/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.speedcode.common.utils.DefaultValueUtil;
import java.util.ArrayList;
import java.util.List;

public class RenderVModelUtil {
    public static String renderDataItemDataOrComputed(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        String finalResult = lcdpComponent.getInstanceKey() + suffix;
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = CodeSuffix._DATA.getType();
        }
        ComponentDataUtil.renderDataItemComputed(lcdpComponent, ctx, suffix, dataItems);
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                break;
            }
            case QUOTE: {
                ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
                lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
                ComponentData data = valueVisitor.getDataItemValue(dataItems);
                if (null != data && ToolUtil.isNotEmpty((Object)data.getRenderValue()) && !data.getRenderValue().equals(ComponentData.EMPTY_DATA.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)data.getDataItemSource())) {
                    finalResult = ComponentDataUtil.dealPrefixThis(data.getRenderValue());
                    break;
                }
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue);
                break;
            }
            case NONE: {
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue);
            }
        }
        return finalResult;
    }

    private static void setNormalData(Ctx ctx, LcdpComponent lcdpComponent, String suffix, String defaultValue) throws LcdpException {
        if (null == defaultValue) {
            defaultValue = "''";
        }
        JSONObject defaultValueAnalysis = (JSONObject)lcdpComponent.getProps().get("defaults");
        boolean isDefaultValue = false;
        if (null != defaultValueAnalysis) {
            isDefaultValue = defaultValueAnalysis.getBooleanValue("isDefaultValue");
        }
        if (isDefaultValue) {
            DefaultValueUtil.renderDefaultValueInput(lcdpComponent, ctx);
        } else {
            ctx.addData(lcdpComponent.getInstanceKey() + suffix + ":" + defaultValue + ",");
        }
    }
}

