/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.common.utils;

import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSConditionListAnalysis;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import java.util.List;

public class QueryAttrUtil {
    public static StringBuilder getQueryAttr(List<DataSConditionListAnalysis> conditionList, Ctx ctx) throws LcdpException {
        StringBuilder queryAttr = new StringBuilder(128);
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
                String attrName = dataSConditionListAnalysis.getQueryAttrName();
                ComponentReference componentReference = dataSConditionListAnalysis.getDataItem();
                ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                String renderGet = null != data ? data.getRenderValue() : "''";
                if ("".equals(attrName)) continue;
                queryAttr.append(attrName).append(": ").append(renderGet).append(",");
            }
        }
        return queryAttr;
    }

    public static StringBuilder getQueryCheck(List<DataSConditionListAnalysis> conditionList, String objName) {
        StringBuilder queryCheck = new StringBuilder(128);
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
                String attrName = dataSConditionListAnalysis.getQueryAttrName();
                ComponentReference componentReference = dataSConditionListAnalysis.getDataItem();
                String dataItemType = componentReference.getType();
                if (DataFromEnum.INPUT.getValue().equals(dataItemType)) continue;
                if (ToolUtil.isNotEmpty((Object)queryCheck.toString())) {
                    queryCheck.append(" && ").append("!").append(objName).append("Obj.").append(attrName);
                    continue;
                }
                queryCheck.append(" !").append(objName).append("Obj.").append(attrName);
            }
        }
        return queryCheck;
    }
}

