/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.common.event;

import com.jxdinfo.hussar.speedcode.codegenerator.core.action.Action;
import com.jxdinfo.hussar.speedcode.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.StateVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="Base.DisabledAction")
public class Disabled
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        String targetId;
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        Map params = action.getParamValues();
        if (null != params && (targetId = (String)params.get("componentSelect")) != null) {
            List<String> idList = Arrays.asList(targetId.split(","));
            for (String id : idList) {
                LcdpComponent toComponent = (LcdpComponent)ctx.getComponentMap().get(id);
                Object componentType = toComponent.getProps().get("componentType");
                if (ToolUtil.isNotEmpty(componentType) && "richTextDisabled".equals(componentType.toString())) {
                    HashMap<String, String> richParams = new HashMap<String, String>();
                    String instanceKey = toComponent.getInstanceKey();
                    richParams.put("instanceKey", instanceKey);
                    String pageName = ctx.getPageName();
                    ctx.addStyle(".lcdp_axe." + pageName + " ." + instanceKey + "{cursor: no-drop;}");
                    ctx.addMethod(triggerName, RenderUtil.renderTemplate((String)"/template/common/event/richTextDisabled.ftl", richParams));
                    break;
                }
                if (!Optional.ofNullable(toComponent).isPresent()) continue;
                StateVisitor stateVisitor = (StateVisitor)toComponent.getProvideVisitor("state");
                stateVisitor.visit(toComponent, ctx, null);
                ctx.addMethod(triggerName, stateVisitor.setDisable());
            }
        }
    }
}

