const verifyInstances = [];
<#list components?values as value>
    verifyInstances.push(${value});
</#list>
let flag = true;
for(let i = 0; i < verifyInstances.length; i++) {
const instance = verifyInstances[i];
<#list checkList! as checkItem >
        <#--正则验证表达式-->
        <#if checkItem.type == "reg">
            const reg${checkItem_index} = ${checkItem.value};
            if ((instance || instance === 0) && !reg${checkItem_index}.test(instance)) {
            self.$message.error('${checkItem.errorMsg}');
            flag = false;
            break;
            }
        <#--必填-->
        <#elseif checkItem.type == "required">
            if (!instance || !/[\S]+/.test(instance)) {
            self.$message.error('${checkItem.errorMsg}');
            flag = false;
            break;
            }
        <#--自定义正则-->
        <#elseif checkItem.type == "customRegular">
            const reg${checkItem_index} = ${checkItem.customValue!};
            if (!reg${checkItem_index}.test(instance)) {
            self.$message.error('${checkItem.errorMsg}');
            flag = false;
            break;
            }
        </#if>
</#list>
}
return flag;