/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.speedcode.common.analysismodel.dataitem.reference.GetValueBO;
import com.jxdinfo.hussar.speedcode.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.MappingUtils;
import com.jxdinfo.hussar.speedcode.constant.dataset.DataTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentDataUtil {
    public static final String PACKAGE_TREE_FIELD_FUNCTION = "packageTreeField";

    public static String getComponentDataRender(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems) throws LcdpException {
        if (ComponentValueStatusEnum.QUOTE.equals((Object)ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems))) {
            QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
            HashMap<String, List<List<String>>> quoteMap = new HashMap<String, List<List<String>>>();
            ArrayList<List<String>> dataItemList = new ArrayList<List<String>>();
            dataItemList.add(dataItems);
            quoteMap.put(lcdpComponent.getInstanceKey(), dataItemList);
            if (ComponentDataUtil.judgeCircleQuote(quoteBO, ctx, quoteMap)) {
                LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(quoteBO.getComponentQuote().getInstanceKey());
                ValueVisitor quoteVisitor = (ValueVisitor)quoteComponent.getProvideVisitor("value");
                quoteComponent.accept((BaseProvideVisitor)quoteVisitor, ctx, null);
                ComponentData quoteData = quoteVisitor.getDataItemValue(quoteBO.getComponentQuote().getInstanceData());
                return quoteData.getRenderValue();
            }
        }
        return CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + suffix;
    }

    public static void renderDataItemComputed(LcdpComponent lcdpComponent, Ctx ctx, String dataSuffix, List<String> dataItems) throws LcdpException {
        ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus) || ComponentValueStatusEnum.GET_VALUE.equals((Object)dataItemValueStatus)) {
            ComponentReference to = ComponentDataUtil.dealCurrDataItem(lcdpComponent, ctx, dataItems, params);
            if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus)) {
                ComponentDataUtil.dealSpecialQuoteRenderParam(lcdpComponent, ctx, dataItems, params, to);
            } else {
                ComponentDataUtil.dealGetValueRenderParam(lcdpComponent, ctx, dataItems, params, to);
            }
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            params.put("getValueData", RenderUtil.renderTemplate((String)"/template/common/dataitem/data_convert_mapping.ftl", params));
            ctx.addComputedWithGetSet(lcdpComponent.getInstanceKey() + dataSuffix, RenderUtil.renderTemplate((String)"/template/common/dataitem/value_computed.ftl", params));
            ComponentDataUtil.renderTreeMethod(lcdpComponent, ctx, params);
        }
    }

    public static void renderTreeMethod(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)params.get("fromDataType")) && ToolUtil.isNotEmpty((Object)params.get("toDataType"))) {
            if (params.get("toDataType").equals(DataTypeEnum.TREE_OBJECT.getValue()) && params.get("fromDataType").equals(DataTypeEnum.TREE_OBJECT.getValue())) {
                List<String> args = Arrays.asList("fromData", "computedRes");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "fromTreeGetValue", args, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_tree.ftl", params));
            }
            if (params.get("toDataType").equals(DataTypeEnum.TREE_OBJECT.getValue()) && params.get("fromDataType").equals(DataTypeEnum.ARRAY_OBJECT.getValue())) {
                List<String> getValueArgs = Collections.singletonList("fromData");
                List<String> getValueChildrenArgs = Arrays.asList("datas", "rootDataArray");
                List mappingList = (List)params.get("mapping");
                String idField = "id";
                String pidField = "pid";
                JSONArray hiddenCols = (JSONArray)lcdpComponent.getProps().get("hidden_cols");
                if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
                    for (Object col : hiddenCols) {
                        JSONObject colObj = (JSONObject)col;
                        if ("jxd-tree-table-fix-id".equals(colObj.getString("id"))) {
                            idField = colObj.getString("field");
                        }
                        if (!"jxd-tree-table-fix-pid".equals(colObj.getString("id"))) continue;
                        pidField = colObj.getString("field");
                    }
                }
                params.put("id", idField);
                if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("root"))) {
                    String root = String.valueOf(lcdpComponent.getProps().get("root"));
                    params.put("root", root);
                }
                if (ToolUtil.isNotEmpty((Object)mappingList)) {
                    String pid = pidField;
                    mappingList.forEach(mapping -> {
                        DataItemMappingBO dataItemMappingBO = (DataItemMappingBO)mapping;
                        if (((String)dataItemMappingBO.getToDataItem()).equals(pid)) {
                            params.put("pid", dataItemMappingBO.getFromDataItem());
                        }
                    });
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "fromArrayGetValue", getValueArgs, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_array.ftl", params));
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "fromArrayGetValueChildren", getValueChildrenArgs, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_array_children.ftl", params));
                }
            }
        }
    }

    private static void dealGetValueRenderParam(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, Map<String, Object> params, ComponentReference to) throws LcdpException {
        ComponentData getValueData;
        GetValueBO getValueBO = ComponentDataUtil.getComponentDataItemGetValue(lcdpComponent, dataItems);
        if (null != getValueBO && null != (getValueData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)getValueBO.getComponentGetData())) && ToolUtil.isNotEmpty((Object)getValueData.getRenderValue())) {
            params.put("getValueData", getValueData.getRenderValue());
            Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, getValueBO.getComponentGetData().getMapping(), getValueBO.getComponentGetData(), to);
            params.putAll(resultMap);
            params.put("fromDataItem", getValueData.getRenderValue());
            params.put("fromDataType", getValueData.getDataType().getValue());
        }
    }

    private static void dealSpecialQuoteRenderParam(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, Map<String, Object> params, ComponentReference to) throws LcdpException {
        ComponentData quoteData;
        QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
        if (null != quoteBO && null != (quoteData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)quoteBO.getComponentQuote())) && ToolUtil.isNotEmpty((Object)quoteData.getRenderValue())) {
            params.put("quoteData", quoteData.getRenderValue());
            ComponentData specialQuoteData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)quoteBO.getSpecialQuote());
            if (null != specialQuoteData && ToolUtil.isNotEmpty((Object)specialQuoteData.getRenderValue())) {
                Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, quoteBO.getSpecialQuote().getMapping(), quoteBO.getSpecialQuote(), to);
                params.putAll(resultMap);
                params.put("fromDataItem", specialQuoteData.getRenderValue());
                params.put("fromDataType", specialQuoteData.getDataType().getValue());
            }
        }
    }

    private static ComponentReference dealCurrDataItem(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, Map<String, Object> params) throws LcdpException {
        ComponentReference to = new ComponentReference(lcdpComponent.getInstanceKey(), dataItems);
        ComponentData toData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
        params.put("toDataItem", "computedRes");
        if (null != toData) {
            params.put("toDataType", toData.getDataType().getValue());
        } else {
            params.put("toDataType", ComponentData.DataTypeEnum.OBJECT.getValue());
        }
        return to;
    }

    private static boolean judgeCircleQuote(QuoteBO quoteBO, Ctx ctx, Map<String, List<List<String>>> quoteMap) throws LcdpException {
        List<List<String>> dataItemList;
        LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(quoteBO.getComponentQuote().getInstanceKey());
        List quoteDataItems = quoteBO.getComponentQuote().getInstanceData();
        boolean keyInMap = quoteMap.containsKey(quoteComponent.getInstanceKey());
        if (keyInMap && ToolUtil.isNotEmpty(dataItemList = quoteMap.get(quoteComponent.getInstanceKey()))) {
            for (List<String> item : dataItemList) {
                if (!item.equals(quoteDataItems)) continue;
                return false;
            }
        }
        if (ComponentValueStatusEnum.QUOTE.equals((Object)ComponentDataUtil.getComponentValueStatus(quoteComponent, ctx, quoteDataItems))) {
            if (keyInMap) {
                quoteMap.get(quoteComponent.getInstanceKey()).add(quoteDataItems);
            } else {
                ArrayList<List> dataItems = new ArrayList<List>();
                dataItems.add(quoteDataItems);
                quoteMap.put(quoteComponent.getInstanceKey(), dataItems);
            }
            QuoteBO nextQuoteBO = ComponentDataUtil.getComponentDataItemQuote(quoteComponent, quoteDataItems);
            return ComponentDataUtil.judgeCircleQuote(nextQuoteBO, ctx, quoteMap);
        }
        return true;
    }

    public static ComponentValueStatusEnum getComponentValueStatus(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) throws LcdpException {
        QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
        GetValueBO getValueBO = ComponentDataUtil.getComponentDataItemGetValue(lcdpComponent, dataItems);
        if (null != quoteBO && ToolUtil.isNotEmpty((Object)quoteBO.getComponentQuote()) && quoteBO.getComponentQuote().isConfigComplete(ctx)) {
            if (ToolUtil.isNotEmpty((Object)quoteBO.getSpecialQuote()) && quoteBO.getSpecialQuote().isConfigComplete(ctx)) {
                return ComponentValueStatusEnum.SPECICAL_QUOTE;
            }
            ComponentData quoteData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)quoteBO.getComponentQuote());
            if (null != quoteData && ToolUtil.isNotEmpty((Object)quoteData.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)quoteData.getDataItemSource())) {
                return ComponentValueStatusEnum.QUOTE;
            }
            return ComponentValueStatusEnum.NONE;
        }
        if (null != getValueBO && ToolUtil.isNotEmpty((Object)getValueBO.getComponentGetData()) && getValueBO.getComponentGetData().isConfigComplete(ctx)) {
            return ComponentValueStatusEnum.GET_VALUE;
        }
        return ComponentValueStatusEnum.NONE;
    }

    private static List<GetValueBO> getComponentGetValue(LcdpComponent lcdpComponent) {
        JSONArray getValues = (JSONArray)lcdpComponent.getProps().get("calculateRefer");
        if (ToolUtil.isNotEmpty((Object)getValues)) {
            return JSON.parseArray((String)getValues.toJSONString(), GetValueBO.class);
        }
        return new ArrayList<GetValueBO>();
    }

    public static GetValueBO getComponentDataItemGetValue(LcdpComponent lcdpComponent, List<String> dataItems) {
        List<GetValueBO> getValueBOS = ComponentDataUtil.getComponentGetValue(lcdpComponent);
        if (ToolUtil.isNotEmpty(getValueBOS)) {
            for (GetValueBO getValueBO : getValueBOS) {
                if (!getValueBO.getCurrentData().equals(dataItems)) continue;
                return getValueBO;
            }
        }
        return null;
    }

    public static QuoteBO getComponentDataItemQuote(LcdpComponent lcdpComponent, List<String> dataItems) {
        List<QuoteBO> quoteBOS = ComponentDataUtil.getComponentQuoteValue(lcdpComponent);
        if (ToolUtil.isNotEmpty(quoteBOS)) {
            for (QuoteBO quoteBO : quoteBOS) {
                if (!quoteBO.getCurrentData().equals(dataItems)) continue;
                return quoteBO;
            }
        }
        return null;
    }

    private static List<QuoteBO> getComponentQuoteValue(LcdpComponent lcdpComponent) {
        JSONArray quotes = (JSONArray)lcdpComponent.getProps().get("reference");
        if (ToolUtil.isNotEmpty((Object)quotes)) {
            return JSON.parseArray((String)quotes.toJSONString(), QuoteBO.class);
        }
        return new ArrayList<QuoteBO>();
    }

    public static String dealPrefixThis(String str) {
        if (ToolUtil.isNotEmpty((Object)str)) {
            if (str.startsWith(CodePrefix._THIS.getType())) {
                str = str.replaceFirst(CodePrefix._THIS.getType(), "");
            }
            if (str.startsWith(CodePrefix._SELF.getType())) {
                str = str.replaceFirst(CodePrefix._SELF.getType(), "");
            }
            if (str.startsWith(CodePrefix._THIS.getType()) || str.startsWith(CodePrefix._SELF.getType())) {
                str = ComponentDataUtil.dealPrefixThis(str);
            }
        }
        return str;
    }

    public static void addPackageTreeFieldMethod(Ctx ctx) {
        if (!ctx.getMethods().containsKey(PACKAGE_TREE_FIELD_FUNCTION)) {
            List<String> args = Arrays.asList("res", "data", "field");
            ctx.addMethod(PACKAGE_TREE_FIELD_FUNCTION, args, "data.forEach((item) => {\nres.push(item[field]);\nif (item.children && item.children.length > 0) {\n" + CodePrefix._SELF.getType() + PACKAGE_TREE_FIELD_FUNCTION + "(res, item.children, field);\n}\n});");
        }
    }

    public static enum ComponentValueStatusEnum {
        NONE,
        GET_VALUE,
        QUOTE,
        SPECICAL_QUOTE;

    }
}

