/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.flow.auth.config.controller;

import com.jxdinfo.hussar.license.HardwareInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.hussar.speedcode.common.util.AppContextUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.flow.auth.config.service.FlowAuthConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowAuth"})
public class FlowAuthConfigController {
    @Autowired
    private FlowAuthConfigService flowAuthConfigService;

    @PostMapping(value={"/getAllAuthConfigs"})
    public Map<String, Object> getAllAuthConfigs(@RequestBody Map<String, String> map) throws LcdpException {
        try {
            List allConfigs = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)map.get("formName")) && ToolUtil.isNotEmpty((Object)map.get("processKey"))) {
                allConfigs = (List)AppContextUtil.computeInAppDs(() -> this.flowAuthConfigService.getAllAuthConfigs((String)map.get("formName"), (String)map.get("processKey"), (String)map.get("formType"), (String)map.get("taskDefinitionKey")));
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", allConfigs);
            return result;
        }
        catch (AppContextUtil.AppDsExecutionTargetException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            if (cause instanceof LcdpException) {
                throw (LcdpException)cause;
            }
            throw e;
        }
    }

    @PostMapping(value={"/saveAuthConfigs"})
    public SpeedCodeResponse<Void> saveAuthConfigs(@RequestBody Map<String, Object> paramMap) throws LcdpException {
        try {
            return (SpeedCodeResponse)AppContextUtil.computeInAppDs(() -> this.flowAuthConfigService.saveAuthConfigs(paramMap));
        }
        catch (AppContextUtil.AppDsExecutionTargetException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            if (cause instanceof LcdpException) {
                throw (LcdpException)cause;
            }
            throw e;
        }
    }

    @PostMapping(value={"/getAllAuthConfigsWithFormId"})
    public Map<String, Object> getAllAuthConfigsByFormId(@RequestBody Map<String, String> map) throws LcdpException {
        try {
            List allConfigs = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)map.get("formId")) && ToolUtil.isNotEmpty((Object)map.get("processKey"))) {
                allConfigs = (List)AppContextUtil.computeInAppDs(() -> this.flowAuthConfigService.getAllAuthConfigsByFormId((String)map.get("formId"), (String)map.get("processKey"), (String)map.get("formType"), (String)map.get("taskDefinitionKey")));
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", allConfigs);
            return result;
        }
        catch (AppContextUtil.AppDsExecutionTargetException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            if (cause instanceof LcdpException) {
                throw (LcdpException)cause;
            }
            throw e;
        }
    }

    @RequestMapping(value={"/isProductionMode"})
    public ApiResponse<?> isProductionMode() {
        return ApiResponse.success((String)String.valueOf(HardwareInfo.getLicenseType()));
    }
}

