/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.basereact.common.analysismodel.formcheck.ElementCheckAnalysis;
import com.jxdinfo.hussar.formdesign.basereact.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.basereact.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.InterActiveVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.model.ComponentReferenceReact;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.util.DataConfigUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobileCheckUtil {
    public static void checkCodeGen(Action action, ReactCtx ctx) throws LcdpException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/commonreact/event/CommonCheck.ftl");
        ReactLcdpComponent myLcdpComponent = action.getCurrentReactLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        String successOperation = "";
        String errorOperation = "";
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis)) {
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
                InterActiveVisitor interActiveVisitor;
                String successInstanceKey = elementCheckAnalysis.getSuccess();
                ReactLcdpComponent successComponent = (ReactLcdpComponent)ctx.getComponentMap().get(successInstanceKey);
                if (ToolUtil.isNotEmpty((Object)successComponent) && ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) {
                    successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                    String unset = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                    String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                    if (ToolUtil.isNotEmpty((Object)unset)) {
                        successOperation = successOperation + unset;
                    }
                    if (ToolUtil.isNotEmpty((Object)set)) {
                        errorOperation = errorOperation + set;
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getError())) {
                ValueVisitor valueVisitor;
                String errorInstanceKey = elementCheckAnalysis.getError();
                ReactLcdpComponent errorComponent = (ReactLcdpComponent)ctx.getComponentMap().get(errorInstanceKey);
                if (ToolUtil.isNotEmpty((Object)errorComponent) && ToolUtil.isNotEmpty((Object)(valueVisitor = (ValueVisitor)errorComponent.getProvideVisitor("value")))) {
                    errorComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
                    String value = valueVisitor.getDataItemValue(null).getRenderValue();
                    value = value.replace(CodePrefix._SELF.getType(), "");
                    if (ToolUtil.isNotEmpty((Object)value)) {
                        successOperation = successOperation + CodePrefix._SELF.getType() + value + " = '';";
                        errorOperation = errorOperation + CodePrefix._SELF.getType() + value + " = errorMsg;";
                    }
                }
            }
        }
        checkMap.put("success", successOperation);
        checkMap.put("error", errorOperation);
        checkMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod((Object[])new String[]{trigger, triggerName, renderResult.getRenderString()});
        }
    }

    public static void checkErrorCodeGen(Action action, ReactCtx ctx) throws LcdpException {
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/commonreact/event/MobileErrorCheck.ftl");
        ReactLcdpComponent myLcdpComponent = action.getCurrentReactLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        Map allParams = action.getParamValues();
        JSONObject params = (JSONObject)allParams.get("inputCheckMsg");
        if (ToolUtil.isEmpty((Object)params)) {
            return;
        }
        ComponentReferenceReact from = (ComponentReferenceReact)JSON.parseObject((String)params.getString("from"), ComponentReferenceReact.class);
        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((ReactCtx)ctx, (ComponentReferenceReact)from);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        checkMap.put("errorMsg", fromComponentData.getRenderValue());
        HashMap<String, String> errorOperation = new HashMap<String, String>();
        List<Object> successInstanceKeys = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            successInstanceKeys = Arrays.asList(successInstanceKey.split(","));
            for (String string : successInstanceKeys) {
                InterActiveVisitor interActiveVisitor;
                ReactLcdpComponent successComponent = (ReactLcdpComponent)ctx.getComponentMap().get(string);
                if (!ToolUtil.isNotEmpty((Object)successComponent) || !ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) continue;
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                if (!ToolUtil.isNotEmpty((Object)set)) continue;
                errorOperation.put(string, set);
            }
        }
        checkMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        HashMap setErrorState = new HashMap();
        for (Map.Entry entry : errorOperation.entrySet()) {
            setErrorState.put(entry.getKey(), entry.getValue());
        }
        checkMap.put("setErrorState", setErrorState);
        ctx.addImports((Object[])new String[]{"Dialog", "vant"});
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod((Object[])new String[]{trigger, triggerName, renderResult.getRenderString()});
        }
    }

    public static void checkSuccessCodeGen(Action action, ReactCtx ctx) throws LcdpException {
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/commonreact/event/MobileSuccessCheck.ftl");
        ReactLcdpComponent myLcdpComponent = action.getCurrentReactLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        HashMap<String, String> successOperation = new HashMap<String, String>();
        List<Object> successInstanceKeys = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            successInstanceKeys = Arrays.asList(successInstanceKey.split(","));
            for (String string : successInstanceKeys) {
                InterActiveVisitor interActiveVisitor;
                ReactLcdpComponent successComponent = (ReactLcdpComponent)ctx.getComponentMap().get(string);
                if (!ToolUtil.isNotEmpty((Object)successComponent) || !ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) continue;
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String unSet = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                if (!ToolUtil.isNotEmpty((Object)unSet)) continue;
                successOperation.put(string, unSet);
            }
        }
        HashMap setErrorState = new HashMap();
        for (Map.Entry entry : successOperation.entrySet()) {
            setErrorState.put(entry.getKey(), entry.getValue());
        }
        checkMap.put("setSuccessState", setErrorState);
        checkMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod((Object[])new String[]{trigger, triggerName, renderResult.getRenderString()});
        }
    }
}

