/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.basereact.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TableFieldUtil {
    private TableFieldUtil() {
    }

    public static String getTableFieldById(String id, List<String> colTypeList, ReactLcdpComponent lcdpComponent) {
        for (String colType : colTypeList) {
            JSONArray colsJSONArray = (JSONArray)lcdpComponent.getProps().get(colType);
            ArrayList<TableOptColsAnalysis> realCols = new ArrayList<TableOptColsAnalysis>();
            if (!ToolUtil.isNotEmpty((Object)colsJSONArray) || !ToolUtil.isNotEmpty((Object)id)) continue;
            List listOptColsAnalyses = JSON.parseArray((String)colsJSONArray.toJSONString(), TableOptColsAnalysis.class);
            TableFieldUtil.getCols(listOptColsAnalyses, realCols);
            for (TableOptColsAnalysis realCol : realCols) {
                if (!id.equals(realCol.getId())) continue;
                return realCol.getField();
            }
        }
        return "";
    }

    public static String getTableFieldTypeByField(String field, List<String> colTypeList, ReactLcdpComponent lcdpComponent) {
        for (String colType : colTypeList) {
            JSONArray colsJSONArray = (JSONArray)lcdpComponent.getProps().get(colType);
            ArrayList<TableOptColsAnalysis> realCols = new ArrayList<TableOptColsAnalysis>();
            if (!ToolUtil.isNotEmpty((Object)colsJSONArray) || !ToolUtil.isNotEmpty((Object)field)) continue;
            List listOptColsAnalyses = JSON.parseArray((String)colsJSONArray.toJSONString(), TableOptColsAnalysis.class);
            TableFieldUtil.getCols(listOptColsAnalyses, realCols);
            for (TableOptColsAnalysis realCol : realCols) {
                if (!field.equals(realCol.getField())) continue;
                return realCol.getDataType();
            }
        }
        return ComponentData.DataTypeEnum.STRING.getValue();
    }

    public static TableOptColsAnalysis getTableFieldInfoById(String id, List<String> colTypeList, ReactLcdpComponent lcdpComponent) {
        for (String colType : colTypeList) {
            JSONArray colsJSONArray = (JSONArray)lcdpComponent.getProps().get(colType);
            ArrayList<TableOptColsAnalysis> realCols = new ArrayList<TableOptColsAnalysis>();
            if (!ToolUtil.isNotEmpty((Object)colsJSONArray) || !ToolUtil.isNotEmpty((Object)id)) continue;
            List listOptColsAnalyses = JSON.parseArray((String)colsJSONArray.toJSONString(), TableOptColsAnalysis.class);
            TableFieldUtil.getCols(listOptColsAnalyses, realCols);
            for (TableOptColsAnalysis realCol : realCols) {
                if (!id.equals(realCol.getField())) continue;
                return realCol;
            }
        }
        return null;
    }

    public static List<TableOptColsAnalysis> getRealAllTableFieldList(List<String> colTypeList, ReactLcdpComponent lcdpComponent) {
        ArrayList<TableOptColsAnalysis> realColReturn = new ArrayList<TableOptColsAnalysis>();
        for (String colType : colTypeList) {
            ArrayList<TableOptColsAnalysis> realCols = new ArrayList<TableOptColsAnalysis>();
            JSONArray colsJSONArray = (JSONArray)lcdpComponent.getProps().get(colType);
            List listOptColsAnalyses = JSON.parseArray((String)colsJSONArray.toJSONString(), TableOptColsAnalysis.class);
            TableFieldUtil.getCols(listOptColsAnalyses, realCols);
            realColReturn.addAll(realCols);
        }
        return realColReturn;
    }

    private static void getCols(List<TableOptColsAnalysis> listOptColsAnalyses, List<TableOptColsAnalysis> realCols) {
        for (TableOptColsAnalysis tableColsAnalysis : listOptColsAnalyses) {
            boolean isNotEmptyCol = ToolUtil.isNotEmpty((Object)tableColsAnalysis);
            boolean isNotEmptyChildren = ToolUtil.isNotEmpty(tableColsAnalysis.getChildren());
            if (!isNotEmptyCol) continue;
            if (isNotEmptyChildren) {
                List<TableOptColsAnalysis> childrenCols = tableColsAnalysis.getChildren();
                TableFieldUtil.getCols(childrenCols, realCols);
                continue;
            }
            realCols.add(tableColsAnalysis);
        }
    }

    public static JSONArray getRealAllTableFieldArray(List<String> colTypeList, ReactLcdpComponent lcdpComponent) {
        JSONArray allCols = new JSONArray();
        for (String colType : colTypeList) {
            JSONArray cols = (JSONArray)lcdpComponent.getProps().get(colType);
            allCols.addAll((Collection)TableFieldUtil.getAllCols(cols));
        }
        return allCols;
    }

    public static JSONArray getAllCols(JSONArray cols) {
        JSONArray allColumns = new JSONArray();
        for (Object col : cols) {
            JSONObject colObj = (JSONObject)col;
            if (Boolean.TRUE.equals(colObj.getBoolean("isParent"))) {
                JSONArray allChildCols = TableFieldUtil.getAllCols(colObj.getJSONArray("children"));
                for (Object childCol : allChildCols) {
                    JSONObject childColObj = (JSONObject)childCol;
                    allColumns.add((Object)childColObj);
                }
                continue;
            }
            allColumns.add((Object)colObj);
        }
        return allColumns;
    }

    public static Integer getMaxRowSpan(JSONArray optCols) {
        Integer maxRowspan = 1;
        for (int i = 0; i < optCols.size(); ++i) {
            JSONObject optCol = (JSONObject)optCols.get(i);
            if (ToolUtil.isEmpty((Object)optCol.get((Object)"rowspan"))) continue;
            Integer rowSpan = Integer.parseInt(optCol.get((Object)"rowspan").toString());
            maxRowspan = Integer.max(rowSpan, maxRowspan);
        }
        return maxRowspan;
    }
}

