/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.utils;

import com.jxdinfo.hussar.formdesign.basereact.common.analysismodel.datas.DataSConditionListAnalysis;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.model.ComponentReferenceReact;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.util.DataConfigUtil;
import java.util.List;

public class QueryAttrUtil {
    public static StringBuilder getQueryAttr(List<DataSConditionListAnalysis> conditionList, ReactCtx ctx) throws LcdpException {
        StringBuilder queryAttr = new StringBuilder(128);
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
                String attrName = dataSConditionListAnalysis.getQueryAttrName();
                ComponentReferenceReact componentReference = dataSConditionListAnalysis.getDataItem();
                ComponentData data = DataConfigUtil.getDataConfigValue((ReactCtx)ctx, (ComponentReferenceReact)componentReference);
                String renderGet = null != data ? data.getRenderValue() : "''";
                if ("".equals(attrName)) continue;
                queryAttr.append(attrName).append(": ").append(renderGet).append(",");
            }
        }
        return queryAttr;
    }

    public static StringBuilder getQueryCheck(List<DataSConditionListAnalysis> conditionList, String objName) {
        StringBuilder queryCheck = new StringBuilder(128);
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
                String attrName = dataSConditionListAnalysis.getQueryAttrName();
                ComponentReferenceReact componentReference = dataSConditionListAnalysis.getDataItem();
                String dataItemType = componentReference.getType();
                if (DataFromEnum.INPUT.getValue().equals(dataItemType)) continue;
                if (ToolUtil.isNotEmpty((Object)queryCheck.toString())) {
                    queryCheck.append(" && ").append("!").append(objName).append("Obj.").append(attrName);
                    continue;
                }
                queryCheck.append(" !").append(objName).append("Obj.").append(attrName);
            }
        }
        return queryCheck;
    }
}

