/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.utils;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public class MultilineExegesisUtil {
    private MultilineExegesisUtil() {
    }

    public static void handleExegesisText(ReactLcdpComponent lcdpComponent, String exegesisPropName, String renderParam) {
        String exegesis = lcdpComponent.getProps().getOrDefault(exegesisPropName, "").toString();
        if (HussarUtils.isEmpty((Object)exegesis)) {
            exegesis = lcdpComponent.getAlias();
        }
        if (HussarUtils.isNotEmpty((Object)exegesis)) {
            String[] exegesisList = exegesis.split("\n");
            StringBuilder exegesisResult = new StringBuilder();
            for (String exegesisItem : exegesisList) {
                exegesisResult.append("<!--").append(exegesisItem).append("-->\r\n");
            }
            lcdpComponent.addRenderParam(renderParam, (Object)exegesisResult.toString());
        }
    }

    public static String handleActionExegesisText(Action action) {
        String exegesis = action.getExegesis();
        String label = action.getLabel();
        StringBuilder exegesisResult = new StringBuilder();
        if (HussarUtils.isNotEmpty((Object)exegesis)) {
            String[] exegesisList = exegesis.split("\n");
            if (exegesisList.length == 1) {
                exegesisResult.append("// ").append(exegesisList[0]).append("\r\n");
            } else {
                exegesisResult.append("/**\r\n");
                for (String exegesisItem : exegesisList) {
                    exegesisResult.append("* ").append(exegesisItem).append("\r\n");
                }
                exegesisResult.append("*/\r\n");
            }
        }
        return HussarUtils.isNotEmpty((Object)exegesisResult) ? exegesisResult.toString() : "// " + label + "\r\n";
    }

    public static String dealDataExegesis(ReactLcdpComponent lcdpComponent, String suffix) {
        StringBuilder exegesisResult = new StringBuilder();
        exegesisResult.append(lcdpComponent == null ? "" : lcdpComponent.getAlias()).append("\u7684");
        if (HussarUtils.isEmpty((Object)suffix)) {
            exegesisResult.append("\u5c5e\u6027");
        } else {
            exegesisResult.append(suffix);
        }
        return exegesisResult.toString();
    }

    public static String dealDataExegesis(String alias, String suffix) {
        StringBuilder exegesisResult = new StringBuilder();
        exegesisResult.append(alias).append("\u7684");
        if (HussarUtils.isEmpty((Object)suffix)) {
            exegesisResult.append("\u5c5e\u6027");
        } else {
            exegesisResult.append(suffix);
        }
        return exegesisResult.toString();
    }

    public static String dealComputedExegesis(ReactLcdpComponent lcdpComponent) {
        StringBuilder exegesisResult = new StringBuilder();
        exegesisResult.append(lcdpComponent.getAlias()).append("\u7684\u53d6\u503c");
        return exegesisResult.toString();
    }

    public static String dealWatchExegesis(ReactLcdpComponent lcdpComponent) {
        StringBuilder exegesisResult = new StringBuilder();
        exegesisResult.append(lcdpComponent.getAlias()).append("\u7684\u76d1\u542c");
        return exegesisResult.toString();
    }

    public static String dealFilterExegesis(ReactLcdpComponent lcdpComponent) {
        StringBuilder exegesisResult = new StringBuilder();
        exegesisResult.append(lcdpComponent.getAlias()).append("\u7684\u8fc7\u6ee4\u5668");
        return exegesisResult.toString();
    }

    public static String dealMethodExegesis(ReactLcdpComponent lcdpComponent, String suffix) {
        StringBuilder exegesisResult = new StringBuilder();
        exegesisResult.append(lcdpComponent.getAlias()).append("\u7684").append(suffix);
        return exegesisResult.toString();
    }
}

