/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.DataReturnValue;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.mapping.DataItemBO;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.model.ComponentReferenceReact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MappingUtils {
    private static final String MAPPING_KEY = "mapping";

    private static Map<String, Object> mapping(Map<String, String> fromColDataItemMap, Map<String, String> toColDataItemMap, List<? extends DataItemMappingBO> mappingList) {
        HashMap<String, Object> mappingMap = new HashMap<String, Object>(8);
        ArrayList list = new ArrayList();
        mappingList.forEach(mappingItem -> {
            String fromDataItemId = (String)mappingItem.getFromDataItem();
            String fromMappingField = (String)fromColDataItemMap.get(fromDataItemId);
            DataItemBO fromColDataItem = new DataItemBO(fromDataItemId, fromMappingField);
            String toDataItemId = (String)mappingItem.getToDataItem();
            String toMappingField = (String)toColDataItemMap.get(toDataItemId);
            DataItemBO toColDataItem = new DataItemBO(toDataItemId, toMappingField);
            if (ToolUtil.isNotEmpty((Object)fromMappingField) || ToolUtil.isNotEmpty((Object)toMappingField)) {
                DataItemMappingBO mappingStore = new DataItemMappingBO((Object)fromColDataItem, (Object)toColDataItem);
                list.add(mappingStore);
            }
        });
        mappingMap.put(MAPPING_KEY, list);
        return mappingMap;
    }

    private static Map<String, Object> mapping(Map<String, String> toColDataItemMap, List<? extends DataItemMappingBO> mappingList) {
        HashMap<String, Object> mappingMap = new HashMap<String, Object>(8);
        ArrayList list = new ArrayList();
        mappingList.forEach(mappingItem -> {
            String fromMappingField = (String)mappingItem.getFromDataItem();
            DataItemBO fromColDataItem = new DataItemBO(fromMappingField, fromMappingField);
            String toDataItemId = (String)mappingItem.getToDataItem();
            String toMappingField = (String)toColDataItemMap.get(toDataItemId);
            DataItemBO toColDataItem = new DataItemBO(toDataItemId, toMappingField);
            if (ToolUtil.isNotEmpty((Object)fromMappingField) || ToolUtil.isNotEmpty((Object)toMappingField)) {
                DataItemMappingBO mappingStore = new DataItemMappingBO((Object)fromColDataItem, (Object)toColDataItem);
                list.add(mappingStore);
            }
        });
        mappingMap.put(MAPPING_KEY, list);
        return mappingMap;
    }

    private static Map<String, Object> mapping(ReactCtx ctx, ComponentReferenceReact from, ComponentReferenceReact to, List<? extends DataItemMappingBO> mappingList, Map<String, Object> mappingMap) throws LcdpException {
        Map<String, String> fromFieldMapping = MappingUtils.getFieldMapping(from, ctx);
        Map<String, String> toFieldMapping = MappingUtils.getFieldMapping(to, ctx);
        List<DataItemMappingBO<String>> mappingBOS = MappingUtils.getDataItemMappingBOS(mappingList, fromFieldMapping, toFieldMapping);
        mappingMap.put(MAPPING_KEY, mappingBOS);
        return mappingMap;
    }

    public static List<DataItemMappingBO<String>> getDataItemMappingBOS(List<? extends DataItemMappingBO> mappingList, Map<String, String> fromFieldMapping, Map<String, String> toFieldMapping) {
        ArrayList<DataItemMappingBO<String>> mappingBOS = new ArrayList<DataItemMappingBO<String>>();
        mappingList.forEach(mappingItem -> {
            if (ToolUtil.isNotEmpty((Object)mappingItem.getFromDataItem()) && ToolUtil.isNotEmpty((Object)mappingItem.getToDataItem())) {
                mappingBOS.add(MappingUtils.dealMappingItem(fromFieldMapping, toFieldMapping, mappingItem));
            }
        });
        return mappingBOS;
    }

    private static DataItemMappingBO<String> dealMappingItem(Map<String, String> fromFieldMapping, Map<String, String> toFieldMapping, DataItemMappingBO mappingItem) {
        DataItemMappingBO mapping = new DataItemMappingBO();
        if (ToolUtil.isNotEmpty(fromFieldMapping) && fromFieldMapping.containsKey(mappingItem.getFromDataItem().toString())) {
            mapping.setFromDataItem((Object)fromFieldMapping.get(mappingItem.getFromDataItem().toString()));
        } else {
            mapping.setFromDataItem((Object)mappingItem.getFromDataItem().toString());
        }
        if (ToolUtil.isNotEmpty(toFieldMapping) && toFieldMapping.containsKey(mappingItem.getToDataItem().toString())) {
            mapping.setToDataItem((Object)toFieldMapping.get(mappingItem.getToDataItem().toString()));
        } else {
            mapping.setToDataItem((Object)mappingItem.getToDataItem().toString());
        }
        return mapping;
    }

    public static Map<String, Object> getMappingResult(ReactCtx ctx, List<? extends DataItemMappingBO> mapsList, ComponentReferenceReact from, ComponentReferenceReact to) throws LcdpException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if (!from.isConfigComplete(ctx) || !to.isConfigComplete(ctx)) {
            return resultMap;
        }
        resultMap.put("type", "simple");
        if (ToolUtil.isNotEmpty(mapsList)) {
            MappingUtils.mapping(ctx, from, to, mapsList, resultMap);
            if (ToolUtil.isNotEmpty(resultMap.get(MAPPING_KEY))) {
                resultMap.put("type", "complex");
            }
        }
        return resultMap;
    }

    public static Map<String, String> getFieldMapping(ComponentReferenceReact reference, ReactCtx ctx) throws LcdpException {
        JSONObject data = reference.getData();
        if (DataFromEnum.RETURN_VALUE.getValue().equals(reference.getType())) {
            String returnValueAction = data.getString("actionId");
            Action targetAction = (Action)ctx.getActionMap().get(returnValueAction);
            ActionProvideVisitor actionProvideVisitor = targetAction.actionProvideVisitor(targetAction.getActionQualifiedName());
            targetAction.accept(actionProvideVisitor, ctx, null);
            return actionProvideVisitor.getDataMapping((DataReturnValue)JSON.parseObject((String)reference.getData().getString("dataItemGet"), DataReturnValue.class));
        }
        ReactLcdpComponent lcdpComponent = (ReactLcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
        if (null == lcdpComponent) {
            return new HashMap<String, String>(16);
        }
        ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
        lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
        return valueVisitor.getComponentColMapping();
    }
}

