/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.basereact.common.analysismodel.defaultvalue.DefaultValueAnalysis;
import com.jxdinfo.hussar.formdesign.basereact.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.properties.DataTypeProperties;
import com.jxdinfo.hussar.formdesign.common.properties.EnvVarsProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaInfo;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.model.ComponentReferenceReact;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.util.ExtendFormulaUtil;
import java.util.Map;

public class DefaultValueUtil {
    private static final DataTypeProperties dataTypeProperties = (DataTypeProperties)SpringUtil.getBean(DataTypeProperties.class);
    private static final EnvVarsProperties envVarsProperties = (EnvVarsProperties)SpringUtil.getBean(EnvVarsProperties.class);

    public static String renderDefaultValue(DefaultValueAnalysis defaultValueAnalysis, String dataType, ReactCtx ctx) throws LcdpException {
        ComponentReferenceReact from;
        ComponentData dataConfigValue;
        String result = "''";
        if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && defaultValueAnalysis.isDefaultValue() && ToolUtil.isNotEmpty((Object)(dataConfigValue = DataConfigUtil.getDataConfigValue((ReactCtx)ctx, (ComponentReferenceReact)(from = defaultValueAnalysis.getFrom()))))) {
            return dataConfigValue.getRenderValue();
        }
        return result;
    }

    public static void renderDefaultValueInput(ReactLcdpComponent lcdpComponent, ReactCtx ctx, String suffix, JSONObject defaultValueAnalysis) throws LcdpException {
        boolean isDefaultValue;
        Object result = "''";
        if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && (isDefaultValue = ((Boolean)defaultValueAnalysis.get((Object)"isDefaultValue")).booleanValue())) {
            String defaultValueType = (String)defaultValueAnalysis.get((Object)"defaultValueType");
            String defaultValue = defaultValueAnalysis.get((Object)"value").toString();
            if (ToolUtil.isNotEmpty((Object)defaultValueType)) {
                if (DataFromEnum.INPUT.getValue().equals(defaultValueType)) {
                    result = "com.jxdinfo.elementuireact.JXDElCheckBox".equals(lcdpComponent.getName()) && ("true".equals(defaultValue) || "false".equals(defaultValue)) ? Boolean.valueOf(Boolean.parseBoolean(defaultValue)) : "'" + defaultValue + "'";
                } else if (DataFromEnum.SESSION.getValue().equals(defaultValueType)) {
                    Map sessionConfig = envVarsProperties.getSession();
                    ComponentReferenceReact componentReference = (ComponentReferenceReact)JSON.parseObject((String)defaultValue, ComponentReferenceReact.class);
                    String configData = componentReference.getConfigData();
                    String item = ToolUtil.isNotEmpty((Object)configData) ? (String)sessionConfig.get(configData) : (String)sessionConfig.get(defaultValue);
                    if (ToolUtil.isNotEmpty((Object)item)) {
                        result = "caching.session.get(" + item + ")";
                        ctx.addImports((Object[])new String[]{"caching", "hussar-base"});
                    }
                } else if (DataFromEnum.SYSTEM.getValue().equals(defaultValueType)) {
                    if (DataFromEnum.YEAR.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'year')";
                    } else if (DataFromEnum.MONTH.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'month')";
                    } else if (DataFromEnum.DATE.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'date')";
                    } else if (DataFromEnum.TIME.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'time')";
                    } else if (DataFromEnum.DATETIME.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'datetime')";
                    }
                    ctx.addImports((Object[])new String[]{"dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil"});
                    if (!ctx.getMethods(new Object[0]).containsKey("format")) {
                        ctx.addImports((Object[])new String[]{"dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil"});
                    }
                } else if (DataFromEnum.EXTEND_FORMULA.getValue().equals(defaultValueType)) {
                    ExtendFormulaInfo formulaInfo = (ExtendFormulaInfo)JSON.parseObject((String)defaultValue, ExtendFormulaInfo.class);
                    try {
                        ExtendFormulaCompileInfo compileInfo = ExtendFormulaUtil.getFormulaCompile((ExtendFormulaInfo)formulaInfo, (ReactCtx)ctx);
                        if (ToolUtil.isNotEmpty((Object)compileInfo)) {
                            result = compileInfo.getFormulaStr();
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                } else if (DataFromEnum.CONSTANT.getValue().equals(defaultValueType) || DataFromEnum.PAGE_PARAM.getValue().equals(defaultValueType)) {
                    ComponentReferenceReact componentReference = (ComponentReferenceReact)JSON.parseObject((String)defaultValue, ComponentReferenceReact.class);
                    ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((ReactCtx)ctx, (ComponentReferenceReact)componentReference);
                    result = dataConfigValue.getRenderValue();
                }
            }
        }
        ctx.addData((Object[])new String[]{lcdpComponent.getInstanceKey() + suffix + ": " + result, MultilineExegesisUtil.dealDataExegesis(lcdpComponent, "data\u53d8\u91cf")});
    }
}

