/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.basereact.common.analysismodel.formcheck.ElementCheckAnalysis;
import com.jxdinfo.hussar.formdesign.basereact.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.basereact.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.InterActiveVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.model.ComponentReferenceReact;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.util.ExtendCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElementCheckUtil {
    public static void checkCodeGen(Action action, ReactCtx ctx) throws LcdpException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/commonreact/event/CommonCheck.ftl");
        ReactLcdpComponent myLcdpComponent = action.getCurrentReactLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        String successOperation = "";
        String errorOperation = "";
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis)) {
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
                InterActiveVisitor interActiveVisitor;
                String successInstanceKey = elementCheckAnalysis.getSuccess();
                ReactLcdpComponent successComponent = (ReactLcdpComponent)ctx.getComponentMap().get(successInstanceKey);
                if (ToolUtil.isNotEmpty((Object)successComponent) && ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) {
                    successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                    String unset = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                    String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                    if (ToolUtil.isNotEmpty((Object)unset)) {
                        successOperation = successOperation + unset;
                    }
                    if (ToolUtil.isNotEmpty((Object)set)) {
                        errorOperation = errorOperation + set;
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getError())) {
                ValueVisitor valueVisitor;
                String errorInstanceKey = elementCheckAnalysis.getError();
                ReactLcdpComponent errorComponent = (ReactLcdpComponent)ctx.getComponentMap().get(errorInstanceKey);
                if (ToolUtil.isNotEmpty((Object)errorComponent) && ToolUtil.isNotEmpty((Object)(valueVisitor = (ValueVisitor)errorComponent.getProvideVisitor("value")))) {
                    errorComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
                    String value = valueVisitor.getDataItemValue(null).getRenderValue();
                    value = value.replace(CodePrefix._SELF.getType(), "");
                    if (ToolUtil.isNotEmpty((Object)value)) {
                        successOperation = successOperation + CodePrefix._SELF.getType() + value + " = '';";
                        errorOperation = errorOperation + CodePrefix._SELF.getType() + value + " = errorMsg;";
                    }
                }
            }
        }
        checkMap.put("success", successOperation);
        checkMap.put("error", errorOperation);
        checkMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod((Object[])new String[]{trigger, triggerName, renderResult.getRenderString()});
        }
    }

    public static void checkErrorCodeGen(Action action, ReactCtx ctx) throws LcdpException {
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/commonreact/event/ErrorCheck.ftl");
        ReactLcdpComponent myLcdpComponent = action.getCurrentReactLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        Map allParams = action.getParamValues();
        JSONObject params = (JSONObject)allParams.get("inputCheckMsg");
        if (ToolUtil.isEmpty((Object)params)) {
            return;
        }
        ComponentReferenceReact from = (ComponentReferenceReact)JSON.parseObject((String)params.getString("from"), ComponentReferenceReact.class);
        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((ReactCtx)ctx, (ComponentReferenceReact)from);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        if (ElementCheckUtil.isComponentDataEmpty(fromComponentData).booleanValue()) {
            checkMap.put("errorMsg", fromComponentData.getRenderValue());
        }
        HashMap<Object, String> errorOperation = new HashMap<Object, String>();
        List<Object> successInstanceKeys = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            successInstanceKeys = Arrays.asList(successInstanceKey.split(","));
            for (int i = 0; i < successInstanceKeys.size(); ++i) {
                InterActiveVisitor interActiveVisitor;
                ReactLcdpComponent successComponent = (ReactLcdpComponent)ctx.getComponentMap().get(successInstanceKeys.get(i));
                if (!ToolUtil.isNotEmpty((Object)successComponent) || !ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) continue;
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                if (!ToolUtil.isNotEmpty((Object)set)) continue;
                errorOperation.put(successInstanceKeys.get(i), set);
            }
        }
        ctx.addImports((Object[])new String[]{"validate", "hussar-base"});
        for (Map.Entry entry : errorOperation.entrySet()) {
            String styleId = "";
            String cssPrefix = "";
            styleId = styleId + ctx.getPageName() + "_" + (String)entry.getKey();
            cssPrefix = cssPrefix + "." + ctx.getPageName() + " ." + (String)entry.getKey();
            ctx.addDestroyeds((Object[])new String[]{"validate.removeLink('" + styleId + "');"});
            checkMap.put("styleId", styleId);
            checkMap.put("cssPrefix", cssPrefix);
            checkMap.put("setErrorState", entry.getValue());
            checkMap.put("checkKey", entry.getKey());
            checkMap.put("onlyInfo", action.getActionQualifiedName().equals("Base.SetErrorInfoAction"));
            checkMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
            renderCore.registerParam(checkMap);
            RenderResult renderResult = renderCore.render();
            if (!renderResult.isStatus()) continue;
            ctx.addMethod((Object[])new String[]{trigger, triggerName, renderResult.getRenderString()});
        }
    }

    public static void checkSuccessCodeGen(Action action, ReactCtx ctx) throws LcdpException {
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/commonreact/event/SuccessCheck.ftl");
        ReactLcdpComponent myLcdpComponent = action.getCurrentReactLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        HashMap<Object, String> successOperation = new HashMap<Object, String>();
        List<Object> successInstanceKeys = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            successInstanceKeys = Arrays.asList(successInstanceKey.split(","));
            for (int i = 0; i < successInstanceKeys.size(); ++i) {
                InterActiveVisitor interActiveVisitor;
                ReactLcdpComponent successComponent = (ReactLcdpComponent)ctx.getComponentMap().get(successInstanceKeys.get(i));
                if (!ToolUtil.isNotEmpty((Object)successComponent) || !ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) continue;
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String unSet = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                if (!ToolUtil.isNotEmpty((Object)unSet)) continue;
                successOperation.put(successInstanceKeys.get(i), unSet);
            }
        }
        for (Map.Entry entry : successOperation.entrySet()) {
            String styleId = "";
            styleId = styleId + ctx.getPageName() + "_" + (String)entry.getKey();
            checkMap.put("styleId", styleId);
            checkMap.put("setSuccessState", entry.getValue());
            checkMap.put("onlyInfo", action.getActionQualifiedName().equals("Base.UnsetErrorInfoAction"));
            checkMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
            renderCore.registerParam(checkMap);
            RenderResult renderResult = renderCore.render();
            if (!renderResult.isStatus()) continue;
            ctx.addMethod((Object[])new String[]{trigger, triggerName, renderResult.getRenderString()});
        }
    }

    public static List<Map<String, Object>> dealCustomFunction(List<Map<String, Object>> customFunction, ReactCtx ctx) throws LcdpException {
        ArrayList<Map<String, Object>> customFuncConfig = new ArrayList<Map<String, Object>>();
        if (ToolUtil.isNotEmpty(customFunction)) {
            for (Map<String, Object> objectMap : customFunction) {
                HashMap<String, Object> customFuncConfigMap = new HashMap<String, Object>();
                customFuncConfigMap.put("functionName", objectMap.get("functionName"));
                customFuncConfigMap.put("fileIdentify", objectMap.get("fileIdentify"));
                List paramList = (List)objectMap.get("params");
                ArrayList<String> paramName = new ArrayList<String>();
                if (ToolUtil.isNotEmpty((Object)paramList)) {
                    for (Map stringObjectMap : paramList) {
                        ComponentReferenceReact componentReference = (ComponentReferenceReact)JSON.parseObject((String)stringObjectMap.toString(), ComponentReferenceReact.class);
                        ComponentData paramData = DataConfigUtil.getDataConfigValue((ReactCtx)ctx, (ComponentReferenceReact)componentReference);
                        if (null != paramData) {
                            paramName.add(paramData.getRenderValue());
                            continue;
                        }
                        paramName.add("''");
                    }
                }
                customFuncConfigMap.put("paramName", paramName);
                customFuncConfig.add(customFuncConfigMap);
                if (objectMap.get("id") == null || objectMap.get("fileIdentify") == null) continue;
                ExtendCommonUtil.addExtendJsImport((ReactCtx)ctx, (String)objectMap.get("id").toString(), (String)objectMap.get("fileIdentify").toString());
            }
        }
        return customFuncConfig;
    }

    private static Boolean isComponentDataEmpty(ComponentData componentData) {
        Boolean isOk = true;
        if (ToolUtil.isNotEmpty((Object)componentData)) {
            if ("".equals(componentData.getRenderValue())) {
                isOk = false;
            }
            if (ToolUtil.isEmpty((Object)componentData.getDataType()) || "".equals(componentData.getDataType().getValue())) {
                isOk = false;
            }
        } else {
            isOk = false;
        }
        return isOk;
    }
}

