/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.basereact.common.event.apiInvoke;

import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModel;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModelOperation;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiRequestMethod;
import com.jxdinfo.hussar.formdesign.basereact.common.event.apiInvoke.model.ApiActionModelReact;
import com.jxdinfo.hussar.formdesign.basereact.common.event.apiInvoke.model.ApiParamModelReact;
import com.jxdinfo.hussar.formdesign.basereact.common.event.apiInvoke.templateParam.ApiBaseTypeParam;
import com.jxdinfo.hussar.formdesign.basereact.common.event.apiInvoke.templateParam.ApiBodyTypeParam;
import com.jxdinfo.hussar.formdesign.basereact.common.event.apiInvoke.templateParam.ApiRequestParam;
import com.jxdinfo.hussar.formdesign.basereact.common.event.apiInvoke.templateParam.WebTemplateParam;
import com.jxdinfo.hussar.formdesign.basereact.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.data.model.ComponentReferenceReact;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiInvoke {
    private ApiActionModelReact action;
    private ApiDataModel apiDataModel;
    private ReactCtx ctx;

    public ApiInvoke(ReactCtx ctx, ApiDataModel apiDataModel, ApiActionModelReact action) {
        this.action = action;
        this.apiDataModel = apiDataModel;
        this.ctx = ctx;
    }

    public WebTemplateParam buildWebParam() throws LcdpException {
        ApiRequestParam apiRequestParam;
        ApiDataModelOperation operation = this.apiDataModel.getOperationById(this.action.getOperationId());
        if (operation != null && operation.getRequestMode().equals((Object)ApiRequestMethod.GET)) {
            apiRequestParam = this.build(this.apiDataModel.getId2NameOfQuery(this.action.getOperationId()));
        } else if (operation != null && operation.getRequestMode().equals((Object)ApiRequestMethod.POST)) {
            apiRequestParam = this.build(this.apiDataModel.getId2NameOfBody(this.action.getOperationId()));
        } else {
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u4e0d\u652f\u6301GET\u3001POST\u4ee5\u5916\u7684\u65b9\u5f0f");
        }
        return new WebTemplateParam(this.apiDataModel.getName(), operation.getName(), apiRequestParam, "");
    }

    private ApiRequestParam build(Map<String, ApiDataModel.DatasetIdName> datasetId2Name) throws LcdpException {
        List<ApiParamModelReact> paramConfigs = this.action.getParamConfigs();
        ApiRequestParam apiRequestParam = new ApiRequestParam(this.action.getName());
        for (ApiParamModelReact paramConfig : paramConfigs) {
            if (!datasetId2Name.containsKey(paramConfig.getCurrentData())) continue;
            if (datasetId2Name.get(paramConfig.getCurrentData()).getFromBody()) {
                ApiBodyTypeParam bodyParam = this.bodyObjectTypeHandle(datasetId2Name, paramConfig);
                apiRequestParam.setBodyParam(bodyParam);
                continue;
            }
            ApiBaseTypeParam apiBaseTypeParam = this.baseTypeHandle(datasetId2Name, paramConfig);
            apiRequestParam.getApiBaseTypeParams().add(apiBaseTypeParam);
        }
        return apiRequestParam;
    }

    private ApiBodyTypeParam bodyObjectTypeHandle(Map<String, ApiDataModel.DatasetIdName> datasetId2Name, ApiParamModelReact paramConfig) throws LcdpException {
        ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((ReactCtx)this.ctx, (ComponentReferenceReact)paramConfig.getComponentReference());
        if (dataConfigValue == null) {
            dataConfigValue = new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.READONLY, "''");
        }
        ApiBodyTypeParam apiObjectTypeParam = new ApiBodyTypeParam();
        apiObjectTypeParam.setJsVariable(dataConfigValue.getRenderValue());
        apiObjectTypeParam.setParentDataSetNames("");
        apiObjectTypeParam.setDatasetType(paramConfig.getCurrentDataType());
        apiObjectTypeParam.setApiBaseTypeParams(new ArrayList<ApiBaseTypeParam>());
        if (paramConfig.getMapping().size() > 0) {
            Map<String, String> componentId2JsVariable = MappingUtils.getFieldMapping(paramConfig.getComponentReference(), this.ctx);
            List<DataItemMappingBO<String>> componentId2DatasetId = paramConfig.getMapping();
            List<DataItemMappingBO<String>> jsVariable2DatasetNameList = MappingUtils.getDataItemMappingBOS(componentId2DatasetId, componentId2JsVariable, this.datasetId2NameTransfer(datasetId2Name));
            jsVariable2DatasetNameList.forEach(jsVariable2DatasetName -> apiObjectTypeParam.getApiBaseTypeParams().add(new ApiBaseTypeParam((String)jsVariable2DatasetName.getToDataItem(), (String)jsVariable2DatasetName.getFromDataItem())));
        }
        return apiObjectTypeParam;
    }

    private Map<String, String> datasetId2NameTransfer(Map<String, ApiDataModel.DatasetIdName> datasetId2Name) {
        if (CollectionUtil.isEmpty(datasetId2Name)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        datasetId2Name.entrySet().forEach(entry -> res.put((String)entry.getKey(), ((ApiDataModel.DatasetIdName)entry.getValue()).getName()));
        return res;
    }

    private ApiBaseTypeParam baseTypeHandle(Map<String, ApiDataModel.DatasetIdName> datasetId2Name, ApiParamModelReact paramConfig) throws LcdpException {
        ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((ReactCtx)this.ctx, (ComponentReferenceReact)paramConfig.getComponentReference());
        if (dataConfigValue == null) {
            dataConfigValue = new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.READONLY, "''");
        }
        ApiBaseTypeParam apiBaseTypeParam = new ApiBaseTypeParam();
        apiBaseTypeParam.setDataSetName(datasetId2Name.get(paramConfig.getCurrentData()).getName());
        apiBaseTypeParam.setJsVariable(dataConfigValue.getRenderValue());
        return apiBaseTypeParam;
    }
}

