/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.back.common.util;

import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.mysql.cj.MysqlType;
import java.sql.JDBCType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import oracle.jdbc.OracleType;

public class EngineColumnTypeUtil {
    private static final List<EngineColumnType> engineColumnTypes = new ArrayList<EngineColumnType>();

    public static Optional<EngineColumnType> getEngineColumnType(String dataType) {
        return engineColumnTypes.stream().filter(x -> x.getDataType().equalsIgnoreCase(dataType)).findFirst();
    }

    static {
        engineColumnTypes.add(new EngineColumnType(JDBCType.INTEGER, MysqlType.INT, OracleType.NUMBER, Integer.class.getName(), "int"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.VARCHAR, MysqlType.VARCHAR, OracleType.VARCHAR2, String.class.getName(), "string"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.VARCHAR, MysqlType.VARCHAR, OracleType.VARCHAR2, String.class.getName(), "arrayPrimary"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.VARCHAR, MysqlType.VARCHAR, OracleType.VARCHAR2, String.class.getName(), "treeObject"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.DOUBLE, MysqlType.DOUBLE, OracleType.NUMBER, Double.class.getName(), "double"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.TIMESTAMP, MysqlType.DATETIME, OracleType.TIMESTAMP, LocalDateTime.class.getName(), "date"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.TINYINT, MysqlType.TINYINT, OracleType.CHAR, Boolean.class.getName(), "boolean"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.BIGINT, MysqlType.BIGINT, OracleType.LONG, Long.class.getName(), "long"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.LONGNVARCHAR, MysqlType.TEXT, OracleType.CLOB, String.class.getName(), "text"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.LONGNVARCHAR, MysqlType.TEXT, OracleType.CLOB, String.class.getName(), "array"));
    }
}

