/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.back.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.service.DataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.service.ModelInfoCommonService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelCommonBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldCommonBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.DataCellInfo;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataCellInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.back.common.service.impl.ModelInfoCommonServiceImpl")
public class ModelInfoCommonServiceImpl
implements ModelInfoCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelInfoCommonServiceImpl.class);
    private static final String HOST_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})";
    private static final String PORT_REG = "(:\\d+)";
    private static final String DB_NAME_REG = "(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final String URL_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final Pattern DB_NAME_PATTERN = Pattern.compile("(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    private static final Pattern URL_PATTERN = Pattern.compile("(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    @Autowired
    private FormDesignBaseMapper formDesignBaseMapper;
    @Autowired
    private DataSourceService dataSourceService;

    public Boolean updateIndexForSystemTask(DataModelBase taskBase, FieldsContrastParam<? extends DataModelFieldBase> fieldsContrastParam) throws IOException, LcdpException {
        DataModelCommonBase task = (DataModelCommonBase)taskBase;
        List<IndexInfoDto> indexInfoByField = this.getIndexInfoByField(task);
        if (HussarUtils.isEmpty(indexInfoByField)) {
            return true;
        }
        DataCellInfo cellInfo = DataModelUtil.getDataCellInfo((String)fieldsContrastParam.getModelId());
        if (this.checkExistIndex(cellInfo)) {
            LOGGER.info(fieldsContrastParam.getModelId() + "\u4e2d\u95f4\u6587\u4ef6task\u5df2\u7ecf\u5b58\u5728indexSet,\u65e0\u9700\u518d\u521b\u5efa\u7d22\u5f15");
            return true;
        }
        MetadataParam metadataParamIndex = new MetadataParam();
        String dataSourceName = task.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return false;
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        TableInfoDto tableInfoDto = ModelInfoCommonServiceImpl.tableInfoInCreate(datasourceLr, task);
        metadataParamIndex.setTableInfo(tableInfoDto);
        metadataParamIndex.setIndexInfo(indexInfoByField);
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig(datasourceLr);
        List indexInfoDB = this.dataSourceService.getTableIndexInfoByTableName(datasourceLr.getConnName(), dataSourceConfig, task.getSourceDataModelName());
        boolean editIndex = true;
        if (HussarUtils.isNotEmpty((Object)indexInfoDB)) {
            LOGGER.info(fieldsContrastParam.getModelId() + ",\u67e5\u8be2\u5e93\u8868\u5df2\u7ecf\u5b58\u5728\u7684\u7d22\u5f15:" + JSONObject.toJSONString((Object)indexInfoDB));
            List indexNameList = indexInfoByField.stream().map(IndexInfoDto::getIndexName).collect(Collectors.toList());
            for (Map index : indexInfoDB) {
                if (!indexNameList.contains(index.get("indexName"))) continue;
                editIndex = false;
                break;
            }
            if (editIndex) {
                LOGGER.info(fieldsContrastParam.getModelId() + "\u4e2d\u95f4\u6587\u4ef6task\u4e0d\u5b58\u5728indexSet,\u9700\u8981\u521b\u5efa\u7d22\u5f15");
                ddlService.updateIndex(metadataParamIndex);
                LOGGER.info(fieldsContrastParam.getModelId() + "\u5e93\u8868\u7d22\u5f15\u521b\u5efa\u6210\u529f");
            }
        }
        this.saveIndexSet(indexInfoByField, cellInfo);
        LOGGER.info(fieldsContrastParam.getModelId() + "\u4e2d\u95f4\u6587\u4ef6\u7d22\u5f15\u4fdd\u5b58\u66f4\u65b0\u6210\u529f");
        return true;
    }

    private DataSourceConfig getDataSourceConfig(SysDataSource datasourceLr) throws IOException {
        DatasourceConfigDTO dataSourceConfigDTO = DataModelUtil.getDataSourceConfigByName((String)datasourceLr.getDbName());
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUsername(dataSourceConfigDTO.getUsername());
        dataSourceConfig.setPassword(dataSourceConfigDTO.getPassword());
        dataSourceConfig.setDbType(dataSourceConfigDTO.getDbType());
        dataSourceConfig.setDbName(dataSourceConfigDTO.getDbName());
        dataSourceConfig.setSchemaname(dataSourceConfigDTO.getSchemaname());
        dataSourceConfig.setDbMode(dataSourceConfigDTO.getDbMode());
        if (dataSourceConfigDTO.getDbType().size() > 1) {
            dataSourceConfig.setDbTypeCustom((String)dataSourceConfigDTO.getDbType().get(1));
        }
        dataSourceConfig.setUrl(datasourceLr.getJdbcUrl());
        dataSourceConfig.setDriverName(datasourceLr.getDriverClass());
        return dataSourceConfig;
    }

    @HussarDs(value="#connName")
    public List<Map<String, Object>> getTableIndexInfoByTableName(String connName, DataSourceConfig dataSourceConfig, String tableName) {
        LOGGER.info("\u67e5\u8be2{}\u7d22\u5f15\u4fe1\u606f\uff1a\u6570\u636e\u6e90\u4fe1\u606f\uff1a{}", (Object)tableName, (Object)JSON.toJSONString((Object)dataSourceConfig));
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String dbName = null;
        List<Map<String, Object>> indexList = Lists.newArrayListWithExpectedSize((int)0);
        if (DbType.MYSQL.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase())) {
            dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            String indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
            return this.formDesignBaseMapper.selectList(indexSql);
        }
        if (DbType.ORACLE.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase()) || DbType.DM.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase()) || DbType.OSCAR.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase()) || DbType.HIGHGO.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase())) {
            dbName = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? dataSourceConfig.getUsername() : dataSourceConfig.getSchemaname();
            String indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
            indexList = this.formDesignBaseMapper.selectList(indexSql);
            if (ToolUtil.isNotEmpty((Object)indexList)) {
                for (Map map : indexList) {
                    if (map.containsKey("indexname")) {
                        map.put("indexName", map.get("indexname"));
                        map.put("isPrimaryIndex", map.get("isprimaryindex"));
                        continue;
                    }
                    map.put("indexName", map.get("INDEXNAME"));
                    map.put("isPrimaryIndex", map.get("ISPRIMARYINDEX"));
                }
            }
            return indexList;
        }
        if (DbType.SQL_SERVER.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase())) {
            String indexSql;
            dbName = "dbo";
            if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
                dbName = dataSourceConfig.getSchemaname();
            }
            if (ToolUtil.isNotEmpty(indexList = this.formDesignBaseMapper.selectList(indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName)))) {
                for (Map<String, Object> map : indexList) {
                    if (map.containsKey("constraintType") && "PK".equals(map.get("constraintType"))) {
                        map.put("isPrimaryIndex", 1);
                        continue;
                    }
                    map.put("isPrimaryIndex", 0);
                }
            }
            return indexList;
        }
        if (DbType.KINGBASE.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase()) || DbType.POSTGRE_SQL.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase()) || DbType.GAUSS.getValue().equals(dataSourceConfig.getDbTypeCustom().toLowerCase())) {
            String indexSql;
            dbName = "public";
            if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
                dbName = dataSourceConfig.getSchemaname();
            }
            if (ToolUtil.isNotEmpty(indexList = this.formDesignBaseMapper.selectList(indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName)))) {
                for (Map<String, Object> map : indexList) {
                    map.put("indexName", map.get("indexname"));
                    map.put("isPrimaryIndex", map.get("isprimarykey"));
                }
            }
            return indexList;
        }
        return indexList;
    }

    private String getDataBaseName(String url) {
        if (url.indexOf(63) > -1) {
            url = url.substring(0, url.indexOf(63));
        }
        String dbName = "";
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            String urlName = urlMatcher.group(0);
            Matcher dbNameMatcher = DB_NAME_PATTERN.matcher(urlName);
            ArrayList<String> dbNameList = new ArrayList<String>();
            while (dbNameMatcher.find()) {
                dbNameList.add(dbNameMatcher.group());
            }
            if (ToolUtil.isNotEmpty(dbNameList)) {
                dbName = ((String)dbNameList.get(dbNameList.size() - 1)).substring(1);
            }
        }
        return dbName;
    }

    private void saveIndexSet(List<IndexInfoDto> indexInfoByField, DataCellInfo cellInfo) throws LcdpException, IOException {
        JSONObject dataModelJson = JSONObject.parseObject((String)cellInfo.getData());
        JSONObject jsonTask = (JSONObject)dataModelJson.get((Object)"task");
        jsonTask.put("indexSet", this.getIndexSetMyByField(indexInfoByField));
        cellInfo.setData(JSONObject.toJSONString((Object)dataModelJson));
        DataCellInfoService dataCellInfoService = (DataCellInfoService)SpringContextUtil.getBean(DataCellInfoService.class);
        dataCellInfoService.updateFileData((BaseFile)cellInfo);
    }

    private Object getIndexSetMyByField(List<IndexInfoDto> indexInfoByField) {
        ArrayList<String> indexSet = new ArrayList<String>();
        for (IndexInfoDto indexInfoDto : indexInfoByField) {
            indexSet.add(indexInfoDto.getIndexName());
        }
        return indexSet;
    }

    private List<IndexInfoDto> getIndexInfoByField(DataModelCommonBase baseDataModel) {
        ArrayList<IndexInfoDto> indexInfoDtos = new ArrayList<IndexInfoDto>();
        String foreignKeyName = this.getForeignKeyName(baseDataModel);
        IndexInfoDto indexInfoDto = new IndexInfoDto();
        indexInfoDto.setIndexName(this.getIndexNameByField(baseDataModel, foreignKeyName));
        indexInfoDto.setIndexColumns(Arrays.asList(foreignKeyName));
        indexInfoDtos.add(indexInfoDto);
        IndexInfoDto indexInfoTaskId = new IndexInfoDto();
        List taskIdField = baseDataModel.getFields().stream().filter(f -> "task_id".equals(f.getSourceFieldName()) || "TASK_ID".equals(f.getSourceFieldName())).collect(Collectors.toList());
        indexInfoTaskId.setIndexName(this.getIndexNameByField(baseDataModel, ((DataModelFieldCommonBase)taskIdField.get(0)).getSourceFieldName()));
        indexInfoTaskId.setIndexColumns(Arrays.asList(((DataModelFieldCommonBase)taskIdField.get(0)).getSourceFieldName()));
        indexInfoDtos.add(indexInfoTaskId);
        return indexInfoDtos;
    }

    private String getIndexNameByField(DataModelCommonBase baseDataModel, String foreignKeyName) {
        String dataModelFlag = baseDataModel.getSourceDataModelName().split("_SYS_TASK")[0];
        String indexName = dataModelFlag + foreignKeyName.charAt(0) + "D";
        return indexName;
    }

    private String getForeignKeyName(DataModelCommonBase baseDataModel) {
        Iterator iterator;
        List fieldsForeign = baseDataModel.getFields().stream().filter(field -> "foreign".equals(field.getUsage())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(fieldsForeign) && (iterator = fieldsForeign.iterator()).hasNext()) {
            DataModelFieldCommonBase field2 = (DataModelFieldCommonBase)iterator.next();
            return field2.getSourceFieldName();
        }
        return null;
    }

    private boolean checkExistIndex(DataCellInfo cellInfo) {
        JSONObject dataModelJson = JSONObject.parseObject((String)cellInfo.getData());
        JSONObject jsonTask = (JSONObject)dataModelJson.get((Object)"task");
        return jsonTask.containsKey((Object)"indexSet") && HussarUtils.isNotEmpty((Object)jsonTask.get((Object)"indexSet"));
    }

    public static TableInfoDto tableInfoInCreate(SysDataSource sysDataSource, DataModelCommonBase dataModel) {
        TableInfoDto tableDto = ModelInfoCommonServiceImpl.tableInfoInEdit(sysDataSource, dataModel);
        tableDto.setTableDec(dataModel.getTableDesc());
        return tableDto;
    }

    public static TableInfoDto tableInfoInEdit(SysDataSource sysDataSource, DataModelCommonBase dataModel) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(dataModel.getSourceDataModelName());
        tableDto.setPollName(dataModel.getDataSourceName());
        tableDto.setTableAlias(dataModel.getName());
        tableDto.setDatasourceId(sysDataSource.getId());
        tableDto.setColumnList(ModelInfoCommonServiceImpl.transfer(dataModel.getFields()));
        return tableDto;
    }

    private static List<MetadataColumn> transfer(List<DataModelFieldCommonBase> fields) {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        for (DataModelFieldCommonBase x : fields) {
            MetadataColumn metadataColumn = ModelInfoCommonServiceImpl.getMetadataColumn(x);
            columns.add(metadataColumn);
        }
        return columns;
    }

    private static MetadataColumn getMetadataColumn(DataModelFieldCommonBase modelField) {
        Optional<EngineColumnType> engineColumnType;
        String fieldSourceDataType = modelField.getSourceDataType();
        int preIndex = fieldSourceDataType.indexOf("(");
        String dataType = preIndex > -1 ? fieldSourceDataType.substring(0, preIndex) : modelField.getSourceDataType();
        MetadataColumn metadataColumn = new MetadataColumn();
        metadataColumn.setColumnAlias(modelField.getName());
        metadataColumn.setColumnName(modelField.getSourceFieldName());
        metadataColumn.setColumnComment(modelField.getComment());
        metadataColumn.setDataType(dataType);
        metadataColumn.setDataDot(Integer.valueOf(modelField.getDataDot()));
        metadataColumn.setDataLength(Long.valueOf(modelField.getDataLength()));
        metadataColumn.setDataIsEmpty(Integer.valueOf(modelField.getDataIsEmpty() ? 1 : 0));
        if (ToolUtil.isNotEmpty((Object)modelField.getUsage())) {
            if ("primary".equals(modelField.getUsage())) {
                metadataColumn.setPrimarys("1");
            }
            metadataColumn.setPurpose(modelField.getUsage());
        }
        if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType(modelField.getDataType())).isPresent()) {
            metadataColumn.setJdbcType(engineColumnType.get().getJdbcType().getName());
            metadataColumn.setJavaType(engineColumnType.get().getJavaType());
        }
        return metadataColumn;
    }
}

