/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.controller;

import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.model.GenerateField;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.model.GenerateModule;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.service.AIFormDesignService;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.service.DataModelRecommendService;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.service.ModuleRecommendService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/ai/lowcode"})
public class AIFormDesignController {
    @Resource
    private AIFormDesignService aiFormDesignService;
    @Resource
    private DataModelRecommendService dataModelRecommendService;
    @Resource
    private ModuleRecommendService moduleRecommendService;

    @GetMapping(value={"/enabled"})
    public FormDesignResponse<Boolean> enabled() {
        return this.aiFormDesignService.enabled();
    }

    @PostMapping(value={"/dataModel"})
    public FormDesignResponse<List<GenerateField>> dataModel(@RequestParam String description, @RequestParam String dataModelType) {
        return this.dataModelRecommendService.dataModel(description, dataModelType);
    }

    @PostMapping(value={"/module"})
    public FormDesignResponse<List<GenerateModule>> module(@RequestParam String description) {
        return this.moduleRecommendService.module(description);
    }
}

