/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.model.Invoice;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.service.AIComponentService;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.util.PythonRequestUtil;
import com.jxdinfo.hussar.formdesign.common.model.ResultCoreVO;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AIComponentServiceImpl
implements AIComponentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AIComponentServiceImpl.class);

    @Override
    public FormDesignResponse<Invoice> invoice(MultipartFile file, String serverAddress) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            String url = serverAddress + "/upload_invoice";
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            FileUtils.writeByteArrayToFile((File)new File(file.getOriginalFilename()), (byte[])file.getBytes());
            FileSystemResource fileSystemResource = new FileSystemResource(new File(file.getOriginalFilename()));
            params.add((Object)"file", (Object)fileSystemResource);
            ResultCoreVO resultCoreVO = PythonRequestUtil.sendPostRequest(url, (MultiValueMap<String, Object>)params);
            if (HussarUtils.isEmpty((Object)resultCoreVO)) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
            } else if (!resultCoreVO.isSucceed() || resultCoreVO.getCode() != 200) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)resultCoreVO.getMsg());
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + resultCoreVO.getMsg());
            } else if (HussarUtils.isEmpty((Object)resultCoreVO.getData())) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u4e3a\u7a7a");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u4e3a\u7a7a");
            } else {
                Object data = resultCoreVO.getData();
                Invoice invoice = (Invoice)JSON.parseObject((String)JSON.toJSONString((Object)data), Invoice.class);
                response.setData((Object)invoice);
                response.setErrorCode(HttpStatus.OK.value());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return response;
    }
}

