/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.artificial.intelligence.nocode.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.nocode.model.GenerateWidget;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.nocode.properties.NoCodeArtificialIntelligenceProperties;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.nocode.service.FormRecommendService;
import com.jxdinfo.hussar.formdesign.common.model.ResultCoreVO;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.RestTemplateHttpUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class FormRecommendServiceImpl
implements FormRecommendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormRecommendServiceImpl.class);

    @Override
    public FormDesignResponse<Boolean> enabled() {
        FormDesignResponse response = new FormDesignResponse();
        boolean dataModelEnabled = ((NoCodeArtificialIntelligenceProperties)SpringUtil.getBean(NoCodeArtificialIntelligenceProperties.class)).getEnabled();
        response.setData((Object)dataModelEnabled);
        response.setErrorCode(HttpStatus.OK.value());
        return response;
    }

    @Override
    public FormDesignResponse<List<GenerateWidget>> get(String content) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            String address = ((NoCodeArtificialIntelligenceProperties)SpringUtil.getBean(NoCodeArtificialIntelligenceProperties.class)).getFormServiceAddress() + "/predict";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("content", content);
            params.put("methodName", "noCodeForm");
            ResultCoreVO resultCoreVO = RestTemplateHttpUtil.sendPostRequest((String)address, params);
            if (HussarUtils.isEmpty((Object)resultCoreVO)) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
            } else if (HussarUtils.isEmpty((Object)resultCoreVO.getData()) && resultCoreVO.getCode() == 200) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u5217\u8868");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u5217\u8868");
            } else {
                Object data = resultCoreVO.getData();
                List widgetList = JSON.parseArray((String)JSON.toJSONString((Object)data), GenerateWidget.class);
                response.setData((Object)widgetList);
                response.setErrorCode(resultCoreVO.getCode().intValue());
                response.setErrorMsg(resultCoreVO.getMsg());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return response;
    }
}

