const file = event.target.files;
const inputDom = event.target;
const isUploadType = true;
for (let i = 0; i < file.length; i++) {
const idx = file[i].name.lastIndexOf('.');
if (idx != -1) {
// 判断文件格式
const fileTypes = ['application/pdf', 'image/png'];
if (isUploadType && fileTypes) {
for (let j = 0; j < fileTypes.length; j++) {
if (fileTypes[j] == file[i].type) {
break;
}
if (j === fileTypes.length - 1) {
HussarRouter.showMsg(self, '不接受此文件类型(支持类型:pdf,png)', 'warning');
return false;
}
}
} else if (isUploadType) {
HussarRouter.showMsg(self, '不接受此文件类型(支持类型：无)', 'warning');
return false;
}
self.${fileName} = file[i].name;
self.${file} = file[i];
self.${dataitem} = {
invoiceClass: '',
invoiceCode: '',
invoiceNumber: '',
invoiceDate: '',
tableData: [],
sellerName: '',
sellerNumber: '',
totalTax: '',
invoiceType: '',
label: '',
buyerName: '',
buyerNumber: '',
amountHj: '',
taxHj: '',
kpr: ''
}
inputDom.value = '';
}
}
const formData = new FormData();
formData.append('file', self.${file});
getUploadInvoice(formData).then((res) => {
if(res.data && res.errorCode === 200) {
const obj = res.data;
const tableData = [];
if (obj.itemsNames && obj.itemsNames.length > 0) {
for (let i = 0; i < obj.itemsNames.length; i++) {
const itemObj = {
itemsNames: obj.itemsNames[i],
rates: obj.rates[i],
taxes: isNaN(parseInt(obj.taxes[i])) ? '' : obj.taxes[i],
amounts: isNaN(parseInt(obj.amounts[i])) ? '' : obj.amounts[i]
}
tableData.push(itemObj);
}
}

self.${instanceKey}TabValue = tableData;
self.${instanceKey}InvoiceCode = obj.invoiceCode;
let dateTime = obj.invoiceDate;
if( typeof dateTime !== 'undefined' && dateTime !== null && dateTime !== ''){
dateTime = dateTime.replace('年', '-');
dateTime = dateTime.replace('月', '-');
dateTime = dateTime.replace('日', '');
}
self.${instanceKey}InvoiceDate = dateTime;
self.${instanceKey}TaxNumber = obj.sellerNumber;
self.${instanceKey}InvoiceType = obj.invoiceType;
self.${instanceKey}InvoiceName = obj.invoiceClass;
self.${instanceKey}InvoiceNumber = obj.invoiceNumber;
self.${instanceKey}SellerName = obj.sellerName;
self.${instanceKey}TotalPrice = obj.totalTax;
self.${instanceKey}TotalMark = obj.label;
self.${instanceKey}BuyerName = obj.buyerName;
self.${instanceKey}BuyerNumber = obj.buyerNumber;
self.${instanceKey}AmountHj = obj.amountHj;
self.${instanceKey}TaxHj = obj.taxHj;
self.${instanceKey}Drawer = obj.kpr;
} else {
self.${instanceKey}TabValue = [];
self.${instanceKey}InvoiceCode = '';
self.${instanceKey}InvoiceDate = '';
self.${instanceKey}TaxNumber = '';
self.${instanceKey}InvoiceType = '';
self.${instanceKey}InvoiceName = '';
self.${instanceKey}InvoiceNumber = '';
self.${instanceKey}SellerName = '';
self.${instanceKey}TotalPrice = '';
self.${instanceKey}TotalMark = '';
self.${instanceKey}BuyerName = '';
self.${instanceKey}BuyerNumber = '';
self.${instanceKey}AmountHj = '';
self.${instanceKey}TaxHj = '';
self.${instanceKey}Drawer = '';
}
});
self.${instanceKey}FileUpload(null);