/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.aicomponent.visitor.provide;

import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentBindUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdInfo.AIComponent.JXDInvoiceIdentife.value")
@Scope(value="prototype")
public class InvoiceValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;
    private static final String ID_DATA_ITEM = "fileId";
    private static final String NAME_DATA_ITEM = "fileName";

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String getValue(List<String> dataItems) throws LcdpException {
        if (ToolUtil.isNotEmpty(dataItems) && ID_DATA_ITEM.equals(dataItems.get(dataItems.size() - 1))) {
            return ComponentBindUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._FILE_ID.getType());
        }
        if (ToolUtil.isNotEmpty(dataItems) && NAME_DATA_ITEM.equals(dataItems.get(dataItems.size() - 1))) {
            return CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._FILE_NAME.getType();
        }
        return CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "''";
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            if (NAME_DATA_ITEM.equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"FileName", dataItems));
            } else if ("invoiceCode".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"InvoiceCode", dataItems));
            } else if ("invoiceDate".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"InvoiceDate", dataItems));
            } else if ("taxNumber".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"TaxNumber", dataItems));
            } else if ("invoiceType".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"InvoiceType", dataItems));
            } else if ("invoiceName".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"InvoiceName", dataItems));
            } else if ("invoiceNumber".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"InvoiceNumber", dataItems));
            } else if ("sellerName".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"SellerName", dataItems));
            } else if ("totalPrice".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"TotalPrice", dataItems));
            } else if ("totalMark".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"TotalMark", dataItems));
            } else if ("buyerName".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"BuyerName", dataItems));
            } else if ("buyerNumber".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"BuyerNumber", dataItems));
            } else if ("amountHj".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"AmountHj", dataItems));
            } else if ("taxHj".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"TaxHj", dataItems));
            } else if ("kpr".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.STRING);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"Drawer", dataItems));
            } else if ("tabValue".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
                data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"TabValue", dataItems));
                if (dataItems.size() == 2) {
                    String dataItem1 = dataItems.get(1);
                    if ("itemsNames".equals(dataItem1)) {
                        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                        String optionData = this.getTableData().getRenderValue();
                        data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].itemsNames );\n}\nreturn flag;}()");
                    } else if ("rates".equals(dataItem1)) {
                        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                        String optionData = this.getTableData().getRenderValue();
                        data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].rates );\n}\nreturn flag;}()");
                    } else if ("taxes".equals(dataItem1)) {
                        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                        String optionData = this.getTableData().getRenderValue();
                        data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].taxes );\n}\nreturn flag;}()");
                    } else if ("amounts".equals(dataItem1)) {
                        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                        String optionData = this.getTableData().getRenderValue();
                        data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].amounts );\n}\nreturn flag;}()");
                    }
                } else if (dataItems.size() == 1) {
                    return this.getTableData();
                }
            }
            return data;
        }
        return new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._FILE_ID.getType(), Collections.singletonList(ID_DATA_ITEM)));
    }

    private ComponentData getTableData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("tabValue");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"TabValue", optionDataItem));
        return optionData;
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put(NAME_DATA_ITEM, NAME_DATA_ITEM);
        return map;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        ArrayList<ComponentData> list = new ArrayList<ComponentData>();
        list.add(new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._FILE_ID.getType(), Collections.singletonList(ID_DATA_ITEM))));
        list.add(new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._FILE_NAME.getType(), Collections.singletonList(NAME_DATA_ITEM))));
        return list;
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }
}

