/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.microsoft.schemas.office.office.CTLock;
import com.microsoft.schemas.vml.CTGroup;
import com.microsoft.schemas.vml.CTShape;
import com.microsoft.schemas.vml.CTShapetype;
import com.microsoft.schemas.vml.CTTextPath;
import com.microsoft.schemas.vml.STExt;
import com.microsoft.schemas.vml.STTrueFalse;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.wp.usermodel.HeaderFooterType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;

public class DocxUtil {
    private static final Logger LOGGER = LogManager.getLogger(DocxUtil.class);
    private static final String fontColor = "#DDDDDD";
    private static final String fontName = "Arial";
    private static final String fontSize = "10pt";
    private static final int widthPerWord = 10;
    private static final String styleRotation = "-45";

    public static void makeFullWaterMarkByWordArt(JSONObject parse, XWPFDocument docx, String customText) {
        if (customText.contains("\n")) {
            customText = customText.replace("\n", " ");
        }
        customText = customText + DocxUtil.repeatString(" ", 14);
        customText = DocxUtil.repeatString(customText, 10);
        String styleTop = "0pt";
        if (docx == null) {
            return;
        }
        for (int lineIndex = -10; lineIndex < 20; ++lineIndex) {
            styleTop = 100 * lineIndex + "pt";
            DocxUtil.waterMarkDocxDocument(parse, docx, customText, styleTop, 1);
        }
    }

    private static String repeatString(String pattern, int repeats) {
        StringBuilder buffer = new StringBuilder(pattern.length() * repeats);
        Stream.generate(() -> pattern).limit(repeats).forEach(buffer::append);
        return new String(buffer);
    }

    private static void waterMarkDocxDocument(JSONObject parse, XWPFDocument doc, String customText, String styleTop, int type) {
        int size;
        XWPFHeader header = doc.createHeader(HeaderFooterType.DEFAULT);
        PackagePart headerPart = header.getPackagePart();
        String rId = null;
        try {
            for (PackageRelationship rel : doc.getPackagePart().getRelationships()) {
                if (!rel.getTargetURI().equals(headerPart.getPartName().getURI())) continue;
                rId = rel.getId();
                break;
            }
        }
        catch (InvalidFormatException e) {
            LOGGER.error("\u672a\u627e\u5230\u6c34\u5370\u9875\u7709\u7684\u5173\u7cfb ID");
        }
        if (HussarUtils.isNotEmpty((Object)parse)) {
            parse.put("_rId_", rId);
        }
        if ((size = header.getParagraphs().size()) == 0) {
            header.createParagraph();
        }
        CTP ctp = header.getParagraphArray(0).getCTP();
        byte[] rsidr = doc.getDocument().getBody().getPArray(0).getRsidR();
        byte[] rsidrdefault = doc.getDocument().getBody().getPArray(0).getRsidRDefault();
        ctp.setRsidP(rsidr);
        ctp.setRsidRDefault(rsidrdefault);
        CTPPr ppr = ctp.addNewPPr();
        ppr.addNewPStyle().setVal("Header");
        CTR ctr = ctp.addNewR();
        CTRPr ctrpr = ctr.addNewRPr();
        ctrpr.addNewNoProof();
        CTGroup group = CTGroup.Factory.newInstance();
        CTShapetype shapetype = group.addNewShapetype();
        CTTextPath shapeTypeTextPath = shapetype.addNewTextpath();
        shapeTypeTextPath.setOn(STTrueFalse.T);
        shapeTypeTextPath.setFitshape(STTrueFalse.T);
        CTLock lock = shapetype.addNewLock();
        lock.setExt(STExt.VIEW);
        CTShape shape = group.addNewShape();
        shape.setId("PowerPlusWaterMarkObject");
        shape.setSpid("_x0000_s102");
        shape.setType("#_x0000_t136");
        if (type != 2) {
            shape.setStyle(DocxUtil.getShapeStyle(customText, styleTop));
        }
        shape.setFillcolor(fontColor);
        shape.setStroked(STTrueFalse.FALSE);
        CTTextPath shapeTextPath = shape.addNewTextpath();
        shapeTextPath.setStyle("font-family:Arial;font-size:10pt");
        shapeTextPath.setString(customText);
        CTPicture pict = ctr.addNewPict();
        pict.set((XmlObject)group);
    }

    private static String getShapeStyle(String customText, String styleTop) {
        StringBuilder sb = new StringBuilder();
        sb.append("position: ").append("absolute");
        sb.append(";width: ").append(customText.length() * 10).append("pt");
        sb.append(";height: ").append("12pt");
        sb.append(";z-index: ").append("-251654144");
        sb.append(";mso-wrap-edited: ").append("f");
        sb.append(";margin-top: ").append(styleTop);
        sb.append(";mso-position-horizontal-relative: ").append("margin");
        sb.append(";mso-position-vertical-relative: ").append("margin");
        sb.append(";mso-position-vertical: ").append("left");
        sb.append(";mso-position-horizontal: ").append("center");
        sb.append(";rotation: ").append(styleRotation);
        return sb.toString();
    }

    private static String getShapeStyle() {
        StringBuilder sb = new StringBuilder();
        sb.append("position: ").append("absolute");
        sb.append(";left: ").append("opt");
        sb.append(";width: ").append("500pt");
        sb.append(";height: ").append("150pt");
        sb.append(";z-index: ").append("-251654144");
        sb.append(";mso-wrap-edited: ").append("f");
        sb.append(";margin-left: ").append("-50pt");
        sb.append(";margin-top: ").append("270pt");
        sb.append(";mso-position-horizontal-relative: ").append("margin");
        sb.append(";mso-position-vertical-relative: ").append("margin");
        sb.append(";mso-width-relative: ").append("page");
        sb.append(";mso-height-relative: ").append("page");
        sb.append(";rotation: ").append("-2949120f");
        return sb.toString();
    }
}

