/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.handle;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.print.handle.WordHandle;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.springframework.stereotype.Component;

@Component
public class WordHandleForCopy {
    @Resource
    private HussarFormDesignProperties hussarFormDesignProperties;
    @Resource
    private OssService ossService;
    @Resource
    private WordHandle wordHandle;
    private static ConcurrentHashMap<String, Object> hashMap = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger(WordHandleForCopy.class);

    private static Matcher matcher(String str) {
        return Pattern.compile("\\$\\{(.+?)\\}", 2).matcher(str);
    }

    private static void analysisPlaceholder(XWPFDocument document, Map<String, String> widgets) {
        for (XWPFParagraph paragraph : document.getParagraphs()) {
            String paragraphText = paragraph.getParagraphText();
            Matcher matcher = WordHandleForCopy.matcher(paragraphText);
            while (matcher.find()) {
                String key = matcher.group();
                if (!key.contains(".")) continue;
                hashMap.put(key, "");
            }
        }
    }

    private static void analysisTable(XWPFDocument document) {
        Iterator tablesIterator = document.getTablesIterator();
        while (tablesIterator.hasNext()) {
            XWPFTable table = (XWPFTable)tablesIterator.next();
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    Matcher matcher = WordHandleForCopy.matcher(cell.getText());
                    while (matcher.find()) {
                        String key = matcher.group();
                        if (!key.contains(".")) continue;
                        hashMap.put(key, "");
                    }
                }
            }
        }
    }

    private static void getFormData(Map<String, Object> hashMap, JSONObject dataJson) {
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            String key = entry.getKey();
            String substring = key.substring(key.indexOf("#") + 1, key.lastIndexOf("}"));
            if (!substring.contains(".")) continue;
            String[] split = substring.split("\\.");
            substring = split[0];
            String value = key.replace(substring, String.valueOf(dataJson.get((Object)substring)));
            hashMap.put(key, value);
        }
    }

    public XWPFDocument generateWord(Map<String, Object> param, XWPFDocument doc, Map<String, String> widgets) {
        try {
            if (param != null && param.size() > 0) {
                this.replaceInPara(doc, param, widgets);
                this.replaceInTable(doc, param, widgets);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u6570\u636e{} \u66ff\u6362\u5931\u8d25", param);
            throw new BaseException("\u66ff\u6362\u6a21\u677f\u5360\u4f4d\u7b26\u5f02\u5e38");
        }
        return doc;
    }

    private void replaceInPara(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets) {
        Iterator iterator = doc.getParagraphsIterator();
        while (iterator.hasNext()) {
            XWPFParagraph para = (XWPFParagraph)iterator.next();
            try {
                this.replaceInPara(para, params, widgets);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("word\u6a21\u677f\u6253\u5370\u6587\u6863{} \u4e0d\u5b58\u5728", (Object)doc);
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void replaceInPara(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets) throws FileNotFoundException {
        String tempString = "";
        int lastChar = 32;
        if (WordHandleForCopy.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            HashSet<XWPFRun> runSet = new HashSet<XWPFRun>();
            for (XWPFRun run : runs) {
                String text = run.getText(0);
                if (text == null) continue;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '$') {
                        runSet = new HashSet();
                        runSet.add(run);
                        tempString = text;
                    } else if (ch == '{') {
                        if (lastChar == 36) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else if (ch == '}') {
                        if (tempString != null && tempString.indexOf("${") >= 0) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                        if (runSet.size() > 0) {
                            String replaceText = WordHandleForCopy.replaceText(tempString, param);
                            if (!replaceText.equals(tempString)) {
                                int index = 0;
                                XWPFRun aRun = null;
                                for (XWPFRun tempRun : runSet) {
                                    tempRun.setText("", 0);
                                    if (index == 0) {
                                        aRun = tempRun;
                                    }
                                    ++index;
                                }
                                aRun.setText(replaceText, 0);
                            }
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else {
                        if (runSet.size() <= 0 || runSet.contains(run)) continue;
                        runSet.add(run);
                        tempString = tempString + text;
                    }
                    lastChar = ch;
                }
            }
        }
    }

    private static String replaceText(String text, Map<String, Object> map) {
        Matcher matcher;
        if (text != null && (matcher = WordHandleForCopy.matcher(text)).find() && (matcher = WordHandleForCopy.matcher(text)).find() && text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) {
            String value = String.valueOf(map.get(matcher.group()));
            text = text.replace(matcher.group(), value);
        }
        return text;
    }

    private void replaceInTable(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets) throws FileNotFoundException {
        Iterator iterator = doc.getTablesIterator();
        while (iterator.hasNext()) {
            XWPFTable table = (XWPFTable)iterator.next();
            List rows = table.getRows();
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                for (XWPFTableCell cell : cells) {
                    String text = cell.getText();
                    if (!text.contains(".") || !text.contains("$") || !text.contains("{") || !text.contains("#") || !text.contains("}")) continue;
                    List paragraphs = cell.getParagraphs();
                    for (XWPFParagraph paragraph : paragraphs) {
                        this.replaceInPara(paragraph, params, widgets);
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Long entry(JSONObject parse, AttachmentManagerModelVo attachmentManagerModelVo, Map<String, String> widgets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

