/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.policy.RenderPolicy;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DownLoadComponent;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.I18nUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.WaterMarkComponent;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.print.dto.SubWordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.dto.WordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.enums.CellLevel;
import com.jxdinfo.hussar.formdesign.application.print.enums.FileNameMode;
import com.jxdinfo.hussar.formdesign.application.print.handle.SuggestionTemp;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.model.SysWordPrintTask;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysWordPrintTaskService;
import com.jxdinfo.hussar.formdesign.application.print.util.DocxUtil;
import com.jxdinfo.hussar.formdesign.application.print.util.GenerateCode;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintGeneFileName;
import com.jxdinfo.hussar.formdesign.application.print.vo.WidgetsAndData;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.application.properties.WordPrintProperties;
import com.jxdinfo.hussar.formdesign.application.util.DeepCopy;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import com.jxdinfo.hussar.formdesign.no.code.business.service.DictDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLFactory;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ddr.poi.html.HtmlRenderPolicy;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColumns;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STEm;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHighlightColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSectionMark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STThemeColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTRImpl;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class WordHandle {
    @Resource
    private HussarFormDesignProperties hussarFormDesignProperties;
    @Resource
    private IHussarAppDataSourceService hussarAppDataSourceService;
    @Resource
    private WordPrintProperties wordPrintProperties;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private ISysWordPrintTaskService sysWordPrintTaskService;
    @Resource
    private OssService ossService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private WaterMarkComponent waterMarkComponent;
    @Resource
    private I18nUtil i18nUtil;
    @Resource
    private DownLoadComponent downLoadCompent;
    @Resource
    private DictDataSourceService dictDataSourceService;
    private static final ConcurrentHashMap<String, Object> HASH_MAP = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger(WordHandle.class);
    private static final int DEFAULT_ROW_NUM = 1;
    private static final int DEFAULT_MAX_ROW_NUM = 0;
    private static final int HOST_LEVEL = 0;
    private static final int CHILD_LEVEL = 1;
    private static final int SUN_LEVEL = 2;
    private static final String WIDGET_LEVEL = "widgetLevel";
    private static final String DATA_VALUE = "dataValue";
    private static final String GRAN_MAP = "granMap";
    private static final String DOCX_SUFFIX = ".docx";
    public static final String DICT_KEY = "dict";
    public static final String STATIC_KEY = "static";
    public static final String ASYNC_KEY = "async";
    public static final String DATA_LINK_AGE_KEY = "dataLinkage";
    public static final String OPTIONS_KEY = "options";
    public static final String OPTION_TYPE_KEY = "optionType";
    public static final String MATCHER_COLOR = "hsl\\(\\s*(\\d+),\\s*(\\d+)%\\s*,\\s*(\\d+)%\\s*\\)";

    private void replaceInPara(XWPFDocument doc, XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets, Map<String, String> richTextMap) throws FileNotFoundException {
        boolean exactFlag = para.getSpacingLineRule() == LineSpacingRule.EXACT && HussarUtils.isNotEmpty((Object)para.getRuns());
        String tempString = "";
        int lastChar = 32;
        if (this.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            HashSet<XWPFRun> runSet = new HashSet<XWPFRun>();
            for (XWPFRun run : runs) {
                String text = run.getText(0);
                if (text == null) continue;
                boolean isFind = true;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '$') {
                        runSet = new HashSet();
                        runSet.add(run);
                        tempString = text;
                    } else if (ch == '{') {
                        if (lastChar == 36) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else if (ch == '}') {
                        if (tempString.contains("${")) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                        if (!runSet.isEmpty()) {
                            String replaceText = this.replaceText(tempString, param);
                            if (!replaceText.equals(tempString) && isFind) {
                                int index = 0;
                                XWPFRun aRun = null;
                                for (XWPFRun tempRun : runSet) {
                                    tempRun.setText("", 0);
                                    if (index == 0) {
                                        aRun = tempRun;
                                    }
                                    ++index;
                                }
                                this.replaceTemp(doc, para, param, tempString, replaceText, aRun, widgets, richTextMap, exactFlag);
                                isFind = false;
                            }
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else {
                        if (runSet.size() <= 0 || runSet.contains(run)) continue;
                        runSet.add(run);
                        tempString = tempString + text;
                    }
                    lastChar = ch;
                }
            }
        }
    }

    private void replaceInParaForRichText(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets, Map<String, String> richTextMap) throws FileNotFoundException {
        String tempString = "";
        int lastChar = 32;
        if (this.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            HashSet<XWPFRun> runSet = new HashSet<XWPFRun>();
            for (XWPFRun run : runs) {
                String text = run.getText(0);
                if (text == null) continue;
                boolean isFind = true;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '$') {
                        runSet = new HashSet();
                        runSet.add(run);
                        tempString = text;
                    } else if (ch == '{') {
                        if (lastChar == 36) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else if (ch == '}') {
                        if (tempString.contains("${")) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                        if (!runSet.isEmpty()) {
                            String replaceText = this.replaceText(tempString, param);
                            if (!replaceText.equals(tempString) && isFind) {
                                int index = 0;
                                XWPFRun aRun = null;
                                for (XWPFRun tempRun : runSet) {
                                    tempRun.setText("", 0);
                                    if (index == 0) {
                                        aRun = tempRun;
                                    }
                                    ++index;
                                }
                                this.replaceTemp1(param, tempString, replaceText, aRun, widgets, richTextMap);
                                isFind = false;
                            }
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else {
                        if (runSet.size() <= 0 || runSet.contains(run)) continue;
                        runSet.add(run);
                        tempString = tempString + text;
                    }
                    lastChar = ch;
                }
            }
        }
    }

    private void replaceTemp(XWPFDocument doc, XWPFParagraph para, Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, boolean exactFlag) {
        ArrayList<String> temps = new ArrayList<String>();
        ArrayList<String> replaceTexts = new ArrayList<String>();
        Matcher matcher = this.matcher(tempString);
        while (matcher.find()) {
            String group = matcher.group();
            temps.add(group);
            if (param.containsKey(group)) {
                if (HussarUtils.isEmpty((Object)param.get(group))) {
                    replaceTexts.add("");
                    continue;
                }
                replaceTexts.add(param.get(group).toString());
                continue;
            }
            replaceTexts.add("");
        }
        int s = 0;
        for (int j = 0; j < temps.size(); ++j) {
            int i;
            int k = j - s;
            String string = (String)temps.get(j);
            String text = (String)replaceTexts.get(j);
            if (this.judgeImage(string, widgets)) {
                if (!this.handleImg(doc, para, string, text, aRun, widgets, k, exactFlag)) continue;
                ++s;
                continue;
            }
            if (this.judgeTextArea(string, widgets)) {
                i = this.handleTextArea(string, text, aRun, widgets, k);
                s -= i;
                continue;
            }
            if (this.judgeSelect(string, widgets)) {
                this.handleSelect(param, string, text, aRun, widgets, k);
                continue;
            }
            if (this.judgeFile(string, widgets)) {
                this.handleFile(string, text, aRun, widgets, k);
                continue;
            }
            if (this.judgeRichText(string, widgets)) {
                this.handleRichText(string, text, aRun, widgets, richTextMap, k);
                continue;
            }
            if (this.judgeInputOrSer(string, widgets)) {
                if (!this.handleInputOrSer(string, text, aRun, widgets, k)) continue;
                ++s;
                continue;
            }
            if (this.judgeSignature(string, widgets)) {
                if (!this.handleSignature(string, text, aRun, widgets, k)) continue;
                ++s;
                continue;
            }
            if (this.judgeSuggestion(string, widgets)) {
                i = this.handleSuggestion(string, text, aRun, widgets, richTextMap, k);
                s -= i;
                continue;
            }
            aRun.setText(text, k);
        }
    }

    private void replaceTemp1(Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList<String> temps = new ArrayList<String>();
        Matcher matcher = this.matcher(tempString);
        while (matcher.find()) {
            String group = matcher.group();
            temps.add(group);
        }
        for (String string : temps) {
            int endIndex;
            int startIndex;
            String result = string.substring(startIndex = string.indexOf(35) + 1, endIndex = string.indexOf(125));
            if (HussarUtils.isNotEmpty((Object)widgets.get(result)) && widgets.get(result).equals(WidgetType.JXDNRichText.getType())) {
                tempString = tempString.replace(string, "{{" + result + "}}");
                richTextMap.put(result, String.valueOf(param.get(string)));
                continue;
            }
            if (result.contains("|")) {
                result = result.split("\\|")[0];
            }
            if (!HussarUtils.isNotEmpty((Object)widgets.get(result)) || !widgets.get(result).equals(WidgetType.JXDNSuggestion.getType())) continue;
            String img = "<img width=\"68\" height=\"25\" src=";
            String[] split = tempString.split("\\|");
            if (split.length > 1) {
                String size = split[1];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    if (height.contains("fixed")) {
                        String[] split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        String[] split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                double widthToHeight = 0.0;
                if (split1.length == 2) {
                    List<Double> wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                    if (HussarUtils.isEmpty(wh)) {
                        LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u5ba1\u6279\u610f\u89c1\u7b7e\u540d\u53c2\u6570\u6709\u8bef", (Object)tempString);
                    }
                    double widthD = wh.get(0) / 25.4 * 96.0;
                    double heightD = wh.get(1) / 25.4 * 96.0;
                    img = "<img width=" + widthD + " height=" + heightD + " src=";
                }
            }
            String widgetStr = widgets.get("widgetsStr");
            JSONArray array = JSON.parseArray((String)widgetStr);
            for (Object o : array) {
                JSONObject object;
                List list;
                JSONObject jsonObject;
                Object name;
                if (!(o instanceof JSONObject) || !HussarUtils.isNotEmpty((Object)(name = (jsonObject = (JSONObject)o).get((Object)"name"))) || !String.valueOf(name).equals(result) || (list = (List)(object = (JSONObject)jsonObject.get((Object)"props")).get((Object)"showFields")).size() == 1 && ((String)list.get(0)).equals("name")) continue;
                if (richTextMap.containsKey(result)) {
                    result = result + System.currentTimeMillis();
                }
                tempString = tempString.replace(string, "{{" + result + "}}");
                String value = String.valueOf(param.get(string));
                value = value.replace("<imgsrc=", img);
                richTextMap.put(result, value);
            }
        }
        aRun.setText(tempString, 0);
    }

    private void handleRichText(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, int position) {
        int startIndex = tempString.indexOf(35) + 1;
        int endIndex = tempString.indexOf(125);
        String result = tempString.substring(startIndex, endIndex);
        String regex = "\\{\\{.+?\\}\\}";
        if (HussarUtils.isEmpty((Object)replaceText)) {
            aRun.setText("", position);
            return;
        }
        Matcher matcher = Pattern.compile(regex, 2).matcher(replaceText);
        if (matcher.find()) {
            aRun.setText(replaceText, position);
        } else {
            aRun.setText("{{" + result + "}}", position);
            richTextMap.put(result, replaceText);
        }
    }

    private boolean handleInputOrSer(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        String codeMode = "";
        if (tempString.contains("|") && tempString.contains("size")) {
            String[] split = tempString.split("\\|");
            if (split.length > 2) {
                codeMode = split[1];
                String size = split[2];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains("fixed")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                if (split1.length == 2) {
                    List<Double> wh;
                    if ("qrcode".equals(codeMode)) {
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, 1.0);
                        WordHandle.insertCode(tempString, codeMode, replaceText, wh.get(0).intValue(), wh.get(1).intValue(), BarcodeFormat.QR_CODE, aRun, ErrorCorrectionLevel.M);
                    } else {
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, 1.5);
                        WordHandle.insertCode(tempString, codeMode, replaceText, wh.get(0).intValue(), wh.get(1).intValue(), BarcodeFormat.CODE_128, aRun, ErrorCorrectionLevel.H);
                    }
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleImg(XWPFDocument doc, XWPFParagraph para, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position, boolean exactFlag) {
        List<Object> wh = new ArrayList();
        int mode = 0;
        String imageconfig = tempString.substring(tempString.indexOf("=") + 1, tempString.indexOf("}"));
        String[] split = imageconfig.split("\\*");
        String width = split[0];
        String height = split[1];
        if (!width.contains("auto")) {
            if (height.contains("fixed")) {
                String[] split1 = height.split("_");
                height = split1[0];
                mode = 1;
            } else if (height.contains("_")) {
                String[] split2 = height.split("_");
                height = split2[0];
                mode = 2;
            } else {
                height = "auto";
                mode = 3;
            }
        }
        JSONArray parse = (JSONArray)JSON.parse((String)replaceText);
        InputStream inputStream = null;
        ByteArrayInputStream stream = null;
        ByteArrayInputStream stream2 = null;
        if (HussarUtils.isNotEmpty((Object)parse)) {
            block41: {
                for (Object obj : parse) {
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject jsonObject = (JSONObject)obj;
                    String id = String.valueOf(jsonObject.get((Object)"id"));
                    String type = String.valueOf(jsonObject.get((Object)"type"));
                    String name = String.valueOf(jsonObject.get((Object)"name"));
                    byte[] bytes = this.showImageByte(Long.valueOf(id));
                    double widthToHeight = 0.0;
                    byte[] bs = new byte[]{};
                    try {
                        inputStream = new ByteArrayInputStream(bytes);
                        stream = new ByteArrayInputStream(bytes);
                        stream2 = new ByteArrayInputStream(bytes);
                        bs = IOUtils.toByteArray((InputStream)stream);
                        BufferedImage image = ImageIO.read(new ByteArrayInputStream(bs));
                        widthToHeight = (double)image.getWidth() / (double)image.getHeight();
                        inputStream = HussarUtils.isNotEmpty((Object)type) && type.equals("ico") ? this.handleIco(this.hussarFormDesignProperties.getWorkspace(), image) : this.handleWebp(inputStream, stream2, this.hussarFormDesignProperties.getWorkspace(), image);
                        if (!HussarUtils.isNotEmpty((Object)inputStream)) continue;
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                        if (HussarUtils.isEmpty(wh)) {
                            LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                        }
                        aRun.addPicture(inputStream, this.judgeImgType(type), name, ((Double)wh.get(0)).intValue() * 36000, ((Double)wh.get(1)).intValue() * 36000);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
                        }
                        try {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
                        }
                        try {
                            if (stream2 == null) continue;
                            ((InputStream)stream2).close();
                        }
                        catch (IOException e) {
                            LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
                        }
                    }
                }
                try {
                    XmlCursor xmlCursor;
                    XWPFParagraph paragraph;
                    CTPPr pPr;
                    int posOfParagraph;
                    XWPFParagraph next;
                    CTDrawing drawing;
                    if (!exactFlag || !HussarUtils.isNotEmpty((Object)aRun.getEmbeddedPictures()) || !HussarUtils.isNotEmpty((Object)aRun.getCTR()) || !HussarUtils.isNotEmpty((Object)aRun.getCTR().getDrawingList()) || !HussarUtils.isNotEmpty((Object)(drawing = aRun.getCTR().getDrawingArray(0)).getInlineList())) break block41;
                    CTGraphicalObject graphic = drawing.getInlineArray(0).getGraphic();
                    String anchorXML = "<wp:anchor  xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"0\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\"><wp:simplePos x=\"0\" y=\"0\"/><wp:positionH relativeFrom=\"column\"><wp:posOffset>635</wp:posOffset></wp:positionH><wp:positionV relativeFrom=\"paragraph\"><wp:posOffset>" + -(589280 * ((Double)wh.get(1)).intValue() / 20) + "</wp:posOffset></wp:positionV><wp:extent cx=\"" + ((Double)wh.get(0)).intValue() * 36000 + "\" cy=\"" + ((Double)wh.get(1)).intValue() * 36000 + "\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:wrapNone/><wp:docPr id=\"1\" name=\"Drawing 0\" descr=\"11\"/><wp:cNvGraphicFramePr/></wp:anchor>";
                    CTDrawing drawing1 = null;
                    try {
                        drawing1 = CTDrawing.Factory.parse((String)anchorXML);
                    }
                    catch (XmlException e) {
                        LOGGER.error("-------\u53d1\u751f\u672a\u77e5\u5f02\u5e38:{}", (Throwable)e);
                    }
                    CTAnchor anchor = drawing1.getAnchorArray(0);
                    anchor.setGraphic(graphic);
                    drawing.setAnchorArray(new CTAnchor[]{anchor});
                    drawing.removeInline(0);
                    XmlObject copyPPr = null;
                    if (HussarUtils.isNotEmpty((Object)para.getCTP()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr())) {
                        CTPPr pPr2 = para.getCTP().getPPr();
                        copyPPr = pPr2.copy();
                    }
                    if (HussarUtils.isEmpty((Object)(next = doc.getParagraphArray((posOfParagraph = doc.getPosOfParagraph(para)) + 1)))) {
                        next = doc.createParagraph();
                    }
                    if (HussarUtils.isEmpty((Object)(pPr = (paragraph = doc.insertNewParagraph(xmlCursor = next.getCTP().newCursor())).getCTP().getPPr()))) {
                        pPr = paragraph.getCTP().addNewPPr();
                    }
                    pPr.set(copyPPr);
                    if (HussarUtils.isNotEmpty((Object)para.getCTP()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr().getSectPr())) {
                        CTPPr oriPPr = para.getCTP().getPPr();
                        oriPPr.unsetSectPr();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u56fe\u7247\u6d6e\u4e8e\u6587\u5b57\u4e0a\u65b9\u5931\u8d25", (Throwable)e);
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    public InputStream handleIco(String outputPath, BufferedImage image) throws IOException {
        String path = outputPath + "wordTemplate" + File.separator + "ico" + File.separator;
        File filePath = new File(outputPath + "wordTemplate" + File.separator + "ico" + File.separator);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        String newPath = path + System.currentTimeMillis() + ".png";
        ImageIO.write((RenderedImage)image, "png", new File(newPath));
        return Files.newInputStream(Paths.get(newPath, new String[0]), new OpenOption[0]);
    }

    public InputStream handleWebp(InputStream inputStream, InputStream stream, String outputPath, BufferedImage image) throws IOException {
        boolean isWebp = this.imgType(stream);
        if (isWebp) {
            String path = outputPath + "wordTemplate" + File.separator + "webp" + File.separator;
            File filePath = new File(outputPath + "wordTemplate" + File.separator + "webp" + File.separator);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            String newPath = path + System.currentTimeMillis() + ".png";
            ImageIO.write((RenderedImage)image, "png", new File(newPath));
            return Files.newInputStream(Paths.get(newPath, new String[0]), new OpenOption[0]);
        }
        return inputStream;
    }

    public boolean imgType(InputStream inputStream) throws IOException {
        byte[] fileHeader = new byte[4];
        inputStream.read(fileHeader, 0, fileHeader.length);
        inputStream.close();
        String header = this.bytes2Hex(fileHeader);
        return header.contains("52494646");
    }

    public String bytes2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            sb.append(hex.length() == 2 ? hex : "0" + hex);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSignature(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        if (tempString.contains("|") && tempString.contains("size") && HussarUtils.isNotEmpty((Object)replaceText)) {
            String[] split = tempString.split("\\|");
            if (split.length > 1) {
                String size = split[1];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains("fixed")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                double widthToHeight = 0.0;
                if (split1.length == 2) {
                    int index = replaceText.indexOf(",");
                    replaceText = replaceText.substring(index + 1);
                    ByteArrayInputStream inputStream = null;
                    try {
                        Base64.Decoder decoder = Base64.getDecoder();
                        byte[] b = decoder.decode(replaceText);
                        inputStream = new ByteArrayInputStream(b);
                    }
                    catch (Exception e) {
                        LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    if (HussarUtils.isNotEmpty((Object)inputStream)) {
                        try {
                            List<Double> wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                            if (HussarUtils.isEmpty(wh)) {
                                LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef", (Object)tempString);
                            }
                            aRun.addPicture((InputStream)inputStream, this.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", wh.get(0).intValue() * 36000, wh.get(1).intValue() * 36000);
                        }
                        catch (Exception e) {
                            LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)inputStream);
                        }
                    }
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    private int handleSuggestion(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, int position) {
        int add = 0;
        String regex = "\\{\\{.+?\\}\\}";
        if (HussarUtils.isEmpty((Object)replaceText)) {
            aRun.setText("", position);
            return add;
        }
        Matcher matcher = Pattern.compile(regex, 2).matcher(replaceText);
        if (HussarUtils.isNotEmpty((Object)replaceText) && !matcher.find()) {
            JSONArray array = JSON.parseArray((String)replaceText);
            for (Object o : array) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)o;
                Object object1 = jsonObject.get((Object)"signature");
                if (HussarUtils.isNotEmpty((Object)object1)) {
                    String signature = String.valueOf(object1);
                    String[] split = tempString.split("\\|");
                    if (split.length > 1) {
                        String size = split[1];
                        int mode = 0;
                        String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                        String[] split1 = imageconfig.split("\\*");
                        String width = split1[0];
                        String height = split1[1];
                        if (!width.contains("auto")) {
                            if (height.contains("fixed")) {
                                String[] split2 = height.split("_");
                                height = split2[0];
                                mode = 1;
                            } else if (height.contains("_")) {
                                String[] split2 = height.split("_");
                                height = split2[0];
                                mode = 2;
                            } else {
                                height = "auto";
                                mode = 3;
                            }
                        }
                        double widthToHeight = 0.0;
                        if (split1.length != 2) continue;
                        int index = signature.indexOf(",");
                        signature = signature.substring(index + 1);
                        ByteArrayInputStream inputStream = null;
                        try {
                            Base64.Decoder decoder = Base64.getDecoder();
                            byte[] b = decoder.decode(signature);
                            inputStream = new ByteArrayInputStream(b);
                        }
                        catch (Exception e) {
                            LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        }
                        if (!HussarUtils.isNotEmpty((Object)inputStream)) continue;
                        List<Double> wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                        if (HussarUtils.isEmpty(wh)) {
                            LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u5ba1\u6279\u610f\u89c1\u7b7e\u540d\u53c2\u6570\u6709\u8bef", (Object)tempString);
                        }
                        try {
                            aRun.addPicture((InputStream)inputStream, this.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", wh.get(0).intValue() * 36000, wh.get(1).intValue() * 36000);
                        }
                        catch (Exception e) {
                            LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        }
                        continue;
                    }
                    int index = signature.indexOf(",");
                    signature = signature.substring(index + 1);
                    ByteArrayInputStream inputStream = null;
                    try {
                        Base64.Decoder decoder = Base64.getDecoder();
                        byte[] b = decoder.decode(signature);
                        inputStream = new ByteArrayInputStream(b);
                    }
                    catch (Exception e) {
                        LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    if (!HussarUtils.isNotEmpty((Object)inputStream)) continue;
                    try {
                        aRun.addPicture((InputStream)inputStream, this.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", 647700, 236220);
                    }
                    catch (Exception e) {
                        LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    continue;
                }
                Object name = jsonObject.get((Object)"userName");
                if (!HussarUtils.isNotEmpty((Object)name)) continue;
                String userName = String.valueOf(name);
                aRun.setText(userName, position + ++add);
            }
        } else {
            String img = "<img width=\"68\" height=\"25\" src=";
            String[] split = tempString.split("\\|");
            if (split.length > 1) {
                String size = split[1];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains("fixed")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                double widthToHeight = 0.0;
                if (split1.length == 2) {
                    List<Double> wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                    if (HussarUtils.isEmpty(wh)) {
                        LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u5ba1\u6279\u610f\u89c1\u7b7e\u540d\u53c2\u6570\u6709\u8bef", (Object)tempString);
                    }
                    Double widthD = wh.get(0) / 25.4 * 96.0;
                    Double heightD = wh.get(1) / 25.4 * 96.0;
                    img = "<img width=" + widthD + " height=" + heightD + " src=";
                }
            }
            String group = matcher.group().replace("{", "").replace("}", "");
            String html = richTextMap.get(group);
            html = html.replace("<imgsrc=", img);
            richTextMap.put(group, html);
            aRun.setText(replaceText, position);
        }
        return add;
    }

    private int handleTextArea(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        int add = 0;
        if (replaceText.contains("\n")) {
            String[] strings = replaceText.split("\\n");
            aRun.setText(strings[0], position);
            for (int i = 1; i < strings.length; ++i) {
                aRun.addBreak();
                aRun.setText(strings[i], position + ++add);
            }
        } else {
            aRun.setText(replaceText, position);
        }
        return add;
    }

    private void handleSelect(Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        if (!this.wordPrintProperties.isSelectionBoxEnable()) {
            aRun.setText(replaceText, position);
        } else {
            JSONObject jsonObject;
            Object idObjs;
            String childName;
            String sub = tempString.substring(tempString.indexOf("#") + 1, tempString.indexOf("}"));
            if (sub.contains("|")) {
                sub = sub.split("\\|")[0];
            }
            if (sub.contains(".")) {
                childName = sub.split("\\.")[0];
                sub = sub.split("\\.")[1];
            } else {
                childName = "";
            }
            String substring = sub;
            String widgetsStr = widgets.get("widgetsStr");
            JSONArray jsonArray = JSON.parseArray((String)widgetsStr);
            ArrayList<String> ids = new ArrayList<String>();
            String idKey = substring + "_value";
            Object dataValue = param.get(DATA_VALUE);
            if (HussarUtils.isNotEmpty((Object)dataValue) && HussarUtils.isNotEmpty((Object)(idObjs = (jsonObject = (JSONObject)dataValue).get((Object)idKey)))) {
                String idStr = String.valueOf(idObjs);
                String[] idArr = idStr.split(",");
                ids.addAll(Arrays.asList(idArr));
            }
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<String> boxs = new ArrayList<String>(ids.size());
            ArrayList optionList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)replaceText)) {
                String[] checkBox = replaceText.split(",");
                boxs.addAll(Arrays.asList(checkBox));
            }
            jsonArray.forEach(obj -> {
                Object object;
                JSONObject jsonObject;
                if (obj instanceof JSONObject && (jsonObject = (JSONObject)obj).get((Object)"name").equals(substring) && (object = jsonObject.get((Object)"props")) instanceof JSONObject) {
                    JSONObject props = (JSONObject)object;
                    Object optionType = props.get((Object)OPTION_TYPE_KEY);
                    if (HussarUtils.isNotEmpty((Object)optionType) && !HussarUtils.equals((Object)optionType, (Object)STATIC_KEY)) {
                        String optionTypeS;
                        switch (optionTypeS = String.valueOf(optionType)) {
                            case "dict": {
                                this.useDict(props, optionList, ids, boxs);
                                break;
                            }
                            case "async": {
                                this.useAsync(props, optionList, ids, boxs);
                                break;
                            }
                            case "dataLinkage": {
                                this.useDataLinkage(props, optionList, ids, boxs);
                                break;
                            }
                        }
                    } else {
                        Object options = props.get((Object)OPTIONS_KEY);
                        if (options instanceof JSONArray) {
                            JSONArray jsonArray1 = (JSONArray)options;
                            jsonArray1.forEach(obj1 -> {
                                if (obj1 instanceof JSONObject) {
                                    optionList.add(obj1);
                                }
                            });
                        }
                    }
                }
            });
            block0: for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                for (Object object : optionList) {
                    String valueStr;
                    if (!(object instanceof JSONObject)) continue;
                    JSONObject jsonObject2 = (JSONObject)object;
                    Object value = jsonObject2.get((Object)"value");
                    Object label = jsonObject2.get((Object)"label");
                    if (!(value instanceof String) || !(label instanceof String) || !(valueStr = String.valueOf(value)).equals(id)) continue;
                    String box = (String)boxs.get(i);
                    jsonObject2.put("label", (Object)box);
                    continue block0;
                }
            }
            for (Object object : optionList) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject jsonObject3 = (JSONObject)object;
                Object value = jsonObject3.get((Object)"value");
                Object label = jsonObject3.get((Object)"label");
                if (!(value instanceof String) || !(label instanceof String)) continue;
                String valueStr = String.valueOf(value);
                String labelStr = String.valueOf(label);
                values.add(valueStr);
                labels.add(labelStr);
            }
            StringBuilder checkBoxText = new StringBuilder();
            ArrayList<Integer> find = new ArrayList<Integer>();
            for (String label : labels) {
                boolean isFind = false;
                for (String box : boxs) {
                    if (!label.equals(box)) continue;
                    checkBoxText.append("R").append(label).append("      ");
                    find.add(boxs.indexOf(box));
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                checkBoxText.append("\u00a3").append(label).append("      ");
            }
            for (String box : boxs) {
                int index = boxs.indexOf(box);
                if (find.contains(index)) continue;
                checkBoxText.append("R").append(box).append("      ");
            }
            if (HussarUtils.isNotEmpty((Object)checkBoxText)) {
                aRun.setText((tempString.contains("|vertical") ? "\uffe5\uffe5" : "\uffe5") + checkBoxText, position);
            } else {
                aRun.setText("", position);
            }
        }
    }

    public void useDataLinkage(JSONObject props, List<Object> optionList, List<String> ids, List<String> boxs) {
        try {
            Map dataLinkageMap = (Map)props.get((Object)DATA_LINK_AGE_KEY);
            Map filterMap = (Map)dataLinkageMap.get("filter");
            Map dataMap = (Map)dataLinkageMap.get("data");
            String formId = dataMap.get("formId").toString();
            String appId = dataMap.get("appId").toString();
            String fieldName = dataMap.get("fieldName").toString();
            Object parentKey = dataMap.get("parentKey");
            if (HussarUtils.isNotEmpty((Object)appId) && HussarUtils.isNotEmpty((Object)formId) && HussarUtils.isNotEmpty((Object)fieldName)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (HussarUtils.isNotEmpty(parentKey)) {
                    params.put("$REVERSE_CHILD", String.valueOf(parentKey));
                }
                params.put("current", 1);
                params.put("orders", new ArrayList());
                params.put("size", 50);
                ArrayList<Filter> superQueryConditionDto = new ArrayList<Filter>();
                Filter filter = new Filter();
                filter.setRule("_isNotNull");
                filter.setMatch("AND");
                filter.setVal("");
                filter.setField(fieldName);
                superQueryConditionDto.add(filter);
                Object conditions = filterMap.get("conditions");
                if (HussarUtils.isNotEmpty(conditions) && conditions instanceof List) {
                    List conditionList = (List)conditions;
                    for (Map map : conditionList) {
                        String field = String.valueOf(map.get("field"));
                        String method = String.valueOf(map.get("method"));
                        Object value = map.get("value");
                        Object parent = map.get("parent");
                        if (HussarUtils.isNotEmpty(parent)) {
                            field = String.valueOf(parent) + "." + field;
                        }
                        Filter filterCondition = new Filter();
                        switch (method) {
                            case "IS_NULL": {
                                method = "_isNull";
                                break;
                            }
                            case "IS_NOT_NULL": {
                                method = "_isNotNull";
                                break;
                            }
                        }
                        filterCondition.setRule(method);
                        filterCondition.setMatch("AND");
                        filterCondition.setVal(HussarUtils.isNotEmpty(value) ? String.valueOf(value) : "");
                        filterCondition.setField(String.valueOf(field));
                        superQueryConditionDto.add(filterCondition);
                    }
                }
                params.put("superQueryConditionDto", superQueryConditionDto);
                ApiResponse queryBusinessDataVoApiResponse = this.hussarAppDataSourceService.queryAppBusinessData(String.valueOf(formId), String.valueOf(appId), params);
                QueryBusinessDataVo data = (QueryBusinessDataVo)queryBusinessDataVoApiResponse.getData();
                if (HussarUtils.isNotEmpty((Object)data) && HussarUtils.isNotEmpty((Object)data.getBusinessData()) && HussarUtils.isNotEmpty((Object)((PageVo)data.getBusinessData()).getData())) {
                    List list = ((PageVo)data.getBusinessData()).getData();
                    ArrayList<String> values = new ArrayList<String>();
                    if (HussarUtils.isNotEmpty((Object)list)) {
                        Object o;
                        if (HussarUtils.isNotEmpty(parentKey)) {
                            for (Map map : list) {
                                o = map.get(String.valueOf(parentKey));
                                if (!HussarUtils.isNotEmpty(o)) continue;
                                List listChild = (List)o;
                                for (Map mapChild : listChild) {
                                    String value;
                                    Object object = mapChild.get(String.valueOf(fieldName));
                                    if (!HussarUtils.isNotEmpty(object) || values.contains(value = String.valueOf(object))) continue;
                                    values.add(value);
                                    JSONObject op = new JSONObject();
                                    op.put("label", (Object)value);
                                    op.put("value", (Object)value);
                                    optionList.add(op);
                                }
                            }
                        } else {
                            for (Map map : list) {
                                String value;
                                o = map.get(fieldName + "_label");
                                if (!HussarUtils.isNotEmpty(o) || values.contains(value = String.valueOf(o))) continue;
                                values.add(value);
                                JSONObject op = new JSONObject();
                                op.put("label", (Object)value);
                                op.put("value", (Object)value);
                                optionList.add(op);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316\u5f02\u5e38", (Throwable)e);
            LOGGER.error("\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316\u5f02\u5e38,props:{}", (Object)JSON.toJSONString((Object)props));
        }
    }

    public void useDict(JSONObject props, List<Object> optionList, List<String> ids, List<String> boxs) {
        Object dictObj = props.get((Object)DICT_KEY);
        Object openOther = props.get((Object)"openOther");
        JSONObject dict = (JSONObject)dictObj;
        Object dictId = dict.get((Object)"dictId");
        Object dictTypeId = dict.get((Object)"dictTypeId");
        if (HussarUtils.isNotEmpty((Object)dictId) && HussarUtils.isNotEmpty((Object)dictTypeId)) {
            List dicLevelTreeVos = this.dictDataSourceService.queryDictOptions(Long.valueOf(String.valueOf(dictId)));
            for (DicLevelTreeVo dicLevelTreeVo : dicLevelTreeVos) {
                if (!HussarUtils.equals((Object)dicLevelTreeVo.getIfUse(), (Object)"1")) continue;
                String label = dicLevelTreeVo.getLabel();
                String value = dicLevelTreeVo.getValue();
                JSONObject dicJson = new JSONObject();
                dicJson.put("label", (Object)label);
                dicJson.put("value", (Object)value);
                optionList.add(dicJson);
            }
        }
        if (HussarUtils.equals((Object)openOther, (Object)true)) {
            JSONObject other = new JSONObject();
            other.put("value", (Object)"__other__");
            other.put("label", (Object)"\u5176\u4ed6");
            optionList.add(other);
            if (ids.contains("__other__")) {
                if (HussarUtils.isNotEmpty(boxs)) {
                    int index = ids.indexOf("__other__");
                    while (boxs.size() <= index) {
                        boxs.add("");
                    }
                    String box = boxs.get(index);
                    if (HussarUtils.isEmpty((Object)box)) {
                        box = "\u5176\u4ed6";
                        boxs.set(index, box);
                    }
                } else {
                    boxs.add("\u5176\u4ed6");
                }
            }
        }
    }

    private void handleFile(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        JSONArray parse = (JSONArray)JSON.parse((String)replaceText);
        if (HussarUtils.isNotEmpty((Object)parse)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parse.size() - 1; ++i) {
                JSONObject o = (JSONObject)parse.get(i);
                String fileName = String.valueOf(o.get((Object)"name"));
                sb.append(fileName).append(",");
            }
            String fileNameLast = String.valueOf(((JSONObject)parse.get(parse.size() - 1)).get((Object)"name"));
            sb.append(fileNameLast);
            replaceText = sb.toString();
        }
        aRun.setText(replaceText, position);
    }

    private static void insertCode(String tempString, String mode, String replaceText, int width, int height, BarcodeFormat barcodeFormat, XWPFRun aRun, ErrorCorrectionLevel errorCorrectionLevel) {
        try {
            BufferedImage bufferedImage = GenerateCode.generateCode(replaceText, mode, barcodeFormat, errorCorrectionLevel);
            if (HussarUtils.isNotEmpty((Object)bufferedImage)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                aRun.addPicture((InputStream)byteArrayInputStream, 6, mode, width * 36000, height * 36000);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u4e8c\u7ef4\u7801/\u6761\u5f62\u7801\u751f\u6210\u5931\u8d25", (Object)tempString);
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    public int judgeImgType(String type) {
        if ("EMF".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("WMF".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("PICT".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("JPEG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("DIB".equalsIgnoreCase(type)) {
            return 7;
        }
        if ("GIF".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("TIFF".equalsIgnoreCase(type)) {
            return 9;
        }
        if ("EPS".equalsIgnoreCase(type)) {
            return 10;
        }
        if ("BMP".equalsIgnoreCase(type)) {
            return 11;
        }
        if ("WPG".equalsIgnoreCase(type)) {
            return 12;
        }
        LOGGER.error("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u7c7b\u578b\uff1a{},\u5df2\u81ea\u52a8\u8f6c\u4e3aPNG\u683c\u5f0f", (Object)type);
        return 6;
    }

    public XWPFDocument generateWord(Map<String, Object> param, XWPFDocument doc, Map<String, String> widgets, JSONObject parse, Map<String, String> richTextMap) {
        try {
            if (param != null) {
                param.put(DATA_VALUE, parse);
                this.analysisPlaceholder(doc, widgets);
                WordHandle.getFormData(HASH_MAP, parse);
                this.replaceInPara(doc, param, widgets, richTextMap);
                if (HussarUtils.isNotEmpty((Object)parse.get((Object)"exportType"))) {
                    this.wordExportHandlePre(doc, widgets);
                }
                this.analysisTable(doc);
                WordHandle.getFormData(HASH_MAP, parse);
                this.replaceInTable(doc, param, widgets, richTextMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u6570\u636e{} \u66ff\u6362\u5931\u8d25", param);
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
        return doc;
    }

    public XWPFDocument generateWordForRichText(Map<String, Object> param, XWPFDocument doc, Map<String, String> widgets, JSONObject parse, Map<String, String> richTextMap) {
        try {
            if (param != null) {
                this.analysisPlaceholder(doc, widgets);
                WordHandle.getFormData(HASH_MAP, parse);
                this.replaceInParaForRichText(doc, param, widgets, richTextMap);
                this.analysisTable(doc);
                WordHandle.getFormData(HASH_MAP, parse);
                this.replaceInTableForRichText(doc, param, widgets, richTextMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u6570\u636e{} \u66ff\u6362\u5931\u8d25", param);
            throw new BaseException((Throwable)e);
        }
        return doc;
    }

    private void replaceInPara(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList paragraphs = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        List xwpfFooters = doc.getFooterList();
        pageHeaders.forEach(header -> paragraphs.addAll(header.getParagraphs()));
        xwpfFooters.forEach(footer -> paragraphs.addAll(footer.getParagraphs()));
        paragraphs.addAll(doc.getParagraphs());
        for (XWPFParagraph para : paragraphs) {
            try {
                this.wpsHandlePara(para, doc);
                this.replaceInPara(doc, para, params, widgets, richTextMap);
                if (!this.wordPrintProperties.isSelectionBoxEnable()) continue;
                this.replaceSelect(para, params, widgets);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("word\u6a21\u677f\u6253\u5370\u6587\u6863{} \u4e0d\u5b58\u5728", (Object)doc);
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void replaceInParaForRichText(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList paragraphs = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        pageHeaders.forEach(header -> paragraphs.addAll(header.getParagraphs()));
        paragraphs.addAll(doc.getParagraphs());
        for (XWPFParagraph para : paragraphs) {
            try {
                this.replaceInParaForRichText(para, params, widgets, richTextMap);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("word\u6a21\u677f\u6253\u5370\u6587\u6863{} \u4e0d\u5b58\u5728", (Object)doc);
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void replaceSelect(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets) {
        boolean isVertical = false;
        if (para.getParagraphText().contains("\uffe5\uffe5")) {
            try {
                CTInd ind = para.getCTP().getPPr().getInd();
                BigInteger firstLine = ind.getFirstLine();
                LOGGER.info("firstLine:{}", (Object)firstLine);
                ind.setLeft(firstLine);
                if (ind.isSetFirstLineChars()) {
                    ind.unsetFirstLineChars();
                }
                if (ind.isSetFirstLine()) {
                    ind.unsetFirstLine();
                }
            }
            catch (Exception e) {
                LOGGER.error("\u8bbe\u7f6eind.setLeft\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                LOGGER.info("\u8bbe\u7f6eind.setLeft\u5931\u8d25:{}", (Object)para.getParagraphText());
            }
            isVertical = true;
        }
        if (para.getParagraphText().contains("\uffe5")) {
            List runR = para.getRuns();
            int fontSize = ((XWPFRun)runR.get(0)).getFontSize();
            HashMap listMap = new HashMap();
            int size = runR.size();
            for (int i = 0; i < size; ++i) {
                int r = 0;
                XWPFRun xwpfRun2 = (XWPFRun)runR.get(i);
                String text = xwpfRun2.text();
                if (!text.contains("\uffe5") || !text.contains("R") && !text.contains("\u00a3")) continue;
                ArrayList<Integer> indexList = new ArrayList<Integer>();
                int k = 0;
                while (HussarUtils.isNotEmpty((Object)xwpfRun2.text())) {
                    xwpfRun2.setText("", k);
                    ++k;
                }
                boolean isFind = false;
                int start = 0;
                for (int s = 0; s < text.length(); ++s) {
                    XWPFRun run2;
                    String substring;
                    char ch = text.charAt(s);
                    if (!isFind) {
                        if (ch != 'R' && ch != '\u00a3') continue;
                        start = s;
                        isFind = true;
                        XWPFRun run3 = para.insertNewRun(i + ++r);
                        indexList.add(runR.indexOf(run3));
                        run3.setText(String.valueOf(ch));
                        continue;
                    }
                    if (ch == 'R' || ch == '\u00a3') {
                        int end = s--;
                        substring = text.substring(start + 1, end);
                        run2 = para.insertNewRun(i + ++r);
                        indexList.add(runR.indexOf(run2));
                        run2.setText(substring);
                        isFind = false;
                    }
                    if (s != text.length() - 1) continue;
                    substring = text.substring(start + 1);
                    run2 = para.insertNewRun(i + ++r);
                    indexList.add(runR.indexOf(run2));
                    run2.setText(substring);
                }
                size = runR.size();
                listMap.put(i += r, indexList);
            }
            ArrayList runList = new ArrayList(runR);
            LinkedHashMap map = new LinkedHashMap();
            runList.forEach(xwpfRun -> {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put(xwpfRun.text(), xwpfRun.getFontFamily());
                map.put(runList.indexOf(xwpfRun), map1);
            });
            runR.forEach(run -> {
                int i = runR.indexOf(run);
                Map map1 = (Map)map.get(i);
                run.setText("", 0);
                String text = "";
                String font = null;
                for (String key : map1.keySet()) {
                    if (!key.equals("\uffe5")) {
                        text = key;
                    }
                    font = (String)map1.get(key);
                }
                run.setText(text);
            });
            int indexBreak = 0;
            for (XWPFRun xwpfRun3 : runR) {
                this.setFontSize(fontSize, xwpfRun3);
                if (xwpfRun3.text().equals("R") || xwpfRun3.text().equals("\u00a3") || xwpfRun3.text().isEmpty()) {
                    CTFonts font = xwpfRun3.getCTR().addNewRPr().addNewRFonts();
                    font.setAscii("Wingdings 2");
                    font.setCs("Wingdings 2");
                    font.setEastAsia("Wingdings 2");
                    font.setHAnsi("Wingdings 2");
                }
                if (!xwpfRun3.text().equals("R") && !xwpfRun3.text().equals("\u00a3") || !isVertical) continue;
                if (indexBreak != 0) {
                    int index = runR.indexOf(xwpfRun3);
                    XWPFRun run4 = (XWPFRun)runR.get(index - 1);
                    run4.addBreak();
                }
                ++indexBreak;
            }
        }
    }

    public String replaceText(String text, Map<String, Object> map) {
        Matcher matcher;
        String replaceText = text;
        if (text != null && (matcher = this.matcher(text)).find()) {
            while ((matcher = this.matcher(text)).find()) {
                String group = matcher.group();
                if (map.containsKey(group)) {
                    String value = String.valueOf(map.get(group));
                    text = replaceText = matcher.replaceFirst(Matcher.quoteReplacement(value));
                    continue;
                }
                text = matcher.replaceFirst("");
            }
            if ("null".equals(text)) {
                replaceText = "";
            }
        }
        return replaceText;
    }

    private void setFontSize(int size, XWPFRun run) {
        if (size != -1) {
            run.setFontSize(size);
        }
    }

    private void replaceInTable(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList tables = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        pageHeaders.forEach(header -> tables.addAll(header.getTables()));
        tables.addAll(doc.getTables());
        for (XWPFTable table : tables) {
            String granMapStr;
            JSONObject granMap;
            if (this.judgeContainsGran(table, widgets, granMap = JSON.parseObject((String)(granMapStr = widgets.get(GRAN_MAP))))) {
                LOGGER.info("\u8be5\u8868\u683c\u542b\u6709\u5b59\u8868\u5b57\u6bb5,\u8868\u683c\u5185\u5bb9:{}", (Object)table.getText());
                this.handleTableContainsGran(doc, table, widgets, granMap, params);
                continue;
            }
            this.handleTable(doc, table, params, widgets, richTextMap);
        }
    }

    private void handleTableContainsGran(XWPFDocument doc, XWPFTable table, Map<String, String> widgets, JSONObject granMap, Map<String, Object> params) {
        try {
            JSONObject widgetLevel = JSON.parseObject((String)widgets.get(WIDGET_LEVEL));
            JSONObject parse = (JSONObject)params.get(DATA_VALUE);
            List rows = table.getRows();
            HashSet<Integer> removeRows = new HashSet<Integer>();
            for (int k = 0; k < rows.size(); ++k) {
                XWPFTableRow row = (XWPFTableRow)rows.get(k);
                List cells = row.getTableCells();
                ArrayList<String> allGroup = new ArrayList<String>();
                ArrayList<String> allChildGroup = new ArrayList<String>();
                HashMap<Integer, List<XWPFTableCell>> cellLevelMap = new HashMap<Integer, List<XWPFTableCell>>();
                ArrayList<XWPFTableCell> levelCells0 = new ArrayList<XWPFTableCell>();
                ArrayList<XWPFTableCell> levelCells1 = new ArrayList<XWPFTableCell>();
                ArrayList<XWPFTableCell> levelCells2 = new ArrayList<XWPFTableCell>();
                cellLevelMap.put(CellLevel.HOST.getLevel(), levelCells0);
                cellLevelMap.put(CellLevel.CHILD.getLevel(), levelCells1);
                cellLevelMap.put(CellLevel.SUN.getLevel(), levelCells2);
                this.preHandleContainsGran(granMap, cells, widgetLevel, allGroup, allChildGroup, levelCells0, levelCells1, levelCells2);
                if (HussarUtils.isNotEmpty(allGroup) && HussarUtils.isNotEmpty(allChildGroup)) {
                    removeRows.add(k);
                }
                HashMap<JSONObject, Integer> childRowNumMap = new HashMap<JSONObject, Integer>();
                HashMap<String, String> granToChildMap = new HashMap<String, String>();
                ArrayList<String> childList = new ArrayList<String>();
                this.getChildMaxRow(cells, childRowNumMap, granToChildMap, granMap, parse, childList);
                int maxAddRow = 0;
                if (!((List)cellLevelMap.get(CellLevel.CHILD.getLevel())).isEmpty() || !((List)cellLevelMap.get(CellLevel.SUN.getLevel())).isEmpty()) {
                    LOGGER.info("\u8be5\u884c\u542b\u6709\u5b50\u8868\u6216\u5b59\u8868\u6a21\u677f");
                    maxAddRow = this.childCellHandle(cellLevelMap, cells, doc, table, widgets, granMap, granToChildMap, parse, maxAddRow, k, childRowNumMap);
                    maxAddRow = this.sunCellHandle(cellLevelMap, cells, doc, table, widgets, granMap, granToChildMap, parse, maxAddRow, k, childRowNumMap, childList);
                    this.hostCellHandle(cellLevelMap, cells, doc, table, widgets, parse, maxAddRow, k);
                    continue;
                }
                if (((List)cellLevelMap.get(CellLevel.HOST.getLevel())).isEmpty()) continue;
                LOGGER.info("\u8be5\u884c\u6ca1\u6709\u5b50\u8868\u6216\u5b59\u8868\u6a21\u677f\uff0c\u542b\u6709\u4e3b\u8868\u7ea7\u522b\u5355\u5143\u683c");
                List tableCells = row.getTableCells();
                for (XWPFTableCell cell : tableCells) {
                    List paragraphs = cell.getParagraphs();
                    for (XWPFParagraph para : paragraphs) {
                        try {
                            this.wpsHandlePara(para, doc);
                            this.replaceInPara(doc, para, params, widgets, null);
                            if (!this.wordPrintProperties.isSelectionBoxEnable()) continue;
                            this.replaceSelect(para, params, widgets);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error("\u5355\u884c\u6570\u636e\u8868\u683c\u5904\u7406\u5931\u8d25");
                            throw new BaseException((Throwable)e);
                        }
                    }
                }
            }
            this.removeRows(removeRows, table);
        }
        catch (Exception e) {
            LOGGER.error("handleTableContainsGran\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void preHandleContainsGran(JSONObject granMap, List<XWPFTableCell> cells, JSONObject widgetLevel, List<String> allGroup, List<String> allChildGroup, List<XWPFTableCell> levelCells0, List<XWPFTableCell> levelCells1, List<XWPFTableCell> levelCells2) {
        for (XWPFTableCell cell : cells) {
            String text = cell.getText();
            Matcher matcher = this.matcher(text);
            ArrayList<String> tableWidgets = new ArrayList<String>();
            int level = CellLevel.HOST.getLevel();
            while (matcher.find()) {
                int endIndex;
                String group = matcher.group();
                allGroup.add(group);
                int startIndex = group.indexOf(35) + 1;
                String result = group.substring(startIndex, endIndex = group.indexOf(125));
                if (!result.contains(".")) continue;
                allChildGroup.add(group);
                String[] split = result.split("\\.");
                String split0 = split[0];
                if (!HussarUtils.isNotEmpty((Object)widgetLevel.get((Object)split0))) continue;
                level = Math.max((Integer)widgetLevel.get((Object)split0), level);
                if (tableWidgets.contains(split0)) continue;
                tableWidgets.add(split0);
            }
            this.judgeCrossAndHandle(tableWidgets, cell, granMap);
            switch (level) {
                case 0: {
                    levelCells0.add(cell);
                    break;
                }
                case 1: {
                    levelCells1.add(cell);
                    break;
                }
                case 2: {
                    levelCells2.add(cell);
                }
            }
        }
    }

    private void getChildMaxRow(List<XWPFTableCell> cells, Map<JSONObject, Integer> childRowNumMap, Map<String, String> granToChildMap, JSONObject granMap, JSONObject parse, List<String> childList) {
        HashMap childMap = new HashMap();
        for (XWPFTableCell cell : cells) {
            String text = cell.getText();
            Matcher matcher = this.matcher(text);
            while (matcher.find()) {
                int endIndex;
                int startIndex;
                String group = matcher.group();
                String result = group.substring(startIndex = group.indexOf(35) + 1, endIndex = group.indexOf(125));
                if (!result.contains(".")) continue;
                String[] split = result.split("\\.");
                String split0 = split[0];
                if (HussarUtils.isNotEmpty((Object)granMap.get((Object)split0))) {
                    String childStr = String.valueOf(granMap.get((Object)split0));
                    granToChildMap.put(childStr, split0);
                    if (childMap.containsKey(childStr)) {
                        List list = (List)childMap.get(childStr);
                        if (list.contains(split0)) continue;
                        list.add(split0);
                        continue;
                    }
                    ArrayList<String> childStrList = new ArrayList<String>();
                    childStrList.add(split0);
                    childMap.put(childStr, childStrList);
                    continue;
                }
                childList.add(split0);
            }
        }
        for (String childStr : childMap.keySet()) {
            JSONArray childArr = (JSONArray)parse.get((Object)childStr);
            List granList = (List)childMap.get(childStr);
            for (Object obj : childArr) {
                JSONObject childOb = (JSONObject)obj;
                childRowNumMap.put(childOb, 1);
                for (String gran : granList) {
                    JSONArray granArr = (JSONArray)childOb.get((Object)gran);
                    childRowNumMap.put(childOb, Math.max(granArr.size(), childRowNumMap.get(childOb)));
                }
            }
        }
    }

    private int sunCellHandle(Map<Integer, List<XWPFTableCell>> cellLevelMap, List<XWPFTableCell> cells, XWPFDocument doc, XWPFTable table, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap, List<String> childList) {
        List<XWPFTableCell> granXwpfTableCells = cellLevelMap.get(CellLevel.SUN.getLevel());
        for (XWPFTableCell xwpfTableCell : granXwpfTableCells) {
            int cellIndex = cells.indexOf(xwpfTableCell);
            String text = xwpfTableCell.getText();
            Matcher matcher = this.matcher(text);
            String granStr = "";
            String childStr = "";
            JSONArray childArray = new JSONArray();
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<String> groups = new ArrayList<String>();
            while (matcher.find()) {
                String[] split;
                String split0;
                int endIndex;
                String group = matcher.group();
                groups.add(group);
                int startIndex = group.indexOf(35) + 1;
                String result = group.substring(startIndex, endIndex = group.indexOf(125));
                if (!result.contains(".") || !HussarUtils.isNotEmpty((Object)granMap.get((Object)(split0 = (split = result.split("\\."))[0])))) continue;
                granStr = split0;
                childStr = (String)granMap.get((Object)split0);
                granToChildMap.put(childStr, granStr);
                Object childO = parse.get((Object)childStr);
                childArray = (JSONArray)childO;
            }
            int addNum = 0;
            for (Object object : childArray) {
                JSONObject granJsonObj;
                JSONObject childOb = (JSONObject)object;
                JSONArray granArr = (JSONArray)childOb.get((Object)granStr);
                if (childList.contains(childStr)) {
                    int childMaxRow = childRowNumMap.get(childOb);
                    for (int i = 0; i < childMaxRow; ++i) {
                        ++addNum;
                        if (i < granArr.size()) {
                            granJsonObj = (JSONObject)granArr.get(i);
                            XWPFTableRow row = table.getRow(k + addNum);
                            this.newRowAddCell(cells, row);
                            XWPFTableCell newRowCell = row.getCell(cellIndex);
                            this.getValueByGroups(groups, map, granMap, granJsonObj, childOb, parse);
                            this.replaceCell(newRowCell, xwpfTableCell, doc, map, widgets, null);
                            continue;
                        }
                        XWPFTableRow row = table.getRow(k + addNum);
                        this.newRowAddCell(cells, row);
                        XWPFTableCell newRowCell = row.getCell(cellIndex);
                        this.copyCellStyle(xwpfTableCell, newRowCell);
                    }
                    continue;
                }
                for (Object o : granArr) {
                    granJsonObj = (JSONObject)o;
                    this.getValueByGroups(groups, map, granMap, granJsonObj, childOb, parse);
                    maxAddRow = this.replaceCellComposite(maxAddRow, ++addNum, table, cells, xwpfTableCell, cellIndex, map, doc, widgets, k);
                }
            }
        }
        return maxAddRow;
    }

    private int childCellHandle(Map<Integer, List<XWPFTableCell>> cellLevelMap, List<XWPFTableCell> cells, XWPFDocument doc, XWPFTable table, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap) {
        List<XWPFTableCell> childXwpfTableCells = cellLevelMap.get(CellLevel.CHILD.getLevel());
        for (XWPFTableCell xwpfTableCell : childXwpfTableCells) {
            int cellIndex = cells.indexOf(xwpfTableCell);
            String text = xwpfTableCell.getText();
            Matcher matcher = this.matcher(text);
            String childStr = "";
            JSONArray childArray = new JSONArray();
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<String> groups = new ArrayList<String>();
            while (matcher.find()) {
                String[] split;
                String split0;
                int endIndex;
                String group = matcher.group();
                groups.add(group);
                int startIndex = group.indexOf(35) + 1;
                String result = group.substring(startIndex, endIndex = group.indexOf(125));
                if (!result.contains(".") || !HussarUtils.isEmpty((Object)granMap.get((Object)(split0 = (split = result.split("\\."))[0])))) continue;
                childStr = split0;
                Object childO = parse.get((Object)childStr);
                childArray = (JSONArray)childO;
            }
            int addNum = 0;
            for (Object child : childArray) {
                JSONObject childObj = (JSONObject)child;
                this.getValueByGroups(groups, map, granMap, null, childObj, parse);
                if (granToChildMap.containsKey(childStr)) {
                    int maxChildRow = childRowNumMap.get(childObj);
                    for (int i = 0; i < maxChildRow; ++i) {
                        maxAddRow = this.replaceCellComposite(maxAddRow, ++addNum, table, cells, xwpfTableCell, cellIndex, map, doc, widgets, k);
                    }
                    continue;
                }
                maxAddRow = this.replaceCellComposite(maxAddRow, ++addNum, table, cells, xwpfTableCell, cellIndex, map, doc, widgets, k);
            }
        }
        return maxAddRow;
    }

    private void hostCellHandle(Map<Integer, List<XWPFTableCell>> cellLevelMap, List<XWPFTableCell> cells, XWPFDocument doc, XWPFTable table, Map<String, String> widgets, JSONObject parse, int maxAddRow, int k) {
        List<XWPFTableCell> xwpfTableCells = cellLevelMap.get(CellLevel.HOST.getLevel());
        for (XWPFTableCell xwpfTableCell : xwpfTableCells) {
            int cellIndex = cells.indexOf(xwpfTableCell);
            String text = xwpfTableCell.getText();
            ArrayList<String> groups = new ArrayList<String>();
            Matcher matcher = this.matcher(text);
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (matcher.find()) {
                int endIndex;
                String group = matcher.group();
                groups.add(group);
                int startIndex = group.indexOf(35) + 1;
                String result = group.substring(startIndex, endIndex = group.indexOf(125));
                if (result.contains(".")) continue;
                if (result.contains("|")) {
                    String[] split = result.split("\\|");
                    result = split[0];
                }
                map.put(group, parse.get((Object)result));
            }
            if (maxAddRow > 0) {
                for (int i = 0; i < maxAddRow; ++i) {
                    XWPFTableRow tableRow = table.getRow(k + i + 1);
                    this.newRowAddCell(cells, tableRow);
                    XWPFTableCell tableCell = tableRow.getCell(cellIndex);
                    this.replaceCell(tableCell, xwpfTableCell, doc, map, widgets, null);
                }
                continue;
            }
            if (groups.isEmpty()) continue;
            XWPFTableRow tableRow = table.insertNewTableRow(k + ++maxAddRow);
            this.newRowAddCell(cells, tableRow);
            XWPFTableCell tableCell = tableRow.getCell(cellIndex);
            this.replaceCell(tableCell, xwpfTableCell, doc, map, widgets, null);
        }
    }

    private int replaceCellComposite(int maxAddRow, int addNum, XWPFTable table, List<XWPFTableCell> cells, XWPFTableCell xwpfTableCell, int cellIndex, Map<String, Object> map, XWPFDocument doc, Map<String, String> widgets, int k) {
        XWPFTableRow newRow;
        if (maxAddRow >= addNum) {
            newRow = table.getRow(k + addNum);
        } else {
            newRow = table.insertNewTableRow(k + addNum);
            ++maxAddRow;
        }
        this.newRowAddCell(cells, newRow);
        XWPFTableCell newRowCell = newRow.getCell(cellIndex);
        this.replaceCell(newRowCell, xwpfTableCell, doc, map, widgets, null);
        return maxAddRow;
    }

    private void newRowAddCell(List<XWPFTableCell> cells, XWPFTableRow newRow) {
        int size = cells.size();
        while (newRow.getTableCells().size() != size) {
            newRow.addNewTableCell();
        }
    }

    public void getValueByGroups(List<String> groups, Map<String, Object> map, JSONObject granMap, JSONObject granJsonObject, JSONObject childJsonObject, JSONObject parse) {
        for (String group : groups) {
            int endIndex;
            int startIndex;
            String result = group.substring(startIndex = group.indexOf(35) + 1, endIndex = group.indexOf(125));
            if (result.contains(".")) {
                String[] split = result.split("\\.");
                String split0 = split[0];
                String spilt1 = split[1].trim();
                if (result.contains("|")) {
                    String[] splitImage = spilt1.split("\\|");
                    spilt1 = splitImage[0];
                }
                if (HussarUtils.isNotEmpty((Object)granMap.get((Object)split0))) {
                    map.put(group, granJsonObject.get((Object)spilt1));
                    continue;
                }
                map.put(group, childJsonObject.get((Object)spilt1));
                continue;
            }
            if (result.contains("|")) {
                String[] splitImage = result.split("\\|");
                result = splitImage[0];
            }
            map.put(group, parse.get((Object)result));
        }
    }

    private void judgeCrossAndHandle(List<String> tableWidgets, XWPFTableCell cell, JSONObject granMap) {
        granMap.put("flowHistoryInfo", (Object)"");
        boolean isCross = true;
        if (tableWidgets.size() < 2) {
            isCross = false;
        } else if (tableWidgets.size() == 2) {
            String tableWidget0 = tableWidgets.get(0);
            String tableWidget1 = tableWidgets.get(1);
            boolean bl = isCross = !granMap.get((Object)tableWidget0).equals(tableWidget1) && !granMap.get((Object)tableWidget1).equals(tableWidget0);
        }
        if (isCross) {
            LOGGER.info("\u5f53\u524d\u5355\u5143\u683c\u4e3a\u4ea4\u53c9\u6570\u636e\uff0c\u5df2\u7f6e\u7a7a,\u5355\u5143\u683c\u5185\u5bb9:{}", (Object)cell.getText());
            List paragraphs = cell.getParagraphs();
            int size = paragraphs.size();
            for (int i = 0; i < size; ++i) {
                cell.removeParagraph(0);
            }
            cell.addParagraph();
        }
    }

    private void removeRows(Set<Integer> removeRows, XWPFTable table) {
        List collect = removeRows.stream().sorted().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(collect)) {
            int removeNum = 0;
            for (Integer removeRow : collect) {
                removeRow = removeRow - removeNum;
                ++removeNum;
                table.removeRow(removeRow.intValue());
            }
        }
    }

    private boolean judgeContainsGran(XWPFTable table, Map<String, String> widgets, JSONObject granMap) {
        boolean isContains = false;
        try {
            String text = table.getText();
            for (String key : granMap.keySet()) {
                Object value;
                if (!text.contains(key) || !HussarUtils.isNotEmpty((Object)(value = granMap.get((Object)key)))) continue;
                isContains = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("judgeContainsGran\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return isContains;
    }

    private void handleTable(XWPFDocument doc, XWPFTable table, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        JSONObject widgetLevel = JSON.parseObject((String)widgets.get(WIDGET_LEVEL));
        String granMapStr = widgets.get(GRAN_MAP);
        JSONObject granMap = JSON.parseObject((String)granMapStr);
        List rows = table.getRows();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        HashSet<Integer> removeRows = new HashSet<Integer>();
        for (int k = 0; k < rows.size(); ++k) {
            Matcher matcher;
            String text;
            boolean hasChild = false;
            XWPFTableRow row = (XWPFTableRow)rows.get(k);
            List cells = row.getTableCells();
            boolean flag = true;
            String tableName = "";
            int lastIndex = 0;
            boolean indexFlag = false;
            for (XWPFTableCell cell : cells) {
                text = cell.getText();
                if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}") && this.isChild(text)) {
                    hasChild = true;
                }
                matcher = this.matcher(text);
                ArrayList<String> tableWidgets = new ArrayList<String>();
                int level = CellLevel.HOST.getLevel();
                while (matcher.find()) {
                    String[] split;
                    String split0;
                    int endIndex;
                    int startIndex;
                    String group = matcher.group();
                    String result = group.substring(startIndex = group.indexOf(35) + 1, endIndex = group.indexOf(125));
                    if (!result.contains(".") || !HussarUtils.isNotEmpty((Object)widgetLevel.get((Object)(split0 = (split = result.split("\\."))[0])))) continue;
                    level = Math.max((Integer)widgetLevel.get((Object)split0), level);
                    if (tableWidgets.contains(split0)) continue;
                    tableWidgets.add(split0);
                }
                this.judgeCrossAndHandle(tableWidgets, cell, granMap);
            }
            for (int i = 0; i < cells.size(); ++i) {
                XWPFTableCell cell;
                cell = (XWPFTableCell)cells.get(i);
                if (k == 0) {
                    widths.add(cell.getWidth());
                }
                List paras = cell.getParagraphs();
                text = cell.getText();
                matcher = this.matcher(text);
                if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}") && this.isChild(text)) {
                    removeRows.add(k);
                    while (matcher.find()) {
                        String[] strings;
                        Object obj = params.get(matcher.group());
                        if (!(obj instanceof List)) continue;
                        List list = (List)obj;
                        String childName = matcher.group();
                        String substring1 = childName.substring(childName.indexOf("#") + 1, childName.indexOf("}"));
                        String currentTableName = "";
                        if (substring1.contains(".") && ((strings = substring1.split("\\.")).length == 2 || strings.length == 3)) {
                            if (!tableName.equals(strings[0])) {
                                flag = true;
                            }
                            currentTableName = strings[0];
                        }
                        if (flag) {
                            for (int j = 0; j < list.size(); ++j) {
                                String[] strings2;
                                String[] split1;
                                String result;
                                int endIndex;
                                String cellTableName;
                                String group;
                                HashMap<String, Object> map;
                                String key21;
                                Matcher matcher1;
                                String text1;
                                CTJc ctjc;
                                CTPPr ctppr;
                                CTP ctp;
                                CTTc cttc;
                                CTPPr pPr;
                                XWPFTableCell newCell;
                                XWPFTableCell sourceCell;
                                int l;
                                XWPFTableRow tableRow = HussarUtils.isEmpty((Object)tableName) ? table.insertNewTableRow(k + j + 1) : (lastIndex < j + 1 ? table.insertNewTableRow(k + j + 1) : (XWPFTableRow)rows.get(k + j + 1));
                                Object obj1 = list.get(j);
                                JSONObject parse = DeepCopy.deepCopyJsonObject(obj1);
                                if (!tableRow.getTableCells().isEmpty()) {
                                    for (l = i; l < cells.size(); ++l) {
                                        sourceCell = (XWPFTableCell)cells.get(l);
                                        newCell = tableRow.getCell(l);
                                        newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
                                        pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
                                        if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
                                            cttc = newCell.getCTTc();
                                            ctp = (CTP)cttc.getPList().get(0);
                                            ctppr = ctp.getPPr();
                                            if (ctppr == null) {
                                                ctppr = ctp.addNewPPr();
                                            }
                                            if ((ctjc = ctppr.getJc()) == null) {
                                                ctjc = ctppr.addNewJc();
                                            }
                                            ctjc.setVal(pPr.getJc().getVal());
                                        }
                                        text1 = sourceCell.getText();
                                        matcher1 = this.matcher(text1);
                                        key21 = "";
                                        map = new HashMap<String, Object>();
                                        group = "";
                                        cellTableName = "";
                                        while (matcher1.find()) {
                                            group = matcher1.group();
                                            if (group.contains(".")) {
                                                int startIndex = group.indexOf(35) + 1;
                                                result = group.substring(startIndex, endIndex = group.indexOf(125));
                                                split1 = result.split("\\.");
                                                if (split1.length != 2) continue;
                                                cellTableName = split1[0];
                                                if (split1[1].contains("|")) {
                                                    strings2 = split1[1].split("\\|");
                                                    if (strings2.length == 3) {
                                                        key21 = strings2[0];
                                                        map.put(group, parse.get((Object)key21));
                                                    }
                                                    if (strings2.length != 2) continue;
                                                    key21 = strings2[0];
                                                    map.put(group, parse.get((Object)key21));
                                                    continue;
                                                }
                                                key21 = split1[1];
                                                map.put(group, parse.get((Object)key21));
                                                continue;
                                            }
                                            String group1 = String.valueOf(params.get(group));
                                            map.put(group, group1);
                                        }
                                        if (HussarUtils.isNotEmpty((Object)cellTableName) && !cellTableName.equals(currentTableName)) continue;
                                        this.replaceCell(newCell, sourceCell, doc, map, widgets, richTextMap);
                                    }
                                    continue;
                                }
                                indexFlag = true;
                                for (l = 0; l < cells.size(); ++l) {
                                    sourceCell = (XWPFTableCell)cells.get(l);
                                    newCell = tableRow.addNewTableCell();
                                    newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
                                    pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
                                    if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
                                        cttc = newCell.getCTTc();
                                        ctp = (CTP)cttc.getPList().get(0);
                                        ctppr = ctp.getPPr();
                                        if (ctppr == null) {
                                            ctppr = ctp.addNewPPr();
                                        }
                                        if ((ctjc = ctppr.getJc()) == null) {
                                            ctjc = ctppr.addNewJc();
                                        }
                                        ctjc.setVal(pPr.getJc().getVal());
                                    }
                                    text1 = sourceCell.getText();
                                    matcher1 = this.matcher(text1);
                                    key21 = "";
                                    map = new HashMap();
                                    map.put(DATA_VALUE, parse);
                                    group = "";
                                    cellTableName = "";
                                    while (matcher1.find()) {
                                        group = matcher1.group();
                                        if (group.contains(".")) {
                                            int startIndex = group.indexOf(35) + 1;
                                            result = group.substring(startIndex, endIndex = group.indexOf(125));
                                            split1 = result.split("\\.");
                                            if (split1.length != 2 && split1.length != 3) continue;
                                            cellTableName = split1[0];
                                            if (split1[split1.length - 1].contains("|")) {
                                                strings2 = split1[1].split("\\|");
                                                if (strings2.length == 3) {
                                                    key21 = strings2[0];
                                                    map.put(group, parse.get((Object)key21));
                                                }
                                                if (strings2.length != 2) continue;
                                                key21 = strings2[0];
                                                map.put(group, parse.get((Object)key21));
                                                continue;
                                            }
                                            key21 = split1[1];
                                            if (split1.length == 2) {
                                                map.put(group, parse.get((Object)key21));
                                                continue;
                                            }
                                            map.put(group, result);
                                            continue;
                                        }
                                        String group1 = String.valueOf(params.get(group));
                                        map.put(group, group1);
                                    }
                                    if (HussarUtils.isNotEmpty((Object)cellTableName) && !cellTableName.equals(currentTableName)) continue;
                                    this.replaceCell(newCell, sourceCell, doc, map, widgets, richTextMap);
                                }
                            }
                            tableName = currentTableName;
                            lastIndex = list.size();
                        }
                        flag = false;
                    }
                    continue;
                }
                if (hasChild && text.contains("RECORD_ID")) continue;
                for (XWPFParagraph para : paras) {
                    try {
                        this.wpsHandlePara(para, doc);
                        this.replaceInPara(doc, para, params, widgets, richTextMap);
                        if (!this.wordPrintProperties.isSelectionBoxEnable()) continue;
                        this.replaceSelect(para, params, widgets);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                        throw new BaseException((Throwable)e);
                    }
                }
            }
        }
        this.removeRows(removeRows, table);
    }

    private boolean isChild(String text) {
        Matcher matcher = this.matcher(text);
        while (matcher.find()) {
            String group = matcher.group();
            if (!group.substring(group.indexOf("#") + 1, group.indexOf("}")).contains(".")) continue;
            return true;
        }
        return false;
    }

    private void replaceCell(XWPFTableCell newCell, XWPFTableCell sourceCell, XWPFDocument doc, Map<String, Object> map, Map<String, String> widgets, Map<String, String> richTextMap) {
        this.copyCellStyle(sourceCell, newCell);
        for (XWPFParagraph sourcePh : sourceCell.getParagraphs()) {
            List paragraphs;
            int index = sourceCell.getParagraphs().indexOf(sourcePh);
            XWPFParagraph newPh = index < (paragraphs = newCell.getParagraphs()).size() ? (XWPFParagraph)paragraphs.get(index) : newCell.addParagraph();
            try {
                this.copyParagraph(doc, sourcePh, newPh);
                this.wpsHandlePara(newPh, doc);
                this.replaceInPara(doc, newPh, map, widgets, richTextMap);
            }
            catch (Exception e) {
                LOGGER.error("\u5b57\u6bb5\u66ff\u6362\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void copyParagraph(XWPFDocument document, XWPFParagraph sourcePh, XWPFParagraph targetPh) {
        targetPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
        for (XWPFRun run : sourcePh.getRuns()) {
            String text = run.text();
            XWPFRun xwpfRun = targetPh.createRun();
            xwpfRun.setText(text, 0);
            try {
                String afontFamily = run.getFontFamily(XWPFRun.FontCharRange.ascii);
                String efontFamily = run.getFontFamily(XWPFRun.FontCharRange.eastAsia);
                String hfontFamily = run.getFontFamily(XWPFRun.FontCharRange.hAnsi);
                String cfontFamily = run.getFontFamily(XWPFRun.FontCharRange.cs);
                String color = run.getColor();
                Boolean bold = run.isBold();
                Boolean italic = run.isItalic();
                int fontSize = -1;
                try {
                    CTRPr pr = run.getCTR().isSetRPr() ? run.getCTR().getRPr() : null;
                    fontSize = HussarUtils.isNotEmpty((Object)pr) && pr.isSetSz() ? pr.getSz().getVal().intValue() : -1;
                }
                catch (Exception e) {
                    LOGGER.error("\u83b7\u53d6run\u5b57\u4f53\u5927\u5c0f\u5f02\u5e38", (Throwable)e);
                }
                UnderlinePatterns underline = run.getUnderline();
                String underlineColor = run.getUnderlineColor();
                STThemeColor.Enum underlineThemeColor = run.getUnderlineThemeColor();
                STHighlightColor.Enum textHightlightColor = run.getTextHightlightColor();
                boolean strikeThrough = run.isStrikeThrough();
                boolean doubleStrikeThrough = run.isDoubleStrikeThrough();
                VerticalAlign subscript = run.getSubscript();
                STEm.Enum emphasisMark = run.getEmphasisMark();
                int textPosition = run.getTextPosition();
                int characterSpacing = run.getCharacterSpacing();
                int textScale = run.getTextScale();
                CTRPr ctrPr = run.getCTR().getRPr();
                if (HussarUtils.isNotEmpty((Object)ctrPr)) {
                    CTRImpl ctr = (CTRImpl)xwpfRun.getCTR();
                    CTRPr rPr = ctr.getRPr();
                    if (rPr == null) {
                        rPr = ctr.addNewRPr();
                    }
                    if (ctrPr.isSetSz()) {
                        CTHpsMeasure ctSize;
                        CTHpsMeasure cTHpsMeasure = ctSize = rPr.isSetSz() ? rPr.getSz() : rPr.addNewSz();
                        if (fontSize != -1) {
                            ctSize.setVal(BigInteger.valueOf(fontSize));
                        }
                    }
                    ctr.setRPr(ctrPr);
                }
                if (HussarUtils.isNotEmpty((Object)efontFamily) || HussarUtils.isNotEmpty((Object)hfontFamily) || HussarUtils.isNotEmpty((Object)afontFamily) || HussarUtils.isNotEmpty((Object)cfontFamily)) {
                    xwpfRun.setFontFamily(afontFamily, XWPFRun.FontCharRange.ascii);
                    xwpfRun.setFontFamily(cfontFamily, XWPFRun.FontCharRange.cs);
                    xwpfRun.setFontFamily(hfontFamily, XWPFRun.FontCharRange.hAnsi);
                    xwpfRun.setFontFamily(efontFamily, XWPFRun.FontCharRange.eastAsia);
                }
                xwpfRun.setColor(color);
                xwpfRun.setBold(bold.booleanValue());
                xwpfRun.setItalic(italic.booleanValue());
                xwpfRun.setUnderline(underline);
                xwpfRun.setUnderlineColor(underlineColor);
                xwpfRun.setUnderlineThemeColor(String.valueOf(underlineThemeColor));
                xwpfRun.setTextHighlightColor(String.valueOf(textHightlightColor));
                xwpfRun.setStrikeThrough(strikeThrough);
                xwpfRun.setDoubleStrikethrough(doubleStrikeThrough);
                xwpfRun.setSubscript(subscript);
                xwpfRun.setEmphasisMark(String.valueOf(emphasisMark));
                xwpfRun.setTextPosition(textPosition);
                xwpfRun.setCharacterSpacing(characterSpacing);
                xwpfRun.setTextScale(textScale);
            }
            catch (Exception e) {
                LOGGER.error("\u590d\u5236\u6bb5\u843d\u6837\u5f0f\u7ed9\u65b0\u6bb5\u843d\u5f02\u5e38", (Throwable)e);
                LOGGER.error("\u6bb5\u843d\u6587\u5b57\uff1a{}", (Object)text);
            }
        }
    }

    private void wpsHandlePara(XWPFParagraph para, XWPFDocument document) {
        int defaultFontSize = -1;
        boolean hasXml = false;
        if (HussarUtils.isNotEmpty((Object)para)) {
            List runs1 = para.getRuns();
            for (XWPFRun run1 : runs1) {
                List embeddedPictures = run1.getEmbeddedPictures();
                if (HussarUtils.isNotEmpty((Object)embeddedPictures)) {
                    return;
                }
                String phonetic = run1.getPhonetic();
                if (!HussarUtils.isNotEmpty((Object)phonetic)) continue;
                hasXml = true;
            }
            String paragraphText = para.getParagraphText();
            if (paragraphText.contains("$") && paragraphText.contains("{") && paragraphText.contains("#") && paragraphText.contains("}")) {
                Boolean italic;
                Boolean bold;
                ArrayList<Character> chars = new ArrayList<Character>();
                ArrayList<String> colors = new ArrayList<String>();
                ArrayList<Boolean> bolds = new ArrayList<Boolean>();
                ArrayList<Boolean> italics = new ArrayList<Boolean>();
                ArrayList<Integer> fontSizes = new ArrayList<Integer>();
                ArrayList<String> afontFamilys = new ArrayList<String>();
                ArrayList<String> efontFamilys = new ArrayList<String>();
                ArrayList<String> hfontFamilys = new ArrayList<String>();
                ArrayList<String> cfontFamilys = new ArrayList<String>();
                ArrayList<STHighlightColor.Enum> highlightColors = new ArrayList<STHighlightColor.Enum>();
                ArrayList<STThemeColor.Enum> themeColors = new ArrayList<STThemeColor.Enum>();
                ArrayList<UnderlinePatterns> underlinePatterns = new ArrayList<UnderlinePatterns>();
                ArrayList<String> underlineColors = new ArrayList<String>();
                ArrayList<Boolean> strikeThroughs = new ArrayList<Boolean>();
                ArrayList<Boolean> doubleStrikeThroughs = new ArrayList<Boolean>();
                ArrayList<VerticalAlign> verticalAligns = new ArrayList<VerticalAlign>();
                ArrayList<STEm.Enum> emphasisMarks = new ArrayList<STEm.Enum>();
                ArrayList<Integer> textPositions = new ArrayList<Integer>();
                ArrayList<Integer> characterSpacings = new ArrayList<Integer>();
                ArrayList<Integer> textScales = new ArrayList<Integer>();
                ArrayList<String> xmls = new ArrayList<String>();
                List runs = para.getRuns();
                for (XWPFRun run : runs) {
                    if (!HussarUtils.isNotEmpty((Object)run)) continue;
                    String text = run.text();
                    String afontFamily = run.getFontFamily(XWPFRun.FontCharRange.ascii);
                    String efontFamily = run.getFontFamily(XWPFRun.FontCharRange.eastAsia);
                    String hfontFamily = run.getFontFamily(XWPFRun.FontCharRange.hAnsi);
                    String cfontFamily = run.getFontFamily(XWPFRun.FontCharRange.cs);
                    String color = run.getColor();
                    bold = run.isBold();
                    italic = run.isItalic();
                    int fontSize = defaultFontSize;
                    try {
                        CTRPr pr = run.getCTR().isSetRPr() ? run.getCTR().getRPr() : null;
                        fontSize = HussarUtils.isNotEmpty((Object)pr) && pr.isSetSz() ? pr.getSz().getVal().intValue() : defaultFontSize;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u83b7\u53d6run\u5b57\u4f53\u5927\u5c0f\u5f02\u5e38", (Throwable)e);
                    }
                    UnderlinePatterns underline = run.getUnderline();
                    String underlineColor = run.getUnderlineColor();
                    STThemeColor.Enum underlineThemeColor = run.getUnderlineThemeColor();
                    STHighlightColor.Enum textHightlightColor = run.getTextHightlightColor();
                    boolean strikeThrough = run.isStrikeThrough();
                    boolean doubleStrikeThrough = run.isDoubleStrikeThrough();
                    VerticalAlign subscript = run.getSubscript();
                    STEm.Enum emphasisMark = run.getEmphasisMark();
                    int textPosition = run.getTextPosition();
                    int characterSpacing = run.getCharacterSpacing();
                    int textScale = run.getTextScale();
                    String phonetic = run.getPhonetic();
                    String xml = "";
                    if (HussarUtils.isNotEmpty((Object)phonetic)) {
                        XmlCursor c = run.getCTR().newCursor();
                        xml = c.getObject().toString();
                    }
                    if (!HussarUtils.isNotEmpty((Object)text)) continue;
                    for (int i = 0; i < text.length(); ++i) {
                        char c = text.charAt(i);
                        chars.add(Character.valueOf(c));
                        afontFamilys.add(afontFamily);
                        efontFamilys.add(efontFamily);
                        hfontFamilys.add(hfontFamily);
                        cfontFamilys.add(cfontFamily);
                        colors.add(color);
                        bolds.add(bold);
                        italics.add(italic);
                        fontSizes.add(fontSize);
                        highlightColors.add(textHightlightColor);
                        underlinePatterns.add(underline);
                        underlineColors.add(underlineColor);
                        strikeThroughs.add(strikeThrough);
                        themeColors.add(underlineThemeColor);
                        doubleStrikeThroughs.add(doubleStrikeThrough);
                        verticalAligns.add(subscript);
                        emphasisMarks.add(emphasisMark);
                        textPositions.add(textPosition);
                        characterSpacings.add(characterSpacing);
                        textScales.add(textScale);
                        xmls.add(xml);
                    }
                }
                for (int j = 0; j < chars.size(); ++j) {
                    List brList;
                    CTHpsMeasure ctSize;
                    XmlObject xmlObject;
                    CTRImpl ctr;
                    String text;
                    Character c = (Character)chars.get(j);
                    String color = (String)colors.get(j);
                    int fontSize = (Integer)fontSizes.get(j);
                    String afontFamily = (String)afontFamilys.get(j);
                    String efontFamily = (String)efontFamilys.get(j);
                    String hfontFamily = (String)hfontFamilys.get(j);
                    String cfontFamily = (String)cfontFamilys.get(j);
                    bold = (Boolean)bolds.get(j);
                    italic = (Boolean)italics.get(j);
                    UnderlinePatterns patterns = (UnderlinePatterns)underlinePatterns.get(j);
                    String underlineColor = (String)underlineColors.get(j);
                    STThemeColor.Enum themeColor = (STThemeColor.Enum)themeColors.get(j);
                    STHighlightColor.Enum anEnum = (STHighlightColor.Enum)highlightColors.get(j);
                    Boolean st = (Boolean)strikeThroughs.get(j);
                    Boolean dSt = (Boolean)doubleStrikeThroughs.get(j);
                    VerticalAlign verticalAlign = (VerticalAlign)verticalAligns.get(j);
                    STEm.Enum eM = (STEm.Enum)emphasisMarks.get(j);
                    Integer tP = (Integer)textPositions.get(j);
                    Integer cS = (Integer)characterSpacings.get(j);
                    Integer textScale = (Integer)textScales.get(j);
                    String xml = (String)xmls.get(j);
                    if (runs.size() >= j + 1) {
                        List brList2;
                        XWPFRun xwpfRun = (XWPFRun)runs.get(j);
                        text = xwpfRun.text();
                        ctr = (CTRImpl)xwpfRun.getCTR();
                        if (hasXml) {
                            if (HussarUtils.isNotEmpty((Object)xml)) {
                                XmlCursor xmlCursor = ctr.newCursor();
                                try {
                                    xmlObject = XmlObject.Factory.parse((String)xml);
                                    xmlCursor.getObject().set(xmlObject);
                                }
                                catch (XmlException e) {
                                    LOGGER.error("\u62fc\u97f3\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                                }
                            } else {
                                XmlCursor xmlCursor = ctr.newCursor();
                                xmlCursor.removeXmlContents();
                            }
                        }
                        if (text.equals("\n") && HussarUtils.isNotEmpty((Object)(brList2 = ctr.getBrList()))) {
                            ctr.removeBr(0);
                        }
                        if (c.toString().equals("\n")) {
                            xwpfRun.addBreak();
                        }
                        if (fontSize != -1) {
                            CTRPr rPr = ctr.getRPr();
                            if (rPr == null) {
                                rPr = ctr.addNewRPr();
                            }
                            ctSize = rPr.isSetSz() ? rPr.getSz() : rPr.addNewSz();
                            ctSize.setVal(BigInteger.valueOf(fontSize));
                        }
                        if (HussarUtils.isNotEmpty((Object)efontFamily) || HussarUtils.isNotEmpty((Object)hfontFamily) || HussarUtils.isNotEmpty((Object)afontFamily) || HussarUtils.isNotEmpty((Object)cfontFamily)) {
                            if (HussarUtils.isNotEmpty((Object)afontFamily)) {
                                xwpfRun.setFontFamily(afontFamily, XWPFRun.FontCharRange.ascii);
                            }
                            if (HussarUtils.isNotEmpty((Object)cfontFamily)) {
                                xwpfRun.setFontFamily(cfontFamily, XWPFRun.FontCharRange.cs);
                            }
                            if (HussarUtils.isNotEmpty((Object)hfontFamily)) {
                                xwpfRun.setFontFamily(hfontFamily, XWPFRun.FontCharRange.hAnsi);
                            }
                            if (HussarUtils.isNotEmpty((Object)efontFamily)) {
                                xwpfRun.setFontFamily(efontFamily, XWPFRun.FontCharRange.eastAsia);
                            }
                        }
                        xwpfRun.setColor(color);
                        xwpfRun.setBold(bold.booleanValue());
                        xwpfRun.setItalic(italic.booleanValue());
                        xwpfRun.setUnderline(patterns);
                        xwpfRun.setUnderlineColor(underlineColor);
                        xwpfRun.setUnderlineThemeColor(String.valueOf(themeColor));
                        xwpfRun.setTextHighlightColor(String.valueOf(anEnum));
                        xwpfRun.setStrikeThrough(st.booleanValue());
                        xwpfRun.setDoubleStrikethrough(dSt.booleanValue());
                        xwpfRun.setSubscript(verticalAlign);
                        xwpfRun.setEmphasisMark(String.valueOf(eM));
                        xwpfRun.setTextPosition(tP.intValue());
                        xwpfRun.setCharacterSpacing(cS.intValue());
                        xwpfRun.setTextScale(textScale.intValue());
                        xwpfRun.setText(c.toString(), 0);
                        continue;
                    }
                    XWPFRun run = para.createRun();
                    text = run.text();
                    ctr = (CTRImpl)run.getCTR();
                    if (text.equals("\n") && HussarUtils.isNotEmpty((Object)(brList = ctr.getBrList()))) {
                        ctr.removeBr(0);
                    }
                    if (c.toString().equals("\n")) {
                        run.addBreak();
                    }
                    run.setColor(color);
                    if (HussarUtils.isNotEmpty((Object)efontFamily) || HussarUtils.isNotEmpty((Object)hfontFamily) || HussarUtils.isNotEmpty((Object)afontFamily) || HussarUtils.isNotEmpty((Object)cfontFamily)) {
                        if (HussarUtils.isNotEmpty((Object)afontFamily)) {
                            run.setFontFamily(afontFamily, XWPFRun.FontCharRange.ascii);
                        }
                        if (HussarUtils.isNotEmpty((Object)cfontFamily)) {
                            run.setFontFamily(cfontFamily, XWPFRun.FontCharRange.cs);
                        }
                        if (HussarUtils.isNotEmpty((Object)hfontFamily)) {
                            run.setFontFamily(hfontFamily, XWPFRun.FontCharRange.hAnsi);
                        }
                        if (HussarUtils.isNotEmpty((Object)efontFamily)) {
                            run.setFontFamily(efontFamily, XWPFRun.FontCharRange.eastAsia);
                        }
                    }
                    run.setTextHighlightColor(String.valueOf(anEnum));
                    run.setStrikeThrough(st.booleanValue());
                    run.setDoubleStrikethrough(dSt.booleanValue());
                    run.setUnderline(patterns);
                    run.setUnderlineColor(underlineColor);
                    run.setUnderlineThemeColor(String.valueOf(themeColor));
                    run.setBold(bold.booleanValue());
                    run.setItalic(italic.booleanValue());
                    run.setEmphasisMark(String.valueOf(eM));
                    run.setTextPosition(tP.intValue());
                    run.setCharacterSpacing(cS.intValue());
                    run.setSubscript(verticalAlign);
                    run.setTextScale(textScale.intValue());
                    if (fontSize != -1) {
                        CTRPr rPr = ctr.getRPr();
                        if (rPr == null) {
                            rPr = ctr.addNewRPr();
                        }
                        ctSize = rPr.isSetSz() ? rPr.getSz() : rPr.addNewSz();
                        ctSize.setVal(BigInteger.valueOf(fontSize));
                    }
                    if (hasXml) {
                        if (HussarUtils.isNotEmpty((Object)xml)) {
                            XmlCursor xmlCursor = run.getCTR().newCursor();
                            try {
                                xmlObject = XmlObject.Factory.parse((String)xml);
                                xmlCursor.getObject().set(xmlObject);
                            }
                            catch (XmlException e) {
                                LOGGER.error("\u62fc\u97f3\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                            }
                            continue;
                        }
                        run.setText(c.toString(), 0);
                        continue;
                    }
                    run.setText(c.toString(), 0);
                }
            }
        }
    }

    private void replaceInTableForRichText(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList tables = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        pageHeaders.forEach(header -> tables.addAll(header.getTables()));
        tables.addAll(doc.getTables());
        for (XWPFTable table : tables) {
            List rows = table.getRows();
            ArrayList<Integer> widths = new ArrayList<Integer>();
            for (int k = 0; k < rows.size(); ++k) {
                XWPFTableRow row = (XWPFTableRow)rows.get(k);
                List cells = row.getTableCells();
                for (int i = 0; i < cells.size(); ++i) {
                    XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                    if (k == 0) {
                        widths.add(cell.getWidth());
                    }
                    List paras = cell.getParagraphs();
                    String text = cell.getText();
                    if (!text.contains("$") || !text.contains("{") || !text.contains("#") || !text.contains("}")) continue;
                    for (XWPFParagraph para : paras) {
                        try {
                            this.replaceInParaForRichText(para, params, widgets, richTextMap);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                            throw new BaseException((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public Matcher matcher(String str) {
        return Pattern.compile("\\$\\{(.+?)\\}", 2).matcher(str);
    }

    private void analysisPlaceholder(XWPFDocument document, Map<String, String> widgets) {
        ArrayList paragraphs = new ArrayList();
        List pageHeaders = document.getHeaderList();
        List xwpfFooters = document.getFooterList();
        pageHeaders.forEach(header -> paragraphs.addAll(header.getParagraphs()));
        xwpfFooters.forEach(footer -> paragraphs.addAll(footer.getParagraphs()));
        paragraphs.addAll(document.getParagraphs());
        for (XWPFParagraph paragraph : paragraphs) {
            String paragraphText = paragraph.getParagraphText();
            Matcher matcher = this.matcher(paragraphText);
            while (matcher.find()) {
                String key = matcher.group();
                String value = this.getFormValue(key);
                if (value.contains(".")) {
                    String[] split = value.split("\\.");
                    value = split[0];
                }
                if (HussarUtils.isNotEmpty((Object)widgets.get(value))) {
                    if (widgets.get(value).equals(WidgetType.CHILDREN_TABLE.getType()) || widgets.get(value).equals(WidgetType.JXDNChildrenTableAgg.getType())) continue;
                    HASH_MAP.put(key, value);
                    continue;
                }
                if (value.equals("flowHistoryInfo")) continue;
                HASH_MAP.put(key, value);
            }
        }
    }

    private void analysisTable(XWPFDocument document) {
        ArrayList tables = new ArrayList();
        List pageHeaders = document.getHeaderList();
        pageHeaders.forEach(header -> tables.addAll(header.getTables()));
        tables.addAll(document.getTables());
        for (XWPFTable table : tables) {
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    Matcher matcher = this.matcher(cell.getText());
                    while (matcher.find()) {
                        String key = matcher.group();
                        String value = this.getFormValue(key);
                        HASH_MAP.put(key, value);
                    }
                }
            }
        }
    }

    private void wordExportHandlePre(XWPFDocument document, Map<String, String> widgets) {
        JSONArray jsonArray = new JSONArray();
        HASH_MAP.put("\u5b50\u8868", jsonArray);
        Iterator tablesIterator = document.getTablesIterator();
        while (tablesIterator.hasNext()) {
            XWPFTable table = (XWPFTable)tablesIterator.next();
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    List cellParagraphs = cell.getParagraphs();
                    for (XWPFParagraph paragraph : cellParagraphs) {
                        String text = paragraph.getText();
                        Matcher matcherFlag = this.matcher(text);
                        if (!matcherFlag.find()) continue;
                        Matcher matcher = this.matcher(text);
                        List runs = paragraph.getRuns();
                        for (XWPFRun run : runs) {
                            run.setText("", 0);
                        }
                        if (HussarUtils.isEmpty((Object)runs)) {
                            paragraph.createRun();
                        }
                        XWPFRun xwpfRun = (XWPFRun)runs.get(0);
                        String newText = "";
                        while (matcher.find()) {
                            String key = matcher.group();
                            String substring = key.substring(key.indexOf("#") + 1, key.indexOf("}"));
                            if (substring.contains(".")) {
                                jsonArray.add((Object)substring);
                            }
                            String newSubstring = "\u4e3b\u8868." + substring;
                            String newKey = key.replace(substring, newSubstring);
                            if (substring.contains("|")) {
                                substring = substring.substring(0, substring.indexOf("|"));
                            }
                            if (!widgets.containsKey(substring)) {
                                newKey = "";
                            }
                            text = newText = text.replace(key, newKey);
                        }
                        xwpfRun.setText(newText, 0);
                    }
                }
            }
        }
    }

    private void wordExportHandlePost(JSONObject parse, XWPFDocument document, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        Object object1 = parse.get((Object)"\u4e3b\u8868");
        JSONArray host = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)object1)) {
            host = (JSONArray)object1;
        }
        HashMap newTable = new HashMap();
        JSONArray jsonArray = new JSONArray();
        Object object = HASH_MAP.get("\u5b50\u8868");
        if (HussarUtils.isNotEmpty((Object)object)) {
            jsonArray = (JSONArray)object;
            List tables = document.getTables();
            for (XWPFTable table : tables) {
                List rows = table.getRows();
                int k = 0;
                for (XWPFTableRow row : rows) {
                    boolean flag = false;
                    List tableCells = row.getTableCells();
                    for (XWPFTableCell tableCell : tableCells) {
                        String text = tableCell.getText();
                        for (Object o : jsonArray) {
                            String[] split;
                            if (!text.contains(o.toString())) continue;
                            flag = true;
                            if (!o.toString().contains(".") || (split = o.toString().split("\\.")).length <= 1) continue;
                            String tableName = split[0];
                            Object object2 = host.get(k);
                            JSONObject jsonObject = (JSONObject)object2;
                            Object object3 = jsonObject.get((Object)tableName);
                            String newKey = "${" + k + "#" + o + "}";
                            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
                            JSONObject value = new JSONObject();
                            value.put(newKey, object3);
                            map.put(newKey, value);
                            newTable.put(tableCell, map);
                        }
                    }
                    if (!flag) continue;
                    ++k;
                }
            }
        }
        for (XWPFTableCell xwpfTableCell : newTable.keySet()) {
            Map map = (Map)newTable.get(xwpfTableCell);
            String newKey = "";
            JSONObject jsonObject = new JSONObject();
            Iterator<Object> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                newKey = key = (String)iterator.next();
                jsonObject = (JSONObject)map.get(key);
            }
            XWPFParagraph paragraph = xwpfTableCell.getParagraphArray(0);
            XWPFTable cellTable = xwpfTableCell.insertNewTbl(paragraph.getCTP().newCursor());
            xwpfTableCell.removeParagraph(0);
            cellTable.getCTTbl().addNewTblPr();
            cellTable.getCTTbl().getTblPr().addNewTblW();
            cellTable.setWidth("120%");
            cellTable.setWidthType(TableWidthType.PCT);
            CTBorder ctBorderLeft = cellTable.getCTTbl().getTblPr().addNewTblBorders().addNewLeft();
            ctBorderLeft.setVal(STBorder.SINGLE);
            ctBorderLeft.setSz(new BigInteger("4"));
            CTBorder borderRight = cellTable.getCTTbl().getTblPr().getTblBorders().addNewRight();
            borderRight.setVal(STBorder.SINGLE);
            borderRight.setSz(new BigInteger("4"));
            CTBorder addNewTop = cellTable.getCTTbl().getTblPr().getTblBorders().addNewTop();
            addNewTop.setVal(STBorder.SINGLE);
            addNewTop.setSz(new BigInteger("4"));
            CTBorder addNewBottom = cellTable.getCTTbl().getTblPr().getTblBorders().addNewBottom();
            addNewBottom.setVal(STBorder.SINGLE);
            addNewBottom.setSz(new BigInteger("4"));
            CTBorder addNewInsideH = cellTable.getCTTbl().getTblPr().getTblBorders().addNewInsideH();
            addNewInsideH.setVal(STBorder.SINGLE);
            addNewInsideH.setSz(new BigInteger("4"));
            CTBorder addNewInsideV = cellTable.getCTTbl().getTblPr().getTblBorders().addNewInsideV();
            addNewInsideV.setVal(STBorder.SINGLE);
            addNewInsideV.setSz(new BigInteger("4"));
            cellTable.getCTTbl().getTblPr().addNewJc().setVal(STJc.CENTER);
            xwpfTableCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
            cellTable.removeRow(0);
            XWPFTableRow row = cellTable.insertNewTableRow(0);
            XWPFTableCell cell = row.addNewTableCell();
            cell.setWidth("100%");
            cell.setWidthType(TableWidthType.DXA);
            XWPFParagraph xwpfParagraph = cell.addParagraph();
            XWPFRun run = xwpfParagraph.createRun();
            run.setText(newKey);
            this.handleTable(document, cellTable, (Map<String, Object>)jsonObject, widgets, richTextMap);
        }
    }

    public String getFormValue(String textPlaceholder) {
        if (textPlaceholder.contains("|")) {
            return textPlaceholder.substring(textPlaceholder.indexOf("#") + 1, textPlaceholder.indexOf("|"));
        }
        return textPlaceholder.substring(textPlaceholder.indexOf("#") + 1, textPlaceholder.indexOf("}"));
    }

    public static void getFormData(Map<String, Object> hashMap, JSONObject dataJson) {
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            Object obj;
            String key;
            block11: {
                String key1;
                String[] split;
                String value;
                block9: {
                    String key2;
                    block10: {
                        key = entry.getKey();
                        value = String.valueOf(entry.getValue());
                        obj = null;
                        if (!value.contains(".")) break block9;
                        split = value.split("\\.");
                        if (entry.getValue() instanceof JSONArray) continue;
                        if (split.length != 2) break block10;
                        key1 = split[0];
                        key2 = split[1];
                        Object obj1 = dataJson.get((Object)key1);
                        if (obj1 != null && obj1 instanceof List) {
                            List list = (List)obj1;
                            hashMap.put(key, list);
                            continue;
                        }
                        break block11;
                    }
                    if (split.length != 3) break block11;
                    key1 = split[0];
                    key2 = split[1];
                    String key3 = split[2];
                    Object obj1 = dataJson.get((Object)key1);
                    if (obj1 != null && obj1 instanceof List) {
                        List list = (List)obj1;
                        hashMap.put(key, list);
                        continue;
                    }
                    break block11;
                }
                if (value.contains("|")) {
                    split = value.split("\\|");
                    if (split.length == 2 || split.length == 3) {
                        key1 = split[0];
                        obj = dataJson.get((Object)key1);
                    }
                } else if (dataJson.containsKey((Object)value)) {
                    obj = value.equals("printUserName") && HussarUtils.isEmpty((Object)dataJson.get((Object)value)) ? "\u5916\u90e8\u7528\u6237" : dataJson.get((Object)value);
                } else {
                    if (key.equals(DATA_VALUE)) continue;
                    hashMap.remove(key);
                    continue;
                }
            }
            if (obj != null) {
                hashMap.put(key, obj);
                continue;
            }
            if (key.equals(DATA_VALUE)) continue;
            hashMap.put(key, "");
        }
    }

    private String getContent(InputStream ... ises) throws IOException {
        if (ises != null) {
            StringBuilder result = new StringBuilder();
            for (InputStream is : ises) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
            }
            return result.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo entry(String mark, JSONObject parse, String inputFilePath, String outputFilePath, String fileName, Map<String, String> widgets) {
        Long fileId = 0L;
        FileInputStream fileInputStream = null;
        Path path = Paths.get(outputFilePath, new String[0]);
        long timestamp = System.currentTimeMillis();
        Path temporaryPath = Paths.get(this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator + "temporary" + File.separator + timestamp + DOCX_SUFFIX, new String[0]);
        Path temporaryPathTwo = Paths.get(this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator + "temporary" + File.separator + (timestamp + 100L) + DOCX_SUFFIX, new String[0]);
        File filePath = new File(this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator + "temporary" + File.separator);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        int taskState = 1;
        XWPFDocument xwpfDocument1 = null;
        XWPFTemplate template = null;
        XWPFTemplate templateTwo = null;
        FileOutputStream out = null;
        FileOutputStream outTwo = null;
        XWPFDocument document = null;
        Object documentTwo = null;
        XWPFDocument xwpfDocument = null;
        File file = null;
        File fileTwo = null;
        try (FileInputStream inputStream = new FileInputStream(inputFilePath);
             OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
             XWPFDocument document1 = new XWPFDocument((InputStream)inputStream);
             InputStream cssInput = WordHandle.class.getResourceAsStream("/wordPrint/wordPrint.css");){
            Object configure;
            ConfigureBuilder configureBuilder;
            HashMap<String, String> richTextMap = new HashMap<String, String>();
            JSONObject parse1 = new JSONObject();
            LinkedHashMap<String, List<String>> cssParse = new LinkedHashMap<String, List<String>>();
            ArrayList delParse = new ArrayList();
            ArrayList underParse = new ArrayList();
            cssParse.put("-\u5220\u9664\u7ebf-", delParse);
            cssParse.put("-\u4e0b\u5212\u7ebf-", underParse);
            String css = HussarUtils.isNotEmpty((Object)cssInput) ? this.getContent(cssInput) : "";
            if (HussarUtils.isNotEmpty((Object)parse)) {
                if (parse.containsKey((Object)"\u4e3b\u8868")) {
                    Iterator object = parse.get((Object)"\u4e3b\u8868");
                    JSONArray jsonArray = (JSONArray)object;
                    jsonArray.forEach(o -> {
                        JSONObject jsonObject = (JSONObject)o;
                        int index = jsonArray.indexOf((Object)jsonObject);
                        this.handleRich(jsonObject, widgets, parse1, css, cssParse, index);
                        for (String key : jsonObject.keySet()) {
                            this.handleSu(jsonObject, widgets, key, parse1, index);
                        }
                    });
                } else {
                    this.handleRich(parse, widgets, parse1, css, cssParse, null);
                    for (Object key : parse.keySet()) {
                        this.handleSu(parse, widgets, (String)key, parse1, null);
                    }
                }
                xwpfDocument1 = this.generateWordForRichText(HASH_MAP, document1, widgets, parse1, richTextMap);
                configureBuilder = Configure.builder();
                if (HussarUtils.isNotEmpty(richTextMap)) {
                    for (Object key : richTextMap.keySet()) {
                        configureBuilder.bind((String)key, (RenderPolicy)new HtmlRenderPolicy());
                    }
                }
                configure = configureBuilder.build();
                LOGGER.info("--------------------\u51c6\u5907\u6267\u884cXWPFTemplate.compile");
                template = XWPFTemplate.compile((XWPFDocument)xwpfDocument1, (Configure)configure);
                LOGGER.info("--------------------\u6267\u884cXWPFTemplate.compile\u7ed3\u675f");
                template.render(richTextMap);
                file = new File(temporaryPath.toString());
                out = new FileOutputStream(file);
                template.write((OutputStream)out);
                document = new XWPFDocument(Files.newInputStream(Paths.get(String.valueOf(temporaryPath), new String[0]), new OpenOption[0]));
                for (String key : parse1.keySet()) {
                    richTextMap.put(key, String.valueOf(parse1.get((Object)key)));
                }
            }
            xwpfDocument = this.generateWord(HASH_MAP, document, widgets, parse, richTextMap);
            if (HussarUtils.isNotEmpty((Object)mark)) {
                DocxUtil.makeFullWaterMarkByWordArt(null, xwpfDocument, mark);
            }
            if (parse.containsKey((Object)"\u4e3b\u8868")) {
                configureBuilder = Configure.builder();
                for (Object key : richTextMap.keySet()) {
                    if (!parse1.containsKey(key)) continue;
                    parse1.put((String)key, richTextMap.get(key));
                }
                if (HussarUtils.isNotEmpty((Object)parse1)) {
                    for (Object key : parse1.keySet()) {
                        configureBuilder.bind((String)key, (RenderPolicy)new HtmlRenderPolicy());
                    }
                }
                configure = configureBuilder.build();
                ZipSecureFile.setMinInflateRatio((double)0.001);
                templateTwo = XWPFTemplate.compile((XWPFDocument)xwpfDocument, (Configure)configure);
                templateTwo.render((Object)parse1);
                fileTwo = new File(temporaryPathTwo.toString());
                outTwo = new FileOutputStream(fileTwo);
                templateTwo.write((OutputStream)outTwo);
                xwpfDocument = new XWPFDocument(Files.newInputStream(Paths.get(String.valueOf(temporaryPathTwo), new String[0]), new OpenOption[0]));
            }
            List paragraphs = xwpfDocument.getParagraphs();
            this.handleHtmlColor(paragraphs, cssParse);
            this.handleTableHtmlColor(xwpfDocument, cssParse);
            try {
                BodyElementType type;
                IBodyElement iBodyElement;
                boolean delLastP = false;
                int paraPos = 0;
                List bodyElements = xwpfDocument.getBodyElements();
                if (HussarUtils.isNotEmpty((Object)bodyElements) && HussarUtils.isNotEmpty((Object)(iBodyElement = (IBodyElement)bodyElements.get(bodyElements.size() - 1))) && (type = iBodyElement.getElementType()) == BodyElementType.PARAGRAPH) {
                    XWPFParagraph paragraph;
                    paraPos = bodyElements.size() - 1;
                    List paragraphs1 = xwpfDocument.getParagraphs();
                    if (HussarUtils.isNotEmpty((Object)paragraphs1) && HussarUtils.isEmpty((Object)(paragraph = (XWPFParagraph)paragraphs1.get(paragraphs1.size() - 1)).getRuns()) && HussarUtils.isEmpty((Object)paragraph.getFootnoteText())) {
                        delLastP = true;
                    }
                }
                if (delLastP && paraPos != 0) {
                    xwpfDocument.removeBodyElement(paraPos);
                    LOGGER.info("word\u6253\u5370\u6a21\u677f\u5220\u9664\u7a7a\u6bb5\u843d\u6210\u529f");
                }
            }
            catch (Exception e) {
                LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u5220\u9664\u7a7a\u6bb5\u843d\u5931\u8d25", (Throwable)e);
            }
            xwpfDocument.write(outputStream);
            fileInputStream = new FileInputStream(new File(outputFilePath));
            int length = fileInputStream.available();
            byte[] fileBytes = new byte[length];
            int bytesRead = fileInputStream.read(fileBytes);
            MockMultipartFile multipartFile = new MockMultipartFile(fileName, fileName, DOCX_SUFFIX, fileBytes);
            ApiResponse upload = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            fileId = (Long)upload.getData();
        }
        catch (Exception e) {
            taskState = -1;
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (xwpfDocument1 != null) {
                    xwpfDocument1.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (template != null) {
                    template.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (templateTwo != null) {
                    templateTwo.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (outTwo != null) {
                    outTwo.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (document != null) {
                    document.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (xwpfDocument != null) {
                    xwpfDocument.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            if (HussarUtils.isNotEmpty((Object)file) && file.exists()) {
                file.delete();
            }
            if (HussarUtils.isNotEmpty((Object)fileTwo) && fileTwo.exists()) {
                fileTwo.delete();
            }
        }
        HASH_MAP.clear();
        return new TaskInfo(taskState, fileId);
    }

    private void handleRich(JSONObject parse, Map<String, String> widgets, JSONObject parse1, String css, Map<String, List<String>> cssParse, Integer index) {
        parse.forEach((key, value) -> {
            if (HussarUtils.isNotEmpty(widgets.get(key)) && ((String)widgets.get(key)).equals(WidgetType.JXDNRichText.getType())) {
                String contents = "<!DOCTYPE html>\n<html lang=\"zh-cn\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style>\n" + css + "    </style>\n</head>\n<body>\n" + value + "</body>\n</html>";
                String html = this.matcherColor(contents);
                Document doc = Jsoup.parse((String)html);
                html = this.handleSpan(doc, cssParse, html);
                html = this.handleUnderLand(doc, cssParse, html);
                html = this.handleDelete(doc, cssParse, html);
                html = this.handleMark(doc, cssParse, html);
                this.handleTable(doc, cssParse, html);
                String oldKey = key;
                if (HussarUtils.isNotEmpty((Object)index)) {
                    key = key + index.toString();
                    parse.put(oldKey, (Object)("{{" + key + "}}"));
                    parse1.put(key, (Object)html);
                } else {
                    parse1.put(key, (Object)html);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo entryBatch(String mark, List<JSONObject> datas, String inputFilePath, String outputFilePath, String fileName, Map<String, String> widgets) throws Exception {
        Long fileId = 0L;
        FileInputStream fileInputStream = null;
        int taskState = 1;
        Path path = Paths.get(outputFilePath, new String[0]);
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        ArrayList<XWPFDocument> documents = new ArrayList<XWPFDocument>();
        ArrayList<XWPFDocument> documentList = new ArrayList<XWPFDocument>();
        ArrayList<XWPFDocument> xwpfDocuments = new ArrayList<XWPFDocument>();
        ArrayList<FileOutputStream> outputStreams = new ArrayList<FileOutputStream>();
        ArrayList<File> files = new ArrayList<File>();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> newHrIds = new ArrayList<String>();
        ArrayList<String> newFrIds = new ArrayList<String>();
        HashMap<String, String> rIdMap = new HashMap<String, String>();
        taskState = this.entryHandleBatch(rIdMap, mark, datas, inputFilePath, null, widgets, documents, taskState, documentList, xwpfDocuments, outputStreams, files, stringBuilder, newHrIds, newFrIds);
        try {
            XWPFDocument xmd = (XWPFDocument)documents.get(0);
            CTSectPr sectPr1 = xmd.getDocument().getBody().getSectPr();
            if ((HussarUtils.isNotEmpty((Object)xmd.getHeaderList()) || HussarUtils.isNotEmpty((Object)xmd.getFooterList())) && HussarUtils.isNotEmpty((Object)sectPr1)) {
                xmd.getDocument().getBody().unsetSectPr();
            }
            WordHandle.appendBody(rIdMap, xmd, stringBuilder, newHrIds, newFrIds);
            stringBuilder = null;
            LOGGER.info("\u6b63\u5728\u8f93\u51fa\u5408\u5e76\u540e\u7684\u6587\u6863");
            xmd.write(outputStream);
            LOGGER.info("\u5408\u5e76\u540e\u7684\u6587\u6863\u8f93\u51fa\u5b8c\u6210");
            fileInputStream = new FileInputStream(new File(outputFilePath));
            int length = fileInputStream.available();
            byte[] fileBytes = new byte[length];
            int bytesRead = fileInputStream.read(fileBytes);
            MockMultipartFile multipartFile = new MockMultipartFile(fileName, fileName, DOCX_SUFFIX, fileBytes);
            ApiResponse upload = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            fileId = (Long)upload.getData();
        }
        catch (Exception ex) {
            taskState = -1;
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        finally {
            try {
                if (documents.get(0) != null) {
                    ((XWPFDocument)documents.get(0)).close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
        }
        return new TaskInfo(taskState, fileId);
    }

    public static void appendBody(Map<String, String> rIdMap, XWPFDocument src, StringBuilder stringBuilder, List<String> newHRIds, List<String> newFRIds) throws Exception {
        String rId = rIdMap.getOrDefault("_rId_", "");
        List headerList = src.getHeaderList();
        List footerList = src.getFooterList();
        if (HussarUtils.isEmpty((Object)headerList) && HussarUtils.isEmpty((Object)footerList) && HussarUtils.isNotEmpty((Object)stringBuilder)) {
            CTSectPr sectPr = src.getDocument().getBody().getSectPr();
            CTSectPr ctSectPr1 = null;
            CTPPr ctpPr1 = null;
            if (sectPr != null) {
                CTColumns cols;
                CTDocGrid docGrid;
                CTPageMar pgMar;
                CTBody body;
                CTPageSz pageSz = sectPr.getPgSz();
                if (pageSz != null) {
                    int width = pageSz.getW().intValue();
                    int height = pageSz.getH().intValue();
                    LOGGER.info("\u9875\u9762\u5bbd\u5ea6\uff1a{}", (Object)width);
                    LOGGER.info("\u9875\u9762\u9ad8\u5ea6\uff1a{}", (Object)height);
                    body = src.getDocument().getBody();
                    ctpPr1 = body.addNewP().addNewPPr();
                    ctSectPr1 = ctpPr1.addNewSectPr();
                    if (HussarUtils.isNotEmpty((Object)rId)) {
                        CTHdrFtrRef headerRef = ctSectPr1.addNewHeaderReference();
                        headerRef.setType(STHdrFtr.Enum.forInt((int)2));
                        headerRef.setId(rId);
                    }
                    ctSectPr1.addNewType().setVal(STSectionMark.NEXT_PAGE);
                    CTPageSz pageSize = ctSectPr1.addNewPgSz();
                    pageSize.setOrient(STPageOrientation.LANDSCAPE);
                    pageSize.setW(BigInteger.valueOf(width));
                    pageSize.setH(BigInteger.valueOf(height));
                }
                if (HussarUtils.isNotEmpty((Object)(pgMar = sectPr.getPgMar()))) {
                    LOGGER.info("\u9875\u8fb9\u8dddgetTop\uff1a{}", (Object)pgMar.getTop());
                    LOGGER.info("\u9875\u8fb9\u8dddgetBottom\uff1a{}", (Object)pgMar.getBottom());
                    LOGGER.info("\u9875\u8fb9\u8dddgetFooter\uff1a{}", (Object)pgMar.getFooter());
                    LOGGER.info("\u9875\u8fb9\u8dddgetGutter\uff1a{}", (Object)pgMar.getGutter());
                    LOGGER.info("\u9875\u8fb9\u8dddgetLeft\uff1a{}", (Object)pgMar.getLeft());
                    LOGGER.info("\u9875\u8fb9\u8dddgetHeader\uff1a{}", (Object)pgMar.getHeader());
                    LOGGER.info("\u9875\u8fb9\u8dddgetRight\uff1a{}", (Object)pgMar.getRight());
                    if (HussarUtils.isEmpty((Object)ctpPr1)) {
                        CTBody body2 = src.getDocument().getBody();
                        ctpPr1 = body2.addNewP().addNewPPr();
                    }
                    if (HussarUtils.isEmpty((Object)ctSectPr1)) {
                        ctSectPr1 = ctpPr1.addNewSectPr();
                    }
                    ctSectPr1.setPgMar(pgMar);
                }
                if (HussarUtils.isNotEmpty((Object)(docGrid = sectPr.getDocGrid()))) {
                    LOGGER.info("docGrid.getLinePitch\uff1a{}", (Object)docGrid.getLinePitch());
                    if (HussarUtils.isEmpty(ctpPr1)) {
                        body = src.getDocument().getBody();
                        ctpPr1 = body.addNewP().addNewPPr();
                    }
                    if (HussarUtils.isEmpty(ctSectPr1)) {
                        ctSectPr1 = ctpPr1.addNewSectPr();
                    }
                    ctSectPr1.setDocGrid(docGrid);
                }
                if (HussarUtils.isNotEmpty((Object)(cols = sectPr.getCols()))) {
                    LOGGER.info("cols.getSpace()\uff1a{}", (Object)cols.getSpace());
                    if (HussarUtils.isEmpty(ctpPr1)) {
                        CTBody body3 = src.getDocument().getBody();
                        ctpPr1 = body3.addNewP().addNewPPr();
                    }
                    if (HussarUtils.isEmpty((Object)ctSectPr1)) {
                        ctSectPr1 = ctpPr1.addNewSectPr();
                    }
                    ctSectPr1.setCols(cols);
                }
            }
        }
        CTBody src1Body = src.getDocument().getBody();
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String srcString = src1Body.xmlText();
        if (HussarUtils.isNotEmpty((Object)src.getHeaderList())) {
            ArrayList<String> headerReferences = new ArrayList<String>();
            String regex = "<w:headerReference\\sw:type=\"default\"\\sr:id=\"rId\\d+\"/>";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(srcString);
            while (matcher.find()) {
                headerReferences.add(matcher.group());
            }
            if (HussarUtils.isNotEmpty(newHRIds)) {
                newHRIds.remove(0);
            }
            if (HussarUtils.isNotEmpty(newFRIds)) {
                newFRIds.remove(0);
            }
            block1: for (String headerReference : headerReferences) {
                for (String newRId : newHRIds) {
                    if (!headerReference.contains(newRId)) continue;
                    srcString = srcString.replace(headerReference, "");
                    continue block1;
                }
            }
        }
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String mainPart = srcString.substring(srcString.indexOf(">") + 1, srcString.lastIndexOf("<"));
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(mainPart);
        sb.append((CharSequence)stringBuilder);
        LOGGER.info("\u5408\u5e76\u6587\u6863\u5b8c\u6210");
        CTBody makeBody = CTBody.Factory.parse((String)sb.append(sufix).toString());
        LOGGER.info("\u751f\u6210\u65b0Body\u5b8c\u6210");
        src1Body.set((XmlObject)makeBody);
        LOGGER.info("\u8bbe\u7f6e\u65b0Body\u5b8c\u6210");
        makeBody = null;
    }

    private int getRelationIndex(XWPFDocument doc, XWPFRelation relation) {
        int i = 1;
        for (POIXMLDocumentPart.RelationPart rp : doc.getRelationParts()) {
            if (!rp.getRelationship().getRelationshipType().equals(relation.getRelation())) continue;
            ++i;
        }
        return i;
    }

    private CTHdrFtr buildHdr(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper, XWPFParagraph[] pars) {
        CTHdrFtr hdr = this.buildHdrFtr(pars, wrapper);
        this.setHeaderReference(doc, type, wrapper);
        return hdr;
    }

    private CTHdrFtr buildHdrFooter(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper, XWPFParagraph[] pars) {
        CTHdrFtr hdr = this.buildHdrFtr(pars, wrapper);
        this.setFooterReference(doc, type, wrapper);
        return hdr;
    }

    private void setHeaderReference(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper) {
        CTHdrFtrRef ref = doc.getDocument().getBody().getSectPr().addNewHeaderReference();
        ref.setType(type);
        ref.setId(doc.getRelationId((POIXMLDocumentPart)wrapper));
    }

    private void setFooterReference(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper) {
        CTHdrFtrRef ref = doc.getDocument().getBody().getSectPr().addNewFooterReference();
        ref.setType(type);
        ref.setId(doc.getRelationId((POIXMLDocumentPart)wrapper));
    }

    private CTHdrFtr buildHdrFtr(XWPFParagraph[] paragraphs, XWPFHeaderFooter wrapper) {
        CTHdrFtr ftr = wrapper._getHdrFtr();
        if (paragraphs != null) {
            for (int i = 0; i < paragraphs.length; ++i) {
                ftr.addNewP();
                ftr.setPArray(i, paragraphs[i].getCTP());
            }
        }
        return ftr;
    }

    private void assignHeader(XWPFDocument doc, XWPFHeader hdr, STHdrFtr.Enum type) {
        List headerList = doc.getHeaderList();
        headerList.add(hdr);
    }

    private void createEmptyHeader(XWPFDocument src, List<String> newHRIds) {
        HdrDocument hdrDoc = HdrDocument.Factory.newInstance();
        XWPFRelation relation = XWPFRelation.HEADER;
        int i = this.getRelationIndex(src, relation);
        XWPFHeader wrapper = (XWPFHeader)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
        wrapper.setXWPFDocument(src);
        CTHdrFtr hdr = this.buildHdr(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
        wrapper.setHeaderFooter(hdr);
        hdrDoc.setHdr(hdr);
        String relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
        newHRIds.add(relationId);
    }

    private void createEmptyFooter(XWPFDocument src, List<String> newFRIds) {
        HdrDocument hdrDoc = HdrDocument.Factory.newInstance();
        XWPFRelation relation = XWPFRelation.FOOTER;
        int i = this.getRelationIndex(src, relation);
        XWPFFooter wrapper = (XWPFFooter)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
        wrapper.setXWPFDocument(src);
        CTHdrFtr hdr = this.buildHdrFooter(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
        wrapper.setHeaderFooter(hdr);
        hdrDoc.setHdr(hdr);
        String relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
        newFRIds.add(relationId);
    }

    private void firstSectPrHandle(XWPFDocument document1, List<String> newHRIds, List<String> newFRIds) {
        XWPFParagraph emptySectP;
        CTPPr pPr1;
        List paragraphList = document1.getParagraphs();
        CTSectPr commonSectPr = null;
        CTSectPr sectPr1 = document1.getDocument().getBody().getSectPr();
        if (HussarUtils.isNotEmpty((Object)sectPr1)) {
            if (HussarUtils.isNotEmpty((Object)sectPr1.getHeaderReferenceList())) {
                int defaultHeaderIndex = -1;
                List headerReferenceList = sectPr1.getHeaderReferenceList();
                for (CTHdrFtrRef ctHdrFtrRef : headerReferenceList) {
                    if (!ctHdrFtrRef.getId().equals(newHRIds.get(0))) continue;
                    defaultHeaderIndex = headerReferenceList.indexOf(ctHdrFtrRef);
                }
                if (defaultHeaderIndex != -1) {
                    sectPr1.removeHeaderReference(defaultHeaderIndex);
                }
            }
            if (HussarUtils.isNotEmpty((Object)sectPr1.getFooterReferenceList())) {
                int defaultFIndex = -1;
                List footerReferenceList = sectPr1.getFooterReferenceList();
                Iterator iterator = footerReferenceList.iterator();
                while (iterator.hasNext()) {
                    CTHdrFtrRef ctHdrFtrRef;
                    ctHdrFtrRef = (CTHdrFtrRef)iterator.next();
                    if (!ctHdrFtrRef.getId().equals(newFRIds.get(0))) continue;
                    defaultFIndex = footerReferenceList.indexOf(ctHdrFtrRef);
                }
                if (defaultFIndex != -1) {
                    sectPr1.removeFooterReference(defaultFIndex);
                }
            }
            commonSectPr = sectPr1;
        }
        ArrayList<XWPFParagraph> emptySectPs = new ArrayList<XWPFParagraph>();
        for (XWPFParagraph paragraph : paragraphList) {
            CTPPr pPr = paragraph.getCTP().getPPr();
            if (pPr == null) continue;
            CTSectPr sectPr = pPr.getSectPr();
            if (sectPr != null) {
                List footerReferenceList;
                List headerReferenceList = sectPr.getHeaderReferenceList();
                if (HussarUtils.isEmpty((Object)headerReferenceList) && HussarUtils.isNotEmpty(newHRIds)) {
                    emptySectPs.clear();
                    String emptyId = newHRIds.get(0);
                    CTHdrFtrRef ctHdrFtrRef = sectPr.addNewHeaderReference();
                    ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
                    ctHdrFtrRef.setId(emptyId);
                }
                if (!HussarUtils.isEmpty((Object)(footerReferenceList = sectPr.getFooterReferenceList())) || !HussarUtils.isNotEmpty(newFRIds)) continue;
                emptySectPs.clear();
                String emptyId = newFRIds.get(0);
                CTHdrFtrRef ctHdrFtrRef = sectPr.addNewFooterReference();
                ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
                ctHdrFtrRef.setId(emptyId);
                continue;
            }
            emptySectPs.add(paragraph);
        }
        if (HussarUtils.isNotEmpty(emptySectPs) && (pPr1 = (emptySectP = (XWPFParagraph)emptySectPs.get(emptySectPs.size() - 1)).getCTP().getPPr()) != null) {
            CTSectPr ctSectPr = pPr1.addNewSectPr();
            XmlObject copy = commonSectPr.copy();
            ctSectPr.set(copy);
        }
    }

    private void lastSectPrHandle(XWPFDocument xwpfDocument, List<String> newHRIds, List<String> newFRIds) {
        List paragraphList = xwpfDocument.getParagraphs();
        for (XWPFParagraph paragraph : paragraphList) {
            List footerReferenceList;
            CTSectPr sectPr;
            CTPPr pPr = paragraph.getCTP().getPPr();
            if (pPr == null || (sectPr = pPr.getSectPr()) == null) continue;
            List headerReferenceList = sectPr.getHeaderReferenceList();
            if (HussarUtils.isEmpty((Object)headerReferenceList) && HussarUtils.isNotEmpty(newHRIds)) {
                String emptyId = newHRIds.get(0);
                CTHdrFtrRef ctHdrFtrRef = sectPr.addNewHeaderReference();
                ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
                ctHdrFtrRef.setId(emptyId);
            }
            if (!HussarUtils.isEmpty((Object)(footerReferenceList = sectPr.getFooterReferenceList())) || !HussarUtils.isNotEmpty(newFRIds)) continue;
            String emptyId = newFRIds.get(0);
            CTHdrFtrRef ctHdrFtrRef = sectPr.addNewFooterReference();
            ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
            ctHdrFtrRef.setId(emptyId);
        }
    }

    private String getPartName(PackagePartName partName) {
        String name = partName.getName();
        String regex = "/[^/]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(name);
        String pName = matcher.find() ? matcher.group().substring(1) : "";
        return pName;
    }

    private void handleAppendWord(XWPFDocument src, List<JSONObject> datas, XWPFDocument xwpfDocument2, XmlOptions optionsOuter, StringBuilder sb, JSONObject parse, List<String> newHRIds, List<String> newFRIds) throws InvalidFormatException, IOException, XmlException {
        CTPageSz pageSz;
        CTSectPr sectPr;
        int index;
        HashMap<String, String> rId_Type = new HashMap<String, String>();
        List headerList1 = xwpfDocument2.getHeaderList();
        List footerList = xwpfDocument2.getFooterList();
        if (HussarUtils.isNotEmpty((Object)headerList1) || HussarUtils.isNotEmpty((Object)footerList)) {
            String partName;
            String relationId;
            Object ctHdrFtr;
            XWPFParagraph paragraph;
            CTHdrFtr hdr;
            XWPFHeader wrapper;
            int i;
            XWPFRelation relation;
            HdrDocument hdrDoc;
            if (datas.indexOf(parse) == datas.size() - 1) {
                this.lastSectPrHandle(xwpfDocument2, newHRIds, newFRIds);
            } else {
                this.firstSectPrHandle(xwpfDocument2, newHRIds, newFRIds);
                if (HussarUtils.isNotEmpty((Object)xwpfDocument2.getDocument().getBody().getSectPr())) {
                    xwpfDocument2.getDocument().getBody().unsetSectPr();
                }
            }
            HashMap<String, String> newRId_Type = new HashMap<String, String>();
            for (XWPFHeader xwpfHeader1 : headerList1) {
                hdrDoc = HdrDocument.Factory.newInstance();
                relation = XWPFRelation.HEADER;
                i = this.getRelationIndex(src, relation);
                wrapper = (XWPFHeader)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
                wrapper.setXWPFDocument(src);
                hdr = this.buildHdr(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
                wrapper.setHeaderFooter(hdr);
                hdrDoc.setHdr(hdr);
                for (XWPFParagraph xwpfParagraph : xwpfHeader1.getParagraphs()) {
                    paragraph = wrapper.createParagraph();
                    paragraph.getCTP().set(xwpfParagraph.getCTP().copy());
                }
                ctHdrFtr = xwpfHeader1._getHdrFtr();
                wrapper.setHeaderFooter((CTHdrFtr)ctHdrFtr);
                relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
                newHRIds.add(relationId);
                partName = this.getPartName(xwpfHeader1.getPackagePart().getPartName());
                newRId_Type.put(relationId, partName);
            }
            for (XWPFFooter xwpfFooter : footerList) {
                hdrDoc = HdrDocument.Factory.newInstance();
                relation = XWPFRelation.FOOTER;
                i = this.getRelationIndex(src, relation);
                wrapper = (XWPFFooter)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
                wrapper.setXWPFDocument(src);
                hdr = this.buildHdr(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
                wrapper.setHeaderFooter(hdr);
                hdrDoc.setHdr(hdr);
                for (XWPFParagraph xwpfParagraph : xwpfFooter.getParagraphs()) {
                    paragraph = wrapper.createParagraph();
                    paragraph.getCTP().set(xwpfParagraph.getCTP().copy());
                }
                ctHdrFtr = xwpfFooter._getHdrFtr();
                wrapper.setHeaderFooter((CTHdrFtr)ctHdrFtr);
                relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
                newFRIds.add(relationId);
                partName = this.getPartName(xwpfFooter.getPackagePart().getPartName());
                newRId_Type.put(relationId, partName);
            }
            ArrayList parts = xwpfDocument2.getPackage().getParts();
            PackagePart docPackagePart = parts.stream().filter(part -> part.getContentType().equals("application/vnd.openxmlformats-package.relationships+xml") && part.getPartName().getName().equals("/word/_rels/document.xml.rels")).findFirst().get();
            InputStream inputStream1 = docPackagePart.getInputStream();
            XmlOptions options = new XmlOptions();
            XmlObject xmlObject = XmlObject.Factory.parse((InputStream)inputStream1, (XmlOptions)options);
            String xmlString = xmlObject.toString();
            String regexForId = "Id\\s*=\\s*\"([^\"]*)\"";
            String regexForTarget = "Target\\s*=\\s*\"([^\"]*)\"";
            Pattern patternId = Pattern.compile(regexForId);
            Pattern patternTarget = Pattern.compile(regexForTarget);
            Matcher matcherId = patternId.matcher(xmlString);
            Matcher matcherTarget = patternTarget.matcher(xmlString);
            while (matcherTarget.find() && matcherId.find()) {
                if (!matcherTarget.group(1).contains("header") && !matcherTarget.group(1).contains("footer")) continue;
                rId_Type.put(matcherId.group(1), matcherTarget.group(1));
            }
            for (String rId : rId_Type.keySet()) {
                String type = (String)rId_Type.get(rId);
                for (String newRid : newRId_Type.keySet()) {
                    String newType = (String)newRId_Type.get(newRid);
                    if (!newType.equals(type)) continue;
                    rId_Type.put(rId, newRid);
                }
            }
        }
        if ((index = datas.indexOf(parse)) == 0) {
            return;
        }
        if (index != datas.size() - 1 && (sectPr = xwpfDocument2.getDocument().getBody().getSectPr()) != null && (pageSz = sectPr.getPgSz()) != null) {
            int width = pageSz.getW().intValue();
            int height = pageSz.getH().intValue();
            System.out.println("\u9875\u9762\u5bbd\u5ea6\uff1a" + width + " TWIPS");
            System.out.println("\u9875\u9762\u9ad8\u5ea6\uff1a" + height + " TWIPS");
            CTBody body = xwpfDocument2.getDocument().getBody();
            CTPPr ctpPr1 = body.addNewP().addNewPPr();
            CTSectPr ctSectPr1 = ctpPr1.addNewSectPr();
            ctSectPr1.addNewType().setVal(STSectionMark.NEXT_PAGE);
            CTPageSz pageSize = ctSectPr1.addNewPgSz();
            pageSize.setOrient(STPageOrientation.LANDSCAPE);
            pageSize.setW(BigInteger.valueOf(width));
            pageSize.setH(BigInteger.valueOf(height));
        }
        List allPictures = xwpfDocument2.getAllPictures();
        HashMap<String, String> map = new HashMap<String, String>();
        for (XWPFPictureData picture : allPictures) {
            String before = xwpfDocument2.getRelationId((POIXMLDocumentPart)picture);
            String after = src.addPictureData(picture.getData(), 6);
            map.put(before, after);
        }
        LOGGER.info("\u6b63\u5728\u5408\u5e76\u7b2c\uff1a{}\u4e2a\u6587\u6863", (Object)index);
        CTBody src2Body = xwpfDocument2.getDocument().getBody();
        String appendString = src2Body.xmlText(optionsOuter);
        src2Body = null;
        String addPart = appendString.substring(appendString.indexOf(">") + 1, appendString.lastIndexOf("<"));
        map.putAll(rId_Type);
        if (map != null && !map.isEmpty()) {
            String patter = StringUtils.join(map.keySet(), (String)"|");
            Pattern compile = Pattern.compile(patter);
            Matcher matcher = compile.matcher(addPart);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String value = (String)map.get(matcher.group());
                if (value == null) continue;
                matcher.appendReplacement(stringBuffer, value);
            }
            matcher.appendTail(stringBuffer);
            addPart = stringBuffer.toString();
        }
        appendString = null;
        sb.append(addPart);
        addPart = null;
        xwpfDocument2.close();
        xwpfDocument2 = null;
        LOGGER.info("\u7b2c\uff1a{}\u4e2a\u6587\u6863\u5408\u5e76\u5b8c\u6210", (Object)index);
    }

    public static XWPFDocument appendBody(XWPFDocument src, XWPFDocument append) throws Exception {
        CTBody src1Body = src.getDocument().getBody();
        XWPFRun run = src.createParagraph().createRun();
        run.addBreak(BreakType.PAGE);
        CTBody src2Body = append.getDocument().getBody();
        List allPictures = append.getAllPictures();
        HashMap<String, String> map = new HashMap<String, String>();
        for (XWPFPictureData picture : allPictures) {
            String before = append.getRelationId((POIXMLDocumentPart)picture);
            String after = src.addPictureData(picture.getData(), 6);
            map.put(before, after);
        }
        WordHandle.appendBody(src1Body, src2Body, map);
        return src;
    }

    private static void appendBody(CTBody src, CTBody append, Map<String, String> map) throws Exception {
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String appendString = append.xmlText(optionsOuter);
        String srcString = src.xmlText();
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String mainPart = srcString.substring(srcString.indexOf(">") + 1, srcString.lastIndexOf("<"));
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        String addPart = appendString.substring(appendString.indexOf(">") + 1, appendString.lastIndexOf("<"));
        if (map != null && !map.isEmpty()) {
            String patter = StringUtils.join(map.keySet(), (String)"|");
            Pattern compile = Pattern.compile(patter);
            Matcher matcher = compile.matcher(addPart);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String value = map.get(matcher.group());
                if (value == null) continue;
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            addPart = sb.toString();
        }
        CTBody makeBody = CTBody.Factory.parse((String)(prefix + mainPart + addPart + sufix));
        src.set((XmlObject)makeBody);
    }

    private int entryHandleBatch(Map<String, String> rIdMap, String mark, List<JSONObject> datas, String inputFilePath, AttachmentManagerModelVo attachmentManagerModelVo, Map<String, String> widgets, List<XWPFDocument> documents, int taskState, List<XWPFDocument> documentList, List<XWPFDocument> xwpfDocuments, List<FileOutputStream> outputStreams, List<File> files, StringBuilder stringBuilder, List<String> newHrIds, List<String> newFrIds) throws IOException {
        InputStream cssInput;
        File filePath = new File(this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator + "temporary" + File.separator);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        String css = HussarUtils.isNotEmpty((Object)(cssInput = WordHandle.class.getResourceAsStream("/wordPrint/wordPrint.css"))) ? this.getContent(cssInput) : "";
        FileInputStream inputStream = new FileInputStream(inputFilePath);
        ByteArrayOutputStream baos = WordHandle.cloneInputStream(inputStream);
        XmlOptions optionsOuter = new XmlOptions();
        String rId = "";
        for (JSONObject parse : datas) {
            LOGGER.info("\u6b63\u5728\u5904\u7406\u7b2c\uff1a{}\u6761\u6570\u636e", (Object)(datas.indexOf(parse) + 1));
            taskState = this.handleBatchParse(mark, datas, inputFilePath, attachmentManagerModelVo, widgets, documents, taskState, documentList, xwpfDocuments, outputStreams, files, parse, css, baos, null, optionsOuter, stringBuilder, newHrIds, newFrIds);
            rId = String.valueOf(parse.getOrDefault((Object)"_rId_", (Object)""));
        }
        if (HussarUtils.isNotEmpty((Object)cssInput)) {
            cssInput.close();
        }
        rIdMap.put("_rId_", rId);
        inputStream.close();
        baos.close();
        return taskState;
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            LOGGER.error("-------\u53d1\u751f\u672a\u77e5\u5f02\u5e38:{}", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleBatchParse(String mark, List<JSONObject> datas, String inputFilePath, AttachmentManagerModelVo attachmentManagerModelVo, Map<String, String> widgets, List<XWPFDocument> documents, int taskState, List<XWPFDocument> documentList, List<XWPFDocument> xwpfDocuments, List<FileOutputStream> outputStreams, List<File> files, JSONObject parse, String css, ByteArrayOutputStream baos, XWPFDocument doc, XmlOptions optionsOuter, StringBuilder stringBuilder, List<String> newHRIds, List<String> newFRIds) throws IOException {
        long timestamp = System.currentTimeMillis();
        Path temporaryPath = Paths.get(this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator + "temporary" + File.separator + timestamp + DOCX_SUFFIX, new String[0]);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        XWPFDocument document1 = new XWPFDocument((InputStream)inputStream);
        try {
            HashMap<String, String> richTextMap = new HashMap<String, String>();
            JSONObject parseHtml = new JSONObject();
            LinkedHashMap<String, List<String>> cssParse = new LinkedHashMap<String, List<String>>();
            ArrayList delParse = new ArrayList();
            ArrayList underParse = new ArrayList();
            cssParse.put("-\u5220\u9664\u7ebf-", delParse);
            cssParse.put("-\u4e0b\u5212\u7ebf-", underParse);
            this.handleRichHtml(css, parse, widgets, cssParse, parseHtml);
            document1 = this.generateRichWord(document1, widgets, parseHtml, richTextMap, temporaryPath, cssParse, parse, outputStreams, documentList, files);
            if (HussarUtils.isNotEmpty((Object)mark)) {
                DocxUtil.makeFullWaterMarkByWordArt(parse, document1, mark);
            }
            if (HussarUtils.isEmpty(documents)) {
                documents.add(document1);
                if (HussarUtils.isNotEmpty((Object)document1.getHeaderList())) {
                    this.createEmptyHeader(document1, newHRIds);
                }
                if (HussarUtils.isNotEmpty((Object)document1.getFooterList())) {
                    this.createEmptyFooter(document1, newFRIds);
                }
                if (HussarUtils.isNotEmpty((Object)document1.getFooterList()) || HussarUtils.isNotEmpty((Object)document1.getHeaderList())) {
                    this.firstSectPrHandle(document1, newHRIds, newFRIds);
                }
            } else {
                this.handleAppendWord(documents.get(0), datas, document1, optionsOuter, stringBuilder, parse, newHRIds, newFRIds);
            }
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            taskState = -1;
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            ((InputStream)inputStream).close();
            if (datas.indexOf(parse) != 0 && HussarUtils.isNotEmpty((Object)document1)) {
                document1.close();
            }
            for (File f : files) {
                if (!HussarUtils.isNotEmpty((Object)f) || !f.exists()) continue;
                boolean delete = f.delete();
                LOGGER.info("-------\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)delete);
            }
        }
        if (datas.indexOf(parse) != 0 && HussarUtils.isNotEmpty((Object)document1)) {
            document1.close();
        }
        for (File f : files) {
            if (!HussarUtils.isNotEmpty((Object)f) || !f.exists()) continue;
            boolean delete = f.delete();
            LOGGER.info("-------\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)delete);
        }
        HASH_MAP.clear();
        return taskState;
    }

    private void handleRichHtml(String css, JSONObject parse, Map<String, String> widgets, Map<String, List<String>> cssParse, JSONObject parseHtml) throws IOException {
        if (HussarUtils.isNotEmpty((Object)parse)) {
            this.handleRich(parse, widgets, parseHtml, css, cssParse, null);
            for (String key : parse.keySet()) {
                this.handleSu(parse, widgets, key, parseHtml, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XWPFDocument generateRichWord(XWPFDocument document1, Map<String, String> widgets, JSONObject parseHtml, Map<String, String> richTextMap, Path temporaryPath, Map<String, List<String>> cssParse, JSONObject parse, List<FileOutputStream> outputStreams, List<XWPFDocument> documentList, List<File> files) throws IOException {
        XWPFTemplate template = null;
        FileOutputStream out = null;
        XWPFDocument document = null;
        File file = null;
        try {
            this.generateWordForRichText(HASH_MAP, document1, widgets, parseHtml, richTextMap);
            if (HussarUtils.isNotEmpty(richTextMap)) {
                ConfigureBuilder configureBuilder = Configure.builder();
                for (String key : richTextMap.keySet()) {
                    configureBuilder.bind(key, (RenderPolicy)new HtmlRenderPolicy());
                }
                Configure configure = configureBuilder.build();
                template = XWPFTemplate.compile((XWPFDocument)document1, (Configure)configure);
                template.render(richTextMap);
                file = new File(temporaryPath.toString());
                out = new FileOutputStream(file);
                template.write((OutputStream)out);
                document = new XWPFDocument(Files.newInputStream(Paths.get(String.valueOf(temporaryPath), new String[0]), new OpenOption[0]));
            } else {
                document = document1;
            }
            List paragraphs = document.getParagraphs();
            this.handleHtmlColor(paragraphs, cssParse);
            this.handleTableHtmlColor(document, cssParse);
            XWPFDocument xWPFDocument = this.generateWord(HASH_MAP, document, widgets, parse, richTextMap);
            return xWPFDocument;
        }
        catch (Exception e) {
            LOGGER.error("Word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (template != null) {
                    template.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("-------\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            if (HussarUtils.isNotEmpty((Object)file) && file.exists()) {
                boolean delete = file.delete();
                LOGGER.info("-------\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)delete);
            }
        }
        return null;
    }

    private void handleSu(JSONObject parse, Map<String, String> widgets, String key, JSONObject parse1, Integer index) {
        String content = "";
        String signature = "";
        String approveTime = "";
        String html = "";
        StringBuilder allBody = new StringBuilder();
        if (HussarUtils.isNotEmpty((Object)widgets.get(key)) && widgets.get(key).equals(WidgetType.JXDNSuggestion.getType())) {
            JSONArray array;
            String widgetStr = widgets.get("widgetsStr");
            JSONArray a1 = JSON.parseArray((String)widgetStr);
            for (Object o : a1) {
                JSONObject object;
                List list;
                JSONObject jsonObject;
                Object name;
                if (!(o instanceof JSONObject) || !HussarUtils.isNotEmpty((Object)(name = (jsonObject = (JSONObject)o).get((Object)"name"))) || !String.valueOf(name).equals(key) || (list = (List)(object = (JSONObject)jsonObject.get((Object)"props")).get((Object)"showFields")).size() != 1 || !((String)list.get(0)).equals("name") || !HussarUtils.isEmpty((Object)index)) continue;
                return;
            }
            Object object = parse.get((Object)key);
            if (HussarUtils.isNotEmpty((Object)object) && HussarUtils.isNotEmpty((Object)(array = JSON.parseArray((String)String.valueOf(object))))) {
                for (Object object1 : array) {
                    Object object3;
                    HashSet<String> set = new HashSet<String>();
                    String text = "";
                    if (!HussarUtils.isNotEmpty(object1)) continue;
                    JSONObject jsonObject = (JSONObject)object1;
                    Object object2 = jsonObject.get((Object)"content");
                    if (HussarUtils.isNotEmpty((Object)object2)) {
                        set.add("content");
                        content = String.valueOf(object2);
                    }
                    if (HussarUtils.isNotEmpty((Object)(object3 = jsonObject.get((Object)"signature")))) {
                        set.add("user");
                        signature = String.valueOf(object3);
                        text = "<imgsrc=\"" + signature + "\">\n";
                    } else {
                        Object object5 = jsonObject.get((Object)"userName");
                        if (HussarUtils.isNotEmpty((Object)object5)) {
                            set.add("user");
                            text = signature = String.valueOf(object5);
                        }
                    }
                    Object object4 = jsonObject.get((Object)"approveTime");
                    if (HussarUtils.isNotEmpty((Object)object4)) {
                        set.add("time");
                        approveTime = String.valueOf(object4);
                        approveTime = this.handleApproveTime(approveTime, widgets, key);
                    }
                    html = set.contains("content") ? SuggestionTemp.getHtml() : SuggestionTemp.getNoContentHtml();
                    String body = SuggestionTemp.getBody(set);
                    String replace = body.replace("{{content}}", content).replace("{{approveTime}}", approveTime).replace("{{user}}", text);
                    allBody.append(replace);
                }
            }
            html = html.replace("{{template}}", allBody.toString());
            String oldKey = key;
            if (HussarUtils.isNotEmpty((Object)index)) {
                key = key + index.toString();
                parse.put(oldKey, (Object)("{{" + key + "}}"));
                parse1.put(key, (Object)html);
            } else {
                parse.put(key, (Object)html);
                parse1.put(key, (Object)html);
            }
        }
    }

    public String handleApproveTime(String approveTime, Map<String, String> widgets, String key) {
        String string = widgets.get("widgetsStr");
        String format = "";
        if (HussarUtils.isNotEmpty((Object)string)) {
            String widget = JSON.parseArray((String)string);
            Iterator iterator = widget.iterator();
            while (iterator.hasNext()) {
                JSONObject jsonObject;
                Object object;
                Object o = iterator.next();
                if (!HussarUtils.isNotEmpty(o) || !String.valueOf(object = (jsonObject = (JSONObject)o).get((Object)"name")).equals(key)) continue;
                Object object1 = jsonObject.get((Object)"props");
                JSONObject props = (JSONObject)object1;
                Object object2 = props.get((Object)"format");
                format = String.valueOf(object2);
                break;
            }
        }
        switch (format) {
            case "yyyy-MM-dd HH": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6";
                break;
            }
            case "yyyy-MM-dd": {
                format = "yyyy\u5e74MM\u6708dd\u65e5";
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206";
                break;
            }
            case "yyyy-MM-dd HH:mm:ss": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
            }
        }
        long timestamp = Long.parseLong(approveTime);
        LocalDateTime dateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return dateTime.format(formatter);
    }

    private void handleTable(Document doc, Map<String, List<String>> cssParse, String html) {
    }

    private String handleMark(Document doc, Map<String, List<String>> cssParse, String html) {
        Elements marks = doc.select("mark");
        for (Element markCss : marks) {
            String cssClass = markCss.attr("class");
            String text = markCss.text();
            ArrayList<String> color = new ArrayList<String>();
            switch (cssClass) {
                case "marker-yellow": {
                    this.setCss(cssParse, markCss, text, color, "yellow");
                    break;
                }
                case "marker-green": {
                    this.setCss(cssParse, markCss, text, color, "green");
                    break;
                }
                case "marker-blue": {
                    this.setCss(cssParse, markCss, text, color, "72ccfd");
                    break;
                }
                case "marker-pink": {
                    this.setCss(cssParse, markCss, text, color, "fc7899");
                    break;
                }
                case "pen-red": {
                    this.setCss(cssParse, markCss, text, color, "e71313");
                    break;
                }
                case "pen-green": {
                    this.setCss(cssParse, markCss, text, color, "128a00");
                }
            }
        }
        return doc.html();
    }

    private String handleUnderLand(Document doc, Map<String, List<String>> cssParse, String html) {
        List<String> underParse = cssParse.get("-\u4e0b\u5212\u7ebf-");
        Elements marks = doc.select("u");
        for (Element markCss : marks) {
            String text = markCss.text();
            String patternString = "%(.*?)%";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) {
                markCss.text("%" + text + "%");
            }
            underParse.add(text);
        }
        cssParse.put("-\u4e0b\u5212\u7ebf-", underParse);
        return doc.html();
    }

    private String handleDelete(Document doc, Map<String, List<String>> cssParse, String html) {
        List<String> delParse = cssParse.get("-\u5220\u9664\u7ebf-");
        Elements marks = doc.select("s");
        for (Element markCss : marks) {
            String text = markCss.text();
            String patternString = "%(.*?)%";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) {
                markCss.text("%" + text + "%");
                delParse.add(text);
                continue;
            }
            delParse.add(matcher.group(1));
        }
        cssParse.put("-\u5220\u9664\u7ebf-", delParse);
        return doc.html();
    }

    private void setCss(Map<String, List<String>> cssParse, Element markCss, String text, List<String> color, String css) {
        String patternString = "%(.*?)%";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            text = matcher.group(1);
        }
        if (!cssParse.containsKey(text)) {
            color.add(css);
            cssParse.put(text, color);
        } else {
            cssParse.get(text).add(css);
        }
        markCss.text("%" + text + "%");
    }

    private String handleSpan(Document doc, Map<String, List<String>> cssParse, String html) {
        Elements spans = doc.select("span");
        for (Element span : spans) {
            String pattern;
            Pattern p;
            Matcher m;
            String style = span.attr("style");
            String text = span.text();
            if (!style.contains("background-color") || !(m = (p = Pattern.compile(pattern = "background-color:#[0-9a-fA-F]+;")).matcher(style)).matches()) continue;
            ArrayList<String> color = new ArrayList<String>();
            style = m.group();
            color.add(style.substring(style.indexOf("#") + 1, style.indexOf(";")));
            span.text("%" + text + "%");
            if (!cssParse.containsKey(text)) {
                cssParse.put(text, color);
                continue;
            }
            cssParse.get(text).add(style.substring(style.indexOf("#") + 1, style.indexOf(";")));
        }
        return doc.html();
    }

    private void handleHtmlColor(List<XWPFParagraph> paragraphs, Map<String, List<String>> cssParse) {
        List<String> under = cssParse.get("-\u4e0b\u5212\u7ebf-");
        List<String> del = cssParse.get("-\u5220\u9664\u7ebf-");
        for (XWPFParagraph paragraph : paragraphs) {
            List runs = paragraph.getRuns();
            block1: for (XWPFRun run : runs) {
                String text = run.text();
                for (String key : cssParse.keySet()) {
                    String patternString = "%(.*?)%";
                    Pattern pattern = Pattern.compile(patternString);
                    Matcher matcher = pattern.matcher(text);
                    if (!matcher.find()) continue;
                    String group = matcher.group(1);
                    if (key.equals(group)) {
                        run.setText("", 0);
                        run.setText(key, 0);
                        String cssParseString = "";
                        List<String> list = cssParse.get(key);
                        if (!list.isEmpty()) {
                            cssParseString = list.get(0);
                            list.remove(0);
                        }
                        if (cssParseString.equals("yellow") || cssParseString.equals("green")) {
                            run.setTextHighlightColor(cssParseString);
                            continue block1;
                        }
                        if (cssParseString.equals("e71313") || cssParseString.equals("128a00")) {
                            run.setColor(cssParseString);
                            continue block1;
                        }
                        CTShd shd = CTShd.Factory.newInstance();
                        shd.setFill((Object)cssParseString);
                        shd.setVal(STShd.CLEAR);
                        run.getCTR().getRPr().setShd(shd);
                        continue block1;
                    }
                    if (under.contains(group)) {
                        run.setUnderline(UnderlinePatterns.SINGLE);
                        under.remove(key);
                    }
                    if (!del.contains(group)) continue;
                    run.setStrikeThrough(true);
                    del.remove(key);
                }
            }
        }
    }

    private void handleTableHtmlColor(XWPFDocument doc, Map<String, List<String>> cssParse) {
        List tables = doc.getTables();
        if (HussarUtils.isNotEmpty((Object)tables)) {
            tables.forEach(xwpfTable -> {
                List rows = xwpfTable.getRows();
                if (HussarUtils.isNotEmpty((Object)rows)) {
                    rows.forEach(xwpfTableRow -> {
                        List tableCells = xwpfTableRow.getTableCells();
                        if (HussarUtils.isNotEmpty((Object)tableCells)) {
                            tableCells.forEach(xwpfTableCell -> {
                                if (HussarUtils.isNotEmpty((Object)xwpfTableCell)) {
                                    List tableCellParagraphs = xwpfTableCell.getParagraphs();
                                    this.handleHtmlColor(tableCellParagraphs, cssParse);
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private void closeFile(FileOutputStream o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeInputFile(FileInputStream o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeOutputStream(OutputStream o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeTemplate(XWPFTemplate o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeXWPFDocument(XWPFDocument o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private String matcherColor(String htmlString) {
        HashMap hslColors = new HashMap();
        Pattern pattern = Pattern.compile(MATCHER_COLOR);
        Matcher matcher = pattern.matcher(htmlString);
        while (matcher.find()) {
            ArrayList<String> list = new ArrayList<String>();
            String hue = matcher.group(1);
            String saturation = matcher.group(2);
            String lightness = matcher.group(3);
            list.add(hue);
            list.add(saturation);
            list.add(lightness);
            hslColors.put(matcher.group(0), list);
        }
        if (HussarUtils.isNotEmpty(hslColors)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry entry : hslColors.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                double hue = Double.parseDouble((String)value.get(0));
                double saturation = Double.parseDouble((String)value.get(1));
                double lightness = Double.parseDouble((String)value.get(2));
                String hex = this.gentHex(hue, saturation, lightness);
                map.put(key, hex);
            }
            for (Map.Entry entry : map.entrySet()) {
                htmlString = htmlString.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return htmlString;
    }

    public String gentHex(double H, double S, double L) {
        int[] rgb = WordHandle.hslToRgb(H /= 360.0, S /= 100.0, L /= 100.0);
        int red = rgb[0];
        int green = rgb[1];
        int blue = rgb[2];
        return String.format("#%02x%02x%02x", red, green, blue);
    }

    private static int[] hslToRgb(double h, double s, double l) {
        double r;
        double g;
        double b;
        if (s == 0.0) {
            g = b = l;
            r = b;
        } else {
            double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
            double p = 2.0 * l - q;
            r = WordHandle.hueToRgb(p, q, h + 0.3333333333333333);
            g = WordHandle.hueToRgb(p, q, h);
            b = WordHandle.hueToRgb(p, q, h - 0.3333333333333333);
        }
        int red = (int)Math.round(r * 255.0);
        int green = (int)Math.round(g * 255.0);
        int blue = (int)Math.round(b * 255.0);
        return new int[]{red, green, blue};
    }

    private static double hueToRgb(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (t < 0.16666666666666666) {
            return p + (q - p) * 6.0 * t;
        }
        if (t < 0.5) {
            return q;
        }
        if (t < 0.6666666666666666) {
            return p + (q - p) * (0.6666666666666666 - t) * 6.0;
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void wordHandle(WordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)this.getFormatTime(timeStart));
            if (HussarUtils.isEmpty((Object)wordPrintParamsDto)) {
                throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String formId = wordPrintParamsDto.getFormId();
            String id = wordPrintParamsDto.getId();
            String templateId = wordPrintParamsDto.getTemplateId();
            String appId = wordPrintParamsDto.getAppId();
            String processInstId = wordPrintParamsDto.getProcessInstId();
            String businessId = wordPrintParamsDto.getBusinessId();
            String tabType = wordPrintParamsDto.getTabType();
            String exportType = wordPrintParamsDto.getExportType();
            String viewId = wordPrintParamsDto.getViewId();
            List filters = wordPrintParamsDto.getFilter();
            Object data = null;
            if (HussarUtils.isEmpty((Object)exportType)) {
                data = ((ApiResponse)this.sysPrintTemplateService.formQuery(formId, id, tabType, appId).getBody()).getData();
            } else {
                HashMap<String, List> params = new HashMap<String, List>();
                List ids = wordPrintParamsDto.getIds();
                if (HussarUtils.isNotEmpty((Object)ids)) {
                    Filter idsFilter = new Filter();
                    idsFilter.setField("RECORD_ID");
                    idsFilter.setMatch("AND");
                    idsFilter.setRule("_in");
                    idsFilter.setVal(String.join((CharSequence)",", ids));
                    filters.add(idsFilter);
                }
                params.put("superQueryConditionDto", filters);
                data = ((ApiResponse)this.sysPrintTemplateService.tableQuery(formId, viewId, params, appId).getBody()).getData();
            }
            if (HussarUtils.isEmpty((Object)data)) {
                throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            WidgetsAndData widgetsAndData = (WidgetsAndData)data;
            EngineResultEntity entity = widgetsAndData.getEntity();
            Map widgets = widgetsAndData.getMap();
            String jsonString = JSON.toJSONString((Object)entity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject parse = (JSONObject)JSONObject.parse((String)jsonString);
            parse.put("exportType", (Object)exportType);
            parse.put("langCode", (Object)wordPrintParamsDto.getLangCode());
            if (HussarUtils.isNotEmpty((Object)processInstId) && HussarUtils.isNotEmpty((Object)businessId)) {
                BpmResponseResult result = InstanceEngineService.queryFlowHistoryInfo((String)businessId, (String)processInstId);
                JSONArray jsonArray = result.getResult();
                JSONArray jsonArray1 = this.getFlowInfo(jsonArray, processInstId, businessId);
                parse.put("flowHistoryInfo", (Object)jsonArray1);
            }
            String printTime = this.getFormatTime(System.currentTimeMillis());
            String printTimeNoHour = this.getFormatTimeNoHour(System.currentTimeMillis());
            UserDetails userDetails = wordPrintParamsDto.getUserDetails();
            if (parse.containsKey((Object)"\u4e3b\u8868")) {
                Object object = parse.get((Object)"\u4e3b\u8868");
                JSONArray jsonArray = (JSONArray)object;
                jsonArray.forEach(o -> {
                    JSONObject jsonObject = (JSONObject)o;
                    jsonObject.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
                    jsonObject.put("printDateTime", (Object)printTime);
                });
            }
            parse.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
            String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
            parse.put("printDateTime", (Object)printTime);
            JSONObject content = (JSONObject)JSON.parseObject((String)((SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId))).getContent(), JSONObject.class);
            Long fileID = Long.valueOf(String.valueOf(content.get((Object)"id")));
            AttachmentManagerModelVo attachmentManagerServiceByFileId = this.ossService.getByFileId(fileID);
            if (HussarUtils.isEmpty((Object)attachmentManagerServiceByFileId)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId));
            if (HussarUtils.isEmpty((Object)printTemplate)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String fileName = this.handlerGeneFileName(printTemplate, printTimeNoHour, formId, parse, DOCX_SUFFIX);
            String outputPathNew = this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator;
            long fileId = Long.parseLong(this.gene16Num());
            String outputFilePath = outputPathNew + File.separator + fileId + DOCX_SUFFIX;
            File file = new File(outputPathNew);
            if (!file.exists()) {
                file.mkdirs();
            }
            TaskInfo taskInfo = this.entry(mark, parse, this.downLoadCompent.copyOssFile(fileID), outputFilePath, fileName, widgets);
            taskState = taskInfo.getTaskStatus();
            fileId = taskInfo.getFileId();
            this.updateTask(taskState, fileId, taskId);
        }
        catch (Exception e) {
            try {
                LOGGER.error("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                this.updateTask(-1, null, taskId);
            }
            catch (Throwable throwable) {
                long timeEnd = System.currentTimeMillis();
                LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
                EngineUserUtil.remove();
                throw throwable;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
            EngineUserUtil.remove();
        }
        long timeEnd = System.currentTimeMillis();
        LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
        EngineUserUtil.remove();
    }

    private JSONArray getFlowInfo(JSONArray jsonArray, String processInstId, String businessId) {
        JSONArray jsonArray1 = new JSONArray();
        if (HussarUtils.isEmpty((Object)jsonArray)) {
            LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u4e0d\u5b58\u5728,processInstId\uff1a{}\uff0cbusinessId\uff1a{}", (Object)processInstId, (Object)businessId);
            return jsonArray1;
        }
        try {
            if (jsonArray.get(0) instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)jsonArray.get(0);
                Object object = jsonObject.get((Object)"completeList");
                if (object instanceof JSONArray) {
                    jsonArray1 = (JSONArray)object;
                    for (Object o : jsonArray1) {
                        JSONObject jsonObject1 = (JSONObject)o;
                        jsonObject1.put("index", (Object)(jsonArray1.indexOf(o) + 1));
                        Object object1 = jsonObject1.get((Object)"comment");
                        if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                        String comment = String.valueOf(object1);
                        try {
                            JSONObject jsonObject2 = JSON.parseObject((String)comment);
                            jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                        }
                        catch (Exception e) {
                            LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                        }
                    }
                } else if (object instanceof List) {
                    List list = (List)object;
                    jsonArray1.addAll((Collection)list);
                    for (Object o : jsonArray1) {
                        JSONObject jsonObject2;
                        String comment;
                        Object object1;
                        if (o instanceof JSONObject) {
                            JSONObject jsonObject1 = (JSONObject)o;
                            jsonObject1.put("index", (Object)(jsonArray1.indexOf(o) + 1));
                            object1 = jsonObject1.get((Object)"comment");
                            if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                            comment = String.valueOf(object1);
                            try {
                                jsonObject2 = JSON.parseObject((String)comment);
                                jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                            }
                            catch (Exception e) {
                                LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                            }
                            continue;
                        }
                        if (!(o instanceof Map)) continue;
                        Map map = (Map)o;
                        map.put("index", jsonArray1.indexOf(o) + 1);
                        object1 = map.get("comment");
                        if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                        comment = String.valueOf(object1);
                        try {
                            jsonObject2 = JSON.parseObject((String)comment);
                            map.put("comment", jsonObject2.get((Object)"msg"));
                        }
                        catch (Exception e) {
                            LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                        }
                    }
                }
            } else if (jsonArray.get(0) instanceof LinkedHashMap) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)jsonArray.get(0);
                Object object = linkedHashMap.get("completeList");
                if (object instanceof JSONArray) {
                    jsonArray1 = (JSONArray)object;
                    for (Object o : jsonArray1) {
                        JSONObject jsonObject1 = (JSONObject)o;
                        jsonObject1.put("index", (Object)(jsonArray1.indexOf(o) + 1));
                        Object object1 = jsonObject1.get((Object)"comment");
                        if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                        String comment = String.valueOf(object1);
                        try {
                            JSONObject jsonObject2 = JSON.parseObject((String)comment);
                            jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                        }
                        catch (Exception e) {
                            LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                        }
                    }
                } else if (object instanceof List) {
                    List list = (List)object;
                    jsonArray1.addAll((Collection)list);
                    for (Object o : jsonArray1) {
                        JSONObject jsonObject2;
                        String comment;
                        Object object1;
                        if (o instanceof JSONObject) {
                            JSONObject jsonObject1 = (JSONObject)o;
                            jsonObject1.put("index", (Object)(jsonArray1.indexOf(o) + 1));
                            object1 = jsonObject1.get((Object)"comment");
                            if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                            comment = String.valueOf(object1);
                            try {
                                jsonObject2 = JSON.parseObject((String)comment);
                                jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                            }
                            catch (Exception e) {
                                LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                            }
                            continue;
                        }
                        if (!(o instanceof Map)) continue;
                        Map map = (Map)o;
                        map.put("index", jsonArray1.indexOf(o) + 1);
                        object1 = map.get("comment");
                        if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                        comment = String.valueOf(object1);
                        try {
                            jsonObject2 = JSON.parseObject((String)comment);
                            map.put("comment", jsonObject2.get((Object)"msg"));
                        }
                        catch (Exception e) {
                            LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return jsonArray1;
    }

    private void queryFlowHis(String processInstId, String businessId, JSONObject parse) {
        if (HussarUtils.isNotEmpty((Object)processInstId) && HussarUtils.isNotEmpty((Object)businessId)) {
            BpmResponseResult result = InstanceEngineService.queryFlowHistoryInfo((String)businessId, (String)processInstId);
            String objStrAll = JSON.toJSONString((Object)result.getResult());
            JSONArray jsonArray = JSON.parseArray((String)objStrAll);
            JSONArray jsonArray1 = new JSONArray();
            if (HussarUtils.isEmpty((Object)jsonArray)) {
                LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u4e0d\u5b58\u5728,processInstId\uff1a{}\uff0cbusinessId\uff1a{}", (Object)processInstId, (Object)businessId);
            } else {
                try {
                    if (jsonArray.get(0) instanceof JSONObject) {
                        JSONObject jsonObject = (JSONObject)jsonArray.get(0);
                        Object object = jsonObject.get((Object)"completeList");
                        String objStr = JSON.toJSONString((Object)object);
                        jsonArray1 = JSON.parseArray((String)objStr);
                        for (Object o : jsonArray1) {
                            JSONObject jsonObject1 = (JSONObject)o;
                            jsonObject1.put("index", (Object)(jsonArray1.indexOf(o) + 1));
                            Object object1 = jsonObject1.get((Object)"comment");
                            if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                            String comment = String.valueOf(object1);
                            try {
                                JSONObject jsonObject2 = JSON.parseObject((String)comment);
                                jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                            }
                            catch (Exception e) {
                                LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                            }
                        }
                    } else if (jsonArray.get(0) instanceof LinkedHashMap) {
                        LinkedHashMap linkedHashMap = (LinkedHashMap)jsonArray.get(0);
                        Object object = linkedHashMap.get("completeList");
                        String objStr1 = JSON.toJSONString(object);
                        jsonArray1 = JSON.parseArray((String)objStr1);
                        for (Object o : jsonArray1) {
                            JSONObject jsonObject1 = (JSONObject)o;
                            jsonObject1.put("index", (Object)(jsonArray1.indexOf(o) + 1));
                            Object object1 = jsonObject1.get((Object)"comment");
                            if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                            String comment = String.valueOf(object1);
                            try {
                                JSONObject jsonObject2 = JSON.parseObject((String)comment);
                                jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                            }
                            catch (Exception e) {
                                LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u89e3\u6790\u5f02\u5e38,processInstId\uff1a{}\uff0cbusinessId\uff1a{}", (Object)processInstId, (Object)businessId);
                    LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                }
            }
            parse.put("flowHistoryInfo", (Object)jsonArray1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void wordHandleBatch(WordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)this.getFormatTime(timeStart));
            if (HussarUtils.isEmpty((Object)wordPrintParamsDto)) {
                throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String formId = wordPrintParamsDto.getFormId();
            String id = wordPrintParamsDto.getId();
            String templateId = wordPrintParamsDto.getTemplateId();
            String appId = wordPrintParamsDto.getAppId();
            Map flowIds = wordPrintParamsDto.getFlowIds();
            String tabType = wordPrintParamsDto.getTabType();
            String exportType = wordPrintParamsDto.getExportType();
            String viewId = wordPrintParamsDto.getViewId();
            String langCode = wordPrintParamsDto.getLangCode();
            Object data = this.queryDataBatch(exportType, formId, viewId, id, appId, wordPrintParamsDto, tabType);
            if (HussarUtils.isEmpty((Object)data)) {
                throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            WidgetsAndData widgetsAndData = (WidgetsAndData)data;
            EngineResultEntity entity = widgetsAndData.getEntity();
            ArrayList<JSONObject> datas = new ArrayList<JSONObject>();
            this.handleDataBatch(entity, flowIds, datas);
            UserDetails userDetails = wordPrintParamsDto.getUserDetails();
            String printTime = this.getFormatTime(System.currentTimeMillis());
            String printTimeNoHour = this.getFormatTimeNoHour(System.currentTimeMillis());
            datas.forEach(dataItem -> {
                dataItem.put("langCode", (Object)langCode);
                dataItem.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
                dataItem.put("printDateTime", (Object)printTime);
            });
            Map widgets = widgetsAndData.getMap();
            String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
            JSONObject content = (JSONObject)JSON.parseObject((String)((SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId))).getContent(), JSONObject.class);
            Long fileID = Long.valueOf(String.valueOf(content.get((Object)"id")));
            AttachmentManagerModelVo attachmentManagerServiceByFileId = this.ossService.getByFileId(fileID);
            if (HussarUtils.isEmpty((Object)attachmentManagerServiceByFileId)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId));
            if (HussarUtils.isEmpty((Object)printTemplate)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            JSONObject fileNameObj = new JSONObject();
            fileNameObj.put("langCode", (Object)langCode);
            fileNameObj.put("mode", (Object)FileNameMode.DEFAULT.getType());
            String fileName = this.handlerGeneFileName(printTemplate, printTimeNoHour, formId, fileNameObj, DOCX_SUFFIX);
            String outputPathNew = this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator;
            long fileId = Long.parseLong(this.gene16Num());
            String outputFilePath = outputPathNew + File.separator + fileId + DOCX_SUFFIX;
            File file = new File(outputPathNew);
            if (!file.exists()) {
                file.mkdirs();
            }
            TaskInfo taskInfo = this.entryBatch(mark, datas, this.downLoadCompent.copyOssFile(fileID), outputFilePath, fileName, widgets);
            taskState = taskInfo.getTaskStatus();
            fileId = taskInfo.getFileId();
            this.updateTask(taskState, fileId, taskId);
        }
        catch (Exception e) {
            try {
                LOGGER.error("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
                this.updateTask(-1, null, taskId);
            }
            catch (Throwable throwable) {
                long timeEnd = System.currentTimeMillis();
                LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
                EngineUserUtil.remove();
                throw throwable;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
            EngineUserUtil.remove();
        }
        long timeEnd = System.currentTimeMillis();
        LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
        EngineUserUtil.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void childWordHandleBatch(SubWordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)this.getFormatTime(timeStart));
            if (HussarUtils.isEmpty((Object)wordPrintParamsDto)) {
                throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String formId = wordPrintParamsDto.getFormId();
            String id = wordPrintParamsDto.getId();
            String templateId = wordPrintParamsDto.getTemplateId();
            String appId = wordPrintParamsDto.getAppId();
            Map flowIds = wordPrintParamsDto.getFlowIds();
            String tabType = wordPrintParamsDto.getTabType();
            String exportType = wordPrintParamsDto.getExportType();
            String viewId = wordPrintParamsDto.getViewId();
            String langCode = wordPrintParamsDto.getLangCode();
            List childIds = wordPrintParamsDto.getChildIds();
            String childTableName = wordPrintParamsDto.getChildTableName();
            WordPrintParamsDto wordPrintParams = new WordPrintParamsDto();
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id);
            wordPrintParams.setIds(ids);
            Object data = ((ApiResponse)this.sysPrintTemplateService.formQuery(formId, id, tabType, appId).getBody()).getData();
            if (HussarUtils.isEmpty((Object)data)) {
                throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            WidgetsAndData widgetsAndData = (WidgetsAndData)data;
            EngineResultEntity entity = widgetsAndData.getEntity();
            ArrayList<JSONObject> datas = new ArrayList<JSONObject>();
            this.handleDataBatch(entity, flowIds, datas);
            String jsonString = JSON.toJSONString((Object)entity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject1 = JSON.parseObject((String)jsonString);
            datas.add(jsonObject1);
            UserDetails userDetails = wordPrintParamsDto.getUserDetails();
            String printTime = this.getFormatTime(System.currentTimeMillis());
            String printTimeNoHour = this.getFormatTimeNoHour(System.currentTimeMillis());
            datas.forEach(dataItem -> {
                dataItem.put("langCode", (Object)langCode);
                dataItem.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
                dataItem.put("printDateTime", (Object)printTime);
            });
            ArrayList<JSONObject> newDatas = new ArrayList<JSONObject>();
            if (HussarUtils.isNotEmpty(datas)) {
                JSONObject hostData = (JSONObject)datas.get(0);
                Object object = hostData.get((Object)childTableName);
                hostData.put(childTableName, (Object)"");
                if (HussarUtils.isNotEmpty((Object)object)) {
                    List childList = (List)object;
                    childList.forEach(child -> {
                        JSONArray jsonArray = new JSONArray();
                        jsonArray.add(child);
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.putAll((Map)hostData);
                        jsonObject.put(childTableName, (Object)jsonArray);
                        newDatas.add(jsonObject);
                    });
                }
            }
            Map widgets = widgetsAndData.getMap();
            String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
            JSONObject content = (JSONObject)JSON.parseObject((String)((SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId))).getContent(), JSONObject.class);
            Long fileID = Long.valueOf(String.valueOf(content.get((Object)"id")));
            AttachmentManagerModelVo attachmentManagerServiceByFileId = this.ossService.getByFileId(fileID);
            if (HussarUtils.isEmpty((Object)attachmentManagerServiceByFileId)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId));
            if (HussarUtils.isEmpty((Object)printTemplate)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            JSONObject fileNameObj = new JSONObject();
            fileNameObj.put("langCode", (Object)langCode);
            fileNameObj.put("mode", (Object)FileNameMode.DEFAULT.getType());
            String fileName = this.handlerGeneFileName(printTemplate, printTimeNoHour, formId, fileNameObj, DOCX_SUFFIX);
            String outputPathNew = this.hussarFormDesignProperties.getWorkspace() + "wordTemplate" + File.separator;
            Random random = new Random();
            long fileId = random.nextLong() >>> 16 & 0xFFFFL;
            String outputFilePath = outputPathNew + File.separator + fileId + DOCX_SUFFIX;
            File file = new File(outputPathNew);
            if (!file.exists()) {
                file.mkdirs();
            }
            TaskInfo taskInfo = this.entryBatch(mark, newDatas, this.downLoadCompent.copyOssFile(fileID), outputFilePath, fileName, widgets);
            taskState = taskInfo.getTaskStatus();
            fileId = taskInfo.getFileId();
            this.updateTask(taskState, fileId, taskId);
        }
        catch (Exception e) {
            try {
                LOGGER.error("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
                this.updateTask(-1, null, taskId);
            }
            catch (Throwable throwable) {
                long timeEnd = System.currentTimeMillis();
                LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
                EngineUserUtil.remove();
                throw throwable;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
            EngineUserUtil.remove();
        }
        long timeEnd = System.currentTimeMillis();
        LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
        EngineUserUtil.remove();
    }

    public Object queryDataBatch(String exportType, String formId, String viewId, String id, String appId, WordPrintParamsDto wordPrintParamsDto, String tabType) {
        Object data;
        if (HussarUtils.isEmpty((Object)exportType)) {
            data = ((ApiResponse)this.sysPrintTemplateService.formQuery(formId, id, tabType, appId).getBody()).getData();
        } else {
            HashMap params = new HashMap();
            ArrayList<Filter> filters = new ArrayList<Filter>();
            List ids = wordPrintParamsDto.getIds();
            if (HussarUtils.isNotEmpty((Object)ids)) {
                Filter idsFilter = new Filter();
                idsFilter.setField("RECORD_ID");
                idsFilter.setMatch("AND");
                idsFilter.setRule("_in");
                idsFilter.setVal(String.join((CharSequence)",", ids));
                filters.add(idsFilter);
            }
            params.put("superQueryConditionDto", filters);
            data = ((ApiResponse)this.sysPrintTemplateService.tableQuery(formId, viewId, params, appId).getBody()).getData();
        }
        return data;
    }

    public void handleDataBatch(EngineResultEntity entity, Map<String, Map<String, String>> flowIds, List<JSONObject> datas) {
        Object dataObj = entity.get((Object)"\u4e3b\u8868");
        if (HussarUtils.isNotEmpty((Object)dataObj)) {
            List list = (List)dataObj;
            list.forEach(o -> {
                JSONObject jsonObject = new JSONObject(o);
                String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                JSONObject parse = (JSONObject)JSONObject.parse((String)jsonString);
                Object object = parse.get((Object)"RECORD_ID");
                String dataId = String.valueOf(object);
                if (HussarUtils.isNotEmpty((Object)flowIds)) {
                    Map map = (Map)flowIds.get(dataId);
                    String processInstId = (String)map.get("processInstId");
                    String businessId = (String)map.get("businessId");
                    this.queryFlowHis(processInstId, businessId, parse);
                }
                datas.add(parse);
            });
        }
    }

    public void updateTask(int taskState, Long fileId, Long taskId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(SysWordPrintTask::getFileId, (Object)fileId)).set(SysWordPrintTask::getTaskStatus, (Object)taskState)).eq(SysWordPrintTask::getTaskId, (Object)taskId);
        boolean flag = this.sysWordPrintTaskService.update((Wrapper)updateWrapper);
        if (!flag) {
            LOGGER.error("\u6253\u5370\u4efb\u52a1\u66f4\u65b0\u5931\u8d25,\u4efb\u52a1id\uff1a{}", (Object)taskId);
            throw new BaseException("\u6253\u5370\u4efb\u52a1\u66f4\u65b0\u5931\u8d25");
        }
    }

    public String handlerGeneFileName(SysPrintTemplate printTemplate, String printTime, String formId, JSONObject parse, String suffix) {
        String fileName = null;
        Object modeObj = parse.get((Object)"mode");
        SysPrintGeneFileName geneFileName = (SysPrintGeneFileName)JSON.parseObject((String)printTemplate.getFileName(), SysPrintGeneFileName.class);
        if (HussarUtils.isNotEmpty((Object)geneFileName)) {
            if (HussarUtils.isNotEmpty((Object)modeObj)) {
                geneFileName.setMode(Integer.parseInt(String.valueOf(modeObj)));
            }
            FileNameMode mode = FileNameMode.getFileNameMode((int)geneFileName.getMode());
            String template = geneFileName.getTemplate();
            SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
            if (HussarUtils.isEmpty((Object)sysForm)) {
                LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
                throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728");
            }
            switch (Objects.requireNonNull(mode)) {
                case DEFAULT: {
                    Object object = parse.get((Object)"langCode");
                    if (HussarUtils.isNotEmpty((Object)object)) {
                        String langCode = String.valueOf(object);
                        fileName = this.i18nUtil.getCommonI18nByKeys(langCode, sysForm.getI18nKeys(), "formName", sysForm.getFormName());
                    } else {
                        fileName = sysForm.getFormName();
                    }
                    fileName = fileName + "_" + printTime;
                    break;
                }
                case TITLE: {
                    Object o = parse.get((Object)"title");
                    fileName = String.valueOf(o);
                    break;
                }
                case TEMPLATE: {
                    JSONObject parse1 = new JSONObject();
                    parse.put("formName", (Object)sysForm.getFormName());
                    Matcher matcher = this.matcher(template);
                    while (matcher.find()) {
                        String key2 = matcher.group();
                        String value2 = matcher.group(1);
                        parse1.put(key2, (Object)value2);
                    }
                    parse.forEach((key, value) -> parse1.forEach((key1, value1) -> {
                        if (value1.equals(key)) {
                            if (HussarUtils.isEmpty((Object)value)) {
                                parse1.put(key1, (Object)"");
                            } else {
                                parse1.put(key1, value);
                            }
                        }
                    }));
                    fileName = this.replaceText(template, (Map<String, Object>)parse1);
                }
            }
        }
        if (!HussarUtils.isNull(fileName)) {
            String regex = "\\d{4}-\\d{2}-\\d{2}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(fileName);
            while (matcher.find()) {
                String group = matcher.group();
                String replace = group.replace(":", "");
                String replace1 = replace.replace("-", "");
                String replace2 = replace1.replace(" ", "_");
                fileName = fileName.replace(group, replace2);
            }
            fileName = fileName.replace(" ", "");
            fileName = fileName.replace("\\", "");
            fileName = fileName.replace("/", "");
            fileName = fileName.replace(":", "");
            fileName = fileName.replace("*", "");
            fileName = fileName.replace("?", "");
            fileName = fileName.replace("\"", "");
            fileName = fileName.replace(">", "");
            fileName = fileName.replace("<", "");
            fileName = (fileName = fileName.replace("|", "")).length() > 50 ? fileName.substring(0, 50) : fileName;
        }
        return fileName + suffix;
    }

    public byte[] showImageByte(Long id) {
        return (byte[])this.ossService.backgroundDownload(id).getData();
    }

    public static String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    public static List<Double> getImageWidthAndHeight(String width, String height, int mode, double widthToHeight) {
        if (widthToHeight == 0.0) {
            widthToHeight = 1.5;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        if (mode == 0) {
            list.add(Double.parseDouble(height) * widthToHeight);
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 1) {
            list.add(Double.valueOf(width));
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 3 || mode == 2) {
            list.add(Double.parseDouble(width));
            list.add(Double.parseDouble(width) / widthToHeight);
            return list;
        }
        list.add(Double.parseDouble(width));
        list.add(Double.parseDouble(height));
        return list;
    }

    public String getFormatTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public String getFormatTimeNoHour(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public boolean judgeImage(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.IMAGE.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.IMAGE.getType());
        }
        return false;
    }

    public boolean judgeSuggestion(String tmp, Map<String, String> widgets) {
        String[] strings;
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains("|")) {
            result = result.split("\\|")[0];
        }
        if (result.contains(".") && (strings = result.split("\\.")).length == 2) {
            result = strings[1];
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.JXDNSuggestion.getType());
    }

    public boolean judgeSignature(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return strings[0].equals("flowHistoryInfo") && strings[1].equals("signature");
                    }
                    return widgets.get(result).equals(WidgetType.JXDNSignature.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.JXDNSignature.getType());
        }
        return false;
    }

    public boolean judgeFile(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (result.contains("|")) {
                    result = result.split("\\|")[0];
                }
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.FILE.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.FILE.getType());
    }

    public boolean judgeRichText(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (result.contains("|")) {
                    result = result.split("\\|")[0];
                }
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.JXDNRichText.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.JXDNRichText.getType());
    }

    public boolean judgeTextArea(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (result.contains("|")) {
                    result = result.split("\\|")[0];
                }
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.TEXTAREA.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.TEXTAREA.getType());
    }

    public boolean judgeSelect(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex;
        String result;
        String selectionFiledTypes = this.wordPrintProperties.getSelectionFiledTypes();
        ArrayList<String> selectionFiledTypeList = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)selectionFiledTypes)) {
            String[] split = selectionFiledTypes.split(",");
            selectionFiledTypeList.addAll(Arrays.asList(split));
        }
        if ((result = tmp.substring(startIndex = tmp.indexOf(35) + 1, endIndex = tmp.indexOf(125))).contains("|")) {
            result = result.split("\\|")[0];
        }
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return selectionFiledTypeList.contains(widgets.get(result));
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return selectionFiledTypeList.contains(widgets.get(result));
    }

    public boolean judgeInputOrSer(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124, startIndex));
            if (result.contains("RECORD_ID")) {
                return true;
            }
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.INPUT.getType()) || widgets.get(result).equals(WidgetType.JXDNSerialNumber.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.INPUT.getType()) || widgets.get(result).equals(WidgetType.JXDNSerialNumber.getType());
        }
        return false;
    }

    private void handleTableOptimize(XWPFDocument doc, XWPFTable table, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        List rows = table.getRows();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        HashSet<Integer> removeRows = new HashSet<Integer>();
        for (int k = 0; k < rows.size(); ++k) {
            XWPFTableRow row = (XWPFTableRow)rows.get(k);
            List cells = row.getTableCells();
            boolean flag = true;
            String tableName = "";
            int lastIndex = 0;
            boolean indexFlag = false;
            for (int i = 0; i < cells.size(); ++i) {
                XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                if (k == 0) {
                    widths.add(cell.getWidth());
                }
                List paras = cell.getParagraphs();
                String text = cell.getText();
                Matcher matcher = this.matcher(text);
                if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) {
                    removeRows.add(k);
                    while (matcher.find()) {
                        String[] strings;
                        Object obj = params.get(matcher.group());
                        if (!(obj instanceof List)) continue;
                        List list = (List)obj;
                        String childName = matcher.group();
                        String substring1 = childName.substring(childName.indexOf("#"), childName.indexOf("}"));
                        String currentTableName = "";
                        if (substring1.contains(".") && ((strings = substring1.split("\\.")).length == 2 || strings.length == 3)) {
                            if (!tableName.equals(strings[0])) {
                                flag = true;
                            }
                            currentTableName = strings[0];
                        }
                        if (flag) {
                            for (int j = 0; j < list.size(); ++j) {
                                XWPFTableRow tableRow = HussarUtils.isEmpty((Object)tableName) ? table.insertNewTableRow(k + j + 1) : (lastIndex < j + 1 ? table.insertNewTableRow(k + j + 1) : (XWPFTableRow)rows.get(k + j + 1));
                                Object obj1 = list.get(j);
                                JSONObject parse = (JSONObject)JSONObject.parse((String)String.valueOf(obj1));
                                indexFlag = this.handleTableForRow(doc, tableRow, cells, params, widgets, richTextMap, parse, indexFlag, i, j);
                            }
                            tableName = currentTableName;
                            lastIndex = list.size();
                        }
                        flag = false;
                    }
                    continue;
                }
                for (XWPFParagraph para : paras) {
                    try {
                        this.wpsHandlePara(para, doc);
                        this.replaceInPara(doc, para, params, widgets, richTextMap);
                        if (!this.wordPrintProperties.isSelectionBoxEnable()) continue;
                        this.replaceSelect(para, params, widgets);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                        throw new BaseException((Throwable)e);
                    }
                }
            }
        }
        List collect = removeRows.stream().sorted().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(collect)) {
            int removeNum = 0;
            for (Integer removeRow : collect) {
                removeRow = removeRow - removeNum;
                ++removeNum;
                table.removeRow(removeRow.intValue());
            }
        }
    }

    private void copyCellStyle(XWPFTableCell sourceCell, XWPFTableCell newCell) {
        newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
        CTPPr pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
        if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
            CTJc ctjc;
            CTTc cttc = newCell.getCTTc();
            CTP ctp = (CTP)cttc.getPList().get(0);
            CTPPr ctppr = ctp.getPPr();
            if (ctppr == null) {
                ctppr = ctp.addNewPPr();
            }
            if ((ctjc = ctppr.getJc()) == null) {
                ctjc = ctppr.addNewJc();
            }
            ctjc.setVal(pPr.getJc().getVal());
        }
    }

    private List<String[]> matchText(Matcher matcher1, JSONObject parse, Map<String, Object> params, String text1, Map<String, Object> map) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String key21 = "";
        String group = "";
        while (matcher1.find()) {
            String[] stringArray = new String[2];
            group = matcher1.group();
            if (group.contains(".")) {
                int endIndex;
                int startIndex = group.indexOf(35) + 1;
                String result = group.substring(startIndex, endIndex = group.indexOf(125));
                String[] split1 = result.split("\\.");
                if (split1.length == 2 || split1.length == 3) {
                    if (split1[split1.length - 1].contains("|")) {
                        String[] strings = split1[1].split("\\|");
                        if (strings.length == 3) {
                            key21 = strings[0];
                            map.put(group, parse.get((Object)key21));
                        }
                        if (strings.length == 2) {
                            key21 = strings[0];
                            map.put(group, parse.get((Object)key21));
                        }
                    } else {
                        key21 = split1[1];
                        if (split1.length == 2) {
                            map.put(group, parse.get((Object)key21));
                        } else {
                            map.put(group, result);
                        }
                    }
                }
            } else {
                String group1 = String.valueOf(params.get(group));
                map.put(group, group1);
            }
            stringArray[0] = key21;
            stringArray[1] = group;
            list.add(stringArray);
        }
        return list;
    }

    private boolean handleEmptyRow(XWPFDocument doc, XWPFTableRow tableRow, List<XWPFTableCell> cells, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap, JSONObject parse, int i, int j) {
        for (int l = 0; l < cells.size(); ++l) {
            XWPFTableCell sourceCell = cells.get(l);
            XWPFTableCell newCell = tableRow.addNewTableCell();
            this.copyCellStyle(sourceCell, newCell);
            String text1 = sourceCell.getText();
            Matcher matcher1 = this.matcher(text1);
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<String[]> strings = this.matchText(matcher1, parse, params, text1, map);
            boolean hasIndex = false;
            for (String[] string : strings) {
                String key21 = string[0];
                String group = string[1];
                if (!key21.equals("index")) continue;
                hasIndex = true;
                map.put(group, j + 1);
                break;
            }
            if (hasIndex) {
                this.handleEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], false, strings.get(0)[1], text1, map, widgets, richTextMap, j);
                continue;
            }
            this.handleNoEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], strings.get(0)[1], text1, map, widgets, richTextMap, j);
        }
        return true;
    }

    private void handleNoEmptyRow(XWPFDocument doc, XWPFTableRow tableRow, List<XWPFTableCell> cells, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap, JSONObject parse, boolean indexFlag, int i, int j) {
        for (int l = i; l < cells.size(); ++l) {
            XWPFTableCell sourceCell = cells.get(l);
            XWPFTableCell newCell = tableRow.getCell(l);
            this.copyCellStyle(sourceCell, newCell);
            String text1 = sourceCell.getText();
            Matcher matcher1 = this.matcher(text1);
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<String[]> strings = this.matchText(matcher1, parse, params, text1, map);
            boolean hasIndex = false;
            for (String[] string : strings) {
                String key21 = string[0];
                String group = string[1];
                if (!key21.equals("index")) continue;
                hasIndex = true;
                map.put(group, j + 1);
                break;
            }
            if (hasIndex) {
                this.handleEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], indexFlag, strings.get(0)[1], text1, map, widgets, richTextMap, j);
                continue;
            }
            this.handleNoEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], strings.get(0)[1], text1, map, widgets, richTextMap, j);
        }
    }

    private void handleEmptyParse(XWPFDocument doc, XWPFTableCell newCell, XWPFTableCell sourceCell, String key21, boolean indexFlag, String group, String text1, Map<String, Object> map, Map<String, String> widgets, Map<String, String> richTextMap, int j) {
        XWPFRun sourceRun;
        XWPFRun run;
        List paragraphs = newCell.getParagraphs();
        XWPFParagraph newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
        XWPFParagraph sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
        if (sourcePh.getRuns().isEmpty()) {
            run = newPh.createRun();
        } else {
            sourceRun = (XWPFRun)sourcePh.getRuns().get(0);
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            run = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
            run.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
            run.setColor(sourceRun.getColor());
            run.setBold(sourceRun.isBold());
            run.setItalic(sourceRun.isItalic());
            this.setFontSize(sourceRun.getFontSize(), run);
        }
        if ("index".equals(key21)) {
            run.setText(this.replaceText(text1, map));
        } else if (HussarUtils.isNotEmpty((Object)widgets.get(key21)) && (widgets.get(key21).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(key21).equals(WidgetType.SELECT.getType()))) {
            sourceRun = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            try {
                for (XWPFRun run1 : sourcePh.getRuns()) {
                    XWPFRun runNew = newPh.createRun();
                    runNew.setText(run1.text());
                    runNew.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                    runNew.setColor(sourceRun.getColor());
                    runNew.setBold(sourceRun.isBold());
                    runNew.setItalic(sourceRun.isItalic());
                    this.setFontSize(sourceRun.getFontSize(), runNew);
                }
                this.replaceInPara(doc, newPh, map, widgets, richTextMap);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
            }
        } else {
            run.setText("");
        }
    }

    private void handleNoEmptyParse(XWPFDocument doc, XWPFTableCell newCell, XWPFTableCell sourceCell, String key21, String group, String text1, Map<String, Object> map, Map<String, String> widgets, Map<String, String> richTextMap, int j) {
        List paragraphs = newCell.getParagraphs();
        XWPFParagraph newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
        XWPFParagraph sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
        XWPFRun sourceRun = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
        if (this.judgeInputOrSer(text1, widgets) || this.judgeImage(text1, widgets) || this.judgeFile(text1, widgets) || this.judgeTextArea(text1, widgets) || this.judgeSelect(text1, widgets) || this.judgeSignature(text1, widgets)) {
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            try {
                for (XWPFRun run1 : sourcePh.getRuns()) {
                    XWPFRun runNew = newPh.createRun();
                    runNew.setText(run1.text());
                    runNew.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                    runNew.setColor(sourceRun.getColor());
                    runNew.setBold(sourceRun.isBold());
                    runNew.setItalic(sourceRun.isItalic());
                    this.setFontSize(sourceRun.getFontSize(), runNew);
                }
                this.replaceInPara(doc, newPh, map, widgets, richTextMap);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
            }
        } else {
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            XWPFRun run = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
            run.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
            run.setColor(sourceRun.getColor());
            run.setBold(sourceRun.isBold());
            run.setItalic(sourceRun.isItalic());
            this.setFontSize(sourceRun.getFontSize(), run);
            run.setText(this.replaceText(text1, map));
        }
    }

    private boolean handleTableForRow(XWPFDocument doc, XWPFTableRow tableRow, List<XWPFTableCell> cells, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap, JSONObject parse, boolean indexFlag, int i, int j) {
        if (!tableRow.getTableCells().isEmpty()) {
            this.handleNoEmptyRow(doc, tableRow, cells, params, widgets, richTextMap, parse, indexFlag, i, j);
        } else {
            indexFlag = this.handleEmptyRow(doc, tableRow, cells, params, widgets, richTextMap, parse, i, j);
        }
        return indexFlag;
    }

    public String gene16Num() {
        Random random = new Random();
        int firstDigit = 1 + random.nextInt(9);
        StringBuilder remainingDigits = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            remainingDigits.append(random.nextInt(10));
        }
        return firstDigit + remainingDigits.toString();
    }

    public void useAsync(JSONObject props, List<Object> optionList, List<String> ids, List<String> boxS) {
        block20: {
            try {
                JSONObject asyncJsonObj;
                Object appType;
                Object asyncObj = props.get((Object)ASYNC_KEY);
                if (!(asyncObj instanceof JSONObject) || !HussarUtils.isNotEmpty((Object)(appType = (asyncJsonObj = (JSONObject)asyncObj).get((Object)"appType")))) break block20;
                String appTypeS = String.valueOf(appType);
                Object formId = asyncJsonObj.get((Object)"formId");
                Object appId = asyncJsonObj.get((Object)"appId");
                Object fieldName = asyncJsonObj.get((Object)"fieldName");
                switch (appTypeS) {
                    case "nocode": {
                        Object parentKey = asyncJsonObj.get((Object)"parentKey");
                        if (!HussarUtils.isNotEmpty((Object)appId) || !HussarUtils.isNotEmpty((Object)formId) || !HussarUtils.isNotEmpty((Object)fieldName)) break;
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        if (HussarUtils.isNotEmpty((Object)parentKey)) {
                            params.put("$REVERSE_CHILD", String.valueOf(parentKey));
                        }
                        params.put("current", 1);
                        params.put("orders", new ArrayList());
                        params.put("size", 50);
                        ArrayList<Filter> superQueryConditionDto = new ArrayList<Filter>();
                        Filter filter = new Filter();
                        filter.setRule("_isNotNull");
                        filter.setMatch("AND");
                        filter.setVal("");
                        filter.setField(String.valueOf(fieldName));
                        superQueryConditionDto.add(filter);
                        params.put("superQueryConditionDto", superQueryConditionDto);
                        ApiResponse queryBusinessDataVoApiResponse = this.hussarAppDataSourceService.queryAppBusinessData(String.valueOf(formId), String.valueOf(appId), params);
                        QueryBusinessDataVo data = (QueryBusinessDataVo)queryBusinessDataVoApiResponse.getData();
                        if (HussarUtils.isNotEmpty((Object)data) && HussarUtils.isNotEmpty((Object)data.getBusinessData()) && HussarUtils.isNotEmpty((Object)((PageVo)data.getBusinessData()).getData())) {
                            List list = ((PageVo)data.getBusinessData()).getData();
                            ArrayList<String> values = new ArrayList<String>();
                            if (HussarUtils.isNotEmpty((Object)list)) {
                                if (HussarUtils.isNotEmpty((Object)parentKey)) {
                                    for (Map map : list) {
                                        Object o = map.get(String.valueOf(parentKey));
                                        if (!HussarUtils.isNotEmpty(o)) continue;
                                        List listChild = (List)o;
                                        for (Map mapChild : listChild) {
                                            String value;
                                            Object object = mapChild.get(String.valueOf(fieldName));
                                            if (!HussarUtils.isNotEmpty(object) || values.contains(value = String.valueOf(object))) continue;
                                            values.add(value);
                                            JSONObject op = new JSONObject();
                                            op.put("label", (Object)value);
                                            op.put("value", (Object)value);
                                            optionList.add(op);
                                        }
                                    }
                                } else {
                                    for (Map map : list) {
                                        String value;
                                        Object o = map.get(String.valueOf(fieldName));
                                        if (!HussarUtils.isNotEmpty(o) || values.contains(value = String.valueOf(o))) continue;
                                        values.add(value);
                                        JSONObject op = new JSONObject();
                                        op.put("label", (Object)value);
                                        op.put("value", (Object)value);
                                        optionList.add(op);
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case "externalAPI": {
                        Object apiCode = asyncJsonObj.get((Object)"apiCode");
                        Object appCode = asyncJsonObj.get((Object)"appCode");
                        Object uri = asyncJsonObj.get((Object)"uri");
                        if (!HussarUtils.isNotEmpty((Object)apiCode) || !HussarUtils.isNotEmpty((Object)fieldName) || !HussarUtils.isNotEmpty((Object)appId) || !HussarUtils.isNotEmpty((Object)formId) || !HussarUtils.isNotEmpty((Object)appCode) || !HussarUtils.isNotEmpty((Object)uri)) break;
                        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                        params.put("current", Integer.valueOf(1));
                        params.put("orders", new ArrayList());
                        params.put("size", Integer.valueOf(50));
                        ArrayList<Filter> superQueryConditionDto = new ArrayList<Filter>();
                        Filter filter = new Filter();
                        filter.setRule("_isNotNull");
                        filter.setMatch("AND");
                        filter.setVal("");
                        filter.setField(String.valueOf(fieldName));
                        superQueryConditionDto.add(filter);
                        params.put("superQueryConditionDto", superQueryConditionDto);
                        ApiResponse queryBusinessDataVoApiResponse = this.hussarAppDataSourceService.queryApiBusinessData(String.valueOf(formId), String.valueOf(appCode), String.valueOf(apiCode), String.valueOf(uri), params);
                        QueryBusinessDataVo data = (QueryBusinessDataVo)queryBusinessDataVoApiResponse.getData();
                        if (HussarUtils.isNotEmpty((Object)data) && HussarUtils.isNotEmpty((Object)data.getBusinessData()) && HussarUtils.isNotEmpty((Object)((JSONObject)data.getBusinessData()).get((Object)"data"))) {
                            JSONObject businessData = (JSONObject)data.getBusinessData();
                            List list = (List)businessData.get((Object)"data");
                            ArrayList<String> values = new ArrayList<String>();
                            for (JSONObject jsonObject : list) {
                                String value;
                                Object o = jsonObject.get((Object)String.valueOf(fieldName));
                                if (!HussarUtils.isNotEmpty((Object)o) || values.contains(value = String.valueOf(o))) continue;
                                values.add(value);
                                JSONObject op = new JSONObject();
                                op.put("label", (Object)value);
                                op.put("value", (Object)value);
                                optionList.add(op);
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("\u4f7f\u7528\u5df2\u6709\u6570\u636e\u5f02\u5e38", (Throwable)e);
                LOGGER.error("\u4f7f\u7528\u5df2\u6709\u6570\u636e\u5f02\u5e38,props:{}", (Object)JSON.toJSONString((Object)props));
            }
        }
    }

    public static class TaskInfo {
        private int taskStatus;
        private Long fileId;
        private String rId;

        public String getrId() {
            return this.rId;
        }

        public void setrId(String rId) {
            this.rId = rId;
        }

        public int getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(int taskStatus) {
            this.taskStatus = taskStatus;
        }

        public Long getFileId() {
            return this.fileId;
        }

        public void setFileId(Long fileId) {
            this.fileId = fileId;
        }

        public TaskInfo() {
        }

        public TaskInfo(int taskStatus, Long fileId) {
            this.taskStatus = taskStatus;
            this.fileId = fileId;
        }
    }
}

