/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lefttree.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.lefttree.dao.NavLeftTreeOrderMapper;
import com.jxdinfo.hussar.formdesign.application.lefttree.dto.LeftTreeSortWithDragDTO;
import com.jxdinfo.hussar.formdesign.application.lefttree.model.NavLeftTreeOrder;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeOrderService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NavLeftTreeOrderServiceImpl
extends HussarServiceImpl<NavLeftTreeOrderMapper, NavLeftTreeOrder>
implements INavLeftTreeOrderService {
    @Resource
    private INavLeftTreeService navLeftTreeService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private NavLeftTreeOrderMapper navLeftTreeOrderMapper;

    @HussarTransactional
    public ApiResponse<Boolean> sortWithDrag(LeftTreeSortWithDragDTO leftTreeSortWithDragDTO) {
        Long oldParentId = leftTreeSortWithDragDTO.getOldParentId();
        Long newParentId = leftTreeSortWithDragDTO.getNewParentId();
        Long nodeId = leftTreeSortWithDragDTO.getNodeId();
        Long formId = leftTreeSortWithDragDTO.getFormId();
        String viewId = leftTreeSortWithDragDTO.getViewId();
        if (HussarUtils.equals((Object)oldParentId, (Object)newParentId)) {
            this.handleNewParentNode(formId, viewId, newParentId, leftTreeSortWithDragDTO);
        } else {
            this.updateParentNode(leftTreeSortWithDragDTO);
            this.handleOldParentNode(formId, viewId, oldParentId, nodeId);
            this.handleNewParentNode(formId, viewId, newParentId, leftTreeSortWithDragDTO);
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    private void handleNewParentNode(Long formId, String viewId, Long newParentId, LeftTreeSortWithDragDTO leftTreeSortWithDragDTO) {
        NavLeftTreeOrder newNodeOrder = this.getOrderByParentId(formId, viewId, newParentId);
        String childOrder = leftTreeSortWithDragDTO.getChildOrder();
        if (HussarUtils.isEmpty((Object)newNodeOrder)) {
            NavLeftTreeOrder leftTreeOrder = new NavLeftTreeOrder();
            BeanUtils.copyProperties((Object)leftTreeSortWithDragDTO, (Object)leftTreeOrder);
            leftTreeOrder.setNodeId(newParentId);
            this.navLeftTreeOrderMapper.insert(leftTreeOrder);
        } else if (HussarUtils.isNotEmpty((Object)childOrder)) {
            newNodeOrder.setChildOrder(childOrder);
            this.navLeftTreeOrderMapper.updateById(newNodeOrder);
        }
    }

    private void handleOldParentNode(Long formId, String viewId, Long oldParentId, Long nodeId) {
        NavLeftTreeOrder oldNodeOrder = this.getOrderByParentId(formId, viewId, oldParentId);
        if (HussarUtils.isNotEmpty((Object)oldNodeOrder) && HussarUtils.isNotEmpty((Object)oldNodeOrder.getChildOrder())) {
            ArrayList<String> oldOrderList = new ArrayList<String>(Arrays.asList(oldNodeOrder.getChildOrder().split(",")));
            oldOrderList.remove(String.valueOf(nodeId));
            oldNodeOrder.setChildOrder(String.join((CharSequence)",", oldOrderList));
            this.navLeftTreeOrderMapper.updateById(oldNodeOrder);
        }
    }

    private void updateParentNode(LeftTreeSortWithDragDTO leftTreeSortWithDragDTO) {
        Long nodeId = leftTreeSortWithDragDTO.getNodeId();
        Long treeAppId = leftTreeSortWithDragDTO.getTreeAppId();
        Long treeFormId = leftTreeSortWithDragDTO.getTreeFormId();
        String supFieldName = leftTreeSortWithDragDTO.getSupFieldName();
        String parentFieldName = this.navLeftTreeService.getParentFieldName(leftTreeSortWithDragDTO.getSupFieldType(), supFieldName);
        EngineResultEntity resultEntity = this.navLeftTreeService.formQuery(treeAppId, treeFormId, nodeId);
        resultEntity.put((Object)supFieldName, (Object)leftTreeSortWithDragDTO.getParentValue());
        resultEntity.put((Object)parentFieldName, (Object)leftTreeSortWithDragDTO.getNewParentId());
        this.formOperateExposedService.formSave(String.valueOf(treeFormId), (Map)resultEntity, String.valueOf(treeAppId), Boolean.TRUE);
    }

    public NavLeftTreeOrder getOrderByParentId(Long formId, String viewId, Long nodeId) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NavLeftTreeOrder::getFormId, (Object)formId)).eq(NavLeftTreeOrder::getViewId, (Object)viewId);
        if (HussarUtils.isEmpty((Object)nodeId)) {
            lambdaQueryWrapper.isNull(NavLeftTreeOrder::getNodeId);
        } else {
            lambdaQueryWrapper.eq(NavLeftTreeOrder::getNodeId, (Object)nodeId);
        }
        return (NavLeftTreeOrder)this.getOne((Wrapper)lambdaQueryWrapper);
    }

    public List<NavLeftTreeOrder> getAllOrderByForm(Long formId, String viewId) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NavLeftTreeOrder::getFormId, (Object)formId)).eq(NavLeftTreeOrder::getViewId, (Object)viewId);
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public List<NavLeftTreeOrder> getExportData(Long appId, Long formId) {
        if (HussarUtils.isEmpty((Object)formId)) {
            return this.list((Wrapper)new LambdaQueryWrapper().eq(NavLeftTreeOrder::getAppId, (Object)appId));
        }
        return this.list((Wrapper)new LambdaQueryWrapper().eq(NavLeftTreeOrder::getFormId, (Object)formId));
    }

    public Boolean deleteByAppId(Long appId) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(NavLeftTreeOrder::getAppId, (Object)appId);
        return this.remove((Wrapper)lambdaQueryWrapper);
    }
}

