/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeIamDto;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitRoleField;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.formdesign.application.authority.service.HussarBaseInvokeService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.RoleTreeAuthorizedVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseInvokeServiceImpl
implements HussarBaseInvokeService {
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private ISysAppVisitDataLogicBoService sysAppVisitDataLogicBoService;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;
    @Resource
    private ISysRoleFunctionsBoService sysRoleFunctionsBoService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private ISysRoleDataRightBoService sysRoleDataRightBoService;

    public List<RoleTreeAuthorizedVo> getRoleTree(Long appId) {
        ArrayList<RoleTreeAuthorizedVo> roleTreeAuthorizedVo = new ArrayList<RoleTreeAuthorizedVo>();
        RoleTreeIamDto roleTreeIamDto = new RoleTreeIamDto();
        roleTreeIamDto.setShowSysRole(Boolean.valueOf(false));
        List roleTreeVo = this.sysRolesExternalService.getRoleTreeForSys(roleTreeIamDto);
        this.copyRoleTreeVo(roleTreeVo, roleTreeAuthorizedVo);
        List groupTree = ((RoleTreeAuthorizedVo)roleTreeAuthorizedVo.get(0)).getChildren();
        ArrayList roleIds = new ArrayList();
        for (RoleTreeAuthorizedVo readOnlyRoleTreeVo : groupTree) {
            roleIds.addAll(readOnlyRoleTreeVo.getChildren().stream().map(AbstractNoIconHussarLazyTreeDefinition::getId).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty(roleIds) && HussarUtils.isNotEmpty((Object)appId)) {
            List funIds = this.sysFunctionsBoService.list(null, appId, null).stream().map(SysFunctions::getId).collect(Collectors.toList());
            List roleFunctionsList = this.sysRoleFunctionsBoService.list(roleIds, funIds);
            Map<Long, List<SysRoleFunctions>> formAuthorizedRolesMap = roleFunctionsList.stream().collect(Collectors.groupingBy(SysRoleFunctions::getRoleId));
            List sysRoleDataRightList = this.sysRoleDataRightBoService.list(roleIds, funIds);
            Map<Long, List<SysRoleDataRight>> organDataAuthorityMap = sysRoleDataRightList.stream().collect(Collectors.groupingBy(SysRoleDataRight::getRoleId));
            List roleFieldList = this.sysAppVisitRoleFieldBoService.listRoleFieldByRoles(appId, null, roleIds);
            Map<Long, List<SysAppVisitRoleField>> roleFieldMap = roleFieldList.stream().collect(Collectors.groupingBy(SysAppVisitRoleField::getRoleId));
            List dataLogicList = this.sysAppVisitDataLogicBoService.listDataLogicByRoles(appId, null, roleIds).stream().filter(item -> !HussarUtils.equals((Object)"", (Object)item.getCombineType())).collect(Collectors.toList());
            Map<Long, List<SysAppVisitDataLogic>> dataLogicMap = dataLogicList.stream().collect(Collectors.groupingBy(SysAppVisitDataLogic::getRoleId));
            for (RoleTreeAuthorizedVo roleAuthorizedVo : groupTree) {
                List roleList = roleAuthorizedVo.getChildren();
                for (RoleTreeAuthorizedVo role : roleList) {
                    Long roleId = (Long)role.getId();
                    role.setAuthorized(Boolean.valueOf(this.checkAuthority(formAuthorizedRolesMap.get(roleId), organDataAuthorityMap.get(roleId), roleFieldMap.get(roleId), dataLogicMap.get(roleId))));
                }
            }
        }
        return roleTreeAuthorizedVo;
    }

    private boolean checkAuthority(List<SysRoleFunctions> formAuthorizeRolesList, List<SysRoleDataRight> organDataAuthorityList, List<SysAppVisitRoleField> roleFieldList, List<SysAppVisitDataLogic> dataLogicList) {
        return HussarUtils.isNotEmpty(formAuthorizeRolesList) || HussarUtils.isNotEmpty(organDataAuthorityList) || HussarUtils.isNotEmpty(roleFieldList) || HussarUtils.isNotEmpty(dataLogicList);
    }

    public void copyRoleTreeVo(List<ReadOnlyRoleTreeVo> source, List<RoleTreeAuthorizedVo> target) {
        for (ReadOnlyRoleTreeVo readOnlyRoleTreeVo : source) {
            RoleTreeAuthorizedVo roleTreeAuthorizedVo = new RoleTreeAuthorizedVo();
            BeanUtils.copyProperties((Object)readOnlyRoleTreeVo, (Object)roleTreeAuthorizedVo);
            roleTreeAuthorizedVo.setChildren(new ArrayList());
            target.add(roleTreeAuthorizedVo);
            if (!HussarUtils.isNotEmpty((Object)readOnlyRoleTreeVo.getChildren())) continue;
            this.copyRoleTreeVo(readOnlyRoleTreeVo.getChildren(), roleTreeAuthorizedVo.getChildren());
        }
    }
}

