/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysAppVisitAuthorization;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dto.NoCodeAppVisitAuthorizationDto;
import com.jxdinfo.hussar.formdesign.application.application.service.INoCodeAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.service.INoCodeAppVisitAuthorizationService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.NoCodeAppAuthorizationServiceImpl")
public class NoCodeAppAuthorizationServiceImpl
implements INoCodeAppVisitAuthorizationService {
    @Resource
    private ISysAppVisitAuthorizationBoService sysAppVisitAuthBoService;
    @Resource
    private ISysRolesExternalService sysRolesService;
    @Resource
    private INoCodeAppDevelopTeamService noCodeAppDevelopTeamService;
    private static final Long TENANT_SYSTEM_ADMIN_ROLE = 1450715195867925063L;
    private static final Long SYSTEM_ADMIN_ROLE = 1450785135866925067L;
    private static final Long TENANT_SECURITYADMIN_ROLE = 1450785935166925011L;
    private static final Long SECURITYADMIN_ROLE = 1450785135866925068L;

    @HussarTransactional
    public Boolean addAuthorize(NoCodeAppVisitAuthorizationDto noCodeAppVisitAuthorizationDto) {
        List roleIds = noCodeAppVisitAuthorizationDto.getRoleIds();
        this.sysAppVisitAuthBoService.deleteByAppId(noCodeAppVisitAuthorizationDto.getAppId());
        if (HussarUtils.isEmpty((Object)roleIds)) {
            return true;
        }
        ArrayList sysAppVisitAuthorizationList = Lists.newArrayListWithCapacity((int)10);
        for (Long roleId : roleIds) {
            SysAppVisitAuthorization sysAppVisitAuthorization = new SysAppVisitAuthorization();
            sysAppVisitAuthorization.setAppId(noCodeAppVisitAuthorizationDto.getAppId());
            sysAppVisitAuthorization.setRoleId(roleId);
            sysAppVisitAuthorizationList.add(sysAppVisitAuthorization);
        }
        return this.sysAppVisitAuthBoService.saveAll((List)sysAppVisitAuthorizationList);
    }

    public ApiResponse<List<RoleVo>> getAppRoleList(Long appId) {
        List sysAppVisitAuthorizationList = this.sysAppVisitAuthBoService.listByAppId(appId);
        if (HussarUtils.isEmpty((Object)sysAppVisitAuthorizationList)) {
            return ApiResponse.success(new ArrayList(), (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList roleVos = Lists.newArrayListWithCapacity((int)10);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (SysAppVisitAuthorization sysAppVisitAuthorization : sysAppVisitAuthorizationList) {
            RoleVo roleVo = new RoleVo();
            roleVo.setId(sysAppVisitAuthorization.getRoleId());
            roleVos.add(roleVo);
            roleIds.add(sysAppVisitAuthorization.getRoleId());
        }
        List list = this.sysRolesService.getRolesByIds(roleIds);
        Map<Long, SysRoles> map = list.stream().collect(Collectors.toMap(SysRoles::getId, r -> r));
        roleVos.forEach(r -> {
            SysRoles role = (SysRoles)map.get(r.getId());
            if (HussarUtils.isNotEmpty((Object)role)) {
                r.setRoleName(role.getRoleName());
            }
        });
        return ApiResponse.success((Object)roleVos);
    }

    public List<Long> getCurrentUserAuthorityApp() {
        SecurityUser user = BaseSecurityUtil.getUser();
        List rolesList = user.getRolesList();
        rolesList.add(user.getUserId());
        Map extendUserMap = user.getExtendUserMap();
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("deptId"))) {
            rolesList.add(Long.valueOf(extendUserMap.get("deptId").toString()));
        }
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("postId"))) {
            rolesList.add(Long.valueOf(extendUserMap.get("postId").toString()));
        }
        rolesList.add(-1L);
        List<Long> appIdList = new ArrayList<Long>();
        List authorizeList = this.sysAppVisitAuthBoService.listByRoleIds(rolesList);
        if (HussarUtils.isNotEmpty((Object)authorizeList)) {
            appIdList = authorizeList.stream().map(SysAppVisitAuthorization::getAppId).distinct().collect(Collectors.toList());
        }
        return appIdList;
    }

    public boolean checkIfLoginUserHasAppAdminPermission(SysApplication app) {
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        boolean isTenantAdmin = HussarUtils.isNotEmpty((Object)loginUser.getRolesList()) && (loginUser.getRolesList().contains(TenantConstant.ADMIN_ROLE) || loginUser.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || loginUser.getRolesList().contains(SYSTEM_ADMIN_ROLE) || loginUser.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || loginUser.getRolesList().contains(SECURITYADMIN_ROLE));
        boolean isSuperAdmin = loginUser.isSuperAdmin() || isTenantAdmin;
        boolean isInDevelopTeam = this.noCodeAppDevelopTeamService.checkCurrentUserInTeam(app.getId());
        boolean isAppCreator = loginUser.getId().equals(app.getCreator());
        return isSuperAdmin || isInDevelopTeam || isAppCreator;
    }
}

