/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppVisitDto;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.AppMenuFuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppVisitVo;
import com.jxdinfo.hussar.dashboard.json.DashboardJsonData;
import com.jxdinfo.hussar.dashboard.json.WidgetJsonData;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.SysAppWatermarkDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppLinkInner;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppLinkInnerService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppWatermarkService;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppAuthRoleServiceImpl;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysDashboardVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFileInfoVo;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeOrderService;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.print.dto.SysPrintTemplateBoolean;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysFileInfoDashboardService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.model.PageExp;
import com.jxdinfo.hussar.formdesign.application.property.model.WidgetExp;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.service.impl.PageExpServiceImpl;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptTreeVO;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleInfo;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleTriggerAction;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.Impl.SysRuleInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppExportInfoServiceImpl")
public class AppExportInfoServiceImpl
implements IAppExportInfoService {
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysAppVisitAuthorizationBoService sysAppVisitAuthorizationBoService;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private PageExpServiceImpl pageExpService;
    @Resource
    private SysFormGroupMapper sysFormGroupMapper;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService formAuthService;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;
    @Resource
    private ISysAppVisitDataLogicBoService sysAppVisitDataLogicBoService;
    @Resource
    private ISysRolesExternalService sysRolesService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private AppAuthRoleServiceImpl appAuthRoleService;
    @Resource
    private ISysRolesExternalService roleGroupService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private IWidgetExpService widgetExpService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysRuleInfoServiceImpl ruleInfoService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    @Resource
    private ISysFormLinkService formLinkService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private ISysAppLinkInnerService sysAppLinkInnerService;
    @Resource
    private ISysAppWatermarkService sysAppWatermarkService;
    @Resource
    private SysMsgPushConfigService sysMsgPushConfigService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private FormMapService formMapService;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private INavLeftTreeOrderService navLeftTreeOrderService;
    @Resource
    private ISysFileInfoDashboardService sysFileInfoDashboardService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService sysAppVisitRoleOrganDataAuthorityService;
    @Resource
    private ISysFormExtApiService sysFormExtApiService;
    @Resource
    private OssService ossService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    private static final Logger logger = LoggerFactory.getLogger(AppExportInfoServiceImpl.class);

    public void init(AppExportDto appExportDto) {
        String exportFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), this.formDesignProperties.getBackProjectPath(), ".export-store"});
        String basePath = FileUtil.posixPath((String[])new String[]{exportFolderPath, appExportDto.getAppId().toString(), UUID.randomUUID().toString()});
        appExportDto.setBasePath(basePath);
    }

    @ProgressCache(status=1, msg="\u6b63\u5728\u5bfc\u51fa\u5e94\u7528\u4fe1\u606f")
    public void exportAppInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysApplication application = this.sysApplicationBoService.selectById(appExportDto.getAppId());
        map.put("appInfo", application);
        if (HussarUtils.isNotEmpty((Object)appExportDto.getAppAuthRoleIds())) {
            List sysAppVisitAuthorizationList = this.sysAppVisitAuthorizationBoService.listByAppIdAndRoleIds(appExportDto.getAppId(), appExportDto.getAppAuthRoleIds());
            map.put("appAuth", sysAppVisitAuthorizationList);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "app.json"}));
        this.exportAppLinkInner(appExportDto.getAppId(), basePath);
        this.exportAppWatermark(appExportDto.getAppId(), basePath);
    }

    private void exportAppLinkInner(Long appId, String basePath) {
        HashMap<String, SysAppLinkInner> map = new HashMap<String, SysAppLinkInner>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysAppLinkInner::getAppId, (Object)appId);
        SysAppLinkInner sysAppLinkInner = (SysAppLinkInner)this.sysAppLinkInnerService.getOne((Wrapper)wrapper);
        map.put("appLinkInner", sysAppLinkInner);
        String appLinkInnerFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "appLinkInner.json"});
        this.writeToFile(map, appLinkInnerFilePath);
    }

    private void exportAppWatermark(Long appId, String basePath) {
        HashMap<String, SysAppWatermarkDto> map = new HashMap<String, SysAppWatermarkDto>();
        SysAppWatermarkDto sysAppWatermark = this.sysAppWatermarkService.getAppWatermark((Object)appId);
        map.put("appWatermark", sysAppWatermark);
        String appWatermarkFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "appWatermark.json"});
        this.writeToFile(map, appWatermarkFilePath);
    }

    @ProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u51fa\u8868\u5355\u4fe1\u606f")
    public void exportFormInfo(AppExportDto appExportDto) throws IOException {
        String basePath = appExportDto.getBasePath();
        HashMap<String, List<AppVisitVo>> map = new HashMap<String, List<AppVisitVo>>();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        map.put("forms", forms);
        if (ToolUtil.isNotEmpty((Object)forms)) {
            List formGroupIds = forms.stream().map(SysForm::getFormGroupId).collect(Collectors.toList());
            List formGroups = this.sysFormGroupMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFormGroup::getId, formGroupIds));
            map.put("formGroups", formGroups);
        }
        this.exportPageExp(forms, basePath);
        this.exportDashboard(forms, basePath);
        List formAuthRoleIds = appExportDto.getFormAuthRoleIds();
        if (HussarUtils.isNotEmpty((Object)formAuthRoleIds)) {
            List<AppVisitVo> visitInfoList = this.getAppVisitInfoList(appExportDto, "1");
            map.put("formAuth", visitInfoList);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "form.json"}));
    }

    private List<AppVisitVo> getAppVisitInfoList(AppExportDto appExportDto, String visitType) {
        QueryAppVisitDto appVisitDto = new QueryAppVisitDto();
        appVisitDto.setAppId(appExportDto.getAppId());
        appVisitDto.setRoleIds(appExportDto.getFormAuthRoleIds());
        appVisitDto.setVisitType(visitType);
        return this.sysFunctionsBoService.getAppVisitInfoList(appVisitDto);
    }

    private void exportPageExp(List<SysForm> forms, String basePath) throws IOException {
        HashMap<String, String> pageExpMap = new HashMap<String, String>();
        for (SysForm form : forms) {
            if (!"3".equals(form.getFormType())) continue;
            String pageName = form.getTableName();
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PageExp::getName, (Object)pageName);
            Long fileId = ((PageExp)this.pageExpService.getOne((Wrapper)wrapper)).getFileId();
            AttachmentManagerModel attachmentModel = this.ossService.getModelById(fileId);
            String fileName = attachmentModel.getAttachmentName();
            int index = fileName.lastIndexOf(".");
            String suffix = index > -1 ? fileName.substring(index) : "";
            String attachmentPath = attachmentModel.getAttachmentDir() + fileId + suffix;
            String folderPath = basePath + File.separator + "pageExpand";
            File folder = new File(folderPath);
            boolean created = folder.mkdirs();
            if (created) {
                System.out.println("\u81ea\u5b9a\u4e49\u9875\u9762\u6587\u4ef6");
            }
            String destinationFolder = FileUtil.posixPath((String[])new String[]{folderPath, fileName});
            try {
                FileInputStream fileInputStream = new FileInputStream(attachmentPath);
                Throwable throwable = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(destinationFolder);
                    Throwable throwable2 = null;
                    try {
                        ZipInputStream zipInput = new ZipInputStream(fileInputStream);
                        Throwable throwable3 = null;
                        try {
                            ZipOutputStream zipOutput = new ZipOutputStream(fileOutputStream);
                            Throwable throwable4 = null;
                            try {
                                ZipEntry entry = zipInput.getNextEntry();
                                while (entry != null) {
                                    int bytesRead;
                                    zipOutput.putNextEntry(new ZipEntry(entry.getName()));
                                    byte[] buffer = new byte[1024];
                                    while ((bytesRead = zipInput.read(buffer)) > 0) {
                                        zipOutput.write(buffer, 0, bytesRead);
                                    }
                                    zipOutput.closeEntry();
                                    entry = zipInput.getNextEntry();
                                }
                                System.out.println("Zip\u538b\u7f29\u5305\u5df2\u6210\u529f\u590d\u5236\u5230\u76ee\u6807\u8def\u5f84\u3002");
                                pageExpMap.put(pageName, fileName);
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (zipOutput == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        zipOutput.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                zipOutput.close();
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable3 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (zipInput == null) continue;
                            if (throwable3 != null) {
                                try {
                                    zipInput.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            zipInput.close();
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable2 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        fileOutputStream.close();
                    }
                }
                catch (Throwable fileOutputStream) {
                    throwable = fileOutputStream;
                    throw fileOutputStream;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable fileOutputStream) {
                            throwable.addSuppressed(fileOutputStream);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage() + "\u8c03\u7528oss\u670d\u52a1\u4e0b\u8f7d\u6587\u4ef6");
                ApiResponse ossDownloadResponse = this.ossService.backgroundDownload(fileId);
                if (!ossDownloadResponse.isSuccess()) continue;
                byte[] zipData = (byte[])ossDownloadResponse.getData();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(destinationFolder);
                    Throwable throwable = null;
                    try {
                        fileOutputStream.write(zipData);
                        System.out.println("\u6570\u636e\u5df2\u6210\u529f\u5199\u5165\u6587\u4ef6: " + destinationFolder);
                        pageExpMap.put(pageName, fileName);
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        if (throwable != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable12) {
                                throwable.addSuppressed(throwable12);
                            }
                            continue;
                        }
                        fileOutputStream.close();
                    }
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
        this.writeToFile(pageExpMap, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "pageNameFile.json"}));
    }

    private void exportDashboard(List<SysForm> forms, String basePath) {
        HashMap<Long, List> exportFileMap = new HashMap<Long, List>();
        for (SysForm form : forms) {
            if (!"2".equals(form.getFormType())) continue;
            Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)form.getId())).or()).eq((Object)"PARENT_ID", (Object)form.getId())).orderByAsc((Object)"ENTRY_TYPE");
            List dashEntryList = this.dashEntryService.list(wrapper);
            exportFileMap.put(form.getId(), dashEntryList);
        }
        this.writeToFile(exportFileMap, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dashboard.json"}));
    }

    @ProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u51fa\u8868\u5355\u6743\u9650\u4fe1\u606f")
    public void exportFormAuthorityInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        if (ToolUtil.isNotEmpty((Object)appExportDto.getFormAuthRoleIds())) {
            HashMap<String, List<AppVisitVo>> map = new HashMap<String, List<AppVisitVo>>();
            List<AppVisitVo> buttonAuthList = this.getAppVisitInfoList(appExportDto, "2");
            map.put("buttonAuth", buttonAuthList);
            List filedAuth = this.sysAppVisitRoleFieldBoService.listRoleFieldByRoles(appExportDto.getAppId(), null, appExportDto.getFormAuthRoleIds());
            map.put("filedAuth", filedAuth);
            List dataLogicAuth = this.sysAppVisitDataLogicBoService.listDataLogicByRoles(appExportDto.getAppId(), null, appExportDto.getFormAuthRoleIds());
            map.put("dataLogicAuth", dataLogicAuth);
            if (ToolUtil.isNotEmpty((Object)dataLogicAuth)) {
                List dataLogicFilterIds = dataLogicAuth.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
                List dataLogicFilters = this.sysAppVisitDataLogicBoService.dataLogicFilterListByLogicIds(dataLogicFilterIds);
                map.put("dataLogicFilter", dataLogicFilters);
            }
            List<AppVisitVo> roleOrganDataAuthList = this.getAppVisitInfoList(appExportDto, "3");
            map.put("organAuth", roleOrganDataAuthList);
            this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "formAuth.json"}));
        }
    }

    @ProgressCache(status=4, msg="\u6b63\u5728\u5bfc\u51fa\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void exportDesignerMidFile(AppExportDto appExportDto) throws IOException {
        String basePath = appExportDto.getBasePath();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        ArrayList<Long> formIds = new ArrayList<Long>();
        for (SysForm sysForm : forms) {
            if (!"0".equals(sysForm.getFormType()) && !"1".equals(sysForm.getFormType())) continue;
            formIds.add(sysForm.getId());
        }
        this.exportMid(appExportDto.getAppId(), FileUtil.posixPath((String[])new String[]{basePath, "appConfig"}), formIds, basePath);
        this.exportBusinessRule(formIds, basePath);
        this.exportCustomButton(formIds, basePath);
        this.exportFormCheckConfig(formIds, basePath);
        this.exportFormLinkData(formIds, basePath);
        this.exportMsgPush(appExportDto.getAppId(), basePath);
        this.exportPrintTemplate(appExportDto.getAppId(), basePath);
        this.exportDataPull(appExportDto.getAppId(), basePath);
        this.exportDataPush(appExportDto.getAppId(), basePath);
        this.exportDataPushMap(appExportDto.getAppId(), basePath);
        this.exportPublicView(formIds, basePath);
        this.exportScript(formIds, basePath);
        this.exportLeftTree(appExportDto);
        this.exportDashboardImage(appExportDto.getAppId(), basePath);
        this.exportExtensionApi(appExportDto, basePath);
    }

    private void exportLeftTree(AppExportDto appExportDto) {
        try {
            List leftTreeOrders;
            HashMap<String, List> leftTreeData = new HashMap<String, List>();
            if (appExportDto.isExportDataFlag() && HussarUtils.isNotEmpty((Object)(leftTreeOrders = this.navLeftTreeOrderService.getExportData(appExportDto.getAppId(), null)))) {
                leftTreeData.put("dragOrder", leftTreeOrders);
            }
            if (HussarUtils.isNotEmpty(leftTreeData)) {
                String leftTreePath = AppMigrateUtil.getFilePath(appExportDto.getBasePath(), "leftTree");
                this.writeToFile(leftTreeData, leftTreePath);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5de6\u4fa7\u6811\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new HussarException("\u5bfc\u51fa\u5de6\u4fa7\u6811\u6570\u636e\u5f02\u5e38");
        }
    }

    private void exportPrintTemplate(Long appId, String basePath) {
        HashMap map = new HashMap();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysForm::getAppId, (Object)appId);
        List sysForms = this.sysFormMapper.selectList((Wrapper)wrapper);
        List printTemplates = new ArrayList();
        ArrayList<SysPrintTemplateBoolean> list = new ArrayList<SysPrintTemplateBoolean>();
        if (HussarUtils.isNotEmpty((Object)sysForms)) {
            List ids = sysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            printTemplates = this.sysPrintTemplateService.list((Wrapper)new LambdaQueryWrapper().in(SysPrintTemplate::getFormId, ids));
            for (SysPrintTemplate sysPrintTemplate : printTemplates) {
                list.add(sysPrintTemplate.intToBoolean(sysPrintTemplate));
            }
        }
        String templateFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "printTemplate", "templateFile"});
        try {
            this.sysPrintTemplateService.exportPrintTemplate(printTemplates, templateFilePath);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6a21\u677f\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
        }
        map.put("printTemplateData", list);
        String printTemplatePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "printTemplate", "printTemplate.json"});
        this.writeToFile(map, printTemplatePath);
    }

    public void exportCustomButton(List<Long> formIds, String basePath) {
        if (HussarUtils.isNotEmpty(formIds)) {
            HashMap<String, List> map = new HashMap<String, List>();
            List customButtons = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().in(SysCustomButton::getFormId, formIds));
            map.put("customButtonData", customButtons);
            String customButtonPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "customButton.json"});
            this.writeToFile(map, customButtonPath);
        }
    }

    private void exportMid(Long appId, String path, List<Long> formIds, String basePath) throws IOException {
        AppContextUtil.setAppId((String)String.valueOf(appId));
        String appIdStr = String.valueOf(appId);
        ArrayList<String> widgetsAll = new ArrayList<String>();
        for (Long formId : formIds) {
            String formName = ((FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData()).getName();
            String midFilePath = FileUtil.posixPath((String[])new String[]{path, appIdStr, String.valueOf(formId)});
            FormCanvasSchema canvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            String canvasFin = formId + ".fd";
            String canvasPath = FileUtil.posixPath((String[])new String[]{midFilePath, "canvas", canvasFin});
            String canvasJson = JSON.toJSONStringWithDateFormat((Object)canvasSchema, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            List widgets = canvasSchema.getWidgets();
            if (HussarUtils.isNotEmpty((Object)widgets)) {
                for (Widget widget : widgets) {
                    if (!"JXDNExtWidget".equals(widget.getType())) continue;
                    widgetsAll.add(widget.getProps().getString("extname"));
                }
            }
            this.filePublishService.writeStringToFile(canvasJson, canvasPath);
            SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
            FormSettingSchema settingSchema = (FormSettingSchema)bean.get(String.valueOf(formId)).getData();
            String settingFin = formId + ".setting";
            String settingPath = FileUtil.posixPath((String[])new String[]{midFilePath, "setting", settingFin});
            String settingJson = JSON.toJSONStringWithDateFormat((Object)settingSchema, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(settingJson, settingPath);
            FormViewSchema viewSchema = (FormViewSchema)this.viewService.get(String.valueOf(formId)).getData();
            String viewFin = formId + ".vd";
            String viewPath = FileUtil.posixPath((String[])new String[]{midFilePath, "view", viewFin});
            String viewJson = JSON.toJSONStringWithDateFormat((Object)viewSchema, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(viewJson, viewPath);
            List staffScopes = (List)this.staffScopeScemaService.list(String.valueOf(formId)).getData();
            String staffFileName = formId + "history" + ".stf";
            String staffFilePath = FileUtil.posixPath((String[])new String[]{midFilePath, "staff", staffFileName});
            String staffJsonStr = JSON.toJSONStringWithDateFormat((Object)staffScopes, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(staffJsonStr, staffFilePath);
        }
        LinkedHashSet set = new LinkedHashSet(widgetsAll);
        widgetsAll.clear();
        widgetsAll.addAll(set);
        this.exportWidgetExp(widgetsAll, basePath);
    }

    private void exportWidgetExp(List<String> widgets, String basePath) throws IOException {
        for (String widgetName : widgets) {
            try {
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(WidgetExp::getName, (Object)widgetName);
                Long fileId = ((WidgetExp)this.widgetExpService.getOne((Wrapper)wrapper)).getFileId();
                AttachmentManagerModel attachmentModel = this.ossService.getModelById(fileId);
                String fileName = attachmentModel.getAttachmentName();
                int index = fileName.lastIndexOf(".");
                String suffix = index > -1 ? fileName.substring(index) : "";
                String attachmentPath = attachmentModel.getAttachmentDir() + fileId + suffix;
                String folderPath = basePath + File.separator + "widgetExpand";
                File folder = new File(folderPath);
                boolean created = folder.mkdirs();
                if (created) {
                    System.out.println("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u6587\u4ef6");
                }
                String destinationFolder = FileUtil.posixPath((String[])new String[]{folderPath, fileName});
                FileInputStream fileInputStream = new FileInputStream(attachmentPath);
                Throwable throwable = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(destinationFolder);
                    Throwable throwable2 = null;
                    try {
                        ZipInputStream zipInput = new ZipInputStream(fileInputStream);
                        Throwable throwable3 = null;
                        try {
                            ZipOutputStream zipOutput = new ZipOutputStream(fileOutputStream);
                            Throwable throwable4 = null;
                            try {
                                ZipEntry entry = zipInput.getNextEntry();
                                while (entry != null) {
                                    int bytesRead;
                                    zipOutput.putNextEntry(new ZipEntry(entry.getName()));
                                    byte[] buffer = new byte[1024];
                                    while ((bytesRead = zipInput.read(buffer)) > 0) {
                                        zipOutput.write(buffer, 0, bytesRead);
                                    }
                                    zipOutput.closeEntry();
                                    entry = zipInput.getNextEntry();
                                }
                                System.out.println("Zip\u538b\u7f29\u5305\u5df2\u6210\u529f\u590d\u5236\u5230\u76ee\u6807\u8def\u5f84\u3002");
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (zipOutput == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        zipOutput.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                zipOutput.close();
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable3 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (zipInput == null) continue;
                            if (throwable3 != null) {
                                try {
                                    zipInput.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            zipInput.close();
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable2 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        fileOutputStream.close();
                    }
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5f02\u5e38\uff0c\u8df3\u8fc7,\u7ec4\u4ef6\u540d\u79f0\uff1a{}", (Object)widgetName, (Object)e);
            }
        }
    }

    private void exportBusinessRule(List<Long> formIds, String basePath) {
        ArrayList allRules = new ArrayList();
        for (Long formId : formIds) {
            String formIdStr = String.valueOf(formId);
            ArrayList<RuleFullVo> ruleFullVos = new ArrayList<RuleFullVo>();
            List triggerActions = this.sysRuleTriggerActionService.getActionsByFormId(Long.valueOf(formIdStr));
            if (HussarUtils.isEmpty((Object)triggerActions)) continue;
            for (SysRuleTriggerAction triggerAction : triggerActions) {
                String delFlag;
                Long ruleId = triggerAction.getRuleId();
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRuleInfo::getRuleId, (Object)ruleId);
                SysRuleInfo sysRuleInfo = (SysRuleInfo)this.ruleInfoService.getOne((Wrapper)wrapper);
                if (!HussarUtils.isNotEmpty((Object)sysRuleInfo) || !"0".equals(delFlag = sysRuleInfo.getDelFlag())) continue;
                ruleFullVos.add(this.ruleInfoService.getRuleInfoDetail(ruleId));
            }
            allRules.addAll(ruleFullVos);
        }
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "rule.json"});
        this.writeToFile(allRules, flowFilePath);
    }

    private void exportFormLinkData(List<Long> formIds, String basePath) {
        Map formLinkExportData = this.formLinkService.getFormLinkExportData(formIds);
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "formLink.json"});
        this.writeToFile(formLinkExportData, flowFilePath);
    }

    private void exportFormCheckConfig(List<Long> formIds, String basePath) {
        List formCheckConfigList = this.sysFormCheckConfigService.getFormCheckConfigList(formIds);
        String formCheckConfigFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "checkConfig.json"});
        this.writeToFile(formCheckConfigList, formCheckConfigFilePath);
    }

    @ProgressCache(status=5, msg="\u6b63\u5728\u5bfc\u51fa\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f")
    public void exportFlowConfigInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        Map flowDataMap = this.flowMigrateService.exportWorkflow(appExportDto.getAppId());
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "flow.json"});
        this.writeToFile(flowDataMap, flowFilePath);
    }

    @ProgressCache(status=6, msg="\u6b63\u5728\u5bfc\u51fa\u516c\u5171\u6570\u636e")
    public void exportCommData(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        HashSet roleIds = new HashSet();
        roleIds.addAll(appExportDto.getAppAuthRoleIds());
        roleIds.addAll(appExportDto.getFormAuthRoleIds());
        roleIds.addAll(appExportDto.getFlowAuthRoleIds());
        if (ToolUtil.isNotEmpty(roleIds)) {
            HashMap<String, List> roleDataMap = new HashMap<String, List>();
            List roles = this.sysRolesService.getRolesByIds(new ArrayList(roleIds));
            roleDataMap.put("roles", roles);
            List roleGroupIds = roles.stream().map(SysRoles::getGroupId).filter(Objects::nonNull).collect(Collectors.toList());
            List roleGroups = this.roleGroupService.selectRoleGroupByIds(roleGroupIds);
            roleDataMap.put("roleGroups", roleGroups);
            this.writeToFile(roleDataMap, FileUtil.posixPath((String[])new String[]{basePath, "commonData", "commonData.json"}));
        }
    }

    @ProgressCache(status=7, msg="\u6b63\u5728\u5bfc\u51fa\u4e1a\u52a1\u6570\u636e")
    public void exportBusinessData(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        HashMap map = new HashMap();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        if (HussarUtils.isEmpty((Object)forms)) {
            return;
        }
        Map<String, List<SysForm>> formGroupByTableName = forms.stream().filter(sysForm -> HussarUtils.isNotEmpty((Object)sysForm.getTableName())).collect(Collectors.groupingBy(SysForm::getTableName));
        if (HussarUtils.isNotEmpty(formGroupByTableName)) {
            formGroupByTableName.forEach((tableName, sysForms) -> {
                if (HussarUtils.isNotEmpty((Object)sysForms)) {
                    boolean anyMatchFlow = sysForms.stream().anyMatch(form -> "1".equals(form.getFormType()));
                    SysForm sysForm = anyMatchFlow ? sysForms.stream().filter(form -> "1".equals(form.getFormType())).findFirst().orElseGet(SysForm::new) : (SysForm)sysForms.get(0);
                    logger.info("exportBusinessData sysForm : {}", (Object)JSON.toJSONString((Object)sysForm));
                    if ("0".equals(sysForm.getFormType()) || "1".equals(sysForm.getFormType())) {
                        logger.info("form id : {},name : {}", (Object)sysForm.getId(), (Object)sysForm.getFormName());
                        ResponseEntity result = this.formOperateExposedService.tableQueryAll(String.valueOf(appExportDto.getAppId()), String.valueOf(sysForm.getId()));
                        List data = ((PageVo)((ApiResponse)Objects.requireNonNull(result.getBody())).getData()).getData();
                        map.put(sysForm.getTableName(), data);
                    }
                }
            });
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "businessData", "businessData.json"}));
    }

    @ProgressCache(status=8, msg="\u6b63\u5728\u751f\u6210\u5bfc\u51fa\u5e94\u7528\u5143\u4fe1\u606f")
    public void generateMetaInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        AppExportMetaDto appExportMeta = new AppExportMetaDto();
        SysApplication sysApplication = this.sysApplicationBoService.selectById(appExportDto.getAppId());
        BeanUtils.copyProperties((Object)sysApplication, (Object)appExportMeta);
        appExportMeta.setAppAuthRoleVo(this.appAuthRoleService.getAppAuthRoleTree(appExportDto.getAppAuthRoleIds(), appExportDto.getFormAuthRoleIds(), appExportDto.getFlowAuthRoleIds()));
        appExportMeta.setVersion(AppMigrateUtil.getMigrateVersion());
        if (ToolUtil.isNotEmpty((Object)appExportDto.getExportPwd())) {
            appExportMeta.setPassword(DigestUtil.sha1Hex((String)appExportDto.getExportPwd()));
        }
        this.writeToFile(appExportMeta, FileUtil.posixPath((String[])new String[]{basePath, "hussar.meta"}));
    }

    @ProgressCache(status=10, msg="\u5e94\u7528\u5bfc\u51fa\u6210\u529f", finish=true)
    public Long uploadExportFile(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        String appName = this.sysApplicationBoService.selectById(appExportDto.getAppId()).getAppName();
        return this.appFileExtendService.fileEncrypt(appName, basePath);
    }

    public void clear() {
        String exportFilePath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), this.formDesignProperties.getBackProjectPath(), ".export-store"});
    }

    private void writeToFile(Object object, String path) {
        String json = JSON.toJSONStringWithDateFormat((Object)object, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        this.filePublishService.writeStringToFile(json, path);
    }

    private void exportMsgPush(Long appId, String basePath) {
        List configs = this.sysMsgPushConfigService.listByAppId(appId);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String msgPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "msg.json"});
            this.writeToFile(configs, msgPushPath);
        }
    }

    private void exportDataPull(Long appId, String basePath) {
        SysDataPullConfigDto sysDataPullConfigDto = new SysDataPullConfigDto();
        sysDataPullConfigDto.setAppId(appId);
        List configs = this.sysDataPullService.listByCondition(sysDataPullConfigDto);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String msgPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPull.json"});
            this.writeToFile(configs, msgPushPath);
        }
    }

    private void exportDataPush(Long appId, String basePath) {
        List configs = this.pushDataService.listByAppId(appId);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String dataPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPush.json"});
            this.writeToFile(configs, dataPushPath);
        }
    }

    private void exportDataPushMap(Long appId, String basePath) {
        List configs = this.formMapService.listByAppId(appId);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String dataPushMapPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPushMap.json"});
            this.writeToFile(configs, dataPushMapPath);
        }
    }

    private void exportPublicView(List<Long> formIds, String basePath) {
        ArrayList formPublicViewList = new ArrayList();
        if (HussarUtils.isEmpty(formIds)) {
            return;
        }
        formIds.forEach(formId -> {
            List viewList = (List)this.customViewService.get(String.valueOf(formId)).getData();
            if (HussarUtils.isNotEmpty((Object)viewList)) {
                formPublicViewList.addAll(viewList);
            }
        });
        if (HussarUtils.isEmpty(formPublicViewList)) {
            return;
        }
        List publicView = formPublicViewList.stream().filter(dataView -> "public".equals(dataView.getCategory())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(publicView)) {
            String formPublicFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "publicView.json"});
            this.writeToFile(publicView, formPublicFilePath);
        }
    }

    private void exportScript(List<Long> formIds, String basePath) {
        ArrayList scriptBases = new ArrayList();
        if (HussarUtils.isEmpty(formIds)) {
            return;
        }
        ScriptRecordService scriptRecordService = (ScriptRecordService)SpringContextUtil.getBean(ScriptRecordService.class);
        formIds.forEach(formId -> {
            List scriptBaseList = ((ScriptTreeVO)scriptRecordService.listInForm(null, String.valueOf(formId)).getData()).getForm();
            if (HussarUtils.isNotEmpty((Object)scriptBaseList)) {
                scriptBases.addAll(scriptBaseList);
            }
        });
        if (HussarUtils.isEmpty(scriptBases)) {
            return;
        }
        if (HussarUtils.isNotEmpty(scriptBases)) {
            String formPublicFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "script.json"});
            this.writeToFile(scriptBases, formPublicFilePath);
        }
    }

    private void exportDashboardImage(Long appId, String basePath) {
        HashMap<String, List<SysFileInfoVo>> map = new HashMap<String, List<SysFileInfoVo>>();
        List<SysDashboardVo> sysDashboardVoList = this.getDashboardImageIds(appId);
        if (sysDashboardVoList.size() > 0) {
            List<SysFileInfoVo> sysFileInfoDashboardList = this.getImageId(sysDashboardVoList);
            String FileInfoPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dashboardImagePath", "imageFile"});
            try {
                this.sysFileInfoDashboardService.exportFileInfoDashboard(sysFileInfoDashboardList, FileInfoPath);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u4eea\u8868\u76d8\u56fe\u7247\u5931\u8d25!", (Throwable)e);
            }
            map.put("printImageData", sysFileInfoDashboardList);
            String printTemplatePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dashboardImagePath", "printImage.json"});
            this.writeToFile(map, printTemplatePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<SysDashboardVo> getDashboardImageIds(Long appId) {
        ArrayList<SysDashboardVo> sysDashboardVoList = new ArrayList<SysDashboardVo>();
        Wrapper wrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)String.valueOf(appId))).eq((Object)"ENTRY_TYPE", (Object)"panel");
        List dashEntryList = this.dashEntryService.list(wrapper);
        Iterator iterator = dashEntryList.iterator();
        while (iterator.hasNext()) {
            DashEntry dashEntry = (DashEntry)iterator.next();
            String imageId = "";
            SysDashboardVo sysDashboardVo = new SysDashboardVo();
            if (!HussarUtils.isNotEmpty((Object)dashEntry)) continue;
            DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), DashboardJsonData.class);
            if (HussarUtils.isNotEmpty((Object)dashboardJsonData)) {
                JSONArray components;
                if (HussarUtils.isNotEmpty((Object)dashboardJsonData.getStyles())) {
                    JSONObject jsonObject;
                    JSONObject dashboardStyleWidget;
                    JSONObject dashboardStyleBackgroud = dashboardJsonData.getStyles().getJSONObject("background");
                    if (HussarUtils.isNotEmpty((Object)dashboardStyleBackgroud) && HussarUtils.isNotEmpty((Object)dashboardStyleBackgroud.getString("imageUrl"))) {
                        imageId = HussarUtils.isEmpty((Object)imageId) ? dashboardStyleBackgroud.getString("imageUrl") : imageId + "," + dashboardStyleBackgroud.getString("imageUrl");
                    }
                    if (HussarUtils.isNotEmpty((Object)(dashboardStyleWidget = dashboardJsonData.getStyles().getJSONObject("widget"))) && HussarUtils.isNotEmpty((Object)(jsonObject = dashboardStyleWidget.getJSONObject("background"))) && HussarUtils.isNotEmpty((Object)jsonObject.getString("imageUrl"))) {
                        imageId = HussarUtils.isEmpty((Object)imageId) ? jsonObject.getString("imageUrl") : imageId + "," + jsonObject.getString("imageUrl");
                    }
                }
                if (HussarUtils.isNotEmpty((Object)(components = dashboardJsonData.getComponents()))) {
                    for (int i = 0; i < components.size(); ++i) {
                        JSONArray imageList;
                        WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)components.getString(i), WidgetJsonData.class);
                        if ("board_image".equals(widgetJsonData.getType())) {
                            JSONObject imageContent = widgetJsonData.getImageContent();
                            imageList = imageContent.getJSONArray("imageList");
                            if (!HussarUtils.isNotEmpty((Object)imageList)) continue;
                        } else {
                            JSONObject jsonObject;
                            JSONObject objWidget;
                            JSONObject jsonObjectStyle = widgetJsonData.getStyles();
                            if (!HussarUtils.isNotEmpty((Object)jsonObjectStyle) || !HussarUtils.isNotEmpty((Object)(objWidget = jsonObjectStyle.getJSONObject("widget"))) || !HussarUtils.isNotEmpty((Object)(jsonObject = objWidget.getJSONObject("background"))) || !HussarUtils.isNotEmpty((Object)jsonObject.getString("imageUrl"))) continue;
                            if (HussarUtils.isEmpty((Object)imageId)) {
                                imageId = jsonObject.getString("imageUrl");
                                continue;
                            }
                            imageId = imageId + "," + jsonObject.getString("imageUrl");
                            continue;
                        }
                        for (int j = 0; j < imageList.size(); ++j) {
                            JSONObject jsonObject = imageList.getJSONObject(j);
                            if (!HussarUtils.isNotEmpty((Object)jsonObject.getString("id"))) continue;
                            imageId = HussarUtils.isEmpty((Object)imageId) ? jsonObject.getString("id") : imageId + "," + jsonObject.getString("id");
                        }
                    }
                }
            }
            sysDashboardVo.setFormId(dashEntry.getEntryId());
            sysDashboardVo.setImageId(imageId);
            sysDashboardVoList.add(sysDashboardVo);
        }
        return sysDashboardVoList;
    }

    private List<SysFileInfoVo> getImageId(List<SysDashboardVo> sysDashboardVoList) {
        ArrayList<SysFileInfoVo> sysFileInfoVoList = new ArrayList<SysFileInfoVo>();
        for (SysDashboardVo sysDashboardVo : sysDashboardVoList) {
            String[] imageIdArr = sysDashboardVo.getImageId().split(",");
            List attachmentManagerModelVos = this.ossService.getByFileIds(imageIdArr);
            for (AttachmentManagerModelVo attachmentManagerModelVo : attachmentManagerModelVos) {
                SysFileInfoVo sysFileInfoVo = (SysFileInfoVo)HussarUtils.copyProperties((Object)attachmentManagerModelVo, SysFileInfoVo.class);
                sysFileInfoVo.setFormId(sysDashboardVo.getFormId());
                sysFileInfoVoList.add(sysFileInfoVo);
            }
        }
        return sysFileInfoVoList;
    }

    public void exportPlugin(AppExportDto appExportDto) throws Exception {
        PluginOperator pluginOperator = (PluginOperator)SpringContextUtil.getBean(PluginOperator.class);
        Set pluginFilePaths = pluginOperator.getPluginFilePaths();
        String basePath = appExportDto.getBasePath();
        if (HussarUtils.isNotEmpty((Object)pluginFilePaths)) {
            for (String pluginFilePath : pluginFilePaths) {
                Path source = Paths.get(pluginFilePath, new String[0]);
                String jarName = source.getFileName().toString();
                String folderPath = basePath + File.separator + "pluginExpand";
                String targetPath = folderPath + File.separator + jarName;
                Path target = Paths.get(targetPath, new String[0]);
                Path targetDir = target.getParent();
                try {
                    if (Files.exists(source, new LinkOption[0])) {
                        if (!Files.exists(targetDir, new LinkOption[0])) {
                            Files.createDirectories(targetDir, new FileAttribute[0]);
                        }
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                        logger.info("\u5e94\u7528\u5bfc\u51fa\u63d2\u4ef6,JAR \u6587\u4ef6\u5df2\u6210\u529f\u590d\u5236\u5230\u76ee\u6807\u4f4d\u7f6e:{}", (Object)targetPath);
                        continue;
                    }
                    logger.error("\u5e94\u7528\u5bfc\u51fa\u63d2\u4ef6\uff0c\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)source.toString());
                }
                catch (IOException e) {
                    logger.error("\u5e94\u7528\u5bfc\u51fa\u63d2\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        }
    }

    @ProgressCache(status=9, msg="\u6b63\u5728\u5bfc\u51fa\u83dc\u5355\u529f\u80fd\u8d44\u6e90\u4fe1\u606f")
    public void exportMenuFuncResInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        AppMenuFuncResVo appMenuFuncResInfo = this.sysFunctionsBoService.getAppMenuFuncResInfo(appExportDto.getAppId());
        this.writeToFile(appMenuFuncResInfo, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "menuFuncRes.json"}));
    }

    private void exportExtensionApi(AppExportDto appExportDto, String basePath) {
        List formExtApis = this.sysFormExtApiService.appExtApiAllList(appExportDto.getAppId());
        if (HussarUtils.isNotEmpty((Object)formExtApis)) {
            appExportDto.setUsedPluginFlag(true);
            String formExtApiPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "extensionApi.json"});
            this.writeToFile(formExtApis, formExtApiPath);
        }
    }
}

