/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.menu.constant.MenuConstants;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitRoleField;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.sync.union.dto.ConversionProduct;
import com.jxdinfo.hussar.formdesign.application.sync.union.dto.CustomDataCondition;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUnionHelper;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SyncUnionConverter {
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;
    @Resource
    private ISysAppVisitDataLogicBoService sysAppVisitDataLogicBoService;
    @Resource
    private ISysCustomButtonService customButtonService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private SyncUnionHelper syncUnionHelper;
    private static final Integer FORM_ORDER = 999;

    public ConversionProduct appToModule(SysApplication app, ConversionProduct conversionProduct) {
        if (HussarUtils.isEmpty((Object)conversionProduct)) {
            conversionProduct = new ConversionProduct();
        }
        String i18Keys = this.getI18Keys(app.getI18nKeys());
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(app.getId());
        funModule.setFunctionModuleName(app.getAppName());
        funModule.setFunctionModuleCode(String.valueOf(app.getId()));
        funModule.setApplicationId(Long.valueOf(1L));
        funModule.setAppId(app.getId());
        funModule.setParentModuleId(Long.valueOf(4L));
        funModule.setSeq(app.getAppSeq());
        funModule.setNameLangKey(i18Keys);
        funModule.setFunModSource("noCode");
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(app.getId());
        resModule.setModuleName(app.getAppName());
        resModule.setModuleCode(String.valueOf(app.getId()));
        resModule.setApplicationId(Long.valueOf(1L));
        resModule.setAppId(app.getId());
        resModule.setParentModuleId(Long.valueOf(4L));
        resModule.setSeq(app.getAppSeq());
        resModule.setNameLangKey(i18Keys);
        resModule.setResModSource("noCode");
        conversionProduct.getResourceModulesList().add(resModule);
        SysMenu sysMenu = this.appToMenu(app);
        conversionProduct.getMenuList().add(sysMenu);
        return conversionProduct;
    }

    public ConversionProduct formGroupToModule(SysFormGroup formGroup, ConversionProduct conversionProduct) {
        if (HussarUtils.isEmpty((Object)conversionProduct)) {
            conversionProduct = new ConversionProduct();
        }
        String i18Keys = this.getI18Keys(formGroup.getI18nKeys());
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(formGroup.getId());
        funModule.setFunctionModuleName(formGroup.getGroupName());
        funModule.setFunctionModuleCode(String.valueOf(formGroup.getId()));
        funModule.setParentModuleId(formGroup.getAppId());
        funModule.setSeq(formGroup.getSeq());
        funModule.setApplicationId(Long.valueOf(1L));
        funModule.setAppId(formGroup.getAppId());
        funModule.setNameLangKey(i18Keys);
        funModule.setFunModSource("noCode");
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(formGroup.getId());
        resModule.setModuleName(formGroup.getGroupName());
        resModule.setModuleCode(String.valueOf(formGroup.getId()));
        resModule.setParentModuleId(formGroup.getAppId());
        resModule.setSeq(formGroup.getSeq());
        resModule.setApplicationId(Long.valueOf(1L));
        resModule.setAppId(formGroup.getAppId());
        resModule.setNameLangKey(i18Keys);
        resModule.setResModSource("noCode");
        conversionProduct.getResourceModulesList().add(resModule);
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(formGroup.getId());
        sysMenu.setText(formGroup.getGroupName());
        sysMenu.setMenuAlias(formGroup.getGroupName());
        sysMenu.setTextLangKey(i18Keys);
        sysMenu.setAliasLangKey(i18Keys);
        sysMenu.setParentId(formGroup.getAppId());
        sysMenu.setSeq(formGroup.getSeq());
        sysMenu.setIsLeaf("0");
        if (HussarUtils.equals((Object)"2", (Object)formGroup.getGroupIconType())) {
            sysMenu.setIcons("caidan_folder_close");
        } else {
            sysMenu.setIcons(formGroup.getGroupIcon());
        }
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setOpenMode("0");
        sysMenu.setIfDisplay("1");
        conversionProduct.getMenuList().add(sysMenu);
        return conversionProduct;
    }

    public void formToModule(SysForm form, ConversionProduct conversionProduct) {
        Long parentModuleId = HussarUtils.isNotEmpty((Object)form.getFormGroupId()) ? form.getFormGroupId() : form.getAppId();
        String i18Keys = this.getI18Keys(form.getI18nKeys());
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(form.getId());
        funModule.setFunctionModuleName(form.getFormName());
        funModule.setFunctionModuleCode(String.valueOf(form.getId()));
        funModule.setNameLangKey(i18Keys);
        funModule.setParentModuleId(parentModuleId);
        funModule.setSeq(Integer.valueOf(form.getSeq()));
        funModule.setApplicationId(Long.valueOf(1L));
        funModule.setAppId(form.getAppId());
        funModule.setFunModSource("noCode");
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(form.getId());
        resModule.setModuleName(form.getFormName());
        resModule.setModuleCode(String.valueOf(form.getId()));
        resModule.setNameLangKey(i18Keys);
        resModule.setParentModuleId(parentModuleId);
        resModule.setSeq(Integer.valueOf(form.getSeq()));
        resModule.setApplicationId(Long.valueOf(1L));
        resModule.setAppId(form.getAppId());
        resModule.setResModSource("noCode");
        conversionProduct.getResourceModulesList().add(resModule);
    }

    public SysMenu formToMenu(SysForm form) {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(form.getId());
        sysMenu.setText(form.getFormName());
        sysMenu.setMenuAlias(form.getFormName());
        String i18Keys = this.getI18Keys(form.getI18nKeys());
        sysMenu.setTextLangKey(i18Keys);
        sysMenu.setAliasLangKey(i18Keys);
        if (HussarUtils.isNotEmpty((Object)form.getFormGroupId())) {
            sysMenu.setParentId(form.getFormGroupId());
            sysMenu.setSeq(Integer.valueOf(form.getSeq()));
        } else {
            sysMenu.setParentId(form.getAppId());
            sysMenu.setSeq(Integer.valueOf(FORM_ORDER + form.getSeq()));
        }
        sysMenu.setIsLeaf("1");
        sysMenu.setIcons(form.getFormIcon());
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setOpenMode("0");
        if (HussarUtils.isNotEmpty((Object)form.getHidden()) && form.getHidden().contains("pc")) {
            sysMenu.setIfDisplay("0");
        } else {
            sysMenu.setIfDisplay("1");
        }
        sysMenu.setPath(SyncUtil.asmResPath(form));
        sysMenu.setComponent(SyncUtil.asmResComponent(form));
        return sysMenu;
    }

    public SysMenu formGroupToMenu(SysFormGroup formGroup) {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(formGroup.getId());
        sysMenu.setText(formGroup.getGroupName());
        sysMenu.setMenuAlias(formGroup.getGroupName());
        String i18Keys = this.getI18Keys(formGroup.getI18nKeys());
        sysMenu.setTextLangKey(i18Keys);
        sysMenu.setAliasLangKey(i18Keys);
        sysMenu.setParentId(formGroup.getAppId());
        sysMenu.setSeq(formGroup.getSeq());
        sysMenu.setIsLeaf("0");
        if (HussarUtils.equals((Object)"2", (Object)formGroup.getGroupIconType())) {
            sysMenu.setIcons("caidan_folder_close");
        } else {
            sysMenu.setIcons(formGroup.getGroupIcon());
        }
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setOpenMode("0");
        sysMenu.setIfDisplay("1");
        return sysMenu;
    }

    public SysMenu appToMenu(SysApplication application) {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(application.getId());
        sysMenu.setText(application.getAppName());
        sysMenu.setMenuAlias(application.getAppName());
        String i18Keys = this.getI18Keys(application.getI18nKeys());
        sysMenu.setTextLangKey(i18Keys);
        sysMenu.setAliasLangKey(i18Keys);
        sysMenu.setParentId(MenuConstants.MENU_APP_PORTAL);
        sysMenu.setSeq(application.getAppSeq());
        sysMenu.setIsLeaf("0");
        if (HussarUtils.equals((Object)"2", (Object)application.getAppIconType())) {
            sysMenu.setIcons("caidan-1Jmoren");
        } else {
            sysMenu.setIcons(application.getAppIcon());
        }
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setOpenMode("0");
        String appStatus = application.getAppStatus();
        String isDisPlay = HussarUtils.equals((Object)"0", (Object)appStatus) ? "0" : "1";
        sysMenu.setIfDisplay(isDisPlay);
        return sysMenu;
    }

    public Map<String, Long> formToMenuRes(SysForm form, ConversionProduct conversionProduct) {
        String i18Keys = this.getI18Keys(form.getI18nKeys());
        String resourceCode = "menu_" + form.getId();
        SysResources sysResources = this.hussarBaseResourceService.getResourcesByCode(resourceCode);
        SysResources res = new SysResources();
        final Long resId = HussarUtils.isNotEmpty((Object)sysResources) ? sysResources.getId() : IdWorker.getId((Object)res);
        res.setId(resId);
        res.setResourceName(form.getFormName());
        res.setResourceAlias(form.getFormName());
        res.setModuleId(form.getId());
        res.setAliasLangKey(i18Keys);
        res.setNameLangKey(i18Keys);
        res.setPath(SyncUtil.asmResPath(form));
        res.setComponent(SyncUtil.asmResComponent(form));
        res.setResTypeId("res_menu");
        res.setStrategy("4");
        res.setResourceCode(resourceCode);
        res.setSeq(Integer.valueOf(conversionProduct.getResourceList().size() + 1));
        res.setApplicationId(Long.valueOf(1L));
        res.setAppId(form.getAppId());
        res.setResSource("noCode");
        res.setKeepAlive("1");
        conversionProduct.getResourceList().add(res);
        conversionProduct.getMenuResIdMap().put(form.getId(), res.getId());
        String functionCode = "menu_" + form.getId();
        SysFunctions sysFunctions = this.functionsBoService.getOneByCode(functionCode);
        SysFunctions fun = new SysFunctions();
        final Long funId = HussarUtils.isNotEmpty((Object)sysFunctions) ? sysFunctions.getId() : IdWorker.getId((Object)fun);
        fun.setId(funId);
        fun.setFunctionCode(functionCode);
        fun.setFunctionModuleId(form.getId());
        fun.setFunctionName(form.getFormName());
        fun.setNameLangKey(i18Keys);
        fun.setDefaultResourceId(res.getId());
        fun.setSeq(Integer.valueOf(conversionProduct.getFunctionList().size() + 1));
        fun.setApplicationId(Long.valueOf(1L));
        fun.setAppId(form.getAppId());
        fun.setFunSource("noCode");
        conversionProduct.getFunctionList().add(fun);
        conversionProduct.getMenuFunIdMap().put(form.getId(), fun.getId());
        conversionProduct.getFunctionResourceList().add(this.newFunRes(fun.getId(), res.getId()));
        return new HashMap<String, Long>(){
            {
                this.put("funId", funId);
                this.put("resId", resId);
            }
        };
    }

    public void formToElementRes(SysForm form, Long resId, ConversionProduct conversionProduct) {
        List customButtons;
        Long formId = form.getId();
        conversionProduct.getElementFunMap().put(formId, new ArrayList());
        conversionProduct.getElementResMap().put(formId, new ArrayList());
        ArrayList<Button> buttons = new ArrayList<Button>();
        switch (form.getFormType()) {
            case "0": {
                buttons.add(Button.CREATE_OPERATE);
                buttons.add(Button.EDIT_OPERATE);
                buttons.add(Button.DELETE_OPERATE);
                buttons.add(Button.IMPORT_OPTION);
                buttons.add(Button.EXPORT_OPTION);
                buttons.add(Button.PRINT_OPERATE);
                buttons.add(Button.DOWNLOAD_OPERATE);
                break;
            }
            case "1": {
                buttons.add(Button.CREATE_OPERATE);
                buttons.add(Button.EDIT_OPERATE);
                buttons.add(Button.DELETE_OPERATE);
                buttons.add(Button.IMPORT_OPTION);
                buttons.add(Button.EXPORT_OPTION);
                buttons.add(Button.PRINT_OPERATE);
                buttons.add(Button.DOWNLOAD_OPERATE);
                buttons.add(Button.SUBMIT_OPERATE);
                buttons.add(Button.REJECT_OPERATE);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (HussarUtils.isNotEmpty(buttons)) {
            for (Button button : buttons) {
                SysResources elementRes = new SysResources();
                elementRes.setId(Long.valueOf(IdWorker.getId((Object)elementRes)));
                elementRes.setResourceName(button.getButtonName() + "\u6309\u94ae");
                elementRes.setResourceAlias(button.getButtonName() + "\u6309\u94ae");
                elementRes.setModuleId(form.getId());
                elementRes.setResTypeId("res_element");
                elementRes.setPermissions(button.getButtonCode());
                elementRes.setResourceCode("element_" + form.getId() + "_" + button.getButtonCode());
                elementRes.setParentResourceId(resId);
                elementRes.setApplicationId(Long.valueOf(1L));
                elementRes.setAppId(form.getAppId());
                elementRes.setResSource("noCode");
                elementRes.setSeq(Integer.valueOf(conversionProduct.getResourceList().size() + 1));
                conversionProduct.getResourceList().add(elementRes);
                conversionProduct.getElementResMap().get(formId).add(elementRes);
                SysFunctions fun = new SysFunctions();
                fun.setId(Long.valueOf(IdWorker.getId((Object)fun)));
                fun.setFunctionCode("element_" + form.getId() + "_" + button.getButtonCode());
                fun.setFunctionModuleId(form.getId());
                fun.setFunctionName(button.getButtonName());
                fun.setSeq(Integer.valueOf(conversionProduct.getFunctionList().size() + 1));
                fun.setApplicationId(Long.valueOf(1L));
                fun.setAppId(form.getAppId());
                fun.setFunSource("noCode");
                conversionProduct.getFunctionList().add(fun);
                conversionProduct.getElementFunMap().get(formId).add(fun);
                conversionProduct.getFunctionResourceList().add(this.newFunRes(fun.getId(), elementRes.getId()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(customButtons = this.customButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)form.getId()))))) {
            for (SysCustomButton customButton : customButtons) {
                String buttonCode = customButton.getAction();
                String buttonAlias = customButton.getAlias();
                SysFunctions fun = new SysFunctions();
                fun.setId(customButton.getId());
                fun.setFunctionCode("element_" + formId + "_" + buttonCode);
                fun.setFunctionModuleId(formId);
                fun.setFunctionName(buttonAlias);
                fun.setSeq(Integer.valueOf(conversionProduct.getFunctionList().size() + 1));
                fun.setApplicationId(Long.valueOf(1L));
                fun.setAppId(form.getAppId());
                fun.setFunSource("noCode");
                conversionProduct.getFunctionList().add(fun);
                conversionProduct.getElementFunMap().get(formId).add(fun);
                SysResources customButtonRes = new SysResources();
                customButtonRes.setId(customButton.getId());
                customButtonRes.setResourceName(buttonAlias);
                customButtonRes.setResourceAlias(buttonAlias);
                customButtonRes.setModuleId(formId);
                customButtonRes.setResTypeId("res_element");
                customButtonRes.setPermissions(buttonCode);
                customButtonRes.setResourceCode("element_" + formId + "_" + buttonCode);
                customButtonRes.setParentResourceId(resId);
                customButtonRes.setSeq(Integer.valueOf(conversionProduct.getResourceList().size() + 1));
                customButtonRes.setApplicationId(Long.valueOf(1L));
                customButtonRes.setAppId(form.getAppId());
                customButtonRes.setResSource("noCode");
                conversionProduct.getResourceList().add(customButtonRes);
                conversionProduct.getElementResMap().get(formId).add(customButtonRes);
                conversionProduct.getFunctionResourceList().add(this.newFunRes(fun.getId(), customButtonRes.getId()));
            }
        }
    }

    public void formToDataRes(SysForm form, ConversionProduct conversionProduct) {
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(form.getId());
        List<SysResources> dataResources = this.dataResToResource(form);
        if (HussarUtils.isNotEmpty(dataResources)) {
            conversionProduct.getResourceList().addAll(dataResources);
            conversionProduct.getDataResIdMap().put(form.getId(), dataResources.stream().map(SysResources::getId).collect(Collectors.toList()));
            for (SysResources resources : dataResources) {
                conversionProduct.getFunctionResourceList().add(this.newFunRes(menuFunId, resources.getId()));
            }
        }
    }

    public void formToOpenInterfaceRes(SysForm form, ConversionProduct conversionProduct) {
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(form.getId());
        List<SysResources> openInterfaceResources = this.openInterfaceResToResource(form);
        if (HussarUtils.isNotEmpty(openInterfaceResources)) {
            conversionProduct.getResourceList().addAll(openInterfaceResources);
            conversionProduct.getOpenInterfaceResIdMap().put(form.getId(), openInterfaceResources.stream().map(SysResources::getId).collect(Collectors.toList()));
            for (SysResources resources : openInterfaceResources) {
                conversionProduct.getFunctionResourceList().add(this.newFunRes(menuFunId, resources.getId()));
            }
        }
    }

    public List<SysResources> dataResToResource(SysForm form) {
        ArrayList<SysResources> dataResources = new ArrayList<SysResources>(6);
        ArrayList<String> nodeNames = new ArrayList<String>();
        ArrayList<String> nodeDecs = new ArrayList<String>();
        nodeDecs.add("\u5355\u8868\u67e5\u8be2\u5206\u9875\u6570\u636e\u8d44\u6e90");
        nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuery");
        nodeDecs.add("\u5355\u8868\u67e5\u8be2\u96c6\u5408\u6570\u636e\u8d44\u6e90");
        nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQueryAll");
        if ("0".equals(form.getFormType())) {
            nodeDecs.add("\u5355\u8868\u67e5\u8be2\u5206\u9875\uff08\u89c6\u56fe\uff09\u6570\u636e\u8d44\u6e90");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQueryjoiopt0oou9plqj559byloyqdj0dk31i");
        } else {
            nodeDecs.add("\u5355\u8868\u67e5\u8be2\u5206\u9875\uff08\u89c6\u56fe\uff09\u6570\u636e\u8d44\u6e90");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuerye33a41s5fcl06btfvdc0qnbvqt9wd1h4");
            nodeDecs.add("\u6211\u7684\u8349\u7a3f\u6570\u636e\u8d44\u6e90");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQueryjvcdwume0vxztr0lfnp4doe8152rrdtz");
            nodeDecs.add("\u6211\u7684\u5f85\u529e\u6570\u636e\u8d44\u6e90");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuery5m3f3ywhll6fjnk916ywvqbfp11mu5bq");
            nodeDecs.add("\u6211\u7684\u5df2\u529e\u6570\u636e\u8d44\u6e90");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuery2is61eg3qeb3a662lsh6j385v2blbv24");
        }
        for (int i = 0; i < nodeNames.size(); ++i) {
            String nodeName = (String)nodeNames.get(i);
            SysResources res = new SysResources();
            res.setId(Long.valueOf(IdWorker.getId((Object)res)));
            res.setResourceName((String)nodeDecs.get(i));
            res.setResourceAlias((String)nodeDecs.get(i));
            res.setModuleId(form.getId());
            res.setResTypeId("res_form_rights");
            res.setResourceCode(form.getId() + "_" + "res_form_rights" + "_" + SyncUtil.subNodeNameType(nodeName));
            res.setUserRight("data_holder");
            res.setDeptRight("data_organ");
            res.setMapper(nodeName);
            res.setApplicationId(Long.valueOf(1L));
            res.setAppId(form.getAppId());
            res.setResSource("noCode");
            dataResources.add(res);
        }
        return dataResources;
    }

    public List<SysResources> openInterfaceResToResource(SysForm form) {
        ArrayList<SysResources> openInterfaceResources = new ArrayList<SysResources>(6);
        ArrayList<String> nodeDecs = new ArrayList<String>();
        ArrayList<String> nodeCodes = new ArrayList<String>();
        ArrayList<String> nodeUrls = new ArrayList<String>();
        nodeDecs.add("\u5f00\u653e\u63a5\u53e3-\u5217\u8868\u67e5\u8be2");
        nodeCodes.add("tableQuery_" + form.getId());
        nodeUrls.add("/hussarApp/authApi/formInfo/" + form.getId() + "/tableQuery");
        nodeDecs.add("\u5f00\u653e\u63a5\u53e3-\u8be6\u60c5\u67e5\u8be2");
        nodeUrls.add("/hussarApp/authApi/formInfo/" + form.getId() + "/formQuery");
        nodeCodes.add("formQuery_" + form.getId());
        for (int i = 0; i < nodeCodes.size(); ++i) {
            SysResources res = new SysResources();
            res.setId(Long.valueOf(IdWorker.getId((Object)res)));
            res.setResourceName((String)nodeDecs.get(i));
            res.setResourceAlias((String)nodeDecs.get(i));
            res.setUrlNames((String)nodeUrls.get(i));
            res.setModuleId(form.getId());
            res.setResTypeId("res_open_interface");
            res.setResourceCode((String)nodeCodes.get(i));
            res.setUserRight("data_holder");
            res.setDeptRight("data_organ");
            res.setApplicationId(Long.valueOf(1L));
            res.setAppId(form.getAppId());
            res.setResSource("noCode");
            openInterfaceResources.add(res);
        }
        return openInterfaceResources;
    }

    public void authFormForAppDevRole(Long appId, ConversionProduct conversionProduct) {
        Long appDevRoleId = this.sysApplicationBoService.selectById(appId).getDevelopRoleId();
        List allFunIdsByForm = conversionProduct.getFunctionList().stream().map(SysFunctions::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)appDevRoleId) && HussarUtils.isNotEmpty(allFunIdsByForm)) {
            for (Long funId : allFunIdsByForm) {
                conversionProduct.getRoleFunctionList().add(this.newRoleFun(appDevRoleId, funId));
            }
        }
        List allResIdsByForm = conversionProduct.getResourceList().stream().map(SysResources::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)appDevRoleId) && HussarUtils.isNotEmpty(allResIdsByForm)) {
            for (Long resId : allResIdsByForm) {
                conversionProduct.getRoleResourceList().add(this.newRoleRes(appDevRoleId, resId));
            }
        }
    }

    public void formAuthToRelation(SysAppVisitFormAuthorizeRoles formAuth, ConversionProduct conversionProduct) {
        Long roleId = formAuth.getRoleId();
        Long formId = formAuth.getFormId();
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(formId);
        Long menuResId = conversionProduct.getMenuResIdMap().get(formId);
        if (HussarUtils.isNotEmpty((Object)menuFunId) && HussarUtils.isNotEmpty((Object)menuResId)) {
            conversionProduct.getRoleFunctionList().add(this.newRoleFun(roleId, menuFunId));
            conversionProduct.getRoleResourceList().add(this.newRoleRes(roleId, menuResId));
            List<Long> dataResIdByForm = conversionProduct.getDataResIdMap().get(formId);
            if (HussarUtils.isNotEmpty(dataResIdByForm)) {
                for (Long dataResId : dataResIdByForm) {
                    conversionProduct.getRoleResourceList().add(this.newRoleRes(roleId, dataResId));
                }
            }
        }
    }

    public void buttonAuthToRelation(SysAppVisitRoleButton buttonAuth, ConversionProduct conversionProduct) {
        Long formId = buttonAuth.getFormId();
        Long roleId = buttonAuth.getRoleId();
        String buttonCode = buttonAuth.getButtonCode();
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(formId);
        if (HussarUtils.isNotEmpty((Object)menuFunId)) {
            SysResources elementRes;
            String elementCode = "element_" + formId + "_" + buttonCode;
            SysFunctions elementFun = conversionProduct.getElementFunMap().get(formId).stream().filter(fun -> elementCode.equals(fun.getFunctionCode())).findFirst().orElse(null);
            if (HussarUtils.isNotEmpty((Object)elementFun)) {
                conversionProduct.getRoleFunctionList().add(this.newRoleFun(roleId, elementFun.getId()));
            }
            if (HussarUtils.isNotEmpty((Object)(elementRes = (SysResources)conversionProduct.getElementResMap().get(formId).stream().filter(res -> elementCode.equals(res.getResourceCode())).findFirst().orElse(null)))) {
                conversionProduct.getRoleResourceList().add(this.newRoleRes(roleId, elementRes.getId()));
            }
        }
    }

    public void dataAuthToRoleDataRight(SysAppVisitFormAuthorizeRoles formAuth, ConversionProduct conversionProduct) {
        SysRoleDataRight roleDataRight = new SysRoleDataRight();
        Long formId = formAuth.getFormId();
        Long roleId = formAuth.getRoleId();
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(formId);
        if (HussarUtils.isNotEmpty((Object)menuFunId)) {
            roleDataRight.setDataRightsId(Long.valueOf(IdWorker.getId((Object)roleDataRight)));
            roleDataRight.setRoleId(roleId);
            roleDataRight.setFunctionId(menuFunId);
            roleDataRight.setDataScope(Integer.valueOf("1"));
            roleDataRight.setResTypeCode("res_form_rights");
            roleDataRight.setDataScopeLabel("1");
            CustomDataCondition customDataCondition = new CustomDataCondition();
            SysAppVisitRoleOrganDataAuthority roleOrganDataAuth = (SysAppVisitRoleOrganDataAuthority)this.roleOrganDataAuthorityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)roleOrganDataAuth)) {
                roleDataRight.setDataScope(this.covertDataScope(roleOrganDataAuth));
                roleDataRight.setDataScopeLabel(String.valueOf(this.covertDataScope(roleOrganDataAuth)));
                boolean customFlag = "5".equals(String.valueOf(roleDataRight.getDataScope()));
                if (customFlag) {
                    CustomDataCondition.CustomOrganAndUserInfo customOrganAndUserInfo = this.roleOrganAuthToCustomDataCondition(roleOrganDataAuth);
                    ArrayList<SysRoleStruRights> sysRoleStruRightsList = new ArrayList<SysRoleStruRights>();
                    ArrayList<SysRoleUserRights> sysRoleUserRightsList = new ArrayList<SysRoleUserRights>();
                    if (HussarUtils.isNotEmpty((Object)customOrganAndUserInfo.getOrganIdList())) {
                        String[] organIds;
                        for (String organId : organIds = customOrganAndUserInfo.getOrganIdList().split(",")) {
                            SysRoleStruRights sysRoleStruRights = new SysRoleStruRights();
                            sysRoleStruRights.setRoleDataRightsId(roleDataRight.getDataRightsId());
                            sysRoleStruRights.setRoleId(roleId);
                            sysRoleStruRights.setStruid(Long.valueOf(organId));
                            sysRoleStruRightsList.add(sysRoleStruRights);
                        }
                    }
                    if (HussarUtils.isNotEmpty((Object)customOrganAndUserInfo.getUserIdList())) {
                        String[] userIds;
                        for (String userId : userIds = customOrganAndUserInfo.getUserIdList().split(",")) {
                            SysRoleUserRights sysRoleUserRights = new SysRoleUserRights();
                            sysRoleUserRights.setRoleDataRightsId(roleDataRight.getDataRightsId());
                            sysRoleUserRights.setRoleId(roleId);
                            sysRoleUserRights.setUserId(Long.valueOf(userId));
                            sysRoleUserRightsList.add(sysRoleUserRights);
                        }
                    }
                    conversionProduct.getRoleStruRightsList().addAll(sysRoleStruRightsList);
                    conversionProduct.getRoleUserRightsList().addAll(sysRoleUserRightsList);
                }
            }
            conversionProduct.getRoleDataRightList().add(roleDataRight);
        }
    }

    private SysFunctionResources newFunRes(Long funId, Long resId) {
        SysFunctionResources functionResources = new SysFunctionResources();
        functionResources.setFunctionId(funId);
        functionResources.setResourceId(resId);
        return functionResources;
    }

    public String getI18Keys(String i18Str) {
        String keys = "";
        if (HussarUtils.isNotEmpty((Object)i18Str)) {
            Map i18Map = (Map)JSON.parseObject((String)i18Str, Map.class);
            if (HussarUtils.isNotEmpty(i18Map.get("appName"))) {
                keys = i18Map.get("appName").toString();
                return keys;
            }
            if (HussarUtils.isNotEmpty(i18Map.get("formName"))) {
                keys = i18Map.get("formName").toString();
                return keys;
            }
            if (HussarUtils.isNotEmpty(i18Map.get("groupName"))) {
                keys = i18Map.get("groupName").toString();
                return keys;
            }
            if (HussarUtils.isNotEmpty(i18Map.get("alias"))) {
                keys = i18Map.get("alias").toString();
                return keys;
            }
        }
        return keys;
    }

    private SysRoleFunctions newRoleFun(Long roleId, Long funId) {
        SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
        sysRoleFunctions.setRoleId(roleId);
        sysRoleFunctions.setFunctionId(funId);
        return sysRoleFunctions;
    }

    private SysRoleResource newRoleRes(Long roleId, Long resId) {
        SysRoleResource sysRoleResource = new SysRoleResource();
        sysRoleResource.setRoleId(roleId);
        sysRoleResource.setResourceId(resId);
        sysRoleResource.setRelationSource("1");
        return sysRoleResource;
    }

    public SysRoleDataRight dataAuthToRoleDataRight(Long formId, Long roleId) {
        List roleFields;
        SysAppVisitDataLogic dataLogic;
        SysRoleDataRight roleDataRight = new SysRoleDataRight();
        roleDataRight.setRoleId(roleId);
        roleDataRight.setFunctionId(this.getMenuFunId(formId));
        roleDataRight.setDataScope(Integer.valueOf("1"));
        roleDataRight.setResTypeCode("res_form_rights");
        roleDataRight.setDataScopeLabel("1");
        CustomDataCondition customDataCondition = new CustomDataCondition();
        SysAppVisitRoleOrganDataAuthority roleOrganDataAuth = (SysAppVisitRoleOrganDataAuthority)this.roleOrganDataAuthorityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
        if (HussarUtils.isNotEmpty((Object)roleOrganDataAuth)) {
            roleDataRight.setDataScope(this.covertDataScope(roleOrganDataAuth));
            roleDataRight.setDataScopeLabel(String.valueOf(this.covertDataScope(roleOrganDataAuth)));
            boolean customFlag = "5".equals(String.valueOf(roleDataRight.getDataScope()));
            if (customFlag) {
                customDataCondition.setCustomOrganAndUserInfo(this.roleOrganAuthToCustomDataCondition(roleOrganDataAuth));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(dataLogic = this.sysAppVisitDataLogicBoService.getDataLogic(null, formId, roleId)))) {
            customDataCondition.setDataLogic(this.dataLogicToCustomDataCondition(dataLogic));
        }
        if (HussarUtils.isNotEmpty((Object)(roleFields = this.sysAppVisitRoleFieldBoService.listRoleField(null, formId, roleId)))) {
            customDataCondition.setFieldAuthority(this.roleFieldToCustomDataCondition(roleFields));
        }
        roleDataRight.setCustomDataCondition(JSON.toJSONString((Object)customDataCondition));
        return roleDataRight;
    }

    public void roleOrganDataAuthToDataRight(SysAppVisitRoleOrganDataAuthority organAuth, ConversionProduct conversionProduct) {
        SysRoleDataRight roleDataRight = new SysRoleDataRight();
        roleDataRight.setRoleId(organAuth.getRoleId());
        roleDataRight.setFunctionId(conversionProduct.getMenuFunIdMap().get(organAuth.getFormId()));
        roleDataRight.setResTypeCode("res_form_rights");
        roleDataRight.setDataScope(this.covertDataScope(organAuth));
        roleDataRight.setDataScopeLabel(String.valueOf(this.covertDataScope(organAuth)));
        conversionProduct.getRoleDataRightList().add(roleDataRight);
    }

    private Integer covertDataScope(SysAppVisitRoleOrganDataAuthority roleOrganAuth) {
        String dataScope = HussarUtils.equals((Object)"1", (Object)roleOrganAuth.getOnlyIndividuals()) ? "4" : (HussarUtils.equals((Object)"1", (Object)roleOrganAuth.getOnlySupOrgan()) ? "3" : (HussarUtils.equals((Object)"1", (Object)roleOrganAuth.getAllOrgan()) ? "1" : "5"));
        return Integer.valueOf(dataScope);
    }

    private CustomDataCondition.CustomOrganAndUserInfo roleOrganAuthToCustomDataCondition(SysAppVisitRoleOrganDataAuthority roleOrganAuth) {
        CustomDataCondition.CustomOrganAndUserInfo customOrganAndUserInfo = new CustomDataCondition.CustomOrganAndUserInfo();
        customOrganAndUserInfo.setOrganIdList(roleOrganAuth.getOrganIdList());
        customOrganAndUserInfo.setUserIdList(roleOrganAuth.getUserIdList());
        return customOrganAndUserInfo;
    }

    private CustomDataCondition.DataLogic dataLogicToCustomDataCondition(SysAppVisitDataLogic dataLogicNo) {
        CustomDataCondition.DataLogic dataLogicLow = new CustomDataCondition.DataLogic();
        dataLogicLow.setCombineType(dataLogicNo.getCombineType());
        List dataLogicFilters = this.sysAppVisitDataLogicBoService.dataLogicFilterListByLogicIds(Arrays.asList(dataLogicNo.getId()));
        if (HussarUtils.isNotEmpty((Object)dataLogicFilters)) {
            ArrayList<CustomDataCondition.DataLogic.Filter> filters = new ArrayList<CustomDataCondition.DataLogic.Filter>(dataLogicFilters.size());
            for (SysAppVisitDataLogicFilter dataLogicFilter : dataLogicFilters) {
                CustomDataCondition.DataLogic.Filter filter = new CustomDataCondition.DataLogic.Filter();
                filter.setFieldId(dataLogicFilter.getFieldId());
                filter.setFieldName(dataLogicFilter.getFieldName());
                filter.setFilterConditionCode(dataLogicFilter.getFilterConditionCode());
                filter.setFilterConditionName(dataLogicFilter.getFilterConditionName());
                filter.setFilterValue(dataLogicFilter.getFilterValue());
                filters.add(filter);
            }
            dataLogicLow.setFilters(filters);
        }
        return dataLogicLow;
    }

    private CustomDataCondition.FieldAuthority roleFieldToCustomDataCondition(List<SysAppVisitRoleField> roleFields) {
        CustomDataCondition.FieldAuthority fieldAuthority = new CustomDataCondition.FieldAuthority();
        ArrayList<CustomDataCondition.FieldAuthority.Rule> rules = new ArrayList<CustomDataCondition.FieldAuthority.Rule>(roleFields.size());
        for (SysAppVisitRoleField roleField : roleFields) {
            CustomDataCondition.FieldAuthority.Rule rule = new CustomDataCondition.FieldAuthority.Rule();
            rule.setRoleFieldId(roleField.getId());
            rule.setFieldId(roleField.getFieldId());
            rule.setFieldName(roleField.getFieldName());
            rule.setCanRead(roleField.getCanRead());
            rule.setCanWrite(roleField.getCanWrite());
            rule.setParentId(roleField.getParentId());
            rules.add(rule);
        }
        fieldAuthority.setRules(rules);
        return fieldAuthority;
    }

    public Long getMenuFunId(Long formId) {
        String eleCode = "menu_" + formId;
        SysFunctions function = this.functionsBoService.getOneByCode(eleCode);
        return HussarUtils.isNotEmpty((Object)function) ? function.getId() : null;
    }

    public SysFunctions systemButtonToFunction(Button systemButton, Long formId, Long appId) {
        SysFunctions fun = new SysFunctions();
        fun.setFunctionCode("element_" + formId + "_" + systemButton.getButtonCode());
        fun.setFunctionModuleId(formId);
        fun.setAppId(appId);
        fun.setFunctionName(systemButton.getButtonName());
        fun.setSeq(this.sysFunctionsBoService.getMaxOrderByParentId(formId));
        fun.setFunSource("noCode");
        return fun;
    }

    public SysResources systemButtonToResource(Button systemButton, Long formId, Long appId) {
        SysResources pageRes = this.hussarBaseResourceService.getResourcesByCode("menu_" + formId);
        SysResources elementRes = new SysResources();
        elementRes.setResourceName(systemButton.getButtonName() + "\u6309\u94ae");
        elementRes.setResourceAlias(systemButton.getButtonName() + "\u6309\u94ae");
        elementRes.setModuleId(formId);
        elementRes.setResTypeId("res_element");
        elementRes.setPermissions(systemButton.getButtonCode());
        elementRes.setResourceCode("element_" + formId + "_" + systemButton.getButtonCode());
        elementRes.setParentResourceId(pageRes.getId());
        elementRes.setAppId(appId);
        elementRes.setSeq(this.hussarBaseResourceService.getMaxOrderByParentId(formId));
        elementRes.setResSource("noCode");
        return elementRes;
    }
}

