/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppVisitDto;
import com.jxdinfo.hussar.authorization.permit.dto.UpdateResourceDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleUserRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.AppMenuFuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppVisitVo;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormUpgradeTypEnum;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.UpgradeFormMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.sync.union.dto.ConversionProduct;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUnionConverter;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUnionHelper;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUtil;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.example.sync.appSyncUnionServiceImpl")
public class AppSyncUnionServiceImpl
implements AppSyncService {
    private final Logger logger = LoggerFactory.getLogger(AppSyncUnionServiceImpl.class);
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysFunctionModulesBoService functionModulesBoService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private ISysResourceMosulesBoService resourceMosulesBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysFunctionResourcesBoService functionResourcesBoService;
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private ISysMenuManageBoService menuBoService;
    @Resource
    private ISysRoleStruRightBoService roleStruRightBoService;
    @Resource
    private ISysRoleUserRightBoService roleUserRightBoService;
    @Resource
    private SyncUnionHelper syncHelper;
    @Resource
    private SyncUnionConverter syncUnionConverter;
    private static final Integer FORM_ORDER = 999;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSyncUnionServiceImpl.class);

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncApp(String type, SysApplication app) {
        switch (type) {
            case "add": {
                this.addApp(app);
                break;
            }
            case "edit": {
                this.editApp(app);
                break;
            }
            case "del": {
                this.delApp(app);
                break;
            }
            case "clean": {
                this.cleanAppData(app);
                break;
            }
            default: {
                throw new HussarException("\u5e94\u7528\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addApp(SysApplication app) {
        this.saveConversionProduct(this.syncUnionConverter.appToModule(app, null));
    }

    private void editApp(SysApplication app) {
        if (HussarUtils.isNotEmpty((Object)app.getAppName())) {
            String langKey = this.syncUnionConverter.getI18Keys(app.getI18nKeys());
            UpdateResourceDto updateResourceDto = new UpdateResourceDto(app.getId(), app.getAppName(), langKey);
            this.functionModulesBoService.updateNameById(updateResourceDto);
            this.resourceMosulesBoService.updateNameById(updateResourceDto);
        }
        this.menuBoService.updateMenu(this.syncUnionConverter.appToMenu(app));
    }

    private void delApp(SysApplication app) {
        Long appId = app.getId();
        if (appId == null) {
            this.logger.info("\u63d0\u793a\uff1a\u5220\u9664\u5e94\u7528\u65f6\u5220\u9664\u529f\u80fd\u8d44\u6e90\uff0c\u5e94\u7528id\u4e3anull, \u5e94\u7528\u540d\uff1a{}", (Object)app.getAppName());
            return;
        }
        this.menuBoService.flagDelApp(appId);
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
    }

    private void cleanAppData(SysApplication app) {
        Long appId = app.getId();
        List<Long> formGroupIds = this.syncHelper.listFormGroupIds(appId);
        List<Long> formIds = this.syncHelper.getAllFormId(appId);
        List<Long> menuFunIdsByApp = this.syncHelper.listMenuFunIdsByApp(appId);
        ArrayList<Long> moduleIds = new ArrayList<Long>();
        moduleIds.add(app.getId());
        moduleIds.addAll(formGroupIds);
        moduleIds.addAll(formIds);
        if (HussarUtils.isNotEmpty(moduleIds)) {
            this.functionModulesBoService.deleteByIds(moduleIds);
            this.resourceMosulesBoService.deleteResourceModulesByIds(moduleIds);
        }
        List<Long> funIds = this.syncHelper.listFunIdsByApp(appId);
        List<Long> resIds = this.syncHelper.listResIdsByApp(appId);
        if (HussarUtils.isNotEmpty(funIds)) {
            this.functionsBoService.deleteByid(funIds);
            this.hussarBaseResourceService.deleteResourcesByIds(resIds);
            this.rolesExternalService.delRoleFunByFunIds(funIds);
            this.rolesExternalService.delRoleResByResIds(resIds);
            this.functionResourcesBoService.deleteByFunAndResId(funIds, resIds);
            this.rolesExternalService.delRoleRightByFunIds(funIds);
        }
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncFormGroup(String type, SysFormGroup formGroup) {
        switch (type) {
            case "add": {
                this.addFormGroup(formGroup);
                break;
            }
            case "edit": {
                this.editFormGroup(formGroup);
                break;
            }
            case "del": {
                this.delFormGroup(formGroup);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u5206\u7ec4\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    @HussarTransactional
    public void syncSaveFormGroupBatch(List<SysFormGroup> formGroupList) {
        if (HussarUtils.isNotEmpty(formGroupList)) {
            ConversionProduct conversionProduct = new ConversionProduct();
            for (SysFormGroup sysFormGroup : formGroupList) {
                this.syncUnionConverter.formGroupToModule(sysFormGroup, conversionProduct);
            }
            this.saveConversionProduct(conversionProduct);
        }
    }

    private void addFormGroup(SysFormGroup formGroup) {
        this.saveConversionProduct(this.syncUnionConverter.formGroupToModule(formGroup, null));
    }

    private void editFormGroup(SysFormGroup formGroup) {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(formGroup.getId());
        sysMenu.setParentId(formGroup.getAppId());
        sysMenu.setSeq(formGroup.getSeq());
        if (HussarUtils.isNotEmpty((Object)formGroup.getGroupIcon())) {
            if (HussarUtils.equals((Object)"2", (Object)formGroup.getGroupIconType())) {
                sysMenu.setIcons("caidan_folder_close");
            } else {
                sysMenu.setIcons(formGroup.getGroupIcon());
            }
        }
        if (HussarUtils.isNotEmpty((Object)formGroup.getGroupName())) {
            String langKey = this.syncUnionConverter.getI18Keys(formGroup.getI18nKeys());
            UpdateResourceDto updateResourceDto = new UpdateResourceDto(formGroup.getId(), formGroup.getGroupName(), langKey);
            this.functionModulesBoService.updateNameById(updateResourceDto);
            this.resourceMosulesBoService.updateNameById(updateResourceDto);
            sysMenu.setText(formGroup.getGroupName());
            sysMenu.setMenuAlias(formGroup.getGroupName());
            String i18Keys = this.syncUnionConverter.getI18Keys(formGroup.getI18nKeys());
            sysMenu.setTextLangKey(i18Keys);
            sysMenu.setAliasLangKey(i18Keys);
        }
        this.menuBoService.updateMenu(sysMenu);
    }

    private void delFormGroup(SysFormGroup formGroup) {
        this.functionModulesBoService.deleteById(formGroup.getId());
        this.resourceMosulesBoService.deleteOneResourceModulesById(formGroup.getId());
        this.menuBoService.deleteMenus(formGroup.getId().toString());
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncForm(String type, SysForm form) {
        switch (type) {
            case "add": {
                this.addForm(form);
                break;
            }
            case "edit": {
                this.editForm(form);
                break;
            }
            case "del": {
                this.delForm(form);
                break;
            }
            case "sort": {
                this.sortForm(form);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void sortForm(SysForm form) {
        boolean haveGroup = HussarUtils.isNotEmpty((Object)form.getFormGroupId());
        Long appId = HussarUtils.isNotEmpty((Object)form.getAppId()) ? form.getAppId() : ((SysForm)this.formService.getById((Serializable)form.getId())).getAppId();
        Long moduleId = haveGroup ? form.getFormGroupId() : appId;
        this.functionModulesBoService.updateParentAndNameById(form.getId(), moduleId, null);
        this.resourceMosulesBoService.updateParentAndNameById(form.getId(), moduleId, null);
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(form.getId());
        sysMenu.setParentId(moduleId);
        sysMenu.setSeq(Integer.valueOf(FORM_ORDER + form.getSeq()));
        this.menuBoService.updateMenu(sysMenu);
    }

    private void addForm(SysForm form) {
        ConversionProduct conversionProduct = new ConversionProduct();
        this.syncUnionConverter.formToModule(form, conversionProduct);
        Map<String, Long> idMap = this.syncUnionConverter.formToMenuRes(form, conversionProduct);
        Long funId = idMap.get("funId");
        Long resId = idMap.get("resId");
        SysMenu sysMenu = this.syncUnionConverter.formToMenu(form);
        sysMenu.setFunctionId(funId);
        conversionProduct.getMenuList().add(sysMenu);
        if (this.ordinaryOrFlow(form)) {
            this.syncUnionConverter.formToElementRes(form, resId, conversionProduct);
            this.syncUnionConverter.formToDataRes(form, conversionProduct);
        }
        this.syncUnionConverter.authFormForAppDevRole(form.getAppId(), conversionProduct);
        this.saveConversionProduct(conversionProduct);
    }

    private void editForm(SysForm form) {
        boolean haveGroup = HussarUtils.isNotEmpty((Object)form.getFormGroupId());
        Long appId = HussarUtils.isNotEmpty((Object)form.getAppId()) ? form.getAppId() : ((SysForm)this.formService.getById((Serializable)form.getId())).getAppId();
        Long moduleId = haveGroup ? form.getFormGroupId() : appId;
        this.functionModulesBoService.updateParentAndNameById(form.getId(), moduleId, null);
        this.resourceMosulesBoService.updateParentAndNameById(form.getId(), moduleId, null);
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(form.getId());
        sysMenu.setParentId(moduleId);
        sysMenu.setOpenMode("0");
        if (HussarUtils.isNotEmpty((Object)form.getFormIcon())) {
            sysMenu.setIcons(form.getFormIcon());
        }
        if (HussarUtils.isNotEmpty((Object)form.getHidden()) && form.getHidden().contains("pc")) {
            sysMenu.setIfDisplay("0");
        } else {
            sysMenu.setIfDisplay("1");
        }
        if (HussarUtils.isNotEmpty((Object)form.getFormName())) {
            String langKey = this.syncUnionConverter.getI18Keys(form.getI18nKeys());
            UpdateResourceDto updateResourceDto = new UpdateResourceDto(form.getId(), form.getFormName(), langKey);
            this.functionModulesBoService.updateNameById(updateResourceDto);
            this.resourceMosulesBoService.updateNameById(updateResourceDto);
            updateResourceDto.setCode("menu_" + form.getId());
            this.functionsBoService.updateNameByCode(updateResourceDto);
            updateResourceDto.setAlias(form.getFormName());
            this.hussarBaseResourceService.updateNameAliasByCode(updateResourceDto);
            sysMenu.setText(form.getFormName());
            sysMenu.setMenuAlias(form.getFormName());
            sysMenu.setTextLangKey(langKey);
            sysMenu.setAliasLangKey(langKey);
            HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
        }
        this.menuBoService.updateMenu(sysMenu);
    }

    private void delForm(SysForm form) {
        Long formId = form.getId();
        Long menuFunId = this.syncHelper.getMenuFunId(formId);
        List<Long> allFunIdsByForm = this.syncHelper.listFunIdsByForm(formId);
        List<Long> allResIdsByForm = this.syncHelper.listResIdsByForm(formId);
        this.functionModulesBoService.deleteById(formId);
        this.resourceMosulesBoService.deleteOneResourceModulesById(formId);
        this.functionsBoService.deleteByid(allFunIdsByForm);
        this.hussarBaseResourceService.deleteResourcesByIds(allResIdsByForm);
        if (HussarUtils.isNotEmpty(allFunIdsByForm) && HussarUtils.isNotEmpty(allResIdsByForm)) {
            this.functionResourcesBoService.deleteByFunAndResId(allFunIdsByForm, allResIdsByForm);
        }
        if (HussarUtils.isNotEmpty(allFunIdsByForm)) {
            this.rolesExternalService.delRoleFunByFunIds(allFunIdsByForm);
        }
        if (HussarUtils.isNotEmpty(allResIdsByForm)) {
            this.rolesExternalService.delRoleResByResIds(allResIdsByForm);
        }
        if (HussarUtils.isNotEmpty((Object)menuFunId)) {
            this.menuBoService.delByFunId(Collections.singletonList(menuFunId));
            HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
        }
        HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncCustomButton(String type, SysCustomButton sysCustomButton) {
        switch (type) {
            case "add": {
                this.addCustomButton(sysCustomButton);
                break;
            }
            case "edit": {
                this.editCustomButton(sysCustomButton);
                break;
            }
            case "del": {
                this.delCustomButton(sysCustomButton);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addCustomButton(SysCustomButton sysCustomButton) {
        Long formId = sysCustomButton.getFormId();
        String buttonCode = sysCustomButton.getAction();
        String buttonAlias = sysCustomButton.getAlias();
        String buttonName = sysCustomButton.getName();
        String langKey = this.syncUnionConverter.getI18Keys(sysCustomButton.getI18nKeys());
        SysFunctions fun = new SysFunctions();
        fun.setId(sysCustomButton.getId());
        fun.setFunctionCode("element_" + formId + "_" + buttonCode);
        fun.setFunctionModuleId(formId);
        fun.setFunctionName(buttonName);
        fun.setSeq(Integer.valueOf(this.functionsBoService.getMaxOrderByParentId(formId) + 1));
        fun.setAppId(sysCustomButton.getAppId());
        fun.setNameLangKey(langKey);
        fun.setFunSource("noCode");
        this.functionsBoService.saveOneFunctions(fun);
        SysResources pageRes = this.hussarBaseResourceService.getResourcesByCode("menu_" + formId);
        SysResources customButtonRes = new SysResources();
        customButtonRes.setId(sysCustomButton.getId());
        customButtonRes.setResourceName(buttonName);
        customButtonRes.setResourceAlias(buttonAlias);
        customButtonRes.setModuleId(formId);
        customButtonRes.setResTypeId("res_element");
        customButtonRes.setPermissions(buttonCode);
        customButtonRes.setResourceCode("element_" + formId + "_" + buttonCode);
        customButtonRes.setParentResourceId(pageRes.getId());
        customButtonRes.setSeq(Integer.valueOf(this.hussarBaseResourceService.getMaxOrderByParentId(formId) + 1));
        customButtonRes.setAppId(sysCustomButton.getAppId());
        customButtonRes.setNameLangKey(langKey);
        customButtonRes.setAliasLangKey(langKey);
        customButtonRes.setResSource("noCode");
        this.hussarBaseResourceService.saveOneResource(customButtonRes);
        SysFunctionResources funRes = new SysFunctionResources();
        funRes.setFunctionId(fun.getId());
        funRes.setResourceId(customButtonRes.getId());
        this.functionResourcesBoService.saveOneFunRes(funRes);
        Long appDevRoleId = this.syncHelper.getAppDevRoleId(sysCustomButton.getAppId());
        this.syncHelper.saveRoleFun(appDevRoleId, fun.getId());
        this.syncHelper.saveRoleRes(appDevRoleId, customButtonRes.getId());
    }

    private void editCustomButton(SysCustomButton sysCustomButton) {
        String langKey = this.syncUnionConverter.getI18Keys(sysCustomButton.getI18nKeys());
        UpdateResourceDto updateResourceDto = new UpdateResourceDto(sysCustomButton.getId(), sysCustomButton.getAlias(), langKey);
        this.functionsBoService.updateNameById(updateResourceDto);
        updateResourceDto.setAlias(sysCustomButton.getAlias());
        this.hussarBaseResourceService.updateNameAliasById(updateResourceDto);
    }

    private void delCustomButton(SysCustomButton sysCustomButton) {
        Long buttonId = sysCustomButton.getId();
        this.functionsBoService.deleteOneById(buttonId);
        this.hussarBaseResourceService.deleteOneResourcesById(buttonId);
        if (HussarUtils.isNotEmpty((Object)buttonId)) {
            this.functionsBoService.deleteOneById(buttonId);
            this.hussarBaseResourceService.deleteOneResourcesById(buttonId);
            this.functionResourcesBoService.deleteByFunAndResId(Collections.singletonList(buttonId), Collections.singletonList(buttonId));
            this.rolesExternalService.delRoleFunByFunIds(Collections.singletonList(buttonId));
            this.rolesExternalService.delRoleResByResIds(Collections.singletonList(buttonId));
        }
    }

    private void syncDataRes(SysForm form) {
        Long menuFunId = this.syncHelper.getMenuFunId(form.getId());
        List<SysResources> dataResources = this.syncUnionConverter.dataResToResource(form);
        if (HussarUtils.isNotEmpty(dataResources)) {
            this.hussarBaseResourceService.saveBatchResource(dataResources);
            dataResources.forEach(dataResource -> this.syncHelper.saveFunRes(menuFunId, dataResource.getId()));
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importApp(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        if (this.checkAppPackage(appImportDto).booleanValue()) {
            this.syncMenuFuncResInfo(appImportDto, importMappingDto);
        } else {
            this.syncAppCompatible(appImportDto, importMappingDto);
        }
    }

    private void syncAppCompatible(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        ConversionProduct conversionProduct = new ConversionProduct();
        this.initAppFormBaseInfo(importMappingDto, conversionProduct);
        if (appImportDto.getExportRoleFlag()) {
            this.initFormAuthToRelation(appImportDto, importMappingDto, conversionProduct);
            JSONObject formAuthData = AppMigrateUtil.readData(appImportDto.getPath(), "formAuth", JSONObject.class);
            if (HussarUtils.isNotEmpty((Object)formAuthData)) {
                this.initButtonAuthToRelation(importMappingDto, formAuthData, conversionProduct);
                this.initOrganDataToDataRight(importMappingDto, formAuthData, conversionProduct);
            }
        }
        this.syncUnionConverter.authFormForAppDevRole(importMappingDto.getNewAppId(), conversionProduct);
        this.saveConversionProduct(conversionProduct);
    }

    private void initOrganDataToDataRight(ImportMappingDto importMappingDto, JSONObject formAuthData, ConversionProduct conversionProduct) {
        List importOrganDataAuthorities;
        List organDataAuthorities = JSON.parseArray((String)formAuthData.getString("organAuth"), SysAppVisitRoleOrganDataAuthority.class);
        if (HussarUtils.isNotEmpty((Object)organDataAuthorities) && HussarUtils.isNotEmpty(importOrganDataAuthorities = organDataAuthorities.stream().filter(dataAuth -> "1".equals(dataAuth.getOnlyIndividuals()) || "1".equals(dataAuth.getOnlySupOrgan()) || "1".equals(dataAuth.getAllOrgan())).collect(Collectors.toList()))) {
            for (SysAppVisitRoleOrganDataAuthority organAuth : importOrganDataAuthorities) {
                if (importMappingDto.getRoleIdMap().containsKey(organAuth.getRoleId())) {
                    organAuth.setRoleId((Long)importMappingDto.getRoleIdMap().get(organAuth.getRoleId()));
                }
                organAuth.setFormId((Long)importMappingDto.getFormIdMap().get(organAuth.getFormId()));
                this.syncUnionConverter.roleOrganDataAuthToDataRight(organAuth, conversionProduct);
            }
        }
    }

    private void initButtonAuthToRelation(ImportMappingDto importMappingDto, JSONObject formAuthData, ConversionProduct conversionProduct) {
        List buttonAuths = JSON.parseArray((String)formAuthData.getString("buttonAuth"), SysAppVisitRoleButton.class);
        if (HussarUtils.isNotEmpty((Object)buttonAuths)) {
            for (SysAppVisitRoleButton buttonAuth : buttonAuths) {
                if (importMappingDto.getRoleIdMap().containsKey(buttonAuth.getRoleId())) {
                    buttonAuth.setRoleId((Long)importMappingDto.getRoleIdMap().get(buttonAuth.getRoleId()));
                }
                buttonAuth.setFormId((Long)importMappingDto.getFormIdMap().get(buttonAuth.getFormId()));
                this.syncUnionConverter.buttonAuthToRelation(buttonAuth, conversionProduct);
            }
        }
    }

    private void initFormAuthToRelation(AppImportDto appImportDto, ImportMappingDto importMappingDto, ConversionProduct conversionProduct) {
        String formFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "form.json"});
        JSONObject formData = AppMigrateUtil.readFileToObject(formFilePath, JSONObject.class);
        List formAuths = JSON.parseArray((String)formData.getString("formAuth"), SysAppVisitFormAuthorizeRoles.class);
        if (HussarUtils.isNotEmpty((Object)formAuths)) {
            for (SysAppVisitFormAuthorizeRoles formAuth : formAuths) {
                if (importMappingDto.getRoleIdMap().containsKey(formAuth.getRoleId())) {
                    formAuth.setRoleId((Long)importMappingDto.getRoleIdMap().get(formAuth.getRoleId()));
                }
                formAuth.setFormId((Long)importMappingDto.getFormIdMap().get(formAuth.getFormId()));
                this.syncUnionConverter.formAuthToRelation(formAuth, conversionProduct);
            }
        }
    }

    private void initAppFormBaseInfo(ImportMappingDto importMappingDto, ConversionProduct conversionProduct) {
        List<SysForm> allForm;
        Long newAppId = importMappingDto.getNewAppId();
        SysApplication application = this.sysApplicationBoService.selectById(newAppId);
        this.syncUnionConverter.appToModule(application, conversionProduct);
        List<SysFormGroup> formGroups = this.syncHelper.getFormGroups(newAppId);
        if (HussarUtils.isNotEmpty(formGroups)) {
            for (SysFormGroup formGroup : formGroups) {
                this.syncUnionConverter.formGroupToModule(formGroup, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(allForm = this.syncHelper.getAllForm(newAppId))) {
            for (SysForm form : allForm) {
                this.syncUnionConverter.formToModule(form, conversionProduct);
                this.syncUnionConverter.formToMenuRes(form, conversionProduct);
                Long resId = conversionProduct.getMenuResIdMap().get(form.getId());
                Long funId = conversionProduct.getMenuFunIdMap().get(form.getId());
                SysMenu sysMenu = this.syncUnionConverter.formToMenu(form);
                sysMenu.setFunctionId(funId);
                conversionProduct.getMenuList().add(sysMenu);
                if (!this.ordinaryOrFlow(form)) continue;
                this.syncUnionConverter.formToElementRes(form, resId, conversionProduct);
                this.syncUnionConverter.formToDataRes(form, conversionProduct);
            }
        }
    }

    private Boolean checkAppPackage(AppImportDto appImportDto) {
        String menuFuncResPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "menuFuncRes.json"});
        JSONObject menuFuncResData = AppMigrateUtil.readFileToObject(menuFuncResPath, JSONObject.class);
        return HussarUtils.isNotEmpty((Object)menuFuncResData);
    }

    private void syncMenuFuncResInfo(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        ConversionProduct conversionProduct = new ConversionProduct();
        HashMap<Long, Long> resIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> funcIdMap = new HashMap<Long, Long>();
        String menuFuncResPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "menuFuncRes.json"});
        JSONObject menuFuncResData = AppMigrateUtil.readFileToObject(menuFuncResPath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)menuFuncResData)) {
            this.initResourceInfo(importMappingDto, menuFuncResData, conversionProduct, resIdMap);
            this.initResourceModuleInfo(appImportDto, importMappingDto, menuFuncResData, conversionProduct);
            this.initFunctionInfo(importMappingDto, menuFuncResData, conversionProduct, resIdMap, funcIdMap);
            this.initFunctionModuleInfo(appImportDto, importMappingDto, menuFuncResData, conversionProduct);
            JSONArray funcResRelationArray = (JSONArray)menuFuncResData.getObject("funcResRelations", JSONArray.class);
            List<SysFunctionResources> funcResRelations = AppMigrateUtil.parseJsonArrayToList(funcResRelationArray, SysFunctionResources.class);
            AppSyncUnionServiceImpl.initFuncResRelation(funcResRelations, conversionProduct, funcIdMap, resIdMap);
            this.initMenuInfo(appImportDto, importMappingDto, menuFuncResData, funcIdMap, conversionProduct);
        }
        this.initDataAuthVisit(appImportDto, importMappingDto, conversionProduct, resIdMap, funcIdMap);
        this.syncUnionConverter.authFormForAppDevRole(importMappingDto.getNewAppId(), conversionProduct);
        this.saveConversionProduct(conversionProduct);
    }

    private void initMenuInfo(AppImportDto appImportDto, ImportMappingDto importMappingDto, JSONObject menuFuncResData, Map<Long, Long> funcIdMap, ConversionProduct conversionProduct) {
        ArrayList<SysMenu> result = new ArrayList<SysMenu>();
        Long newAppId = importMappingDto.getNewAppId();
        Map formIdMap = importMappingDto.getFormIdMap();
        Map formGroupMap = importMappingDto.getFormGroupMap();
        Map formTypeMap = importMappingDto.getFormTypeMap();
        JSONArray menuArray = (JSONArray)menuFuncResData.getObject("menus", JSONArray.class);
        List<SysMenu> menus = AppMigrateUtil.parseJsonArrayToList(menuArray, SysMenu.class);
        if (HussarUtils.isNotEmpty(menus)) {
            for (SysMenu menu : menus) {
                Long oldMenuId = menu.getId();
                if (oldMenuId.equals(importMappingDto.getOldAppId())) {
                    menu.setId(newAppId);
                } else if (HussarUtils.isNotEmpty(formIdMap.get(oldMenuId))) {
                    menu.setId((Long)formIdMap.get(oldMenuId));
                } else {
                    if (!HussarUtils.isNotEmpty(formGroupMap.get(oldMenuId))) continue;
                    menu.setId((Long)formGroupMap.get(oldMenuId));
                }
                Long oldParentId = menu.getParentId();
                if (oldParentId != 4L) {
                    if (oldParentId.equals(importMappingDto.getOldAppId())) {
                        menu.setParentId(newAppId);
                    } else {
                        menu.setParentId((Long)formGroupMap.get(oldParentId));
                    }
                }
                if (HussarUtils.equals((Object)menu.getId(), (Object)newAppId)) {
                    menu.setText(appImportDto.getAppName());
                    menu.setMenuAlias(appImportDto.getAppName());
                }
                if ("1".equals(menu.getIsLeaf())) {
                    menu.setFunctionId(funcIdMap.get(menu.getFunctionId()));
                    SysForm form = new SysForm();
                    form.setId(menu.getId());
                    form.setAppId(newAppId);
                    form.setFormType((String)formTypeMap.get(menu.getId()));
                    menu.setPath(SyncUtil.asmResPath(form));
                    menu.setComponent(SyncUtil.asmResComponent(form));
                }
                result.add(menu);
            }
        }
        conversionProduct.setMenuList(result);
    }

    private void initResourceInfo(ImportMappingDto importMappingDto, JSONObject menuFuncResData, ConversionProduct conversionProduct, Map<Long, Long> resIdMap) {
        Map formIdMap = importMappingDto.getFormIdMap();
        Map formTypeMap = importMappingDto.getFormTypeMap();
        Long newAppId = importMappingDto.getNewAppId();
        JSONArray resourceArray = (JSONArray)menuFuncResData.getObject("resources", JSONArray.class);
        List<SysResources> resources = AppMigrateUtil.parseJsonArrayToList(resourceArray, SysResources.class);
        ArrayList<SysResources> openInterfaceResources = new ArrayList<SysResources>();
        if (HussarUtils.isNotEmpty(resources)) {
            for (SysResources resource : resources) {
                Long newMenuResId;
                Long newFormId = (Long)formIdMap.get(resource.getModuleId());
                if ("res_menu".equals(resource.getResTypeId())) {
                    newMenuResId = resIdMap.get(resource.getParentResourceId());
                    if (HussarUtils.isEmpty((Object)newMenuResId)) {
                        newMenuResId = IdWorker.getId((Object)new SysResources());
                        resIdMap.put(resource.getId(), newMenuResId);
                    }
                    resource.setId(newMenuResId);
                    SysForm form = new SysForm();
                    form.setId(newFormId);
                    form.setAppId(newAppId);
                    form.setFormType((String)formTypeMap.get(newFormId));
                    resource.setPath(SyncUtil.asmResPath(form));
                    resource.setComponent(SyncUtil.asmResComponent(form));
                    resource.setResourceCode("menu_" + newFormId);
                    resource.setKeepAlive("1");
                } else if ("res_open_interface".equals(resource.getResTypeId())) {
                    openInterfaceResources.add(resource);
                } else {
                    Long id = IdWorker.getId((Object)resource);
                    resIdMap.put(resource.getId(), id);
                    resource.setId(id);
                }
                if ("res_element".equals(resource.getResTypeId())) {
                    newMenuResId = resIdMap.get(resource.getParentResourceId());
                    if (HussarUtils.isEmpty((Object)newMenuResId)) {
                        newMenuResId = IdWorker.getId((Object)new SysResources());
                        resIdMap.put(resource.getParentResourceId(), newMenuResId);
                    }
                    resource.setParentResourceId(newMenuResId);
                    resource.setResourceCode("element_" + newFormId + "_" + resource.getPermissions());
                }
                if ("res_form_rights".equals(resource.getResTypeId())) {
                    String mapper = resource.getMapper();
                    resource.setResourceCode(newFormId + "_" + "res_form_rights" + "_" + SyncUtil.subNodeNameType(mapper));
                    resource.setMapper("POST." + newAppId + "." + newFormId + "." + SyncUtil.subNodeNameType(mapper));
                }
                resource.setAppId(newAppId);
                resource.setModuleId(newFormId);
            }
            resources.removeAll(openInterfaceResources);
        }
        conversionProduct.setResourceList(resources);
    }

    private void initResourceModuleInfo(AppImportDto appImportDto, ImportMappingDto importMappingDto, JSONObject menuFuncResData, ConversionProduct conversionProduct) {
        ArrayList<SysResourceModules> result = new ArrayList<SysResourceModules>();
        Map formIdMap = importMappingDto.getFormIdMap();
        Map formGroupMap = importMappingDto.getFormGroupMap();
        Long newAppId = importMappingDto.getNewAppId();
        JSONArray resModuleArray = (JSONArray)menuFuncResData.getObject("resModules", JSONArray.class);
        List<SysResourceModules> resModules = AppMigrateUtil.parseJsonArrayToList(resModuleArray, SysResourceModules.class);
        if (HussarUtils.isNotEmpty(resModules)) {
            for (SysResourceModules module : resModules) {
                Long oldModuleId = module.getId();
                if (oldModuleId.equals(importMappingDto.getOldAppId())) {
                    module.setId(newAppId);
                } else if (HussarUtils.isNotEmpty(formIdMap.get(oldModuleId))) {
                    module.setId((Long)formIdMap.get(oldModuleId));
                } else {
                    if (!HussarUtils.isNotEmpty(formGroupMap.get(oldModuleId))) continue;
                    module.setId((Long)formGroupMap.get(oldModuleId));
                }
                Long oldParentId = module.getParentModuleId();
                if (oldParentId != 4L) {
                    if (oldParentId.equals(importMappingDto.getOldAppId())) {
                        module.setParentModuleId(newAppId);
                    } else {
                        module.setParentModuleId((Long)formGroupMap.get(oldParentId));
                    }
                }
                if (HussarUtils.equals((Object)module.getId(), (Object)newAppId)) {
                    module.setModuleName(appImportDto.getAppName());
                }
                module.setModuleCode(String.valueOf(module.getId()));
                module.setAppId(importMappingDto.getNewAppId());
                module.setResModSource("noCode");
                result.add(module);
            }
        }
        conversionProduct.setResourceModulesList(result);
    }

    private void initFunctionInfo(ImportMappingDto importMappingDto, JSONObject menuFuncResData, ConversionProduct conversionProduct, Map<Long, Long> resIdMap, Map<Long, Long> funcIdMap) {
        Map formIdMap = importMappingDto.getFormIdMap();
        Long newAppId = importMappingDto.getNewAppId();
        JSONArray functionArray = (JSONArray)menuFuncResData.getObject("functions", JSONArray.class);
        List<SysFunctions> functions = AppMigrateUtil.parseJsonArrayToList(functionArray, SysFunctions.class);
        if (HussarUtils.isNotEmpty(functions)) {
            for (SysFunctions function : functions) {
                Long newFormId = (Long)formIdMap.get(function.getFunctionModuleId());
                String oldCode = function.getFunctionCode();
                if (oldCode.contains("menu_")) {
                    Long newMenuResId = resIdMap.get(function.getDefaultResourceId());
                    function.setDefaultResourceId(newMenuResId);
                    function.setFunctionCode("menu_" + newFormId);
                } else {
                    String button = function.getFunctionCode().substring(function.getFunctionCode().lastIndexOf("_"));
                    function.setFunctionCode("element_" + newFormId + button);
                }
                Long id = IdWorker.getId((Object)function);
                funcIdMap.put(function.getId(), id);
                function.setId(id);
                function.setAppId(newAppId);
                function.setFunctionModuleId(newFormId);
            }
        }
        conversionProduct.setFunctionList(functions);
    }

    private void initFunctionModuleInfo(AppImportDto appImportDto, ImportMappingDto importMappingDto, JSONObject menuFuncResData, ConversionProduct conversionProduct) {
        ArrayList<SysFunctionModules> result = new ArrayList<SysFunctionModules>();
        Map formIdMap = importMappingDto.getFormIdMap();
        Map formGroupMap = importMappingDto.getFormGroupMap();
        Long newAppId = importMappingDto.getNewAppId();
        JSONArray funcModuleArray = (JSONArray)menuFuncResData.getObject("funcModules", JSONArray.class);
        List<SysFunctionModules> funcModules = AppMigrateUtil.parseJsonArrayToList(funcModuleArray, SysFunctionModules.class);
        if (HussarUtils.isNotEmpty(funcModules)) {
            for (SysFunctionModules module : funcModules) {
                Long oldModuleId = module.getId();
                if (oldModuleId.equals(importMappingDto.getOldAppId())) {
                    module.setId(newAppId);
                } else if (HussarUtils.isNotEmpty(formIdMap.get(oldModuleId))) {
                    module.setId((Long)formIdMap.get(oldModuleId));
                } else {
                    if (!HussarUtils.isNotEmpty(formGroupMap.get(oldModuleId))) continue;
                    module.setId((Long)formGroupMap.get(oldModuleId));
                }
                Long oldParentId = module.getParentModuleId();
                if (oldParentId != 4L) {
                    if (oldParentId.equals(importMappingDto.getOldAppId())) {
                        module.setParentModuleId(newAppId);
                    } else {
                        module.setParentModuleId((Long)formGroupMap.get(oldParentId));
                    }
                }
                if (HussarUtils.equals((Object)module.getId(), (Object)newAppId)) {
                    module.setFunctionModuleName(appImportDto.getAppName());
                }
                module.setFunctionModuleCode(String.valueOf(module.getId()));
                module.setAppId(importMappingDto.getNewAppId());
                module.setFunModSource("noCode");
                result.add(module);
            }
        }
        conversionProduct.setFunctionModulesList(result);
    }

    private static void initFuncResRelation(List<SysFunctionResources> funcResRelations, ConversionProduct conversionProduct, Map<Long, Long> funcIdMap, Map<Long, Long> resIdMap) {
        ArrayList<SysFunctionResources> newFunctionResourceList = null;
        if (HussarUtils.isNotEmpty(funcResRelations)) {
            newFunctionResourceList = new ArrayList<SysFunctionResources>(funcResRelations.size());
            for (SysFunctionResources relation : funcResRelations) {
                if (!HussarUtils.isNotEmpty((Object)funcIdMap.get(relation.getFunctionId())) || !HussarUtils.isNotEmpty((Object)resIdMap.get(relation.getResourceId()))) continue;
                relation.setId(null);
                relation.setFunctionId(funcIdMap.get(relation.getFunctionId()));
                relation.setResourceId(resIdMap.get(relation.getResourceId()));
                newFunctionResourceList.add(relation);
            }
        }
        conversionProduct.setFunctionResourceList(newFunctionResourceList);
    }

    private static void upgradeFuncResRelation(List<SysFunctionResources> funcResRelations, ConversionProduct conversionProduct, Map<Long, Long> funcIdMap, Map<Long, Long> resIdMap) {
        ArrayList<SysFunctionResources> newfuncResRelations = new ArrayList<SysFunctionResources>();
        if (HussarUtils.isNotEmpty(funcResRelations)) {
            for (SysFunctionResources relation : funcResRelations) {
                if (!HussarUtils.isNotEmpty((Object)funcIdMap.get(relation.getFunctionId())) || !HussarUtils.isNotEmpty((Object)resIdMap.get(relation.getResourceId()))) continue;
                SysFunctionResources relationO = new SysFunctionResources();
                relationO.setId(null);
                relationO.setFunctionId(funcIdMap.get(relation.getFunctionId()));
                relationO.setResourceId(resIdMap.get(relation.getResourceId()));
                newfuncResRelations.add(relationO);
            }
        }
        conversionProduct.setFunctionResourceList(newfuncResRelations);
    }

    private void initDataAuthVisit(AppImportDto appImportDto, ImportMappingDto importMappingDto, ConversionProduct conversionProduct, Map<Long, Long> resIdMap, Map<Long, Long> funcIdMap) {
        if (appImportDto.getExportRoleFlag()) {
            ArrayList<AppVisitVo> allAuthList = new ArrayList<AppVisitVo>();
            this.getFormAuthForPath(appImportDto, allAuthList);
            this.getButtonAndDataRightAuth(appImportDto, allAuthList);
            this.initFuncResDataRightInfo(importMappingDto, conversionProduct, resIdMap, funcIdMap, allAuthList);
        }
    }

    private void initFuncResDataRightInfo(ImportMappingDto importMappingDto, ConversionProduct conversionProduct, Map<Long, Long> resIdMap, Map<Long, Long> funcIdMap, List<AppVisitVo> allAuthList) {
        if (HussarUtils.isNotEmpty(allAuthList)) {
            ArrayList<SysRoleResource> finalRoleResList = new ArrayList<SysRoleResource>();
            ArrayList<SysRoleFunctions> finalRoleFuncList = new ArrayList<SysRoleFunctions>();
            ArrayList<SysRoleDataRight> finalDataRightList = new ArrayList<SysRoleDataRight>();
            Map roleIdMap = importMappingDto.getRoleIdMap();
            for (AppVisitVo appVisitVo : allAuthList) {
                Long roleId = appVisitVo.getRoleId();
                Long newRoleId = (Long)roleIdMap.get(roleId);
                this.initRoleResourceInfo(resIdMap, appVisitVo, newRoleId, finalRoleResList);
                this.initRoleFunctionInfo(funcIdMap, appVisitVo, newRoleId, finalRoleFuncList);
                this.initRoleDataRightInfo(funcIdMap, appVisitVo, newRoleId, finalDataRightList);
            }
            conversionProduct.setRoleResourceList(finalRoleResList);
            conversionProduct.setRoleFunctionList(finalRoleFuncList);
            conversionProduct.setRoleDataRightList(finalDataRightList);
        }
    }

    private void initRoleDataRightInfo(Map<Long, Long> funcIdMap, AppVisitVo appVisitVo, Long newRoleId, List<SysRoleDataRight> finalDataRightList) {
        List roleDataRights = appVisitVo.getRoleDataRights();
        if (HussarUtils.isNotEmpty((Object)roleDataRights)) {
            for (SysRoleDataRight roleDataRight : roleDataRights) {
                Long newId = IdWorker.getId((Object)roleDataRight);
                roleDataRight.setDataRightsId(newId);
                roleDataRight.setRoleId(newRoleId);
                roleDataRight.setFunctionId(funcIdMap.get(roleDataRight.getFunctionId()));
                finalDataRightList.add(roleDataRight);
            }
        }
    }

    private void initRoleFunctionInfo(Map<Long, Long> funcIdMap, AppVisitVo appVisitVo, Long newRoleId, List<SysRoleFunctions> finalRoleFuncList) {
        List roleFunctions = appVisitVo.getRoleFunctions();
        if (HussarUtils.isNotEmpty((Object)roleFunctions)) {
            for (SysRoleFunctions roleFunction : roleFunctions) {
                roleFunction.setId(null);
                roleFunction.setRoleId(newRoleId);
                roleFunction.setFunctionId(funcIdMap.get(roleFunction.getFunctionId()));
                finalRoleFuncList.add(roleFunction);
            }
        }
    }

    private void initRoleResourceInfo(Map<Long, Long> resIdMap, AppVisitVo appVisitVo, Long newRoleId, List<SysRoleResource> finalRoleResList) {
        List roleResources = appVisitVo.getRoleResources();
        if (HussarUtils.isNotEmpty((Object)roleResources)) {
            for (SysRoleResource roleResource : roleResources) {
                roleResource.setId(null);
                roleResource.setRoleId(newRoleId);
                roleResource.setResourceId(resIdMap.get(roleResource.getResourceId()));
                finalRoleResList.add(roleResource);
            }
        }
    }

    private void getButtonAndDataRightAuth(AppImportDto appImportDto, List<AppVisitVo> allAuthList) {
        String formAuthPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "formAuth.json"});
        JSONObject formAuthData = AppMigrateUtil.readFileToObject(formAuthPath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)formAuthData)) {
            JSONArray buttonAuthArray = (JSONArray)formAuthData.getObject("buttonAuth", JSONArray.class);
            List<AppVisitVo> buttonAuthList = AppMigrateUtil.parseJsonArrayToList(buttonAuthArray, AppVisitVo.class);
            allAuthList.addAll(buttonAuthList);
            JSONArray organAuthArray = (JSONArray)formAuthData.getObject("organAuth", JSONArray.class);
            List<AppVisitVo> organAuthList = AppMigrateUtil.parseJsonArrayToList(organAuthArray, AppVisitVo.class);
            allAuthList.addAll(organAuthList);
        }
    }

    private void getFormAuthForPath(AppImportDto appImportDto, List<AppVisitVo> allAuthList) {
        String formPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "form.json"});
        JSONObject formData = AppMigrateUtil.readFileToObject(formPath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)formData)) {
            JSONArray formAuthArray = (JSONArray)formData.getObject("formAuth", JSONArray.class);
            List<AppVisitVo> formAuthList = AppMigrateUtil.parseJsonArrayToList(formAuthArray, AppVisitVo.class);
            allAuthList.addAll(formAuthList);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importAppFail(Long appId) {
        this.menuBoService.deleteRecycleApp(appId);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        if (HussarUtils.isNotEmpty((Object)form)) {
            this.syncForm("add", form);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void upgradeForm(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formUpgradeDto.getId());
        if (HussarUtils.isNotEmpty((Object)form)) {
            if (FormUpgradeTypEnum.COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
                this.syncForm("add", form);
            } else if (FormUpgradeTypEnum.MERGE.getCode().equals(formUpgradeDto.getUpgradeType()) || FormUpgradeTypEnum.HALF_COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
                this.syncForm("edit", form);
                this.upgradeFuncResForForm(upgradeFormMappingDto);
            } else {
                throw new HussarException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b");
            }
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void copyForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        if (HussarUtils.isNotEmpty((Object)form)) {
            this.syncForm("add", form);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void convertForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        Long appId = form.getAppId();
        Long appDevRole = this.syncHelper.getAppDevRoleId(appId);
        if (HussarUtils.isNotEmpty((Object)form)) {
            String formType = form.getFormType();
            if ("1".equals(formType)) {
                SysFunctions batchSubmitFunction = this.syncUnionConverter.systemButtonToFunction(Button.SUBMIT_OPERATE, formId, appId);
                SysFunctions batchRejectFunction = this.syncUnionConverter.systemButtonToFunction(Button.REJECT_OPERATE, formId, appId);
                SysResources batchSubmitResource = this.syncUnionConverter.systemButtonToResource(Button.SUBMIT_OPERATE, formId, appId);
                SysResources batchRejectResource = this.syncUnionConverter.systemButtonToResource(Button.REJECT_OPERATE, formId, appId);
                this.functionsBoService.saveOneFunctions(batchSubmitFunction);
                this.functionsBoService.saveOneFunctions(batchRejectFunction);
                this.hussarBaseResourceService.saveOneResource(batchSubmitResource);
                this.hussarBaseResourceService.saveOneResource(batchRejectResource);
                this.syncHelper.saveFunRes(batchSubmitFunction.getId(), batchSubmitResource.getId());
                this.syncHelper.saveFunRes(batchRejectFunction.getId(), batchRejectResource.getId());
                this.syncHelper.saveRoleFun(appDevRole, batchSubmitFunction.getId());
                this.syncHelper.saveRoleFun(appDevRole, batchRejectFunction.getId());
                this.syncHelper.saveRoleRes(appDevRole, batchSubmitResource.getId());
                this.syncHelper.saveRoleRes(appDevRole, batchRejectResource.getId());
                List<SysAppVisitRoleButton> roleButtonAuthList = this.syncHelper.listButtonAuthByFlowSystemButton(formId);
                if (HussarUtils.isNotEmpty(roleButtonAuthList)) {
                    for (SysAppVisitRoleButton roleButtonAuth : roleButtonAuthList) {
                        Long elementFunctionIdByButtonCode = this.syncHelper.getElementFunctionIdByButtonCode(roleButtonAuth.getFormId(), roleButtonAuth.getButtonCode());
                        Long elementResourceIdByButtonCode = this.syncHelper.getElementResourceIdByButtonCode(roleButtonAuth.getFormId(), roleButtonAuth.getButtonCode());
                        this.syncHelper.saveRoleFun(roleButtonAuth.getRoleId(), elementFunctionIdByButtonCode);
                        this.syncHelper.saveRoleRes(roleButtonAuth.getRoleId(), elementResourceIdByButtonCode);
                    }
                }
            } else {
                ArrayList<Long> elementFunctionIdsByFlowSystemButton = new ArrayList<Long>(Arrays.asList(this.syncHelper.getElementFunctionIdByButtonCode(formId, Button.SUBMIT_OPERATE.getButtonCode()), this.syncHelper.getElementFunctionIdByButtonCode(formId, Button.REJECT_OPERATE.getButtonCode())));
                ArrayList<Long> elementResourceIdsByFlowSystemButton = new ArrayList<Long>(Arrays.asList(this.syncHelper.getElementResourceIdByButtonCode(formId, Button.SUBMIT_OPERATE.getButtonCode()), this.syncHelper.getElementResourceIdByButtonCode(formId, Button.REJECT_OPERATE.getButtonCode())));
                this.functionsBoService.deleteByid(elementFunctionIdsByFlowSystemButton);
                this.hussarBaseResourceService.deleteResourcesByIds(elementResourceIdsByFlowSystemButton);
                this.functionResourcesBoService.deleteByFunAndResId(elementFunctionIdsByFlowSystemButton, elementResourceIdsByFlowSystemButton);
                this.rolesExternalService.delRoleFunByFunIds(elementFunctionIdsByFlowSystemButton);
                this.rolesExternalService.delRoleResByResIds(elementResourceIdsByFlowSystemButton);
            }
            List<Long> dataResIdsByForm = this.syncHelper.listDataResIdByForm(formId);
            if (HussarUtils.isNotEmpty(dataResIdsByForm)) {
                this.hussarBaseResourceService.deleteResourcesByIds(dataResIdsByForm);
                this.functionResourcesBoService.deleteByResId(dataResIdsByForm);
                this.rolesExternalService.delRoleResByResIds(dataResIdsByForm);
            }
            this.syncDataRes(form);
            List<Long> newDataResIdsByForm = this.syncHelper.listDataResIdByForm(formId);
            List roleIds = this.rolesExternalService.listRoleResByResId(this.syncHelper.getMenuResId(formId)).stream().map(SysRoleResource::getRoleId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(roleIds) && HussarUtils.isNotEmpty(newDataResIdsByForm)) {
                for (Long roleId : roleIds) {
                    newDataResIdsByForm.forEach(dataResId -> this.syncHelper.saveRoleRes(roleId, (Long)dataResId));
                }
            }
        }
    }

    public void recycleApp(Long appId) {
        SysApplication application = new SysApplication();
        application.setId(appId);
        this.delApp(application);
        this.menuBoService.recycleApp(appId);
    }

    public void syncHistory(Long appId) {
        List<SysAppVisitRoleButton> allButtonAuth;
        List<SysForm> allForm;
        SysApplication application = this.sysApplicationBoService.selectById(appId);
        if (HussarUtils.isEmpty((Object)application)) {
            return;
        }
        Long startTime = System.currentTimeMillis();
        ConversionProduct conversionProduct = new ConversionProduct();
        this.syncUnionConverter.appToModule(application, conversionProduct);
        List<SysFormGroup> formGroups = this.syncHelper.getFormGroups(appId);
        if (HussarUtils.isNotEmpty(formGroups)) {
            for (SysFormGroup sysFormGroup : formGroups) {
                this.syncUnionConverter.formGroupToModule(sysFormGroup, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(allForm = this.syncHelper.getAllForm(appId))) {
            for (SysForm form : allForm) {
                this.syncUnionConverter.formToModule(form, conversionProduct);
                Map<String, Long> idMap = this.syncUnionConverter.formToMenuRes(form, conversionProduct);
                Long l = (Long)idMap.get("resId");
                Long funId = (Long)idMap.get("funId");
                SysMenu sysMenu = this.syncUnionConverter.formToMenu(form);
                sysMenu.setFunctionId(funId);
                conversionProduct.getMenuList().add(sysMenu);
                if (!this.ordinaryOrFlow(form)) continue;
                this.syncUnionConverter.formToElementRes(form, l, conversionProduct);
                this.syncUnionConverter.formToDataRes(form, conversionProduct);
            }
        }
        List<SysAppVisitFormAuthorizeRoles> list = this.syncHelper.getAllFormAuth(appId);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(list)) {
            for (SysAppVisitFormAuthorizeRoles sysAppVisitFormAuthorizeRoles : list) {
                roleIds.add(sysAppVisitFormAuthorizeRoles.getRoleId());
                this.syncUnionConverter.formAuthToRelation(sysAppVisitFormAuthorizeRoles, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(allButtonAuth = this.syncHelper.getAllButtonAuth(appId))) {
            for (SysAppVisitRoleButton buttonAuth : allButtonAuth) {
                this.syncUnionConverter.buttonAuthToRelation(buttonAuth, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(list)) {
            for (SysAppVisitFormAuthorizeRoles formAuth : list) {
                this.syncUnionConverter.dataAuthToRoleDataRight(formAuth, conversionProduct);
            }
        }
        this.removeExistData(conversionProduct, appId, roleIds);
        this.saveConversionProduct(conversionProduct);
        Long l = System.currentTimeMillis();
        LOGGER.info("\u540c\u6b65\u6240\u9700\u65f6\u95f4\uff1a{}", (Object)(l - startTime));
    }

    private void removeExistData(ConversionProduct conversionProduct, Long appId, List<Long> roleIds) {
        QueryAppVisitDto queryAppVisitDto = new QueryAppVisitDto();
        queryAppVisitDto.setAppId(appId);
        queryAppVisitDto.setRoleIds(roleIds);
        List appVisitInfoList = this.functionsBoService.getAppVisitInfoList(queryAppVisitDto);
        AppMenuFuncResVo appMenuFuncResInfo = this.functionsBoService.getAppMenuFuncResInfo(appId);
        if (HussarUtils.isNotEmpty((Object)appMenuFuncResInfo.getFuncModules())) {
            List funModIds = appMenuFuncResInfo.getFuncModules().stream().map(SysFunctionModules::getId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(conversionProduct.getFunctionModulesList())) {
                conversionProduct.getFunctionModulesList().removeIf(sysFunctionModules -> funModIds.contains(sysFunctionModules.getId()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)appMenuFuncResInfo.getResModules())) {
            List resModIds = appMenuFuncResInfo.getResModules().stream().map(SysResourceModules::getId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(conversionProduct.getResourceModulesList())) {
                conversionProduct.getResourceModulesList().removeIf(sysResourceModules -> resModIds.contains(sysResourceModules.getId()));
            }
        }
        Map<Object, Object> existFuncCodeMap = new HashMap();
        Map<Object, Object> newFuncCodeMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)appMenuFuncResInfo.getFunctions())) {
            existFuncCodeMap = appMenuFuncResInfo.getFunctions().stream().collect(Collectors.toMap(SysFunctions::getId, SysFunctions::getFunctionCode));
            List funCodes = appMenuFuncResInfo.getFunctions().stream().map(SysFunctions::getFunctionCode).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(conversionProduct.getFunctionList())) {
                newFuncCodeMap = conversionProduct.getFunctionList().stream().collect(Collectors.toMap(SysFunctions::getId, SysFunctions::getFunctionCode));
                conversionProduct.getFunctionList().removeIf(functions -> funCodes.contains(functions.getFunctionCode()));
            }
        }
        Map<Object, Object> existResCodeMap = new HashMap();
        Map<Object, Object> newResCodeMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)appMenuFuncResInfo.getResources())) {
            existResCodeMap = appMenuFuncResInfo.getResources().stream().collect(Collectors.toMap(SysResources::getId, SysResources::getResourceCode));
            List resCodes = appMenuFuncResInfo.getResources().stream().map(SysResources::getResourceCode).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(conversionProduct.getResourceList())) {
                newResCodeMap = conversionProduct.getResourceList().stream().collect(Collectors.toMap(SysResources::getId, SysResources::getResourceCode));
                conversionProduct.getResourceList().removeIf(sysResources -> resCodes.contains(sysResources.getResourceCode()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)appMenuFuncResInfo.getFuncResRelations())) {
            Map<Object, Object> finalExistFuncCodeMap = existFuncCodeMap;
            HashMap finalExistResCodeMap = existResCodeMap;
            List funcResRelations = appMenuFuncResInfo.getFuncResRelations().stream().map(funcRes -> (String)finalExistFuncCodeMap.get(funcRes.getFunctionId()) + "-" + (String)finalExistResCodeMap.get(funcRes.getResourceId())).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(conversionProduct.getFunctionResourceList())) {
                Iterator<SysFunctionResources> iterator = conversionProduct.getFunctionResourceList().iterator();
                while (iterator.hasNext()) {
                    SysFunctionResources sysFunctionResources = iterator.next();
                    String key = (String)newFuncCodeMap.get(sysFunctionResources.getFunctionId()) + "-" + (String)newResCodeMap.get(sysFunctionResources.getResourceId());
                    if (!funcResRelations.contains(key)) continue;
                    iterator.remove();
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)appVisitInfoList)) {
            Iterator<SysRoleStruRights> iterator;
            ArrayList roleFuncRelations = new ArrayList();
            ArrayList roleResRelations = new ArrayList();
            HashMap roleFuncRightMap = new HashMap();
            ArrayList roleStruRights = new ArrayList();
            ArrayList roleUserRights = new ArrayList();
            appVisitInfoList.forEach(appVisitInfo -> {
                if (HussarUtils.isNotEmpty((Object)appVisitInfo.getRoleFunctions())) {
                    appVisitInfo.getRoleFunctions().stream().map(roleFunc -> roleFunc.getRoleId() + "-" + roleFunc.getFunctionId()).forEach(roleFuncRelations::add);
                }
                if (HussarUtils.isNotEmpty((Object)appVisitInfo.getRoleResources())) {
                    appVisitInfo.getRoleResources().stream().map(roleRes -> roleRes.getRoleId() + "-" + roleRes.getResourceId()).forEach(roleResRelations::add);
                }
                if (HussarUtils.isNotEmpty((Object)appVisitInfo.getRoleDataRights())) {
                    appVisitInfo.getRoleDataRights().stream().forEach(roleData -> roleFuncRightMap.put(roleData.getRoleId() + "-" + roleData.getFunctionId(), roleData.getDataRightsId()));
                }
                if (HussarUtils.isNotEmpty((Object)appVisitInfo.getRoleStruRights())) {
                    appVisitInfo.getRoleStruRights().stream().map(roleStru -> roleStru.getRoleDataRightsId() + "-" + roleStru.getRoleId() + "-" + roleStru.getStruid()).forEach(roleStruRights::add);
                }
                if (HussarUtils.isNotEmpty((Object)appVisitInfo.getRoleUserRights())) {
                    appVisitInfo.getRoleUserRights().stream().map(roleStru -> roleStru.getRoleDataRightsId() + "-" + roleStru.getRoleId() + "-" + roleStru.getUserId()).forEach(roleUserRights::add);
                }
            });
            if (HussarUtils.isNotEmpty(conversionProduct.getRoleFunctionList())) {
                conversionProduct.getRoleFunctionList().removeIf(roleFunc -> roleFuncRelations.contains(roleFunc.getRoleId() + "-" + roleFunc.getFunctionId()));
            }
            if (HussarUtils.isNotEmpty(conversionProduct.getRoleResourceList())) {
                conversionProduct.getRoleResourceList().removeIf(roleRes -> roleResRelations.contains(roleRes.getRoleId() + "-" + roleRes.getResourceId()));
            }
            HashMap roleDataRightsIdMap = new HashMap();
            if (HussarUtils.isNotEmpty(conversionProduct.getRoleDataRightList())) {
                Set roleDataRights = roleFuncRightMap.keySet();
                Iterator<SysRoleDataRight> iterator2 = conversionProduct.getRoleDataRightList().iterator();
                while (iterator2.hasNext()) {
                    SysRoleDataRight sysRoleDataRight = iterator2.next();
                    String key = sysRoleDataRight.getRoleId() + "-" + sysRoleDataRight.getFunctionId();
                    if (!roleDataRights.contains(key)) continue;
                    roleDataRightsIdMap.put(sysRoleDataRight.getDataRightsId(), roleFuncRightMap.get(key));
                    iterator2.remove();
                }
            }
            if (HussarUtils.isNotEmpty(conversionProduct.getRoleStruRightsList())) {
                iterator = conversionProduct.getRoleStruRightsList().iterator();
                while (iterator.hasNext()) {
                    SysRoleStruRights sysRoleStruRights = iterator.next();
                    if (roleDataRightsIdMap.containsKey(sysRoleStruRights.getRoleDataRightsId())) {
                        sysRoleStruRights.setRoleDataRightsId((Long)roleDataRightsIdMap.get(sysRoleStruRights.getRoleDataRightsId()));
                    }
                    if (!roleStruRights.contains(sysRoleStruRights.getRoleDataRightsId() + "-" + sysRoleStruRights.getRoleId() + "-" + sysRoleStruRights.getStruid())) continue;
                    iterator.remove();
                }
            }
            if (HussarUtils.isNotEmpty(conversionProduct.getRoleUserRightsList())) {
                iterator = conversionProduct.getRoleUserRightsList().iterator();
                while (iterator.hasNext()) {
                    SysRoleUserRights sysRoleUserRights = (SysRoleUserRights)iterator.next();
                    if (roleDataRightsIdMap.containsKey(sysRoleUserRights.getRoleDataRightsId())) {
                        sysRoleUserRights.setRoleDataRightsId((Long)roleDataRightsIdMap.get(sysRoleUserRights.getRoleDataRightsId()));
                    }
                    if (!roleUserRights.contains(sysRoleUserRights.getRoleDataRightsId() + "-" + sysRoleUserRights.getRoleId() + "-" + sysRoleUserRights.getUserId())) continue;
                    iterator.remove();
                }
            }
        }
    }

    public Long getAppRoleGroupId(Long appId) {
        SysRoleGroup appRoleGroup = this.getAppRoleGroup(appId);
        if (!HussarUtils.isNull((Object)appRoleGroup)) {
            return appRoleGroup.getId();
        }
        return null;
    }

    private void upgradeFuncResForForm(UpgradeFormMappingDto upgradeFormMappingDto) {
        ConversionProduct conversionProduct = new ConversionProduct();
        SysForm currentForm = upgradeFormMappingDto.getCurrentForm();
        HashMap<Long, Long> resIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> funcIdMap = new HashMap<Long, Long>();
        AppMenuFuncResVo menuFuncResData = upgradeFormMappingDto.getFormDataInit().getFormMenuFuncResVo();
        if (HussarUtils.isNotEmpty((Object)menuFuncResData) && menuFuncResData.getFunctions() != null && menuFuncResData.getResources() != null) {
            this.upgradeResource(upgradeFormMappingDto, menuFuncResData, resIdMap, conversionProduct);
            this.upgradeFunction(upgradeFormMappingDto, menuFuncResData, funcIdMap, conversionProduct);
            AppSyncUnionServiceImpl.upgradeFuncResRelation(menuFuncResData.getFuncResRelations(), conversionProduct, funcIdMap, resIdMap);
            this.saveConversionProduct(conversionProduct);
        } else {
            this.upgradeResourceNoAuthData(upgradeFormMappingDto, resIdMap, conversionProduct);
            this.upgradeFunctionNoAuthData(upgradeFormMappingDto, funcIdMap, conversionProduct);
            this.initFuncResRelationNoAuthData(upgradeFormMappingDto, conversionProduct, funcIdMap, resIdMap);
            this.saveConversionProduct(conversionProduct);
        }
        this.syncUnionConverter.authFormForAppDevRole(currentForm.getAppId(), conversionProduct);
    }

    private void initFuncResRelationNoAuthData(UpgradeFormMappingDto upgradeFormMappingDto, ConversionProduct conversionProduct, Map<Long, Long> funcIdMap, Map<Long, Long> resIdMap) {
        List customButtonList = upgradeFormMappingDto.getFormDataInit().getCustomButton();
        if (HussarUtils.isNotEmpty((Object)customButtonList)) {
            ArrayList<SysFunctionResources> list = new ArrayList<SysFunctionResources>(customButtonList.size());
            for (SysCustomButton button : customButtonList) {
                if (!HussarUtils.isNotEmpty((Object)funcIdMap.get(button.getId())) || !HussarUtils.isNotEmpty((Object)resIdMap.get(button.getId()))) continue;
                SysFunctionResources relation = new SysFunctionResources();
                relation.setId(null);
                relation.setFunctionId(funcIdMap.get(button.getId()));
                relation.setResourceId(resIdMap.get(button.getId()));
                list.add(relation);
            }
            conversionProduct.setFunctionResourceList(list);
        }
    }

    private void upgradeFunctionNoAuthData(UpgradeFormMappingDto upgradeFormMappingDto, Map<Long, Long> funcIdMap, ConversionProduct conversionProduct) {
        SysForm currentForm = upgradeFormMappingDto.getCurrentForm();
        List currentFuncList = this.functionsBoService.listByModuleId(currentForm.getId());
        List customButtonList = upgradeFormMappingDto.getFormDataInit().getCustomButton();
        List currentElFuncList = currentFuncList.stream().filter(item -> item.getFunctionCode().contains("element_")).collect(Collectors.toList());
        ArrayList<SysFunctions> addFuncList = new ArrayList<SysFunctions>();
        ArrayList<SysCustomButton> addCustomButtonList = new ArrayList<SysCustomButton>();
        if (HussarUtils.isNotEmpty((Object)customButtonList) && HussarUtils.isEmpty(currentElFuncList)) {
            addCustomButtonList.addAll(customButtonList);
        }
        if (HussarUtils.isNotEmpty((Object)customButtonList) && HussarUtils.isNotEmpty(currentElFuncList)) {
            for (SysCustomButton button : customButtonList) {
                String buttonCode = button.getAction();
                boolean addFlag = currentElFuncList.stream().map(SysFunctions::getFunctionCode).map(code -> code.substring(code.lastIndexOf("_") + 1)).noneMatch(currentButton -> HussarUtils.equals((Object)currentButton, (Object)buttonCode));
                if (!addFlag) continue;
                addCustomButtonList.add(button);
            }
        }
        if (HussarUtils.isEmpty(addCustomButtonList)) {
            return;
        }
        if (HussarUtils.isNotEmpty(addCustomButtonList)) {
            Map customButtonIdMap = upgradeFormMappingDto.getCustomButtonIdMap();
            Integer maxOrder = this.functionsBoService.getMaxOrderByParentId(currentForm.getId());
            for (SysCustomButton button : addCustomButtonList) {
                String langKey = this.syncUnionConverter.getI18Keys(button.getI18nKeys());
                SysFunctions fun = new SysFunctions();
                funcIdMap.put(button.getId(), (Long)customButtonIdMap.get(button.getId()));
                fun.setId(button.getId());
                fun.setFunctionCode("element_" + currentForm.getId() + "_" + button.getAction());
                fun.setFunctionModuleId(currentForm.getId());
                fun.setFunctionName(button.getName());
                maxOrder = maxOrder + 1;
                fun.setSeq(maxOrder);
                fun.setAppId(currentForm.getAppId());
                fun.setNameLangKey(langKey);
                fun.setFunSource("noCode");
                addFuncList.add(fun);
            }
            conversionProduct.setFunctionList(addFuncList);
        }
    }

    private void upgradeResourceNoAuthData(UpgradeFormMappingDto upgradeFormMappingDto, Map<Long, Long> resIdMap, ConversionProduct conversionProduct) {
        SysForm currentForm = upgradeFormMappingDto.getCurrentForm();
        List currentResList = this.hussarBaseResourceService.getResourcesByModuleId(currentForm.getId());
        List customButtonList = upgradeFormMappingDto.getFormDataInit().getCustomButton();
        List currentElementResList = currentResList.stream().filter(item -> "res_element".equals(item.getResTypeId())).collect(Collectors.toList());
        List list = currentResList.stream().filter(item -> "res_menu".equals(item.getResTypeId())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        SysResources pageRes = (SysResources)list.get(0);
        ArrayList<SysResources> addResList = new ArrayList<SysResources>();
        List<Object> addCustomButtonList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)customButtonList) && HussarUtils.isEmpty(currentElementResList)) {
            addCustomButtonList.addAll(customButtonList);
        }
        if (HussarUtils.isNotEmpty((Object)customButtonList) && HussarUtils.isNotEmpty(currentElementResList)) {
            addCustomButtonList = customButtonList.stream().filter(item -> currentElementResList.stream().noneMatch(entry -> HussarUtils.equals((Object)item.getAction(), (Object)entry.getPermissions()))).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addCustomButtonList)) {
            Map customButtonIdMap = upgradeFormMappingDto.getCustomButtonIdMap();
            Integer maxOrder = this.hussarBaseResourceService.getMaxOrderByParentId(currentForm.getId());
            for (SysCustomButton sysCustomButton : addCustomButtonList) {
                String langKey = this.syncUnionConverter.getI18Keys(sysCustomButton.getI18nKeys());
                SysResources customButtonRes = new SysResources();
                resIdMap.put(sysCustomButton.getId(), (Long)customButtonIdMap.get(sysCustomButton.getId()));
                customButtonRes.setId(sysCustomButton.getId());
                customButtonRes.setResourceName(sysCustomButton.getName());
                customButtonRes.setResourceAlias(sysCustomButton.getAlias());
                customButtonRes.setModuleId(currentForm.getId());
                customButtonRes.setResTypeId("res_element");
                customButtonRes.setPermissions(sysCustomButton.getAction());
                customButtonRes.setResourceCode("element_" + currentForm.getId() + "_" + sysCustomButton.getAction());
                customButtonRes.setParentResourceId(pageRes.getId());
                maxOrder = maxOrder + 1;
                customButtonRes.setSeq(maxOrder);
                customButtonRes.setAppId(currentForm.getAppId());
                customButtonRes.setNameLangKey(langKey);
                customButtonRes.setAliasLangKey(langKey);
                customButtonRes.setResSource("noCode");
                addResList.add(customButtonRes);
            }
            conversionProduct.setResourceList(addResList);
        }
    }

    private void upgradeFunction(UpgradeFormMappingDto upgradeFormMappingDto, AppMenuFuncResVo menuFuncResData, Map<Long, Long> funcIdMap, ConversionProduct conversionProduct) {
        SysForm currentForm = upgradeFormMappingDto.getCurrentForm();
        List currentFuncList = this.functionsBoService.listByModuleId(currentForm.getId());
        List functions = menuFuncResData.getFunctions();
        List elFuncList = functions.stream().filter(item -> item.getFunctionCode().contains("element_")).collect(Collectors.toList());
        List currentElFuncList = currentFuncList.stream().filter(item -> item.getFunctionCode().contains("element_")).collect(Collectors.toList());
        ArrayList<SysFunctions> addFuncList = new ArrayList<SysFunctions>();
        if (HussarUtils.isNotEmpty(elFuncList) && HussarUtils.isEmpty(currentElFuncList)) {
            addFuncList.addAll(elFuncList);
        }
        if (HussarUtils.isNotEmpty(elFuncList) && HussarUtils.isNotEmpty(currentElFuncList)) {
            for (SysFunctions function : elFuncList) {
                String functionCode = function.getFunctionCode();
                String button = functionCode.substring(functionCode.lastIndexOf("_") + 1);
                boolean addFlag = currentElFuncList.stream().map(SysFunctions::getFunctionCode).map(code -> code.substring(code.lastIndexOf("_") + 1)).noneMatch(currentButton -> HussarUtils.equals((Object)currentButton, (Object)button));
                if (!addFlag) continue;
                addFuncList.add(function);
            }
        }
        if (HussarUtils.isEmpty(addFuncList)) {
            return;
        }
        List buttonCodeList = Arrays.stream(Button.values()).map(Button::getButtonCode).collect(Collectors.toList());
        Map customButtonIdMap = upgradeFormMappingDto.getCustomButtonIdMap();
        addFuncList.forEach(func -> {
            String button = func.getFunctionCode().substring(func.getFunctionCode().lastIndexOf("_") + 1);
            Long id = HussarUtils.isNotEmpty((Object)customButtonIdMap) && HussarUtils.isNotEmpty(customButtonIdMap.get(func.getId())) ? (Long)customButtonIdMap.get(func.getId()) : (!buttonCodeList.contains(button) ? func.getId() : Long.valueOf(IdWorker.getId((Object)func)));
            funcIdMap.put(func.getId(), id);
            func.setId(id);
            func.setAppId(currentForm.getAppId());
            func.setFunctionModuleId(currentForm.getId());
            func.setFunctionCode("element_" + currentForm.getId() + "_" + button);
        });
        conversionProduct.setFunctionList(addFuncList);
    }

    private void upgradeResource(UpgradeFormMappingDto upgradeFormMappingDto, AppMenuFuncResVo menuFuncResData, Map<Long, Long> resIdMap, ConversionProduct conversionProduct) {
        SysForm currentForm = upgradeFormMappingDto.getCurrentForm();
        List currentResList = this.hussarBaseResourceService.getResourcesByModuleId(currentForm.getId());
        List resources = menuFuncResData.getResources();
        List elementResList = resources.stream().filter(item -> "res_element".equals(item.getResTypeId())).collect(Collectors.toList());
        List currentElementResList = currentResList.stream().filter(item -> "res_element".equals(item.getResTypeId())).collect(Collectors.toList());
        List list = currentResList.stream().filter(item -> "res_menu".equals(item.getResTypeId())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        SysResources pageRes = (SysResources)list.get(0);
        List<Object> addResList = new ArrayList();
        if (HussarUtils.isNotEmpty(elementResList) && HussarUtils.isEmpty(currentElementResList)) {
            addResList.addAll(elementResList);
        }
        if (HussarUtils.isNotEmpty(elementResList) && HussarUtils.isNotEmpty(currentElementResList)) {
            addResList = elementResList.stream().filter(item -> currentElementResList.stream().noneMatch(entry -> HussarUtils.equals((Object)item.getPermissions(), (Object)entry.getPermissions()))).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addResList)) {
            List buttonCodeList = Arrays.stream(Button.values()).map(Button::getButtonCode).collect(Collectors.toList());
            Map customButtonIdMap = upgradeFormMappingDto.getCustomButtonIdMap();
            for (SysResources sysResources : addResList) {
                Long id = HussarUtils.isNotEmpty((Object)customButtonIdMap) && HussarUtils.isNotEmpty(customButtonIdMap.get(sysResources.getId())) ? (Long)customButtonIdMap.get(sysResources.getId()) : (!buttonCodeList.contains(sysResources.getPermissions()) ? sysResources.getId() : Long.valueOf(IdWorker.getId((Object)sysResources)));
                resIdMap.put(sysResources.getId(), id);
                sysResources.setId(id);
                sysResources.setModuleId(currentForm.getId());
                sysResources.setAppId(currentForm.getAppId());
                sysResources.setParentResourceId(pageRes.getId());
                sysResources.setResourceCode("element_" + currentForm.getId() + "_" + sysResources.getPermissions());
            }
            conversionProduct.setResourceList(addResList);
        }
    }

    private SysRoleGroup getAppRoleGroup(Long appId) {
        return this.rolesExternalService.getRoleGroupByAppId(appId);
    }

    private void saveConversionProduct(ConversionProduct conversionProduct) {
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionModulesList())) {
            this.functionModulesBoService.saveAll(conversionProduct.getFunctionModulesList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getResourceModulesList())) {
            this.resourceMosulesBoService.saveResourceModules(conversionProduct.getResourceModulesList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionList())) {
            this.functionsBoService.saveAllFunctions(conversionProduct.getFunctionList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getResourceList())) {
            this.hussarBaseResourceService.saveBatchResource(conversionProduct.getResourceList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionResourceList())) {
            this.functionResourcesBoService.saveAllFunRes(conversionProduct.getFunctionResourceList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleFunctionList())) {
            this.rolesExternalService.saveAllRoleFun(conversionProduct.getRoleFunctionList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleResourceList())) {
            this.rolesExternalService.saveAllRoleRes(conversionProduct.getRoleResourceList());
            HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleDataRightList())) {
            this.rolesExternalService.saveAllRoleRight(conversionProduct.getRoleDataRightList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleStruRightsList())) {
            this.roleStruRightBoService.saveBatch(conversionProduct.getRoleStruRightsList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleUserRightsList())) {
            this.roleUserRightBoService.saveBatch(conversionProduct.getRoleUserRightsList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getMenuList())) {
            this.menuBoService.insertOrUpdateMenuList(conversionProduct.getMenuList());
            HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
        }
    }

    private boolean ordinaryOrFlow(SysForm form) {
        String formType = form.getFormType();
        return "0".equals(formType) || "1".equals(formType);
    }
}

