/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.model.SysDataOperateLog;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogAsync;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogComponent;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogThreadLocal;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogType;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.DataOperateLog;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.vo.SysDataLogUserInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataOperateLogAspect {
    @Resource
    private OperateLogComponent operateLogComponent;
    @Resource
    private OperateLogAsync operateLogAsync;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private OperateLogThreadLocal operateLogThreadLocal;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataOperateLogAspect.class);
    private static final String TABLE_QUERY_FROM = "_tableQuery_from";

    @Around(value="(execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.formSave(..)) || execution(* com.jxdinfo.hussar.formdesign.extension.api.service.IOpeApiService.update(..))|| execution(* com.jxdinfo.hussar.formdesign.extension.api.service.IOpeApiService.create(..)))&& @annotation(dataOperateLog)")
    public Object formSaveAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        String saveDataOperateLog = dataOperateLog.saveDataOperateLog();
        if (HussarUtils.isNotEmpty((Object)saveDataOperateLog) && saveDataOperateLog.startsWith("#")) {
            String paramName = saveDataOperateLog.substring(1);
            Object[] values = joinPoint.getArgs();
            String[] names = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
            Boolean saveDataOperateLogValue = null;
            for (int i = 0; i < names.length; ++i) {
                if (!HussarUtils.equals((Object)paramName, (Object)names[i])) continue;
                saveDataOperateLogValue = (Boolean)values[i];
                break;
            }
            if (HussarUtils.equals((Object)Boolean.FALSE, saveDataOperateLogValue)) {
                return joinPoint.proceed();
            }
        }
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        JSONObject oldData = new JSONObject();
        JSONArray childList = new JSONArray();
        JSONArray childCountList = new JSONArray();
        HashMap newParams = new HashMap();
        HashMap oldParams = new HashMap();
        JSONArray widgets = new JSONArray();
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        String tableName = "";
        Object formData = args[1];
        String appId = String.valueOf(args[2]);
        try {
            tableName = sysForm.getTableName();
            JSONObject data = this.operateLogComponent.toJsonObj(formData);
            Object dataIdObj = data.get((Object)"RECORD_ID");
            if (sysForm.getFormType().equals("1")) {
                if (HussarUtils.isNotEmpty((Object)operateLogType.getButtonId())) {
                    if (HussarUtils.isEmpty((Object)dataIdObj)) {
                        LOGGER.info("\u6d41\u7a0b\u8349\u7a3f\u65b0\u589e\u6216\u4fee\u6539\u4e0d\u8bb0\u5f55\u6570\u636e\u65e5\u5fd7,\u8868\u5355id:{}", (Object)formId);
                        return joinPoint.proceed();
                    }
                    operateLogType.setMode(2);
                }
                if (operateLogType.getMode() == 0 && HussarUtils.isEmpty((Object)data.get((Object)"PROCESS_NODE"))) {
                    LOGGER.info("\u6d41\u7a0b\u8349\u7a3f\u65b0\u589e\u6216\u4fee\u6539\u4e0d\u8bb0\u5f55\u6570\u636e\u65e5\u5fd7,\u8868\u5355id:{}", (Object)formId);
                    return joinPoint.proceed();
                }
            } else if (HussarUtils.isNotEmpty((Object)operateLogType.getButtonId())) {
                operateLogType.setMode(2);
            }
            if (HussarUtils.isNotEmpty((Object)dataIdObj)) {
                String dataId = String.valueOf(dataIdObj);
                oldData = this.operateLogComponent.getDataFormDB(dataId, appId, String.valueOf(formId), "0");
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("formSave\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38\uff0c\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u8868\u5355id\uff1a{}\uff0c\u6570\u636e\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, formData, e.getMessage()});
        }
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        String dataId = "";
        JSONObject newData = new JSONObject();
        String packageName = "";
        String methodName = "";
        try {
            packageName = joinPoint.getSignature().getDeclaringType().getName();
            methodName = joinPoint.getSignature().getName();
            userInfo.setPackageName(packageName);
            userInfo.setMethodName(methodName);
            if (value instanceof ApiResponse) {
                Object data = ((ApiResponse)value).getData();
                if (data instanceof LinkedHashMap) {
                    dataId = String.valueOf(((LinkedHashMap)data).get("RECORD_ID"));
                }
                if (data instanceof JSONObject) {
                    dataId = String.valueOf(((JSONObject)data).get((Object)"RECORD_ID"));
                }
            } else {
                ResponseEntity responseEntity = (ResponseEntity)value;
                if (HussarUtils.isNotEmpty((Object)responseEntity) && HussarUtils.isNotEmpty((Object)responseEntity.getBody())) {
                    ApiResponse body = (ApiResponse)responseEntity.getBody();
                    dataId = String.valueOf(body.getData());
                }
            }
            newData = this.operateLogComponent.getDataFormDB(dataId, appId, String.valueOf(formId), "0");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4fdd\u5b58\u540e\u7684\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        String dataSourceKey = DataModelUtil.currentDsName();
        String tableNameFinal = tableName;
        JSONObject oldDataFinal = oldData;
        Long userIdFinal = userId;
        JSONObject newDataFinal = newData;
        String dataIdFinal = dataId;
        HussarNoCodeThreadUtil.executeDataTask(() -> {
            try {
                this.operateLogAsync.formSaveAsync(value, tableNameFinal, appId, String.valueOf(formId), oldDataFinal, childList, childCountList, newParams, oldParams, userIdFinal, operateLogType, widgets, newDataFinal, dataIdFinal, dataSourceKey, userInfo);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                LOGGER.error("\u6570\u636e\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            }
        });
        return value;
    }

    @Around(value="execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.formIncrementSave(..)) && @annotation(dataOperateLog)")
    public Object formIncrementSaveAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        int mode = operateLogType.getMode();
        AtomicInteger type = null;
        JSONArray oldDataS = new JSONArray();
        JSONArray newDataS = new JSONArray();
        JSONArray editIds = new JSONArray();
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        String tableName = "";
        Object formData = args[1];
        String appId = String.valueOf(args[2]);
        JSONObject data = this.operateLogComponent.toJsonObj(formData);
        JSONArray oldArray = new JSONArray();
        Object saveAndUpdate = data.get((Object)"saveAndUpdate");
        try {
            JSONObject jsonObject;
            Object dataObj;
            String packageName = joinPoint.getSignature().getDeclaringType().getName();
            String methodName = joinPoint.getSignature().getName();
            userInfo.setPackageName(packageName);
            userInfo.setMethodName(methodName);
            tableName = sysForm.getTableName();
            if (HussarUtils.isNotEmpty((Object)saveAndUpdate) && HussarUtils.isNotEmpty((Object)(dataObj = (jsonObject = (JSONObject)saveAndUpdate).get((Object)tableName)))) {
                oldArray.addAll((Collection)JSON.parseArray((String)JSON.toJSONString((Object)dataObj)));
            }
            if (mode == 1) {
                type = new AtomicInteger(2);
                boolean isAdd = false;
                boolean isEdit = false;
                for (Object jsonObj2 : oldArray) {
                    Object o = ((JSONObject)jsonObj2).get((Object)"RECORD_ID");
                    if (HussarUtils.isNotEmpty((Object)o)) {
                        isEdit = true;
                        continue;
                    }
                    isAdd = true;
                }
                if (isAdd && isEdit) {
                    type.set(3);
                }
                if (isAdd && !isEdit) {
                    type.set(1);
                }
                if (type.get() == 2) {
                    this.operateLogComponent.getDataSBatch(oldArray, tableName, oldDataS, Long.valueOf(appId), formId);
                }
                if (type.get() == 3) {
                    List<Object> editList = oldArray.stream().filter(jsonObj -> !"".equals(((JSONObject)jsonObj).get((Object)"RECORD_ID"))).collect(Collectors.toList());
                    editList.forEach(jsonObj -> {
                        String id = String.valueOf(((JSONObject)jsonObj).get((Object)"RECORD_ID"));
                        editIds.add((Object)id);
                    });
                    this.operateLogComponent.getDataSBatch(new JSONArray(editList), tableName, oldDataS, Long.valueOf(appId), formId);
                }
            } else {
                this.operateLogComponent.getDataSBatch(oldArray, tableName, oldDataS, Long.valueOf(appId), formId);
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("formIncrementSave\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38\uff0c\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u8868\u5355id\uff1a{}\uff0c\u6570\u636e\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, formData, e});
        }
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        LOGGER.info("\u64cd\u4f5c\u7c7b\u578b\uff1a{}\uff0c\u64cd\u4f5c\u6a21\u5f0f\uff1a{}", (Object)type, (Object)mode);
        String dataSourceKey = DataModelUtil.currentDsName();
        String finalTableName = tableName;
        AtomicInteger finalType = type;
        Long finalUserId = userId;
        this.operateLogComponent.getDataSBatch(oldArray, tableName, newDataS, Long.valueOf(appId), formId);
        HussarNoCodeThreadUtil.executeDataTask(() -> this.operateLogAsync.formIncrementSaveAsync(formData, finalTableName, Long.valueOf(appId), finalType, formId, oldDataS, newDataS, finalUserId, operateLogType, editIds, dataSourceKey, userInfo));
        return value;
    }

    @Around(value="(execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.tableSave(..)) || execution(* com.jxdinfo.hussar.formdesign.extension.api.service.IOpeApiService.createBatch(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.saveBatchMore(..)))&& @annotation(dataOperateLog)")
    public Object tableSaveAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        try {
            SysForm sysForm;
            int mode;
            SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
            String device = userInfo.getDevice();
            Long userId = userInfo.getUserId();
            Object[] args = joinPoint.getArgs();
            Long formId = Long.valueOf(String.valueOf(args[1]));
            Long appId = Long.valueOf(String.valueOf(args[0]));
            Map map = (Map)args[2];
            String oldString = JSON.toJSONString((Object)map);
            JSONObject oldObj = JSON.parseObject((String)oldString);
            AtomicInteger type = null;
            JSONArray oldArray = this.operateLogComponent.getJsonObj(oldObj);
            OperateLogType operateLogType1 = new OperateLogType();
            OperateLogType operateLogType = this.operateLogThreadLocal.get();
            if (HussarUtils.isEmpty((Object)operateLogType)) {
                operateLogType1.setMode(-1);
                operateLogType1.setTriggerFormId(null);
                operateLogType1.setDevice("Unknown");
            } else {
                operateLogType1.setMode(operateLogType.getMode());
                operateLogType1.setTriggerFormId(operateLogType.getTriggerFormId());
                operateLogType1.setDevice(device);
                operateLogType1.setDataPullCreator(operateLogType.getDataPullCreator());
            }
            if (operateLogType1.getMode() == 6) {
                userId = operateLogType1.getDataPullCreator();
            }
            if ((mode = operateLogType1.getMode()) == 9) {
                LOGGER.info("\u8868\u5355\u8f6c\u6362\u4e0d\u8bb0\u5f55\u6570\u636e\u65e5\u5fd7,\u8868\u5355id:{}", (Object)formId);
                this.operateLogThreadLocal.remove();
                return joinPoint.proceed();
            }
            if (mode == 5 || mode == 1 || mode == 8 || mode == 6) {
                this.operateLogThreadLocal.remove();
            }
            if (HussarUtils.isEmpty((Object)(sysForm = (SysForm)this.sysFormService.getById((Serializable)formId)))) {
                LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
            }
            if (sysForm.getFormType().equals("1") && mode == 1) {
                LOGGER.info("\u6d41\u7a0b\u8349\u7a3f\u65b0\u589e\u6216\u4fee\u6539\u4e0d\u8bb0\u5f55\u6570\u636e\u65e5\u5fd7,\u8868\u5355id:{}", (Object)formId);
                return joinPoint.proceed();
            }
            String tableName = "";
            JSONArray oldDataS = new JSONArray();
            JSONArray newDataS = new JSONArray();
            JSONArray editIds = new JSONArray();
            try {
                String packageName = joinPoint.getSignature().getDeclaringType().getName();
                String methodName = joinPoint.getSignature().getName();
                userInfo.setPackageName(packageName);
                userInfo.setMethodName(methodName);
                tableName = sysForm.getTableName();
                if (mode == 4 || mode == 5 || mode == 8 || mode == 6) {
                    for (Object jsonObj2 : oldArray) {
                        Object o = ((JSONObject)jsonObj2).get((Object)tableName);
                        editIds.add(o);
                    }
                }
                if (mode == 1) {
                    type = new AtomicInteger(2);
                    boolean isAdd = false;
                    boolean isEdit = false;
                    for (Object jsonObj3 : oldArray) {
                        Object o = ((JSONObject)jsonObj3).get((Object)"RECORD_ID");
                        if (HussarUtils.isNotEmpty((Object)o)) {
                            isEdit = true;
                            continue;
                        }
                        isAdd = true;
                    }
                    if (isAdd && isEdit) {
                        type.set(3);
                    }
                    if (isAdd && !isEdit) {
                        type.set(1);
                    }
                    if (type.get() == 2) {
                        this.operateLogComponent.getDataSBatch(oldArray, tableName, oldDataS, appId, formId);
                    }
                    if (type.get() == 3) {
                        List<Object> editList = oldArray.stream().filter(jsonObj -> !"".equals(((JSONObject)jsonObj).get((Object)"RECORD_ID"))).collect(Collectors.toList());
                        editList.forEach(jsonObj -> {
                            String id = String.valueOf(((JSONObject)jsonObj).get((Object)"RECORD_ID"));
                            editIds.add((Object)id);
                        });
                        this.operateLogComponent.getDataSBatch(new JSONArray(editList), tableName, oldDataS, appId, formId);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("tableSaveAround\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38,\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5e94\u7528id:{},\u8868\u5355id:{},\u4fdd\u5b58\u524d\u6570\u636e\uff1a{}", new Object[]{appId, formId, oldArray});
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
            joinPoint.proceed();
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
            if (mode == -1) {
                LOGGER.error("tableSaveAround\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38,\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5e94\u7528id:{},\u8868\u5355id:{},\u4fdd\u5b58\u524d\u6570\u636e\uff1a{}", new Object[]{appId, formId, oldArray});
                return null;
            }
            String dataSourceKey = DataModelUtil.currentDsName();
            String finalTableName = tableName;
            Long finalUserId = userId;
            AtomicInteger finalType = type;
            HussarNoCodeThreadUtil.executeDataTask(() -> {
                this.operateLogComponent.getDataSBatch(oldArray, finalTableName, newDataS, appId, formId);
                this.operateLogAsync.taleSaveAsync(map, finalTableName, appId, formId, oldDataS, newDataS, editIds, finalUserId, operateLogType1, finalType, dataSourceKey, userInfo);
            });
            return null;
        }
        catch (Exception e) {
            LOGGER.error("tableSave\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38\uff0c\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            joinPoint.proceed();
            return null;
        }
    }

    @Around(value="(execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.flowFormSubmit(..)) || execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.prevNodeReject(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.anyNodeReject(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.initialNodeReject(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.taskEntrust(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.endProcess(..))|| execution(* com.jxdinfo.hussar.formdesign.extension.api.service.IOpeApiService.flowFormSubmit(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.completeAssistTask(..)))&& @annotation(dataOperateLog)")
    public Object flowFormAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        JSONArray childList = new JSONArray();
        JSONArray childCountList = new JSONArray();
        HashMap newParams = new HashMap();
        HashMap oldParams = new HashMap();
        JSONArray widgets = new JSONArray();
        JSONObject oldData = new JSONObject();
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        Object arg = args[1];
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        String tableName = "";
        Long appId = sysForm.getAppId();
        JSONObject data = this.operateLogComponent.toJsonObj(arg);
        Object formDataObj = data.get((Object)"formData");
        JSONObject formData = this.operateLogComponent.toJsonObj(formDataObj);
        try {
            String packageName = joinPoint.getSignature().getDeclaringType().getName();
            String methodName = joinPoint.getSignature().getName();
            userInfo.setPackageName(packageName);
            userInfo.setMethodName(methodName);
            tableName = sysForm.getTableName();
            if (HussarUtils.isNotEmpty((Object)formData.get((Object)tableName))) {
                String dataId = String.valueOf(formData.get((Object)tableName));
                if (formData.containsKey((Object)"PROCESS_KEY") && HussarUtils.isEmpty((Object)formData.get((Object)"PROCESS_KEY"))) {
                    LOGGER.info("\u6d41\u7a0b\u8349\u7a3f\u4fee\u6539\u540e\u63d0\u4ea4\u6d41\u7a0b\u8bb0\u5f55\u65b0\u589e\u6570\u636e\u65e5\u5fd7,\u8868\u5355id:{},\u6570\u636eid\uff1a{}", (Object)formId, (Object)dataId);
                } else {
                    oldData = this.operateLogComponent.getDataFormDB(dataId, String.valueOf(appId), String.valueOf(formId), "0");
                }
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("flowFormSubmit\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38,\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5e94\u7528id:{},\u8868\u5355id:{},\u4fdd\u5b58\u524d\u6570\u636e\uff1a{}", new Object[]{appId, formId, formData});
        }
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        String dataId = "";
        JSONObject newData = new JSONObject();
        try {
            Object data1 = value instanceof ApiResponse ? ((ApiResponse)value).getData() : ((ApiResponse)((ResponseEntity)value).getBody()).getData();
            if (HussarUtils.isNotEmpty((Object)data1)) {
                dataId = String.valueOf(data1);
            }
            if (HussarUtils.isEmpty((Object)dataId)) {
                dataId = String.valueOf(formData.get((Object)tableName));
            }
            newData = this.operateLogComponent.getDataFormDB(dataId, String.valueOf(appId), String.valueOf(formId), "0");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4fdd\u5b58\u540e\u7684\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        String dataSourceKey = DataModelUtil.currentDsName();
        String finalTableName = tableName;
        JSONObject finalOldData = oldData;
        Long finalUserId = userId;
        JSONObject finalNewData = newData;
        String finalDataId = dataId;
        HussarNoCodeThreadUtil.executeDataTask(() -> this.operateLogAsync.flowFormSubmitAsync(value, finalTableName, appId, formId, finalOldData, childList, childCountList, newParams, oldParams, finalUserId, operateLogType, widgets, finalNewData, finalDataId, dataSourceKey, userInfo));
        return value;
    }

    @Around(value="(execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.flowFormSubmitBatch(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.flowFormRejectBatch(..)))&& @annotation(dataOperateLog)")
    public Object flowFormBatch(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        Object arg = args[1];
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        JSONObject data = this.operateLogComponent.toJsonObj(arg);
        Object object = data.get((Object)"dataList");
        JSONArray oldDataS = new JSONArray();
        JSONArray newDataS = new JSONArray();
        JSONArray editIds = new JSONArray();
        JSONArray dataList2 = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)object)) {
            String packageName = joinPoint.getSignature().getDeclaringType().getName();
            String methodName = joinPoint.getSignature().getName();
            userInfo.setPackageName(packageName);
            userInfo.setMethodName(methodName);
            JSONArray dataList = (JSONArray)object;
            dataList.forEach(item -> {
                JSONObject jsonObject = (JSONObject)item;
                Object object1 = jsonObject.get((Object)"formData");
                JSONObject jsonObject2 = (JSONObject)object1;
                dataList2.add((Object)jsonObject2);
                editIds.add(jsonObject2.get((Object)"RECORD_ID"));
            });
            this.operateLogComponent.getDataSBatch(dataList2, sysForm.getFormName(), oldDataS, sysForm.getAppId(), formId);
        }
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        Object proceed = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        String dataSourceKey = DataModelUtil.currentDsName();
        Long finalUserId = userId;
        HussarNoCodeThreadUtil.executeDataTask(() -> this.operateLogAsync.flowFormBatchAsync(dataList2, sysForm.getTableName(), sysForm.getAppId(), formId, oldDataS, newDataS, editIds, finalUserId, operateLogType, dataSourceKey, userInfo));
        return proceed;
    }

    @Around(value="execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.deleteBatch(..)) && @annotation(dataOperateLog)")
    public Object deleteBatchAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        JSONArray dataS = new JSONArray();
        SysForm sysForm = new SysForm();
        String formId = "";
        try {
            String packageName = joinPoint.getSignature().getDeclaringType().getName();
            String methodName = joinPoint.getSignature().getName();
            userInfo.setPackageName(packageName);
            userInfo.setMethodName(methodName);
            Object[] args = joinPoint.getArgs();
            Object arg = args[0];
            Object arg1 = args[1];
            Object arg2 = args[2];
            formId = String.valueOf(arg);
            sysForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData();
            JSONArray dataList = new JSONArray();
            if (HussarUtils.isNotEmpty((Object)arg1)) {
                String[] split;
                String ids = arg1.toString();
                for (String id : split = ids.split(",")) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("RECORD_ID", (Object)id);
                    dataList.add((Object)jsonObject);
                }
            }
            this.operateLogComponent.getDataSBatch(dataList, sysForm.getFormName(), dataS, sysForm.getAppId(), sysForm.getId());
        }
        catch (Exception ex) {
            LOGGER.error("\u6279\u91cf\u5220\u9664\u524d\u89e3\u6790\u5931\u8d25", (Throwable)ex);
        }
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        String dataSourceKey = "";
        try {
            dataSourceKey = DataModelUtil.currentDsName();
        }
        catch (Exception ex) {
            LOGGER.error("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25");
        }
        Long finalUserId = userId;
        String finalDataSourceKey = dataSourceKey;
        SysForm finalSysForm = sysForm;
        String finalFormId = formId;
        HussarNoCodeThreadUtil.executeDataTask(() -> {
            this.operateLogAsync.delDataLogAsync(joinPoint, finalUserId, operateLogType, finalDataSourceKey);
            for (Object object : dataS) {
                EngineResultEntity result = (EngineResultEntity)object;
                String jsonString = JSON.toJSONString((Object)result);
                JSONObject oldData = (JSONObject)JSON.parseObject((String)jsonString, JSONObject.class);
                JSONObject newData = new JSONObject();
                JSONArray childList = new JSONArray();
                JSONArray childCountList = new JSONArray();
                HashMap<String, Object> newParams = new HashMap<String, Object>();
                HashMap<String, Object> oldParams = new HashMap<String, Object>();
                String tableName = finalSysForm.getTableName();
                JSONArray widgets = new JSONArray();
                this.operateLogComponent.compareData(oldData, newData, childList, childCountList, newParams, oldParams, tableName, finalFormId, widgets);
                Map<String, String> widgetMap = this.operateLogComponent.getWidgets(finalFormId);
                Map<String, Widget> widgetsObj = this.operateLogComponent.getWidgetsObj(finalFormId);
                SysDataOperateLog log = this.operateLogComponent.newLog(String.valueOf(result.get((Object)"RECORD_ID")), finalFormId, String.valueOf(finalSysForm.getAppId()), 2, childList, childCountList, newParams, oldParams, operateLogType, widgets);
                if (operateLogType.getMode() == 6) {
                    Object user = newData.get((Object)"createUser_user");
                    if (HussarUtils.isNotEmpty((Object)user)) {
                        log.setCreator(Long.valueOf(String.valueOf(user)));
                    } else {
                        log.setCreator(finalUserId);
                    }
                } else {
                    log.setCreator(finalUserId);
                }
                this.operateLogComponent.auditLogHandle(log, Long.valueOf(finalFormId), String.valueOf(result.get((Object)"RECORD_ID")), finalUserId, this.operateLogComponent.getUserName(finalUserId), widgetMap, widgetsObj, finalSysForm, newData, userInfo);
            }
        });
        return value;
    }

    @Around(value="execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.flowFormSubmits(..)) && @annotation(dataOperateLog)")
    public Object flowFormSubmitSAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        Object value = null;
        try {
            Object[] args = joinPoint.getArgs();
            SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
            userInfo.setPackageName(joinPoint.getSignature().getDeclaringType().getName());
            userInfo.setMethodName(joinPoint.getSignature().getName());
            String device = userInfo.getDevice();
            Long userId = userInfo.getUserId();
            Long formId = Long.valueOf(String.valueOf(args[0]));
            Map map = (Map)args[1];
            String oldString = JSON.toJSONString((Object)map);
            JSONObject oldObj = JSON.parseObject((String)oldString);
            Object form = oldObj.get((Object)TABLE_QUERY_FROM);
            SysForm sysForm = HussarUtils.isNotEmpty((Object)form) ? (SysForm)((JSONObject)form).toJavaObject(SysForm.class) : (SysForm)this.sysFormService.getById((Serializable)formId);
            String tableName = sysForm.getTableName();
            Long appId = sysForm.getAppId();
            OperateLogType operateLogType = this.operateLogThreadLocal.get();
            operateLogType.setDevice(device);
            int mode = operateLogType.getMode();
            JSONArray newArray = new JSONArray();
            JSONArray dataList = (JSONArray)oldObj.get((Object)"dataList");
            if (HussarUtils.isNotEmpty((Object)dataList)) {
                for (Object object : dataList) {
                    JSONObject jsonObject = (JSONObject)object;
                    JSONObject formData = (JSONObject)jsonObject.get((Object)"formData");
                    newArray.add((Object)formData);
                }
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
            value = joinPoint.proceed();
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
            HussarNoCodeThreadUtil.executeDataTask(() -> this.operateLogComponent.batchAdd(newArray, tableName, appId, formId, 0, operateLogType, userId, mode, userInfo));
            return value;
        }
        catch (Exception e) {
            LOGGER.error("flowFormSubmits\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38\uff0c\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            return HussarUtils.isNotEmpty(value) ? value : joinPoint.proceed();
        }
    }

    private SysDataLogUserInfo beforeHandler(DataOperateLog dataOperateLog) {
        Long userId;
        SysDataLogUserInfo userInfo = new SysDataLogUserInfo();
        LOGGER.info("\u6570\u636e\u64cd\u4f5c\u65e5\u5fd7\u5207\u9762\u6267\u884c\u5f00\u59cb\uff0c\u6a21\u5757\u540d\u79f0:{}\uff0c\u5177\u4f53\u4e1a\u52a1\u540d\u79f0\uff1a{}", (Object)dataOperateLog.moduleCode(), (Object)dataOperateLog.handleName());
        SecurityUser user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        String device = String.valueOf(HussarUtils.isNotEmpty((Object)TransmittableThreadLocalHolder.get((String)"device")) ? TransmittableThreadLocalHolder.get((String)"device") : "Unknown");
        String accessToken = "";
        Long tenantId = 0L;
        if (HussarUtils.isEmpty((Object)user)) {
            LOGGER.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f");
            userId = 0L;
        } else {
            accessToken = user.getAccessToken();
            tenantId = user.getTenantId();
            LOGGER.info("tenantId:{}", (Object)tenantId);
            LOGGER.info("accessToken:{}", (Object)accessToken);
            userId = HussarUtils.isNull((Object)user.getId()) ? Long.valueOf(0L) : user.getId();
        }
        userInfo.setUserId(userId);
        userInfo.setDevice(device);
        userInfo.setToken(accessToken);
        userInfo.setTenantId(tenantId);
        return userInfo;
    }
}

