/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.dto.QueryStruRightFeignDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleUserRightBoService;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCustomInfoVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.SysFormRoleAuthVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitRoleServiceImpl")
public class SysAppVisitRoleOrganDataAuthorityServiceImpl
extends HussarServiceImpl<SysAppVisitRoleOrganDataAuthorityMapper, SysAppVisitRoleOrganDataAuthority>
implements ISysAppVisitRoleOrganDataAuthorityService {
    @Autowired
    private IHussarBaseStaffBoService hussarBaseStaffService;
    @Autowired
    private IHussarBaseUserBoService sysUsersService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysRoleDataRightBoService sysRoleDataRightBoService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private ISysRoleStruRightBoService sysRoleStruRightBoService;
    @Resource
    private ISysRoleUserRightBoService sysRoleUserRightBoService;
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;

    public ApiResponse<OrganDataAuthorityVo> organDataAuthorityList(Long formId, Long roleId) {
        Long dataRightsId;
        List dataRightCustomInfo;
        if (HussarUtils.isEmpty((Object)formId) || HussarUtils.isEmpty((Object)roleId)) {
            throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
        }
        OrganDataAuthorityVo organDataAuthorityVo = new OrganDataAuthorityVo();
        List functionsList = this.sysFunctionsBoService.list(Collections.singletonList(formId), null, "menu_" + formId);
        if (HussarUtils.isEmpty((Object)functionsList)) {
            return ApiResponse.success((Object)organDataAuthorityVo);
        }
        List funcIds = functionsList.stream().map(SysFunctions::getId).distinct().collect(Collectors.toList());
        List dataRightList = this.sysRoleDataRightBoService.list(Collections.singletonList(roleId), funcIds);
        if (HussarUtils.isEmpty((Object)dataRightList)) {
            return ApiResponse.success((Object)organDataAuthorityVo);
        }
        organDataAuthorityVo.setAllOrgan(((SysRoleDataRight)dataRightList.get(0)).getDataScope() == 1 ? "1" : "0");
        organDataAuthorityVo.setSubOrgan(((SysRoleDataRight)dataRightList.get(0)).getDataScope() == 2 ? "1" : "0");
        organDataAuthorityVo.setSupOrgan(((SysRoleDataRight)dataRightList.get(0)).getDataScope() == 3 ? "1" : "0");
        organDataAuthorityVo.setOnlyIndividuals(((SysRoleDataRight)dataRightList.get(0)).getDataScope() == 4 ? "1" : "0");
        if (((SysRoleDataRight)dataRightList.get(0)).getDataScope() == 5 && HussarUtils.isNotEmpty((Object)(dataRightCustomInfo = this.sysRoleDataRightBoService.selectDataRightCustomInfo(Collections.singletonList(dataRightsId = ((SysRoleDataRight)dataRightList.get(0)).getDataRightsId()))))) {
            DataRightCustomInfoVo infoVo = (DataRightCustomInfoVo)dataRightCustomInfo.get(0);
            organDataAuthorityVo.setSimpleUserVos(infoVo.getUserVos());
            organDataAuthorityVo.setSimpleOrganVos(infoVo.getSimpleOrganVos());
        }
        return ApiResponse.success((Object)organDataAuthorityVo);
    }

    public Map<Long, OrganDataAuthorityVo> listOrganDataAuthorityByAppId(Long appId, Long roleId, Long formId) {
        HashMap<Long, OrganDataAuthorityVo> organDataAuthorityVoMap = new HashMap<Long, OrganDataAuthorityVo>();
        LambdaQueryWrapper wrapperForm = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            wrapperForm.eq(SysForm::getAppId, (Object)appId);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            wrapperForm.eq(SysForm::getId, (Object)formId);
        }
        List sysFormList = this.sysFormService.list((Wrapper)wrapperForm);
        Map formFuncMap = this.sysFunctionsBoService.getFunctionsByResTypeId(appId, roleId, "res_form_rights");
        List funIds = formFuncMap.values().stream().flatMap(Collection::stream).map(SysFunctions::getId).distinct().collect(Collectors.toList());
        ArrayList dataRightList = HussarUtils.isEmpty(funIds) ? new ArrayList() : this.sysRoleDataRightBoService.list(Collections.singletonList(roleId), funIds);
        Map rightMap = dataRightList.stream().collect(Collectors.toMap(SysRoleDataRight::getFunctionId, Function.identity(), (v1, v2) -> v1));
        Map<Object, Object> dataRightCustomInfoMap = new HashMap();
        if (HussarUtils.isNotEmpty(dataRightList)) {
            List dataRightIds = dataRightList.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
            List dataRightCustomInfo = this.sysRoleDataRightBoService.selectDataRightCustomInfo(dataRightIds);
            dataRightCustomInfoMap = dataRightCustomInfo.stream().collect(Collectors.toMap(DataRightCustomInfoVo::getDataRightId, Function.identity(), (v1, v2) -> v1));
        }
        for (SysForm sysForm : sysFormList) {
            OrganDataAuthorityVo organDataAuthorityVo = new OrganDataAuthorityVo();
            organDataAuthorityVoMap.put(HussarUtils.toLong((Object)sysForm.getId()), organDataAuthorityVo);
            List functions = (List)formFuncMap.get(sysForm.getId());
            if (HussarUtils.isEmpty((Object)functions)) continue;
            for (SysFunctions function : functions) {
                SysRoleDataRight roleDataRight = (SysRoleDataRight)rightMap.get(function.getId());
                if (HussarUtils.isNotEmpty((Object)roleDataRight)) {
                    DataRightCustomInfoVo vo;
                    organDataAuthorityVo.setAllOrgan(roleDataRight.getDataScope() == 1 ? "1" : "0");
                    organDataAuthorityVo.setSubOrgan(roleDataRight.getDataScope() == 2 ? "1" : "0");
                    organDataAuthorityVo.setSupOrgan(roleDataRight.getDataScope() == 3 ? "1" : "0");
                    organDataAuthorityVo.setOnlyIndividuals(roleDataRight.getDataScope() == 4 ? "1" : "0");
                    if (roleDataRight.getDataScope() != 5 || !HussarUtils.isNotEmpty((Object)(vo = (DataRightCustomInfoVo)dataRightCustomInfoMap.get(roleDataRight.getDataRightsId())))) continue;
                    organDataAuthorityVo.setSimpleUserVos(vo.getUserVos());
                    organDataAuthorityVo.setSimpleOrganVos(vo.getSimpleOrganVos());
                    continue;
                }
                organDataAuthorityVo.setAllOrgan("1");
            }
        }
        return organDataAuthorityVoMap;
    }

    public void prepareOrganDataAuthorityByFormId(List<SysFormRoleAuthVo> result, Long appId, final Long formId) {
        List functionList = this.sysFunctionsBoService.list((List)new ArrayList<Long>(){
            {
                this.add(formId);
            }
        }, appId, "menu_");
        if (HussarUtils.isEmpty((Object)functionList)) {
            return;
        }
        List funIds = functionList.stream().map(SysFunctions::getId).collect(Collectors.toList());
        ArrayList dataRightList = HussarUtils.isEmpty(funIds) ? new ArrayList() : this.sysRoleDataRightBoService.list(null, funIds);
        Map<Object, Object> dataRightCustomInfoMap = new HashMap();
        if (HussarUtils.isNotEmpty(dataRightList)) {
            List dataRightIds = dataRightList.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
            List dataRightCustomInfo = this.sysRoleDataRightBoService.selectDataRightCustomInfo(dataRightIds);
            dataRightCustomInfoMap = dataRightCustomInfo.stream().collect(Collectors.toMap(DataRightCustomInfoVo::getDataRightId, Function.identity(), (v1, v2) -> v1));
        }
        for (SysFormRoleAuthVo formRoleAuthVo : result) {
            OrganDataAuthorityVo organDataAuthorityVo = new OrganDataAuthorityVo();
            formRoleAuthVo.setOrganDataAuthority(organDataAuthorityVo);
            Optional<SysRoleDataRight> dataRightOptional = dataRightList.stream().filter(item -> HussarUtils.equals((Object)formRoleAuthVo.getRoleId(), (Object)item.getRoleId())).findFirst();
            if (dataRightOptional.isPresent()) {
                DataRightCustomInfoVo vo;
                SysRoleDataRight roleDataRight = dataRightOptional.get();
                organDataAuthorityVo.setAllOrgan(roleDataRight.getDataScope() == 1 ? "1" : "0");
                organDataAuthorityVo.setSubOrgan(roleDataRight.getDataScope() == 2 ? "1" : "0");
                organDataAuthorityVo.setSupOrgan(roleDataRight.getDataScope() == 3 ? "1" : "0");
                organDataAuthorityVo.setOnlyIndividuals(roleDataRight.getDataScope() == 4 ? "1" : "0");
                if (roleDataRight.getDataScope() != 5 || !HussarUtils.isNotEmpty((Object)(vo = (DataRightCustomInfoVo)dataRightCustomInfoMap.get(roleDataRight.getDataRightsId())))) continue;
                organDataAuthorityVo.setSimpleUserVos(vo.getUserVos());
                organDataAuthorityVo.setSimpleOrganVos(vo.getSimpleOrganVos());
                continue;
            }
            organDataAuthorityVo.setAllOrgan("1");
        }
    }

    public ApiResponse<OrganDataAuthorityFeignVo> formAuthorityOrganData(Long formId) {
        if (HussarUtils.isEmpty((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        OrganDataAuthorityFeignVo organDataAuthorityFeignVo = new OrganDataAuthorityFeignVo();
        List rolesList = user.getRolesList();
        List functionsList = this.sysFunctionsBoService.list(Collections.singletonList(formId), null, "menu_" + formId);
        if (HussarUtils.isEmpty((Object)functionsList)) {
            return ApiResponse.success((Object)organDataAuthorityFeignVo);
        }
        List funcIds = functionsList.stream().map(SysFunctions::getId).distinct().collect(Collectors.toList());
        List dataRightList = this.sysRoleDataRightBoService.list(rolesList, funcIds);
        if (HussarUtils.isEmpty((Object)dataRightList)) {
            return ApiResponse.success((Object)organDataAuthorityFeignVo);
        }
        List allOrgan = dataRightList.stream().filter(item -> HussarUtils.equals((Object)item.getDataScope(), (Object)1)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(allOrgan)) {
            return ApiResponse.success((Object)organDataAuthorityFeignVo);
        }
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> organIds = new HashSet<Long>();
        this.collectUserIdAndOrganId(user, dataRightList, userIds, organIds);
        organDataAuthorityFeignVo.setOrganIds(organIds);
        organDataAuthorityFeignVo.setUserIds(userIds);
        return ApiResponse.success((Object)organDataAuthorityFeignVo);
    }

    private void collectUserIdAndOrganId(SecurityUser user, List<SysRoleDataRight> dataRightList, Set<Long> userIds, Set<Long> organIds) {
        Object organId = user.getExtendUserMap().get("deptId");
        Set<Object> allSubStruIds = new HashSet();
        if (HussarUtils.isNotEmpty(organId)) {
            List allSubOrgan = this.hussarBaseOrganizationBoService.getAllSubOrgan(Long.valueOf(String.valueOf(organId)));
            allSubStruIds = allSubOrgan.stream().map(OrganVo::getId).map(Long::parseLong).collect(Collectors.toSet());
        }
        for (SysRoleDataRight dataRight : dataRightList) {
            String dataScope = String.valueOf(dataRight.getDataScope());
            if ("4".equals(dataScope)) {
                Long userId = user.getId();
                userIds.add(userId);
                continue;
            }
            if ("3".equals(dataScope) && HussarUtils.isNotEmpty(organId)) {
                organIds.add(Long.valueOf(String.valueOf(organId)));
                continue;
            }
            if (!"2".equals(dataScope) || !HussarUtils.isNotEmpty(organId)) continue;
            organIds.addAll(allSubStruIds);
        }
        List dataRightIdList = dataRightList.stream().map(SysRoleDataRight::getDataRightsId).distinct().collect(Collectors.toList());
        QueryStruRightFeignDto feignDto = new QueryStruRightFeignDto();
        feignDto.setRoleRightIds(dataRightIdList);
        List struRights = this.sysRoleStruRightBoService.listStruRights(feignDto);
        Set struIds = struRights.stream().map(s -> Optional.ofNullable(s).map(SysRoleStruRights::getStruid).orElse(null)).collect(Collectors.toSet());
        organIds.addAll(struIds);
        List userRights = this.sysRoleUserRightBoService.listUserRights(feignDto);
        Set userIdList = userRights.stream().map(s -> Optional.ofNullable(s).map(SysRoleUserRights::getUserId).orElse(null)).collect(Collectors.toSet());
        userIds.addAll(userIdList);
    }
}

