/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.UpgradeMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.enums.AppUpgradeType;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionDetailService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpFormContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpGroupContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpQuickMatchVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpformMappingVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ChildWidgetVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysFormWithChildren;
import com.jxdinfo.hussar.formdesign.application.application.vo.UpgradeStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.application.util.AppIoUtil;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppUpgradeServiceImpl")
public class AppUpgradeServiceImpl
implements IAppUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppUpgradeServiceImpl.class);
    private static final String UPGRADE_OPERTYPE = "0";
    private static final String UPGRADE_ROLLBACK = "1";
    private static final String FORM_DESIGN_TYPE = "free";
    @Resource
    private CanvasService canvasService;
    @Resource
    private IAppImportService appImportService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysApplicationVersionService sysApplicationVersionService;
    @Resource
    private IAppExportService appExportService;
    @Resource
    private ISysApplicationVersionDetailService sysApplicationVersionDetailService;
    @Resource
    private IAppUpgradeInfoService appUpgradeInfoService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private IFormUpgradeThreadService formUpgradeThreadService;
    @Resource
    private IFormUpgradeInfoService formUpgradeInfoService;

    public ApiResponse<AppUpAttachmentParseVo> analyzeUpgradePackage(MultipartFile file) {
        String localPath;
        Long fileId;
        try {
            fileId = this.appFileExtendService.fileDecryptAndUpload(file);
            localPath = this.appFileExtendService.downloadAndUnzip(fileId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = this.formUpgradeInfoService.getUnZipPathByLocalPath(localPath);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        AppExportMetaDto appExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, AppExportMetaDto.class);
        String formPath = FileUtil.posixPath((String[])new String[]{unZipPath, "appConfig" + File.separator + "app.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(formPath, JSONObject.class);
        if (HussarUtils.isEmpty((Object)jsonObject)) {
            throw new BaseException("\u8bfb\u53d6\u5e94\u7528\u5347\u7ea7\u5305\u5931\u8d25");
        }
        Object object = jsonObject.get((Object)"appInfo");
        JSONObject app = (JSONObject)object;
        if (HussarUtils.isEmpty((Object)app)) {
            throw new BaseException("\u8bfb\u53d6\u5e94\u7528\u4fe1\u606f\u5931\u8d25");
        }
        if (appExportMetaDto == null || HussarUtils.isEmpty((Object)appExportMetaDto.getAppName())) {
            return ApiResponse.fail((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u5e94\u7528\u6587\u4ef6");
        }
        AppUpAttachmentParseVo appAttachmentParseVo = new AppUpAttachmentParseVo();
        appAttachmentParseVo.setFileId(fileId);
        appAttachmentParseVo.setPath(unZipPath);
        appAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)appExportMetaDto.getPassword()));
        appAttachmentParseVo.setAppName(appExportMetaDto.getAppName());
        return ApiResponse.success((Object)appAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(AppUpgradeDto appUpgradeDto) {
        appUpgradeDto.setPath(appUpgradeDto.getPath());
        return this.appImportService.verifyPassword((AppImportDto)appUpgradeDto);
    }

    public ApiResponse<List<AppUpGroupContrast>> contrastForm(AppUpgradeDto appUpgradeDto) {
        SysApplication upgradeApp = AppIoUtil.readDataByKey(appUpgradeDto.getPath(), "app", "appInfo", SysApplication.class);
        AssertUtil.isNotNull((Object)upgradeApp, (String)"\u5347\u7ea7\u5e94\u7528\u4e0d\u5b58\u5728");
        List<SysFormGroupVo> sysFormGroupVoList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "formGroups", SysFormGroupVo.class);
        List<SysFormVo> sysFormVoList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "forms", SysFormVo.class);
        SysSiftGroupList upgradeSiftGroup = this.combinedData(sysFormVoList, sysFormGroupVoList);
        List<FormSchema> formSchemas = AppIoUtil.readMidFiles(appUpgradeDto.getPath(), String.valueOf(upgradeApp.getId()));
        Map<String, FormCanvasSchema> upgradeCanvasMap = formSchemas.stream().map(FormSchema::getFormCanvas).collect(Collectors.toMap(BaseForm::getId, Function.identity()));
        List<AppUpGroupVo> upgradeGroupList = this.convertToGroupVo(upgradeSiftGroup, upgradeCanvasMap);
        List<AppUpGroupVo> currentGroupList = this.listFormGroupByAppId(appUpgradeDto.getCurrentAppId());
        List<AppUpGroupContrast> appUpGroupContrastList = this.contrastGroup(currentGroupList, upgradeGroupList);
        return ApiResponse.success(appUpGroupContrastList);
    }

    public SysSiftGroupList combinedData(List<SysFormVo> sysFormList, List<SysFormGroupVo> sysFormGroups) {
        ArrayList<SysForm> noGroupList = new ArrayList<SysForm>();
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysFormGroups), SysFormGroupVo.class).stream().distinct().collect(Collectors.toMap(SysFormGroup::getId, sysFormGroupVo -> sysFormGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            SysFormGroupVo sysFormGroupVo2 = (SysFormGroupVo)resultCollect.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)sysFormGroupVo2)) {
                noGroupList.add(sysForm);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)sysFormGroupVo2.getSysFormList())) {
                sysFormGroupVo2.getSysFormList().add(sysForm);
            }
            if (!HussarUtils.isEmpty((Object)sysFormGroupVo2.getSysFormList())) continue;
            ArrayList<SysForm> formGroupList = new ArrayList<SysForm>();
            formGroupList.add(sysForm);
            sysFormGroupVo2.setSysFormList(formGroupList);
        }
        sysSiftGroupList.setHaveGroupList(new ArrayList(resultCollect.values()));
        sysSiftGroupList.setNoGroupList(noGroupList);
        return sysSiftGroupList;
    }

    public List<AppUpGroupVo> listFormGroupByAppId(Long appId) {
        AssertUtil.isNotNull((Object)appId, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        SysSiftGroupList sysSiftGroupList = this.sysFormService.getFormList(null, null, null, appId);
        List sysFormList = this.sysFormService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        sysFormList = sysFormList.stream().filter(s -> !"2".equals(s.getFormType()) && !"3".equals(s.getFormType())).collect(Collectors.toList());
        Map<String, FormCanvasSchema> canvasSchemaMap = sysFormList.stream().map(sysForm -> {
            try {
                return (FormCanvasSchema)this.canvasService.get(String.valueOf(sysForm.getId())).getData();
            }
            catch (Exception e) {
                throw new HussarException("\u753b\u5e03\u83b7\u53d6\u5931\u8d25");
            }
        }).collect(Collectors.toMap(BaseForm::getId, Function.identity()));
        return this.convertToGroupVo(sysSiftGroupList, canvasSchemaMap);
    }

    public List<AppUpGroupContrast> contrastGroup(List<AppUpGroupVo> currentGroupList, List<AppUpGroupVo> targetGroupList) {
        ArrayList<AppUpGroupContrast> groupContrastList = new ArrayList<AppUpGroupContrast>();
        currentGroupList = Optional.ofNullable(currentGroupList).orElse(new ArrayList());
        targetGroupList = Optional.ofNullable(targetGroupList).orElse(new ArrayList());
        List<SysFormWithChildren> targetAllFormByGroup = this.getAllFormByGroup(targetGroupList);
        HashSet allFormIdentifierSet = Sets.newHashSetWithExpectedSize((int)5);
        Iterator iteratorcurrentGroup = currentGroupList.iterator();
        while (iteratorcurrentGroup.hasNext()) {
            AppUpGroupVo currentGroup = (AppUpGroupVo)iteratorcurrentGroup.next();
            if (CollectionUtils.isEmpty((Collection)currentGroup.getFormList())) continue;
            HashSet formIdentifierCurrentGroupSet = Sets.newHashSetWithExpectedSize((int)5);
            int currentGroupFormSize = currentGroup.getFormList().size();
            Iterator iteratorCurrentForm = currentGroup.getFormList().iterator();
            while (iteratorCurrentForm.hasNext()) {
                SysFormWithChildren currentform = (SysFormWithChildren)iteratorCurrentForm.next();
                boolean exsitNotEqFormIdentifier = false;
                for (SysFormWithChildren targetForm : targetAllFormByGroup) {
                    if (!currentform.getId().equals(targetForm.getId()) || FORM_DESIGN_TYPE.equals(targetForm.getDesignType()) || "3".equals(targetForm.getFormType())) continue;
                    AppUpFormContrast contrastForm = this.contrastFormByEqFormIdentifier(currentform, targetForm);
                    formIdentifierCurrentGroupSet.add(currentform.getId());
                    Map currentGroupIdMap = groupContrastList.stream().collect(Collectors.toMap(AppUpGroupContrast::getCurrentGroupId, Function.identity()));
                    if (currentGroupIdMap.containsKey(currentform.getFormGroupId())) {
                        ((AppUpGroupContrast)currentGroupIdMap.get(currentform.getFormGroupId())).getFormContrastList().add(contrastForm);
                    } else {
                        ArrayList formContrasts = Lists.newArrayListWithCapacity((int)1);
                        formContrasts.add(contrastForm);
                        groupContrastList.add(new AppUpGroupContrast.Builder().currentGroupId(currentform.getFormGroupId()).targetGroupId(targetForm.getFormGroupId()).groupName(currentform.getFormGroupName()).upgradeType(AppUpgradeType.HALF_COVER.getName()).formContrastList((List)formContrasts).build());
                    }
                    exsitNotEqFormIdentifier = true;
                    break;
                }
                if (!exsitNotEqFormIdentifier) continue;
                iteratorCurrentForm.remove();
            }
            if (currentGroupFormSize == formIdentifierCurrentGroupSet.size()) {
                iteratorcurrentGroup.remove();
            }
            allFormIdentifierSet.addAll(formIdentifierCurrentGroupSet);
        }
        for (AppUpGroupVo targetGroup : targetGroupList) {
            ArrayList<AppUpFormContrast> formContrastList = new ArrayList<AppUpFormContrast>();
            for (SysFormWithChildren targetForm : targetGroup.getFormList()) {
                if (allFormIdentifierSet.contains(targetForm.getId()) || FORM_DESIGN_TYPE.equals(targetForm.getDesignType()) || "3".equals(targetForm.getFormType())) continue;
                formContrastList.add(new AppUpFormContrast.Builder().targetId(targetForm.getId()).targetTitle(targetForm.getFormName()).upgradeType(AppUpgradeType.ADD.getName()).targetFormType(targetForm.getFormType()).build());
            }
            if (!CollectionUtil.isNotEmpty(formContrastList)) continue;
            Map<String, List<AppUpGroupContrast>> currentGroupNameMap = groupContrastList.stream().collect(Collectors.groupingBy(AppUpGroupContrast::getGroupName));
            if (currentGroupNameMap.containsKey(targetGroup.getGroupName())) {
                currentGroupNameMap.get(targetGroup.getGroupName()).get(0).getFormContrastList().addAll(formContrastList);
                continue;
            }
            groupContrastList.add(new AppUpGroupContrast.Builder().targetGroupId(targetGroup.getId()).groupName(targetGroup.getGroupName()).upgradeType(AppUpgradeType.ADD.getName()).formContrastList(formContrastList).build());
        }
        return groupContrastList;
    }

    private AppUpFormContrast getContrastFormByCurrentForm(SysFormWithChildren currentForm) {
        AppUpFormContrast formContrast = new AppUpFormContrast.Builder().currentId(currentForm.getId()).currentTitle(currentForm.getFormName()).upgradeType(AppUpgradeType.NO_OPS.getName()).currentFormType(currentForm.getFormType()).build();
        return formContrast;
    }

    public ApiResponse<AppUpQuickMatchVo> quickMatch(AppUpgradeDto appUpgradeDto) {
        AppUpQuickMatchVo quickMatchVo = new AppUpQuickMatchVo();
        ApiResponse<List<AppUpGroupContrast>> listApiResponse = this.contrastForm(appUpgradeDto);
        List groupContrasts = (List)listApiResponse.getData();
        ArrayList upgradeForm = Lists.newArrayListWithCapacity((int)5);
        ArrayList addForm = Lists.newArrayListWithCapacity((int)5);
        for (AppUpGroupContrast groupContrast : groupContrasts) {
            if (CollectionUtils.isEmpty((Collection)groupContrast.getFormContrastList())) continue;
            ArrayList upgradeFormContrastList = Lists.newArrayListWithCapacity((int)5);
            ArrayList addFormContrastList = Lists.newArrayListWithCapacity((int)5);
            for (AppUpFormContrast formContrast : groupContrast.getFormContrastList()) {
                if (AppUpgradeType.ADD.getName().equals(formContrast.getUpgradeType())) {
                    addFormContrastList.add(formContrast);
                    continue;
                }
                if (!AppUpgradeType.HALF_COVER.getName().equals(formContrast.getUpgradeType())) continue;
                upgradeFormContrastList.add(formContrast);
            }
            if (CollectionUtil.isNotEmpty((Collection)upgradeFormContrastList)) {
                AppUpGroupContrast upgradeGroupNew = this.getUpgradeGroupNew(groupContrast);
                upgradeGroupNew.setFormContrastList((List)upgradeFormContrastList);
                upgradeForm.add(upgradeGroupNew);
            }
            if (!CollectionUtil.isNotEmpty((Collection)addFormContrastList)) continue;
            AppUpGroupContrast addGroupNew = this.getUpgradeGroupNew(groupContrast);
            addGroupNew.setFormContrastList((List)addFormContrastList);
            addForm.add(addGroupNew);
        }
        quickMatchVo.setAddForm((List)addForm);
        quickMatchVo.setUpgradeForm((List)upgradeForm);
        quickMatchVo.setFormContrast(groupContrasts);
        return ApiResponse.success((Object)quickMatchVo);
    }

    @NotNull
    private AppUpGroupContrast getUpgradeGroupNew(AppUpGroupContrast groupContrast) {
        return new AppUpGroupContrast.Builder().currentGroupId(groupContrast.getCurrentGroupId()).targetGroupId(groupContrast.getTargetGroupId()).groupName(groupContrast.getGroupName()).upgradeType(groupContrast.getUpgradeType()).build();
    }

    private List<SysFormWithChildren> getAllFormByGroup(List<AppUpGroupVo> groupVoList) {
        ArrayList allFormList = Lists.newArrayListWithCapacity((int)5);
        for (AppUpGroupVo groupVo : groupVoList) {
            if (!CollectionUtil.isNotEmpty((Collection)groupVo.getFormList())) continue;
            allFormList.addAll(groupVo.getFormList());
        }
        return allFormList;
    }

    private AppUpFormContrast contrastFormByEqFormIdentifier(SysFormWithChildren currentForm, SysFormWithChildren targetForm) {
        String currentTitle = currentForm.getFormName();
        String targetTitle = targetForm.getFormName();
        AppUpFormContrast formContrast = new AppUpFormContrast.Builder().currentId(currentForm.getId()).targetId(targetForm.getId()).currentTitle(currentTitle).targetTitle(targetTitle).upgradeType(AppUpgradeType.HALF_COVER.getName()).currentFormType(currentForm.getFormType()).targetFormType(targetForm.getFormType()).build();
        return formContrast;
    }

    private List<AppUpGroupVo> convertToGroupVo(SysSiftGroupList siftGroupList, Map<String, FormCanvasSchema> canvasSchemaMap) {
        ArrayList<AppUpGroupVo> appUpGroupVoList = new ArrayList<AppUpGroupVo>();
        if (HussarUtils.isEmpty((Object)siftGroupList)) {
            return appUpGroupVoList;
        }
        if (HussarUtils.isNotEmpty((Object)siftGroupList.getNoGroupList())) {
            AppUpGroupVo noGroup = new AppUpGroupVo();
            noGroup.setGroupName("\u672a\u5206\u7ec4");
            appUpGroupVoList.add(noGroup);
            for (SysForm sysForm : siftGroupList.getNoGroupList()) {
                SysFormWithChildren sysFormWithChildren = new SysFormWithChildren();
                BeanUtils.copyProperties((Object)sysForm, (Object)sysFormWithChildren);
                sysFormWithChildren.setFormGroupName("\u672a\u5206\u7ec4");
                if (UPGRADE_OPERTYPE.equals(sysForm.getFormType()) || UPGRADE_ROLLBACK.equals(sysForm.getFormType())) {
                    List childTableList = Optional.ofNullable(canvasSchemaMap.get(String.valueOf(sysForm.getId()))).map(FormCanvasSchema::childTables).map(childTables -> childTables.stream().map(widget -> (ChildWidgetVo)BeanUtil.copy((Object)widget, ChildWidgetVo.class)).collect(Collectors.toList())).orElse(new ArrayList());
                    sysFormWithChildren.setChildren(childTableList);
                }
                noGroup.getFormList().add(sysFormWithChildren);
            }
        }
        for (SysFormGroupVo sysFormGroupVo : siftGroupList.getHaveGroupList()) {
            List sysFormList = sysFormGroupVo.getSysFormList();
            AppUpGroupVo appUpGroupVo = new AppUpGroupVo();
            appUpGroupVoList.add(appUpGroupVo);
            BeanUtils.copyProperties((Object)sysFormGroupVo, (Object)appUpGroupVo);
            if (!HussarUtils.isNotEmpty((Object)sysFormList)) continue;
            for (SysForm sysForm : sysFormList) {
                SysFormWithChildren sysFormWithChildren = new SysFormWithChildren();
                BeanUtils.copyProperties((Object)sysForm, (Object)sysFormWithChildren);
                sysFormWithChildren.setFormGroupName(sysFormGroupVo.getGroupName());
                List childTableList = Optional.ofNullable(canvasSchemaMap.get(String.valueOf(sysForm.getId()))).map(FormCanvasSchema::childTables).map(childTables -> childTables.stream().map(widget -> (ChildWidgetVo)BeanUtil.copy((Object)widget, ChildWidgetVo.class)).collect(Collectors.toList())).orElse(new ArrayList());
                sysFormWithChildren.setChildren(childTableList);
                appUpGroupVo.getFormList().add(sysFormWithChildren);
            }
        }
        return appUpGroupVoList;
    }

    public ApiResponse<String> execute(AppUpgradeDto appUpgradeDto) {
        String upgradeTaskId = String.valueOf(UUID.randomUUID());
        TransmittableThreadLocalHolder.set((String)"upgradeCacheKey", (Object)upgradeTaskId);
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        appUpgradeDto.setOperType(UPGRADE_OPERTYPE);
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (Exception e) {
            LOGGER.error("DataModelUtil.getDataSourceConfigByName\u6570\u636e\u6e90\u5f02\u5e38\uff1a" + e);
        }
        HussarNoCodeThreadUtil.executeUserTask(() -> {
            try {
                LOGGER.info("\u5e94\u7528\u5347\u7ea7[{}] ===============> \u5f00\u59cb\u6267\u884c...", (Object)appUpgradeDto.getCurrentAppId());
                long startTime = System.currentTimeMillis();
                String appStatusOld = this.sysApplicationVersionService.updateAppLock(appUpgradeDto.getCurrentAppId());
                IAppUpgradeService upgradeService = (IAppUpgradeService)SpringUtil.getBean(IAppUpgradeService.class);
                upgradeService.executeStart(appUpgradeDto, loginUser, dataSourceKey);
                this.sysApplicationVersionService.updateAppRestore(appUpgradeDto.getCurrentAppId(), appStatusOld);
                LOGGER.info("\u5e94\u7528\u5347\u7ea7[{}] ==============> \u7ed3\u675f,\u8017\u65f6{}ms...", (Object)appUpgradeDto.getCurrentAppId(), (Object)(System.currentTimeMillis() - startTime));
            }
            catch (Exception e) {
                HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeTaskId, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(5)).msg("\u5347\u7ea7\u5f02\u5e38\uff1a" + e.getMessage()).finishFlag(Boolean.TRUE).errorFlag(Boolean.TRUE).build());
                e.printStackTrace();
            }
        });
        return ApiResponse.success((Object)upgradeTaskId, (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    @HussarDs(value="#dataSourceKey")
    public void executeStart(AppUpgradeDto appUpgradeDto, SecurityUser loginUser, String dataSourceKey) {
        UpgradeMappingDto upgradeMappingDto = this.initUpgradeMapping(appUpgradeDto);
        this.executeUpgradeProcess(appUpgradeDto, upgradeMappingDto, loginUser, dataSourceKey);
    }

    public ApiResponse<AppUpformMappingVo> formMapping(AppUpgradeDto appUpgradeDto) {
        AppUpformMappingVo mappingVo = new AppUpformMappingVo();
        ApiResponse<List<AppUpGroupContrast>> listApiResponse = this.contrastForm(appUpgradeDto);
        List groupContrasts = (List)listApiResponse.getData();
        mappingVo.setFormContrast(groupContrasts);
        return ApiResponse.success((Object)mappingVo);
    }

    public void executeUpgradeProcess(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto, SecurityUser loginUser, String dataSourceKey) {
        try {
            String upgradeCacheKey = (String)TransmittableThreadLocalHolder.get((String)"upgradeCacheKey");
            HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(1)).msg("\u5e94\u7528\u5907\u4efd\u4e2d...").finishFlag(Boolean.valueOf(false)).build());
            this.handleAppBack(appUpgradeDto, loginUser, dataSourceKey);
            HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(2)).msg("\u5347\u7ea7\u5e94\u7528...").finishFlag(Boolean.valueOf(false)).build());
            this.appUpgradeInfoService.upgradeApp(appUpgradeDto, upgradeMappingDto);
            HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(3)).msg("\u5347\u7ea7\u5206\u7ec4...").finishFlag(Boolean.valueOf(false)).build());
            this.appUpgradeInfoService.upgradeGroup(appUpgradeDto, upgradeMappingDto);
            List<SysForm> upgradeFormList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "forms", SysForm.class);
            Map upgradeFormIdMap = upgradeFormList.stream().collect(Collectors.toMap(SysForm::getId, Function.identity()));
            List currentSysForms = this.sysFormService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)upgradeMappingDto.getCurrentAppId()));
            Map currentFormMap = currentSysForms.stream().collect(Collectors.toMap(SysForm::getId, Function.identity()));
            String dataSourceName = DataModelUtil.currentDsName();
            List upgradeAndAddForm = upgradeMappingDto.getUpgradeAndAddForm();
            LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u5347\u7ea7\u7684\u8868\u5355\u4fe1\u606f\u3010{}\u3011:", (Object)appUpgradeDto.getCurrentAppId(), (Object)JSON.toJSONString((Object)upgradeAndAddForm));
            for (AppUpFormContrast formContrast : upgradeAndAddForm) {
                SysForm upgradeForm = (SysForm)upgradeFormIdMap.get(formContrast.getTargetId());
                if (AppUpgradeType.ADD.getName().equals(formContrast.getUpgradeType())) {
                    HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(4)).msg("\u5347\u7ea7\u8868\u5355\u3010" + upgradeForm.getFormName() + "\u3011...").finishFlag(Boolean.valueOf(false)).build());
                    SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)upgradeForm.getId());
                    if (HussarUtils.isNotEmpty((Object)sysForm)) {
                        LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u8868\u5355\u5bfc\u5165-\u8868\u5355ID\u3010{}\u3011\u5f00\u59cb", (Object)appUpgradeDto.getCurrentAppId(), (Object)upgradeForm.getId());
                        this.appUpgradeInfoService.importForm(upgradeForm, appUpgradeDto, formContrast);
                        LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u8868\u5355\u5bfc\u5165-\u8868\u5355ID\u3010{}\u3011\u7ed3\u675f", (Object)appUpgradeDto.getCurrentAppId(), (Object)upgradeForm.getId());
                        continue;
                    }
                    Optional tableInfo = DataModelUtil.filterTable((String)dataSourceName, (String)"BASE TABLE", (String)upgradeForm.getTableName());
                    if (tableInfo.isPresent()) {
                        LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u5e93\u8868\u65b0\u5efa-\u8868\u5355ID\u3010{}\u3011\u5f00\u59cb", (Object)appUpgradeDto.getCurrentAppId(), (Object)upgradeForm.getId());
                        this.appUpgradeInfoService.createByTable(upgradeForm, appUpgradeDto, formContrast);
                        LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u5e93\u8868\u65b0\u5efa-\u8868\u5355ID\u3010{}\u3011\u7ed3\u675f", (Object)appUpgradeDto.getCurrentAppId(), (Object)upgradeForm.getId());
                        continue;
                    }
                    LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u8868\u5355\u5347\u7ea7-\u8868\u5355ID\u3010{}\u3011\u5f00\u59cb", (Object)appUpgradeDto.getCurrentAppId(), (Object)upgradeForm.getId());
                    this.appUpgradeInfoService.upgradeForm(upgradeForm, appUpgradeDto, formContrast);
                    LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u8868\u5355\u5347\u7ea7-\u8868\u5355ID\u3010{}\u3011\u7ed3\u675f", (Object)appUpgradeDto.getCurrentAppId(), (Object)upgradeForm.getId());
                    continue;
                }
                if (!AppUpgradeType.MERGE.getName().equals(formContrast.getUpgradeType()) && !AppUpgradeType.HALF_COVER.getName().equals(formContrast.getUpgradeType())) continue;
                SysForm currentForm = (SysForm)currentFormMap.get(formContrast.getCurrentId());
                HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(4)).msg("\u5347\u7ea7\u8868\u5355\u3010" + currentForm.getFormName() + "\u3011...").finishFlag(Boolean.valueOf(false)).build());
                LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u5347\u7ea7\u65b9\u5f0f\u3010{}\u3011,\u5347\u7ea7\u8868\u5355ID\u3010{}\u3011\u5f00\u59cb", new Object[]{appUpgradeDto.getCurrentAppId(), formContrast.getUpgradeType(), currentForm.getId()});
                this.appUpgradeInfoService.upgradeForm(upgradeForm, currentForm, formContrast, appUpgradeDto);
                LOGGER.info("\u5e94\u7528ID\u3010{}\u3011\uff0c\u5347\u7ea7\u65b9\u5f0f\u3010{}\u3011,\u5347\u7ea7\u8868\u5355ID\u3010{}\u3011\u7ed3\u675f", new Object[]{appUpgradeDto.getCurrentAppId(), formContrast.getUpgradeType(), currentForm.getId()});
            }
            HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(5)).msg("\u8bb0\u5f55\u5347\u7ea7\u7248\u672c...").finishFlag(Boolean.valueOf(false)).build());
            this.appUpgradeInfoService.saveUpgradeVersion(appUpgradeDto, upgradeMappingDto);
            HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(5)).msg("\u5347\u7ea7\u5b8c\u6210").finishFlag(Boolean.valueOf(true)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5e94\u7528\u5347\u7ea7\u5931\u8d25!", (Throwable)e);
            throw new HussarException(e.getMessage());
        }
    }

    private void handleAppBack(AppUpgradeDto appUpgradeDto, SecurityUser loginUser, String dataSourceKey) {
        if (!UPGRADE_OPERTYPE.equals(appUpgradeDto.getOperType())) {
            return;
        }
        LOGGER.info("\u5907\u4efd\u5e94\u7528\u5305\u5f00\u59cb\u3010{}\u3011...", (Object)appUpgradeDto.getCurrentAppId());
        Long appId = appUpgradeDto.getCurrentAppId();
        AppExportDto exportDto = new AppExportDto();
        exportDto.setAppId(appUpgradeDto.getCurrentAppId());
        exportDto.setExportDataFlag(false);
        exportDto.setExportPwd("");
        exportDto.setAppAuthRoleIds((List)Lists.newArrayListWithCapacity((int)0));
        exportDto.setFormAuthRoleIds((List)Lists.newArrayListWithCapacity((int)0));
        exportDto.setFlowAuthRoleIds((List)Lists.newArrayListWithCapacity((int)0));
        Long appPackageId = null;
        try {
            appPackageId = this.appExportService.exportExecute(exportDto, loginUser.getId(), dataSourceKey);
            appUpgradeDto.setBackFileId(appPackageId);
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u5347\u7ea7\u3010{}\u3011,\u5907\u4efd\u5e94\u7528\u5305\u5931\u8d25.", (Object)appId);
            e.printStackTrace();
            throw new HussarException("\u5e94\u7528\u5347\u7ea7,\u5907\u4efd\u5e94\u7528\u5305\u5931\u8d25");
        }
        LOGGER.info("\u5907\u4efd\u5e94\u7528\u5305\u7ed3\u675f\u3010{}\u3011...", (Object)appUpgradeDto.getCurrentAppId());
    }

    private UpgradeMappingDto initUpgradeMapping(AppUpgradeDto appUpgradeDto) {
        UpgradeMappingDto upgradeMappingDto = new UpgradeMappingDto();
        List upGroupContrastList = appUpgradeDto.getUpGroupContrastList();
        HashMap formGroupIdMap = Maps.newHashMapWithExpectedSize((int)5);
        ArrayList addGroup = Lists.newArrayListWithCapacity((int)5);
        ArrayList upgradeAndAddForm = Lists.newArrayListWithCapacity((int)5);
        for (AppUpGroupContrast group : upGroupContrastList) {
            if (AppUpgradeType.HALF_COVER.getName().equals(group.getUpgradeType())) {
                formGroupIdMap.put(group.getTargetGroupId(), group.getCurrentGroupId());
            } else if (AppUpgradeType.ADD.getName().equals(group.getUpgradeType())) {
                addGroup.add(group);
            }
            for (AppUpFormContrast form : group.getFormContrastList()) {
                if (AppUpgradeType.NO_OPS.equals(form.getUpgradeType())) continue;
                upgradeAndAddForm.add(form);
            }
        }
        upgradeMappingDto.setAddGroup((List)addGroup);
        upgradeMappingDto.setFormGroupIdMap((Map)formGroupIdMap);
        upgradeMappingDto.setUpgradeAndAddForm((List)upgradeAndAddForm);
        return upgradeMappingDto;
    }

    public ApiResponse<UpgradeStatusVo> getUpgradeProgress(String taskId) {
        UpgradeStatusVo statusVo = (UpgradeStatusVo)HussarCacheUtil.get((String)"upgrade_progress", (Object)taskId);
        return ApiResponse.success((Object)statusVo);
    }
}

