/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.controller;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.WaterMarkComponent;
import com.jxdinfo.hussar.formdesign.application.print.dto.SubWordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.dto.SysPrintTemplateDto;
import com.jxdinfo.hussar.formdesign.application.print.dto.WordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.model.SysWordPrintTask;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintTemplateVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/hussarNoCode/print"})
public class SysPrintTemplateController {
    @Resource
    private ISysPrintTemplateService printTemplateService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private WaterMarkComponent waterMarkComponent;

    @GetMapping(value={"/getWaterMark"})
    @ApiOperation(value="\u83b7\u53d6\u6253\u5370\u6c34\u5370", notes="\u83b7\u53d6\u6253\u5370\u6c34\u5370")
    public ApiResponse<String> getWaterMark(@ApiParam(value="\u5e94\u7528id") @RequestParam Long appId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        UserDetails userDetails = new UserDetails();
        userDetails.setUserId(user.getId());
        String mark = this.waterMarkComponent.getWaterMark(appId, userDetails);
        String replaceMark = mark.replace("\n", " ");
        return ApiResponse.success((Object)replaceMark, (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/initExcelTemp"})
    @ApiOperation(value="\u521d\u59cb\u5316\u7cfb\u7edf\u6253\u5370\u6a21\u677f", notes="\u521d\u59cb\u5316excel\u5bfc\u51fa\u6a21\u677f")
    public ApiResponse<SysPrintTemplateVo> initExcelTemp(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId) {
        return this.printTemplateService.initExcelTemp(formId);
    }

    @PostMapping(value={"/initStandardTemp"})
    @ApiOperation(value="\u521d\u59cb\u5316\u6807\u51c6\u5bfc\u5165\u6a21\u677f", notes="\u521d\u59cb\u5316\u6807\u51c6\u5bfc\u5165\u6a21\u677f")
    public ApiResponse<SysPrintTemplateVo> initStandardTemp(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId) {
        return this.printTemplateService.initStandardTemp(formId);
    }

    @PostMapping(value={"/initSysTemp"})
    @ApiOperation(value="\u521d\u59cb\u5316\u7cfb\u7edf\u6253\u5370\u6a21\u677f", notes="\u521d\u59cb\u5316\u7cfb\u7edf\u6253\u5370\u6a21\u677f")
    public ApiResponse<SysPrintTemplateVo> initSysTemp(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId) {
        return this.printTemplateService.initSysTemp(formId);
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u6253\u5370\u6a21\u677f", notes="\u65b0\u589e\u6253\u5370\u6a21\u677f")
    public ApiResponse<Long> create(@ApiParam(value="\u6253\u5370\u6a21\u677fdto") @RequestBody SysPrintTemplateDto sysPrintTemplateDto) {
        return this.printTemplateService.create(sysPrintTemplateDto);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6253\u5370\u6a21\u677f", notes="\u4fee\u6539\u6253\u5370\u6a21\u677f")
    public ApiResponse<Boolean> update(@ApiParam(value="\u6253\u5370\u6a21\u677fdto") @RequestBody SysPrintTemplateDto sysPrintTemplateDto) {
        return this.printTemplateService.update(sysPrintTemplateDto);
    }

    @PostMapping(value={"/enable"})
    @ApiOperation(value="\u4fee\u6539\u6a21\u677f\u542f\u7528\u72b6\u6001", notes="\u542f\u7528\u6216\u7981\u7528\u6a21\u677f")
    public ApiResponse<Boolean> enable(@ApiParam(value="\u6253\u5370\u6a21\u677fdto") @RequestBody SysPrintTemplateDto sysPrintTemplateDto) {
        return this.printTemplateService.update(sysPrintTemplateDto);
    }

    @PostMapping(value={"/setting/update"})
    @ApiOperation(value="\u4fee\u6539\u6253\u5370\u6a21\u677f\u8bbe\u7f6e", notes="\u4fee\u6539\u6a21\u677f\u7684\u4f7f\u7528\u8303\u56f4\u3001\u53ef\u89c1\u8303\u56f4\u3001\u751f\u6210\u6587\u4ef6\u540d")
    public ApiResponse<Boolean> updatePrintSetting(@ApiParam(value="\u6253\u5370\u6a21\u677fdto") @RequestBody SysPrintTemplateDto sysPrintTemplateDto) {
        return this.printTemplateService.update(sysPrintTemplateDto);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6253\u5370\u6a21\u677f", notes="\u6839\u636e\u6a21\u677fid\u5220\u9664")
    public ApiResponse<Boolean> delete(@ApiParam(value="\u6253\u5370\u6a21\u677fid") @RequestBody SysPrintTemplateDto sysPrintTemplateDto) {
        return this.printTemplateService.deleteByPrintId(sysPrintTemplateDto);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u83b7\u53d6\u6253\u5370\u6a21\u677f\u8be6\u60c5", notes="\u83b7\u53d6\u6253\u5370\u6a21\u677f\u8be6\u60c5")
    public ApiResponse<SysPrintTemplateVo> detail(@ApiParam(value="\u6253\u5370\u6a21\u677fid") @RequestParam Long id) {
        return this.printTemplateService.detailById(id);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868", notes="\u8fd4\u56de\u6240\u6709\u6a21\u677f")
    public ApiResponse<List<SysPrintTemplateVo>> list(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u5bfc\u51fa\u7c7b\u578b") @RequestParam(required=false) String exportType) {
        return this.printTemplateService.listByFormId(formId, exportType);
    }

    @GetMapping(value={"/listAvailable"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u53ef\u7528\u7684\u6253\u5370\u6a21\u677f\u5217\u8868", notes="\u9a8c\u8bc1\u6388\u6743\u4fe1\u606f\u4ee5\u53ca\u6a21\u677f\u542f\u7528\u72b6\u6001")
    public ApiResponse<List<SysPrintTemplateVo>> listAvailable(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u5bfc\u51fa\u7c7b\u578b") @RequestParam(required=false) String exportType) {
        return this.printTemplateService.listAvailableByFormId(formId, exportType);
    }

    @GetMapping(value={"/formQuery"})
    @ApiOperation(value="\u8868\u5355\u6570\u636e\u67e5\u8be2", notes="\u8868\u5355\u6570\u636e\u67e5\u8be2")
    public ResponseEntity<ApiResponse<Object>> formQuery(@RequestParam String formId, @RequestParam String id, @RequestParam(required=false) String tabType, @RequestParam(required=false) String appId) {
        return this.printTemplateService.formQuery(formId, id, tabType, appId);
    }

    @PostMapping(value={"/wordHandle"})
    @ApiOperation(value="word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5904\u7406", notes="word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5904\u7406")
    public ApiResponse<Long> wordHandle(@ApiParam(value="word\u6253\u5370\u6a21\u677f\u5b9e\u4f53") @RequestBody WordPrintParamsDto wordPrintParamsDto) {
        return this.printTemplateService.wordPrint(wordPrintParamsDto);
    }

    @PostMapping(value={"/wordHandleBatch"})
    @ApiOperation(value="word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5904\u7406", notes="word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5904\u7406")
    public ApiResponse<Long> wordHandleBatch(@ApiParam(value="word\u6253\u5370\u6a21\u677f\u5b9e\u4f53") @RequestBody WordPrintParamsDto wordPrintParamsDto) {
        return this.printTemplateService.wordHandleBatch(wordPrintParamsDto);
    }

    @PostMapping(value={"/childWordHandleBatch"})
    @ApiOperation(value="\u5b50\u8868word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5904\u7406", notes="\u5b50\u8868word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5904\u7406")
    public ApiResponse<Long> childWordHandleBatch(@ApiParam(value="\u5b50\u8868word\u6253\u5370\u6a21\u677f\u5b9e\u4f53") @RequestBody SubWordPrintParamsDto wordPrintParamsDto) {
        return this.printTemplateService.childWordHandleBatch(wordPrintParamsDto);
    }

    @GetMapping(value={"/getTaskDetail"})
    @ApiOperation(value="\u83b7\u53d6word\u6253\u5370\u6a21\u677f\u4efb\u52a1\u8be6\u60c5", notes="\u83b7\u53d6word\u6253\u5370\u6a21\u677f\u4efb\u52a1\u8be6\u60c5")
    public ApiResponse<SysWordPrintTask> getTaskDetail(@ApiParam(value="\u4efb\u52a1id") @RequestParam Long taskId) {
        return this.printTemplateService.getTaskDetail(taskId);
    }

    @GetMapping(value={"/download"})
    @ApiOperation(value="\u6253\u5370\u6587\u4ef6\u4e0b\u8f7d", notes="\u6253\u5370\u6587\u4ef6\u4e0b\u8f7d")
    public void fileDownload(@ApiParam(value="\u6587\u4ef6id") @RequestParam(value="fileId") Long fileId, HttpServletResponse response) {
        this.attachmentManagerService.fileDownload(response, fileId);
    }

    @PostMapping(value={"/uploadFileWithDrag"})
    @CheckPermission(value={"attachment:uploadfilewithdrag"})
    @ApiOperation(value="\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20")
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, @ApiParam(value="\u4e1a\u52a1ID") Long businessId) throws Exception {
        return this.attachmentManagerService.uploadFileWithDrag(multipartRequest, businessId);
    }

    @GetMapping(value={"/copy"})
    @ApiOperation(value="\u6253\u5370\u6a21\u677f\u590d\u5236", notes="\u590d\u5236\u5230\u5f53\u524d\u8868\u5355\u4e0b")
    public ApiResponse<SysPrintTemplateVo> copy(@ApiParam(value="\u6a21\u677fid") @RequestParam Long printId) {
        return this.printTemplateService.copy(printId);
    }
}

