/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.constant.DataOprLogConst;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.model.SysDataOperateLog;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.service.ISysDataOperateLogService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogType;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.vo.SysDataLogUserInfo;
import com.jxdinfo.hussar.formdesign.application.properties.DataOperateLogProperties;
import com.jxdinfo.hussar.formdesign.application.util.DeepCopy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogColumnEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogService;
import com.jxdinfo.hussar.support.audit.core.auditlog.vo.AuditLogItemVo;
import com.jxdinfo.hussar.support.audit.core.util.AuditIpUtils;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

@Component
public class OperateLogComponent {
    @Resource
    private DataOperateLogProperties dataOperateLogProperties;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private ISysDataOperateLogService sysDataOperateLogService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    private static final Logger LOGGER = LoggerFactory.getLogger(OperateLogComponent.class);
    @Autowired(required=false)
    private AuditLogService auditLogService;
    @Resource
    private ISysFormService formService;
    @Resource
    private IHussarBaseUserBoService usersService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;

    public String getConnNameByTcode(String tcode) {
        boolean tenantOpen = TenantCacheUtil.openTenant();
        if (tenantOpen) {
            HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(tcode);
            if (HussarUtils.isNotEmpty((Object)tenantByTenantCode)) {
                HussarContextHolder.setTenant((HussarTenantDefinition)tenantByTenantCode);
                return tenantByTenantCode.getConnName();
            }
            return null;
        }
        return null;
    }

    public void batchDel(ProceedingJoinPoint joinPoint, Long userId, OperateLogType operateLogType) {
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        Object idsObj = args[1];
        Long appId = Long.valueOf(String.valueOf(args[2]));
        String ids = String.valueOf(idsObj);
        LOGGER.info("\u5f00\u59cb\u5f02\u6b65\u89e3\u6790\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)ids);
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList logs = new ArrayList();
        try {
            idList.forEach(id -> {
                SysDataOperateLog log = this.newLog((String)id, String.valueOf(formId), String.valueOf(appId), 2, new JSONArray(), new JSONArray(), (Map<String, Object>)new HashMap<String, Object>(), (Map<String, Object>)new HashMap<String, Object>(), operateLogType, new JSONArray());
                log.setCreator(userId);
                logs.add(log);
            });
            LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)ids);
            String storageType = this.dataOperateLogProperties.getStorageType();
            if (storageType.equals("mysql")) {
                this.sysDataOperateLogService.saveBatch(logs);
            } else {
                logs.forEach(sysDataOperateLog -> {
                    sysDataOperateLog.setOperateId(Long.valueOf(IdWorker.getId((Object)sysDataOperateLog)));
                    sysDataOperateLog.setCreateTime(this.localDateTime());
                    sysDataOperateLog.setLastTime(sysDataOperateLog.getCreateTime());
                    sysDataOperateLog.setLastEditor(sysDataOperateLog.getCreator());
                });
                this.mongoTemplate.insertAll(logs);
            }
        }
        catch (Exception e) {
            LOGGER.error("deleteBatch\u5f02\u6b65\u89e3\u6790\u5f02\u5e38\uff0c\u8868\u5355id:{},\u6570\u636eid:{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, ids, e});
        }
    }

    public void singleDataHandle(JSONObject newData, JSONObject oldData, Long appId, Long formId, String dataId, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, Long userId, OperateLogType operateLogType, JSONArray widgets, SysDataLogUserInfo userInfo) {
        SysDataOperateLog log = this.newLog(dataId, String.valueOf(formId), String.valueOf(appId), HussarUtils.isNotEmpty((Object)oldData) ? 1 : 0, childList, childCountList, newParams, oldParams, operateLogType, widgets);
        if (operateLogType.getMode() == 6) {
            Object user = newData.get((Object)"createUser_user");
            if (HussarUtils.isNotEmpty((Object)user)) {
                log.setCreator(Long.valueOf(String.valueOf(user)));
            } else {
                log.setCreator(userId);
            }
        } else {
            log.setCreator(userId);
        }
        String storageType = this.dataOperateLogProperties.getStorageType();
        if (storageType.equals("mysql")) {
            this.sysDataOperateLogService.save((Object)log);
        } else {
            log.setOperateId(Long.valueOf(IdWorker.getId((Object)log)));
            log.setCreateTime(this.localDateTime());
            log.setLastTime(log.getCreateTime());
            log.setLastEditor(log.getCreator());
            this.mongoTemplate.insert((Object)log);
        }
        HussarNoCodeThreadUtil.executeDataTask(() -> {
            Map<String, String> widgetMap = this.getWidgets(String.valueOf(formId));
            Map<String, Widget> widgetsObj = this.getWidgetsObj(String.valueOf(formId));
            SysForm sysForm = (SysForm)this.formService.getDetailById(formId).getData();
            this.auditLogHandle(log, formId, dataId, userId, this.getUserName(userId), widgetMap, widgetsObj, sysForm, newData, userInfo);
        });
    }

    public void addDataAuditLog(JSONObject oldData, JSONObject newData, SysForm sysForm, String formId, OperateLogType operateLogType, Long userId, SysDataLogUserInfo userInfo, Map<String, String> widgetMap, Map<String, Widget> widgetsObj, String userName) {
        JSONArray childList = new JSONArray();
        JSONArray childCountList = new JSONArray();
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        HashMap<String, Object> oldParams = new HashMap<String, Object>();
        String tableName = sysForm.getTableName();
        JSONArray widgets = new JSONArray();
        this.compareData(oldData, newData, childList, childCountList, newParams, oldParams, tableName, formId, widgets);
        SysDataOperateLog log = this.newLog(String.valueOf(newData.get((Object)"RECORD_ID")), formId, String.valueOf(sysForm.getAppId()), 0, childList, childCountList, newParams, oldParams, operateLogType, widgets);
        if (operateLogType.getMode() == 6) {
            Object user = newData.get((Object)"createUser_user");
            if (HussarUtils.isNotEmpty((Object)user)) {
                log.setCreator(Long.valueOf(String.valueOf(user)));
            } else {
                log.setCreator(userId);
            }
        } else {
            log.setCreator(userId);
        }
        this.auditLogHandle(log, Long.valueOf(formId), String.valueOf(newData.get((Object)"RECORD_ID")), userId, userName, widgetMap, widgetsObj, sysForm, newData, userInfo);
    }

    public void auditLogHandle(SysDataOperateLog log, Long formId, String dataId, Long userId, String username, Map<String, String> widgetMap, Map<String, Widget> widgetsObj, SysForm sysForm, JSONObject newData, SysDataLogUserInfo userInfo) {
        if (HussarUtils.isEmpty((Object)this.auditLogService)) {
            LOGGER.info("\u672a\u542f\u7528\u5ba1\u8ba1\u65e5\u5fd7\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
            return;
        }
        String token = userInfo.getToken();
        Long tenantId = userInfo.getTenantId();
        int opType = log.getOpType();
        String opName = "";
        String opNameCname = "";
        int eventType = 0;
        switch (opType) {
            case 0: {
                opName = "INSERT";
                opNameCname = "\u65b0\u589e";
                eventType = 1;
                break;
            }
            case 1: {
                eventType = 3;
                opName = "UPDATE";
                opNameCname = "\u4fee\u6539";
                break;
            }
            case 2: {
                eventType = 2;
                opName = "DELETE";
                opNameCname = "\u5220\u9664";
            }
        }
        try {
            LOGGER.info("\u5f00\u59cb\u4fdd\u5b58\u65e5\u5fd7\u5230\u5ba1\u8ba1\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)dataId);
            ArrayList<AuditLogItemVo> auditLogItemVos = new ArrayList<AuditLogItemVo>();
            String newRecord = log.getNewRecord();
            String oldRecord = log.getOldRecord();
            if (HussarUtils.isNotEmpty((Object)newRecord) && HussarUtils.isNotEmpty((Object)oldRecord)) {
                JSONObject nJsonObject = JSON.parseObject((String)newRecord);
                JSONObject OJsonObject = JSON.parseObject((String)oldRecord);
                if (HussarUtils.isNotEmpty((Object)nJsonObject) && HussarUtils.isNotEmpty((Object)OJsonObject)) {
                    UUID uuid = UUID.randomUUID();
                    String commitId = String.valueOf(uuid);
                    AuditLogEntity auditLogEntity = new AuditLogEntity();
                    auditLogEntity.setCommitId(commitId);
                    auditLogEntity.setEventType(Integer.valueOf(eventType));
                    auditLogEntity.setEventDesc(sysForm.getFormName() + opNameCname + "\u6570\u636e\u65e5\u5fd7");
                    auditLogEntity.setEventGrade(Integer.valueOf(1));
                    auditLogEntity.setRequesetResult(Integer.valueOf(1));
                    auditLogEntity.setClientAddr(AuditIpUtils.getIp());
                    auditLogEntity.setSeverityLevel(Integer.valueOf(1));
                    auditLogEntity.setUserId(userId);
                    auditLogEntity.setUserName(username);
                    auditLogEntity.setToken(token);
                    auditLogEntity.setTenantId(Long.valueOf(HussarUtils.isNotEmpty((Object)tenantId) ? tenantId : 0L));
                    String packageName = userInfo.getPackageName();
                    if (HussarUtils.isNotEmpty((Object)packageName)) {
                        String substring = packageName.substring(0, packageName.lastIndexOf("."));
                        auditLogEntity.setPackageName(substring);
                        auditLogEntity.setClassName(packageName.substring(packageName.lastIndexOf(".") + 1));
                    }
                    auditLogEntity.setMethodName(userInfo.getMethodName());
                    this.auditLogService.save(auditLogEntity);
                    LOGGER.info("--------------\u5ba1\u8ba1\u65e5\u5fd7\u63d0\u4ea4\u6210\u529f\uff0c\u63d0\u4ea4id:{}--------------", (Object)commitId);
                    boolean hostFlag = true;
                    AuditLogItemVo auditLogItemVo = new AuditLogItemVo();
                    LinkedHashSet<AuditLogColumnEntity> auditLogColumnEntitySet = new LinkedHashSet<AuditLogColumnEntity>();
                    for (String key : nJsonObject.keySet()) {
                        if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && WidgetTool.isChildTableType((String)widgetMap.get(key))) continue;
                        if (hostFlag) {
                            AuditLogTableEntity auditLogTableEntity = new AuditLogTableEntity();
                            auditLogItemVo.setAuditLogColumnSet(auditLogColumnEntitySet);
                            auditLogItemVo.setAuditLogTable(auditLogTableEntity);
                            auditLogTableEntity.setCommitId(commitId);
                            auditLogTableEntity.setTableDesc(sysForm.getFormName());
                            auditLogTableEntity.setTableName(sysForm.getTableName());
                            auditLogTableEntity.setSchemaName(DataModelUtil.currentDsName());
                            auditLogTableEntity.setOperateMode(opName);
                            auditLogTableEntity.setTenantId(Long.valueOf(HussarUtils.isNotEmpty((Object)tenantId) ? tenantId : 0L));
                            hostFlag = false;
                        }
                        if (key.contains("_detailed") && HussarUtils.isNotEmpty((Object)widgetMap.get(key.replace("_detailed", ""))) && widgetMap.get(key.replace("_detailed", "")).equals(WidgetType.ADDRESS.getType())) {
                            if (nJsonObject.containsKey((Object)key.replace("_detailed", ""))) continue;
                            nJsonObject.put(key.replace("_detailed", ""), (Object)"");
                            if (OJsonObject.containsKey((Object)key.replace("_detailed", ""))) continue;
                            OJsonObject.put(key.replace("_detailed", ""), (Object)"");
                            key = key.replace("_detailed", "");
                        }
                        Object newValue = nJsonObject.get((Object)key);
                        Object oldValue = OJsonObject.get((Object)key);
                        if (key.contains("_label")) {
                            key = key.replace("_label", "");
                        }
                        if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && widgetMap.get(key).equals(WidgetType.ADDRESS.getType())) {
                            if (nJsonObject.containsKey((Object)(key + "_detailed"))) {
                                newValue = newValue + " " + nJsonObject.get((Object)(key + "_detailed"));
                            }
                            if (OJsonObject.containsKey((Object)(key + "_detailed"))) {
                                oldValue = oldValue + " " + OJsonObject.get((Object)(key + "_detailed"));
                            }
                        }
                        if (!HussarUtils.isNotEmpty((Object)widgetMap.get(key))) continue;
                        AuditLogColumnEntity auditLogColumnEntity = new AuditLogColumnEntity();
                        auditLogColumnEntity.setCommitId(commitId);
                        auditLogColumnEntity.setColumnDesc(widgetsObj.get(key).getTitle());
                        auditLogColumnEntity.setTableName(sysForm.getTableName());
                        auditLogColumnEntity.setColumnName(widgetsObj.get(key).getName());
                        auditLogColumnEntity.setBeforeValue(String.valueOf(oldValue));
                        auditLogColumnEntity.setAfterValue(String.valueOf(newValue));
                        auditLogColumnEntity.setOperateMode(opName);
                        auditLogColumnEntity.setTenantId(Long.valueOf(HussarUtils.isNotEmpty((Object)tenantId) ? tenantId : 0L));
                        auditLogColumnEntitySet.add(auditLogColumnEntity);
                    }
                    if (HussarUtils.isNotEmpty((Object)auditLogItemVo.getAuditLogTable())) {
                        auditLogItemVos.add(auditLogItemVo);
                    }
                    LOGGER.info("--------------\u4e3b\u8868\u65e5\u5fd7\u6574\u5408\u5230\u5ba1\u8ba1\u65e5\u5fd7\u5b8c\u6210\uff0c\u63d0\u4ea4id:{}--------------", (Object)commitId);
                    String childRecord = log.getChildRecord();
                    JSONArray cRArr = JSON.parseArray((String)childRecord);
                    this.childAuditHandle(log, widgetsObj, commitId, widgetMap, auditLogItemVos, cRArr, tenantId);
                    LOGGER.info("--------------\u5b50\u5b59\u8868\u65e5\u5fd7\u6574\u5408\u5230\u5ba1\u8ba1\u65e5\u5fd7\u5b8c\u6210\uff0c\u63d0\u4ea4id:{}--------------", (Object)commitId);
                }
            }
            this.auditLogService.saveAuditLogDataChanges(auditLogItemVos);
        }
        catch (Exception e) {
            LOGGER.error("singleDataHandle \u5f02\u6b65\u89e3\u6790\u5f02\u5e38\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)dataId);
            LOGGER.error("singleDataHandle \u5f02\u6b65\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    private void childAuditHandle(SysDataOperateLog log, Map<String, Widget> widgetsObj, String commitId, Map<String, String> widgetMap, List<AuditLogItemVo> auditLogItemVos, JSONArray cRArr, Long tenantId) {
        for (Object o : cRArr) {
            JSONObject cJsonObject = (JSONObject)o;
            for (String key : cJsonObject.keySet()) {
                if (!HussarUtils.isNotEmpty((Object)widgetMap.get(key)) || !WidgetTool.isChildTableType((String)widgetMap.get(key))) continue;
                Widget cWidget = widgetsObj.get(key);
                Object object = cJsonObject.get((Object)key);
                JSONArray jsonArray = (JSONArray)object;
                for (Object object1 : jsonArray) {
                    JSONObject jsonObject = (JSONObject)object1;
                    String opMode = "";
                    Object row = jsonObject.get((Object)"row");
                    if (HussarUtils.isNotEmpty((Object)row)) {
                        JSONObject rowJ = (JSONObject)row;
                        Object object2 = rowJ.get((Object)"mode");
                        int mode = Integer.parseInt(String.valueOf(object2));
                        switch (mode) {
                            case 0: {
                                opMode = "INSERT";
                                break;
                            }
                            case 1: {
                                opMode = "UPDATE";
                                break;
                            }
                            case 2: {
                                opMode = "DELETE";
                            }
                        }
                    }
                    AuditLogItemVo auditLogItemVoC = new AuditLogItemVo();
                    AuditLogTableEntity auditLogTableEntityC = new AuditLogTableEntity();
                    LinkedHashSet<AuditLogColumnEntity> auditLogColumnEntitySetC = new LinkedHashSet<AuditLogColumnEntity>();
                    auditLogItemVoC.setAuditLogColumnSet(auditLogColumnEntitySetC);
                    auditLogItemVoC.setAuditLogTable(auditLogTableEntityC);
                    auditLogTableEntityC.setCommitId(commitId);
                    auditLogTableEntityC.setSchemaName(DataModelUtil.currentDsName());
                    auditLogTableEntityC.setOperateMode(opMode);
                    auditLogTableEntityC.setTableDesc(cWidget.getTitle());
                    auditLogTableEntityC.setTableName(cWidget.getName());
                    auditLogTableEntityC.setTenantId(Long.valueOf(HussarUtils.isNotEmpty((Object)tenantId) ? tenantId : 0L));
                    for (String key1 : jsonObject.keySet()) {
                        JSONObject addr;
                        JSONArray cRArr1;
                        Object childRecord;
                        if (key1.equals("childRecord") && (childRecord = jsonObject.get((Object)"childRecord")) instanceof JSONArray && HussarUtils.isNotEmpty((Object)(cRArr1 = (JSONArray)childRecord))) {
                            LOGGER.info("--------------\u5b59\u8868\u65e5\u5fd7\u6574\u5408\u5230\u5ba1\u8ba1\u65e5\u5fd7\u5f00\u59cb\uff0c\u63d0\u4ea4id:{}--------------", (Object)commitId);
                            this.childAuditHandle(log, widgetsObj, commitId, widgetMap, auditLogItemVos, cRArr1, tenantId);
                            LOGGER.info("--------------\u5b59\u8868\u65e5\u5fd7\u6574\u5408\u5230\u5ba1\u8ba1\u65e5\u5fd7\u7ed3\u675f\uff0c\u63d0\u4ea4id:{}--------------", (Object)commitId);
                        }
                        if (HussarUtils.isNotEmpty((Object)widgetMap.get(key1)) && WidgetTool.isChildTableType((String)widgetMap.get(key1)) || key1.equals("row") || !(jsonObject.get((Object)key1) instanceof JSONObject)) continue;
                        JSONObject dataRecord = (JSONObject)jsonObject.get((Object)key1);
                        Object newValue = dataRecord.get((Object)"newData");
                        Object oldValue = dataRecord.get((Object)"oldData");
                        Object mode = dataRecord.get((Object)"mode");
                        if (key1.contains("_detailed") && HussarUtils.isNotEmpty((Object)widgetMap.get(key1.replace("_detailed", ""))) && widgetMap.get(key1.replace("_detailed", "")).equals(WidgetType.ADDRESS.getType())) {
                            if (Integer.parseInt(String.valueOf(mode)) == 3) continue;
                            addr = (JSONObject)jsonObject.get((Object)key1.replace("_detailed", "_label"));
                            addr.put("mode", (Object)1);
                            continue;
                        }
                        if (key1.contains("_label")) {
                            key1 = key1.replace("_label", "");
                        }
                        if (HussarUtils.isNotEmpty((Object)widgetMap.get(key1)) && widgetMap.get(key1).equals(WidgetType.ADDRESS.getType()) && jsonObject.containsKey((Object)(key1 + "_detailed"))) {
                            addr = (JSONObject)jsonObject.get((Object)(key1 + "_detailed"));
                            Object object2 = addr.get((Object)"mode");
                            if (Integer.parseInt(String.valueOf(object2)) != 3) {
                                mode = 1;
                            }
                            newValue = newValue + " " + addr.get((Object)"newData");
                            oldValue = oldValue + " " + addr.get((Object)"oldData");
                        }
                        if (HussarUtils.isNotEmpty((Object)mode) && Integer.parseInt(String.valueOf(mode)) == 3) continue;
                        AuditLogColumnEntity auditLogColumnEntityC = new AuditLogColumnEntity();
                        auditLogColumnEntityC.setCommitId(commitId);
                        auditLogColumnEntityC.setColumnDesc(widgetsObj.get(key1).getTitle());
                        auditLogColumnEntityC.setTableName(cWidget.getName());
                        auditLogColumnEntityC.setColumnName(widgetsObj.get(key1).getName());
                        auditLogColumnEntityC.setBeforeValue(String.valueOf(oldValue));
                        auditLogColumnEntityC.setAfterValue(String.valueOf(newValue));
                        auditLogColumnEntityC.setOperateMode(opMode);
                        auditLogColumnEntityC.setTenantId(Long.valueOf(HussarUtils.isNotEmpty((Object)tenantId) ? tenantId : 0L));
                        auditLogColumnEntitySetC.add(auditLogColumnEntityC);
                    }
                    if (!HussarUtils.isNotEmpty(auditLogColumnEntitySetC)) continue;
                    auditLogItemVos.add(auditLogItemVoC);
                }
                LOGGER.info("--------------\u5b50\u8868\u65e5\u5fd7\u6574\u5408\u5230\u5ba1\u8ba1\u65e5\u5fd7\u7ed3\u675f\uff0c\u63d0\u4ea4id:{}--------------", (Object)commitId);
            }
        }
    }

    public String getUserName(Long userId) {
        SysUsers users = this.usersService.getUser(userId);
        String username = "";
        username = HussarUtils.isNotEmpty((Object)users) ? users.getUserName() : "\u5916\u90e8\u7528\u6237";
        return username;
    }

    public String judgeDevice(HttpServletRequest request) {
        if (HussarUtils.isEmpty((Object)request)) {
            return "Unknown";
        }
        String userAgent = request.getHeader("User-Agent");
        if (HussarUtils.isEmpty((Object)userAgent)) {
            return "Unknown";
        }
        String device = userAgent.contains("Android") || userAgent.contains("iPhone") || userAgent.contains("iPad") || userAgent.contains("Mobile") ? "Mobile" : (userAgent.contains("Windows") || userAgent.contains("Macintosh") ? "PC" : "Unknown");
        return device;
    }

    public JSONObject getDataFormDB(String dataId, String appId, String formId, String tabTye) {
        ResponseEntity responseEntity = this.formOperateExposedService.formQuery(formId, dataId, tabTye, appId, Boolean.TRUE.booleanValue());
        ApiResponse body = (ApiResponse)responseEntity.getBody();
        Object oldObj = body.getData();
        if (HussarUtils.isEmpty((Object)oldObj)) {
            LOGGER.error("\u8868\u5355\u539f\u59cb\u6570\u636e\u4e0d\u5b58\u5728,\u5e94\u7528id\uff1a{},\u8868\u5355id\uff1a{}\uff0c\u6570\u636eid\uff1a{}", new Object[]{appId, formId, dataId});
            return new JSONObject();
        }
        LOGGER.info("\u8868\u5355\u539f\u59cb\u6570\u636e\uff1a{}", (Object)this.toJsonObj(oldObj));
        return this.toJsonObj(oldObj);
    }

    public void batchAdd(JSONArray newArray, String tableName, Long appId, Long formId, int opType, OperateLogType operateLogType, Long userId, int mode, SysDataLogUserInfo userInfo) {
        newArray.forEach(jsonObj -> {
            JSONObject jsonObj1 = (JSONObject)jsonObj;
            jsonObj1.put("childList", (Object)new JSONArray());
            jsonObj1.put("childCountList", (Object)new JSONArray());
            jsonObj1.put("newParams", new HashMap());
            jsonObj1.put("oldParams", new HashMap());
            jsonObj1.put("widget", (Object)new JSONArray());
        });
        this.logSaveBatch(tableName, String.valueOf(formId), String.valueOf(appId), newArray, opType, operateLogType, userId, mode, userInfo);
    }

    public void editDataLogSaveBatch(int opType, JSONArray newArray, String tableName, JSONArray newDataS, Long appId, Long formId, JSONArray oldDataS, OperateLogType operateLogType, Long userId, SysDataLogUserInfo userInfo) {
        JSONArray editIds = new JSONArray();
        JSONArray toLogs = new JSONArray();
        block0: for (Object data : oldDataS) {
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            Object o = jsonObject.get((Object)tableName);
            String s = String.valueOf(o);
            for (Object newData : newDataS) {
                JSONObject jsonObject1 = JSON.parseObject((String)JSON.toJSONString(newData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                Object o1 = jsonObject1.get((Object)tableName);
                String s1 = String.valueOf(o1);
                if (!s.equals(s1)) continue;
                editIds.add((Object)s1);
                JSONArray childList = new JSONArray();
                JSONArray childCountList = new JSONArray();
                HashMap<String, Object> newParams = new HashMap<String, Object>();
                HashMap<String, Object> oldParams = new HashMap<String, Object>();
                JSONArray widgets = new JSONArray();
                if (this.compareData(jsonObject, jsonObject1, childList, childCountList, newParams, oldParams, tableName, String.valueOf(formId), widgets)) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)s1, (Object)formId);
                    editIds.remove((Object)s1);
                    continue block0;
                }
                if (newParams.isEmpty() && oldParams.isEmpty()) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)s1, (Object)formId);
                    editIds.remove((Object)s1);
                    continue block0;
                }
                jsonObject1.put("childList", (Object)childList);
                jsonObject1.put("childCountList", (Object)childCountList);
                jsonObject1.put("newParams", newParams);
                jsonObject1.put("oldParams", oldParams);
                jsonObject1.put("widget", (Object)widgets);
                toLogs.add((Object)jsonObject1);
            }
        }
        LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u4fee\u6539\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)editIds);
        this.logSaveBatch(tableName, String.valueOf(formId), String.valueOf(appId), toLogs, opType, operateLogType, userId, operateLogType.getMode(), userInfo);
    }

    public void getDataSBatch(JSONArray array, String formName, JSONArray dataS, Long appId, Long formId) {
        ArrayList idsList = new ArrayList();
        array.forEach(jsonObj -> {
            Object o = ((JSONObject)jsonObj).get((Object)"RECORD_ID");
            String s = String.valueOf(o);
            idsList.add(s);
        });
        String ids = String.join((CharSequence)",", idsList);
        HashMap params = new HashMap();
        Filter idsFilter = new Filter();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        idsFilter.setField("RECORD_ID");
        idsFilter.setMatch("AND");
        idsFilter.setRule("_in");
        idsFilter.setVal(ids);
        filters.add(idsFilter);
        params.put("superQueryConditionDto", filters);
        ResponseEntity apiResponse = this.formOperateExposedService.tableQueryByCondition(String.valueOf(appId), String.valueOf(formId), params);
        PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(apiResponse.getBody())).getData();
        List dataTemp = pageData.getData();
        dataS.addAll((Collection)dataTemp);
        LOGGER.info("\u67e5\u8be2\u8868\u5355\u6570\u636e\u5b8c\u6210\uff0c\u8868\u5355id:{},\u6570\u636eid:{},\u6570\u636e\uff1a{}", new Object[]{formId, ids, dataS});
    }

    public JSONArray getJsonObj(JSONObject jsonObject) {
        JSONArray array = new JSONArray();
        Object importList = jsonObject.get((Object)"importList");
        List list = (List)importList;
        if (HussarUtils.isNotEmpty((Object)list)) {
            array.addAll((Collection)list);
        }
        return array;
    }

    public JSONArray getFlowJsonObj(JSONObject jsonObject) {
        Object dataList = jsonObject.get((Object)"dataList");
        return (JSONArray)dataList;
    }

    public SysDataOperateLog newLog(String dataId, String formId, String appId, int opType, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, OperateLogType operateLogType, JSONArray widgets) {
        if (HussarUtils.isNull((Object)operateLogType)) {
            operateLogType = new OperateLogType();
            operateLogType.setMode(0);
        }
        JSONArray newWidgets = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)widgets)) {
            block0: for (Object o : widgets) {
                JSONObject jsonObject = (JSONObject)o;
                String name = String.valueOf(jsonObject.get((Object)"name"));
                for (String key : newParams.keySet()) {
                    if (!key.contains(name)) continue;
                    newWidgets.add((Object)jsonObject);
                    continue block0;
                }
            }
        }
        return new SysDataOperateLog(Long.valueOf(dataId), Long.valueOf(formId), Long.valueOf(appId), JSON.toJSONString(oldParams), JSON.toJSONString(newParams), JSON.toJSONString((Object)childList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), this.count(newParams), opType, operateLogType.getMode(), HussarUtils.isNotEmpty((Object)operateLogType.getTriggerFormId()) ? Long.valueOf(operateLogType.getTriggerFormId()) : null, JSON.toJSONString((Object)childCountList), operateLogType.getDevice(), HussarUtils.isNotEmpty((Object)operateLogType.getButtonId()) ? Long.valueOf(operateLogType.getButtonId()) : null, JSON.toJSONString((Object)newWidgets, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    private int count(Map<String, Object> newParams) {
        int size = newParams.size();
        for (String o : newParams.keySet()) {
            if (!o.toString().contains("_detail")) continue;
            --size;
        }
        return size;
    }

    private void logSaveBatch(String tableName, String formId, String appId, JSONArray newData, int opType, OperateLogType operateLogType, Long userId, int mode, SysDataLogUserInfo userInfo) {
        ArrayList logs = new ArrayList();
        newData.forEach(jsonObj -> {
            JSONObject jsonObj1 = (JSONObject)jsonObj;
            SysDataOperateLog log = this.newLog(String.valueOf(jsonObj1.get((Object)tableName)), formId, appId, opType, (JSONArray)jsonObj1.get((Object)"childList"), (JSONArray)jsonObj1.get((Object)"childCountList"), (Map)jsonObj1.get((Object)"newParams"), (Map)jsonObj1.get((Object)"oldParams"), operateLogType, (JSONArray)jsonObj1.get((Object)"widget"));
            if (mode == 6) {
                Object user = jsonObj1.get((Object)"createUser_user");
                if (HussarUtils.isNotEmpty((Object)user)) {
                    log.setCreator(Long.valueOf(String.valueOf(user)));
                } else {
                    log.setCreator(userId);
                }
            } else {
                log.setCreator(userId);
            }
            logs.add(log);
        });
        String storageType = this.dataOperateLogProperties.getStorageType();
        if (storageType.equals("mysql")) {
            this.sysDataOperateLogService.saveBatch(logs);
        } else {
            logs.forEach(log -> {
                log.setOperateId(Long.valueOf(IdWorker.getId((Object)log)));
                log.setCreateTime(this.localDateTime());
                log.setLastTime(log.getCreateTime());
                log.setLastEditor(log.getCreator());
            });
            this.mongoTemplate.insertAll(logs);
        }
        HussarNoCodeThreadUtil.executeDataTask(() -> {
            String userName = this.getUserName(userId);
            Map<String, String> widgetMap = this.getWidgets(String.valueOf(formId));
            Map<String, Widget> widgetsObj = this.getWidgetsObj(String.valueOf(formId));
            SysForm sysForm = (SysForm)this.formService.getDetailById(Long.valueOf(formId)).getData();
            for (SysDataOperateLog log : logs) {
                int index = logs.indexOf(log);
                if (log.getOpType() == 0) {
                    JSONObject oldData = new JSONObject();
                    this.addDataAuditLog(oldData, (JSONObject)newData.get(index), sysForm, formId, operateLogType, userId, userInfo, widgetMap, widgetsObj, userName);
                }
                if (log.getOpType() != 1) continue;
                this.auditLogHandle(log, Long.valueOf(formId), String.valueOf(log.getDataId()), userId, userName, widgetMap, widgetsObj, sysForm, (JSONObject)newData.get(index), userInfo);
            }
        });
    }

    public JSONObject toJsonObj(Object obj) {
        String dataJson = JsonUtil.toJson((Object)obj);
        return JSON.parseObject((String)dataJson);
    }

    private void newDataToOldData(Map<String, String> widgetMap, JSONObject newCompare) {
        for (String key : newCompare.keySet()) {
            if (key.equals("RECORD_ID")) continue;
            if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && WidgetTool.isChildTableType((String)widgetMap.get(key))) {
                Object object = newCompare.get((Object)key);
                if (!(object instanceof JSONArray)) continue;
                JSONArray childData = (JSONArray)object;
                childData = new JSONArray();
                newCompare.put(key, (Object)childData);
                continue;
            }
            newCompare.put(key, (Object)"");
        }
    }

    public boolean compareData(JSONObject oldData, JSONObject newData, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, String tableName, String formId, JSONArray widgets) {
        LOGGER.info("\u6570\u636e\u6bd4\u8f83\u5f00\u59cb\uff0c\u65e7\u6570\u636e\uff1a{},\u65b0\u6570\u636e\uff1a{}", (Object)oldData, (Object)newData);
        Map<String, String> widgetMap = this.getWidgets(formId);
        if (HussarUtils.isEmpty((Object)oldData)) {
            JSONObject newCompare = DeepCopy.deepCopyJsonObject(newData);
            this.newDataToOldData(widgetMap, newCompare);
            oldData = newCompare;
        }
        if (HussarUtils.isEmpty((Object)newData)) {
            JSONObject oldCompare = DeepCopy.deepCopyJsonObject(oldData);
            this.newDataToOldData(widgetMap, oldCompare);
            newData = oldCompare;
        }
        this.cleanData(oldData, 0, tableName, widgetMap);
        this.cleanData(newData, 0, tableName, widgetMap);
        LOGGER.info("\u6e05\u9664\u540e\u6570\u636e\uff1a\u8001{}\uff0c\u65b0{}", (Object)oldData, (Object)newData);
        if (JSON.toJSONString((Object)oldData).equals(JSON.toJSONString((Object)newData))) {
            return true;
        }
        for (String key : newData.keySet()) {
            if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && widgetMap.get(key).equals(WidgetType.JXDN_SUGGESTION.getType()) || !oldData.containsKey((Object)key)) continue;
            if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && (widgetMap.get(key).equals(WidgetType.CHILDREN_TABLE.getType()) || widgetMap.get(key).equals(WidgetType.JXDNChildrenTableAgg.getType()))) {
                this.compareChild((JSONArray)oldData.get((Object)key), (JSONArray)newData.get((Object)key), childList, childCountList, newParams, oldParams, tableName, key, widgetMap);
                continue;
            }
            if (this.compareAddress(key, oldData, newData, oldParams, newParams, widgetMap) || this.compareImage(key, oldData, newData, oldParams, newParams, widgetMap)) continue;
            if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && widgetMap.get(key).equals(WidgetType.JXDNLinkFormMulti.getType())) {
                String refId = key + "_ref_id";
                String refChildId = key + "_ref_child_id";
                Object newObject = newData.get((Object)refId);
                Object newChildObject = newData.get((Object)refChildId);
                Object oldObject = oldData.get((Object)refId);
                Object oldChildObject = oldData.get((Object)refChildId);
                if (!OperateLogComponent.objEquals(newChildObject, oldChildObject) && !OperateLogComponent.objEquals(newObject, oldObject) && !OperateLogComponent.objEquals(newData.get((Object)key), oldData.get((Object)key))) continue;
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                HashMap<String, Object> oldMap = new HashMap<String, Object>();
                newMap.put(key, HussarUtils.isNotEmpty((Object)newData.get((Object)key)) ? newData.get((Object)key) : "");
                newMap.put(refId, HussarUtils.isNotEmpty((Object)newData.get((Object)refId)) ? newData.get((Object)refId) : "");
                newMap.put(refChildId, HussarUtils.isNotEmpty((Object)newData.get((Object)refChildId)) ? newData.get((Object)refChildId) : "");
                oldMap.put(key, HussarUtils.isNotEmpty((Object)oldData.get((Object)key)) ? oldData.get((Object)key) : "");
                oldMap.put(refId, HussarUtils.isNotEmpty((Object)oldData.get((Object)refId)) ? oldData.get((Object)refId) : "");
                oldMap.put(refChildId, HussarUtils.isNotEmpty((Object)oldData.get((Object)refChildId)) ? oldData.get((Object)refChildId) : "");
                oldParams.put(key, oldMap);
                newParams.put(key, newMap);
                continue;
            }
            if (key.contains("_ref_id") || key.contains("_ref_child_id") || !OperateLogComponent.objEquals(oldData.get((Object)key), newData.get((Object)key))) continue;
            LOGGER.info("\u5b57\u6bb5{}\u88ab\u4fee\u6539\uff0c\u8868\u5355id{}", (Object)key, (Object)formId);
            oldParams.put(key, HussarUtils.isNotEmpty((Object)oldData.get((Object)key)) ? oldData.get((Object)key) : "");
            newParams.put(key, newData.get((Object)key));
        }
        return false;
    }

    private void compareChild(JSONArray oldChildren, JSONArray newChildren, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, String tableName, String key, Map<String, String> widgetMap) {
        int size = childList.size();
        JSONObject childCount = new JSONObject();
        JSONObject childCountMap = new JSONObject();
        JSONObject map = new JSONObject();
        JSONArray updateList = new JSONArray();
        JSONArray updateChild = new JSONArray();
        JSONArray childDelData = new JSONArray();
        Map<String, Tuple2<JSONArray, JSONArray>> grandChildren = this.childEquals(oldChildren, newChildren, newParams, oldParams, tableName, key, widgetMap);
        if (HussarUtils.isEmpty((Object)oldChildren) && HussarUtils.isEmpty((Object)newChildren)) {
            return;
        }
        OperateLogComponent.getDelChildList(oldChildren, childDelData, newChildren);
        for (Object newChild : newChildren) {
            JSONObject newJsonObject = (JSONObject)newChild;
            String newId = String.valueOf(newJsonObject.get((Object)"RECORD_ID"));
            JSONObject oldJsonObject = OperateLogComponent.getOldDataByNewId(oldChildren, newId, key);
            if (HussarUtils.isEmpty((Object)oldJsonObject)) {
                this.handleChildNewData(newJsonObject, updateChild, childCount, key, grandChildren, widgetMap);
                this.cleanData(newJsonObject, 1, tableName, widgetMap);
                continue;
            }
            this.cleanData(newJsonObject, 1, tableName, widgetMap);
            boolean isUpdate = true;
            JSONObject updateMap = new JSONObject();
            this.cleanData(oldJsonObject, 1, tableName, widgetMap);
            JSONObject newCompare = DeepCopy.deepCopyJsonObject(newJsonObject);
            JSONObject oldCompare = DeepCopy.deepCopyJsonObject(oldJsonObject);
            ArrayList oldList = new ArrayList();
            ArrayList newList = new ArrayList();
            oldCompare.forEach((k, v) -> {
                if (k.contains("_label")) {
                    String[] strings = k.split("_label");
                    String string = strings[0];
                    if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                        oldList.add(k);
                    }
                    if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                        oldList.add(k);
                    }
                }
            });
            oldList.forEach(arg_0 -> ((JSONObject)oldCompare).remove(arg_0));
            newCompare.forEach((k, v) -> {
                if (k.contains("_label")) {
                    String[] strings = k.split("_label");
                    String string = strings[0];
                    if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                        newList.add(k);
                    }
                    if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                        newList.add(k);
                    }
                }
            });
            newList.forEach(arg_0 -> ((JSONObject)newCompare).remove(arg_0));
            if (!newCompare.toJSONString().equals(oldCompare.toJSONString()) || grandChildren.containsKey(newId)) {
                if (grandChildren.containsKey(newId)) {
                    updateMap.put("childRecord", grandChildren.get(newId).getT1());
                    updateMap.put("childCount", grandChildren.get(newId).getT2());
                }
                for (String key2 : newJsonObject.keySet()) {
                    if (!oldJsonObject.containsKey((Object)key2) || key2.contains("_ref_id") || key2.contains("_ref_child_id")) continue;
                    DataRecord dataRecord = new DataRecord();
                    Object oldR = oldJsonObject.get((Object)key2);
                    Object newR = newJsonObject.get((Object)key2);
                    if (this.compareChildNo(key2, dataRecord, oldJsonObject, newJsonObject, widgetMap)) continue;
                    if (key2.contains("_code")) {
                        String[] strings = key2.split("_code");
                        String address = strings[0];
                        address = address + "_label";
                        if (OperateLogComponent.objEquals(oldJsonObject.get((Object)key2), newJsonObject.get((Object)key2))) {
                            this.compareChild(newJsonObject.get((Object)address), oldJsonObject.get((Object)address), dataRecord);
                        } else {
                            dataRecord.setNewData("");
                            if (HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)address))) {
                                dataRecord.setOldData(oldJsonObject.get((Object)address));
                            } else {
                                dataRecord.setOldData("");
                            }
                            dataRecord.setMode(3);
                        }
                        key2 = address;
                    } else if (HussarUtils.isNotEmpty((Object)widgetMap.get(key2)) && widgetMap.get(key2).equals(WidgetType.IMAGE.getType())) {
                        if (OperateLogComponent.objEquals(oldJsonObject.get((Object)key2), newJsonObject.get((Object)key2))) {
                            key2 = key2 + "_label";
                            this.compareChild(newJsonObject.get((Object)key2), oldJsonObject.get((Object)key2), dataRecord);
                        } else {
                            key2 = key2 + "_label";
                            dataRecord.setNewData("");
                            if (HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)key2))) {
                                dataRecord.setOldData(oldJsonObject.get((Object)key2));
                            } else {
                                dataRecord.setOldData("");
                            }
                            dataRecord.setMode(3);
                        }
                    } else if (HussarUtils.isNotEmpty((Object)widgetMap.get(key2)) && widgetMap.get(key2).equals(WidgetType.JXDNLinkFormMulti.getType())) {
                        String refId = key2 + "_ref_id";
                        String refChildId = key2 + "_ref_child_id";
                        Object newObject = newJsonObject.get((Object)refId);
                        Object newChildObject = newJsonObject.get((Object)refChildId);
                        Object oldObject = oldJsonObject.get((Object)refId);
                        Object oldChildObject = oldJsonObject.get((Object)refChildId);
                        if (!(OperateLogComponent.objEquals(newChildObject, oldChildObject) || OperateLogComponent.objEquals(newObject, oldObject) || OperateLogComponent.objEquals(newJsonObject.get((Object)key2), oldJsonObject.get((Object)key2)))) {
                            dataRecord.setNewData("");
                            dataRecord.setOldData(HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)key2)) ? oldJsonObject.get((Object)key2) : "");
                            dataRecord.setMode(3);
                        } else {
                            HashMap<String, Object> newMap = new HashMap<String, Object>();
                            HashMap<String, Object> oldMap = new HashMap<String, Object>();
                            newMap.put(key2, HussarUtils.isNotEmpty((Object)newJsonObject.get((Object)key2)) ? newJsonObject.get((Object)key2) : "");
                            newMap.put(refId, HussarUtils.isNotEmpty((Object)newJsonObject.get((Object)refId)) ? newJsonObject.get((Object)refId) : "");
                            newMap.put(refChildId, HussarUtils.isNotEmpty((Object)newJsonObject.get((Object)refChildId)) ? newJsonObject.get((Object)refChildId) : "");
                            oldMap.put(key2, HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)key2)) ? oldJsonObject.get((Object)key2) : "");
                            oldMap.put(refId, HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)refId)) ? oldJsonObject.get((Object)refId) : "");
                            oldMap.put(refChildId, HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)refChildId)) ? oldJsonObject.get((Object)refChildId) : "");
                            dataRecord.setNewData(newMap);
                            dataRecord.setOldData(oldMap);
                            dataRecord.setMode(1);
                        }
                    } else {
                        this.compareChild(newR, oldR, dataRecord);
                    }
                    updateMap.put(key2, (Object)dataRecord);
                    if (!isUpdate) continue;
                    updateMap.put("row", (Object)new Mode("1"));
                    if (childCount.containsKey((Object)"UPDATE")) {
                        childCount.put("UPDATE", (Object)(Integer.parseInt(String.valueOf(childCount.get((Object)"UPDATE"))) + 1));
                    } else {
                        childCount.put("UPDATE", (Object)1);
                    }
                    isUpdate = false;
                }
            }
            if (!HussarUtils.isNotEmpty((Object)updateMap)) continue;
            updateChild.add((Object)updateMap);
        }
        this.handleChildDelData(childDelData, updateChild, childCount, key, grandChildren, widgetMap);
        this.cleanChildData(childDelData, tableName, widgetMap);
        if (HussarUtils.isNotEmpty((Object)updateChild)) {
            updateList.addAll((Collection)updateChild);
            map.put(key, (Object)updateList);
            childList.add((Object)map);
        }
        if (HussarUtils.isNotEmpty((Object)childCount)) {
            childCountMap.put(key, (Object)childCount);
            childCountList.add((Object)childCountMap);
        }
        if (childList.size() == size) {
            newParams.remove(key);
            oldParams.remove(key);
        }
    }

    private void compareChild(Object newR, Object oldR, DataRecord dataRecord) {
        if (HussarUtils.isNotEmpty((Object)newR) && HussarUtils.isEmpty((Object)oldR)) {
            dataRecord.setNewData(newR);
            dataRecord.setOldData("");
            dataRecord.setMode(0);
        } else if (HussarUtils.isNotEmpty((Object)newR) && HussarUtils.isNotEmpty((Object)oldR) && OperateLogComponent.objEquals(newR, oldR)) {
            dataRecord.setNewData(newR);
            dataRecord.setOldData(oldR);
            dataRecord.setMode(1);
        } else if (HussarUtils.isEmpty((Object)newR) && HussarUtils.isNotEmpty((Object)oldR)) {
            dataRecord.setNewData("");
            dataRecord.setOldData(oldR);
            dataRecord.setMode(2);
        } else if (!OperateLogComponent.objEquals(oldR, newR)) {
            dataRecord.setNewData("");
            if (HussarUtils.isNotEmpty((Object)oldR)) {
                dataRecord.setOldData(oldR);
            } else {
                dataRecord.setOldData("");
            }
            dataRecord.setMode(3);
        }
    }

    private boolean compareChildNo(String key, DataRecord dataRecord, JSONObject oldData, JSONObject newData, Map<String, String> widgetMap) {
        if (key.contains("_label")) {
            String[] strings = key.split("_label");
            String string = strings[0];
            if (widgetMap.get(string).equals(WidgetType.ADDRESS.getType())) {
                return true;
            }
            if (widgetMap.get(string).equals(WidgetType.IMAGE.getType())) {
                return true;
            }
        }
        return false;
    }

    private boolean compareAddress(String key, JSONObject oldData, JSONObject newData, Map<String, Object> oldParams, Map<String, Object> newParams, Map<String, String> widgetMap) {
        if (key.contains("_code")) {
            String[] strings = key.split("_code");
            String address = strings[0];
            address = address + "_label";
            if (OperateLogComponent.objEquals(oldData.get((Object)key), newData.get((Object)key))) {
                oldParams.put(address, HussarUtils.isNotEmpty((Object)oldData.get((Object)address)) ? oldData.get((Object)address) : "");
                newParams.put(address, HussarUtils.isNotEmpty((Object)newData.get((Object)address)) ? newData.get((Object)address) : "");
            }
            return true;
        }
        if (key.contains("_label")) {
            String[] strings = key.split("_label");
            String string = strings[0];
            return HussarUtils.isNotEmpty((Object)widgetMap.get(string)) && widgetMap.get(string).equals(WidgetType.ADDRESS.getType());
        }
        return false;
    }

    private boolean compareImage(String key, JSONObject oldData, JSONObject newData, Map<String, Object> oldParams, Map<String, Object> newParams, Map<String, String> widgetMap) {
        if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && widgetMap.get(key).equals(WidgetType.IMAGE.getType()) && OperateLogComponent.objEquals(oldData.get((Object)key), newData.get((Object)key))) {
            oldParams.put(key, HussarUtils.isNotEmpty((Object)oldData.get((Object)(key = key + "_label"))) ? oldData.get((Object)key) : "");
            newParams.put(key, HussarUtils.isNotEmpty((Object)newData.get((Object)key)) ? newData.get((Object)key) : "");
            return true;
        }
        if (key.contains("_label")) {
            String[] strings = key.split("_label");
            String string = strings[0];
            return HussarUtils.isNotEmpty((Object)widgetMap.get(string)) && widgetMap.get(string).equals(WidgetType.IMAGE.getType());
        }
        return false;
    }

    private static JSONObject getOldDataByNewId(JSONArray oldData, String newId, String key) {
        List objectList = oldData.stream().filter(jsonObj -> String.valueOf(((JSONObject)jsonObj).get((Object)"RECORD_ID")).equals(newId)).collect(Collectors.toList());
        if (!objectList.isEmpty()) {
            return (JSONObject)objectList.get(0);
        }
        return new JSONObject();
    }

    private static void getDelChildList(JSONArray oldChild, JSONArray childDelData, JSONArray newChild) {
        oldChild.forEach(jsonObj -> {
            JSONObject obj = (JSONObject)jsonObj;
            Object recordId = obj.get((Object)"RECORD_ID");
            List objectList = newChild.stream().filter(jsonObj2 -> String.valueOf(((JSONObject)jsonObj2).get((Object)"RECORD_ID")).equals(recordId)).collect(Collectors.toList());
            if (objectList.isEmpty()) {
                childDelData.add((Object)obj);
            }
        });
    }

    private void handleChildDelData(JSONArray childDelData, JSONArray updateChild, JSONObject childCount, String key, Map<String, Tuple2<JSONArray, JSONArray>> grandChange, Map<String, String> widgetMap) {
        JSONObject jsonObject;
        ArrayList list = new ArrayList();
        for (Object obj : childDelData) {
            jsonObject = (JSONObject)obj;
            jsonObject.forEach((k, v) -> {
                if (k.contains("_code")) {
                    list.add(k);
                }
                if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.IMAGE.getType())) {
                    list.add(k);
                }
            });
            list.forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
        }
        for (Object obj : childDelData) {
            JSONArray childCountList;
            JSONArray childList;
            jsonObject = (JSONObject)obj;
            String cid = ((JSONObject)obj).getString("RECORD_ID");
            if (!grandChange.isEmpty()) {
                childList = grandChange.containsKey(cid) ? (JSONArray)grandChange.get(cid).getT1() : new JSONArray();
                childCountList = grandChange.containsKey(cid) ? (JSONArray)grandChange.get(cid).getT2() : new JSONArray();
            } else {
                childList = new JSONArray();
                childCountList = new JSONArray();
                HashMap<String, Object> oldParams = new HashMap<String, Object>();
                HashMap<String, Object> newParams = new HashMap<String, Object>();
                List keys = CollectionUtil.newArrayList((Iterable)jsonObject.keySet());
                for (String k2 : keys) {
                    if (!widgetMap.containsKey(k2) || !WidgetTool.isChildTableType((String)widgetMap.get(k2)) || !(jsonObject.get((Object)k2) instanceof JSONArray)) continue;
                    this.compareChild((JSONArray)jsonObject.get((Object)k2), new JSONArray(), childList, childCountList, newParams, oldParams, key, k2, widgetMap);
                }
            }
            jsonObject.replaceAll((k, v) -> {
                if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.JXDNLinkFormMulti.getType())) {
                    String refId = k + "_ref_id";
                    String refChildId = k + "_ref_child_id";
                    list.add(refId);
                    list.add(refChildId);
                    HashMap<String, String> newMap = new HashMap<String, String>();
                    HashMap<String, Object> oldMap = new HashMap<String, Object>();
                    oldMap.put((String)k, HussarUtils.isNotEmpty((Object)jsonObject.get(k)) ? jsonObject.get(k) : "");
                    oldMap.put(refId, HussarUtils.isNotEmpty((Object)jsonObject.get((Object)refId)) ? jsonObject.get((Object)refId) : "");
                    oldMap.put(refChildId, HussarUtils.isNotEmpty((Object)jsonObject.get((Object)refChildId)) ? jsonObject.get((Object)refChildId) : "");
                    newMap.put((String)k, "");
                    newMap.put(refId, "");
                    newMap.put(refChildId, "");
                    return new DataRecord(oldMap, newMap, HussarUtils.isEmpty((Object)jsonObject.get(k)) && HussarUtils.isEmpty((Object)jsonObject.get((Object)refId)) && HussarUtils.isEmpty((Object)jsonObject.get((Object)refChildId)) ? 3 : 2);
                }
                if (k.contains("_ref_id") || k.contains("_ref_child_id")) {
                    return jsonObject.get(k);
                }
                if (HussarUtils.isEmpty((Object)v)) {
                    return new DataRecord("", "", 3);
                }
                return new DataRecord(v, "", 2);
            });
            list.forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
            jsonObject.put("childRecord", (Object)childList);
            jsonObject.put("childCount", (Object)childCountList);
            jsonObject.put("row", (Object)new Mode("2"));
            if (childCount.containsKey((Object)"DEL")) {
                childCount.put("DEL", (Object)(Integer.parseInt(String.valueOf(childCount.get((Object)"DEL"))) + 1));
            } else {
                childCount.put("DEL", (Object)1);
            }
            updateChild.add((Object)jsonObject);
        }
    }

    private void handleChildNewData(JSONObject jsonObject, JSONArray updateChild, JSONObject childCount, String key, Map<String, Tuple2<JSONArray, JSONArray>> grandChange, Map<String, String> widgetMap) {
        JSONArray childCountList;
        JSONArray childList;
        ArrayList list = new ArrayList();
        String cid = jsonObject.getString("RECORD_ID");
        if (!grandChange.isEmpty()) {
            childList = grandChange.containsKey(cid) ? (JSONArray)grandChange.get(cid).getT1() : new JSONArray();
            childCountList = grandChange.containsKey(cid) ? (JSONArray)grandChange.get(cid).getT2() : new JSONArray();
        } else {
            childList = new JSONArray();
            childCountList = new JSONArray();
            HashMap<String, Object> oldParams = new HashMap<String, Object>();
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            List keys = CollectionUtil.newArrayList((Iterable)jsonObject.keySet());
            for (String k2 : keys) {
                if (!widgetMap.containsKey(k2) || !WidgetTool.isChildTableType((String)widgetMap.get(k2)) || !(jsonObject.get((Object)k2) instanceof JSONArray)) continue;
                this.compareChild(new JSONArray(), (JSONArray)jsonObject.get((Object)k2), childList, childCountList, newParams, oldParams, key, k2, widgetMap);
            }
        }
        jsonObject.forEach((k, v) -> {
            if (k.contains("_code")) {
                list.add(k);
            }
            if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.IMAGE.getType())) {
                list.add(k);
            }
        });
        list.forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
        jsonObject.replaceAll((k, v) -> {
            if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.JXDNLinkFormMulti.getType())) {
                String refId = k + "_ref_id";
                String refChildId = k + "_ref_child_id";
                list.add(refId);
                list.add(refChildId);
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                HashMap<String, String> oldMap = new HashMap<String, String>();
                newMap.put((String)k, HussarUtils.isNotEmpty((Object)jsonObject.get(k)) ? jsonObject.get(k) : "");
                newMap.put(refId, HussarUtils.isNotEmpty((Object)jsonObject.get((Object)refId)) ? jsonObject.get((Object)refId) : "");
                newMap.put(refChildId, HussarUtils.isNotEmpty((Object)jsonObject.get((Object)refChildId)) ? jsonObject.get((Object)refChildId) : "");
                oldMap.put((String)k, "");
                oldMap.put(refId, "");
                oldMap.put(refChildId, "");
                return new DataRecord(oldMap, newMap, HussarUtils.isEmpty((Object)jsonObject.get(k)) && HussarUtils.isEmpty((Object)jsonObject.get((Object)refId)) && HussarUtils.isEmpty((Object)jsonObject.get((Object)refChildId)) ? 3 : 0);
            }
            if (k.contains("_ref_id") || k.contains("_ref_child_id")) {
                return jsonObject.get(k);
            }
            if (HussarUtils.isEmpty((Object)v)) {
                return new DataRecord("", "", 3);
            }
            return new DataRecord("", v, 0);
        });
        list.forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
        jsonObject.put("childRecord", (Object)childList);
        jsonObject.put("childCount", (Object)childCountList);
        jsonObject.put("row", (Object)new Mode("0"));
        if (childCount.containsKey((Object)"ADD")) {
            childCount.put("ADD", (Object)(Integer.parseInt(String.valueOf(childCount.get((Object)"ADD"))) + 1));
        } else {
            childCount.put("ADD", (Object)1);
        }
        updateChild.add((Object)jsonObject);
    }

    private static boolean objEquals(Object oldObj, Object newObj) {
        if (oldObj == null && newObj == null) {
            return false;
        }
        if (oldObj == null) {
            return true;
        }
        if (newObj == null) {
            return true;
        }
        return !JSON.toJSONString((Object)oldObj).equals(JSON.toJSONString((Object)newObj));
    }

    private Map<String, Tuple2<JSONArray, JSONArray>> childEquals(JSONArray oldChildren, JSONArray newChildren, Map<String, Object> newParams, Map<String, Object> oldParams, String tableName, String key, Map<String, String> widgetMap) {
        if (HussarUtils.isEmpty((Object)oldChildren)) {
            if (HussarUtils.isNotEmpty((Object)newChildren)) {
                oldParams.put(key, "\u65e0\u6570\u636e");
                newParams.put(key, "\u65b0\u589e\u4e86\u6570\u636e");
            }
            return Collections.emptyMap();
        }
        if (HussarUtils.isEmpty((Object)newChildren)) {
            oldParams.put(key, "\u6709\u6570\u636e");
            newParams.put(key, "\u5220\u9664\u4e86\u6570\u636e");
            return Collections.emptyMap();
        }
        try {
            if (HussarUtils.isNotEmpty((Object)oldChildren) && HussarUtils.isNotEmpty((Object)newChildren)) {
                JSONObject childNew;
                JSONArray jsonArray;
                Object object;
                for (Object newO : newChildren) {
                    JSONObject newJsonO = (JSONObject)newO;
                    for (String newK : newJsonO.keySet()) {
                        if (!HussarUtils.isNotEmpty((Object)widgetMap.get(newK)) || !WidgetTool.isChildTableType((String)widgetMap.get(newK)) || !HussarUtils.isNotEmpty((Object)(object = newJsonO.get((Object)newK))) || !(object instanceof JSONArray)) continue;
                        jsonArray = (JSONArray)object;
                        for (Object childN : jsonArray) {
                            childNew = (JSONObject)childN;
                            childNew.remove((Object)"FORM_ID");
                        }
                    }
                }
                for (Object oldO : oldChildren) {
                    JSONObject oldJsonO = (JSONObject)oldO;
                    for (String newK : oldJsonO.keySet()) {
                        if (!HussarUtils.isNotEmpty((Object)widgetMap.get(newK)) || !WidgetTool.isChildTableType((String)widgetMap.get(newK)) || !HussarUtils.isNotEmpty((Object)(object = oldJsonO.get((Object)newK))) || !(object instanceof JSONArray)) continue;
                        jsonArray = (JSONArray)object;
                        for (Object childN : jsonArray) {
                            childNew = (JSONObject)childN;
                            childNew.remove((Object)"FORM_ID");
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            LOGGER.error("\u53bb\u9664\u5b59\u8868\u7684FORM_ID\u5b57\u6bb5\u5931\u8d25");
        }
        HashMap newgcs = new HashMap();
        HashMap oldgcs = new HashMap();
        HashMap<String, Tuple2<JSONArray, JSONArray>> childrenChange = new HashMap<String, Tuple2<JSONArray, JSONArray>>();
        if (!JSON.toJSONString((Object)newChildren).equals(JSON.toJSONString((Object)oldChildren))) {
            JSONArray newArr = new JSONArray();
            newChildren.forEach(newChild -> {
                JSONObject newCompare = DeepCopy.deepCopyJsonObject(newChild);
                newArr.add((Object)newCompare);
            });
            JSONArray oldArr = new JSONArray();
            oldChildren.forEach(oldChild -> {
                JSONObject oldCompare = DeepCopy.deepCopyJsonObject(oldChild);
                oldArr.add((Object)oldCompare);
            });
            newArr.forEach(newChild -> {
                JSONObject jsono = (JSONObject)newChild;
                Iterator it = jsono.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    String k = (String)next.getKey();
                    Object v = next.getValue();
                    if (k.contains("_label")) {
                        String[] strings = k.split("_label");
                        String string = strings[0];
                        if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                            it.remove();
                        }
                        if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                            it.remove();
                        }
                    }
                    if (!HussarUtils.isNotEmpty(widgetMap.get(k)) || !WidgetTool.isChildTableType((String)((String)widgetMap.get(k)))) continue;
                    it.remove();
                    if (StringUtil.equals((CharSequence)k, (CharSequence)key)) continue;
                    HashMap<String, JSONArray> c2gc = (HashMap<String, JSONArray>)newgcs.get(k);
                    if (c2gc == null) {
                        c2gc = new HashMap<String, JSONArray>();
                        newgcs.put(k, c2gc);
                    }
                    c2gc.put(jsono.getString("RECORD_ID"), (JSONArray)v);
                }
            });
            oldArr.forEach(oldChild -> {
                JSONObject jsono = (JSONObject)oldChild;
                Iterator it = jsono.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    String k = (String)next.getKey();
                    Object v = next.getValue();
                    if (k.contains("_label")) {
                        String[] strings = k.split("_label");
                        String string = strings[0];
                        if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                            it.remove();
                        }
                        if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                            it.remove();
                        }
                    }
                    if (!HussarUtils.isNotEmpty(widgetMap.get(k)) || !WidgetTool.isChildTableType((String)((String)widgetMap.get(k)))) continue;
                    it.remove();
                    if (StringUtil.equals((CharSequence)k, (CharSequence)key)) continue;
                    HashMap<String, JSONArray> c2gc = (HashMap<String, JSONArray>)oldgcs.get(k);
                    if (c2gc == null) {
                        c2gc = new HashMap<String, JSONArray>();
                        oldgcs.put(k, c2gc);
                    }
                    c2gc.put(jsono.getString("RECORD_ID"), (JSONArray)v);
                }
            });
            HashMap<String, Tuple4> changes = new HashMap<String, Tuple4>();
            boolean isChanged = false;
            for (String gc : CollectionUtils.union(newgcs.keySet(), oldgcs.keySet())) {
                Map nc2gcs = (Map)newgcs.get(gc);
                Map oc2gcs = (Map)oldgcs.get(gc);
                for (String cid : CollectionUtils.union(nc2gcs.keySet(), oc2gcs.keySet())) {
                    Tuple4 tp = (Tuple4)changes.get(cid);
                    if (tp == null) {
                        tp = Tuples.of((Object)new JSONArray(), (Object)new JSONArray(), new HashMap(), new HashMap());
                        changes.put(cid, tp);
                    }
                    JSONArray childList = (JSONArray)tp.getT1();
                    JSONArray childCountList = (JSONArray)tp.getT2();
                    Map nps = (Map)tp.getT3();
                    Map ops = (Map)tp.getT4();
                    this.compareChild(Optional.of(oc2gcs).map(e -> (JSONArray)e.get(cid)).orElse(new JSONArray()), Optional.of(nc2gcs).map(e -> (JSONArray)e.get(cid)).orElse(new JSONArray()), childList, childCountList, nps, ops, tableName, gc, widgetMap);
                    if (CollectionUtil.isEmpty((Collection)childList)) continue;
                    isChanged = true;
                    childrenChange.put(cid, (Tuple2<JSONArray, JSONArray>)Tuples.of((Object)childList, (Object)childCountList));
                }
            }
            if (isChanged || !JSON.toJSONString((Object)newArr).equals(JSON.toJSONString((Object)oldArr))) {
                oldParams.put(key, "\u6709\u6570\u636e");
                newParams.put(key, "\u4fee\u6539\u4e86\u6570\u636e");
            }
        }
        return childrenChange;
    }

    public Map<String, String> getWidgets(String formId) {
        FormCanvasSchema canvasSchema = Optional.ofNullable(this.canvasSchemaService.get(formId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25"));
        return WidgetTool.flatAllWidget((List)canvasSchema.getWidgets()).stream().collect(Collectors.toMap(e -> e.getName(), e -> e.getType(), (key1, key2) -> key2));
    }

    public Map<String, Widget> getWidgetsObj(String formId) {
        FormCanvasSchema canvasSchema = Optional.ofNullable(this.canvasSchemaService.get(formId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25"));
        return WidgetTool.flatAllWidget((List)canvasSchema.getWidgets()).stream().collect(Collectors.toMap(e -> e.getName(), e -> e, (key1, key2) -> key2));
    }

    private void cleanData(JSONObject data, int mode, String tableName, Map<String, String> widgetMap) {
        LOGGER.info("\u753b\u5e03\u6570\u636e\uff1a{}", widgetMap);
        List widgets = DataOprLogConst.widgets();
        ArrayList<String> widgetTypes = new ArrayList<String>();
        widgetTypes.add(WidgetType.JXDNOrgMulti.getType());
        widgetTypes.add(WidgetType.JXDNUserMulti.getType());
        widgetTypes.add(WidgetType.JXDNUser.getType());
        widgetTypes.add(WidgetType.SELECT_MUL.getType());
        widgetTypes.add(WidgetType.JXDNOrg.getType());
        widgetTypes.add(WidgetType.FILE.getType());
        widgetTypes.add(WidgetType.SELECT.getType());
        widgetTypes.add(WidgetType.RADIO_GROUP.getType());
        widgetTypes.add(WidgetType.CHECK_BOX_GROUP.getType());
        widgetTypes.add(WidgetType.JXDN_CASCADER.getType());
        widgetTypes.add(WidgetType.JXDN_CASCADER_MULTI.getType());
        widgetTypes.add(WidgetType.JXDN_DATA_QUERY.getType());
        data.forEach((key, value) -> {
            if (widgetTypes.contains(widgetMap.get(key))) {
                widgets.add(key);
            }
        });
        ArrayList<String> list = new ArrayList<String>();
        if (mode == 1) {
            ArrayList<String> childWidgets = new ArrayList<String>();
            childWidgets.add(WidgetType.CHILDREN_TABLE.getType());
            childWidgets.add(WidgetType.JXDNChildrenTableAgg.getType());
            data.forEach((key, value) -> {
                if (childWidgets.contains(widgetMap.get(key))) {
                    widgets.add(key);
                }
            });
            widgets.add("F_RECORD_ID");
            widgets.add("RECORD_ID");
            widgets.add(tableName);
        }
        data.forEach((key, value) -> {
            for (String widget : widgets) {
                boolean isWidget = false;
                if (key.contains(widget) && !key.contains("_label")) {
                    list.add((String)key);
                    isWidget = true;
                }
                if (HussarUtils.isNotEmpty(widgetMap.get(key)) && ((String)widgetMap.get(key)).equals(WidgetType.ADDRESS.getType())) {
                    list.add((String)key);
                    isWidget = true;
                }
                if (!isWidget) continue;
                break;
            }
        });
        list.add("securityLevel");
        list.add("securityLevel_label");
        for (String key2 : list) {
            data.remove((Object)key2);
        }
    }

    private void cleanChildData(JSONArray jsonArray, String tableName, Map<String, String> widgetMap) {
        if (HussarUtils.isNotEmpty((Object)jsonArray)) {
            for (Object obj : jsonArray) {
                JSONObject jsonObject = (JSONObject)obj;
                this.cleanData(jsonObject, 1, tableName, widgetMap);
            }
        }
    }

    public LocalDateTime localDateTime() {
        return LocalDateTime.now();
    }

    private static class Mode {
        private String mode;

        public Mode() {
        }

        public Mode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }
    }

    private static class DataRecord {
        private Object oldData;
        private Object newData;
        private int mode;

        public DataRecord() {
        }

        public DataRecord(Object oldData, Object newData, int mode) {
            this.oldData = oldData;
            this.newData = newData;
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public Object getOldData() {
            return this.oldData;
        }

        public void setOldData(Object oldData) {
            this.oldData = oldData;
        }

        public Object getNewData() {
            return this.newData;
        }

        public void setNewData(Object newData) {
            this.newData = newData;
        }
    }
}

