/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.data.service.impl.PullDataServiceImpl;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormCheckConfig;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeOrderService;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogThreadLocal;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysFileInfoDashboardService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.dto.ScriptBaseAssemble;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptRecord;
import com.jxdinfo.hussar.formdesign.application.property.service.IPageExpService;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.tool.SnowflakeID;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.FormMigrateUtil;
import com.jxdinfo.hussar.formdesign.application.util.ImportUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseSetting;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.NavLeftTreeOption;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.WidgetItem;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.business.util.FormCanvasUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportInfoServiceImpl")
public class FormImportInfoServiceImpl
implements IFormImportInfoService {
    @Resource
    private OperateLogThreadLocal operateLogThreadLocal;
    @Resource
    private ISysFormService formService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private OssService ossService;
    @Resource
    private IPageExpService pageExpService;
    @Resource
    private IWidgetExpService widgetExpService;
    @Resource
    private ISysRuleInfoService ruleInfoService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private SysMsgPushConfigService msgPushConfigService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private PullDataServiceImpl pullDataService;
    @Resource
    private FormMapService formMapService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormImportInfoServiceImpl.class);
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private AppImportInfoServiceImpl appImportInfoService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private SysDataPullTaskService sysDataPullTaskService;
    @Resource
    private SnowflakeID snowflakeID;
    @Resource
    private INavLeftTreeOrderService navLeftTreeOrderService;
    @Resource
    private ISysFormExtApiService sysFormExtApiService;
    @Resource
    private ISysFileInfoDashboardService sysFileInfoDashboardService;
    @Resource
    private IFormUpgradeInfoService formUpgradeInfoService;

    @ImportProgressCache(status=1, msg="\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6570\u636e")
    public void importFormData(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        Long userId = BaseSecurityUtil.getUser().getUserId();
        SysForm form = importMappingDto.getFormDataInit().getForm();
        if (HussarUtils.isEmpty((Object)formImportDto.getFormType())) {
            formImportDto.setFormType(form.getFormType());
        }
        if (HussarUtils.isNotEmpty((Object)form)) {
            Long oldFormId = form.getId();
            String oldTableName = form.getTableName();
            Long oldAppId = form.getAppId();
            Long newFormId = IdWorker.getId((Object)new SysForm());
            if (importMappingDto.isKeepTableName()) {
                newFormId = form.getId();
            }
            form.setId(newFormId);
            form.setAppId(formImportDto.getAppId());
            String oldFormName = form.getFormName();
            String newFormName = formImportDto.getFormName();
            form.setFormName(newFormName);
            if (HussarUtils.isNotEmpty((Object)formImportDto.getFormIconType())) {
                form.setFormIconType(formImportDto.getFormIconType());
            } else {
                form.setFormIconType("1");
            }
            if (HussarUtils.isNotEmpty((Object)formImportDto.getFormIcon())) {
                form.setFormIcon(formImportDto.getFormIcon());
            } else {
                form.setFormIcon("caidan-1Jmoren");
            }
            if (HussarUtils.isNotEmpty((Object)formImportDto.getFormIconColor())) {
                form.setFormIconColor(formImportDto.getFormIconColor());
            } else {
                form.setFormIconColor("#2794F8");
            }
            form.setSourceFormId(null);
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(form.getCreateSource())) {
                form.setCreateSource(null);
            }
            String newTableName = null;
            newTableName = importMappingDto.isKeepTableName() ? form.getTableName() : this.checkAndGenerateTableName(form.getTableName(), importMappingDto);
            DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
            String jdbcUrl = bean.getCurrentDatasource().getUrl();
            String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
            if (HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)dbType)) {
                newTableName = newTableName.toLowerCase();
            }
            form.setTableName(newTableName);
            form.setFormGroupId(formImportDto.getFormGroupId());
            form.setCreator(userId);
            form.setCreateTime(LocalDateTime.now());
            form.setLastEditor(userId);
            form.setLastTime(LocalDateTime.now());
            form.setI18nKeys(formImportDto.getI18nKeys());
            this.formService.save((Object)form);
            SysFormDto sysFormDto = new SysFormDto();
            BeanUtils.copyProperties((Object)form, (Object)sysFormDto);
            if (!"3".equals(form.getFormType())) {
                importMappingDto.getFormIdMap().put(oldFormId, newFormId);
                importMappingDto.getTableNameMap().put(oldTableName, newTableName);
                importMappingDto.getFormNameMap().put(oldFormName, newFormName);
            }
            importMappingDto.setNewAppId(formImportDto.getAppId());
            importMappingDto.setOldAppId(oldAppId);
        }
    }

    private String checkAndGenerateTableName(String tableName, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        String newTableName = null;
        for (int i = 0; i < 5; ++i) {
            int length = tableName.length();
            int suffixLength = Math.min(63 - length, 4);
            String uid = String.valueOf(IdWorker.getId((Object)suffixLength));
            String random = uid.substring(18 - suffixLength);
            newTableName = tableName + "_" + random;
            List sysForms = (List)this.formService.getFormsByTableNames(Arrays.asList(newTableName)).getData();
            if (HussarUtils.isEmpty((Object)sysForms)) {
                importMappingDto.setSpliceSuffix(random);
                break;
            }
            if (i != 4 || !HussarUtils.isNotEmpty((Object)sysForms)) continue;
            LOGGER.error("\u6570\u636e\u5e93\u8868\u540d\u968f\u673a\u62fc\u63a5\u540e\u7f00\u91cd\u590d");
            throw new RuntimeException();
        }
        return newTableName;
    }

    @ImportProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u5165\u4eea\u8868\u76d8\u6570\u636e")
    public void importDashboardData(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        this.importDashboardImage(formImportDto, importMappingDto);
        JSONArray dashEntryArray = importMappingDto.getFormDataInit().getDashEntry();
        if (HussarUtils.isEmpty((Object)dashEntryArray)) {
            return;
        }
        List<DashEntry> dashEntryList = FormMigrateUtil.parseJsonArrayToList(dashEntryArray, DashEntry.class);
        Long panelId = null;
        panelId = importMappingDto.isKeepTableName() ? dashEntryList.get(0).getEntryId() : (Long)importMappingDto.getFormIdMap().get(dashEntryList.get(0).getEntryId());
        String newFormName = (String)importMappingDto.getFormNameMap().get(dashEntryList.get(0).getEntryName());
        String newGroupId = formImportDto.getFormGroupId() == null ? null : formImportDto.getFormGroupId().toString();
        String newIcon = formImportDto.getFormIcon().toString();
        this.dashEntryService.importPanelData(panelId, newIcon, newGroupId, newFormName, importMappingDto.getNewAppId(), dashEntryList, importMappingDto.getFormIdMap(), importMappingDto.getDashboardImageIdMap(), Boolean.valueOf(importMappingDto.isKeepTableName()));
    }

    @ImportProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u5165\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void importMidFile(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws Exception {
        this.recordReplaceMapping(formImportDto, importMappingDto);
        AppContextUtil.setAppId((String)String.valueOf(formImportDto.getAppId()));
        this.importCustomButton(formImportDto, importMappingDto);
        this.importScript(formImportDto, importMappingDto);
        String tableName = (String)importMappingDto.getTableNameMap().entrySet().iterator().next().getKey();
        String newSettingFormId = "";
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        HashMap titleReplaceMap = new HashMap();
        importMappingDto.getFormNameMap().forEach((key, value) -> {
            titleReplaceMap.put("\"title\":\"" + key + "\"", "\"title\":\"" + value + "\"");
            titleReplaceMap.put("\"formTitle\":\"" + key + "\"", "\"formTitle\":\"" + value + "\"");
        });
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(titleReplaceMap);
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        replaceMap.putAll(importMappingDto.getProcessKeyMap());
        replaceMap.putAll(importMappingDto.getScriptRecordMap());
        replaceMap.putAll(importMappingDto.getScriptMethodMap());
        String canvasPath = importMappingDto.getFormDataInit().getCanvasPath();
        FormCanvasSchema formCanvasSchema = FormMigrateUtil.readFileToObjectWithReplace(canvasPath, FormCanvasSchema.class, replaceMap);
        formCanvasSchema.setAppId(String.valueOf(formImportDto.getAppId()));
        formCanvasSchema.setTitle((String)importMappingDto.getFormNameMap().get(formCanvasSchema.getTitle()));
        List references = formCanvasSchema.getReferences();
        String newFormId = String.valueOf(new ArrayList(importMappingDto.getFormIdMap().values()).get(0));
        ArrayList<Widget> linkWidgetList = new ArrayList<Widget>();
        ArrayList<Widget> selectWidgetList = new ArrayList<Widget>();
        List widgets = formCanvasSchema.getWidgets();
        if (HussarUtils.isNotEmpty((Object)widgets)) {
            String formId;
            String linkFormId;
            for (Widget widget : widgets) {
                linkWidgetList.addAll(this.getWidgetByType(widget, Arrays.asList(WidgetType.JXDNLinkForm, WidgetType.JXDNLinkFormMulti)));
                linkWidgetList.addAll(this.getWidgetByType(widget, Arrays.asList(WidgetType.JXDN_CASCADER, WidgetType.JXDN_CASCADER_MULTI)));
                linkWidgetList.addAll(this.getWidgetByType(widget, Collections.singletonList(WidgetType.JXDN_DATA_QUERY)));
                selectWidgetList.addAll(this.getWidgetByType(widget, Arrays.asList(WidgetType.SELECT, WidgetType.SELECT_MUL)));
            }
            for (Widget widget : linkWidgetList) {
                JSONObject linkTableInfo = (JSONObject)widget.getProps().get((Object)"linkTableInfo");
                linkFormId = (String)linkTableInfo.get((Object)"formId");
                formId = formCanvasSchema.getId();
                if (!formId.equals(linkFormId)) continue;
                linkTableInfo.put("appId", (Object)importMappingDto.getNewAppId());
            }
            for (Widget widget : selectWidgetList) {
                JSONObject async = (JSONObject)widget.getProps().get((Object)"async");
                linkFormId = (String)async.get((Object)"formId");
                formId = formCanvasSchema.getId();
                if (!formId.equals(linkFormId)) continue;
                async.put("appId", (Object)importMappingDto.getNewAppId());
            }
        }
        if (HussarUtils.isNotEmpty((Object)references)) {
            this.processReferences(references, importMappingDto, newFormId);
        }
        formCanvasSchema.setReferences(references);
        if (ToolUtil.isNotEmpty((Object)formCanvasSchema)) {
            newSettingFormId = formCanvasSchema.getId();
            if (!this.isCover(importMappingDto)) {
                this.clearSerialNumberId(formCanvasSchema);
            }
            FormCanvasUtil.dealUseExistingRule((FormCanvasSchema)formCanvasSchema);
            formCanvasSchema.setSourceFormId(null);
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(formCanvasSchema.getCreateSource())) {
                formCanvasSchema.setCreateSource(null);
            }
            this.canvasService.saveCanvasForImport(formCanvasSchema, (ImportMappingDto)importMappingDto);
        }
        String settingPath = importMappingDto.getFormDataInit().getSettingPath();
        HashMap<Object, Object> settingReplaceMap = new HashMap<Object, Object>();
        settingReplaceMap.putAll(importMappingDto.getSubTableNameMap());
        settingReplaceMap.putAll(importMappingDto.getFormIdMap());
        settingReplaceMap.putAll(importMappingDto.getScriptRecordMap());
        settingReplaceMap.putAll(importMappingDto.getScriptMethodMap());
        FormSettingSchema formSettingSchema = FormMigrateUtil.readFileToObjectWithReplace(settingPath, FormSettingSchema.class, settingReplaceMap);
        if (ToolUtil.isNotEmpty((Object)formSettingSchema)) {
            formSettingSchema.setAppId(String.valueOf(formImportDto.getAppId()));
            SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
            bean.saveOrUpdate((BaseSetting)formSettingSchema, newSettingFormId);
        }
        String viewPath = importMappingDto.getFormDataInit().getViewPath();
        HashMap<Object, Object> viewReplaceMap = new HashMap<Object, Object>();
        viewReplaceMap.putAll(importMappingDto.getTableNameMap());
        viewReplaceMap.putAll(importMappingDto.getSubTableNameMap());
        viewReplaceMap.putAll(importMappingDto.getScriptRecordMap());
        viewReplaceMap.putAll(importMappingDto.getScriptMethodMap());
        FormViewSchema formViewSchema = FormMigrateUtil.readFileToObjectWithReplace(viewPath, FormViewSchema.class, viewReplaceMap);
        formViewSchema.setFormTitle((String)importMappingDto.getFormNameMap().get(formViewSchema.getFormTitle()));
        if (ToolUtil.isNotEmpty((Object)formViewSchema)) {
            formViewSchema.setAppId(String.valueOf(formImportDto.getAppId()));
            Long oldFormId = Long.valueOf(formViewSchema.getFormId());
            newFormId = String.valueOf(importMappingDto.getFormIdMap().get(oldFormId));
            formViewSchema.setFormId(newFormId);
            this.processLeftTree(importMappingDto, formViewSchema.getViews(), oldFormId, Long.valueOf(newFormId));
            this.viewService.save(formViewSchema);
        }
        this.importCheckConfig(formImportDto, importMappingDto);
        this.importMsgPush(formImportDto, importMappingDto);
        this.importPrintTemplate(formImportDto, importMappingDto);
        this.importFormLink(formImportDto, importMappingDto);
        this.importDataPush(formImportDto, importMappingDto);
        this.importDataPushMap(formImportDto, importMappingDto);
        this.importDataPull(formImportDto, importMappingDto);
        this.importPublicView(formImportDto, importMappingDto);
        this.importLeftTreeData(formImportDto, importMappingDto);
        this.importExtensionApi(formImportDto, importMappingDto);
    }

    public void importLeftTreeData(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        try {
            List dragOrders = importMappingDto.getFormDataInit().getDragOrders();
            if (HussarUtils.isEmpty((Object)dragOrders)) {
                return;
            }
            HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
            replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
            replaceMap.putAll(importMappingDto.getFormIdMap());
            replaceMap.putAll(importMappingDto.getPublicViewMap());
            FormMigrateUtil.updateObj(dragOrders, replaceMap, List.class);
            if (HussarUtils.isNotEmpty((Object)dragOrders)) {
                dragOrders.forEach(dragOrder -> dragOrder.setId(this.isCover(importMappingDto) ? dragOrder.getId() : null));
                this.navLeftTreeOrderService.saveBatch((Collection)dragOrders);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5de6\u4fa7\u6811\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new HussarException("\u5bfc\u5165\u5de6\u4fa7\u6811\u6570\u636e\u5f02\u5e38");
        }
    }

    public void processLeftTree(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto, List<DataView> dataViews, Long oldFormId, Long newFormId) {
        Long newAppId = importMappingDto.getNewAppId();
        for (DataView dataView : dataViews) {
            int viewType = dataView.getViewType();
            NavLeftTreeOption leftTreeOption = dataView.getNavLeftTreeOption();
            switch (viewType) {
                case 1: {
                    WidgetItem filterWidget = leftTreeOption.getFilterWidget();
                    filterWidget.setAppId(newAppId);
                    filterWidget.setFormId((Long)importMappingDto.getFormIdMap().get(filterWidget.getFormId()));
                    WidgetItem linkWidget = leftTreeOption.getLinkWidget();
                    WidgetItem supWidget = leftTreeOption.getSupWidget();
                    if (!HussarUtils.equals((Object)linkWidget.getFormId(), (Object)oldFormId)) break;
                    linkWidget.setAppId(newAppId);
                    linkWidget.setFormId(newFormId);
                    supWidget.setAppId(newAppId);
                    supWidget.setFormId(newFormId);
                    break;
                }
                case 2: {
                    WidgetItem titleWidget = leftTreeOption.getTitleWidget();
                    WidgetItem linkWidget = leftTreeOption.getLinkWidget();
                    WidgetItem supWidget = leftTreeOption.getSupWidget();
                    titleWidget.setAppId(newAppId);
                    titleWidget.setFormId((Long)importMappingDto.getFormIdMap().get(titleWidget.getFormId()));
                    linkWidget.setAppId(newAppId);
                    linkWidget.setFormId(newFormId);
                    supWidget.setAppId(newAppId);
                    supWidget.setFormId(newFormId);
                    break;
                }
            }
        }
    }

    public void processReferences(List<Map<String, Object>> references, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto, String newFormId) {
        ArrayList<Map<Object, Object>> updatedReferences = new ArrayList<Map<Object, Object>>(references.size());
        for (Map<String, Object> reference : references) {
            List children = (List)reference.get("children");
            ArrayList<String> formIds = new ArrayList<String>();
            for (Object obj : children) {
                if (!(obj instanceof String)) continue;
                formIds.add((String)obj);
            }
            if (String.valueOf(importMappingDto.getOldAppId()).equals(String.valueOf(reference.get("appId")))) {
                HashMap<String, Object> updatedReference;
                if (formIds.contains(newFormId)) {
                    formIds.remove(newFormId);
                    updatedReference = new HashMap();
                    updatedReference.put("appId", importMappingDto.getNewAppId());
                    updatedReference.put("children", Collections.singletonList(newFormId));
                    updatedReferences.add(updatedReference);
                }
                if (!HussarUtils.isNotEmpty(formIds)) continue;
                updatedReference = new HashMap<String, Object>();
                updatedReference.put("appId", importMappingDto.getOldAppId());
                updatedReference.put("children", formIds);
                updatedReferences.add(updatedReference);
                continue;
            }
            updatedReferences.add(reference);
        }
        references.clear();
        references.addAll(updatedReferences);
    }

    private List<Widget> getWidgetByType(Widget widget, List<WidgetType> widgetTypeList) {
        ArrayList<Widget> result = new ArrayList<Widget>();
        if (HussarUtils.isEmpty((Object)widget)) {
            return result;
        }
        WidgetType widgetType = WidgetType.getWidgetType((String)widget.getType());
        if (widgetTypeList.contains(widgetType)) {
            result.add(widget);
        } else if (HussarUtils.isNotEmpty((Object)widget.getChildren())) {
            for (Widget child : widget.getChildren()) {
                result.addAll(this.getWidgetByType(child, widgetTypeList));
            }
        }
        return result;
    }

    public void importPrintTemplate(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        try {
            List<SysPrintTemplate> printTemplates = importMappingDto.getFormDataInit().getPrintTemplates();
            if (HussarUtils.isNotEmpty((Object)printTemplates)) {
                printTemplates = FormMigrateUtil.updateObj(printTemplates, this.formUpgradeInfoService.getReplaceMapAppIdAndGroupId(importMappingDto), List.class);
                printTemplates = FormMigrateUtil.parseListObjectoList(printTemplates, SysPrintTemplate.class);
                String templateFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "printTemplate", "templateFile"});
                this.sysPrintTemplateService.importPrintTemplate((ImportMappingDto)importMappingDto, printTemplates, templateFilePath);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u6253\u5370\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    private void importCustomButton1(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        JSONArray customButtonJsonArray;
        List<SysCustomButton> customButtons;
        String customButtonPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "customButton.json"});
        JSONObject jsonObject = FormMigrateUtil.readFileToObject(customButtonPath, JSONObject.class);
        if (ToolUtil.isNotEmpty((Object)jsonObject) && HussarUtils.isNotEmpty(customButtons = FormMigrateUtil.parseJsonArrayToList(customButtonJsonArray = (JSONArray)jsonObject.getObject("customButtonData", JSONArray.class), SysCustomButton.class))) {
            String customButtonsStr = JSONObject.toJSONString(customButtons);
            ArrayList sortedEntries = new ArrayList(importMappingDto.getSubTableNameMap().entrySet());
            sortedEntries.sort((o1, o2) -> ((String)o2.getKey()).length() - ((String)o1.getKey()).length());
            for (Map.Entry entry : sortedEntries) {
                customButtonsStr = customButtonsStr.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            List customButtonsNew = JSONArray.parseArray((String)customButtonsStr, SysCustomButton.class);
            customButtonsNew.forEach(button -> {
                button.setId(this.isCover(importMappingDto) ? button.getId() : null);
                button.setAppId(formImportDto.getAppId());
                button.setFormId((Long)importMappingDto.getFormIdMap().get(button.getFormId()));
            });
            this.sysCustomButtonService.saveBatch((Collection)customButtonsNew);
        }
    }

    public void importCustomButton(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        List<SysCustomButton> customButtons = importMappingDto.getFormDataInit().getCustomButton();
        if (HussarUtils.isEmpty((Object)customButtons)) {
            return;
        }
        customButtons = FormMigrateUtil.updateObj(customButtons, this.formUpgradeInfoService.getReplaceMapAppIdAndGroupId(importMappingDto), List.class);
        customButtons = FormMigrateUtil.parseListObjectoList(customButtons, SysCustomButton.class);
        this.importCustomButton(customButtons, importMappingDto);
    }

    public void importCustomButton(List<SysCustomButton> customButtons, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        if (ToolUtil.isEmpty(customButtons)) {
            return;
        }
        HashMap customButtonIdMap = new HashMap();
        this.appImportInfoService.replaceCustomButton((ImportMappingDto)importMappingDto, customButtons, "2");
        if (!this.isCover(importMappingDto)) {
            customButtons.forEach(e -> {
                Long id = IdWorker.getId((Object)e);
                customButtonIdMap.put(e.getId(), id);
                e.setId(id);
            });
        }
        this.sysCustomButtonService.saveBatch(customButtons);
        importMappingDto.setCustomButtonIdMap(customButtonIdMap);
    }

    private void importBusinessRule2(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws IOException {
        String ruleFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "rule.json"});
        File file = new File(ruleFilePath);
        if (!file.exists()) {
            return;
        }
        String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        List ruleCardVos = JSONArray.parseArray((String)text, RuleFullVo.class);
        for (RuleFullVo rule : ruleCardVos) {
            rule.setRuleId(this.isCover(importMappingDto) ? rule.getRuleId() : null);
            rule.setAppId(String.valueOf(formImportDto.getAppId()));
            rule.setSourceForm(String.valueOf(importMappingDto.getFormIdMap().get(Long.parseLong(rule.getSourceForm()))));
            Map subTableNameMap = importMappingDto.getSubTableNameMap();
            for (JSONObject object : rule.getActions()) {
                List actions;
                JSONObject filterStr = object.getJSONObject("filter");
                List filters = JSONArray.parseArray((String)filterStr.getString("cond"), JSONObject.class);
                if (HussarUtils.isNotEmpty((Object)filters)) {
                    for (JSONObject filter : filters) {
                        String newSubFormName;
                        String oldSubFormName;
                        JSONObject depend = filter.getJSONObject("depend");
                        if (!HussarUtils.isNotEmpty((Object)depend) || !HussarUtils.isNotEmpty((Object)(oldSubFormName = depend.getString("parent"))) || !HussarUtils.isNotEmpty((Object)(newSubFormName = (String)subTableNameMap.get(oldSubFormName)))) continue;
                        depend.put("parent", (Object)newSubFormName);
                        filter.put("depend", (Object)depend);
                    }
                    filterStr.put("cond", (Object)filters);
                    object.put("filter", (Object)filterStr);
                }
                if (!HussarUtils.isNotEmpty((Object)(actions = JSONArray.parseArray((String)object.getString("values"), JSONObject.class)))) continue;
                for (JSONObject action : actions) {
                    String newSubFormName;
                    String oldSubFormName;
                    JSONObject depend = action.getJSONObject("depend");
                    if (!HussarUtils.isNotEmpty((Object)depend) || !HussarUtils.isNotEmpty((Object)(oldSubFormName = depend.getString("parent"))) || !HussarUtils.isNotEmpty((Object)(newSubFormName = (String)subTableNameMap.get(oldSubFormName)))) continue;
                    depend.put("parent", (Object)newSubFormName);
                    action.put("depend", (Object)depend);
                }
                object.put("values", (Object)actions);
            }
            try {
                this.ruleInfoService.saveRule(rule);
            }
            catch (Exception e) {
                LOGGER.error("\u5bfc\u5165\u4e1a\u52a1\u89c4\u5219\u65f6\uff0c\u62a5\u9519", (Throwable)e);
            }
        }
    }

    public void importBusinessRule(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws IOException {
        this.importBusinessRule(importMappingDto.getFormDataInit().getRules(), importMappingDto);
    }

    public void importBusinessRule(List<RuleFullVo> ruleFullVos, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws IOException {
        if (HussarUtils.isEmpty(ruleFullVos)) {
            return;
        }
        String text = JSON.toJSONString(ruleFullVos);
        ArrayList sortedEntries = new ArrayList(importMappingDto.getSubTableNameMap().entrySet());
        HashMap<String, String> appIdMap = new HashMap<String, String>();
        appIdMap.put(String.valueOf(importMappingDto.getOldAppId()), String.valueOf(importMappingDto.getNewAppId()));
        sortedEntries.addAll(appIdMap.entrySet());
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry entry : importMappingDto.getFormIdMap().entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            stringMap.put(key, value);
        }
        sortedEntries.addAll(stringMap.entrySet());
        sortedEntries.sort((o1, o2) -> ((String)o2.getKey()).length() - ((String)o1.getKey()).length());
        for (Map.Entry entry : sortedEntries) {
            text = text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        List ruleNew = JSONArray.parseArray((String)text, RuleFullVo.class);
        for (RuleFullVo rule : ruleNew) {
            rule.setRuleId(this.isCover(importMappingDto) ? rule.getRuleId() : null);
            rule.setAppId(String.valueOf(importMappingDto.getNewAppId()));
            try {
                this.ruleInfoService.saveRule(rule);
            }
            catch (Exception e) {
                LOGGER.error("\u5bfc\u5165\u4e1a\u52a1\u89c4\u5219\u65f6\uff0c\u62a5\u9519", (Throwable)e);
            }
        }
    }

    public void importFormLink(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        JSONObject jsonObject = importMappingDto.getFormDataInit().getFormLinkObject();
        this.sysFormLinkService.saveBatchImportData(jsonObject, (ImportMappingDto)importMappingDto);
    }

    public void importCheckConfig(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws IOException {
        SysFormCheckConfig sysFormCheckConfig;
        List checkConfigs = importMappingDto.getFormDataInit().getCheckConfigs();
        if (HussarUtils.isNotEmpty((Object)checkConfigs) && HussarUtils.isNotEmpty((Object)(sysFormCheckConfig = (SysFormCheckConfig)checkConfigs.get(0)))) {
            String checkConfig = sysFormCheckConfig.getCheckConfig();
            String json = JSON.parse((String)checkConfig).toString();
            for (Map.Entry entry : importMappingDto.getSubTableNameMap().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!json.contains(key)) continue;
                json = json.replace(key, value);
            }
            sysFormCheckConfig.setCheckConfigId(this.isCover(importMappingDto) ? sysFormCheckConfig.getCheckConfigId() : null);
            sysFormCheckConfig.setCheckConfig(json);
            sysFormCheckConfig.setFormId((Long)importMappingDto.getFormIdMap().get(sysFormCheckConfig.getFormId()));
            this.sysFormCheckConfigService.save((Object)sysFormCheckConfig);
        }
    }

    @ImportProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u5165\u6d41\u7a0b\u914d\u7f6e\u6570\u636e")
    public void importFlowData(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        Map formGroupMap = importMappingDto.getFormGroupMap();
        if (HussarUtils.isNotEmpty((Object)formGroupMap)) {
            HashMap formGroupMapNotNull = Maps.newHashMapWithExpectedSize((int)5);
            formGroupMap.forEach((k, v) -> {
                if (HussarUtils.isEmpty((Object)k)) {
                    formGroupMapNotNull.put(0L, HussarUtils.isEmpty((Object)v) ? 0L : v);
                } else {
                    formGroupMapNotNull.put(k, v);
                }
            });
            importMappingDto.setFormGroupMap((Map)formGroupMapNotNull);
        }
        this.recordReplaceMappingOfFlow(importMappingDto);
        JSONObject flowData = importMappingDto.getFormDataInit().getFlowData();
        HashMap<String, List<WorkflowDumpVo>> workflowDumpVoListMap = new HashMap<String, List<WorkflowDumpVo>>();
        if (ToolUtil.isNotEmpty((Object)flowData)) {
            for (String key : flowData.keySet()) {
                JSONArray data = (JSONArray)flowData.getObject(key, JSONArray.class);
                List<WorkflowDumpVo> workflowDumpVos = FormMigrateUtil.parseJsonArrayToList(data, WorkflowDumpVo.class);
                workflowDumpVoListMap.put(key, workflowDumpVos);
            }
        }
        com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto flowImportMappingDto = new com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto();
        BeanUtils.copyProperties((Object)importMappingDto, (Object)flowImportMappingDto);
        if (ToolUtil.isNotEmpty((Object)importMappingDto.getTableNameMap())) {
            Map<String, String> mainTableNameMap = importMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setMainTableNameMap(mainTableNameMap);
        }
        if (ToolUtil.isNotEmpty((Object)importMappingDto.getTaskTableNameMap())) {
            Map<String, String> taskTableNameMap = importMappingDto.getTaskTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setTaskTableNameMap(taskTableNameMap);
        }
        flowImportMappingDto.setMainTableBusinessKeyMap(importMappingDto.getTableNameMap());
        flowImportMappingDto.getMainTableBusinessKeyMap().put("RECORD_ID", "RECORD_ID");
        LOGGER.info("======================\u5e94\u7528:\u3010{}\u3011,\u8868\u5355\uff1a\u3010{}\u3011,\u6d41\u7a0b\u914d\u7f6e\u6570\u636e\u4f20\u5165\u6d41\u7a0b\u5165\u53c2\uff1a{}", new Object[]{formImportDto.getAppId(), formImportDto.getId(), JSONObject.toJSONString((Object)flowImportMappingDto)});
        this.flowMigrateService.importWorkflow(workflowDumpVoListMap, flowImportMappingDto);
        importMappingDto.setFormGroupMap(formGroupMap);
    }

    @ImportProgressCache(status=4, msg="\u6b63\u5728\u5bfc\u5165\u4e1a\u52a1\u6570\u636e")
    @OperateLogTypeCache(mode=5)
    public void importBusinessData(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws Exception {
        this.saveOrUpdateBusinessData(formImportDto, importMappingDto);
    }

    public void saveOrUpdateBusinessData(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws IOException {
        JSONObject businessData = new JSONObject();
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType)) {
            JSONObject data = importMappingDto.getFormDataInit().getBusinessData();
            if (HussarUtils.isNotEmpty((Object)data)) {
                JSONObject dataWithLowercaseKeys = new JSONObject();
                data.forEach((k, v) -> dataWithLowercaseKeys.put(k.toLowerCase(), v));
                businessData = dataWithLowercaseKeys;
            }
        } else {
            businessData = importMappingDto.getFormDataInit().getBusinessData();
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        replaceMap.putAll(importMappingDto.getProcessKeyMap());
        replaceMap.putAll(importMappingDto.getAppIdMap());
        replaceMap.putAll(importMappingDto.getFormGroupMap());
        JSONObject jsonObject = FormMigrateUtil.updateObj(businessData, replaceMap, JSONObject.class);
        EngineUserUtil.setUser((UserDetails)((UserDetails)TransmittableThreadLocalHolder.get((String)"loginUser")));
        this.importWidgetExp(importMappingDto);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            String appId = String.valueOf(importMappingDto.getNewAppId());
            Set tableNames = jsonObject.keySet();
            for (String tableName : tableNames) {
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysForm::getTableName, (Object)tableName);
                String formId = String.valueOf(((SysForm)this.formService.getOne((Wrapper)wrapper)).getId());
                JSONArray jsonArray = (JSONArray)jsonObject.getObject(tableName, JSONArray.class);
                List<Object> importList = FormMigrateUtil.parseJsonArrayToList(jsonArray, Object.class);
                ArrayList<JSONObject> importListFinal = new ArrayList<JSONObject>();
                for (Object object : importList) {
                    if (!HussarUtils.isNotEmpty((Object)object)) continue;
                    JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)object));
                    if (HussarUtils.isNotEmpty((Object)json.get((Object)"PROCESS_STATE"))) {
                        json.put("PROCESS_STATE", (Object)"2");
                    } else if (HussarUtils.isNotEmpty((Object)json.get((Object)"process_state"))) {
                        json.put("process_state", (Object)"2");
                    }
                    json.remove((Object)"PROCESS_INST_ID");
                    json.remove((Object)"process_inst_id");
                    json.put("FORM_ID", (Object)formId);
                    importListFinal.add(json);
                }
                HashMap<String, ArrayList<JSONObject>> params = new HashMap<String, ArrayList<JSONObject>>();
                params.put("importList", importListFinal);
                this.formOperateExposedService.tableSave(appId, formId, params);
            }
        }
        this.operateLogThreadLocal.remove();
        EngineUserUtil.remove();
    }

    private void afterBusinessData(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) throws Exception {
        Collection formIds = importMappingDto.getFormIdMap().values();
        if (HussarUtils.isNotEmpty(formIds)) {
            for (Long formId : formIds) {
                this.reSync(String.valueOf(formId));
            }
        }
    }

    private void clearSerialNumberId(FormCanvasSchema formCanvasSchema) {
        List widgets = formCanvasSchema.getWidgets();
        this.clearFirstLevelSerialNumberId(widgets);
    }

    private void clearFirstLevelSerialNumberId(List<Widget> widgets) {
        if (ToolUtil.isNotEmpty(widgets)) {
            for (Widget widget : widgets) {
                if (WidgetType.JXDNSerialNumber.getType().equals(widget.getType())) {
                    List serialNumRuleDTOS = JsonParser.array((Object)widget, (String)"$.props.rules", SerialNumRuleDTO.class).orElse(null);
                    if (!ToolUtil.isNotEmpty((Object)serialNumRuleDTOS)) continue;
                    for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOS) {
                        serialNumRuleDTO.getConfig().setId(null);
                    }
                    JSONPath.set((Object)widget, (String)"$.props.rules", (Object)serialNumRuleDTOS);
                    continue;
                }
                if (!widget.getIsContainer()) continue;
                List childrenWidgets = widget.getChildren();
                this.clearFirstLevelSerialNumberId(childrenWidgets);
            }
        }
    }

    private void recordReplaceMappingOfFlow(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        Map<String, String> taskTableNameMap = importMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> "PROCESS_TASK_INFO_" + (String)entry.getKey(), entry -> "PROCESS_TASK_INFO_" + (String)entry.getValue()));
        importMappingDto.setTaskTableNameMap(taskTableNameMap);
        importMappingDto.getMainTableBusinessKeyMap().putAll(importMappingDto.getTableNameMap());
    }

    private void recordReplaceMapping(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        String tableName = (String)importMappingDto.getTableNameMap().entrySet().iterator().next().getKey();
        String canvasPath = importMappingDto.getFormDataInit().getCanvasPath();
        FormCanvasSchema formCanvasSchema = FormMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
        if (ToolUtil.isNotEmpty((Object)formCanvasSchema)) {
            String oldFlowIdentity;
            if (!importMappingDto.isKeepTableName()) {
                for (Widget widget : formCanvasSchema.childTables()) {
                    String oleSubTableName = widget.getName();
                    String newSubTableName = oleSubTableName + "_" + importMappingDto.getSpliceSuffix();
                    if (this.isCover(importMappingDto)) {
                        importMappingDto.getSubTableNameMap().put(oleSubTableName, oleSubTableName);
                    } else {
                        importMappingDto.getSubTableNameMap().put(oleSubTableName, newSubTableName);
                    }
                    this.storeTempGrandSonTableNameMapping(importMappingDto, widget);
                }
            }
            if (HussarUtils.isNotEmpty((Object)(oldFlowIdentity = formCanvasSchema.getIdentity()))) {
                String newFlowIdentity = oldFlowIdentity.substring(0, oldFlowIdentity.length() - 18) + RandomUtil.randomString((String)"0123456789", (int)18);
                if (this.isCover(importMappingDto)) {
                    importMappingDto.getProcessKeyMap().put(oldFlowIdentity, oldFlowIdentity);
                } else {
                    importMappingDto.getProcessKeyMap().put(oldFlowIdentity, newFlowIdentity);
                }
            }
        }
    }

    public void storeTempGrandSonTableNameMapping(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto, Widget widget) {
        List grandsonChild;
        List children = widget.getChildren();
        if (CollectionUtil.isNotEmpty((Collection)children) && CollectionUtil.isNotEmpty(grandsonChild = children.stream().filter(c -> WidgetType.CHILDREN_TABLE.getType().equals(c.getType())).collect(Collectors.toList()))) {
            for (Widget grandson : grandsonChild) {
                String oldGrandsonTableName = grandson.getName();
                String newGrandsonTableName = oldGrandsonTableName + "_" + importMappingDto.getSpliceSuffix();
                if (this.isCover(importMappingDto)) {
                    importMappingDto.getSubTableNameMap().put(oldGrandsonTableName, oldGrandsonTableName);
                    continue;
                }
                importMappingDto.getSubTableNameMap().put(oldGrandsonTableName, newGrandsonTableName);
            }
        }
    }

    private void reSync(String formId) throws Exception {
        FormDesignResponse form = this.formOperateService.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)((FormSchema)form.getData()));
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.sync(dataModelBase);
    }

    private void importPageExp(FormImportDto formImportDto) throws IOException {
        String formFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "pageExpand"});
        File folder = new File(formFilePath);
        Object[] files = folder.listFiles();
        if (HussarUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                String fileName = ((File)file).getName();
                String filePath = formFilePath + File.separator + fileName;
                Long fileId = this.fileUpload(filePath);
                this.pageExpService.importPage(fileId, Long.valueOf(1L));
            }
        }
    }

    private void importWidgetExp(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto formImportDto) throws IOException {
        String formFilePath = formImportDto.getFormDataInit().getWidgetExpandPath();
        if (HussarUtils.isEmpty((Object)formFilePath)) {
            return;
        }
        File folder = new File(formFilePath);
        Object[] files = folder.listFiles();
        if (HussarUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                String fileName = ((File)file).getName();
                String filePath = formFilePath + File.separator + fileName;
                Long fileId = this.fileUpload(filePath);
                this.widgetExpService.importWidget(fileId, Long.valueOf(1L));
            }
        }
    }

    public void importMsgPush(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        this.importMsgPush(importMappingDto.getFormDataInit().getSysMsgPushConfigs(), importMappingDto, null);
    }

    public void importMsgPush(List<SysMsgPushConfig> configs, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto, Collection<Long> ups) {
        if (HussarUtils.isEmpty(configs)) {
            return;
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormGroupMap());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        configs = FormMigrateUtil.updateObj(configs, replaceMap, List.class);
        configs = FormMigrateUtil.parseListObjectoList(configs, SysMsgPushConfig.class);
        for (SysMsgPushConfig config : configs) {
            config.setId(this.isCover(importMappingDto) ? config.getId() : null);
            if (ups.contains(config.getId())) continue;
            config.setReminders("{\"organs\": [], \"staffs\": [], \"showFields\": [], \"containSub\": false}");
        }
        this.msgPushConfigService.saveBatch(configs);
    }

    public void importDataPush(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        this.importDataPush(importMappingDto.getFormDataInit().getPushConfigs(), importMappingDto);
    }

    public void importDataPush(List<SysDataPushConfig> configs, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        if (HussarUtils.isEmpty(configs)) {
            return;
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        FormMigrateUtil.updateObj(configs, replaceMap, List.class);
        for (SysDataPushConfig config : configs) {
            List list;
            Long oldId = config.getId();
            config.setId(this.isCover(importMappingDto) ? config.getId() : null);
            this.pushDataService.saveOrUpdate((Object)config);
            if (!config.getTriggerAction().equals("CUSTOM") || (list = this.sysCustomButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getDataPushId, (Object)oldId)).eq(SysCustomButton::getFormId, (Object)config.getFormId()))).isEmpty()) continue;
            for (SysCustomButton customButton : list) {
                customButton.setDataPushId(config.getId());
            }
            this.sysCustomButtonService.saveOrUpdateBatch((Collection)list);
        }
    }

    public void importDataPushMap(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        FormMap map = importMappingDto.getFormDataInit().getMap();
        if (HussarUtils.isEmpty((Object)map)) {
            return;
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        FormMigrateUtil.updateObj(map, replaceMap, FormMap.class);
        map.setId(this.isCover(importMappingDto) ? map.getId() : null);
        this.formMapService.save((Object)map);
    }

    public void importDataPull(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        this.importDataPull(importMappingDto.getFormDataInit().getPullConfigs(), importMappingDto);
    }

    public void importDataPull(List<SysDataPullConfig> configs, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        if (HussarUtils.isEmpty(configs)) {
            return;
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        replaceMap.putAll(importMappingDto.getFormGroupMap());
        configs = FormMigrateUtil.updateObj(configs, replaceMap, List.class);
        configs = FormMigrateUtil.parseListObjectoList(configs, SysDataPullConfig.class);
        for (SysDataPullConfig config : configs) {
            List list;
            Long oldId = config.getId();
            config.setId(this.isCover(importMappingDto) ? config.getId() : null);
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            config.setCreator(loginUser.getId());
            config.setLastEditor(loginUser.getId());
            config.setLastTime(LocalDateTime.now());
            SysDataPullConfigDto sysDataPullConfigDto = new SysDataPullConfigDto();
            BeanUtils.copyProperties((Object)config, (Object)sysDataPullConfigDto);
            this.pullDataService.saveConfig(sysDataPullConfigDto);
            if (config.getTriggerAction().equals("1") && !(list = this.sysCustomButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getDataPullId, (Object)oldId)).eq(SysCustomButton::getFormId, (Object)config.getFormId()))).isEmpty()) {
                for (SysCustomButton customButton : list) {
                    customButton.setDataPullId(sysDataPullConfigDto.getId());
                    this.sysCustomButtonService.saveOrUpdate((Object)customButton);
                }
            }
            if (!"1".equals(config.getStatus()) || !StringUtil.isNotEmpty((Object)config.getTriggerAction()) || !config.getTriggerAction().equals("0") || "1".equals(config.getDelFlag())) continue;
            this.sysDataPullTaskService.removeByConfigId(config.getId());
            HussarNoCodeThreadUtil.executeUserTask(() -> this.sysDataPullTaskService.asyncGenerateTaskBySaveConfig(config));
        }
    }

    public void importPublicView(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        List dataViews = importMappingDto.getFormDataInit().getDataViews();
        if (HussarUtils.isEmpty((Object)dataViews)) {
            return;
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        FormMigrateUtil.updateObj(dataViews, replaceMap, List.class);
        List<CustomView> publicViewList = dataViews.stream().map(dataView -> this.customViewService.convertToCustomView(dataView)).collect(Collectors.toList());
        publicViewList.forEach(customView -> {
            Long oldViewId = customView.getViewId();
            customView.setViewId(this.isCover(importMappingDto) ? customView.getViewId() : null);
            customView.setFormId((Long)new ArrayList(importMappingDto.getFormIdMap().values()).get(0));
            customView.setAppId(formImportDto.getAppId());
            this.customViewService.save((BaseEntity)customView);
            Long newViewId = customView.getViewId();
            importMappingDto.getPublicViewMap().put(String.valueOf(oldViewId), String.valueOf(newViewId));
        });
    }

    public void importScript(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        List scriptBases = importMappingDto.getFormDataInit().getScriptBases();
        if (HussarUtils.isEmpty((Object)scriptBases)) {
            return;
        }
        HashMap<Long, Long> replaceMap = new HashMap<Long, Long>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        ScriptRecordService scriptRecordService = (ScriptRecordService)SpringContextUtil.getBean(ScriptRecordService.class);
        ArrayList<ScriptRecord> scriptRecords = new ArrayList<ScriptRecord>();
        this.snowflakeID.init();
        HashMap<String, String> scriptRecordMap = new HashMap<String, String>();
        HashMap scriptMethodMap = new HashMap();
        for (ScriptBase scriptBase : scriptBases) {
            long recordId = this.isCover(importMappingDto) ? scriptBase.getId() : this.snowflakeID.nextIdLong();
            scriptRecordMap.put(String.valueOf(scriptBase.getId()), String.valueOf(recordId));
            ScriptRecord scriptRecord = new ScriptRecord.Builder().withId(Long.valueOf(recordId)).withName(scriptBase.getName()).withDesc(scriptBase.getDesc()).withNote(scriptBase.getNote()).withIcon(scriptBase.getIcon()).withType(scriptBase.getType()).withAuthor(scriptBase.getAuthor()).withVersion(scriptBase.getVersion()).withEditorNote(scriptBase.getEditorNote()).withFileId(scriptBase.getFileId()).withGroupId(scriptBase.getGroupId()).withFormId(scriptBase.getFormId()).build();
            ScriptBaseAssemble scriptBaseAssemble = new ScriptBaseAssemble(new ArrayList(), scriptRecord);
            scriptRecords.add(scriptRecord);
            scriptRecordService.importMethods(scriptBase.getMethods(), scriptBaseAssemble, scriptMethodMap);
        }
        scriptRecordService.saveBatch(scriptRecords);
        importMappingDto.setScriptMethodMap(scriptMethodMap);
        importMappingDto.setScriptRecordMap(scriptRecordMap);
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException iOException) {
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public void importExtensionApi(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        List sysFormExtApis = importMappingDto.getFormDataInit().getSysFormExtApis();
        if (HussarUtils.isEmpty((Object)sysFormExtApis)) {
            return;
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        FormMigrateUtil.updateObj(sysFormExtApis, replaceMap, List.class);
        sysFormExtApis.forEach(sysFormExtApi -> sysFormExtApi.setApiId(this.isCover(importMappingDto) ? sysFormExtApi.getApiId() : null));
        this.sysFormExtApiService.saveBatch((Collection)sysFormExtApis);
    }

    private boolean isCover(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        return ImportUtil.isKeepId(importMappingDto);
    }

    public void importDashboardImage(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        try {
            List printTemplates = importMappingDto.getFormDataInit().getDashboardImageList();
            if (HussarUtils.isEmpty((Object)printTemplates)) {
                return;
            }
            String templateFilePath = importMappingDto.getFormDataInit().getDashboardImagePath();
            this.sysFileInfoDashboardService.importDashboardImage((ImportMappingDto)importMappingDto, printTemplates, templateFilePath);
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u6570\u636e\u770b\u677f\u56fe\u7247\u5931\u8d25", (Throwable)e);
        }
    }
}

