/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.data.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.formdesign.application.data.dao.SysDataPullRecordMapper;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullRecord;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullRecordService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.data.service.impl.SysDataPullRecordServiceImpl")
public class SysDataPullRecordServiceImpl
extends HussarServiceImpl<SysDataPullRecordMapper, SysDataPullRecord>
implements SysDataPullRecordService {
    public ApiResponse<Page<SysDataPullRecord>> getRecordList(String startTime, String endTime, String configId, String success, Long current, Long size) {
        LocalDateTime startDate = null;
        LocalDateTime endDate = null;
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (StringUtil.isNotEmpty((Object)startTime)) {
            startDate = LocalDateTime.parse(startTime, fmt);
        }
        if (StringUtil.isNotEmpty((Object)endTime)) {
            endDate = LocalDateTime.parse(endTime, fmt);
        }
        Page page = (Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysDataPullRecord::getPullId, (Object)configId)).eq(StringUtil.isNotEmpty((Object)success), SysDataPullRecord::getSuccess, (Object)success)).ge(startDate != null, HussarBaseEntity::getCreateTime, (Object)startDate)).le(endDate != null, HussarBaseEntity::getCreateTime, (Object)endDate)).orderByDesc(HussarBaseEntity::getCreateTime)).page((IPage)new Page(current.longValue(), size.longValue()));
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Void> removeByFormId(Long formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullRecord::getFormId, (Object)formId);
        this.remove((Wrapper)queryWrapper);
        return ApiResponse.success();
    }
}

