/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationRollBackService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionService;
import com.jxdinfo.hussar.formdesign.application.application.vo.UpgradeStatusVo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.SysApplicationRollBackServiceImpl")
public class SysApplicationRollBackServiceImpl
implements ISysApplicationRollBackService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysApplicationRollBackServiceImpl.class);
    @Resource
    private ISysApplicationVersionService applicationVersionService;

    public ApiResponse<String> rollback(Long appId, Long versionId, Long currentVersionId) {
        if (versionId.equals(currentVersionId)) {
            return ApiResponse.fail((String)"\u4e0d\u5141\u8bb8\u56de\u9000\u5f53\u524d\u7248\u672c");
        }
        String upgradeTaskId = String.valueOf(UUID.randomUUID());
        TransmittableThreadLocalHolder.set((String)"upgradeCacheKey", (Object)upgradeTaskId);
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (Exception e) {
            LOGGER.error("DataModelUtil.getDataSourceConfigByName\u6570\u636e\u6e90\u5f02\u5e38\uff1a" + e);
        }
        HussarNoCodeThreadUtil.executeUserTask(() -> {
            try {
                LOGGER.info("\u5e94\u7528\u56de\u9000[{}] ===============> \u5f00\u59cb\u6267\u884c...", (Object)appId);
                long startTime = System.currentTimeMillis();
                String appStatusOld = this.applicationVersionService.updateAppLock(appId);
                AppUpgradeDto appUpgradeDto = this.applicationVersionService.initAppUpgrade(appId, versionId);
                IAppUpgradeService upgradeService = (IAppUpgradeService)SpringUtil.getBean(IAppUpgradeService.class);
                upgradeService.executeStart(appUpgradeDto, loginUser, dataSourceKey);
                this.applicationVersionService.updataCurrentVersion(appId, versionId, currentVersionId);
                this.applicationVersionService.updateAppRestore(appId, appStatusOld);
                LOGGER.info("\u5e94\u7528\u56de\u9000[{}] ==============> \u7ed3\u675f,\u8017\u65f6{}ms...", (Object)appId, (Object)(System.currentTimeMillis() - startTime));
            }
            catch (Exception e) {
                HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeTaskId, (Object)new UpgradeStatusVo.Builder().statusCount(Integer.valueOf(5)).status(Integer.valueOf(5)).msg("\u56de\u9000\u5f02\u5e38\uff1a" + e.getMessage()).finishFlag(Boolean.TRUE).errorFlag(Boolean.TRUE).build());
                e.printStackTrace();
            }
        });
        return ApiResponse.success((Object)upgradeTaskId, (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

