/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DownLoadCompent;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelWaterRemarkUtils;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.I18nUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.WaterMarkComponent;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.print.dto.WordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.enums.CellLevel;
import com.jxdinfo.hussar.formdesign.application.print.enums.FileNameMode;
import com.jxdinfo.hussar.formdesign.application.print.handle.WordHandle;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysWordPrintTaskService;
import com.jxdinfo.hussar.formdesign.application.print.util.GenerateCode;
import com.jxdinfo.hussar.formdesign.application.print.vo.WidgetsAndData;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.application.properties.WordPrintProperties;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFAnchor;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTDrawing;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTOneCellAnchor;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBookView;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ExcelHandle {
    @Resource
    private HussarFormDesignProperties hussarFormDesignProperties;
    @Resource
    private WordPrintProperties wordPrintProperties;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private ISysWordPrintTaskService sysWordPrintTaskService;
    @Resource
    private OssService ossService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private WaterMarkComponent waterMarkComponent;
    @Resource
    private I18nUtil i18nUtil;
    @Resource
    private DownLoadCompent downLoadCompent;
    @Resource
    private WordHandle wordHandle;
    private static final ConcurrentHashMap<String, Object> HASH_MAP = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger(ExcelHandle.class);
    private static final int DEFAULT_ROW_NUM = 1;
    private static final int DEFAULT_MAX_ROW_NUM = 0;
    private static final int HOST_LEVEL = 0;
    private static final int CHILD_LEVEL = 1;
    private static final int SUN_LEVEL = 2;
    private static final String WIDGET_LEVEL = "widgetLevel";
    private static final String DATA_VALUE = "dataValue";
    private static final String GRAN_MAP = "granMap";
    private static final String XLSX_SUFFIX = ".xlsx";
    public static final String ID_KEY = "id";
    public static final String SUPER_QUERY_CONDITION_DTO_KEY = "superQueryConditionDto";
    public static final String COMMENT_KEY = "comment";
    public static final String MSG_KEY = "msg";
    public static final String GROUP_INDEX_KEY = "GROUP_INDEX";
    public static final String GROUP_COUNT_KEY = "GROUP_COUNT";
    public static final String MERGE_KEY = "merge";
    public static final String GROUP_KEY = "group";
    public static final String VALUE_KEY = "value";
    public static final String LABEL_KEY = "label";
    public static final String OPTION_TYPE_KEY = "optionType";
    public static final String DICT_KEY = "dict";
    public static final String STATIC_KEY = "static";
    public static final String ASYNC_KEY = "async";
    public static final String DATA_LINK_AGE_KEY = "dataLinkage";
    public static final String OPTIONS_KEY = "options";
    public static final String SIGNATURE_KEY = "signature";
    public static final String USER_NAME_KEY = "userName";
    public static final String SELECT_KEY = "R";
    public static final String NO_SELECT_KEY = "\u00a3";
    public static final String MARK_KEY = "\uffe5";
    public static final String D_MARK_KEY = "\uffe5\uffe5";
    public static final String VERTICAL = "|vertical";
    public static final String WINGDINGS_2 = "Wingdings 2";
    public static final String INDEX = "index";
    public static final String UNION = "|union";
    public static final String CONTENT = "content";
    public static final String BLANK = "      ";
    public static final String SPLIT_LINE = "|";
    public static final String UNDERLINE = "_";
    public static final String SEPARATION = ".";
    public static final String MATCHER_SEPARATION = "\\.";
    public static final String RIGHT_PARENTHESIS = "}";
    public static final String EQUAL_SIGN = "=";
    public static final String QR_CODE = "qrcode";
    public static final int LENGTH_SIZE_2 = 2;
    public static final int LENGTH_SIZE_3 = 3;
    public static final Map<Integer, Double> FONT_CHAR = new HashMap<Integer, Double>(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void excelHandle(WordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            LOGGER.info("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)this.wordHandle.getFormatTime(timeStart));
            this.validateInputParameters(wordPrintParamsDto);
            WidgetsAndData widgetsAndData = this.fetchData(wordPrintParamsDto);
            JSONObject parse = this.prepareDataModel(wordPrintParamsDto, widgetsAndData);
            this.processFlowHistoryIfNeeded(wordPrintParamsDto, parse);
            this.injectPrintInfo(wordPrintParamsDto, parse);
            Long templateFileId = this.validateAndGetTemplateFileId(wordPrintParamsDto);
            OutputFileInfo outputInfo = this.prepareOutputFile(wordPrintParamsDto, parse, templateFileId);
            WordHandle.TaskInfo taskInfo = this.executeExcelGeneration(wordPrintParamsDto, parse, widgetsAndData.getMap(), templateFileId, outputInfo);
            taskState = taskInfo.getTaskStatus();
            this.updateTaskStatus(taskState, taskInfo.getFileId(), taskId);
        }
        catch (Exception e) {
            this.handleException(taskId, e);
        }
        finally {
            this.logFinalStatus(taskId, taskState, timeStart);
        }
    }

    private void validateInputParameters(WordPrintParamsDto dto) {
        if (HussarUtils.isEmpty((Object)dto)) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private WidgetsAndData fetchData(WordPrintParamsDto dto) {
        Object data;
        String formId = dto.getFormId();
        String exportType = dto.getExportType();
        if (HussarUtils.isEmpty((Object)exportType)) {
            data = ((ApiResponse)Objects.requireNonNull(this.sysPrintTemplateService.formQuery(formId, dto.getId(), dto.getTabType(), dto.getAppId()).getBody())).getData();
        } else {
            HashMap<String, List> params = new HashMap<String, List>(10);
            List ids = dto.getIds();
            if (HussarUtils.isNotEmpty((Object)ids)) {
                dto.getFilter().add(this.createIdsFilter(ids));
            }
            params.put(SUPER_QUERY_CONDITION_DTO_KEY, dto.getFilter());
            data = ((ApiResponse)Objects.requireNonNull(this.sysPrintTemplateService.tableQuery(formId, dto.getViewId(), params, dto.getAppId()).getBody())).getData();
        }
        if (HussarUtils.isEmpty((Object)data)) {
            throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return (WidgetsAndData)data;
    }

    private Filter createIdsFilter(List<String> ids) {
        Filter filter = new Filter();
        filter.setField("RECORD_ID");
        filter.setMatch("AND");
        filter.setRule("_in");
        filter.setVal(String.join((CharSequence)",", ids));
        return filter;
    }

    private JSONObject prepareDataModel(WordPrintParamsDto dto, WidgetsAndData widgetsAndData) {
        EngineResultEntity entity = widgetsAndData.getEntity();
        String jsonString = JSON.toJSONString((Object)entity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        JSONObject parse = (JSONObject)JSON.parse((String)jsonString);
        parse.put("exportType", (Object)dto.getExportType());
        parse.put("langCode", (Object)dto.getLangCode());
        parse.put(GROUP_INDEX_KEY, (Object)"");
        parse.put(GROUP_COUNT_KEY, (Object)"");
        return parse;
    }

    private void processFlowHistoryIfNeeded(WordPrintParamsDto dto, JSONObject parse) {
        String processInstId = dto.getProcessInstId();
        String businessId = dto.getBusinessId();
        if (HussarUtils.isEmpty((Object)processInstId) || HussarUtils.isEmpty((Object)businessId)) {
            return;
        }
        BpmResponseResult result = InstanceEngineService.queryFlowHistoryInfo((String)businessId, (String)processInstId);
        JSONArray historyArray = result.getResult();
        if (HussarUtils.isEmpty((Object)historyArray)) {
            LOGGER.error("-------\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u4e0d\u5b58\u5728,processInstId\uff1a{}\uff0cbusinessId\uff1a{}", (Object)processInstId, (Object)businessId);
            parse.put("flowHistoryInfo", (Object)new JSONArray());
            return;
        }
        try {
            JSONArray processedHistory = this.processFlowHistory(historyArray);
            parse.put("flowHistoryInfo", (Object)processedHistory);
        }
        catch (Exception e) {
            LOGGER.error("-------\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u89e3\u6790\u5931\u8d25", (Throwable)e);
            parse.put("flowHistoryInfo", (Object)new JSONArray());
        }
    }

    private JSONArray processFlowHistory(JSONArray historyArray) {
        JSONArray result = new JSONArray();
        Object firstItem = historyArray.get(0);
        Object completeList = null;
        if (firstItem instanceof JSONObject) {
            completeList = ((JSONObject)firstItem).get((Object)"completeList");
        } else if (firstItem instanceof LinkedHashMap) {
            completeList = ((LinkedHashMap)firstItem).get("completeList");
        }
        if (completeList != null) {
            String objStr = JSON.toJSONString((Object)completeList);
            result = JSON.parseArray((String)objStr);
            for (int i = 0; i < result.size(); ++i) {
                JSONObject item = result.getJSONObject(i);
                item.put(INDEX, (Object)(i + 1));
                Object comment = item.get((Object)COMMENT_KEY);
                if (!HussarUtils.isNotEmpty((Object)comment)) continue;
                this.processCommentField(item, comment);
            }
        }
        return result;
    }

    private void processCommentField(JSONObject item, Object comment) {
        try {
            String commentStr = String.valueOf(comment);
            JSONObject jsonComment = JSON.parseObject((String)commentStr);
            item.put(COMMENT_KEY, jsonComment.get((Object)MSG_KEY));
        }
        catch (Exception e) {
            LOGGER.info("-------\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
        }
    }

    private void injectPrintInfo(WordPrintParamsDto dto, JSONObject parse) {
        UserDetails userDetails = dto.getUserDetails();
        String printTime = this.wordHandle.getFormatTime(System.currentTimeMillis());
        if (parse.containsKey((Object)"\u4e3b\u8868")) {
            JSONArray items = parse.getJSONArray("\u4e3b\u8868");
            items.forEach(item -> {
                JSONObject jsonObj = (JSONObject)item;
                jsonObj.put("printUserName", (Object)this.getUserName(userDetails));
                jsonObj.put("printDateTime", (Object)printTime);
            });
        }
        parse.put("printUserName", (Object)this.getUserName(userDetails));
        parse.put("printDateTime", (Object)printTime);
    }

    private String getUserName(UserDetails userDetails) {
        return HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null;
    }

    private Long validateAndGetTemplateFileId(WordPrintParamsDto dto) {
        String templateId = dto.getTemplateId();
        SysPrintTemplate template = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId));
        if (HussarUtils.isEmpty((Object)template)) {
            LOGGER.error("-------\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
            throw new BaseException("-------\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        JSONObject content = (JSONObject)JSON.parseObject((String)template.getContent(), JSONObject.class);
        return Long.valueOf(String.valueOf(content.get((Object)ID_KEY)));
    }

    private OutputFileInfo prepareOutputFile(WordPrintParamsDto dto, JSONObject parse, Long templateFileId) {
        String printTimeNoHour = this.wordHandle.getFormatTimeNoHour(System.currentTimeMillis());
        SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(dto.getTemplateId()));
        String fileName = this.wordHandle.handlerGeneFileName(printTemplate, printTimeNoHour, dto.getFormId(), parse, XLSX_SUFFIX);
        String outputPath = this.hussarFormDesignProperties.getWorkspace() + "excelTemplate" + File.separator;
        this.createDirectoryIfNotExists(outputPath);
        long fileId = Long.parseLong(this.wordHandle.gene16Num());
        String outputFilePath = outputPath + File.separator + fileId + XLSX_SUFFIX;
        return new OutputFileInfo(fileId, fileName, outputFilePath);
    }

    private void createDirectoryIfNotExists(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            boolean success = dir.mkdirs();
            LOGGER.info("\u76ee\u5f55\u521b\u5efa{}", (Object)(success ? "\u6210\u529f" : "\u5931\u8d25"));
        }
    }

    private WordHandle.TaskInfo executeExcelGeneration(WordPrintParamsDto dto, JSONObject parse, Map<String, String> widgets, Long templateFileId, OutputFileInfo outputInfo) {
        String appId = dto.getAppId();
        UserDetails userDetails = dto.getUserDetails();
        String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
        return this.entry(mark, parse, this.downLoadCompent.copyOssFile(templateFileId), outputInfo.outputFilePath, outputInfo.fileName, widgets);
    }

    private void updateTaskStatus(int taskState, Long fileId, Long taskId) {
        this.wordHandle.updateTask(taskState, fileId, taskId);
    }

    private void handleException(Long taskId, Exception e) {
        LOGGER.error("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
        LOGGER.error("-------\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
        this.wordHandle.updateTask(-1, null, taskId);
    }

    private void logFinalStatus(Long taskId, int taskState, long startTime) {
        long timeEnd = System.currentTimeMillis();
        String status = taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25";
        LOGGER.info("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)status, (Object)this.wordHandle.getFormatTime(timeEnd), (Object)(timeEnd - startTime));
        EngineUserUtil.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WordHandle.TaskInfo entry(String mark, JSONObject parse, String inputFilePath, String outputFilePath, String fileName, Map<String, String> widgets) {
        Long fileId = 0L;
        int taskState = 1;
        try (FileInputStream inputStream = new FileInputStream(inputFilePath);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);){
            XSSFSheet sheet = this.getFirstVisibleSheet(workbook);
            if (sheet == null) {
                LOGGER.error("-------\u65e0\u53ef\u6253\u5370\u7684sheet\uff1a{}", (Object)inputFilePath);
                WordHandle.TaskInfo taskInfo = new WordHandle.TaskInfo(-1, 0L);
                return taskInfo;
            }
            this.hideNonTemplateSheets(workbook, sheet);
            this.handleExportType(parse, sheet, widgets);
            this.processSheetData(workbook, sheet, widgets, parse);
            fileId = this.writeAndUpload(workbook, outputFilePath, fileName);
        }
        catch (Exception e) {
            this.handleError(inputFilePath, e);
            taskState = -1;
        }
        finally {
            this.clearHashMap();
        }
        return new WordHandle.TaskInfo(taskState, fileId);
    }

    private XSSFSheet getFirstVisibleSheet(XSSFWorkbook workbook) {
        int sheetCount = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            if (!SheetVisibility.VISIBLE.equals((Object)workbook.getSheetVisibility(i))) continue;
            try {
                List workbookViewList = workbook.getCTWorkbook().getBookViews().getWorkbookViewList();
                if (workbookViewList != null && !workbookViewList.isEmpty()) {
                    for (CTBookView workbookView : workbookViewList) {
                        workbookView.setActiveTab((long)i);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("\u8bbe\u7f6e\u6d3b\u52a8sheet\u9875\u5931\u8d25", (Throwable)e);
            }
            return workbook.getSheetAt(i);
        }
        return null;
    }

    private void hideNonTemplateSheets(XSSFWorkbook workbook, XSSFSheet visibleSheet) {
        int visibleIndex = workbook.getSheetIndex((Sheet)visibleSheet);
        int sheetCount = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            if (i == visibleIndex) continue;
            workbook.setSheetVisibility(i, SheetVisibility.HIDDEN);
        }
    }

    private void handleExportType(JSONObject parse, XSSFSheet sheet, Map<String, String> widgets) {
        if (HussarUtils.isEmpty((Object)parse.get((Object)"exportType"))) {
            return;
        }
        this.excelExportHandlePre(sheet, widgets);
        JSONObject widgetLevel = JSON.parseObject((String)widgets.get(WIDGET_LEVEL));
        widgetLevel.keySet().stream().filter(key -> !key.equals("\u4e3b\u8868")).filter(key -> Integer.parseInt(widgetLevel.get(key).toString()) == 1).forEach(key -> widgetLevel.put(key, (Object)2));
        JSONObject granMap = JSON.parseObject((String)widgets.get(GRAN_MAP));
        granMap.replaceAll((key, value) -> HussarUtils.isEmpty((Object)value) ? "\u4e3b\u8868" : value);
        widgets.put(GRAN_MAP, JSON.toJSONString((Object)granMap));
        widgets.put(WIDGET_LEVEL, JSON.toJSONString((Object)widgetLevel));
    }

    private void processSheetData(XSSFWorkbook workbook, XSSFSheet sheet, Map<String, String> widgets, JSONObject parse) {
        this.analysisCell(sheet);
        HASH_MAP.put(DATA_VALUE, parse);
        WordHandle.getFormData(HASH_MAP, parse);
        JSONObject granMap = JSON.parseObject((String)widgets.get(GRAN_MAP));
        this.handleTableContainsGran(workbook, sheet, widgets, granMap);
    }

    /*
     * Exception decompiling
     */
    private Long writeAndUpload(XSSFWorkbook workbook, String outputPath, String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleError(String filePath, Exception e) {
        LOGGER.error("-------excel\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)filePath);
        LOGGER.error("-------Excel\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25, \u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
    }

    private void clearHashMap() {
        HASH_MAP.clear();
    }

    public void addWatermark(Workbook workbook, String mark) {
        if (HussarUtils.isNotEmpty((Object)mark)) {
            try {
                LOGGER.info("\u6c34\u5370\u5185\u5bb9\uff1a{}", (Object)mark);
                byte[] bytes = mark.getBytes();
                mark = new String(bytes, StandardCharsets.UTF_8);
                BufferedImage bufferedImage = ExcelWaterRemarkUtils.createWaterMarkImage((String)mark);
                this.addWatermarkExcel(workbook, bufferedImage);
            }
            catch (Exception e) {
                LOGGER.error("\u6c34\u5370\u6dfb\u52a0\u5931\u8d25");
                LOGGER.error("\u5931\u8d25\u539f\u56e0", (Throwable)e);
            }
        }
    }

    public void addWatermarkExcel(Workbook workbook, BufferedImage image) throws IOException {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        if (null == image) {
            throw new HussarException("\u5411Excel\u4e0a\u9762\u6253\u5370\u6c34\u5370\uff0c\u8bfb\u53d6\u6c34\u5370\u56fe\u7247\u5931\u8d25(2)\u3002");
        }
        ImageIO.write((RenderedImage)image, "png", byteArrayOut);
        int pictureIdx = workbook.addPicture(byteArrayOut.toByteArray(), 6);
        XSSFPictureData pictureData = (XSSFPictureData)workbook.getAllPictures().get(pictureIdx);
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            XSSFSheet sheet = (XSSFSheet)workbook.getSheetAt(i);
            PackagePartName ppn = pictureData.getPackagePart().getPartName();
            String relType = XSSFRelation.IMAGES.getRelation();
            PackageRelationship pr = sheet.getPackagePart().addRelationship(ppn, TargetMode.INTERNAL, relType, null);
            sheet.getCTWorksheet().addNewPicture().setId(pr.getId());
        }
    }

    private void excelExportHandlePre(XSSFSheet sheetAt, Map<String, String> widgets) {
        JSONArray jsonArray = new JSONArray();
        HASH_MAP.put("\u5b50\u8868", jsonArray);
        for (Row row : sheetAt) {
            if (row == null) continue;
            this.processCellsInRow(row, jsonArray, widgets);
        }
    }

    private void processCellsInRow(Row row, JSONArray jsonArray, Map<String, String> widgets) {
        int lastCellNum = row.getLastCellNum();
        for (int cellIndex = 0; cellIndex < lastCellNum; ++cellIndex) {
            Cell cell = row.getCell(cellIndex);
            if (cell == null || cell.getCellType() != CellType.STRING) continue;
            this.processCellContent(cell, jsonArray, widgets);
        }
    }

    private void processCellContent(Cell cell, JSONArray jsonArray, Map<String, String> widgets) {
        String originalValue = cell.getStringCellValue();
        Matcher matcher = this.wordHandle.matcher(originalValue);
        String currentValue = originalValue;
        while (matcher.find()) {
            String matchedText = matcher.group();
            String substring = this.getMatchedSubstring(matchedText);
            if (this.isIndexOrCountType(substring)) continue;
            if (this.isGroupRow(substring)) {
                currentValue = "";
                break;
            }
            if (this.hasSpecialSymbols(substring)) {
                substring = substring.replace(UNION, "");
            }
            if (this.containsDot(substring)) {
                jsonArray.add((Object)substring);
                continue;
            }
            currentValue = this.updateKeyValue(currentValue, matchedText, substring, widgets);
        }
        if (!currentValue.equals(originalValue)) {
            cell.setCellValue(currentValue);
        }
    }

    private String getMatchedSubstring(String matchedText) {
        int startIndex = matchedText.indexOf("#") + 1;
        int endIndex = matchedText.indexOf(RIGHT_PARENTHESIS);
        return matchedText.substring(startIndex, endIndex);
    }

    private boolean isIndexOrCountType(String substring) {
        return substring.equals(GROUP_INDEX_KEY) || substring.equals(GROUP_COUNT_KEY);
    }

    private boolean isGroupRow(String substring) {
        return substring.contains(SEPARATION) && substring.contains("|group");
    }

    private boolean hasSpecialSymbols(String substring) {
        return !substring.contains(SEPARATION) && substring.contains(UNION);
    }

    private boolean containsDot(String substring) {
        return substring.contains(SEPARATION);
    }

    private String updateKeyValue(String currentValue, String matchedText, String substring, Map<String, String> widgets) {
        String baseKey = this.extractBaseKey(substring);
        String newSubstring = "\u4e3b\u8868." + substring;
        String newKey = matchedText.replace(substring, newSubstring);
        if (this.isInvalidKey(baseKey, widgets)) {
            newKey = "";
        }
        return currentValue.replace(matchedText, newKey);
    }

    private String extractBaseKey(String substring) {
        if (substring.contains(SPLIT_LINE)) {
            return substring.substring(0, substring.indexOf(SPLIT_LINE));
        }
        return substring;
    }

    private boolean isInvalidKey(String baseKey, Map<String, String> widgets) {
        return !widgets.containsKey(baseKey) && !baseKey.equals(INDEX);
    }

    private void handleTableContainsGran(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, JSONObject granMap) {
        try {
            JSONObject widgetLevel = JSON.parseObject((String)widgets.get(WIDGET_LEVEL));
            JSONObject parse = (JSONObject)HASH_MAP.get(DATA_VALUE);
            HashSet<Integer> rowsToRemove = new HashSet<Integer>();
            ArrayList<XSSFRow> groupRows = new ArrayList<XSSFRow>();
            this.processAllRows(workbook, sheetAt, widgets, granMap, parse, rowsToRemove, groupRows, widgetLevel);
            this.deleteRow(sheetAt, rowsToRemove);
        }
        catch (Exception e) {
            LOGGER.error("-------\u5904\u7406\u5305\u542b\u7c92\u5ea6\u7684\u8868\u683c\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void processAllRows(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, JSONObject granMap, JSONObject parse, Set<Integer> rowsToRemove, List<XSSFRow> groupRows, JSONObject widgetLevel) {
        int lastRowNum = sheetAt.getLastRowNum();
        for (int rowIndex = 0; rowIndex <= lastRowNum; ++rowIndex) {
            XSSFRow currentRow = sheetAt.getRow(rowIndex);
            if (currentRow == null) continue;
            this.processSingleRow(workbook, sheetAt, widgets, granMap, parse, rowsToRemove, groupRows, widgetLevel, rowIndex, currentRow);
            lastRowNum = sheetAt.getLastRowNum();
        }
    }

    private void processSingleRow(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, JSONObject granMap, JSONObject parse, Set<Integer> rowsToRemove, List<XSSFRow> groupRows, JSONObject widgetLevel, int rowIndex, XSSFRow currentRow) {
        Map<Integer, List<XSSFCell>> cellLevelMap = this.createCellLevelMap();
        ArrayList<String> allGroups = new ArrayList<String>();
        ArrayList<String> allChildGroups = new ArrayList<String>();
        this.preHandleContainsGran(granMap, currentRow, widgetLevel, allGroups, allChildGroups, cellLevelMap, groupRows);
        if (!allGroups.isEmpty() && !allChildGroups.isEmpty()) {
            rowsToRemove.add(rowIndex);
        }
        HashMap<JSONObject, Integer> childRowNumMap = new HashMap<JSONObject, Integer>(10);
        HashMap<String, String> granToChildMap = new HashMap<String, String>(10);
        ArrayList<String> childList = new ArrayList<String>();
        this.getChildMaxRow(currentRow, childRowNumMap, granToChildMap, granMap, parse, childList);
        this.processCellLevels(workbook, sheetAt, widgets, granMap, parse, groupRows, cellLevelMap, childRowNumMap, granToChildMap, childList, rowIndex, currentRow);
    }

    private Map<Integer, List<XSSFCell>> createCellLevelMap() {
        HashMap<Integer, List<XSSFCell>> levelMap = new HashMap<Integer, List<XSSFCell>>(3);
        levelMap.put(CellLevel.HOST.getLevel(), new ArrayList());
        levelMap.put(CellLevel.CHILD.getLevel(), new ArrayList());
        levelMap.put(CellLevel.SUN.getLevel(), new ArrayList());
        return levelMap;
    }

    private void processCellLevels(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, JSONObject granMap, JSONObject parse, List<XSSFRow> groupRows, Map<Integer, List<XSSFCell>> cellLevelMap, Map<JSONObject, Integer> childRowNumMap, Map<String, String> granToChildMap, List<String> childList, int rowIndex, XSSFRow currentRow) {
        boolean hasHostCells;
        boolean hasChildOrSunCells = !cellLevelMap.get(CellLevel.CHILD.getLevel()).isEmpty() || !cellLevelMap.get(CellLevel.SUN.getLevel()).isEmpty();
        boolean bl = hasHostCells = !cellLevelMap.get(CellLevel.HOST.getLevel()).isEmpty();
        if (hasChildOrSunCells) {
            this.processChildOrSunRow(workbook, sheetAt, widgets, granMap, parse, groupRows, cellLevelMap, childRowNumMap, granToChildMap, childList, rowIndex, currentRow);
        } else if (hasHostCells) {
            this.processHostOnlyRow(workbook, sheetAt, widgets, groupRows, currentRow);
        }
    }

    private void processChildOrSunRow(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, JSONObject granMap, JSONObject parse, List<XSSFRow> groupRows, Map<Integer, List<XSSFCell>> cellLevelMap, Map<JSONObject, Integer> childRowNumMap, Map<String, String> granToChildMap, List<String> childList, int rowIndex, XSSFRow currentRow) {
        LOGGER.info("-------\u8be5\u884c\u542b\u6709\u5b50\u8868\u6216\u5b59\u8868\u6a21\u677f,\u884c\u53f7:{},cellLevelMap:{}", (Object)rowIndex, cellLevelMap.entrySet());
        int maxAddRow = 0;
        if (this.isGroupRow(sheetAt, rowIndex, groupRows)) {
            this.processGroupRow(workbook, sheetAt, widgets, granMap, parse, groupRows, cellLevelMap, childRowNumMap, granToChildMap, childList, rowIndex, currentRow, maxAddRow);
        } else {
            this.processNonGroupRow(workbook, sheetAt, widgets, granMap, parse, cellLevelMap, childRowNumMap, granToChildMap, childList, rowIndex, currentRow, maxAddRow);
        }
    }

    private boolean isGroupRow(XSSFSheet sheetAt, int rowIndex, List<XSSFRow> groupRows) {
        return groupRows.contains(sheetAt.getRow(rowIndex - 1));
    }

    private void processGroupRow(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, JSONObject granMap, JSONObject parse, List<XSSFRow> groupRows, Map<Integer, List<XSSFCell>> cellLevelMap, Map<JSONObject, Integer> childRowNumMap, Map<String, String> granToChildMap, List<String> childList, int rowIndex, XSSFRow currentRow, int maxAddRow) {
        LOGGER.info("-------\u8be5\u884c\u8fdb\u884c\u5206\u7ec4\u6253\u5370\u5904\u7406,\u5206\u7ec4\u6a21\u677f\u884c\u53f7:{}", (Object)(rowIndex - 1));
        ArrayList<String> groupList = new ArrayList<String>();
        HashMap<String, JSONArray> newChildArrayMap = new HashMap<String, JSONArray>(10);
        this.handleGroupRow(workbook, sheetAt, currentRow, groupList, granMap, parse, widgets, newChildArrayMap, cellLevelMap, rowIndex, maxAddRow, granToChildMap, childRowNumMap, childList);
    }

    private void processNonGroupRow(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, JSONObject granMap, JSONObject parse, Map<Integer, List<XSSFCell>> cellLevelMap, Map<JSONObject, Integer> childRowNumMap, Map<String, String> granToChildMap, List<String> childList, int rowIndex, XSSFRow currentRow, int maxAddRow) {
        maxAddRow = this.childCellHandle(workbook, sheetAt, cellLevelMap, currentRow, widgets, granMap, granToChildMap, parse, maxAddRow, rowIndex, childRowNumMap);
        maxAddRow = this.sunCellHandle(workbook, sheetAt, cellLevelMap, currentRow, widgets, granMap, granToChildMap, parse, maxAddRow, rowIndex, childRowNumMap, childList, false);
        this.hostCellHandle(sheetAt, cellLevelMap, currentRow, widgets, parse, maxAddRow, rowIndex, workbook, false);
    }

    private void processHostOnlyRow(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<String, String> widgets, List<XSSFRow> groupRows, XSSFRow currentRow) {
        if (groupRows.contains(currentRow)) {
            return;
        }
        Iterator cellIterator = currentRow.cellIterator();
        while (cellIterator.hasNext()) {
            XSSFCell cell = (XSSFCell)cellIterator.next();
            this.processSingleCell(workbook, sheetAt, currentRow, cell, widgets);
        }
    }

    private void processSingleCell(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow currentRow, XSSFCell cell, Map<String, String> widgets) {
        if (cell.getCellType() != CellType.STRING) {
            return;
        }
        String cellValue = cell.getStringCellValue();
        int rowIndex = currentRow.getRowNum();
        int columnIndex = cell.getColumnIndex();
        Matcher matcher = this.wordHandle.matcher(cellValue);
        if (matcher.find()) {
            this.replaceStringCell(cellValue, HASH_MAP, widgets, cell, cell, workbook, sheetAt, currentRow, rowIndex, columnIndex);
        }
        if (this.wordPrintProperties.isSelectionBoxEnable()) {
            this.replaceSelect(workbook, sheetAt, currentRow, cell, columnIndex, cell.getStringCellValue());
        }
    }

    private void replaceStringCell(Object stringValue, Map<String, Object> param, Map<String, String> widgets, XSSFCell sourceCell, XSSFCell cell, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFRow newRow, int rowIndex, int cellIndex) {
        CellType cellType = sourceCell.getCellType();
        if (!HussarUtils.equals((Object)cellType, (Object)CellType.STRING)) {
            switch (cellType) {
                case NUMERIC: {
                    cell.setCellValue(((Double)stringValue).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    cell.setCellValue(((Boolean)stringValue).booleanValue());
                    break;
                }
                case BLANK: {
                    break;
                }
                default: {
                    cell.setCellValue(stringValue.toString());
                }
            }
            return;
        }
        short fontHeight = cell.getCellStyle().getFont().getFontHeight();
        int fontSize = fontHeight / 20;
        ReturnBody returnBody = new ReturnBody();
        returnBody.setStartNum(0);
        String stringCellValue = String.valueOf(stringValue);
        Matcher matcher = this.wordHandle.matcher(stringCellValue);
        short alignmentCode = 0;
        VerticalAlignment verticalAlignment = VerticalAlignment.BOTTOM;
        if (HussarUtils.isNotEmpty((Object)cell.getCellStyle())) {
            verticalAlignment = cell.getCellStyle().getVerticalAlignment();
            HorizontalAlignment alignment = cell.getCellStyle().getAlignment();
            alignmentCode = alignment.getCode();
        }
        stringCellValue = alignmentCode == HorizontalAlignment.RIGHT.getCode() ? this.rightReplace(stringCellValue, param, widgets, sourceCell, cell, workbook, xssfSheet, newRow, rowIndex, cellIndex, matcher, returnBody, fontSize) : this.defaultReplace(stringCellValue, param, widgets, sourceCell, cell, workbook, xssfSheet, newRow, rowIndex, cellIndex, matcher, returnBody, fontSize, verticalAlignment);
        cell.setCellValue(stringCellValue);
    }

    public String rightReplace(String cellValue, Map<String, Object> param, Map<String, String> widgets, XSSFCell sourceCell, XSSFCell cell, XSSFWorkbook workbook, XSSFSheet sheet, XSSFRow newRow, int rowIndex, int cellIndex, Matcher matcher, ReturnBody returnBody, int fontSize) {
        StringBuilder splitBuilder = new StringBuilder(cellValue);
        List<String> matches = this.collectAllMatches(matcher);
        for (int matchIndex = matches.size() - 1; matchIndex >= 0; --matchIndex) {
            cellValue = this.processSingleMatch(splitBuilder, matches, matchIndex, cellValue, param, widgets, sourceCell, cell, workbook, sheet, newRow, rowIndex, cellIndex, returnBody, fontSize);
        }
        return cellValue;
    }

    private List<String> collectAllMatches(Matcher matcher) {
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    private String processSingleMatch(StringBuilder splitBuilder, List<String> matches, int matchIndex, String cellValue, Map<String, Object> param, Map<String, String> widgets, XSSFCell sourceCell, XSSFCell cell, XSSFWorkbook workbook, XSSFSheet sheet, XSSFRow newRow, int rowIndex, int cellIndex, ReturnBody returnBody, int fontSize) {
        String match = matches.get(matchIndex);
        this.processTextSplit(splitBuilder, match, returnBody, fontSize);
        String replaceText = this.wordHandle.replaceText(match, param);
        return this.handleComponentType(cellValue, match, replaceText, widgets, workbook, sheet, sourceCell, cell, newRow, rowIndex, cellIndex, returnBody, param);
    }

    private void processTextSplit(StringBuilder splitBuilder, String match, ReturnBody returnBody, int fontSize) {
        String[] splitArray = splitBuilder.toString().split(Pattern.quote(match));
        if (splitArray.length > 1) {
            String splitText = splitArray[splitArray.length - 1];
            splitBuilder.setLength(0);
            for (int i = 0; i < splitArray.length - 1; ++i) {
                splitBuilder.append(splitArray[i]);
            }
            this.setTextWidth(splitText, returnBody, fontSize);
        }
    }

    private String handleComponentType(String cellValue, String match, String replaceText, Map<String, String> widgets, XSSFWorkbook workbook, XSSFSheet sheet, XSSFCell sourceCell, XSSFCell cell, XSSFRow newRow, int rowIndex, int cellIndex, ReturnBody returnBody, Map<String, Object> param) {
        if (this.wordHandle.judgeImage(match, widgets)) {
            this.handleImg(cellValue, match, replaceText, (Workbook)workbook, sheet, cell, cellIndex, rowIndex, returnBody);
            return returnBody.getStringCellValue();
        }
        if (this.wordHandle.judgeTextArea(match, widgets)) {
            return this.handleTextArea(cellValue, match, replaceText, workbook, sheet, newRow, cell, cellIndex);
        }
        if (this.wordHandle.judgeSelect(match, widgets)) {
            return this.handleSelect(cellValue, match, replaceText, widgets, param);
        }
        if (this.wordHandle.judgeFile(match, widgets)) {
            return this.handleFile(cellValue, match, replaceText);
        }
        if (this.wordHandle.judgeRichText(match, widgets)) {
            return this.handleRichText(cellValue, match);
        }
        if (this.wordHandle.judgeInputOrSer(match, widgets)) {
            this.handleInputOrSer(cellValue, match, replaceText, workbook, sheet, cell, cellIndex, rowIndex, returnBody);
            return returnBody.getStringCellValue();
        }
        if (this.wordHandle.judgeSignature(match, widgets)) {
            this.handleSignature(cellValue, match, replaceText, workbook, sheet, cell, cellIndex, rowIndex, returnBody);
            return returnBody.getStringCellValue();
        }
        if (this.wordHandle.judgeSuggestion(match, widgets)) {
            this.handleSuggestion(cellValue, match, replaceText, workbook, sheet, cell, cellIndex, rowIndex, returnBody, widgets);
            return returnBody.getStringCellValue();
        }
        return cellValue.replace(match, replaceText);
    }

    private String defaultReplace(String cellValue, Map<String, Object> param, Map<String, String> widgets, XSSFCell sourceCell, XSSFCell cell, XSSFWorkbook workbook, XSSFSheet sheet, XSSFRow newRow, int rowIndex, int cellIndex, Matcher matcher, ReturnBody returnBody, int fontSize, VerticalAlignment verticalAlignment) {
        TextProcessingState state = new TextProcessingState(cellValue);
        while (matcher.find()) {
            String match = matcher.group();
            this.processMatch(match, state, param, widgets, sourceCell, cell, workbook, sheet, newRow, rowIndex, cellIndex, returnBody, fontSize, verticalAlignment);
        }
        return state.cellValue;
    }

    private void processMatch(String match, TextProcessingState state, Map<String, Object> param, Map<String, String> widgets, XSSFCell sourceCell, XSSFCell cell, XSSFWorkbook workbook, XSSFSheet sheet, XSSFRow newRow, int rowIndex, int cellIndex, ReturnBody returnBody, int fontSize, VerticalAlignment verticalAlignment) {
        this.handleWrapText(cell, match, state, verticalAlignment, returnBody);
        this.performTextSplit(match, state, returnBody, fontSize);
        String replaceText = this.wordHandle.replaceText(match, param);
        state.cellValue = this.handleComponentType(state.cellValue, match, replaceText, widgets, workbook, sheet, sourceCell, cell, newRow, rowIndex, cellIndex, returnBody, param);
    }

    private void handleWrapText(XSSFCell cell, String match, TextProcessingState state, VerticalAlignment alignment, ReturnBody returnBody) {
        if (!cell.getCellStyle().getWrapText()) {
            returnBody.setHeightNum(0);
        }
        String[] lines = state.cellValue.split("\n");
        state.currentLineIndex = 0;
        for (String line : lines) {
            if (line.contains(match)) {
                state.splitBuilder = new StringBuilder(line);
                break;
            }
            ++state.currentLineIndex;
        }
        if (!state.lastSplit.contentEquals(state.splitBuilder)) {
            returnBody.setStartNum(0);
        }
        state.lastSplit = state.splitBuilder.toString();
        int adjustedIndex = this.calculateHeightPosition(state.currentLineIndex, alignment, lines.length);
        returnBody.setHeightNum(adjustedIndex);
    }

    private int calculateHeightPosition(int index, VerticalAlignment alignment, int totalLines) {
        switch (alignment) {
            case CENTER: 
            case TOP: {
                return index;
            }
        }
        return totalLines - index - 1;
    }

    private void performTextSplit(String match, TextProcessingState state, ReturnBody returnBody, int fontSize) {
        String[] splitArray = state.splitBuilder.toString().split(Pattern.quote(match));
        if (splitArray.length > 0) {
            String firstPart = splitArray[0];
            state.splitBuilder.setLength(0);
            for (int i = 1; i < splitArray.length; ++i) {
                state.splitBuilder.append(splitArray[i]);
            }
            this.setTextWidth(firstPart, returnBody, fontSize);
        }
    }

    private void setTextWidth(String text, ReturnBody body, int fontSize) {
        int px = fontSize * 96 / 72;
        body.setStartNum(body.getStartNum() + px * text.length() * 9525);
    }

    private void handleSignature(String stringCellValue, String tempString, String replaceText, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody) {
        if (!this.isValidSignatureFormat(tempString, replaceText)) {
            returnBody.setStringCellValue(stringCellValue.replace(tempString, replaceText));
            return;
        }
        this.processSignatureImage(stringCellValue, tempString, replaceText, workbook, xssfSheet, cell, cellIndex, rowIndex, returnBody);
    }

    private boolean isValidSignatureFormat(String tempString, String replaceText) {
        return tempString.contains(SPLIT_LINE) && tempString.contains("size") && HussarUtils.isNotEmpty((Object)replaceText);
    }

    private void processSignatureImage(String stringCellValue, String tempString, String replaceText, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody) {
        String[] configParts = this.parseSignatureConfig(tempString);
        if (configParts.length < 2) {
            return;
        }
        ImageConfig config = this.processImageConfig(configParts[1]);
        String base64Data = this.extractBase64Data(replaceText);
        byte[] imageBytes = this.decodeBase64(base64Data, tempString);
        this.insertSignatureImage(config, imageBytes, workbook, xssfSheet, cell, cellIndex, rowIndex, stringCellValue, tempString, returnBody);
    }

    private String[] parseSignatureConfig(String tempString) {
        return tempString.split("\\|");
    }

    private ImageConfig processImageConfig(String sizeConfig) {
        ImageConfig config = new ImageConfig();
        String configValue = sizeConfig.substring(sizeConfig.indexOf(EQUAL_SIGN) + 1, sizeConfig.indexOf(RIGHT_PARENTHESIS));
        String[] dimensions = configValue.split("\\*");
        if (dimensions.length != 2) {
            return config;
        }
        config.width = dimensions[0];
        config.height = dimensions[1];
        if (!config.width.contains("auto")) {
            if (config.height.contains("fixed")) {
                String[] heightParts = config.height.split(UNDERLINE);
                config.height = heightParts[0];
                config.mode = 1;
            } else if (config.height.contains(UNDERLINE)) {
                String[] heightParts = config.height.split(UNDERLINE);
                config.height = heightParts[0];
                config.mode = 2;
            } else {
                config.height = "auto";
                config.mode = 3;
            }
        }
        return config;
    }

    private String extractBase64Data(String replaceText) {
        int commaIndex = replaceText.indexOf(",");
        return commaIndex != -1 ? replaceText.substring(commaIndex + 1) : replaceText;
    }

    private byte[] decodeBase64(String base64Data, String tempString) {
        try {
            return Base64.getDecoder().decode(base64Data);
        }
        catch (Exception e) {
            LOGGER.error("-------excel\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
            LOGGER.error("-------Base64\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            return new byte[0];
        }
    }

    private void insertSignatureImage(ImageConfig config, byte[] imageBytes, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, String stringCellValue, String tempString, ReturnBody returnBody) {
        if (imageBytes.length == 0) {
            return;
        }
        try {
            List<Double> dimensions = WordHandle.getImageWidthAndHeight(config.width, config.height, config.mode, config.widthToHeight);
            if (HussarUtils.isEmpty(dimensions)) {
                LOGGER.error("-------excel\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef", (Object)tempString);
                return;
            }
            this.addPicture(dimensions, (Workbook)workbook, xssfSheet, cell, imageBytes, cellIndex, rowIndex, returnBody);
            this.setImgText(dimensions, returnBody, stringCellValue, tempString, cell);
        }
        catch (Exception e) {
            LOGGER.error("-------excel\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
            LOGGER.error("-------\u56fe\u7247\u63d2\u5165\u5f02\u5e38", (Throwable)e);
        }
    }

    private void setImgText(List<Double> wh, ReturnBody returnBody, String stringCellValue, String tempString, XSSFCell cell) {
        short fontHeight = cell.getCellStyle().getFont().getFontHeight();
        int fontSize = fontHeight / 20;
        Double v = wh.get(0);
        int v2 = (int)(v * 96.0 / 25.4 / 7.0 * FONT_CHAR.getOrDefault(fontSize, 1.8));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < v2; ++i) {
            stringBuilder.append(" ");
        }
        returnBody.setStringCellValue(stringCellValue.replace(tempString, stringBuilder));
    }

    private void handleSuggestion(String stringCellValue, String tempString, String replaceText, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody, Map<String, String> widgets) {
        if (HussarUtils.isEmpty((Object)replaceText)) {
            returnBody.setStringCellValue(stringCellValue.replace(tempString, ""));
            return;
        }
        this.processSuggestionContent(stringCellValue, tempString, replaceText, workbook, xssfSheet, cell, cellIndex, rowIndex, returnBody, widgets);
    }

    private void processSuggestionContent(String stringCellValue, String tempString, String replaceText, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody, Map<String, String> widgets) {
        String widgetName = this.extractWidgetName(tempString);
        FieldDisplayConfig displayConfig = this.parseDisplayConfig(widgets, widgetName);
        JSONArray array = JSON.parseArray((String)replaceText);
        for (Object item : array) {
            if (!(item instanceof JSONObject)) continue;
            JSONObject jsonObject = (JSONObject)item;
            this.processSuggestionItem(jsonObject, displayConfig, stringCellValue, tempString, workbook, xssfSheet, cell, cellIndex, rowIndex, returnBody, widgets);
        }
    }

    private String extractWidgetName(String tempString) {
        String[] parts;
        int endIndex;
        int startIndex = tempString.indexOf(35) + 1;
        String name = tempString.substring(startIndex, endIndex = tempString.indexOf(125));
        if (name.contains(SPLIT_LINE)) {
            name = name.split("\\|")[0];
        }
        if (name.contains(SEPARATION) && (parts = name.split(MATCHER_SEPARATION)).length == 2) {
            return parts[1];
        }
        return name;
    }

    private FieldDisplayConfig parseDisplayConfig(Map<String, String> widgets, String widgetName) {
        FieldDisplayConfig config = new FieldDisplayConfig();
        if (HussarUtils.isEmpty(widgets)) {
            return config;
        }
        String widgetStr = widgets.get("widgetsStr");
        if (HussarUtils.isEmpty((Object)widgetStr)) {
            return config;
        }
        JSONArray jsonArray = JSON.parseArray((String)widgetStr);
        for (Object item : jsonArray) {
            JSONObject widget = (JSONObject)item;
            if (!widgetName.equals(widget.getString("name"))) continue;
            JSONObject props = widget.getJSONObject("props");
            JSONArray showFields = props.getJSONArray("showFields");
            config.hasContent = showFields.contains((Object)CONTENT);
            config.hasName = showFields.contains((Object)"name");
            config.hasDate = showFields.contains((Object)"date");
            break;
        }
        return config;
    }

    private void processSuggestionItem(JSONObject jsonObject, FieldDisplayConfig displayConfig, String stringCellValue, String tempString, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody, Map<String, String> widgets) {
        int modeType = displayConfig.hasName && HussarUtils.isNotEmpty((Object)jsonObject.get((Object)SIGNATURE_KEY)) ? 1 : 0;
        jsonObject.put("_SuggestionModeType", (Object)modeType);
        String suggestionText = this.buildSuggestionText(jsonObject, displayConfig, widgets, tempString);
        if (modeType == 0) {
            returnBody.setStringCellValue(stringCellValue.replace(tempString, suggestionText));
        } else {
            this.handleSignatureMode(jsonObject, suggestionText, stringCellValue, tempString, workbook, xssfSheet, cell, cellIndex, rowIndex, returnBody);
        }
    }

    private String buildSuggestionText(JSONObject jsonObject, FieldDisplayConfig displayConfig, Map<String, String> widgets, String tempString) {
        String content = "";
        String name = "";
        String date = "";
        String allText = "";
        int modeType = (Integer)jsonObject.get((Object)"_SuggestionModeType");
        if (displayConfig.hasContent) {
            Object contentObj = jsonObject.get((Object)CONTENT);
            content = HussarUtils.isNotEmpty((Object)contentObj) ? String.valueOf(contentObj) : "";
            allText = allText + content;
        }
        if (displayConfig.hasName && modeType == 0) {
            Object nameObj = jsonObject.get((Object)USER_NAME_KEY);
            name = HussarUtils.isNotEmpty((Object)nameObj) ? String.valueOf(nameObj) : "";
            allText = allText + "  " + name;
        }
        if (displayConfig.hasDate) {
            Object dateObj = jsonObject.get((Object)"approveTime");
            date = HussarUtils.isNotEmpty((Object)dateObj) ? this.wordHandle.handleApproveTime(String.valueOf(dateObj), widgets, this.extractWidgetName(tempString)) : "";
            allText = allText + "  " + date;
        }
        return allText;
    }

    private void handleSignatureMode(JSONObject jsonObject, String suggestionText, String stringCellValue, String tempString, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody) {
        stringCellValue = stringCellValue.replace(tempString, tempString + suggestionText);
        returnBody.setStringCellValue(stringCellValue);
        Object signatureObj = jsonObject.get((Object)SIGNATURE_KEY);
        if (HussarUtils.isEmpty((Object)signatureObj)) {
            return;
        }
        this.insertSuggestionSignature(String.valueOf(signatureObj), tempString, workbook, xssfSheet, cell, cellIndex, rowIndex, returnBody);
    }

    private void insertSuggestionSignature(String signature, String tempString, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody) {
        if (!tempString.contains(SPLIT_LINE)) {
            return;
        }
        String[] parts = tempString.split("\\|");
        if (parts.length < 2) {
            return;
        }
        String sizeConfig = parts[1];
        if (!sizeConfig.contains(EQUAL_SIGN) || !sizeConfig.contains(RIGHT_PARENTHESIS)) {
            return;
        }
        ImageConfig config = this.processImageConfig(parts[1]);
        String base64Data = this.extractBase64Data(signature);
        byte[] imageBytes = this.decodeBase64(base64Data, tempString);
        if (imageBytes.length == 0) {
            return;
        }
        List<Double> wh = WordHandle.getImageWidthAndHeight(config.width, config.height, config.mode, 0.0);
        if (HussarUtils.isEmpty(wh)) {
            LOGGER.error("-------word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u5ba1\u6279\u610f\u89c1\u7b7e\u540d\u53c2\u6570\u6709\u8bef", (Object)tempString);
            return;
        }
        try {
            this.addPicture(wh, (Workbook)workbook, xssfSheet, cell, imageBytes, cellIndex, rowIndex, returnBody);
            this.setImgText(wh, returnBody, returnBody.getStringCellValue(), tempString, cell);
        }
        catch (Exception e) {
            LOGGER.error("-------excel\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
            LOGGER.error("-------\u7b7e\u540d\u56fe\u7247\u63d2\u5165\u5f02\u5e38", (Throwable)e);
        }
    }

    private void handleInputOrSer(String stringCellValue, String tempString, String replaceText, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody) {
        if (!this.isSpecialCodeFormat(tempString)) {
            returnBody.setStringCellValue(stringCellValue.replace(tempString, replaceText));
            return;
        }
        this.processCodeGeneration(stringCellValue, tempString, replaceText, workbook, xssfSheet, cell, cellIndex, rowIndex, returnBody);
    }

    private boolean isSpecialCodeFormat(String tempString) {
        return tempString.contains(SPLIT_LINE) && tempString.contains("size");
    }

    private void processCodeGeneration(String stringCellValue, String tempString, String replaceText, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody) {
        double ratioFactor;
        BarcodeFormat format;
        String[] parts = tempString.split("\\|");
        if (parts.length < 3) {
            returnBody.setStringCellValue(stringCellValue.replace(tempString, replaceText));
            return;
        }
        String codeMode = parts[1];
        String sizeConfig = parts[2];
        ImageConfig config = this.processImageConfig(sizeConfig);
        if (QR_CODE.equals(codeMode)) {
            format = BarcodeFormat.QR_CODE;
            ratioFactor = 1.0;
        } else {
            format = BarcodeFormat.CODE_128;
            ratioFactor = 1.5;
        }
        List<Double> dimensions = WordHandle.getImageWidthAndHeight(config.width, config.height, config.mode, ratioFactor);
        if (HussarUtils.isEmpty(dimensions)) {
            returnBody.setStringCellValue(stringCellValue.replace(tempString, replaceText));
            return;
        }
        this.generateAndInsertCode(workbook, xssfSheet, tempString, codeMode, replaceText, dimensions, cell, cellIndex, rowIndex, returnBody, stringCellValue, format);
        returnBody.setStringCellValue(stringCellValue.replace(tempString, ""));
    }

    private void generateAndInsertCode(XSSFWorkbook workbook, XSSFSheet xssfSheet, String tempString, String codeMode, String replaceText, List<Double> dimensions, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody, String stringCellValue, BarcodeFormat format) {
        try {
            if (QR_CODE.equals(codeMode)) {
                this.insertCode(workbook, xssfSheet, tempString, codeMode, replaceText, dimensions, cell, cellIndex, rowIndex, returnBody, stringCellValue, format, ErrorCorrectionLevel.M);
            } else {
                this.insertCode(workbook, xssfSheet, tempString, codeMode, replaceText, dimensions, cell, cellIndex, rowIndex, returnBody, stringCellValue, format, ErrorCorrectionLevel.H);
            }
        }
        catch (Exception e) {
            LOGGER.error("-------\u6761\u7801\u751f\u6210\u5f02\u5e38: {}", (Object)tempString, (Object)e);
            returnBody.setStringCellValue(stringCellValue.replace(tempString, replaceText));
        }
    }

    private void insertCode(XSSFWorkbook workbook, XSSFSheet xssfSheet, String tempString, String codeMode, String replaceText, List<Double> wh, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody, String stringCellValue, BarcodeFormat barcodeFormat, ErrorCorrectionLevel errorCorrectionLevel) {
        try {
            BufferedImage bufferedImage = GenerateCode.generateCode(replaceText, codeMode, barcodeFormat, errorCorrectionLevel);
            if (HussarUtils.isNotEmpty((Object)bufferedImage)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                this.addPicture(wh, (Workbook)workbook, xssfSheet, cell, byteArray, cellIndex, rowIndex, returnBody);
                this.setImgText(wh, returnBody, stringCellValue, tempString, cell);
            }
        }
        catch (Exception e) {
            LOGGER.error("-------\u6761\u7801\u751f\u6210\u5f02\u5e38: {}", (Object)tempString);
            LOGGER.error("-------\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
        }
    }

    private String handleRichText(String stringCellValue, String group) {
        return stringCellValue.replace(group, "");
    }

    private String handleFile(String stringCellValue, String group, String replaceText) {
        JSONArray parse = (JSONArray)JSON.parse((String)replaceText);
        if (HussarUtils.isNotEmpty((Object)parse)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parse.size() - 1; ++i) {
                JSONObject o = (JSONObject)parse.get(i);
                String fileName = String.valueOf(o.get((Object)"name"));
                sb.append(fileName).append(",");
            }
            String fileNameLast = String.valueOf(((JSONObject)parse.get(parse.size() - 1)).get((Object)"name"));
            sb.append(fileNameLast);
            replaceText = sb.toString();
        }
        return stringCellValue.replace(group, replaceText);
    }

    private void replaceSelect(XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFRow xssfRow, XSSFCell xssfCell, int cellIndex, String stringCellValue) {
        if (!this.requiresSpecialProcessing(stringCellValue)) {
            return;
        }
        stringCellValue = this.handleCurrencySymbols(stringCellValue, xssfCell, workbook);
        XSSFRichTextString richText = this.createStyledRichText(workbook, xssfCell, stringCellValue);
        this.applyRichTextToCell(xssfCell, richText, xssfSheet, cellIndex, xssfRow);
    }

    private boolean requiresSpecialProcessing(String stringCellValue) {
        return stringCellValue != null && stringCellValue.contains(MARK_KEY) && (stringCellValue.contains(SELECT_KEY) || stringCellValue.contains(NO_SELECT_KEY));
    }

    private String handleCurrencySymbols(String stringCellValue, XSSFCell xssfCell, XSSFWorkbook workbook) {
        if (!stringCellValue.contains(D_MARK_KEY)) {
            return stringCellValue.replace(MARK_KEY, "");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean firstOccurrence = true;
        for (char c : stringCellValue.toCharArray()) {
            if (c == 'R' || c == '\u00a3') {
                if (firstOccurrence) {
                    stringBuilder.append(c);
                    firstOccurrence = false;
                    continue;
                }
                stringBuilder.append('\n').append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        XSSFCellStyle cellStyle = xssfCell.getCellStyle() != null ? xssfCell.getCellStyle() : workbook.createCellStyle();
        cellStyle.setWrapText(true);
        xssfCell.setCellStyle((CellStyle)cellStyle);
        return stringBuilder.toString().replace(MARK_KEY, "");
    }

    private XSSFRichTextString createStyledRichText(XSSFWorkbook workbook, XSSFCell xssfCell, String text) {
        XSSFFont font = this.getOrCreateFont(workbook, xssfCell);
        XSSFFont symbolFont = workbook.createFont();
        symbolFont.setFontName(WINGDINGS_2);
        XSSFRichTextString richText = new XSSFRichTextString(text);
        this.applyFontStyles(richText, text, font, symbolFont);
        return richText;
    }

    private XSSFFont getOrCreateFont(XSSFWorkbook workbook, XSSFCell xssfCell) {
        XSSFFont font = null;
        if (xssfCell.getCellStyle() != null) {
            font = xssfCell.getCellStyle().getFont();
        }
        return font != null ? font : workbook.createFont();
    }

    private void applyFontStyles(XSSFRichTextString richText, String text, XSSFFont baseFont, XSSFFont symbolFont) {
        if (text.isEmpty()) {
            return;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            XSSFFont fontToApply = c == 'R' || c == '\u00a3' ? symbolFont : baseFont;
            richText.applyFont(i, i + 1, (Font)fontToApply);
        }
    }

    private void applyRichTextToCell(XSSFCell cell, XSSFRichTextString richText, XSSFSheet sheet, int cellIndex, XSSFRow row) {
        cell.setCellValue((RichTextString)richText);
        this.setCellWidth(richText.getString(), sheet, cell, cellIndex);
        this.setCellHeight(sheet, richText.toString(), row, cell);
    }

    private String handleSelect(String stringCellValue, String tempString, String replaceText, Map<String, String> widgets, Map<String, Object> param) {
        if (!this.wordPrintProperties.isSelectionBoxEnable()) {
            return stringCellValue.replace(tempString, replaceText);
        }
        return this.processSelectionBox(stringCellValue, tempString, replaceText, widgets, param);
    }

    private String processSelectionBox(String stringCellValue, String tempString, String replaceText, Map<String, String> widgets, Map<String, Object> param) {
        String sub = this.extractKeyFromTempString(tempString);
        if (sub.contains(SEPARATION)) {
            sub = sub.split(MATCHER_SEPARATION)[1];
        }
        List<String> ids = this.extractIdsFromParam(sub, param);
        List<String> boxS = this.splitReplaceText(replaceText);
        List<Object> optionList = this.parseWidgetsOptions(widgets, sub, ids, boxS);
        this.updateOptionListLabels(optionList, ids, boxS);
        String checkBoxText = this.buildCheckBoxText(optionList, boxS);
        return this.buildFinalResult(stringCellValue, tempString, checkBoxText);
    }

    private String extractKeyFromTempString(String tempString) {
        String sub = tempString.substring(tempString.indexOf("#") + 1, tempString.indexOf(RIGHT_PARENTHESIS));
        return sub.contains(SPLIT_LINE) ? sub.split("\\|")[0] : sub;
    }

    private List<String> extractIdsFromParam(String sub, Map<String, Object> param) {
        JSONObject jsonObject;
        Object idObjS;
        ArrayList<String> ids = new ArrayList<String>();
        String idKey = sub + "_value";
        Object dataValue = param.get(DATA_VALUE);
        if (HussarUtils.isNotEmpty((Object)dataValue) && HussarUtils.isNotEmpty((Object)(idObjS = (jsonObject = (JSONObject)dataValue).get((Object)idKey)))) {
            Collections.addAll(ids, String.valueOf(idObjS).split(","));
        }
        return ids;
    }

    private List<String> splitReplaceText(String replaceText) {
        return HussarUtils.isNotEmpty((Object)replaceText) ? new ArrayList<String>(Arrays.asList(replaceText.split(","))) : new ArrayList();
    }

    private List<Object> parseWidgetsOptions(Map<String, String> widgets, String substring, List<String> ids, List<String> boxS) {
        ArrayList<Object> optionList = new ArrayList<Object>();
        String widgetsStr = widgets.get("widgetsStr");
        if (widgetsStr == null) {
            return optionList;
        }
        JSONArray jsonArray = JSON.parseArray((String)widgetsStr);
        for (Object obj : jsonArray) {
            JSONObject jsonObj;
            if (!(obj instanceof JSONObject) || !substring.equals((jsonObj = (JSONObject)obj).get((Object)"name"))) continue;
            this.processWidgetOptions(jsonObj, optionList, ids, boxS);
        }
        return optionList;
    }

    private void processWidgetOptions(JSONObject widgetObj, List<Object> optionList, List<String> ids, List<String> boxS) {
        Object propsObj = widgetObj.get((Object)"props");
        if (!(propsObj instanceof JSONObject)) {
            return;
        }
        JSONObject props = (JSONObject)propsObj;
        Object optionType = props.get((Object)OPTION_TYPE_KEY);
        if (HussarUtils.isNotEmpty((Object)optionType) && !HussarUtils.equals((Object)optionType, (Object)STATIC_KEY)) {
            this.handleDynamicOptions(props, optionList, ids, boxS);
        } else {
            this.handleStaticOptions(props, optionList);
        }
    }

    private void handleDynamicOptions(JSONObject props, List<Object> optionList, List<String> ids, List<String> boxS) {
        String optionTypeS;
        switch (optionTypeS = String.valueOf(props.get((Object)OPTION_TYPE_KEY))) {
            case "dict": {
                this.wordHandle.useDict(props, optionList, ids, boxS);
                break;
            }
            case "async": {
                this.wordHandle.useAsync(props, optionList, ids, boxS);
                break;
            }
            case "dataLinkage": {
                this.wordHandle.useDataLinkage(props, optionList, ids, boxS);
                break;
            }
            default: {
                this.handleStaticOptions(props, optionList);
            }
        }
    }

    private void handleStaticOptions(JSONObject props, List<Object> optionList) {
        Object options = props.get((Object)OPTIONS_KEY);
        if (options instanceof JSONArray) {
            for (Object opt : (JSONArray)options) {
                if (!(opt instanceof JSONObject)) continue;
                optionList.add(opt);
            }
        }
    }

    private void updateOptionListLabels(List<Object> optionList, List<String> ids, List<String> boxS) {
        block0: for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            if (i >= boxS.size()) continue;
            String currentBox = boxS.get(i);
            for (Object obj : optionList) {
                JSONObject jsonObj;
                Object value;
                if (!(obj instanceof JSONObject) || (value = (jsonObj = (JSONObject)obj).get((Object)VALUE_KEY)) == null || !id.equals(String.valueOf(value))) continue;
                jsonObj.put(LABEL_KEY, (Object)currentBox);
                continue block0;
            }
        }
    }

    private String buildCheckBoxText(List<Object> optionList, List<String> boxS) {
        List<String> labels = this.extractValidLabels(optionList);
        HashSet<Integer> matchedIndexes = new HashSet<Integer>();
        StringBuilder checkBoxText = new StringBuilder();
        for (String label : labels) {
            int matchIndex = boxS.indexOf(label);
            if (matchIndex != -1) {
                matchedIndexes.add(matchIndex);
                this.appendSelectedItem(checkBoxText, label);
                continue;
            }
            this.appendUnselectedItem(checkBoxText, label);
        }
        for (int i = 0; i < boxS.size(); ++i) {
            if (matchedIndexes.contains(i)) continue;
            this.appendSelectedItem(checkBoxText, boxS.get(i));
        }
        return checkBoxText.toString();
    }

    private List<String> extractValidLabels(List<Object> optionList) {
        ArrayList<String> labels = new ArrayList<String>();
        for (Object obj : optionList) {
            JSONObject jsonObj;
            Object label;
            if (!(obj instanceof JSONObject) || !((label = (jsonObj = (JSONObject)obj).get((Object)LABEL_KEY)) instanceof String)) continue;
            labels.add((String)label);
        }
        return labels;
    }

    private void appendSelectedItem(StringBuilder sb, String text) {
        sb.append(SELECT_KEY).append(text).append(BLANK);
    }

    private void appendUnselectedItem(StringBuilder sb, String text) {
        sb.append(NO_SELECT_KEY).append(text).append(BLANK);
    }

    private String buildFinalResult(String baseText, String tempString, String checkBoxText) {
        if (checkBoxText.isEmpty()) {
            return baseText.replace(tempString, "");
        }
        String mark = tempString.contains(VERTICAL) ? D_MARK_KEY : MARK_KEY;
        return baseText.replace(tempString, mark + checkBoxText);
    }

    private String handleTextArea(String stringCellValue, String tempString, String replaceText, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFRow row, XSSFCell cell, int cellIndex) {
        XSSFCellStyle cellStyle = HussarUtils.isNotEmpty((Object)cell.getCellStyle()) ? cell.getCellStyle() : workbook.createCellStyle();
        cellStyle.setWrapText(true);
        cell.setCellStyle((CellStyle)cellStyle);
        String replace = stringCellValue.replace(tempString, replaceText);
        this.setCellHeight(xssfSheet, replace, row, cell);
        return replace;
    }

    private void setCellWidth(String replace, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex) {
        String maxText = this.getLongestLine(replace);
        if (maxText == null || maxText.isEmpty()) {
            return;
        }
        double adjustedLength = this.calculateAdjustedLength(maxText);
        double requiredWidth = adjustedLength * 2.0 * 256.0;
        CellRangeAddress mergedRegion = this.findMergedRegionContainingCell((Sheet)xssfSheet, (Cell)cell);
        if (mergedRegion != null) {
            this.handleMergedRegion(xssfSheet, mergedRegion, adjustedLength, requiredWidth);
        } else {
            this.handleSingleColumn(xssfSheet, cellIndex, requiredWidth);
        }
    }

    private String getLongestLine(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String[] lines = text.split("\n");
        if (lines.length == 0) {
            return text;
        }
        String longest = lines[0];
        for (int i = 1; i < lines.length; ++i) {
            if (lines[i].getBytes().length <= longest.getBytes().length) continue;
            longest = lines[i];
        }
        return longest;
    }

    private double calculateAdjustedLength(String text) {
        double length = 0.0;
        for (char c : text.toCharArray()) {
            if (this.isCjkCharacter(c)) {
                length += 1.0;
                continue;
            }
            length += 0.6;
        }
        return length;
    }

    private boolean isCjkCharacter(char c) {
        return c >= '\u4e00' && c <= '\u9fa5' || c >= '\u3400' && c <= '\u4dbf';
    }

    private void handleMergedRegion(XSSFSheet sheet, CellRangeAddress region, double adjustedLength, double requiredWidth) {
        boolean shouldResize;
        int firstCol = region.getFirstColumn();
        int lastCol = region.getLastColumn();
        int colCount = lastCol - firstCol + 1;
        int currentTotalWidth = 0;
        for (int i = firstCol; i <= lastCol; ++i) {
            currentTotalWidth += sheet.getColumnWidth(i);
        }
        double perColWidth = (adjustedLength / (double)colCount + 1.0) * 2.0 * 256.0;
        boolean bl = shouldResize = (double)currentTotalWidth < requiredWidth && perColWidth <= 65280.0;
        if (!shouldResize) {
            return;
        }
        for (int i = firstCol; i <= lastCol; ++i) {
            sheet.setColumnWidth(i, (int)perColWidth);
        }
    }

    private void handleSingleColumn(XSSFSheet sheet, int colIndex, double requiredWidth) {
        int newWidth;
        int currentWidth = sheet.getColumnWidth(colIndex);
        if (currentWidth < (newWidth = (int)Math.min(requiredWidth, 65280.0))) {
            sheet.setColumnWidth(colIndex, newWidth);
        }
    }

    private void setCellHeight(XSSFSheet xssfSheet, String text, XSSFRow row, XSSFCell xssfCell) {
        String[] split = text.split("\n");
        int lineCount = split.length + 1;
        int columnWidth = xssfSheet.getColumnWidth(xssfCell.getColumnIndex());
        XSSFCellStyle cellStyle = xssfCell.getCellStyle();
        boolean wrapText = cellStyle.getWrapText();
        CellRangeAddress cellAddresses = this.findMergedRegionContainingCell((Sheet)xssfSheet, (Cell)xssfCell);
        columnWidth = this.getColumnWidthAddress(xssfSheet, cellAddresses, columnWidth);
        if (wrapText) {
            lineCount = this.calculateLineCount(split, columnWidth, lineCount);
            short height = (short)(xssfCell.getCellStyle().getFont().getFontHeightInPoints() + 4);
            if (row.getHeightInPoints() < (float)(height * lineCount)) {
                row.setHeightInPoints((float)(height * lineCount));
            }
        }
    }

    private int getColumnWidthAddress(XSSFSheet xssfSheet, CellRangeAddress cellAddresses, int columnWidth) {
        if (cellAddresses != null) {
            int firstColumn = cellAddresses.getFirstColumn();
            int lastColumn = cellAddresses.getLastColumn();
            int total = 0;
            for (int i = firstColumn; i <= lastColumn; ++i) {
                int columnW = xssfSheet.getColumnWidth(i);
                total += columnW;
            }
            columnWidth = total;
        }
        return columnWidth;
    }

    private int calculateLineCount(String[] split, int columnWidth, int lineCount) {
        if (columnWidth <= 0) {
            return lineCount;
        }
        for (String s : split) {
            double length = this.calculateAdjustedLength(s);
            int i = (int)(length * 2.0 * 256.0);
            if (i <= columnWidth) continue;
            int i1 = i / columnWidth + 1;
            lineCount += i1;
        }
        return lineCount;
    }

    private void handleImg(String stringCellValue, String tempString, String replaceText, Workbook workbook, XSSFSheet xssfSheet, XSSFCell cell, int cellIndex, int rowIndex, ReturnBody returnBody) {
        ImageConfig imageConfig = this.processImageConfig(tempString);
        this.processImageData(replaceText, workbook, xssfSheet, cell, cellIndex, rowIndex, stringCellValue, tempString, returnBody, imageConfig);
        returnBody.setStringCellValue(stringCellValue.replace(tempString, ""));
    }

    private void processImageData(String replaceText, Workbook workbook, XSSFSheet sheet, XSSFCell cell, int cellIndex, int rowIndex, String stringCellValue, String tempString, ReturnBody returnBody, ImageConfig imageConfig) {
        JSONArray images = (JSONArray)JSON.parse((String)replaceText);
        if (images == null || images.isEmpty()) {
            return;
        }
        for (Object obj : images) {
            if (!(obj instanceof JSONObject)) continue;
            this.processSingleImage((JSONObject)obj, workbook, sheet, cell, cellIndex, rowIndex, stringCellValue, tempString, returnBody, imageConfig);
        }
    }

    private void processSingleImage(JSONObject imageJson, Workbook workbook, XSSFSheet sheet, XSSFCell cell, int cellIndex, int rowIndex, String stringCellValue, String tempString, ReturnBody returnBody, ImageConfig imageConfig) {
        Long id = Long.valueOf(String.valueOf(imageJson.get((Object)ID_KEY)));
        String type = String.valueOf(imageJson.get((Object)"type"));
        byte[] imageBytes = this.wordHandle.showImageByte(id);
        if (imageBytes == null || imageBytes.length == 0) {
            return;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(imageBytes);){
            List<Double> dimensions;
            BufferedImage image = ImageIO.read(stream);
            double aspectRatio = (double)image.getWidth() / (double)image.getHeight();
            if (HussarUtils.isNotEmpty((Object)type) && type.equals("ico")) {
                InputStream stream1 = this.wordHandle.handleIco(this.hussarFormDesignProperties.getWorkspace(), image);
                imageBytes = IOUtils.toByteArray((InputStream)stream1);
            }
            if ((dimensions = WordHandle.getImageWidthAndHeight(imageConfig.width, imageConfig.height, imageConfig.mode, aspectRatio)).size() < 2) {
                LOGGER.error("-------excel\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef", (Object)tempString);
                return;
            }
            this.addPicture(dimensions, workbook, sheet, cell, imageBytes, cellIndex, rowIndex, returnBody);
            this.setImgText(dimensions, returnBody, stringCellValue, tempString, cell);
        }
        catch (Exception e) {
            LOGGER.error("-------\u56fe\u7247\u5904\u7406\u5f02\u5e38 - \u6a21\u677f\u5360\u4f4d\u7b26\uff1a{}", (Object)tempString);
            LOGGER.error("-------\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
        }
    }

    private void addPicture(List<Double> wh, Workbook workbook, XSSFSheet xssfSheet, XSSFCell cell, byte[] bytes, int cellIndex, int rowIndex, ReturnBody returnBody) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        short alignmentCode = 0;
        VerticalAlignment verticalAlignment = VerticalAlignment.BOTTOM;
        if (HussarUtils.isNotEmpty((Object)cellStyle)) {
            verticalAlignment = cellStyle.getVerticalAlignment();
            HorizontalAlignment alignment = cellStyle.getAlignment();
            alignmentCode = alignment.getCode();
        }
        Double widthO = wh.get(0);
        Double heightO = wh.get(1);
        int height = (int)(heightO * 96.0 * 9525.0 / 25.4);
        double heightP = heightO * 2.834;
        XSSFRow row = xssfSheet.getRow(rowIndex) != null ? xssfSheet.getRow(rowIndex) : xssfSheet.createRow(rowIndex);
        CellRangeAddress cellAddresses = this.findMergedRegionContainingCell((Sheet)xssfSheet, (Cell)cell);
        VerticalHeight verticalHeight = new VerticalHeight(0, 0, 0, rowIndex, rowIndex);
        if (cellAddresses != null && cellAddresses.getLastRow() != cellAddresses.getFirstRow()) {
            this.handleRangeVertical(cellAddresses, xssfSheet, verticalAlignment, cell, returnBody, heightP, height, verticalHeight);
        } else {
            this.handleNoRangeVertical((Row)row, cellStyle, verticalAlignment, cell, returnBody, heightP, height, verticalHeight);
        }
        int startNum = returnBody.getStartNum();
        int pictureIdx = workbook.addPicture(bytes, 6);
        XSSFDrawing drawing = xssfSheet.createDrawingPatriarch();
        int endNum = (int)((double)startNum + widthO * 36000.0);
        int withMax = (int)((double)endNum / 9525.0 / 7.0 * 256.0);
        HorizontalWidth horizontalWidth = new HorizontalWidth(cellIndex, cellIndex, 0, 0);
        this.handleHorizontal(cellIndex, alignmentCode, xssfSheet, withMax, cellAddresses, endNum, startNum, horizontalWidth);
        ClientAnchor drawingAnchor = drawing.createAnchor(horizontalWidth.dx1, verticalHeight.dy1, horizontalWidth.dx2, verticalHeight.dy2, horizontalWidth.col1, verticalHeight.firstRow2, horizontalWidth.col2, verticalHeight.lastRow2);
        drawingAnchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        drawing.createPicture(drawingAnchor, pictureIdx);
        returnBody.setStartNum(endNum);
    }

    private int handleVerticalHeight(VerticalAlignment verticalAlignment, XSSFCell cell, ReturnBody returnBody, float heightInPoints, double heightP) {
        int v;
        switch (verticalAlignment) {
            case CENTER: {
                v = (int)((double)(cell.getCellStyle().getFont().getFontHeightInPoints() * (returnBody.getHeightNum() / 2)) * 12700.0);
                v = (int)(heightInPoints / 2.0f + (float)v);
                if (!((double)v > heightP / 2.0)) break;
                v = (int)((double)v - heightP / 2.0);
                break;
            }
            case TOP: {
                v = (int)((double)(cell.getCellStyle().getFont().getFontHeightInPoints() * returnBody.getHeightNum()) * 12700.0);
                break;
            }
            default: {
                v = (int)((double)(cell.getCellStyle().getFont().getFontHeightInPoints() * returnBody.getHeightNum()) * 12700.0);
                v = (int)(heightInPoints - (float)v);
                if (!((double)v > heightP)) break;
                v = (int)((double)v - heightP);
            }
        }
        return v;
    }

    private void handleRangeVertical(CellRangeAddress cellAddresses, XSSFSheet xssfSheet, VerticalAlignment verticalAlignment, XSSFCell cell, ReturnBody returnBody, double heightP, int height, VerticalHeight verticalHeight) {
        int i;
        int firstRow = cellAddresses.getFirstRow();
        int lastRow = cellAddresses.getLastRow();
        float heightInPoints = 0.0f;
        for (int i2 = firstRow; i2 <= lastRow; ++i2) {
            heightInPoints += xssfSheet.getRow(i2).getHeightInPoints();
        }
        verticalHeight.v = this.handleVerticalHeight(verticalAlignment, cell, returnBody, heightInPoints, heightP);
        float heightInPointsIndex = 0.0f;
        verticalHeight.dy1 = verticalHeight.v;
        verticalHeight.dy2 = height + verticalHeight.v;
        for (i = firstRow; i <= lastRow; ++i) {
            if (!((heightInPointsIndex += xssfSheet.getRow(i).getHeightInPoints()) > (float)verticalHeight.v)) continue;
            verticalHeight.firstRow2 = i;
            verticalHeight.dy1 = (int)((float)verticalHeight.v - (heightInPointsIndex - xssfSheet.getRow(i).getHeightInPoints())) * 12700;
            break;
        }
        heightInPointsIndex = 0.0f;
        for (i = firstRow; i <= lastRow; ++i) {
            if (!((double)(heightInPointsIndex += xssfSheet.getRow(i).getHeightInPoints()) > heightP + (double)verticalHeight.v)) continue;
            verticalHeight.lastRow2 = i;
            verticalHeight.dy2 = (int)(heightP + (double)verticalHeight.v - (double)(heightInPointsIndex - xssfSheet.getRow(i).getHeightInPoints())) * 12700;
            break;
        }
    }

    private void handleNoRangeVertical(Row row, XSSFCellStyle cellStyle, VerticalAlignment verticalAlignment, XSSFCell cell, ReturnBody returnBody, double heightP, int height, VerticalHeight verticalHeight) {
        int v;
        float heightInPoints = row.getHeightInPoints();
        int y = (int)heightP;
        if (cellStyle.getWrapText() && !returnBody.isExpansionHeight) {
            y = (int)((double)heightInPoints + heightP);
            returnBody.setExpansionHeight(true);
        }
        if (heightInPoints < (float)y) {
            row.setHeightInPoints((float)y);
        }
        switch (verticalAlignment) {
            case CENTER: {
                v = (int)((double)(cell.getCellStyle().getFont().getFontHeightInPoints() * (returnBody.getHeightNum() / 2)) * 12700.0);
                v = (int)(row.getHeightInPoints() / 2.0f * 12700.0f + (float)v);
                if (v > height / 2) {
                    v -= height / 2;
                    break;
                }
                v = 0;
                break;
            }
            case TOP: {
                v = (int)((double)(cell.getCellStyle().getFont().getFontHeightInPoints() * returnBody.getHeightNum()) * 12700.0);
                break;
            }
            default: {
                v = (int)((double)(cell.getCellStyle().getFont().getFontHeightInPoints() * returnBody.getHeightNum()) * 12700.0);
                v = (int)(row.getHeightInPoints() * 12700.0f - (float)v);
                if (v > height) {
                    v -= height;
                    break;
                }
                v = 0;
            }
        }
        int dy1 = v;
        int dy2 = height + v;
        verticalHeight.v = v;
        verticalHeight.dy1 = dy1;
        verticalHeight.dy2 = dy2;
    }

    private void handleHorizontal(int cellIndex, int alignmentCode, XSSFSheet xssfSheet, int withMax, CellRangeAddress cellAddresses, int endNum, int startNum, HorizontalWidth horizontalWidth) {
        if (alignmentCode == HorizontalAlignment.RIGHT.getCode()) {
            this.rightHorizontal(cellAddresses, xssfSheet, horizontalWidth, endNum, startNum, withMax, cellIndex);
        } else if (alignmentCode == HorizontalAlignment.CENTER.getCode()) {
            this.centerHorizontal(xssfSheet, horizontalWidth, withMax, cellIndex);
        } else {
            this.leftOrDefaultHorizontal(cellAddresses, xssfSheet, horizontalWidth, endNum, startNum, withMax, cellIndex);
        }
    }

    private void rightHorizontal(CellRangeAddress cellAddresses, XSSFSheet xssfSheet, HorizontalWidth horizontalWidth, int endNum, int startNum, int withMax, int cellIndex) {
        int widthAll = 0;
        int col1 = horizontalWidth.col1;
        int col2 = horizontalWidth.col2;
        int dx1 = horizontalWidth.dx1;
        int dx2 = horizontalWidth.dx2;
        if (HussarUtils.isNotEmpty((Object)cellAddresses)) {
            int firstColumn = cellAddresses.getFirstColumn();
            int lastColumn = cellAddresses.getLastColumn();
            boolean col2Flag = true;
            for (int i = lastColumn; i > firstColumn; --i) {
                int width = (int)((double)xssfSheet.getColumnWidth(i) / 28.44 * 0.8 * 9525.0);
                if ((widthAll += width) >= startNum && col2Flag) {
                    col2 = i;
                    dx2 = widthAll - startNum;
                    col2Flag = false;
                }
                if (widthAll < endNum) continue;
                col1 = i;
                dx1 = widthAll - endNum;
                break;
            }
        } else {
            widthAll = xssfSheet.getColumnWidth(cellIndex);
            if (withMax > widthAll) {
                xssfSheet.setColumnWidth(cellIndex, withMax);
            }
            dx1 = (int)((double)xssfSheet.getColumnWidth(cellIndex) / 28.44 * 0.8 * 9525.0) - endNum;
            dx2 = (int)((double)xssfSheet.getColumnWidth(cellIndex) / 28.44 * 0.8 * 9525.0) - startNum;
        }
        horizontalWidth.col1 = col1;
        horizontalWidth.col2 = col2;
        horizontalWidth.dx1 = dx1;
        horizontalWidth.dx2 = dx2;
    }

    private void centerHorizontal(XSSFSheet xssfSheet, HorizontalWidth horizontalWidth, int withMax, int cellIndex) {
        int widthAll = 0;
        int col1 = horizontalWidth.col1;
        int col2 = horizontalWidth.col2;
        widthAll = xssfSheet.getColumnWidth(cellIndex);
        if (withMax > widthAll) {
            widthAll = withMax;
            xssfSheet.setColumnWidth(cellIndex, withMax);
        }
        int dx1 = (int)((double)(widthAll - withMax) / 2.0 / 28.44 * 0.8 * 9525.0);
        int dx2 = (int)((double)(widthAll + withMax) / 2.0 / 28.44 * 0.8 * 9525.0);
        horizontalWidth.col1 = col1;
        horizontalWidth.col2 = col2;
        horizontalWidth.dx1 = dx1;
        horizontalWidth.dx2 = dx2;
    }

    private void leftOrDefaultHorizontal(CellRangeAddress cellAddresses, XSSFSheet xssfSheet, HorizontalWidth horizontalWidth, int endNum, int startNum, int withMax, int cellIndex) {
        int widthAll = 0;
        horizontalWidth.dx1 = 0;
        horizontalWidth.dx2 = 0;
        horizontalWidth.widthDel = 0;
        horizontalWidth.widthDelStart = 0;
        if (HussarUtils.isNotEmpty((Object)cellAddresses)) {
            int firstColumn = cellAddresses.getFirstColumn();
            int lastColumn = cellAddresses.getLastColumn();
            int widthM = 0;
            for (int i = firstColumn; i <= lastColumn; ++i) {
                int width = xssfSheet.getColumnWidth(i);
                widthM += width;
            }
            if (withMax > widthM) {
                xssfSheet.setColumnWidth(cellIndex, withMax);
            }
            boolean setCol1 = false;
            this.getWidthDel(firstColumn, lastColumn, widthAll, xssfSheet, startNum, setCol1, horizontalWidth, endNum);
        } else {
            widthAll = xssfSheet.getColumnWidth(cellIndex);
            if (withMax > widthAll) {
                xssfSheet.setColumnWidth(cellIndex, withMax);
            }
        }
        horizontalWidth.dx1 = startNum - horizontalWidth.widthDelStart;
        horizontalWidth.dx2 = endNum - horizontalWidth.widthDel;
    }

    private void getWidthDel(int firstColumn, int lastColumn, int widthAll, XSSFSheet xssfSheet, int startNum, boolean setCol1, HorizontalWidth horizontalWidth, int endNum) {
        int widthDel = horizontalWidth.widthDel;
        int col1 = horizontalWidth.col1;
        int col2 = horizontalWidth.col2;
        int widthDelStart = horizontalWidth.widthDelStart;
        for (int i = firstColumn; i < lastColumn; ++i) {
            int width = (int)((double)xssfSheet.getColumnWidth(i) / 28.44 * 0.8 * 9525.0);
            if ((widthAll += width) >= startNum && !setCol1) {
                widthDelStart = widthAll - width;
                col1 = i;
                setCol1 = true;
            }
            if (widthAll >= endNum) {
                col2 = i;
                break;
            }
            widthDel += width;
        }
        horizontalWidth.col1 = col1;
        horizontalWidth.col2 = col2;
        horizontalWidth.widthDel = widthDel;
        horizontalWidth.widthDelStart = widthDelStart;
    }

    public void deleteRow(XSSFSheet sheet, Set<Integer> removeRows) {
        List collect = removeRows.stream().sorted().collect(Collectors.toList());
        if (HussarUtils.isEmpty(collect)) {
            return;
        }
        int removeNum = 0;
        for (Integer rowIndex : collect) {
            LOGGER.info("-------\u5220\u9664\u6a21\u677f\u884c,\u884c\u53f7\uff1a{}", (Object)rowIndex);
            rowIndex = rowIndex - removeNum;
            XSSFRow row = sheet.getRow(rowIndex.intValue());
            ++removeNum;
            if (HussarUtils.isEmpty((Object)row)) continue;
            sheet.removeRow((Row)row);
            int lastRowNum = sheet.getLastRowNum();
            if (rowIndex >= lastRowNum) continue;
            this.moveRow(sheet, rowIndex, lastRowNum);
        }
    }

    private void moveRow(XSSFSheet sheet, int rowIndex, int lastRowNum) {
        this.moveShapes(sheet, rowIndex, -1);
        ArrayList mergedRegions = new ArrayList(sheet.getMergedRegions());
        sheet.shiftRows(rowIndex + 1, lastRowNum, -1, true, false);
        List newRegions = sheet.getMergedRegions();
        mergedRegions.removeAll(newRegions);
        for (CellRangeAddress region : mergedRegions) {
            int lastRow;
            int firstRow = region.getFirstRow();
            if (firstRow == (lastRow = region.getLastRow()) || firstRow > rowIndex || lastRow <= firstRow + 1) continue;
            region.setLastRow(Math.max(lastRow - 1, 0));
            sheet.addMergedRegion(region);
        }
    }

    private void moveShapes(XSSFSheet sheet, int rowIndex, int moveNum) {
        XSSFDrawing drawing = sheet.createDrawingPatriarch();
        List shapes = drawing.getShapes();
        for (XSSFShape shape : shapes) {
            XSSFAnchor anchor = shape.getAnchor();
            ClientAnchor oldAnchor = (ClientAnchor)anchor;
            int row = oldAnchor.getRow1();
            if (row <= rowIndex) continue;
            oldAnchor.setRow1(Math.max(oldAnchor.getRow1() + moveNum, 0));
            oldAnchor.setRow2(Math.max(oldAnchor.getRow2() + moveNum, 0));
        }
    }

    public void deleteImageAtCell(XSSFSheet sheet, int start, int end, VerticalAlignment verticalAlignment, int targetCol) {
        XSSFDrawing drawing;
        ArrayList<Integer> targetRows = new ArrayList<Integer>();
        switch (verticalAlignment) {
            case CENTER: {
                int t;
                int i = (end - start) / 2 + start;
                for (t = start; t <= end; ++t) {
                    if (t == i) continue;
                    targetRows.add(t);
                }
                break;
            }
            case TOP: {
                int t;
                for (t = start + 1; t <= end; ++t) {
                    targetRows.add(t);
                }
                break;
            }
            default: {
                int t;
                for (t = start; t < end; ++t) {
                    targetRows.add(t);
                }
            }
        }
        if ((drawing = sheet.getDrawingPatriarch()) == null) {
            return;
        }
        CTDrawing ctDrawing = drawing.getCTDrawing();
        Iterator iterator = targetRows.iterator();
        while (iterator.hasNext()) {
            int targetRow = (Integer)iterator.next();
            this.processAnchors(ctDrawing, ctDrawing.getTwoCellAnchorList(), targetRow, targetCol, true);
            this.processAnchors(ctDrawing, ctDrawing.getOneCellAnchorList(), targetRow, targetCol, false);
        }
    }

    private void processAnchors(CTDrawing ctDrawing, List anchors, int targetRow, int targetCol, boolean isTwoCell) {
        for (int i = anchors.size() - 1; i >= 0; --i) {
            Object anchor = anchors.get(i);
            CTPicture pic = null;
            CTMarker from = null;
            if (anchor instanceof CTTwoCellAnchor) {
                CTTwoCellAnchor twoCellAnchor = (CTTwoCellAnchor)anchor;
                from = twoCellAnchor.getFrom();
                pic = twoCellAnchor.getPic();
            } else if (anchor instanceof CTOneCellAnchor) {
                CTOneCellAnchor oneCellAnchor = (CTOneCellAnchor)anchor;
                pic = oneCellAnchor.getPic();
                from = oneCellAnchor.getFrom();
            }
            if (pic == null || from.getRow() != targetRow || from.getCol() != targetCol) continue;
            if (isTwoCell) {
                ctDrawing.removeTwoCellAnchor(i);
                continue;
            }
            ctDrawing.removeOneCellAnchor(i);
        }
    }

    public void hostCellHandle(XSSFSheet sheetAt, Map<Integer, List<XSSFCell>> cellLevelMap, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject parse, int maxAddRow, int k, XSSFWorkbook workbook, boolean isGroup) {
        List<XSSFCell> hostCells = cellLevelMap.get(CellLevel.HOST.getLevel());
        if (HussarUtils.isEmpty(hostCells)) {
            return;
        }
        for (XSSFCell hostCell : hostCells) {
            this.processHostCell(hostCell, sheetAt, sheetAtRow, widgets, parse, maxAddRow, k, workbook, isGroup);
        }
    }

    private void processHostCell(XSSFCell xssfCell, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject parse, int maxAddRow, int k, XSSFWorkbook workbook, boolean isGroup) {
        int cellIndex = xssfCell.getColumnIndex();
        String text = this.getCellValueString(xssfCell);
        ArrayList<String> groups = new ArrayList<String>();
        Matcher matcher = this.wordHandle.matcher(text);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        boolean isMerge = this.matcherHost(matcher, map, parse, groups);
        if (maxAddRow > 0) {
            this.multiHost(xssfCell, sheetAt, sheetAtRow, widgets, maxAddRow, k, workbook, cellIndex, map, isMerge, text);
        } else if (!groups.isEmpty()) {
            this.singleHost(xssfCell, sheetAt, sheetAtRow, widgets, maxAddRow, k, workbook, cellIndex, map, isMerge);
        }
        if (!isGroup) {
            this.removeCellRegion(sheetAt, xssfCell);
        }
    }

    private boolean matcherHost(Matcher matcher, Map<String, Object> map, JSONObject parse, List<String> groups) {
        boolean isMerge = false;
        while (matcher.find()) {
            String[] split;
            String group = matcher.group();
            groups.add(group);
            int startIndex = group.indexOf(35) + 1;
            int endIndex = group.indexOf(125);
            String result = group.substring(startIndex, endIndex);
            if (result.contains(SPLIT_LINE) && HussarUtils.equals((Object)(split = result.split("\\|"))[1], (Object)MERGE_KEY)) {
                isMerge = true;
            }
            if (result.contains(SEPARATION)) continue;
            if (result.contains(SPLIT_LINE)) {
                split = result.split("\\|");
                result = split[0];
            }
            map.put(group, parse.get((Object)result));
        }
        return isMerge;
    }

    private void multiHost(XSSFCell xssfCell, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, int maxAddRow, int k, XSSFWorkbook workbook, int cellIndex, Map<String, Object> map, boolean isMerge, String text) {
        for (int i = 0; i < maxAddRow; ++i) {
            XSSFRow tableRow = sheetAt.getRow(k + i + 1);
            XSSFCell tableCell = tableRow.getCell(cellIndex);
            this.replaceCell(tableCell, xssfCell, map, widgets, workbook, sheetAt, sheetAtRow, tableRow, tableRow.getRowNum(), cellIndex);
        }
        if (isMerge) {
            LOGGER.info("-------\u5408\u5e76\u5355\u5143\u683c,\u6a21\u677f\uff1a{},\u8d77\u59cb\u884c\uff1a{},\u7ed3\u675f\u884c\uff1a{},\u8d77\u59cb\u5217\uff1a{},\u7ed3\u675f\u5217\uff1a{}", (Object)text, (Object)(k + 1), (Object)(k + maxAddRow), (Object)cellIndex, (Object)cellIndex);
            if (maxAddRow > 1) {
                sheetAt.addMergedRegion(new CellRangeAddress(k + 1, k + maxAddRow, cellIndex, cellIndex));
            }
        }
    }

    private void singleHost(XSSFCell xssfCell, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, int maxAddRow, int k, XSSFWorkbook workbook, int cellIndex, Map<String, Object> map, boolean isMerge) {
        int insertNum = k + ++maxAddRow;
        this.moveShapes(sheetAt, insertNum, 1);
        if (sheetAt.getRow(insertNum) != null) {
            int lastRowNo = sheetAt.getLastRowNum();
            sheetAt.shiftRows(insertNum, lastRowNo, 1, true, false);
        }
        this.handleHostMerge(sheetAt, sheetAtRow.getRowNum());
        XSSFRow tableRow = sheetAt.createRow(insertNum);
        this.newRowAddCell(sheetAtRow, tableRow, sheetAt);
        XSSFCell tableCell = tableRow.getCell(cellIndex);
        this.replaceCell(tableCell, xssfCell, map, widgets, workbook, sheetAt, sheetAtRow, tableRow, tableRow.getRowNum(), cellIndex);
    }

    private int sunCellHandleUnion(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<Integer, List<XSSFCell>> cellLevelMap, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap, List<String> childList, boolean isGroup) {
        List<XSSFCell> granXwpfTableCells = cellLevelMap.get(CellLevel.SUN.getLevel());
        ArrayList<XSSFCell> granUnionXwpfTableCells = new ArrayList<XSSFCell>();
        for (XSSFCell xssfCell : granXwpfTableCells) {
            String stringCellValue = xssfCell.getStringCellValue();
            if (!stringCellValue.contains(UNION)) continue;
            granUnionXwpfTableCells.add(xssfCell);
        }
        granXwpfTableCells.removeAll(granUnionXwpfTableCells);
        maxAddRow = this.granNoUnion(workbook, sheetAt, sheetAtRow, widgets, granMap, granToChildMap, parse, maxAddRow, k, childRowNumMap, childList, granXwpfTableCells);
        maxAddRow = this.granUnion(workbook, sheetAt, sheetAtRow, widgets, granMap, granToChildMap, parse, maxAddRow, k, childList, granUnionXwpfTableCells);
        granXwpfTableCells.addAll(granUnionXwpfTableCells);
        return maxAddRow;
    }

    private int granNoUnion(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap, List<String> childList, List<XSSFCell> granXwpfTableCells) {
        for (XSSFCell xssfCell : granXwpfTableCells) {
            int cellIndex = xssfCell.getColumnIndex();
            String text = xssfCell.getStringCellValue();
            Matcher matcher = this.wordHandle.matcher(text);
            SunStr sunStr = new SunStr();
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            ArrayList<String> groups = new ArrayList<String>();
            JSONArray childArray = this.matcherSun(matcher, groups, granMap, granToChildMap, parse, sunStr);
            int addNum = 0;
            for (Object object : childArray) {
                JSONObject childOb = (JSONObject)object;
                JSONArray granArr = (JSONArray)childOb.get((Object)sunStr.granStr);
                if (childList.contains(sunStr.childStr)) {
                    int childMaxRow = childRowNumMap.get(childOb);
                    for (int i = 0; i < childMaxRow; ++i) {
                        ++addNum;
                        if (i < granArr.size()) {
                            maxAddRow = this.sunHandleRow(workbook, sheetAt, sheetAtRow, widgets, cellIndex, maxAddRow, k, xssfCell, addNum, i, map, granArr, granMap, childOb, parse, groups);
                            continue;
                        }
                        XSSFRow row = sheetAt.getRow(k + addNum);
                        XSSFCell newRowCell = row.getCell(cellIndex);
                        this.copyCellStyle(xssfCell, newRowCell, sheetAtRow, row, sheetAt);
                    }
                    continue;
                }
                maxAddRow = this.sunNoChild(childArray, workbook, sheetAt, sheetAtRow, widgets, granMap, parse, maxAddRow, k, addNum, groups, map, childOb, xssfCell, cellIndex);
            }
        }
        return maxAddRow;
    }

    private int sunNoChild(JSONArray granArr, XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, JSONObject parse, int maxAddRow, int k, int addNum, List<String> groups, Map<String, Object> map, JSONObject childOb, XSSFCell xssfCell, int cellIndex) {
        for (Object o : granArr) {
            JSONObject granJsonObj = (JSONObject)o;
            this.wordHandle.getValueByGroups(groups, map, granMap, granJsonObj, childOb, parse);
            maxAddRow = this.replaceCellComposite(maxAddRow, ++addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
        }
        return maxAddRow;
    }

    private int sunHandleRow(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, int cellIndex, int maxAddRow, int k, XSSFCell xssfCell, int addNum, int i, Map<String, Object> map, JSONArray granArr, JSONObject granMap, JSONObject childOb, JSONObject parse, List<String> groups) {
        JSONObject granJsonObj = (JSONObject)granArr.get(i);
        this.wordHandle.getValueByGroups(groups, map, granMap, granJsonObj, childOb, parse);
        XSSFRow row = sheetAt.getRow(k + addNum);
        if (HussarUtils.isNotEmpty((Object)row)) {
            XSSFCell newRowCell = row.getCell(cellIndex);
            if (HussarUtils.isNotEmpty((Object)xssfCell)) {
                this.replaceCell(newRowCell, xssfCell, map, widgets, workbook, sheetAt, sheetAtRow, row, row.getRowNum(), cellIndex);
            }
        } else {
            maxAddRow = this.replaceCellComposite(maxAddRow, addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
        }
        return maxAddRow;
    }

    private JSONArray matcherSun(Matcher matcher, List<String> groups, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, SunStr sunStr) {
        JSONArray childArray = new JSONArray();
        while (matcher.find()) {
            String[] split;
            String split0;
            int endIndex;
            String group = matcher.group();
            groups.add(group);
            int startIndex = group.indexOf(35) + 1;
            String result = group.substring(startIndex, endIndex = group.indexOf(125));
            if (!result.contains(SEPARATION) || !HussarUtils.isNotEmpty((Object)granMap.get((Object)(split0 = (split = result.split(MATCHER_SEPARATION))[0])))) continue;
            sunStr.granStr = split0;
            sunStr.childStr = (String)granMap.get((Object)split0);
            granToChildMap.put(sunStr.childStr, sunStr.granStr);
            Object childO = parse.get((Object)sunStr.childStr);
            childArray = (JSONArray)childO;
        }
        return childArray;
    }

    private int granUnion(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, List<String> childList, List<XSSFCell> granUnionXwpfTableCells) {
        boolean isAdd = false;
        for (XSSFCell xssfCell : granUnionXwpfTableCells) {
            int cellIndex = xssfCell.getColumnIndex();
            String text = xssfCell.getStringCellValue();
            Matcher matcher = this.wordHandle.matcher(text);
            SunStr sunStr = new SunStr();
            JSONArray childArray = new JSONArray();
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            ArrayList<String> groups = new ArrayList<String>();
            while (matcher.find()) {
                String[] split;
                String split0;
                int endIndex;
                String group = matcher.group();
                groups.add(group);
                int startIndex = group.indexOf(35) + 1;
                String result = group.substring(startIndex, endIndex = group.indexOf(125));
                if (!result.contains(SEPARATION) || !HussarUtils.isNotEmpty((Object)granMap.get((Object)(split0 = (split = result.split(MATCHER_SEPARATION))[0])))) continue;
                sunStr.granStr = split0;
                sunStr.childStr = (String)granMap.get((Object)split0);
                granToChildMap.put(sunStr.childStr, sunStr.granStr);
                Object childO = parse.get((Object)sunStr.childStr);
                childArray = (JSONArray)childO;
            }
            String stringCellValue = xssfCell.getStringCellValue();
            maxAddRow = this.granUnionDetails(workbook, sheetAt, sheetAtRow, widgets, granMap, map, parse, maxAddRow, k, childList, groups, childArray, sunStr, isAdd, xssfCell, cellIndex, stringCellValue);
            isAdd = true;
        }
        return maxAddRow;
    }

    private int granUnionDetails(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, Object> map, JSONObject parse, int maxAddRow, int k, List<String> childList, List<String> groups, JSONArray childArray, SunStr sunStr, boolean isAdd, XSSFCell xssfCell, int cellIndex, String stringCellValue) {
        int addNum = 0;
        int mergeAddNum = 0;
        for (Object object : childArray) {
            JSONObject childOb = (JSONObject)object;
            JSONArray granArr = (JSONArray)childOb.get((Object)sunStr.granStr);
            if (childList.contains(sunStr.childStr)) {
                addNum = mergeAddNum;
                this.granArrHandle(workbook, sheetAt, sheetAtRow, widgets, granMap, map, parse, k, addNum, groups, xssfCell, cellIndex, stringCellValue, childOb, granArr);
            } else {
                addNum = mergeAddNum;
                if (!isAdd) {
                    maxAddRow = this.granHandleOne(workbook, sheetAt, sheetAtRow, maxAddRow, widgets, granMap, map, parse, k, addNum, groups, xssfCell, cellIndex, stringCellValue, childOb, granArr);
                } else {
                    this.granHandleTwo(workbook, sheetAt, sheetAtRow, widgets, granMap, map, parse, k, addNum, groups, xssfCell, cellIndex, stringCellValue, childOb, granArr);
                }
            }
            xssfCell.setCellValue(stringCellValue);
            if (granArr.size() > 1) {
                int firstRow = k + 1 + addNum;
                CellRangeAddress cellAddresses = new CellRangeAddress(firstRow, firstRow + granArr.size() - 1, xssfCell.getColumnIndex(), xssfCell.getColumnIndex());
                mergeAddNum += granArr.size();
                sheetAt.addMergedRegion(cellAddresses);
                continue;
            }
            ++mergeAddNum;
        }
        return maxAddRow;
    }

    private int granHandleOne(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, int maxAddRow, Map<String, String> widgets, JSONObject granMap, Map<String, Object> map, JSONObject parse, int k, int addNum, List<String> groups, XSSFCell xssfCell, int cellIndex, String stringCellValue, JSONObject childOb, JSONArray granArr) {
        int insertNum = k + addNum + 1;
        this.moveShapes(sheetAt, insertNum, 1);
        if (sheetAt.getRow(insertNum) != null) {
            int lastRowNo = sheetAt.getLastRowNum();
            sheetAt.shiftRows(insertNum, lastRowNo, 1, true, false);
        }
        this.handleHostMerge(sheetAt, sheetAtRow.getRowNum());
        XSSFRow newRow = sheetAt.createRow(insertNum);
        ++maxAddRow;
        this.newRowAddCell(sheetAtRow, newRow, sheetAt);
        XSSFCell newRowCell = newRow.getCell(cellIndex);
        for (Object obj : granArr) {
            XSSFCellStyle cellStyle;
            JSONObject granObj = (JSONObject)obj;
            this.wordHandle.getValueByGroups(groups, map, granMap, granObj, childOb, parse);
            if (HussarUtils.isNotEmpty((Object)xssfCell)) {
                this.replaceCell(newRowCell, xssfCell, map, widgets, workbook, sheetAt, sheetAtRow, newRow, newRow.getRowNum(), cellIndex);
            }
            if (HussarUtils.isEmpty((Object)(cellStyle = newRowCell.getCellStyle()))) {
                cellStyle = workbook.createCellStyle();
            }
            cellStyle.setWrapText(true);
            if (HussarUtils.isNotEmpty((Object)newRowCell.getStringCellValue()) && granArr.indexOf((Object)granObj) != granArr.size() - 1) {
                xssfCell.setCellValue(newRowCell.getStringCellValue() + "\n" + stringCellValue);
            }
            this.setCellWidth(newRowCell.getStringCellValue(), sheetAt, newRowCell, cellIndex);
        }
        return maxAddRow;
    }

    private void granHandleTwo(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, Object> map, JSONObject parse, int k, int addNum, List<String> groups, XSSFCell xssfCell, int cellIndex, String stringCellValue, JSONObject childOb, JSONArray granArr) {
        XSSFRow row = sheetAt.getRow(k + addNum + 1);
        for (Object obj : granArr) {
            XSSFCellStyle cellStyle;
            JSONObject granObj = (JSONObject)obj;
            this.wordHandle.getValueByGroups(groups, map, granMap, granObj, childOb, parse);
            XSSFCell newRowCell = row.getCell(cellIndex);
            if (HussarUtils.isNotEmpty((Object)xssfCell)) {
                this.replaceCell(newRowCell, xssfCell, map, widgets, workbook, sheetAt, sheetAtRow, row, row.getRowNum(), cellIndex);
            }
            if (HussarUtils.isEmpty((Object)(cellStyle = newRowCell.getCellStyle()))) {
                cellStyle = workbook.createCellStyle();
            }
            cellStyle.setWrapText(true);
            if (HussarUtils.isNotEmpty((Object)newRowCell.getStringCellValue()) && granArr.indexOf((Object)granObj) != granArr.size() - 1) {
                xssfCell.setCellValue(newRowCell.getStringCellValue() + "\n" + stringCellValue);
            }
            this.setCellWidth(newRowCell.getStringCellValue(), sheetAt, newRowCell, cellIndex);
        }
    }

    private void granArrHandle(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, Object> map, JSONObject parse, int k, int addNum, List<String> groups, XSSFCell xssfCell, int cellIndex, String stringCellValue, JSONObject childOb, JSONArray granArr) {
        XSSFRow row = sheetAt.getRow(k + addNum + 1);
        for (Object obj : granArr) {
            XSSFCellStyle cellStyle;
            JSONObject granObj = (JSONObject)obj;
            this.wordHandle.getValueByGroups(groups, map, granMap, granObj, childOb, parse);
            XSSFCell newRowCell = row.getCell(cellIndex);
            if (HussarUtils.isNotEmpty((Object)xssfCell)) {
                this.replaceCell(newRowCell, xssfCell, map, widgets, workbook, sheetAt, sheetAtRow, row, row.getRowNum(), cellIndex);
            }
            if (HussarUtils.isEmpty((Object)(cellStyle = newRowCell.getCellStyle()))) {
                cellStyle = workbook.createCellStyle();
            }
            cellStyle.setWrapText(true);
            if (HussarUtils.isNotEmpty((Object)newRowCell.getStringCellValue()) && granArr.indexOf((Object)granObj) != granArr.size() - 1) {
                xssfCell.setCellValue(newRowCell.getStringCellValue() + "\n" + stringCellValue);
            }
            this.setCellWidth(newRowCell.getStringCellValue(), sheetAt, newRowCell, cellIndex);
        }
    }

    private int sunCellHandle(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<Integer, List<XSSFCell>> cellLevelMap, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap, List<String> childList, boolean isGroup) {
        List<XSSFCell> granXwpfTableCells = cellLevelMap.get(CellLevel.SUN.getLevel());
        boolean union = this.matcherUnion(granXwpfTableCells);
        if (union) {
            return this.sunCellHandleUnion(workbook, sheetAt, cellLevelMap, sheetAtRow, widgets, granMap, granToChildMap, parse, maxAddRow, k, childRowNumMap, childList, isGroup);
        }
        for (XSSFCell xssfCell : granXwpfTableCells) {
            int cellIndex = xssfCell.getColumnIndex();
            String text = xssfCell.getStringCellValue();
            Matcher matcher = this.wordHandle.matcher(text);
            SunStr sunStr = new SunStr();
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            ArrayList<String> groups = new ArrayList<String>();
            JSONArray childArray = this.matcherSun(matcher, groups, granMap, granToChildMap, parse, sunStr);
            maxAddRow = this.sunNoUnion(workbook, sheetAt, sheetAtRow, widgets, granMap, parse, maxAddRow, k, childRowNumMap, childList, childArray, sunStr, groups, map, xssfCell, cellIndex);
        }
        return maxAddRow;
    }

    private int sunNoUnion(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap, List<String> childList, JSONArray childArray, SunStr sunStr, List<String> groups, Map<String, Object> map, XSSFCell xssfCell, int cellIndex) {
        int addNum = 0;
        for (Object object : childArray) {
            JSONObject granJsonObj;
            JSONObject childOb = (JSONObject)object;
            JSONArray granArr = (JSONArray)childOb.get((Object)sunStr.granStr);
            if (childList.contains(sunStr.childStr)) {
                int childMaxRow = childRowNumMap.get(childOb);
                for (int i = 0; i < childMaxRow; ++i) {
                    ++addNum;
                    if (i < granArr.size()) {
                        granJsonObj = (JSONObject)granArr.get(i);
                        this.wordHandle.getValueByGroups(groups, map, granMap, granJsonObj, childOb, parse);
                        XSSFRow row = sheetAt.getRow(k + addNum);
                        if (HussarUtils.isNotEmpty((Object)row)) {
                            XSSFCell newRowCell = row.getCell(cellIndex);
                            if (!HussarUtils.isNotEmpty((Object)xssfCell)) continue;
                            this.replaceCell(newRowCell, xssfCell, map, widgets, workbook, sheetAt, sheetAtRow, row, row.getRowNum(), cellIndex);
                            continue;
                        }
                        maxAddRow = this.replaceCellComposite(maxAddRow, addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
                        continue;
                    }
                    XSSFRow row = sheetAt.getRow(k + addNum);
                    XSSFCell newRowCell = row.getCell(cellIndex);
                    this.copyCellStyle(xssfCell, newRowCell, sheetAtRow, row, sheetAt);
                }
                continue;
            }
            for (Object o : granArr) {
                granJsonObj = (JSONObject)o;
                this.wordHandle.getValueByGroups(groups, map, granMap, granJsonObj, childOb, parse);
                maxAddRow = this.replaceCellComposite(maxAddRow, ++addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
            }
        }
        return maxAddRow;
    }

    private boolean matcherUnion(List<XSSFCell> granXwpfTableCells) {
        boolean union = false;
        for (XSSFCell cell : granXwpfTableCells) {
            String text = cell.getStringCellValue();
            Matcher matcher = this.wordHandle.matcher(text);
            while (matcher.find()) {
                String[] unions;
                String[] split;
                String last;
                int endIndex;
                int startIndex;
                String group = matcher.group();
                String result = group.substring(startIndex = group.indexOf(35) + 1, endIndex = group.indexOf(125));
                if (!result.contains(SEPARATION) || !(last = (split = result.split(MATCHER_SEPARATION))[split.length - 1]).contains(SPLIT_LINE) || !(unions = last.split("\\|"))[unions.length - 1].equals("union")) continue;
                union = true;
            }
        }
        return union;
    }

    private int childCellHandle(XSSFWorkbook workbook, XSSFSheet sheetAt, Map<Integer, List<XSSFCell>> cellLevelMap, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap) {
        ArrayList<XSSFCell> mergeCells = new ArrayList<XSSFCell>();
        ArrayList<String> mergeList = new ArrayList<String>();
        List<XSSFCell> childXwpfTableCells = cellLevelMap.get(CellLevel.CHILD.getLevel());
        HashMap<XSSFCell, JSONArray> childCellToData = new HashMap<XSSFCell, JSONArray>(10);
        this.findMergeCell(childXwpfTableCells, mergeList, mergeCells);
        MaxAdd maxAdd = new MaxAdd(maxAddRow, 0);
        this.childHandleOne(workbook, sheetAt, mergeList, sheetAtRow, widgets, granMap, granToChildMap, parse, maxAddRow, k, childRowNumMap, childXwpfTableCells, maxAdd, childCellToData);
        this.childHandleTwo(sheetAt, cellLevelMap, k, mergeCells, childRowNumMap, childXwpfTableCells, maxAdd, childCellToData);
        return maxAdd.maxAddRow;
    }

    private void childHandleOne(XSSFWorkbook workbook, XSSFSheet sheetAt, List<String> mergeList, XSSFRow sheetAtRow, Map<String, String> widgets, JSONObject granMap, Map<String, String> granToChildMap, JSONObject parse, int maxAddRow, int k, Map<JSONObject, Integer> childRowNumMap, List<XSSFCell> childXwpfTableCells, MaxAdd maxAdd, Map<XSSFCell, JSONArray> childCellToData) {
        int maxAddNum = maxAdd.maxAddNum;
        for (XSSFCell xssfCell : childXwpfTableCells) {
            int cellIndex = xssfCell.getColumnIndex();
            String text = xssfCell.getStringCellValue();
            Matcher matcher = this.wordHandle.matcher(text);
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            ArrayList<String> groups = new ArrayList<String>();
            SunStr sunStr = new SunStr();
            JSONArray childArray = this.childHandleTri(matcher, groups, sunStr, parse, granMap);
            int addNum = 0;
            JSONArray newChildArray = new JSONArray();
            this.mergeData(childArray, mergeList, newChildArray);
            childCellToData.put(xssfCell, newChildArray);
            for (Object child : newChildArray) {
                JSONObject childObj = (JSONObject)child;
                JSONObject newChildObj = JSON.parseObject((String)JSON.toJSONString((Object)childObj));
                newChildObj.put(INDEX, (Object)(newChildArray.indexOf((Object)childObj) + 1));
                newChildObj.put(GROUP_COUNT_KEY, (Object)"");
                newChildObj.put(GROUP_INDEX_KEY, (Object)"");
                this.wordHandle.getValueByGroups(groups, map, granMap, null, newChildObj, parse);
                if (granToChildMap.containsKey(sunStr.childStr)) {
                    int maxChildRow = childRowNumMap.get(childObj);
                    for (int i = 0; i < maxChildRow; ++i) {
                        maxAddRow = this.replaceCellComposite(maxAddRow, ++addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
                    }
                    continue;
                }
                maxAddRow = this.replaceCellComposite(maxAddRow, ++addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
            }
            this.removeCellRegion(sheetAt, xssfCell);
            maxAddNum = Math.max(maxAddNum, addNum);
        }
        maxAdd.maxAddNum = maxAddNum;
        maxAdd.maxAddRow = maxAddRow;
    }

    private void childHandleTwo(XSSFSheet sheetAt, Map<Integer, List<XSSFCell>> cellLevelMap, int k, List<XSSFCell> mergeCells, Map<JSONObject, Integer> childRowNumMap, List<XSSFCell> childXwpfTableCells, MaxAdd maxAdd, Map<XSSFCell, JSONArray> childCellToData) {
        if (HussarUtils.isNotEmpty(cellLevelMap.get(2))) {
            ArrayList<XSSFCell> childMergeCells = new ArrayList<XSSFCell>();
            for (XSSFCell cell : childXwpfTableCells) {
                if (mergeCells.contains(cell)) continue;
                childMergeCells.add(cell);
            }
            this.mergeRegionCell(mergeCells, k, maxAdd.maxAddNum, sheetAt, false, null, null);
            this.mergeRegionCell(childMergeCells, k, maxAdd.maxAddNum, sheetAt, true, childCellToData, childRowNumMap);
        } else {
            this.mergeRegionCell(mergeCells, k, maxAdd.maxAddNum, sheetAt, false, null, null);
        }
    }

    private JSONArray childHandleTri(Matcher matcher, List<String> groups, SunStr sunStr, JSONObject parse, JSONObject granMap) {
        JSONArray childArray = new JSONArray();
        while (matcher.find()) {
            String[] split;
            String split0;
            int endIndex;
            String group = matcher.group();
            groups.add(group);
            int startIndex = group.indexOf(35) + 1;
            String result = group.substring(startIndex, endIndex = group.indexOf(125));
            if (!result.contains(SEPARATION) || !HussarUtils.isEmpty((Object)granMap.get((Object)(split0 = (split = result.split(MATCHER_SEPARATION))[0])))) continue;
            sunStr.childStr = split0;
            Object childO = parse.get((Object)sunStr.childStr);
            childArray = (JSONArray)childO;
        }
        return childArray;
    }

    private String getCellValueString(XSSFCell xssfCell) {
        String text = "";
        CellType cellType = xssfCell.getCellType();
        switch (cellType) {
            case STRING: {
                text = xssfCell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                text = String.valueOf(xssfCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                text = String.valueOf(xssfCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                text = xssfCell.getCellFormula();
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                text = xssfCell.getStringCellValue();
            }
        }
        return text;
    }

    private Object getCellValueObject(XSSFCell xssfCell) {
        Object text = "";
        CellType cellType = xssfCell.getCellType();
        switch (cellType) {
            case STRING: {
                text = xssfCell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                text = xssfCell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                text = xssfCell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                text = xssfCell.getCellFormula();
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                text = xssfCell.getStringCellValue();
            }
        }
        return text;
    }

    private void handleGroupRow(XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, List<String> groupList, JSONObject granMap, JSONObject parse, Map<String, String> widgets, Map<String, JSONArray> newChildArrayMap, Map<Integer, List<XSSFCell>> cellLevelMap, int k, int maxAddRow, Map<String, String> granToChildMap, Map<JSONObject, Integer> childRowNumMap, List<String> childList) {
        int rowNum = sheetAtRow.getRowNum();
        XSSFRow groupRow = sheetAt.getRow(rowNum - 1);
        int lastCellNum = groupRow.getLastCellNum();
        GroupInfo groupInfo = this.parseGroupRow(groupRow, lastCellNum, groupList, parse, granMap);
        this.groupData(groupInfo.childArrayAll, groupList, newChildArrayMap);
        List<XSSFCell> childXwpfTableCells = cellLevelMap.get(CellLevel.CHILD.getLevel());
        List<XSSFCell> hostXwpfTableCells = cellLevelMap.get(CellLevel.HOST.getLevel());
        if (HussarUtils.isNotEmpty(newChildArrayMap)) {
            int keyIndex = 0;
            for (String key : newChildArrayMap.keySet()) {
                JSONArray data = newChildArrayMap.get(key);
                LOGGER.info("-------\u5904\u7406\u7b2c{}\u4e2a\u5206\u7ec4\u6570\u636e", (Object)(++keyIndex));
                maxAddRow = 0;
                LOGGER.info("-------\u5f00\u59cb\u5904\u7406\u7b2c{}\u4e2a\u5206\u7ec4\u6a21\u677f\u884c", (Object)keyIndex);
                Map<String, Object> groupMap = this.createGroupMap(groupInfo, key, keyIndex, data.size());
                for (int i = 0; i < lastCellNum; ++i) {
                    XSSFCell groupRowCell = groupRow.getCell(i);
                    maxAddRow = this.replaceCellComposite(maxAddRow, 1, sheetAt, groupRow, groupRowCell, i, groupMap, widgets, k, workbook);
                }
                LOGGER.info("-------\u5904\u7406\u5b8c\u6210\u7b2c{}\u5206\u7ec4\u6a21\u677f\u884c", (Object)keyIndex);
                JSONArray childArray = newChildArrayMap.get(key);
                GroupChildData childData = this.processChildData(childArray, childXwpfTableCells, granMap, parse, granToChildMap, childRowNumMap, workbook, sheetAt, cellLevelMap, sheetAtRow, widgets, ++k, keyIndex);
                int maxAddNum = childData.maxAddRow = this.sunCellHandle(workbook, sheetAt, cellLevelMap, sheetAtRow, widgets, granMap, granToChildMap, childData.newParse, childData.maxAddRow, k, childRowNumMap, childList, true);
                this.hostCellHandle(sheetAt, cellLevelMap, sheetAtRow, widgets, parse, maxAddRow, k, workbook, true);
                LOGGER.info("-------\u5904\u7406\u5b8c\u6210\u7b2c{}\u4e2a\u5206\u7ec4\u6570\u636e\u6a21\u677f\u884c", (Object)keyIndex);
                if (HussarUtils.isNotEmpty(cellLevelMap.get(2))) {
                    ArrayList<XSSFCell> childMergeCells = new ArrayList<XSSFCell>(childXwpfTableCells);
                    childMergeCells.removeAll(childData.mergeCells);
                    this.mergeRegionCell(childData.mergeCells, k, maxAddNum, sheetAt, false, null, null);
                    this.mergeRegionCell(childMergeCells, k, maxAddNum, sheetAt, true, childData.childCellToData, childRowNumMap);
                } else {
                    this.mergeRegionCell(childData.mergeCells, k, maxAddNum, sheetAt, false, null, null);
                }
                k += maxAddNum;
            }
        }
        this.clearMergedRegions(sheetAt, childXwpfTableCells);
        this.clearMergedRegions(sheetAt, hostXwpfTableCells);
        this.removeCellRegionAll(sheetAt, lastCellNum, groupRow);
    }

    private GroupInfo parseGroupRow(XSSFRow groupRow, int lastCellNum, List<String> groupList, JSONObject parse, JSONObject granMap) {
        GroupInfo info = new GroupInfo();
        info.childArrayAll = new JSONArray();
        info.groupTextS = new ArrayList<String>();
        for (int i = 0; i < lastCellNum; ++i) {
            XSSFCell groupRowCell = groupRow.getCell(i);
            if (!HussarUtils.isNotEmpty((Object)groupRowCell) || groupRowCell.getCellType() != CellType.STRING) continue;
            String text = groupRowCell.getStringCellValue();
            Matcher matcher = this.wordHandle.matcher(text);
            while (matcher.find()) {
                String group = matcher.group();
                String result = this.extractPlaceholderContent(group);
                this.getGroupInfo(result, info, group, granMap, parse, groupList, groupRowCell, text);
            }
        }
        if (!info.groupTextS.isEmpty()) {
            info.groupText = info.groupTextS.get(0);
        }
        return info;
    }

    private void getGroupInfo(String result, GroupInfo info, String group, JSONObject granMap, JSONObject parse, List<String> groupList, XSSFCell groupRowCell, String text) {
        String[] split;
        if (result.equals(GROUP_INDEX_KEY)) {
            info.groupIndexText = group;
        }
        if (result.equals(GROUP_COUNT_KEY)) {
            info.groupCountText = group;
        }
        if (result.contains(SEPARATION) && HussarUtils.isEmpty((Object)granMap.get((Object)(split = result.split(MATCHER_SEPARATION))[0]))) {
            info.childArrayAll = (JSONArray)parse.get((Object)split[0]);
        }
        if (result.contains(SPLIT_LINE)) {
            info.groupTextS.add(group);
            split = result.split("\\|");
            this.processGroupTextPipe(groupList, groupRowCell, text, group, split);
        }
    }

    private void processGroupTextPipe(List<String> groupList, XSSFCell groupRowCell, String text, String group, String[] split) {
        if (HussarUtils.isNotEmpty((Object)split[split.length - 1]) && HussarUtils.equals((Object)split[split.length - 1], (Object)GROUP_KEY) && split[0].contains(SEPARATION)) {
            String[] strings = split[0].split(MATCHER_SEPARATION);
            if (HussarUtils.isEmpty(groupList)) {
                groupList.add(strings[1]);
            } else if (!groupList.get(0).equals(strings[1])) {
                text = text.replace(group, "");
                groupRowCell.setCellValue(text);
            }
        }
    }

    private Map<String, Object> createGroupMap(GroupInfo groupInfo, String key, int keyIndex, int dataSize) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        for (String group : groupInfo.groupTextS) {
            if (HussarUtils.equals((Object)group, (Object)groupInfo.groupText)) {
                map.put(groupInfo.groupText, key);
                continue;
            }
            map.put(group, "");
        }
        map.put(groupInfo.groupIndexText, keyIndex);
        map.put(groupInfo.groupCountText, dataSize);
        return map;
    }

    private GroupChildData processChildData(JSONArray childArray, List<XSSFCell> childXwpfTableCells, JSONObject granMap, JSONObject parse, Map<String, String> granToChildMap, Map<JSONObject, Integer> childRowNumMap, XSSFWorkbook workbook, XSSFSheet sheetAt, Map<Integer, List<XSSFCell>> cellLevelMap, XSSFRow sheetAtRow, Map<String, String> widgets, int k, int keyIndex) {
        GroupChildData data = new GroupChildData();
        data.mergeCells = new ArrayList<XSSFCell>();
        data.mergeList = new ArrayList<String>();
        data.childCellToData = new HashMap<XSSFCell, JSONArray>(10);
        data.newParse = new JSONObject();
        data.newChildArray = new JSONArray();
        data.maxAddRow = 0;
        this.findMergeCell(childXwpfTableCells, data.mergeList, data.mergeCells);
        this.mergeData(childArray, data.mergeList, data.newChildArray);
        data.newParse.put("\u4e3b\u8868", (Object)data.newChildArray);
        LOGGER.info("-------\u5f00\u59cb\u5904\u7406\u7b2c{}\u4e2a\u5206\u7ec4\u6570\u636e\u6a21\u677f\u884c", (Object)keyIndex);
        for (XSSFCell xssfCell : childXwpfTableCells) {
            data.childCellToData.put(xssfCell, data.newChildArray);
            this.processChildCell(xssfCell, data, granMap, parse, granToChildMap, childRowNumMap, workbook, sheetAt, sheetAtRow, widgets, k);
        }
        return data;
    }

    private void processChildCell(XSSFCell xssfCell, GroupChildData data, JSONObject granMap, JSONObject parse, Map<String, String> granToChildMap, Map<JSONObject, Integer> childRowNumMap, XSSFWorkbook workbook, XSSFSheet sheetAt, XSSFRow sheetAtRow, Map<String, String> widgets, int k) {
        int cellIndex = xssfCell.getColumnIndex();
        String text = xssfCell.getStringCellValue();
        Matcher matcher = this.wordHandle.matcher(text);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        ArrayList<String> groups = new ArrayList<String>();
        String childStr = this.matcherChild(matcher, groups, granMap);
        int addNum = 0;
        for (Object child : data.newChildArray) {
            JSONObject childObj = (JSONObject)child;
            JSONObject newChildObj = JSON.parseObject((String)JSON.toJSONString((Object)childObj));
            newChildObj.put(INDEX, (Object)(data.newChildArray.indexOf((Object)childObj) + 1));
            this.wordHandle.getValueByGroups(groups, map, granMap, null, newChildObj, parse);
            if (granToChildMap.containsKey(childStr)) {
                int maxChildRow = childRowNumMap.get(childObj);
                for (int i = 0; i < maxChildRow; ++i) {
                    data.maxAddRow = this.replaceCellComposite(data.maxAddRow, ++addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
                }
                continue;
            }
            data.maxAddRow = this.replaceCellComposite(data.maxAddRow, ++addNum, sheetAt, sheetAtRow, xssfCell, cellIndex, map, widgets, k, workbook);
        }
        data.maxAddNum = Math.max(data.maxAddNum, addNum);
    }

    private String matcherChild(Matcher matcher, List<String> groups, JSONObject granMap) {
        String childStr = "";
        while (matcher.find()) {
            String[] split;
            String group = matcher.group();
            groups.add(group);
            String result = this.extractPlaceholderContent(group);
            if (!result.contains(SEPARATION) || !HussarUtils.isEmpty((Object)granMap.get((Object)(split = result.split(MATCHER_SEPARATION))[0]))) continue;
            childStr = split[0];
        }
        return childStr;
    }

    private String extractPlaceholderContent(String group) {
        int startIndex = group.indexOf(35) + 1;
        int endIndex = group.indexOf(125);
        return group.substring(startIndex, endIndex);
    }

    private void clearMergedRegions(XSSFSheet sheet, List<XSSFCell> cells) {
        for (XSSFCell cell : cells) {
            this.removeCellRegion(sheet, cell);
        }
    }

    private void removeCellRegionAll(XSSFSheet sheetAt, int lastCellNum, XSSFRow groupRow) {
        for (int i = 0; i < lastCellNum; ++i) {
            this.removeCellRegion(sheetAt, groupRow.getCell(i));
        }
    }

    private void removeCellRegion(XSSFSheet sheetAt, XSSFCell xssfCell) {
        CellRangeAddress sourceRegion = this.findMergedRegionContainingCell((Sheet)sheetAt, (Cell)xssfCell);
        if (sourceRegion != null && sourceRegion.getFirstRow() == sourceRegion.getLastRow()) {
            sheetAt.removeMergedRegion(sheetAt.getMergedRegions().indexOf(sourceRegion));
        }
    }

    private void groupData(JSONArray childArray, List<String> groupList, Map<String, JSONArray> newChildArrayMap) {
        if (HussarUtils.isNotEmpty(groupList)) {
            Map<String, List<JSONObject>> groupedData = childArray.stream().map(obj -> (JSONObject)obj).collect(Collectors.groupingBy(item -> item.getString((String)groupList.get(0))));
            for (String key : groupedData.keySet()) {
                List<JSONObject> jsonObjects = groupedData.get(key);
                JSONArray jsonArray = new JSONArray();
                jsonArray.addAll(jsonObjects);
                newChildArrayMap.put(key, jsonArray);
            }
        }
    }

    private void handleHostMerge(XSSFSheet sheetAt, int templateRowNum) {
        List mergedRegions = sheetAt.getMergedRegions();
        ArrayList<CellRangeAddress> skip = new ArrayList<CellRangeAddress>();
        for (CellRangeAddress cellAddresses : mergedRegions) {
            int firstRow = cellAddresses.getFirstRow();
            int lastRow = cellAddresses.getLastRow();
            if (skip.contains(cellAddresses) || firstRow > templateRowNum || lastRow < templateRowNum || firstRow == lastRow) continue;
            sheetAt.removeMergedRegion(mergedRegions.indexOf(cellAddresses));
            cellAddresses.setLastRow(lastRow + 1);
            sheetAt.addMergedRegion(cellAddresses);
            skip.add(cellAddresses);
        }
    }

    private void mergeRegionCell(List<XSSFCell> mergeCells, int k, int maxAddNum, XSSFSheet sheetAt, boolean hasGran, Map<XSSFCell, JSONArray> childCellToData, Map<JSONObject, Integer> childRowNumMap) {
        if (hasGran) {
            this.hasGranMerge(mergeCells, k, sheetAt, childCellToData, childRowNumMap);
        } else {
            this.noGranMerge(mergeCells, k, maxAddNum, sheetAt);
        }
    }

    private void hasGranMerge(List<XSSFCell> mergeCells, int k, XSSFSheet sheetAt, Map<XSSFCell, JSONArray> childCellToData, Map<JSONObject, Integer> childRowNumMap) {
        for (XSSFCell xssfCell : mergeCells) {
            VerticalAlignment verticalAlignment = xssfCell.getCellStyle().getVerticalAlignment();
            int startRowNum = k + 1;
            JSONArray jsonArray = childCellToData.get(xssfCell);
            for (Object dataItem : jsonArray) {
                Integer rowIndex = childRowNumMap.get((JSONObject)dataItem);
                int endRowNum = startRowNum + rowIndex;
                if (endRowNum > startRowNum + 1) {
                    this.processCellMerging(sheetAt, startRowNum, endRowNum, xssfCell.getColumnIndex(), verticalAlignment);
                }
                startRowNum = endRowNum;
            }
        }
    }

    private void noGranMerge(List<XSSFCell> mergeCells, int k, int maxAddNum, XSSFSheet sheetAt) {
        int startRowNum = k + 1;
        int endRowNum = startRowNum + maxAddNum;
        if (endRowNum <= startRowNum + 1) {
            return;
        }
        for (XSSFCell xssfCell : mergeCells) {
            this.processSingleCellMerging(sheetAt, xssfCell, startRowNum, endRowNum);
        }
    }

    private void processSingleCellMerging(XSSFSheet sheetAt, XSSFCell xssfCell, int startRowNum, int endRowNum) {
        VerticalAlignment verticalAlignment = xssfCell.getCellStyle().getVerticalAlignment();
        int colIndex = xssfCell.getColumnIndex();
        String prevText = "";
        int mergeStart = startRowNum;
        int mergeEnd = startRowNum;
        for (int rowNum = startRowNum; rowNum < endRowNum; ++rowNum) {
            boolean isLastRow;
            XSSFRow currentRow = sheetAt.getRow(rowNum);
            XSSFCell currentCell = currentRow.getCell(colIndex);
            if (!currentCell.getCellType().equals((Object)CellType.STRING)) continue;
            String currentText = currentCell.getStringCellValue();
            boolean isValueChanged = !prevText.equals(currentText);
            boolean isFirstRowInBlock = rowNum == startRowNum;
            boolean bl = isLastRow = rowNum == endRowNum - 1;
            if (isValueChanged && !isFirstRowInBlock || isLastRow) {
                if (isLastRow && prevText.equals(currentText)) {
                    ++mergeEnd;
                }
                this.performCellMergeOperation(sheetAt, mergeStart, mergeEnd, colIndex, verticalAlignment, rowNum);
                mergeStart = rowNum;
            }
            mergeEnd = rowNum;
            prevText = currentText;
        }
    }

    private void performCellMergeOperation(XSSFSheet sheetAt, int mergeStart, int mergeEnd, int colIndex, VerticalAlignment verticalAlignment, int currentRow) {
        if (mergeEnd <= mergeStart) {
            return;
        }
        XSSFRow previousRow = sheetAt.getRow(currentRow - 1);
        XSSFCell previousCell = previousRow.getCell(colIndex);
        CellRangeAddress existingRegion = this.findMergedRegionContainingCell((Sheet)sheetAt, (Cell)previousCell);
        if (existingRegion != null) {
            int regionIndex = sheetAt.getMergedRegions().indexOf(existingRegion);
            sheetAt.removeMergedRegion(regionIndex);
            existingRegion.setLastRow(existingRegion.getLastRow() + 1);
            sheetAt.addMergedRegion(existingRegion);
        } else {
            CellRangeAddress newRegion = new CellRangeAddress(mergeStart, mergeEnd, colIndex, colIndex);
            sheetAt.addMergedRegion(newRegion);
        }
        this.deleteImageAtCell(sheetAt, mergeStart, mergeEnd, verticalAlignment, colIndex);
    }

    private void processCellMerging(XSSFSheet sheetAt, int startRowNum, int endRowNum, int colIndex, VerticalAlignment verticalAlignment) {
        String prevText = "";
        int mergeStart = startRowNum;
        int mergeEnd = startRowNum;
        for (int currentRow = startRowNum; currentRow < endRowNum; ++currentRow) {
            boolean isLastRow;
            XSSFRow row = sheetAt.getRow(currentRow);
            XSSFCell cell = row.getCell(colIndex);
            if (cell.getCellType() != CellType.STRING) continue;
            String currentText = cell.getStringCellValue();
            boolean isValueChanged = !prevText.equals(currentText) && currentRow != startRowNum;
            boolean bl = isLastRow = currentRow == endRowNum - 1;
            if (isValueChanged || isLastRow) {
                if (isLastRow && prevText.equals(currentText)) {
                    ++mergeEnd;
                }
                if (mergeEnd > mergeStart) {
                    this.adjustMergedRegions(sheetAt, mergeStart, mergeEnd, colIndex, verticalAlignment, currentRow);
                }
                mergeStart = currentRow;
            }
            mergeEnd = currentRow;
            prevText = currentText;
        }
    }

    private void adjustMergedRegions(XSSFSheet sheetAt, int mergeStart, int mergeEnd, int colIndex, VerticalAlignment verticalAlignment, int currentRow) {
        CellRangeAddress existingRegion = this.findMergedRegionContainingCell((Sheet)sheetAt, (Cell)sheetAt.getRow(currentRow - 1).getCell(colIndex));
        if (existingRegion != null) {
            int regionIndex = sheetAt.getMergedRegions().indexOf(existingRegion);
            sheetAt.removeMergedRegion(regionIndex);
            existingRegion.setLastRow(existingRegion.getLastRow() + 1);
            sheetAt.addMergedRegion(existingRegion);
        } else {
            CellRangeAddress newRegion = new CellRangeAddress(mergeStart, mergeEnd, colIndex, colIndex);
            sheetAt.addMergedRegion(newRegion);
        }
        this.deleteImageAtCell(sheetAt, mergeStart, mergeEnd, verticalAlignment, colIndex);
    }

    private void mergeData(JSONArray childArray, List<String> mergeList, JSONArray newChildArray) {
        newChildArray.addAll((Collection)childArray);
    }

    private void findMergeCell(List<XSSFCell> childXwpfTableCells, List<String> mergeList, List<XSSFCell> mergeCells) {
        for (XSSFCell cell : childXwpfTableCells) {
            this.processCellForMergeInstructions(cell.getRichStringCellValue().toString(), mergeList, mergeCells, cell);
        }
    }

    private void processCellForMergeInstructions(String cellText, List<String> mergeList, List<XSSFCell> mergeCells, XSSFCell currentCell) {
        Matcher templateMatcher = this.wordHandle.matcher(cellText);
        while (templateMatcher.find()) {
            String placeholder = templateMatcher.group();
            this.extractMergeInstructionFromPlaceholder(placeholder, mergeList, mergeCells, currentCell);
        }
    }

    private void extractMergeInstructionFromPlaceholder(String placeholder, List<String> mergeList, List<XSSFCell> mergeCells, XSSFCell currentCell) {
        String[] instructionParts;
        String placeholderContent = this.extractPlaceholderContent(placeholder);
        if (this.isMergeInstructionPresent(placeholderContent) && this.isValidMergeInstruction(instructionParts = placeholderContent.split("\\|"))) {
            this.extractGroupName(instructionParts[0], mergeList);
            mergeCells.add(currentCell);
        }
    }

    private boolean isMergeInstructionPresent(String content) {
        return content.contains(SPLIT_LINE);
    }

    private boolean isValidMergeInstruction(String[] instructionParts) {
        int lastIndex = instructionParts.length - 1;
        return HussarUtils.isNotEmpty((Object)instructionParts[lastIndex]) && HussarUtils.equals((Object)instructionParts[lastIndex], (Object)MERGE_KEY);
    }

    private void extractGroupName(String groupPath, List<String> mergeList) {
        if (groupPath.contains(SEPARATION)) {
            String[] pathParts = groupPath.split(MATCHER_SEPARATION);
            mergeList.add(pathParts[1]);
        }
    }

    private int replaceCellComposite(int maxAddRow, int addNum, XSSFSheet xssfSheet, XSSFRow xssfRow, XSSFCell xssfCell, int cellIndex, Map<String, Object> map, Map<String, String> widgets, int k, XSSFWorkbook workbook) {
        XSSFRow newRow;
        if (maxAddRow >= addNum) {
            newRow = xssfSheet.getRow(k + addNum);
        } else {
            int insertNum = k + addNum;
            this.moveShapes(xssfSheet, insertNum, 1);
            if (xssfSheet.getRow(insertNum) != null) {
                int lastRowNo = xssfSheet.getLastRowNum();
                xssfSheet.shiftRows(insertNum, lastRowNo, 1, true, false);
            }
            this.handleHostMerge(xssfSheet, xssfRow.getRowNum());
            newRow = xssfSheet.createRow(insertNum);
            ++maxAddRow;
            this.newRowAddCell(xssfRow, newRow, xssfSheet);
        }
        XSSFCell newRowCell = newRow.getCell(cellIndex);
        if (HussarUtils.isNotEmpty((Object)xssfCell)) {
            this.replaceCell(newRowCell, xssfCell, map, widgets, workbook, xssfSheet, xssfRow, newRow, newRow.getRowNum(), cellIndex);
        }
        return maxAddRow;
    }

    private void replaceCell(XSSFCell newCell, XSSFCell sourceCell, Map<String, Object> map, Map<String, String> widgets, XSSFWorkbook workbook, XSSFSheet xssfSheet, XSSFRow xssfRow, XSSFRow newRow, int rowIndex, int cellIndex) {
        this.copyCellStyle(sourceCell, newCell, xssfRow, newRow, xssfSheet);
        Object stringCellValue = this.getCellValueObject(sourceCell);
        this.replaceStringCell(stringCellValue, map, widgets, sourceCell, newCell, workbook, xssfSheet, newRow, rowIndex, cellIndex);
    }

    private void copyCellStyle(XSSFCell sourceCell, XSSFCell newCell, XSSFRow sourceRow, XSSFRow newRow, XSSFSheet sourceSheet) {
        XSSFCellStyle sourceStyle = sourceCell.getCellStyle();
        this.processMergedRegionIfNeeded(sourceSheet, sourceCell, newCell, sourceStyle, newRow);
        newCell.setCellStyle((CellStyle)sourceStyle);
        this.copyRowHeight(sourceRow, newRow);
        newCell.setCellType(sourceCell.getCellType());
    }

    private void processMergedRegionIfNeeded(XSSFSheet sourceSheet, XSSFCell sourceCell, XSSFCell newCell, XSSFCellStyle sourceStyle, XSSFRow newRow) {
        CellRangeAddress sourceRegion = this.findMergedRegionContainingCell((Sheet)sourceSheet, (Cell)sourceCell);
        if (sourceRegion == null) {
            return;
        }
        CellRangeAddress existingNewRegion = this.findMergedRegionContainingCell((Sheet)sourceSheet, (Cell)newCell);
        if (existingNewRegion != null) {
            return;
        }
        this.createTargetMergedRegion(sourceSheet, sourceRegion, newCell, newRow, sourceStyle);
    }

    private void createTargetMergedRegion(XSSFSheet sourceSheet, CellRangeAddress sourceRegion, XSSFCell newCell, XSSFRow newRow, XSSFCellStyle sourceStyle) {
        int rowSpan = sourceRegion.getLastRow() - sourceRegion.getFirstRow();
        int colSpan = sourceRegion.getLastColumn() - sourceRegion.getFirstColumn();
        CellRangeAddress targetRegion = new CellRangeAddress(newRow.getRowNum(), newRow.getRowNum() + rowSpan, newCell.getColumnIndex(), newCell.getColumnIndex() + colSpan);
        this.clearCellStylesInRegion(sourceSheet, targetRegion, newCell);
        sourceSheet.addMergedRegion(targetRegion);
        this.applyRegionBorders(sourceSheet, targetRegion, sourceStyle);
    }

    private void clearCellStylesInRegion(XSSFSheet sourceSheet, CellRangeAddress targetRegion, XSSFCell keepCell) {
        for (int r = targetRegion.getFirstRow(); r <= targetRegion.getLastRow(); ++r) {
            XSSFRow row = sourceSheet.getRow(r);
            if (row == null) continue;
            for (int c = targetRegion.getFirstColumn(); c <= targetRegion.getLastColumn(); ++c) {
                Cell cell;
                if (r == targetRegion.getFirstRow() && c == targetRegion.getFirstColumn() || (cell = row.getCell(c)) == null) continue;
                cell.setCellStyle(null);
            }
        }
    }

    private void applyRegionBorders(XSSFSheet sourceSheet, CellRangeAddress targetRegion, XSSFCellStyle sourceStyle) {
        BorderStyle borderBottom = sourceStyle.getBorderBottom();
        BorderStyle borderLeft = sourceStyle.getBorderLeft();
        BorderStyle borderTop = sourceStyle.getBorderTop();
        BorderStyle borderRight = sourceStyle.getBorderRight();
        short topBorderColor = sourceStyle.getTopBorderColor();
        short bottomBorderColor = sourceStyle.getBottomBorderColor();
        short leftBorderColor = sourceStyle.getLeftBorderColor();
        short rightBorderColor = sourceStyle.getRightBorderColor();
        RegionUtil.setBorderBottom((BorderStyle)borderBottom, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
        RegionUtil.setBorderLeft((BorderStyle)borderLeft, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
        RegionUtil.setBorderRight((BorderStyle)borderRight, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
        RegionUtil.setBorderTop((BorderStyle)borderTop, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
        RegionUtil.setLeftBorderColor((int)leftBorderColor, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
        RegionUtil.setBottomBorderColor((int)bottomBorderColor, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
        RegionUtil.setRightBorderColor((int)rightBorderColor, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
        RegionUtil.setTopBorderColor((int)topBorderColor, (CellRangeAddress)targetRegion, (Sheet)sourceSheet);
    }

    private void copyRowHeight(XSSFRow sourceRow, XSSFRow newRow) {
        float sourceHeight = sourceRow.getHeightInPoints();
        float currentHeight = newRow.getHeightInPoints();
        if (currentHeight < sourceHeight) {
            newRow.setHeightInPoints(sourceHeight);
        }
    }

    private CellRangeAddress findMergedRegionContainingCell(Sheet sheet, Cell cell) {
        if (HussarUtils.isNotEmpty((Object)cell)) {
            for (CellRangeAddress region : sheet.getMergedRegions()) {
                if (!region.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
                return region;
            }
        }
        return null;
    }

    private void newRowAddCell(XSSFRow xssfRow, XSSFRow newRow, XSSFSheet xssfSheet) {
        int size = xssfRow.getLastCellNum();
        while (newRow.getLastCellNum() != size) {
            newRow.createCell(newRow.getLastCellNum() == -1 ? newRow.getLastCellNum() + 1 : newRow.getLastCellNum());
        }
        for (int i = 0; i < size; ++i) {
            XSSFCell cell = xssfRow.getCell(i);
            XSSFCell newRowCell = newRow.getCell(i);
            if (!HussarUtils.isNotEmpty((Object)cell) || !HussarUtils.isNotEmpty((Object)newRowCell)) continue;
            this.copyCellStyle(cell, newRowCell, xssfRow, newRow, xssfSheet);
        }
    }

    private void getChildMaxRow(XSSFRow sheetAtRow, Map<JSONObject, Integer> childRowNumMap, Map<String, String> granToChildMap, JSONObject granMap, JSONObject parse, List<String> childList) {
        HashMap<String, List<String>> childGranMap = new HashMap<String, List<String>>(10);
        JSONArray unionGranArray = new JSONArray();
        this.processRowCells(sheetAtRow, childGranMap, granToChildMap, granMap, childList, unionGranArray);
        this.calculateMaxRowsForChildren(childGranMap, parse, childRowNumMap);
    }

    private void processRowCells(XSSFRow sheetAtRow, Map<String, List<String>> childGranMap, Map<String, String> granToChildMap, JSONObject granMap, List<String> childList, JSONArray unionGranArray) {
        for (int cellIndex = 0; cellIndex < sheetAtRow.getLastCellNum(); ++cellIndex) {
            XSSFCell currentCell = sheetAtRow.getCell(cellIndex);
            if (HussarUtils.isEmpty((Object)currentCell) || !currentCell.getCellType().equals((Object)CellType.STRING)) continue;
            this.processCellContent(currentCell.getStringCellValue(), childGranMap, granToChildMap, granMap, childList, unionGranArray);
        }
    }

    private void processCellContent(String cellText, Map<String, List<String>> childGranMap, Map<String, String> granToChildMap, JSONObject granMap, List<String> childList, JSONArray unionGranArray) {
        Matcher placeholderMatcher = this.wordHandle.matcher(cellText);
        while (placeholderMatcher.find()) {
            String placeholder = placeholderMatcher.group();
            this.processPlaceholder(placeholder, childGranMap, granToChildMap, granMap, childList, unionGranArray);
        }
    }

    private void processPlaceholder(String placeholder, Map<String, List<String>> childGranMap, Map<String, String> granToChildMap, JSONObject granMap, List<String> childList, JSONArray unionGranArray) {
        String innerContent = this.extractPlaceholderContent(placeholder);
        if (!innerContent.contains(SEPARATION)) {
            return;
        }
        String[] contentParts = innerContent.split(MATCHER_SEPARATION);
        this.handleFirstPart(contentParts, childGranMap, granToChildMap, granMap, childList, unionGranArray);
    }

    private void handleFirstPart(String[] parts, Map<String, List<String>> childGranMap, Map<String, String> granToChildMap, JSONObject granMap, List<String> childList, JSONArray unionGranArray) {
        String firstPart = parts[0];
        if (HussarUtils.isNotEmpty((Object)granMap.get((Object)firstPart))) {
            this.handleGrandchildDefinitions(parts, childGranMap, granToChildMap, granMap, unionGranArray, firstPart);
        } else {
            this.handleChildDefinitions(firstPart, childList);
        }
    }

    private void handleGrandchildDefinitions(String[] parts, Map<String, List<String>> childGranMap, Map<String, String> granToChildMap, JSONObject granMap, JSONArray unionGranArray, String firstPart) {
        String grandchildName = String.valueOf(granMap.get((Object)firstPart));
        granToChildMap.put(grandchildName, firstPart);
        this.checkForUnionMarker(parts, grandchildName, unionGranArray);
        this.updateGrandchildMapping(childGranMap, grandchildName, firstPart);
    }

    private void checkForUnionMarker(String[] parts, String grandchildName, JSONArray unionGranArray) {
        String[] subParts;
        String lastPart = parts[parts.length - 1];
        if (lastPart.contains(SPLIT_LINE) && "union".equals((subParts = lastPart.split("\\|"))[subParts.length - 1])) {
            unionGranArray.add((Object)grandchildName);
        }
    }

    private void updateGrandchildMapping(Map<String, List<String>> childGranMap, String grandchildName, String firstPart) {
        if (childGranMap.containsKey(grandchildName)) {
            List<String> existingList = childGranMap.get(grandchildName);
            if (!existingList.contains(firstPart)) {
                existingList.add(firstPart);
            }
        } else {
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(firstPart);
            childGranMap.put(grandchildName, newList);
        }
    }

    private void handleChildDefinitions(String firstPart, List<String> childList) {
        if (!childList.contains(firstPart)) {
            childList.add(firstPart);
        }
    }

    private void calculateMaxRowsForChildren(Map<String, List<String>> childGranMap, JSONObject parse, Map<JSONObject, Integer> childRowNumMap) {
        for (Map.Entry<String, List<String>> entry : childGranMap.entrySet()) {
            String grandchildName = entry.getKey();
            List<String> grandchildList = entry.getValue();
            JSONArray grandchildArray = (JSONArray)parse.get((Object)grandchildName);
            for (Object obj : grandchildArray) {
                JSONObject childObject = (JSONObject)obj;
                childRowNumMap.put(childObject, 1);
                this.calculateMaxRowsForGrandchildren(childObject, grandchildList, childRowNumMap);
            }
        }
    }

    private void calculateMaxRowsForGrandchildren(JSONObject childObject, List<String> grandchildList, Map<JSONObject, Integer> childRowNumMap) {
        for (String grandchildName : grandchildList) {
            JSONArray grandchildArray = (JSONArray)childObject.get((Object)grandchildName);
            int maxRows = Math.max(grandchildArray.size(), childRowNumMap.get(childObject));
            childRowNumMap.put(childObject, maxRows);
        }
    }

    private void preHandleContainsGran(JSONObject granMap, XSSFRow sheetAtRow, JSONObject widgetLevel, List<String> allGroup, List<String> allChildGroup, Map<Integer, List<XSSFCell>> cellLevelMap, List<XSSFRow> groupRows) {
        List<XSSFCell> hostCells = cellLevelMap.get(CellLevel.HOST.getLevel());
        List<XSSFCell> childCells = cellLevelMap.get(CellLevel.CHILD.getLevel());
        List<XSSFCell> grandchildCells = cellLevelMap.get(CellLevel.SUN.getLevel());
        this.processRowCells(sheetAtRow, granMap, widgetLevel, allGroup, allChildGroup, hostCells, childCells, grandchildCells, groupRows);
    }

    private void processRowCells(XSSFRow sheetAtRow, JSONObject granMap, JSONObject widgetLevel, List<String> allGroup, List<String> allChildGroup, List<XSSFCell> hostCells, List<XSSFCell> childCells, List<XSSFCell> grandchildCells, List<XSSFRow> groupRows) {
        for (int cellIndex = 0; cellIndex < sheetAtRow.getLastCellNum(); ++cellIndex) {
            boolean shouldReturn;
            XSSFCell currentCell = sheetAtRow.getCell(cellIndex);
            if (HussarUtils.isEmpty((Object)currentCell) || !(shouldReturn = this.processCellContent(currentCell, granMap, widgetLevel, allGroup, allChildGroup, hostCells, childCells, grandchildCells, groupRows))) continue;
            return;
        }
    }

    private boolean processCellContent(XSSFCell cell, JSONObject granMap, JSONObject widgetLevel, List<String> allGroup, List<String> allChildGroup, List<XSSFCell> hostCells, List<XSSFCell> childCells, List<XSSFCell> grandchildCells, List<XSSFRow> groupRows) {
        if (!cell.getCellType().equals((Object)CellType.STRING)) {
            hostCells.add(cell);
            return false;
        }
        String cellText = cell.getStringCellValue();
        Matcher placeholderMatcher = this.wordHandle.matcher(cellText);
        ArrayList<String> tableWidgets = new ArrayList<String>();
        int[] maxLevelRef = new int[]{CellLevel.HOST.getLevel()};
        boolean hasGroupMarker = this.processPlaceholders(placeholderMatcher, allGroup, allChildGroup, widgetLevel, tableWidgets, cell, groupRows, maxLevelRef);
        if (hasGroupMarker) {
            return true;
        }
        this.judgeCrossAndHandle(tableWidgets, cell, granMap);
        this.assignCellByLevel(maxLevelRef[0], cell, hostCells, childCells, grandchildCells);
        return false;
    }

    private boolean processPlaceholders(Matcher matcher, List<String> allGroup, List<String> allChildGroup, JSONObject widgetLevel, List<String> tableWidgets, XSSFCell cell, List<XSSFRow> groupRows, int[] maxLevelRef) {
        while (matcher.find()) {
            String placeholder = matcher.group();
            allGroup.add(placeholder);
            String content = this.extractPlaceholderContent(placeholder);
            if (content.contains(SEPARATION)) {
                this.processDotSeparatedContent(content, allChildGroup, widgetLevel, tableWidgets, maxLevelRef);
            }
            if (!this.checkForGroupMarker(content, groupRows, cell)) continue;
            return true;
        }
        return false;
    }

    private void processDotSeparatedContent(String content, List<String> allChildGroup, JSONObject widgetLevel, List<String> tableWidgets, int[] maxLevelRef) {
        allChildGroup.add(content);
        String[] parts = content.split(MATCHER_SEPARATION);
        String firstPart = parts[0];
        if (HussarUtils.isNotEmpty((Object)widgetLevel.get((Object)firstPart))) {
            maxLevelRef[0] = Math.max((Integer)widgetLevel.get((Object)firstPart), maxLevelRef[0]);
            this.updateTableWidgets(tableWidgets, firstPart);
        }
    }

    private void updateTableWidgets(List<String> tableWidgets, String widget) {
        if (!tableWidgets.contains(widget)) {
            tableWidgets.add(widget);
        }
    }

    private boolean checkForGroupMarker(String content, List<XSSFRow> groupRows, XSSFCell cell) {
        if (!content.contains(SPLIT_LINE)) {
            return false;
        }
        String[] pipeParts = content.split("\\|");
        String lastPart = pipeParts[pipeParts.length - 1];
        if (HussarUtils.isNotEmpty((Object)lastPart) && GROUP_KEY.equals(lastPart)) {
            groupRows.add(cell.getRow());
            return true;
        }
        return false;
    }

    private void assignCellByLevel(int level, XSSFCell cell, List<XSSFCell> hostCells, List<XSSFCell> childCells, List<XSSFCell> grandchildCells) {
        switch (level) {
            case 1: {
                childCells.add(cell);
                break;
            }
            case 2: {
                grandchildCells.add(cell);
                break;
            }
            default: {
                hostCells.add(cell);
            }
        }
    }

    private void judgeCrossAndHandle(List<String> tableWidgets, XSSFCell sheetAtRowCell, JSONObject granMap) {
        granMap.put("flowHistoryInfo", (Object)"");
        boolean isCross = true;
        if (tableWidgets.size() < 2) {
            isCross = false;
        } else if (tableWidgets.size() == 2) {
            String tableWidget0 = tableWidgets.get(0);
            String tableWidget1 = tableWidgets.get(1);
            boolean bl = isCross = !tableWidget1.equals(granMap.get((Object)tableWidget0)) && !tableWidget0.equals(granMap.get((Object)tableWidget1));
        }
        if (isCross) {
            LOGGER.info("-------\u5f53\u524d\u5355\u5143\u683c\u4e3a\u4ea4\u53c9\u6570\u636e\uff0c\u5df2\u7f6e\u7a7a,\u5355\u5143\u683c\u5185\u5bb9:{}", (Object)sheetAtRowCell.getStringCellValue());
            sheetAtRowCell.setCellValue("");
        }
    }

    public void analysisCell(XSSFSheet sheetAt) {
        int totalRows = sheetAt.getLastRowNum() + 1;
        for (int rowIndex = 0; rowIndex < totalRows; ++rowIndex) {
            this.processSheetRow(sheetAt, rowIndex);
        }
    }

    private void processSheetRow(XSSFSheet sheetAt, int rowIndex) {
        XSSFRow currentRow = sheetAt.getRow(rowIndex);
        if (HussarUtils.isEmpty((Object)currentRow)) {
            return;
        }
        int cellCount = currentRow.getLastCellNum();
        for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
            this.processRowCell(currentRow, cellIndex);
        }
    }

    private void processRowCell(XSSFRow currentRow, int cellIndex) {
        XSSFCell cell = currentRow.getCell(cellIndex);
        if (HussarUtils.isEmpty((Object)cell)) {
            return;
        }
        this.cloneCellStyle(cell);
        if (cell.getCellType() != CellType.STRING) {
            return;
        }
        this.processCellStringContent(cell);
    }

    private void cloneCellStyle(XSSFCell cell) {
        XSSFCellStyle originalStyle = cell.getCellStyle();
        XSSFCellStyle clonedStyle = originalStyle.copy();
        cell.setCellStyle((CellStyle)clonedStyle);
    }

    private void processCellStringContent(XSSFCell cell) {
        String cellValue = cell.getStringCellValue();
        Matcher patternMatcher = this.wordHandle.matcher(cellValue);
        while (patternMatcher.find()) {
            String matchKey = patternMatcher.group();
            String matchValue = this.wordHandle.getFormValue(matchKey);
            HASH_MAP.put(matchKey, matchValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void excelHandleBatch(WordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            LOGGER.info("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)this.wordHandle.getFormatTime(timeStart));
            if (HussarUtils.isEmpty((Object)wordPrintParamsDto)) {
                throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String formId = wordPrintParamsDto.getFormId();
            String id = wordPrintParamsDto.getId();
            String templateId = wordPrintParamsDto.getTemplateId();
            String appId = wordPrintParamsDto.getAppId();
            Map flowIds = wordPrintParamsDto.getFlowIds();
            String tabType = wordPrintParamsDto.getTabType();
            String exportType = wordPrintParamsDto.getExportType();
            String viewId = wordPrintParamsDto.getViewId();
            String langCode = wordPrintParamsDto.getLangCode();
            Object data = this.wordHandle.queryDataBatch(exportType, formId, viewId, id, appId, wordPrintParamsDto, tabType);
            if (HussarUtils.isEmpty((Object)data)) {
                throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            WidgetsAndData widgetsAndData = (WidgetsAndData)data;
            EngineResultEntity entity = widgetsAndData.getEntity();
            ArrayList<JSONObject> dataS = new ArrayList<JSONObject>();
            this.wordHandle.handleDataBatch(entity, flowIds, dataS);
            UserDetails userDetails = wordPrintParamsDto.getUserDetails();
            String printTime = this.wordHandle.getFormatTime(System.currentTimeMillis());
            String printTimeNoHour = this.wordHandle.getFormatTimeNoHour(System.currentTimeMillis());
            dataS.forEach(dataItem -> {
                dataItem.put("langCode", (Object)langCode);
                dataItem.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
                dataItem.put("printDateTime", (Object)printTime);
            });
            Map widgets = widgetsAndData.getMap();
            String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
            JSONObject content = (JSONObject)JSON.parseObject((String)((SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId))).getContent(), JSONObject.class);
            Long templateFileId = Long.valueOf(String.valueOf(content.get((Object)ID_KEY)));
            AttachmentManagerModelVo attachmentManagerServiceByFileId = this.ossService.getByFileId(templateFileId);
            if (HussarUtils.isEmpty((Object)attachmentManagerServiceByFileId)) {
                LOGGER.error("-------\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("-------\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)Long.valueOf(templateId));
            if (HussarUtils.isEmpty((Object)printTemplate)) {
                LOGGER.error("-------\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("-------\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            JSONObject fileNameObj = new JSONObject();
            fileNameObj.put("langCode", (Object)langCode);
            fileNameObj.put("mode", (Object)FileNameMode.DEFAULT.getType());
            String fileName = this.wordHandle.handlerGeneFileName(printTemplate, printTimeNoHour, formId, fileNameObj, XLSX_SUFFIX);
            String outputPathNew = this.hussarFormDesignProperties.getWorkspace() + "excelTemplate" + File.separator;
            long fileId = Long.parseLong(this.wordHandle.gene16Num());
            String outputFilePath = outputPathNew + File.separator + fileId + XLSX_SUFFIX;
            File file = new File(outputPathNew);
            if (!file.exists()) {
                boolean mkdirFlag = file.mkdirs();
                LOGGER.info("\u6587\u4ef6\u521b\u5efa{}", (Object)(mkdirFlag ? "\u6210\u529f" : "\u5931\u8d25"));
            }
            WordHandle.TaskInfo taskInfo = this.entryBatch(mark, dataS, this.downLoadCompent.copyOssFile(templateFileId), outputFilePath, fileName, widgets);
            taskState = taskInfo.getTaskStatus();
            fileId = taskInfo.getFileId();
            this.wordHandle.updateTask(taskState, fileId, taskId);
        }
        catch (Exception e) {
            try {
                LOGGER.error("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
                this.wordHandle.updateTask(-1, null, taskId);
            }
            catch (Throwable throwable) {
                long timeEnd = System.currentTimeMillis();
                LOGGER.info("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.wordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
                EngineUserUtil.remove();
                throw throwable;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.info("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.wordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
            EngineUserUtil.remove();
        }
        long timeEnd = System.currentTimeMillis();
        LOGGER.info("-------excel\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)this.wordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
        EngineUserUtil.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WordHandle.TaskInfo entryBatch(String mark, List<JSONObject> dataList, String inputFilePath, String outputFilePath, String fileName, Map<String, String> widgets) {
        Long fileId = 0L;
        int taskState = 1;
        try (FileInputStream inputStream = new FileInputStream(inputFilePath);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);
             OutputStream outputStream = Files.newOutputStream(Paths.get(outputFilePath, new String[0]), new OpenOption[0]);
             FileInputStream fileInputStream = new FileInputStream(outputFilePath);){
            this.processWorkbookSheets(workbook, dataList, widgets, mark);
            workbook.write(outputStream);
            fileId = this.uploadGeneratedFile(fileInputStream, fileName);
        }
        catch (Exception e) {
            taskState = this.handleProcessingException(inputFilePath, e);
        }
        finally {
            HASH_MAP.clear();
        }
        return new WordHandle.TaskInfo(taskState, fileId);
    }

    private void processWorkbookSheets(XSSFWorkbook workbook, List<JSONObject> dataList, Map<String, String> widgets, String mark) {
        List<XSSFSheet> sheets = this.getAllSheets(workbook);
        XSSFSheet sourceSheet = this.findFirstVisibleSheet(workbook, sheets);
        if (HussarUtils.isNotEmpty((Object)sourceSheet)) {
            this.processDataList(workbook, sourceSheet, dataList, widgets, sheets);
        } else {
            LOGGER.error("-------\u65e0\u53ef\u6253\u5370\u7684sheet\uff1a{}", (Object)sourceSheet);
        }
        this.processRemainingSheets(workbook, sheets, mark);
    }

    private List<XSSFSheet> getAllSheets(XSSFWorkbook workbook) {
        ArrayList<XSSFSheet> sheets = new ArrayList<XSSFSheet>();
        int sheetCount = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            sheets.add(workbook.getSheetAt(i));
        }
        return sheets;
    }

    private XSSFSheet findFirstVisibleSheet(XSSFWorkbook workbook, List<XSSFSheet> sheets) {
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            if (!workbook.getSheetVisibility(i).equals((Object)SheetVisibility.VISIBLE)) continue;
            return workbook.getSheetAt(i);
        }
        return null;
    }

    private void processDataList(XSSFWorkbook workbook, XSSFSheet sourceSheet, List<JSONObject> dataList, Map<String, String> widgets, List<XSSFSheet> sheets) {
        String sheetName = workbook.getSheetName(workbook.getSheetIndex((Sheet)sourceSheet));
        for (JSONObject dataItem : dataList) {
            int index = dataList.indexOf(dataItem) + 1;
            LOGGER.info("-------\u5f00\u59cb\u6253\u5370\u7b2c{}\u6761\u6570\u636e", (Object)index);
            XSSFSheet newSheet = workbook.cloneSheet(workbook.getSheetIndex((Sheet)sourceSheet));
            this.copyPageSettings(workbook, (Sheet)sourceSheet, (Sheet)newSheet);
            workbook.setSheetName(workbook.getSheetIndex((Sheet)newSheet), sheetName + "(" + index + ")");
            this.prepareDataProcessing(workbook, newSheet, dataItem, widgets);
            LOGGER.info("-------\u7ed3\u675f\u6253\u5370\u7b2c{}\u6761\u6570\u636e", (Object)index);
        }
        workbook.removeSheetAt(workbook.getSheetIndex((Sheet)sourceSheet));
        sheets.remove(sourceSheet);
    }

    private void prepareDataProcessing(XSSFWorkbook workbook, XSSFSheet sheet, JSONObject dataItem, Map<String, String> widgets) {
        this.analysisCell(sheet);
        HASH_MAP.put(DATA_VALUE, dataItem);
        WordHandle.getFormData(HASH_MAP, dataItem);
        String granMapStr = widgets.get(GRAN_MAP);
        JSONObject granMap = JSON.parseObject((String)granMapStr);
        this.handleTableContainsGran(workbook, sheet, widgets, granMap);
    }

    private void processRemainingSheets(XSSFWorkbook workbook, List<XSSFSheet> sheets, String mark) {
        ArrayList<XSSFSheet> clonedSheets = new ArrayList<XSSFSheet>();
        for (XSSFSheet sheet : sheets) {
            if (HussarUtils.isEmpty((Object)sheet)) continue;
            int sheetIndex = workbook.getSheetIndex((Sheet)sheet);
            XSSFSheet clonedSheet = workbook.cloneSheet(sheetIndex);
            clonedSheets.add(clonedSheet);
            this.copyPageSettings(workbook, (Sheet)sheet, (Sheet)clonedSheet);
            String sheetName = sheet.getSheetName();
            workbook.removeSheetAt(sheetIndex);
            workbook.setSheetName(workbook.getSheetIndex((Sheet)clonedSheet), sheetName);
        }
        for (XSSFSheet clonedSheet : clonedSheets) {
            workbook.setSheetVisibility(workbook.getSheetIndex((Sheet)clonedSheet), SheetVisibility.HIDDEN);
        }
    }

    private Long uploadGeneratedFile(FileInputStream fileInputStream, String fileName) throws IOException {
        int length = fileInputStream.available();
        byte[] fileBytes = new byte[length];
        int bytesRead = fileInputStream.read(fileBytes);
        LOGGER.info("-------bytesRead\u957f\u5ea6{}", (Object)bytesRead);
        MockMultipartFile multipartFile = new MockMultipartFile(fileName, fileName, XLSX_SUFFIX, fileBytes);
        ApiResponse upload = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        return (Long)upload.getData();
    }

    private int handleProcessingException(String inputFilePath, Exception e) {
        LOGGER.error("-------excel\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
        LOGGER.error("-------\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
        return -1;
    }

    private void copyPageSettings(XSSFWorkbook xssfWorkbook, Sheet source, Sheet target) {
        PrintSetup sourcePrint = source.getPrintSetup();
        PrintSetup targetPrint = target.getPrintSetup();
        targetPrint.setLandscape(sourcePrint.getLandscape());
        targetPrint.setPaperSize(sourcePrint.getPaperSize());
        targetPrint.setScale(sourcePrint.getScale());
        targetPrint.setFitWidth(sourcePrint.getFitWidth());
        targetPrint.setFitHeight(sourcePrint.getFitHeight());
        target.setMargin((short)0, source.getMargin((short)0));
        target.setMargin((short)1, source.getMargin((short)1));
        target.setMargin((short)2, source.getMargin((short)2));
        target.setMargin((short)3, source.getMargin((short)3));
        Header sourceHeader = source.getHeader();
        Footer sourceFooter = source.getFooter();
        Header targetHeader = target.getHeader();
        Footer targetFooter = target.getFooter();
        targetHeader.setLeft(sourceHeader.getLeft());
        targetHeader.setCenter(sourceHeader.getCenter());
        targetHeader.setRight(sourceHeader.getRight());
        targetFooter.setLeft(sourceFooter.getLeft());
        targetFooter.setCenter(sourceFooter.getCenter());
        targetFooter.setRight(sourceFooter.getRight());
        if (source.getRepeatingRows() != null) {
            target.setRepeatingRows(source.getRepeatingRows());
        }
        if (source.getRepeatingColumns() != null) {
            target.setRepeatingColumns(source.getRepeatingColumns());
        }
        if (xssfWorkbook.getPrintArea(xssfWorkbook.getSheetIndex(source)) != null) {
            String printArea = xssfWorkbook.getPrintArea(xssfWorkbook.getSheetIndex(source));
            xssfWorkbook.setPrintArea(xssfWorkbook.getSheetIndex(target), printArea);
        }
    }

    static {
        FONT_CHAR.put(6, 3.1);
        FONT_CHAR.put(8, 2.4);
        FONT_CHAR.put(9, 2.4);
        FONT_CHAR.put(10, 1.9);
        FONT_CHAR.put(11, 1.85);
        FONT_CHAR.put(12, 1.8);
        FONT_CHAR.put(14, 1.6);
        FONT_CHAR.put(16, 1.35);
        FONT_CHAR.put(18, 1.15);
        FONT_CHAR.put(20, 10.0);
        FONT_CHAR.put(22, 9.0);
        FONT_CHAR.put(24, 8.0);
        FONT_CHAR.put(26, 7.5);
        FONT_CHAR.put(36, 5.5);
    }

    private static class TextProcessingState {
        String cellValue;
        StringBuilder splitBuilder;
        String lastSplit;
        int currentLineIndex;

        public TextProcessingState(String initialValue) {
            this.cellValue = initialValue;
            this.splitBuilder = new StringBuilder(initialValue);
            this.lastSplit = "";
            this.currentLineIndex = 0;
        }
    }

    private static class MaxAdd {
        private int maxAddRow;
        private int maxAddNum;

        public MaxAdd() {
        }

        public MaxAdd(int maxAddRow, int maxAddNum) {
            this.maxAddRow = maxAddRow;
            this.maxAddNum = maxAddNum;
        }
    }

    private static class FieldDisplayConfig {
        boolean hasContent;
        boolean hasName;
        boolean hasDate;

        private FieldDisplayConfig() {
        }
    }

    private static class HorizontalWidth {
        int col1;
        int col2;
        int dx1;
        int dx2;
        int widthDel;
        int widthDelStart;

        public HorizontalWidth(int col1, int col2, int dx1, int dx2) {
            this.col1 = col1;
            this.col2 = col2;
            this.dx1 = dx1;
            this.dx2 = dx2;
        }

        public HorizontalWidth() {
        }
    }

    private static class VerticalHeight {
        int v;
        int dy1;
        int dy2;
        int firstRow2;
        int lastRow2;

        public VerticalHeight() {
        }

        public VerticalHeight(int v, int dy1, int dy2, int firstRow2, int lastRow2) {
            this.v = v;
            this.dy1 = dy1;
            this.dy2 = dy2;
            this.firstRow2 = firstRow2;
            this.lastRow2 = lastRow2;
        }
    }

    private static class ImageConfig {
        String width;
        String height;
        int mode;
        double widthToHeight;

        private ImageConfig() {
        }
    }

    private static class OutputFileInfo {
        long fileId;
        String fileName;
        String outputFilePath;

        OutputFileInfo(long fileId, String fileName, String outputFilePath) {
            this.fileId = fileId;
            this.fileName = fileName;
            this.outputFilePath = outputFilePath;
        }
    }

    private static class SunStr {
        private String granStr;
        private String childStr;

        private SunStr() {
        }
    }

    public static class ReturnBody {
        String stringCellValue;
        int startNum;
        int heightNum;
        boolean isExpansionHeight;

        public boolean isExpansionHeight() {
            return this.isExpansionHeight;
        }

        public void setExpansionHeight(boolean expansionHeight) {
            this.isExpansionHeight = expansionHeight;
        }

        public void setHeightNum(int heightNum) {
            this.heightNum = heightNum;
        }

        public int getHeightNum() {
            return this.heightNum;
        }

        public String getStringCellValue() {
            return this.stringCellValue;
        }

        public void setStringCellValue(String stringCellValue) {
            this.stringCellValue = stringCellValue;
        }

        public int getStartNum() {
            return this.startNum;
        }

        public void setStartNum(int startNum) {
            this.startNum = startNum;
        }
    }

    private static class GroupChildData {
        List<XSSFCell> mergeCells;
        List<String> mergeList;
        Map<XSSFCell, JSONArray> childCellToData;
        JSONObject newParse;
        JSONArray newChildArray;
        int maxAddRow;
        int maxAddNum;

        private GroupChildData() {
        }
    }

    private static class GroupInfo {
        JSONArray childArrayAll;
        String groupText;
        String groupIndexText;
        String groupCountText;
        List<String> groupTextS;

        private GroupInfo() {
        }
    }
}

