/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.TranslateUtil;
import com.jxdinfo.hussar.formdesign.application.form.dao.FormRecentUsedHisMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.FormRecentUsedHis;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormRecentUsedHisService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormRecentUsedHisVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormRecentUsedHisServiceImpl")
public class FormRecentUsedHisServiceImpl
implements IFormRecentUsedHisService {
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysApplicationBoService applicationBoService;
    @Resource
    private FormRecentUsedHisMapper formRecentUsedHisMapper;
    private static final int MAX_HISTORY_SIZE = 8;
    private static final DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(FormRecentUsedHisServiceImpl.class);

    public ApiResponse<List<FormRecentUsedHisVo>> getRecentUsedHisList() {
        String recentUsedHis;
        JSONArray jsonArray;
        FormRecentUsedHis formRecentUsedHis = this.getFormRecentUsedHis();
        List<Object> formRecentUsedHisVoList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)formRecentUsedHis) && HussarUtils.isNotEmpty((Object)(jsonArray = JSONArray.parseArray((String)(recentUsedHis = formRecentUsedHis.getRecentUsedHis()))))) {
            ArrayList<String> formIds = new ArrayList<String>();
            HashMap formIdToVoMap = new HashMap();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String formId = jsonObject.getString("formId");
                formIds.add(formId);
                formIdToVoMap.put(formId, null);
            }
            formRecentUsedHisVoList = this.getFormAndAppInfos(formIds);
            formRecentUsedHisVoList.stream().forEach(vo -> formIdToVoMap.put(vo.getFormId(), vo));
            boolean delFlag = false;
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject jsonObject = (JSONObject)iterator.next();
                String formId = jsonObject.getString("formId");
                FormRecentUsedHisVo vo2 = (FormRecentUsedHisVo)formIdToVoMap.get(formId);
                String accessTime = jsonObject.getString("accessTime");
                if (HussarUtils.isNotEmpty((Object)vo2)) {
                    String formLangKeys = vo2.getFormLangKeys();
                    String appLangKeys = vo2.getAppLangKeys();
                    JSONObject formLangJsonObject = JSONObject.parseObject((String)formLangKeys);
                    JSONObject appLangJsonObject = JSONObject.parseObject((String)appLangKeys);
                    String appNameKey = null;
                    String formNameKey = null;
                    if (HussarUtils.isNotEmpty((Object)appLangJsonObject)) {
                        appNameKey = appLangJsonObject.getString("appName");
                    }
                    if (HussarUtils.isNotEmpty((Object)formLangJsonObject)) {
                        formNameKey = formLangJsonObject.getString("formName");
                    }
                    String translateFormName = TranslateUtil.getTranslateName(formNameKey);
                    String translateAppName = TranslateUtil.getTranslateName((String)appNameKey);
                    if (HussarUtils.isNotEmpty((Object)translateFormName)) {
                        vo2.setFormName(translateFormName);
                    }
                    if (HussarUtils.isNotEmpty((Object)translateAppName)) {
                        vo2.setAppName(translateAppName);
                    }
                    vo2.setAccessTime(accessTime);
                    continue;
                }
                formIdToVoMap.remove(formId);
                iterator.remove();
                delFlag = true;
            }
            if (delFlag) {
                formRecentUsedHis.setRecentUsedHis(jsonArray.toJSONString());
                this.formRecentUsedHisMapper.updateById(formRecentUsedHis);
            }
            formRecentUsedHisVoList.clear();
            formRecentUsedHisVoList.addAll(formIdToVoMap.values());
            this.sortListByAccessTime(formRecentUsedHisVoList);
        }
        return ApiResponse.success(formRecentUsedHisVoList);
    }

    private List<FormRecentUsedHisVo> getFormAndAppInfos(List<String> formIds) {
        ArrayList<FormRecentUsedHisVo> formRecentUsedHisVoList = new ArrayList<FormRecentUsedHisVo>();
        List forms = this.formService.listByIds(formIds);
        if (HussarUtils.isNotEmpty((Object)forms)) {
            for (SysForm form : forms) {
                SysApplication application = this.applicationBoService.selectById(form.getAppId());
                if (HussarUtils.isEmpty((Object)application)) {
                    LOGGER.error("\u8868\u5355\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8868\u5355ID\uff1a{}", (Object)form.getId());
                    continue;
                }
                FormRecentUsedHisVo formRecentUsedHisVo = new FormRecentUsedHisVo();
                formRecentUsedHisVo.setFormId(String.valueOf(form.getId()));
                formRecentUsedHisVo.setFormName(form.getFormName());
                formRecentUsedHisVo.setFormType(form.getFormType());
                formRecentUsedHisVo.setAppId(String.valueOf(application.getId()));
                formRecentUsedHisVo.setAppName(application.getAppName());
                formRecentUsedHisVo.setAppLangKeys(application.getI18nKeys());
                formRecentUsedHisVo.setFormIconType(form.getFormIconType());
                formRecentUsedHisVo.setFormIcon(form.getFormIcon());
                formRecentUsedHisVo.setFormIconColor(form.getFormIconColor());
                formRecentUsedHisVo.setIsDeleted(form.getDelFlag());
                formRecentUsedHisVo.setFormLangKeys(form.getI18nKeys());
                formRecentUsedHisVoList.add(formRecentUsedHisVo);
            }
        }
        return formRecentUsedHisVoList;
    }

    public ApiResponse<Boolean> updateRecentUsedHis(String formId) {
        FormRecentUsedHis formRecentUsedHis = this.getFormRecentUsedHis();
        String currentTime = HussarUtils.formatDateTime((TemporalAccessor)LocalDateTime.now());
        if (HussarUtils.isEmpty((Object)formRecentUsedHis)) {
            formRecentUsedHis = new FormRecentUsedHis();
            Long userId = BaseSecurityUtil.getUser().getUserId();
            formRecentUsedHis.setUserId(userId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("formId", (Object)formId);
            jsonObject.put("accessTime", (Object)currentTime);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
            formRecentUsedHis.setRecentUsedHis(jsonArray.toJSONString());
            int isSuccess = this.formRecentUsedHisMapper.insert(formRecentUsedHis);
            if (isSuccess > 0) {
                return ApiResponse.success((Object)true);
            }
            return ApiResponse.success((Object)false);
        }
        String recentUsedHis = formRecentUsedHis.getRecentUsedHis();
        JSONArray jsonArray = JSONArray.parseArray((String)recentUsedHis);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        boolean found = false;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject entry = jsonArray.getJSONObject(i);
            jsonObjects.add(entry);
            if (!entry.getString("formId").equals(formId)) continue;
            entry.put("accessTime", (Object)currentTime);
            found = true;
        }
        if (!found) {
            JSONObject newEntry = new JSONObject();
            newEntry.put("formId", (Object)formId);
            newEntry.put("accessTime", (Object)currentTime);
            jsonObjects.add(newEntry);
        }
        this.sortJsonObjectsByAccessTime(jsonObjects);
        while (jsonObjects.size() > 8) {
            jsonObjects.remove(jsonObjects.size() - 1);
        }
        String newRecentUsedHis = JSONArray.toJSONString(jsonObjects);
        formRecentUsedHis.setRecentUsedHis(newRecentUsedHis);
        int isSuccess = this.formRecentUsedHisMapper.updateById(formRecentUsedHis);
        if (isSuccess > 0) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    private FormRecentUsedHis getFormRecentUsedHis() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = String.valueOf(user.getUserId());
        return this.formRecentUsedHisMapper.selectByUserId(Long.valueOf(userId));
    }

    private void sortJsonObjectsByAccessTime(List<JSONObject> jsonObjects) {
        jsonObjects.sort((o1, o2) -> {
            LocalDateTime date1 = LocalDateTime.parse(o1.getString("accessTime"), sdf);
            LocalDateTime date2 = LocalDateTime.parse(o2.getString("accessTime"), sdf);
            return date2.compareTo(date1);
        });
    }

    private void sortListByAccessTime(List<FormRecentUsedHisVo> formRecentUsedHisVo) {
        formRecentUsedHisVo.sort((o1, o2) -> {
            LocalDateTime date1 = LocalDateTime.parse(o1.getAccessTime(), sdf);
            LocalDateTime date2 = LocalDateTime.parse(o2.getAccessTime(), sdf);
            return date2.compareTo(date1);
        });
    }
}

