/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.dashboard.json.DashboardJsonData;
import com.jxdinfo.hussar.dashboard.json.WidgetJsonData;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormExportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFileInfoVo;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeOrderService;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.print.dto.SysPrintTemplateBoolean;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysFileInfoDashboardService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.model.WidgetExp;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptTreeVO;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleInfo;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.Impl.SysRuleInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormExportInfoServiceImpl")
public class FormExportInfoServiceImpl
implements IFormExportInfoService {
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private IWidgetExpService widgetExpService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysRuleInfoServiceImpl ruleInfoService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    @Resource
    private ISysFormLinkService formLinkService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private SysMsgPushConfigService sysMsgPushConfigService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private FormMapService formMapService;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private INavLeftTreeOrderService navLeftTreeOrderService;
    @Resource
    private ISysFormExtApiService sysFormExtApiService;
    @Resource
    private ISysFileInfoDashboardService sysFileInfoDashboardService;
    private static final Logger logger = LoggerFactory.getLogger(FormExportInfoServiceImpl.class);

    public void init(FormExportDto formExportDto) {
        String exportFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), this.formDesignProperties.getBackProjectPath(), ".export-store"});
        String basePath = FileUtil.posixPath((String[])new String[]{exportFolderPath, formExportDto.getFormId().toString(), UUID.randomUUID().toString()});
        formExportDto.setBasePath(basePath);
    }

    @ProgressCache(status=1, msg="\u6b63\u5728\u5bfc\u51fa\u8868\u5355\u4fe1\u606f")
    public void exportFormInfo(FormExportDto formExportDto) throws IOException {
        String basePath = formExportDto.getBasePath();
        HashMap<String, SysForm> map = new HashMap<String, SysForm>();
        SysForm form = (SysForm)this.sysFormMapper.selectById(formExportDto.getFormId());
        map.put("form", form);
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "form.json"}));
    }

    @ProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u51fa\u4eea\u8868\u76d8\u4fe1\u606f")
    public void exportDashboardData(FormExportDto formExportDto) throws IOException {
        String basePath = formExportDto.getBasePath();
        this.exportDashboardImage(formExportDto.getFormId(), basePath);
        HashMap map = new HashMap();
        ArrayList<DashEntry> dashEntryList = new ArrayList<DashEntry>();
        DashEntry panelEntry = (DashEntry)this.dashEntryService.getById((Serializable)formExportDto.getFormId());
        dashEntryList.add(panelEntry);
        dashEntryList.addAll(this.dashEntryService.selectList(formExportDto.getFormId()));
        map.put("dashboard", dashEntryList);
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "dashboardConfig", "dashboard.json"}));
    }

    @ProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u51fa\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void exportDesignerMidFile(FormExportDto formExportDto) throws IOException {
        String basePath = formExportDto.getBasePath();
        this.exportMid(formExportDto.getAppId(), FileUtil.posixPath((String[])new String[]{basePath, "formConfig"}), formExportDto.getFormId(), basePath);
        this.exportBusinessRule(formExportDto.getFormId(), basePath);
        this.exportCustomButton(formExportDto.getFormId(), basePath);
        this.exportFormCheckConfig(Collections.singletonList(formExportDto.getFormId()), basePath);
        this.exportFormLinkData(Collections.singletonList(formExportDto.getFormId()), basePath);
        this.exportMsgPush(formExportDto.getFormId(), basePath);
        this.exportPrintTemplate(formExportDto.getFormId(), basePath);
        this.exportDataPush(formExportDto.getFormId(), basePath);
        this.exportDataPushMap(formExportDto.getFormId(), basePath);
        this.exportDataPull(formExportDto.getFormId(), basePath);
        this.exportPublicView(formExportDto.getFormId(), basePath);
        this.exportScript(formExportDto.getFormId(), basePath);
        this.exportLeftTreeData(formExportDto);
        this.exportExtensionApi(formExportDto.getFormId(), basePath);
    }

    public void exportCustomButton(Long formId, String basePath) {
        HashMap<String, List> map = new HashMap<String, List>();
        List customButtons = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
        map.put("customButtonData", customButtons);
        String customButtonPath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "customButton.json"});
        this.writeToFile(map, customButtonPath);
    }

    private void exportPrintTemplate(Long formId, String basePath) {
        HashMap map = new HashMap();
        List printTemplates = this.sysPrintTemplateService.list((Wrapper)new LambdaQueryWrapper().eq(SysPrintTemplate::getFormId, (Object)formId));
        ArrayList<SysPrintTemplateBoolean> list = new ArrayList<SysPrintTemplateBoolean>();
        for (SysPrintTemplate sysPrintTemplate : printTemplates) {
            list.add(sysPrintTemplate.intToBoolean(sysPrintTemplate));
        }
        String templateFilePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "printTemplate", "templateFile"});
        try {
            this.sysPrintTemplateService.exportPrintTemplate(printTemplates, templateFilePath);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6a21\u677f\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
        }
        map.put("printTemplateData", list);
        String printTemplatePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "printTemplate", "printTemplate.json"});
        this.writeToFile(map, printTemplatePath);
    }

    private void exportMid(Long appId, String path, Long formId, String basePath) throws IOException {
        AppContextUtil.setAppId((String)String.valueOf(appId));
        String appIdStr = String.valueOf(appId);
        ArrayList<String> widgetsAll = new ArrayList<String>();
        String formName = ((FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData()).getName();
        String midFilePath = FileUtil.posixPath((String[])new String[]{path, formName});
        FormCanvasSchema canvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
        String canvasFin = formName + ".fd";
        String canvasPath = FileUtil.posixPath((String[])new String[]{midFilePath, "canvas", canvasFin});
        String canvasJson = JSONObject.toJSONStringWithDateFormat((Object)canvasSchema, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        List widgets = canvasSchema.getWidgets();
        if (HussarUtils.isNotEmpty((Object)widgets)) {
            for (Widget widget : widgets) {
                if (!"JXDNExtWidget".equals(widget.getType())) continue;
                widgetsAll.add(widget.getProps().getString("extname"));
            }
        }
        this.filePublishService.writeStringToFile(canvasJson, canvasPath);
        SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
        FormSettingSchema settingSchema = (FormSettingSchema)bean.get(String.valueOf(formId)).getData();
        String settingFin = formName + ".setting";
        String settingPath = FileUtil.posixPath((String[])new String[]{midFilePath, "setting", settingFin});
        String settingJson = JSONObject.toJSONStringWithDateFormat((Object)settingSchema, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        this.filePublishService.writeStringToFile(settingJson, settingPath);
        FormViewSchema viewSchema = (FormViewSchema)this.viewService.get(String.valueOf(formId)).getData();
        String viewFin = formName + ".vd";
        String viewPath = FileUtil.posixPath((String[])new String[]{midFilePath, "view", viewFin});
        String viewJson = JSONObject.toJSONStringWithDateFormat((Object)viewSchema, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        this.filePublishService.writeStringToFile(viewJson, viewPath);
        LinkedHashSet set = new LinkedHashSet(widgetsAll);
        widgetsAll.clear();
        widgetsAll.addAll(set);
        this.exportWidgetExp(widgetsAll, basePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportWidgetExp(List<String> widgets, String basePath) {
        for (String widgetName : widgets) {
            try {
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(WidgetExp::getName, (Object)widgetName);
                Long fileId = ((WidgetExp)this.widgetExpService.getOne((Wrapper)wrapper)).getFileId();
                AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)fileId);
                String fileName = attachmentModel.getAttachmentName();
                int index = fileName.lastIndexOf(".");
                String suffix = index > -1 ? fileName.substring(index) : "";
                String attachmentPath = attachmentModel.getAttachmentDir() + fileId + suffix;
                String folderPath = basePath + File.separator + "widgetExpand";
                File folder = new File(folderPath);
                boolean created = folder.mkdirs();
                if (created) {
                    System.out.println("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u6587\u4ef6");
                }
                String destinationFolder = FileUtil.posixPath((String[])new String[]{folderPath, fileName});
                ZipInputStream zipInput = null;
                ZipOutputStream zipOutput = null;
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    fileInputStream = new FileInputStream(attachmentPath);
                    fileOutputStream = new FileOutputStream(destinationFolder);
                    zipInput = new ZipInputStream(fileInputStream);
                    zipOutput = new ZipOutputStream(fileOutputStream);
                    ZipEntry entry = zipInput.getNextEntry();
                    while (entry != null) {
                        int bytesRead;
                        zipOutput.putNextEntry(new ZipEntry(entry.getName()));
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = zipInput.read(buffer)) > 0) {
                            zipOutput.write(buffer, 0, bytesRead);
                        }
                        zipOutput.closeEntry();
                        entry = zipInput.getNextEntry();
                    }
                    System.out.println("Zip\u538b\u7f29\u5305\u5df2\u6210\u529f\u590d\u5236\u5230\u76ee\u6807\u8def\u5f84\u3002");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (zipOutput != null) {
                            zipOutput.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                    try {
                        if (zipInput != null) {
                            zipInput.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                    try {
                        if (fileInputStream == null) continue;
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5f02\u5e38\uff0c\u8df3\u8fc7,\u7ec4\u4ef6\u540d\u79f0\uff1a{}", (Object)widgetName, (Object)e);
            }
        }
    }

    private void exportBusinessRule(Long formId, String basePath) {
        ArrayList<RuleFullVo> ruleFullVos = new ArrayList<RuleFullVo>();
        List<SysRuleInfo> ruleInfos = this.ruleInfoService.getRuleListByFormId(formId);
        if (HussarUtils.isEmpty(ruleInfos)) {
            return;
        }
        for (SysRuleInfo sysRuleInfo : ruleInfos) {
            Long ruleId = sysRuleInfo.getRuleId();
            ruleFullVos.add(this.ruleInfoService.getRuleInfoDetail(ruleId));
        }
        ArrayList allRules = new ArrayList(ruleFullVos);
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "rule.json"});
        this.writeToFile(allRules, flowFilePath);
    }

    private void exportFormLinkData(List<Long> formIds, String basePath) {
        Map formLinkExportData = this.formLinkService.getFormLinkExportData(formIds);
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "formLink.json"});
        this.writeToFile(formLinkExportData, flowFilePath);
    }

    private void exportFormCheckConfig(List<Long> formIds, String basePath) {
        List formCheckConfigList = this.sysFormCheckConfigService.getFormCheckConfigList(formIds);
        String formCheckConfigFilePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "checkConfig.json"});
        this.writeToFile(formCheckConfigList, formCheckConfigFilePath);
    }

    private void exportPublicView(Long formId, String basePath) {
        List formPublicViewList = (List)this.customViewService.get(String.valueOf(formId)).getData();
        if (HussarUtils.isEmpty((Object)formPublicViewList)) {
            return;
        }
        List publicView = formPublicViewList.stream().filter(dataView -> "public".equals(dataView.getCategory())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(publicView)) {
            String formPublicFilePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "publicView.json"});
            this.writeToFile(publicView, formPublicFilePath);
        }
    }

    private void exportScript(Long formId, String basePath) {
        List form;
        ScriptRecordService scriptRecordService = (ScriptRecordService)SpringContextUtil.getBean(ScriptRecordService.class);
        ApiResponse scriptTreeRes = scriptRecordService.listInForm(null, String.valueOf(formId));
        ScriptTreeVO data = (ScriptTreeVO)scriptTreeRes.getData();
        if (HussarUtils.isNotEmpty((Object)scriptTreeRes) && HussarUtils.isNotEmpty((Object)data) && HussarUtils.isNotEmpty((Object)(form = data.getForm()))) {
            String formPublicFilePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "script.json"});
            this.writeToFile(form, formPublicFilePath);
        }
    }

    private void exportLeftTreeData(FormExportDto formExportDto) {
        try {
            List dragOrderData;
            HashMap<String, List> leftTreeData = new HashMap<String, List>();
            if (formExportDto.isExportDataFlag() && HussarUtils.isNotEmpty((Object)(dragOrderData = this.navLeftTreeOrderService.getExportData(formExportDto.getAppId(), formExportDto.getFormId())))) {
                leftTreeData.put("dragOrder", dragOrderData);
            }
            if (HussarUtils.isNotEmpty(leftTreeData)) {
                String leftTreePath = AppMigrateUtil.getFilePath(formExportDto.getBasePath(), "leftTree");
                this.writeToFile(leftTreeData, leftTreePath);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5de6\u4fa7\u6811\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new HussarException("\u5bfc\u51fa\u5de6\u4fa7\u6811\u6570\u636e\u5f02\u5e38");
        }
    }

    @ProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u51fa\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f")
    public void exportFlowConfigInfo(FormExportDto formExportDto) {
        String basePath = formExportDto.getBasePath();
        FormCanvasSchema formCanvasSchema = Optional.ofNullable(this.canvasSchemaService.get(String.valueOf(formExportDto.getFormId()))).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u753b\u5e03\u83b7\u53d6\u5931\u8d25!"));
        if ("1".equals(formCanvasSchema.getFormType())) {
            String oldFlowIdentity = formCanvasSchema.getIdentity();
            Map flowDataMap = this.flowMigrateService.exportFormWorkflow(oldFlowIdentity);
            String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "flow.json"});
            this.writeToFile(flowDataMap, flowFilePath);
        }
    }

    @ProgressCache(status=4, msg="\u6b63\u5728\u5bfc\u51fa\u4e1a\u52a1\u6570\u636e")
    public void exportBusinessData(FormExportDto formExportDto) {
        String basePath = formExportDto.getBasePath();
        HashMap<String, List> map = new HashMap<String, List>();
        SysForm sysForm = (SysForm)this.sysFormMapper.selectById(formExportDto.getFormId());
        logger.info("exportBusinessData sysForm : {}", (Object)JSONObject.toJSONString((Object)sysForm));
        if ("0".equals(sysForm.getFormType()) || "1".equals(sysForm.getFormType())) {
            logger.info("form id : {},name : {}", (Object)sysForm.getId(), (Object)sysForm.getFormName());
            ResponseEntity result = this.formOperateExposedService.tableQueryAll(String.valueOf(formExportDto.getAppId()), String.valueOf(sysForm.getId()));
            List data = ((PageVo)((ApiResponse)Objects.requireNonNull(result.getBody())).getData()).getData();
            map.put(sysForm.getTableName(), data);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "businessData", "businessData.json"}));
    }

    @ProgressCache(status=5, msg="\u6b63\u5728\u751f\u6210\u5bfc\u51fa\u8868\u5355\u5143\u4fe1\u606f")
    public void generateMetaInfo(FormExportDto formExportDto) {
        String basePath = formExportDto.getBasePath();
        FormExportMetaDto formExportMetaDto = new FormExportMetaDto();
        SysForm form = (SysForm)this.sysFormMapper.selectById(formExportDto.getFormId());
        BeanUtils.copyProperties((Object)form, (Object)formExportMetaDto);
        if (ToolUtil.isNotEmpty((Object)formExportDto.getExportPwd())) {
            formExportMetaDto.setPassword(DigestUtil.sha1Hex((String)formExportDto.getExportPwd()));
        }
        this.writeToFile(formExportMetaDto, FileUtil.posixPath((String[])new String[]{basePath, "hussar.meta"}));
    }

    @ProgressCache(status=6, msg="\u8868\u5355\u5bfc\u51fa\u6210\u529f", finish=true)
    public Long uploadExportFile(FormExportDto formExportDto) {
        String basePath = formExportDto.getBasePath();
        String formName = ((SysForm)this.sysFormMapper.selectById(formExportDto.getFormId())).getFormName();
        return this.appFileExtendService.fileEncrypt(formName, basePath);
    }

    public void clear() {
        String exportFilePath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), this.formDesignProperties.getBackProjectPath(), ".export-store"});
    }

    private void writeToFile(Object object, String path) {
        String json = JSONObject.toJSONStringWithDateFormat((Object)object, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        this.filePublishService.writeStringToFile(json, path);
    }

    private void exportMsgPush(Long formId, String basePath) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMsgPushConfig::getFormId, (Object)formId);
        List configs = this.sysMsgPushConfigService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String msgPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "msg.json"});
            this.writeToFile(configs, msgPushPath);
        }
    }

    private void exportDataPush(Long formId, String basePath) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getFormId, (Object)formId);
        List configs = this.pushDataService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String dataPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPush.json"});
            this.writeToFile(configs, dataPushPath);
        }
    }

    private void exportDataPushMap(Long formId, String basePath) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FormMap::getFormId, (Object)formId);
        FormMap config = (FormMap)this.formMapService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)config)) {
            String dataPushMapPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPushMap.json"});
            this.writeToFile(config, dataPushMapPath);
        }
    }

    private void exportDataPull(Long formId, String basePath) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullConfig::getFormId, (Object)formId);
        List configs = this.sysDataPullService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String dataPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPull.json"});
            this.writeToFile(configs, dataPushPath);
        }
    }

    private void exportExtensionApi(Long formId, String basePath) {
        List sysFormExtApis = this.sysFormExtApiService.formExtApiAllList(formId);
        if (HussarUtils.isNotEmpty((Object)sysFormExtApis)) {
            String extensionApiPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "extensionApi.json"});
            this.writeToFile(sysFormExtApis, extensionApiPushPath);
        }
    }

    private void exportDashboardImage(Long formId, String basePath) {
        HashMap<String, List<SysFileInfoVo>> map = new HashMap<String, List<SysFileInfoVo>>();
        String imageId = this.getDashboardImageIds(formId);
        if (HussarUtils.isNotEmpty((Object)imageId)) {
            List<SysFileInfoVo> sysFileInfoDashboardList = this.getImageId(imageId, formId);
            String FileInfoPath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "dashboardImagePath", "imageFile"});
            try {
                this.sysFileInfoDashboardService.exportFileInfoDashboard(sysFileInfoDashboardList, FileInfoPath);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u4eea\u8868\u76d8\u56fe\u7247\u5931\u8d25!", (Throwable)e);
            }
            map.put("printImageData", sysFileInfoDashboardList);
            String printTemplatePath = FileUtil.posixPath((String[])new String[]{basePath, "formConfig", "dashboardImagePath", "printImage.json"});
            this.writeToFile(map, printTemplatePath);
        }
    }

    private List<SysFileInfoVo> getImageId(String imageId, Long formId) {
        ArrayList<SysFileInfoVo> sysFileInfoVoList = new ArrayList<SysFileInfoVo>();
        String[] imageIdArr = imageId.split(",");
        List attachmentManagerModelVos = this.attachmentManagerService.getByFileIds(imageIdArr);
        for (AttachmentManagerModelVo attachmentManagerModelVo : attachmentManagerModelVos) {
            SysFileInfoVo sysFileInfoVo = (SysFileInfoVo)HussarUtils.copyProperties((Object)attachmentManagerModelVo, SysFileInfoVo.class);
            sysFileInfoVo.setFormId(formId);
            sysFileInfoVoList.add(sysFileInfoVo);
        }
        return sysFileInfoVoList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDashboardImageIds(Long formId) {
        JSONArray components;
        DashboardJsonData dashboardJsonData;
        String imageId = "";
        Wrapper wrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)formId)).eq((Object)"ENTRY_TYPE", (Object)"panel");
        DashEntry dashEntry = (DashEntry)this.dashEntryService.getOne(wrapper);
        if (!HussarUtils.isNotEmpty((Object)dashEntry) || !HussarUtils.isNotEmpty((Object)(dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), DashboardJsonData.class)))) return imageId;
        if (HussarUtils.isNotEmpty((Object)dashboardJsonData.getStyles())) {
            JSONObject jsonObject;
            JSONObject dashboardStyleWidget;
            JSONObject dashboardStyleBackgroud = dashboardJsonData.getStyles().getJSONObject("background");
            if (HussarUtils.isNotEmpty((Object)dashboardStyleBackgroud) && HussarUtils.isNotEmpty((Object)dashboardStyleBackgroud.getString("imageUrl"))) {
                imageId = HussarUtils.isEmpty((Object)imageId) ? dashboardStyleBackgroud.getString("imageUrl") : imageId + "," + dashboardStyleBackgroud.getString("imageUrl");
            }
            if (HussarUtils.isNotEmpty((Object)(dashboardStyleWidget = dashboardJsonData.getStyles().getJSONObject("widget"))) && HussarUtils.isNotEmpty((Object)(jsonObject = dashboardStyleWidget.getJSONObject("background"))) && HussarUtils.isNotEmpty((Object)jsonObject.getString("imageUrl"))) {
                imageId = HussarUtils.isEmpty((Object)imageId) ? jsonObject.getString("imageUrl") : imageId + "," + jsonObject.getString("imageUrl");
            }
        }
        if (!HussarUtils.isNotEmpty((Object)(components = dashboardJsonData.getComponents()))) return imageId;
        for (int i = 0; i < components.size(); ++i) {
            JSONObject jsonObject;
            JSONObject objWidget;
            WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)components.getString(i), WidgetJsonData.class);
            if ("board_image".equals(widgetJsonData.getType())) {
                JSONObject imageContent = widgetJsonData.getImageContent();
                JSONArray imageList = imageContent.getJSONArray("imageList");
                if (!HussarUtils.isNotEmpty((Object)imageList)) continue;
                for (int j = 0; j < imageList.size(); ++j) {
                    JSONObject jsonObject2 = imageList.getJSONObject(j);
                    if (!HussarUtils.isNotEmpty((Object)jsonObject2.getString("id"))) continue;
                    imageId = HussarUtils.isEmpty((Object)imageId) ? jsonObject2.getString("id") : imageId + "," + jsonObject2.getString("id");
                }
                continue;
            }
            JSONObject jsonObjectStyle = widgetJsonData.getStyles();
            if (!HussarUtils.isNotEmpty((Object)jsonObjectStyle) || !HussarUtils.isNotEmpty((Object)(objWidget = jsonObjectStyle.getJSONObject("widget"))) || !HussarUtils.isNotEmpty((Object)(jsonObject = objWidget.getJSONObject("background"))) || !HussarUtils.isNotEmpty((Object)jsonObject.getString("imageUrl"))) continue;
            imageId = HussarUtils.isEmpty((Object)imageId) ? jsonObject.getString("imageUrl") : imageId + "," + jsonObject.getString("imageUrl");
        }
        return imageId;
    }
}

