/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.DataLogicFilterDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicFilterVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitDataLogicFilterServiceImpl")
public class SysAppVisitDataLogicFilterServiceImpl
extends HussarServiceImpl<SysAppVisitDataLogicFilterMapper, SysAppVisitDataLogicFilter>
implements ISysAppVisitDataLogicFilterService {
    @Resource
    private SysAppVisitDataLogicFilterMapper sysAppVisitDataLogicFilterMapper;
    @Resource
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;

    @HussarTransactional
    public void dataLogicFilterSave(List<DataLogicFilterDto> dataLogicFilters, Long id) {
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogicFilter::getRoleDataLogicId, (Object)id));
        if (HussarUtils.isNotEmpty(dataLogicFilters)) {
            for (DataLogicFilterDto dataLogicFilterDto : dataLogicFilters) {
                SysAppVisitDataLogicFilter sysAppVisitDataLogicFilter = new SysAppVisitDataLogicFilter();
                BeanUtil.copy((Object)dataLogicFilterDto, (Object)sysAppVisitDataLogicFilter);
                sysAppVisitDataLogicFilter.setRoleDataLogicId(id);
                sysAppVisitDataLogicFilter.setFilterConditionCode(dataLogicFilterDto.getFilterCode());
                sysAppVisitDataLogicFilter.setFilterConditionName(dataLogicFilterDto.getFilterName());
                this.save((BaseEntity)sysAppVisitDataLogicFilter);
            }
        }
    }

    public List<DataLogicFilterVo> dataLogicFilterList(Long id) {
        return this.sysAppVisitDataLogicFilterMapper.selectDataLogicFilter(id);
    }

    public List<SysAppVisitDataLogicFilter> dataLogicFilterListByLogicIds(List<Long> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysAppVisitDataLogicFilter::getRoleDataLogicId, ids);
        List result = this.list((Wrapper)queryWrapper);
        return result;
    }

    public void dataLogicFilterCancel(Long id) {
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogicFilter::getRoleDataLogicId, (Object)id));
    }

    public ApiResponse<Boolean> deleteLogicFilterByIds(List<String> fieldIds, String formId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper querySysAppVisitDataLogic = new LambdaQueryWrapper();
        querySysAppVisitDataLogic.eq(SysAppVisitDataLogic::getFormId, (Object)Long.valueOf(formId));
        List sysAppVisitDataLogic = this.sysAppVisitDataLogicService.list((Wrapper)querySysAppVisitDataLogic);
        if (HussarUtils.isEmpty((Object)sysAppVisitDataLogic)) {
            return ApiResponse.success((Object)true);
        }
        ArrayList<Long> roleDataLogicId = new ArrayList<Long>();
        for (SysAppVisitDataLogic appVisitDataLogic : sysAppVisitDataLogic) {
            roleDataLogicId.add(appVisitDataLogic.getId());
        }
        ((LambdaQueryWrapper)queryWrapper.in(SysAppVisitDataLogicFilter::getFieldId, fieldIds)).in(SysAppVisitDataLogicFilter::getRoleDataLogicId, roleDataLogicId);
        Boolean result = this.remove((Wrapper)queryWrapper);
        return ApiResponse.success((Object)result);
    }
}

