/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.property.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.formdesign.application.property.dto.ScriptManifest;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptGroupPlatVO;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptGroupVO;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptPreviewVO;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptTreeVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/extend/script"})
public class ScriptController {
    @Resource
    private ScriptRecordService scriptRecordService;

    @GetMapping(value={"/check"})
    public ApiResponse<Integer> check(@RequestParam long fileId, @RequestParam(required=false) String groupId, @RequestParam(required=false) String formId, @RequestParam(required=false) String scriptType) throws IOException {
        return this.scriptRecordService.check(fileId, groupId, formId, scriptType);
    }

    @GetMapping(value={"/import"})
    public ApiResponse<Boolean> scriptImport(@RequestParam long fileId, @RequestParam(required=false) String groupId, @RequestParam(required=false) String formId) throws IOException {
        return this.scriptRecordService.scriptImport(fileId, groupId, formId);
    }

    @PostMapping(value={"/debug"})
    public ApiResponse<List<ScriptBase>> debug(@RequestBody List<ScriptManifest> manifests) throws IOException {
        return this.scriptRecordService.debug(manifests);
    }

    @GetMapping(value={"/list/global/card"})
    public ApiResponse<List<ScriptGroupVO>> listGlobalCard(@RequestParam(required=false) String scriptName) {
        return this.scriptRecordService.listGlobalCard(scriptName);
    }

    @GetMapping(value={"/list/global/page"})
    public ApiResponse<Page<ScriptGroupPlatVO>> listGlobalPage(@RequestParam(required=false) String scriptName, @RequestParam(required=false) String groupId, @RequestParam(required=false, defaultValue="1") int current, @RequestParam(required=false, defaultValue="10") int size) {
        PageInfo pageInfo = new PageInfo((long)current, (long)size);
        return this.scriptRecordService.listGlobalPage(scriptName, groupId, pageInfo);
    }

    @GetMapping(value={"/list/in_form"})
    public ApiResponse<ScriptTreeVO> listInForm(@RequestParam(required=false) String scriptName, @RequestParam String formId) {
        return this.scriptRecordService.listInForm(scriptName, formId);
    }

    @GetMapping(value={"/list/in_form/plat"})
    public ApiResponse<List<ScriptBase>> listInFormPlat(@RequestParam(required=false) String scriptName, @RequestParam String formId) {
        return this.scriptRecordService.listInFormPlat(scriptName, formId);
    }

    @GetMapping(value={"/download/{fileId}"})
    public void scriptDownload(@PathVariable long fileId, HttpServletResponse response) {
        this.scriptRecordService.scriptDownload(fileId, response);
    }

    @PostMapping(value={"/delete/{scriptId}"})
    public ApiResponse<Boolean> scriptDelete(@PathVariable long scriptId) throws IOException {
        return this.scriptRecordService.scriptDelete(scriptId);
    }

    @PostMapping(value={"/relate/add"})
    public ApiResponse<Boolean> relateAdd(@RequestParam String relatedPath, @RequestParam long methodId) {
        return this.scriptRecordService.relateAdd(relatedPath, methodId);
    }

    @GetMapping(value={"/{scriptName}"})
    public ApiResponse<ScriptPreviewVO> script(@PathVariable String scriptName) {
        return this.scriptRecordService.script(scriptName);
    }

    @GetMapping(value={"/showImage"})
    @ApiOperation(value="\u811a\u672c\u56fe\u6807\u5c55\u793a")
    public void showImage(@RequestParam(value="scriptName") String scriptName, @RequestParam(value="fileName") String fileName, HttpServletResponse response) {
        this.scriptRecordService.showImage(scriptName, fileName, response);
    }

    @GetMapping(value={"/logoTemp"})
    @ApiOperation(value="\u5bfc\u5165\u65f6\uff0c\u811a\u672c\u56fe\u6807\u5c55\u793a")
    public void logoTemp(@RequestParam(value="fileId") long fileId, HttpServletResponse response) {
        this.scriptRecordService.logoTemp(fileId, response);
    }
}

