/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.post.dto.PostDto;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dao.ThirdPostMapper;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ThirdPostDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdOrganRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdPostRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdOrganService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdPostService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ThirdPostServiceImpl
extends HussarServiceImpl<ThirdPostMapper, ThirdPostRela>
implements IThirdPostService {
    @Resource
    private IHussarBasePostBoService hussarBasePostService;
    @Resource
    private IThirdPostService thirdPostService;
    @Resource
    private IThirdOrganService thirdOrganService;

    @Override
    public ApiResponse<Void> addPost(ThirdPostDto thirdPostDto) {
        PostDto postDto = new PostDto();
        BeanUtils.copyProperties((Object)((Object)thirdPostDto), (Object)postDto);
        postDto.setOrganIds(this.getOrganIds(thirdPostDto.getThirdOrganIds()));
        postDto.setRoleIds(new ArrayList());
        postDto.setUserIds(new ArrayList());
        Long addPostResult = this.hussarBasePostService.addPost(postDto);
        ThirdPostRela thirdOrganRela = new ThirdPostRela();
        thirdOrganRela.setPostId(addPostResult);
        thirdOrganRela.setThirdPostId(thirdPostDto.getThirdPostId());
        thirdOrganRela.setThirdPostSource("\u5ba2\u6237\u516c\u53f8");
        this.thirdPostService.save((Object)thirdOrganRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editPost(ThirdPostDto thirdPostDto) {
        SysPost sysPost = new SysPost();
        sysPost.setId(this.getPostId(thirdPostDto.getThirdPostId()));
        sysPost.setPostName(thirdPostDto.getPostName());
        sysPost.setPostDesc(thirdPostDto.getPostDesc());
        this.hussarBasePostService.updatePostById(sysPost);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> delPost(ThirdPostRela thirdPostRela) {
        this.hussarBasePostService.deletePostByPostId(this.getPostId(thirdPostRela.getThirdPostId()));
        this.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdPostRela::getThirdPostId, (Object)thirdPostRela.getThirdPostId()));
        return ApiResponse.success();
    }

    private Long getPostId(String thirdPostId) {
        LambdaQueryWrapper thirdPostRelaWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ThirdPostRela::getThirdPostId, (Object)thirdPostId);
        return ((ThirdPostRela)((Object)this.thirdPostService.getOne((Wrapper)thirdPostRelaWrapper))).getPostId();
    }

    private List<Long> getOrganIds(List<String> thirdOrganIds) {
        if (HussarUtils.isEmpty(thirdOrganIds)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper thirdOrganRelaWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(ThirdOrganRela::getThirdOrganId, thirdOrganIds);
        List thirdOrganRelas = this.thirdOrganService.list((Wrapper)thirdOrganRelaWrapper);
        return thirdOrganRelas.stream().map(ThirdOrganRela::getOrganId).collect(Collectors.toList());
    }
}

