/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lefttree.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.TreeViewGridService;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.MatchWidgetVO;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class TreeViewGridServiceImpl
implements TreeViewGridService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private EngineApiService engineApiService;
    private static Logger logger = LoggerFactory.getLogger(TreeViewGridServiceImpl.class);
    private static final String FIELD_SUFFIX = "_ref_id";
    private static final String SIZE_KEY = "size";
    private static final String FORM_ID_KEY = "formId";
    private static final String KEY_WIDGET_NAME = "widgetName";
    private static final String LINK_TABLE_INFO_KEY = "linkTableInfo";
    private static final String LINK_FIELD_INFO_KEY = "linkFieldInfo";
    private static final String RECODE_ID = "RECORD_ID";
    private static final String SUPER_QUERY_CONDITION_KEY = "superQueryConditionDto";
    private static final String MATCH_AND = "AND";
    private static final String RULE_ISNULL = "_isNull";
    private static final String RULE_IN = "_in";
    private static final String METHOD_TABLE_QUERY_ALL = "TableQueryAll";
    private static final String HAS_CHILDREN_KEY = "hasChildren";
    private static final String PARENT_KEY = "parent";
    private static final int MAX_SIZE_EVERY_PAGE = 500;

    public ApiResponse<MatchWidgetVO> checkWidget(String formId) {
        MatchWidgetVO result = new MatchWidgetVO();
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)this.canvasSchemaService.get(formId).getData();
        if (HussarUtils.isEmpty((Object)formCanvasSchema)) {
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)result, (String)"\u8868\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        if (HussarUtils.isEmpty((Object)formCanvasSchema.getWidgets())) {
            result.setMatch(false);
            return ApiResponse.success((Object)result, (String)"\u8868\u5355\u4e2d\u65e0\u6dfb\u52a0\u7ec4\u4ef6");
        }
        List widgets = formCanvasSchema.widgets();
        List links = widgets.stream().filter(x -> HussarUtils.equals((Object)x.getType(), (Object)WidgetType.JXDNLinkForm.getType())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(links)) {
            result.setMatch(false);
            return ApiResponse.success((Object)result, (String)"\u8868\u5355\u4e2d\u6ca1\u6709\u9002\u7b26\u5408\u201c\u6811\u5f62\u8868\u683c\u201d\u89c6\u56fe\u7684\u7ec4\u4ef6");
        }
        for (Widget link : links) {
            JSONObject props = link.getProps();
            JSONObject linkTableInfo = (JSONObject)JSON.parseObject((String)JSONObject.toJSONString((Object)props.get((Object)LINK_TABLE_INFO_KEY)), JSONObject.class);
            JSONObject linkFieldInfo = (JSONObject)JSON.parseObject((String)JSONObject.toJSONString((Object)linkTableInfo.get((Object)LINK_FIELD_INFO_KEY)), JSONObject.class);
            if (!HussarUtils.equals((Object)linkTableInfo.getString(FORM_ID_KEY), (Object)formId) || !HussarUtils.isEmpty((Object)linkFieldInfo.get((Object)PARENT_KEY))) continue;
            result.setMatch(true);
            result.setWidgetName(link.getName());
            break;
        }
        if (HussarUtils.isEmpty((Object)result)) {
            result.setMatch(false);
            return ApiResponse.success((Object)result, (String)"\u8868\u5355\u4e2d\u6ca1\u6709\u7b26\u5408\u201c\u6811\u5f62\u8868\u683c\u201d\u89c6\u56fe\u7684\u7ec4\u4ef6");
        }
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<Object> listFirstNode(String appId, String formId, String viewId, Map<String, Object> params) {
        String widgetName = (String)params.get(KEY_WIDGET_NAME);
        params.remove(KEY_WIDGET_NAME);
        Object superQueryConditionDto = params.get(SUPER_QUERY_CONDITION_KEY);
        List superQueryCondition = HussarUtils.isEmpty((Object)superQueryConditionDto) ? new ArrayList() : JSON.parseArray((String)JSONObject.toJSONString((Object)superQueryConditionDto), Filter.class);
        Filter filter = new Filter();
        filter.setField(widgetName + FIELD_SUFFIX);
        filter.setMatch(MATCH_AND);
        filter.setRule(RULE_ISNULL);
        filter.setVal("");
        superQueryCondition.add(filter);
        params.put(SUPER_QUERY_CONDITION_KEY, superQueryCondition);
        ResponseEntity apiResponseResponseEntity = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
        return this.isHaveNext(appId, formId, (ApiResponse<Object>)((ApiResponse)Objects.requireNonNull(apiResponseResponseEntity.getBody())), widgetName);
    }

    public ApiResponse<Object> loadNext(String appId, String formId, String viewId, Map<String, Object> params) {
        params.put(SIZE_KEY, 500);
        String widgetName = (String)params.get(KEY_WIDGET_NAME);
        ResponseEntity apiResponseResponseEntity = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
        return this.isHaveNext(appId, formId, (ApiResponse<Object>)((ApiResponse)Objects.requireNonNull(apiResponseResponseEntity.getBody())), widgetName);
    }

    private ApiResponse<Object> isHaveNext(String appId, String formId, ApiResponse<Object> result, String widgetName) {
        PageVo pageVo = (PageVo)result.getData();
        if (HussarUtils.isEmpty((Object)pageVo.getData())) {
            return result;
        }
        ArrayList oneData = (ArrayList)pageVo.getData();
        ArrayList<String> ids = new ArrayList<String>();
        for (EngineResultEntity oneDatum : oneData) {
            String recordId = oneDatum.get((Object)RECODE_ID).toString();
            if (!HussarUtils.isNotEmpty((Object)recordId)) continue;
            ids.add(recordId);
        }
        HashMap params = new HashMap();
        ArrayList<Filter> superQueryCondition = new ArrayList<Filter>();
        Filter filter = new Filter();
        filter.setField(widgetName + FIELD_SUFFIX);
        filter.setMatch(MATCH_AND);
        filter.setRule(RULE_IN);
        filter.setVal(ids.stream().collect(Collectors.joining(",")));
        superQueryCondition.add(filter);
        params.put(SUPER_QUERY_CONDITION_KEY, superQueryCondition);
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, METHOD_TABLE_QUERY_ALL);
        ResponseEntity apiResponseResponseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, params);
        Object data = ((ApiResponse)apiResponseResponseEntity.getBody()).getData();
        ArrayList<EngineResultEntity> resultEntities = new ArrayList<EngineResultEntity>();
        if (HussarUtils.isEmpty((Object)data)) {
            for (EngineResultEntity oneDatum : oneData) {
                oneDatum.put((Object)HAS_CHILDREN_KEY, (Object)false);
                resultEntities.add(oneDatum);
            }
            PageVo resultPageVo = new PageVo(resultEntities, pageVo.getCount());
            return ApiResponse.success((Object)resultPageVo);
        }
        PageVo nextData = (PageVo)data;
        if (HussarUtils.isEmpty((Object)nextData.getData())) {
            for (EngineResultEntity oneDatum : oneData) {
                oneDatum.put((Object)HAS_CHILDREN_KEY, (Object)false);
                resultEntities.add(oneDatum);
            }
            PageVo resultPageVo = new PageVo(resultEntities, pageVo.getCount());
            return ApiResponse.success((Object)resultPageVo);
        }
        ArrayList nextDataList = (ArrayList)nextData.getData();
        for (EngineResultEntity oneDatum : oneData) {
            Optional<EngineResultEntity> recordId = nextDataList.stream().filter(x -> HussarUtils.equals((Object)x.get((Object)(widgetName + FIELD_SUFFIX)), (Object)oneDatum.get((Object)RECODE_ID).toString())).findAny();
            oneDatum.put((Object)HAS_CHILDREN_KEY, (Object)recordId.isPresent());
            resultEntities.add(oneDatum);
        }
        PageVo resultPageVo = new PageVo(resultEntities, pageVo.getCount());
        return ApiResponse.success((Object)resultPageVo);
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }
}

