/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.UpgradeFormMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeThreadService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormUpgradeThreadServiceImpl")
public class FormUpgradeThreadServiceImpl
implements IFormUpgradeThreadService {
    @Resource
    private IFormUpgradeInfoService formUpgradeInfoService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private IFormImportThreadService formImportThreadService;
    @Resource
    private IFormImportInfoService importBusinessData;

    @HussarDs(value="#dataSourceKey")
    @Transactional(rollbackFor={Exception.class})
    public void startUpgradeThread(FormUpgradeDto formUpgradeDto, String dataSourceKey) throws Exception {
        UpgradeFormMappingDto upgradeFormMappingDto = new UpgradeFormMappingDto();
        upgradeFormMappingDto.setKeepTableName(true);
        this.formImportThreadService.initFormDataByFormPackage((FormImportDto)formUpgradeDto, (ImportMappingDto)upgradeFormMappingDto);
        IFormUpgradeThreadService formUpgradeThreadService = (IFormUpgradeThreadService)SpringUtil.getBean(IFormUpgradeThreadService.class);
        formUpgradeThreadService.upgradeForm(formUpgradeDto, upgradeFormMappingDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void upgradeForm(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) throws Exception {
        this.formUpgradeInfoService.upgradeFormData(formUpgradeDto, upgradeFormMappingDto);
        if ("2".equals(upgradeFormMappingDto.getCurrentForm().getFormType())) {
            this.formUpgradeInfoService.upgradeDashboardData(formUpgradeDto, upgradeFormMappingDto);
        } else {
            this.formUpgradeInfoService.upgradeMidFile(formUpgradeDto, upgradeFormMappingDto);
            this.formUpgradeInfoService.upgradeExtension(formUpgradeDto, upgradeFormMappingDto);
            if ("1".equals(upgradeFormMappingDto.getCurrentForm().getFormType())) {
                this.formUpgradeInfoService.upgradeFlowBusinessData(formUpgradeDto, upgradeFormMappingDto);
            }
            if (formUpgradeDto.isUpgradeData()) {
                if (5 == formUpgradeDto.getDataOprLogType()) {
                    this.importBusinessData.importBusinessData((FormImportDto)formUpgradeDto, (ImportMappingDto)upgradeFormMappingDto);
                } else {
                    this.formUpgradeInfoService.upgradeBusinessData(formUpgradeDto, upgradeFormMappingDto);
                }
            }
        }
        this.appSyncService.upgradeForm(formUpgradeDto.getId());
    }
}

