/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dto.AppRoleMemberDto;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleRelateVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.authority.dto.AuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.RoleFormAuthorityAndMemberDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.RoleFormAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.service.AuthoritySaveService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.authoritySaveServiceImpl")
public class AuthoritySaveServiceImpl
implements AuthoritySaveService {
    @Autowired
    private ISysAppVisitRoleButtonService roleButtonService;
    @Autowired
    private ISysUpAppVisitRoleFieldService roleFieldService;
    @Autowired
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Autowired
    private ISysAppVisitDataLogicService dataLogicService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private ISysUpAppVisitRoleFieldService sysUpAppVisitRoleFieldService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private AppSyncService appSyncService;

    @HussarTransactional
    public ApiResponse<Boolean> authoritySave(List<AuthorityDto> authorityDtos) {
        if (HussarUtils.isEmpty(authorityDtos)) {
            throw new BaseException("\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (AuthorityDto authorityDto : authorityDtos) {
            if (HussarUtils.isNotEmpty((Object)authorityDto.getButtonAuthoritiesDto())) {
                this.roleButtonService.addButtonAuthorityRoles(authorityDto.getButtonAuthoritiesDto());
            }
            if (HussarUtils.isNotEmpty((Object)authorityDto.getFormRoleFieldAuthoritiesDto()) && !HussarUtils.equals((Object)authorityDto.getFormRoleFieldAuthoritiesDto().getFieldDtos().size(), (Object)0)) {
                this.roleFieldService.saveFieldAuthority(authorityDto.getFormRoleFieldAuthoritiesDto());
            }
            if (HussarUtils.isNotEmpty((Object)authorityDto.getOrganDataAuthorityDto())) {
                this.roleOrganDataAuthorityService.organDataAuthoritySave(authorityDto.getOrganDataAuthorityDto());
            }
            if (!HussarUtils.isNotEmpty((Object)authorityDto.getDataLogicAuthorityDto())) continue;
            this.dataLogicService.dataLogicAuthoritySave(authorityDto.getDataLogicAuthorityDto());
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> saveFormAuthority(List<RoleFormAuthorityAndMemberDto> roleFormAuthorityDtoList) {
        List appRoleMemberList = roleFormAuthorityDtoList.stream().filter(authDto -> authDto.getMemberList() != null).map(authDto -> {
            AppRoleMemberDto appRoleMemberDto = new AppRoleMemberDto();
            appRoleMemberDto.setRoleId(authDto.getRoleId());
            List struIds = authDto.getMemberList().stream().filter(e -> "1".equals(e.getRelateType())).map(AppRoleRelateVo::getId).collect(Collectors.toList());
            appRoleMemberDto.setStruIds(struIds);
            List userIds = authDto.getMemberList().stream().filter(e -> "2".equals(e.getRelateType())).map(AppRoleRelateVo::getId).collect(Collectors.toList());
            appRoleMemberDto.setUserIds(userIds);
            return appRoleMemberDto;
        }).collect(Collectors.toList());
        this.sysRolesExternalService.saveAppRoleInfo(appRoleMemberList);
        return this.authoritySaveBath(roleFormAuthorityDtoList.stream().collect(Collectors.toList()), true);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> authoritySaveBath(List<RoleFormAuthorityDto> roleFormAuthorityDtoList, boolean isForm) {
        if (HussarUtils.isEmpty(roleFormAuthorityDtoList)) {
            return ApiResponse.success((Object)Boolean.TRUE);
        }
        List buttonAuthoritiesDtoList = roleFormAuthorityDtoList.stream().map(AuthorityDto::getButtonAuthoritiesDto).collect(Collectors.toList());
        List formRoleFieldAuthoritiesDtoList = roleFormAuthorityDtoList.stream().map(AuthorityDto::getFormRoleFieldAuthoritiesDto).collect(Collectors.toList());
        List organDataAuthorityDtoList = roleFormAuthorityDtoList.stream().map(AuthorityDto::getOrganDataAuthorityDto).collect(Collectors.toList());
        List dataLogicAuthorityDtoList = roleFormAuthorityDtoList.stream().map(AuthorityDto::getDataLogicAuthorityDto).collect(Collectors.toList());
        this.roleButtonService.saveBatchButtonAuthority(buttonAuthoritiesDtoList, isForm);
        this.sysUpAppVisitRoleFieldService.saveBatchFieldAuthority(formRoleFieldAuthoritiesDtoList, isForm);
        this.roleOrganDataAuthorityService.saveBatchOrganDataAuthority(organDataAuthorityDtoList, isForm);
        this.dataLogicService.saveBatchDataLogicAuthority(dataLogicAuthorityDtoList);
        ((AuthoritySaveServiceImpl)SpringContextUtil.getBean(this.getClass())).formAuthorizeBatch(roleFormAuthorityDtoList, isForm);
        this.appSyncService.syncAuthority(roleFormAuthorityDtoList);
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public void formAuthorizeBatch(List<RoleFormAuthorityDto> roleFormAuthorityDtoList, boolean isForm) {
        Long appId = roleFormAuthorityDtoList.get(0).getAppId();
        Long roleId = roleFormAuthorityDtoList.get(0).getRoleId();
        Long formId = roleFormAuthorityDtoList.get(0).getFormId();
        List authorizeRolesList = this.sysAppVisitFormAuthorizeRolesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId)).eq(!isForm, SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId)).eq(isForm, SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId));
        List authorizedFormIds = null;
        authorizedFormIds = !isForm ? authorizeRolesList.stream().map(SysAppVisitFormAuthorizeRoles::getFormId).collect(Collectors.toList()) : authorizeRolesList.stream().map(SysAppVisitFormAuthorizeRoles::getRoleId).collect(Collectors.toList());
        ArrayList addFormAuthorizeList = new ArrayList();
        ArrayList delFormAuthorizeList = new ArrayList();
        List finalAuthorizedFormIds = authorizedFormIds;
        roleFormAuthorityDtoList.forEach(roleFormAuthorityDto -> {
            Long containId;
            Long l = containId = isForm ? roleFormAuthorityDto.getRoleId() : roleFormAuthorityDto.getFormId();
            if (finalAuthorizedFormIds.contains(containId) && !roleFormAuthorityDto.isAuthorized()) {
                delFormAuthorizeList.add(containId);
            } else if (!finalAuthorizedFormIds.contains(containId) && roleFormAuthorityDto.isAuthorized()) {
                SysAppVisitFormAuthorizeRoles formAuthorizeRoles = new SysAppVisitFormAuthorizeRoles();
                formAuthorizeRoles.setAppId(appId);
                formAuthorizeRoles.setFormId(roleFormAuthorityDto.getFormId());
                formAuthorizeRoles.setRoleId(roleFormAuthorityDto.getRoleId());
                addFormAuthorizeList.add(formAuthorizeRoles);
            }
        });
        if (HussarUtils.isNotEmpty(addFormAuthorizeList)) {
            this.sysAppVisitFormAuthorizeRolesService.saveBatch(addFormAuthorizeList);
        }
        if (HussarUtils.isNotEmpty(delFormAuthorizeList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (isForm) {
                ((LambdaQueryWrapper)queryWrapper.in(SysAppVisitFormAuthorizeRoles::getRoleId, delFormAuthorizeList)).eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId);
            } else {
                ((LambdaQueryWrapper)queryWrapper.in(SysAppVisitFormAuthorizeRoles::getFormId, delFormAuthorizeList)).eq(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId);
            }
            this.sysAppVisitFormAuthorizeRolesService.remove((Wrapper)queryWrapper);
        }
    }
}

