/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicFilterVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FormRoleVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormSecurityLevelService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.core.model.FieldAccess;
import com.jxdinfo.hussar.support.engine.core.service.PlatformApi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.NoCodePlatformApiImpl")
public class NoCodePlatformApiImpl
implements PlatformApi {
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    private ISysAppVisitDataLogicService dataLogicService;
    private ISysUpAppVisitRoleFieldService roleFieldService;
    private ISysFormService formService;
    private IHussarBaseOrganizationBoService organizationBoService;
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    private ISysApplicationBoService applicationBoService;
    private static Logger logger = LoggerFactory.getLogger(NoCodePlatformApiImpl.class);
    @Resource
    private IPermissionService permissionService;
    @Resource
    private FormSecurityLevelService formSecurityLevelService;

    public NoCodePlatformApiImpl(ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService, ISysAppVisitDataLogicService dataLogicService, ISysUpAppVisitRoleFieldService roleFieldService, ISysFormService formService, IHussarBaseOrganizationBoService organizationBoService, ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService, ISysApplicationBoService applicationBoService) {
        this.roleOrganDataAuthorityService = roleOrganDataAuthorityService;
        this.dataLogicService = dataLogicService;
        this.roleFieldService = roleFieldService;
        this.formService = formService;
        this.organizationBoService = organizationBoService;
        this.sysAppVisitFormAuthorizeRolesService = sysAppVisitFormAuthorizeRolesService;
        this.applicationBoService = applicationBoService;
    }

    public List<FieldAccess> getFieldAccess(String businessId, String type) {
        ApiResponse listApiResponse;
        Long formId = this.getLong(businessId);
        if (HussarUtils.isNotEmpty((Object)formId) && (listApiResponse = this.roleFieldService.formAuthorityField(formId)).isSuccess() && !HussarUtils.isEmpty((Object)listApiResponse.getData())) {
            List data = (List)listApiResponse.getData();
            data = data.stream().filter(d -> "0".equals(d.getCanRead())).collect(Collectors.toList());
            return BeanUtil.copyToList(data, FieldAccess.class);
        }
        return new ArrayList<FieldAccess>();
    }

    public List<EngineQueryConditionDto> getDataFilter(String businessId, String type) {
        Long formId = this.getLong(businessId);
        if (formId == null) {
            return new ArrayList<EngineQueryConditionDto>();
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        }
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        List rolesList = user.getRolesList();
        boolean isTenantAdmin = false;
        if (HussarUtils.isNotEmpty((Object)user.getRolesList())) {
            isTenantAdmin = user.getRolesList().contains(TenantConstant.ADMIN_ROLE);
        }
        ArrayList<EngineQueryConditionDto> result = new ArrayList<EngineQueryConditionDto>();
        if (this.formSecurityLevelService.getSecurityLevelSwitch(String.valueOf(formId))) {
            EngineQueryConditionDto securityLevelCondition = new EngineQueryConditionDto();
            securityLevelCondition.setMatch(MatchTypeEnum.AND.getValue());
            securityLevelCondition.setRule(OperatorType.LE.getValue());
            securityLevelCondition.setVal((Object)user.getSecurityLevel());
            securityLevelCondition.setPurposeEnum(PurposeEnum.SECURITY_LEVEL);
            result.add(securityLevelCondition);
        }
        if (HussarUtils.isEmpty((Object)rolesList) || user.isSuperAdmin() || isTenantAdmin) {
            return result;
        }
        SysForm sysForm = (SysForm)this.formService.getById((Serializable)formId);
        AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        Long appId = sysForm.getAppId();
        SysApplication appDetail = this.applicationBoService.selectById(appId);
        AssertUtil.isNotNull((Object)appDetail, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        Long developRoleId = appDetail.getDevelopRoleId();
        if (rolesList.contains(developRoleId)) {
            return result;
        }
        List formRoleVos = this.permissionService.getFormAuthorizeRolesList(formId);
        if (HussarUtils.isEmpty((Object)formRoleVos)) {
            return result;
        }
        List formAuthorizeRoleIds = formRoleVos.stream().map(FormRoleVo::getRoleId).collect(Collectors.toList());
        Collection intersectionRoleIds = CollectionUtils.intersection((Iterable)rolesList, formAuthorizeRoleIds);
        if (HussarUtils.isEmpty((Object)intersectionRoleIds)) {
            return result;
        }
        EngineQueryConditionDto roleDataAuth = this.getAndCondition(new ArrayList<EngineQueryConditionDto>(), MatchTypeEnum.AND);
        for (Long roleId : intersectionRoleIds) {
            ApiResponse listApiResponse2;
            ArrayList<EngineQueryConditionDto> roleConditionResult = new ArrayList<EngineQueryConditionDto>();
            OrganDataAuthorityFeignVo organDataAuthorityFeignVo = this.permissionService.formAuthorityOrganData(formId, roleId);
            if (HussarUtils.isNotEmpty((Object)organDataAuthorityFeignVo)) {
                ArrayList<EngineQueryConditionDto> organDataList = new ArrayList<EngineQueryConditionDto>();
                this.getQueryCondition(organDataAuthorityFeignVo, organDataList);
                if (!organDataList.isEmpty()) {
                    EngineQueryConditionDto andCondition = this.getAndCondition(organDataList, MatchTypeEnum.AND);
                    roleConditionResult.add(andCondition);
                }
            }
            if ((listApiResponse2 = this.dataLogicService.dataLogicAuthorityByFormId(formId, roleId)).isSuccess() && HussarUtils.isNotEmpty((Object)listApiResponse2.getData())) {
                DataLogicAuthorityVo dataLogicAuthorityVo = (DataLogicAuthorityVo)listApiResponse2.getData();
                EngineQueryConditionDto dataLogicAuth = this.getAndCondition(new ArrayList<EngineQueryConditionDto>(), MatchTypeEnum.AND);
                for (DataLogicFilterVo filter : dataLogicAuthorityVo.getFilters()) {
                    OperatorType operatorType = OperatorType.getByName((String)filter.getFilterCode());
                    if (operatorType == null) continue;
                    EngineQueryConditionDto dataFilter = this.newEngineQueryCondition(filter.getFieldId(), operatorType.getValue(), filter.getFilterValue(), "0".equals(dataLogicAuthorityVo.getCombineType()) ? MatchTypeEnum.OR.getValue() : MatchTypeEnum.AND.getValue(), null);
                    dataLogicAuth.getChildren().add(dataFilter);
                }
                if (!dataLogicAuth.getChildren().isEmpty()) {
                    roleConditionResult.add(dataLogicAuth);
                }
            }
            if (HussarUtils.isNotEmpty(roleConditionResult)) {
                EngineQueryConditionDto roleCondition = this.getAndCondition(roleConditionResult, MatchTypeEnum.OR);
                roleDataAuth.getChildren().add(roleCondition);
                continue;
            }
            roleDataAuth.setChildren(new ArrayList());
            break;
        }
        result.add(roleDataAuth);
        return result;
    }

    private EngineQueryConditionDto getAndCondition(List<EngineQueryConditionDto> organData, MatchTypeEnum and) {
        EngineQueryConditionDto parentCondition = new EngineQueryConditionDto();
        parentCondition.setMatch(and.getValue());
        parentCondition.setChildren(organData);
        return parentCondition;
    }

    private EngineQueryConditionDto newEngineQueryCondition(String field, String rule, String filterValue, String matchType, PurposeEnum purposeEnum) {
        EngineQueryConditionDto conditionDto = new EngineQueryConditionDto();
        conditionDto.setField(field);
        conditionDto.setVal((Object)filterValue);
        conditionDto.setRule(rule);
        conditionDto.setMatch(matchType);
        conditionDto.setPurposeEnum(purposeEnum);
        return conditionDto;
    }

    private void getQueryCondition(OrganDataAuthorityFeignVo authorityVo, List<EngineQueryConditionDto> organDataList) {
        if (HussarUtils.isNotEmpty((Object)authorityVo.getUserIds())) {
            organDataList.add(this.newEngineQueryCondition(null, OperatorType.IN.getValue(), HussarUtils.join((Collection)authorityVo.getUserIds()), MatchTypeEnum.OR.getValue(), PurposeEnum.CREATE_USER));
        }
        if (HussarUtils.isNotEmpty((Object)authorityVo.getOrganIds())) {
            organDataList.add(this.newEngineQueryCondition(null, OperatorType.IN.getValue(), HussarUtils.join((Collection)authorityVo.getOrganIds()), MatchTypeEnum.OR.getValue(), PurposeEnum.DATA_ORGAN));
        }
    }

    private Long getLong(String longStr) {
        try {
            return Long.parseLong(longStr);
        }
        catch (Exception var3) {
            return null;
        }
    }

    public String getFormName(String businessId) {
        if (HussarUtils.isBlank((CharSequence)businessId)) {
            return "";
        }
        Long formId = this.getLong(businessId);
        if (formId == null) {
            return "";
        }
        ApiResponse detail = this.formService.getDetailById(formId);
        return detail != null && detail.isSuccess() && detail.getData() != null ? ((SysForm)detail.getData()).getFormName() : "";
    }

    public List<Long> getUnderDept() {
        return this.organizationBoService.getSubOrganByCurrentUser();
    }

    public List<EngineQueryConditionDto> getDataSecurityFilter(String formId) {
        ArrayList<EngineQueryConditionDto> result = new ArrayList<EngineQueryConditionDto>();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            logger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u5bc6\u7ea7");
            return result;
        }
        if (this.formSecurityLevelService.getSecurityLevelSwitch(formId)) {
            EngineQueryConditionDto securityLevelCondition = new EngineQueryConditionDto();
            securityLevelCondition.setMatch(MatchTypeEnum.AND.getValue());
            securityLevelCondition.setRule(OperatorType.LE.getValue());
            securityLevelCondition.setVal((Object)user.getSecurityLevel());
            securityLevelCondition.setPurposeEnum(PurposeEnum.SECURITY_LEVEL);
            result.add(securityLevelCondition);
        }
        return result;
    }
}

