/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DownLoadCompent;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.properties.FormDesignAppProperties;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.migration.enums.EncryptionType;
import com.jxdinfo.hussar.migration.utils.MigrationCryptoUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AppFileExtendServiceImpl
implements AppFileExtendService {
    @Resource
    private HussarFormDesignProperties hussarFormDesignProperties;
    private static Logger logger = LoggerFactory.getLogger(AppFileExtendServiceImpl.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private FormDesignAppProperties properties;
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private DownLoadCompent downLoadCompent;
    private static final EncryptionType encryptionType = EncryptionType.AES;

    public void fileDownload(Long id, HttpServletResponse response) {
        byte[] data = (byte[])this.ossService.backgroundDownload(id).getData();
        AttachmentManagerModelVo managerModelVo = this.ossService.getByFileId(id);
        try (ServletOutputStream os = response.getOutputStream();){
            String newFileName = URLEncoder.encode(managerModelVo.getFileName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("multipart/form-data");
            IOUtils.write((byte[])data, (OutputStream)os);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public Long fileEncrypt(String appName, String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                String oldFormat = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss");
                String fileName = appName + "_" + oldFormat + ".hussar";
                File parentDir = new File(path).getParentFile();
                String zipPath = parentDir.getAbsolutePath() + File.separator + fileName;
                ZipUtil.zip((String)path, (String)zipPath);
                byte[] bytes = FileUtils.readFileToByteArray((File)new File(zipPath));
                byte[] encrypt = MigrationCryptoUtils.encrypt((EncryptionType)encryptionType, (String)this.properties.getEncryptionKey(), (byte[])bytes);
                this.saveEncryptedDataToFile(encrypt, zipPath);
                Long id = this.fileUpload(zipPath);
                File zipFile = new File(zipPath);
                zipFile.delete();
                return id;
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public String fileDecrypt(MultipartFile multipartFile) throws Exception {
        String originFileName = multipartFile.getOriginalFilename();
        int lastFourDigits = (int)(System.currentTimeMillis() % 10000L);
        assert (originFileName != null);
        int lastDotIndex = originFileName.lastIndexOf(".");
        String decryptFileName = originFileName.substring(0, lastDotIndex) + "#" + lastFourDigits + originFileName.substring(lastDotIndex);
        String filePath = com.jxdinfo.hussar.formdesign.common.util.FileUtil.posixPath((String[])new String[]{this.getFileUploadPath(), decryptFileName});
        byte[] bytes = multipartFile.getBytes();
        byte[] decrypt = MigrationCryptoUtils.decrypt((EncryptionType)encryptionType, (String)this.properties.getEncryptionKey(), (byte[])bytes);
        this.saveEncryptedDataToFile(decrypt, filePath);
        com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((File)new File(filePath));
        return filePath;
    }

    public String fileDecrypt(String filePath) throws Exception {
        String tempHussarFilePath = filePath.substring(0, filePath.lastIndexOf(".")) + "_temp.hussar";
        AppMigrateUtil.deleteFile(tempHussarFilePath);
        AppMigrateUtil.deleteFolder(tempHussarFilePath.substring(0, tempHussarFilePath.lastIndexOf(".")));
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(filePath));
        byte[] decrypt = MigrationCryptoUtils.decrypt((EncryptionType)encryptionType, (String)this.properties.getEncryptionKey(), (byte[])bytes);
        this.saveEncryptedDataToFile(decrypt, tempHussarFilePath);
        com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((File)new File(tempHussarFilePath));
        return tempHussarFilePath.substring(0, tempHussarFilePath.lastIndexOf("."));
    }

    public void fileDelete(Long id) {
        Object data = this.ossService.deleteFile(id).getData();
    }

    public Long fileDecryptAndUpload(MultipartFile multipartFile) throws Exception {
        ApiResponse apiResponse = this.ossService.backgroundUpload(multipartFile);
        return (Long)apiResponse.getData();
    }

    public String downloadAndUnzip(Long fileId) throws IOException {
        String localPath = this.downLoadCompent.copyOssFile(fileId);
        File file = new File(localPath);
        MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
        byte[] bytes = mockMultipartFile.getBytes();
        byte[] decrypt = MigrationCryptoUtils.decrypt((EncryptionType)encryptionType, (String)this.properties.getEncryptionKey(), (byte[])bytes);
        this.saveEncryptedDataToFile(decrypt, localPath);
        com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((File)new File(localPath));
        return localPath;
    }

    private void saveEncryptedDataToFile(byte[] encryptedData, String exportPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(exportPath);){
            fos.write(encryptedData);
            fos.flush();
        }
    }

    public String getFileUploadPath() {
        File file;
        String fileUploadPath = "";
        boolean fileDateSplit = true;
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os != null && os.toLowerCase().contains("linux")) {
            fileUploadPath = this.hussarFormDesignProperties.getWorkspace();
        } else if (os != null && os.toLowerCase().contains("windows")) {
            fileUploadPath = "";
        } else if (os != null && os.toLowerCase().contains("mac")) {
            fileUploadPath = "";
        }
        if (HussarUtils.isEmpty((Object)fileUploadPath)) {
            fileUploadPath = FileUtil.getTempDirPath();
        }
        if (fileDateSplit) {
            String datePath = new SimpleDateFormat("yyyy/MM/dd").format(new Date()).replace("/", File.separator);
            fileUploadPath = fileUploadPath + File.separator + datePath;
        }
        if (!fileUploadPath.endsWith(File.separator)) {
            fileUploadPath = fileUploadPath + File.separator;
        }
        if (!(file = new File(fileUploadPath)).exists()) {
            file.mkdirs();
        }
        return fileUploadPath;
    }

    public String fileDecryptUp(String filePath) throws IOException {
        String tempHussarFilePath = filePath.substring(0, filePath.lastIndexOf(".")) + ".hussar";
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(filePath));
        byte[] decrypt = MigrationCryptoUtils.decrypt((EncryptionType)encryptionType, (String)this.properties.getEncryptionKey(), (byte[])bytes);
        this.saveEncryptedDataToFile(decrypt, tempHussarFilePath);
        com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((File)new File(tempHussarFilePath));
        return tempHussarFilePath.substring(0, tempHussarFilePath.lastIndexOf("."));
    }
}

