/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormSysFieldEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.dto.TableColumnsDto;
import com.jxdinfo.hussar.formdesign.application.tableinfo.dto.TableNameQueryDto;
import com.jxdinfo.hussar.formdesign.application.tableinfo.model.SysUserTableName;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.FormTableInfoService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.application.util.DatabaseTypeConverter;
import com.jxdinfo.hussar.formdesign.application.util.DatabaseTypewidget;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.service.DatasourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl.FormTableInfoServiceImpl")
public class FormTableInfoServiceImpl
implements FormTableInfoService {
    private final Logger LOGGER = LoggerFactory.getLogger(FormTableInfoServiceImpl.class);
    @Autowired
    private DatasourceDataService dataSourceDataService;
    @Autowired
    private ISysFormService formService;
    @Autowired
    private ISysUserTableNameService sysUserTableNameService;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    public ApiResponse<Boolean> flushed() throws IOException, LcdpException {
        Boolean flushing = (Boolean)HussarCacheUtil.get((String)"sys_user_table_name_flushed", (Object)"flushed_key");
        if (HussarUtils.isNotEmpty((Object)flushing) && flushing.booleanValue()) {
            return ApiResponse.success((Object)false);
        }
        HussarCacheUtil.put((String)"sys_user_table_name_flushed", (Object)"flushed_key", (Object)true, (long)600L);
        try {
            this.sysUserTableNameService.flushed();
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HussarCacheUtil.evict((String)"sys_user_table_name_flushed", (Object)"flushed_key");
        }
        return ApiResponse.success((Object)true);
    }

    @Override
    public Page<SysUserTableName> getTableInfoList(TableNameQueryDto queryDto) throws IOException, LcdpException {
        this.sysUserTableNameService.clearCreated();
        return this.sysUserTableNameService.selectByPage(queryDto.getPage(), queryDto.getTableNameLike());
    }

    @Override
    public List<TableInfo> getTables(List<String> tableNames) throws IOException, LcdpException {
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasource = sysDataSourceService.getByConnName(NoCodeBusinessDB.getNocodeBusinessDB());
        ArrayList tableNamesContainUpper = Lists.newArrayListWithCapacity((int)5);
        tableNamesContainUpper.addAll(tableNames);
        for (String s : tableNames) {
            tableNamesContainUpper.add(s.toUpperCase());
        }
        List tableInfoList = this.dataSourceDataService.filterTables(datasource.getId(), "BASE TABLE", (List)tableNamesContainUpper);
        Set<String> fieldNameUppers = FormSysFieldEnum.getFieldNameUppers();
        for (TableInfo tableInfo : tableInfoList) {
            List fields = tableInfo.getFields();
            if (HussarUtils.isNotEmpty((Object)fields)) {
                fields.removeIf(field -> fieldNameUppers.contains(field.getName().toUpperCase()) || HussarUtils.equals((Object)tableInfo.getName().toUpperCase(), (Object)field.getName().toUpperCase()));
            }
            for (TableField field2 : fields) {
                String widgetType = DatabaseTypewidget.convertWidgetType((String)field2.getType());
                field2.setWidgetType(widgetType);
            }
        }
        return tableInfoList;
    }

    @Override
    public ApiResponse<String> checkTableNames(List<String> tableNames) {
        ApiResponse<Boolean> check = this.sysUserTableNameService.check(tableNames);
        if (!check.isSuccess()) {
            return ApiResponse.fail((String)check.getMsg());
        }
        String key = this.sysUserTableNameService.put(tableNames);
        return ApiResponse.success((Object)key, (String)"");
    }

    @Override
    public ApiResponse<Map<String, List<TableColumnsDto>>> getNoSyncColumns(Long formId) throws Exception {
        HashMap<String, List<TableColumnsDto>> unSyncTableColumnsMap = new HashMap<String, List<TableColumnsDto>>(3);
        SysForm form = (SysForm)this.formService.getDetailById(formId).getData();
        if (HussarUtils.isEmpty((Object)form)) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u8868\u5355");
        }
        String tableName = form.getTableName();
        FormCanvasSchema canvas = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(formId)).getData();
        if (HussarUtils.isEmpty((Object)canvas)) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u753b\u5e03");
        }
        List widgets = canvas.widgetsContainChildren();
        this.getUnSyncColumns(tableName, unSyncTableColumnsMap, widgets);
        return ApiResponse.success(unSyncTableColumnsMap);
    }

    private void getUnSyncColumns(String tableName, Map<String, List<TableColumnsDto>> unSyncTableColumnsMap, List<Widget> widgets) throws IOException, LcdpException {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(tableName.toUpperCase());
        tableNames.add(tableName.toLowerCase());
        List<TableInfo> tableInfos = this.getTables(tableNames);
        List tableFields = tableInfos.get(0).getFields();
        List existingColumns = WidgetTool.getAllFieldsByType(widgets);
        ArrayList<TableColumnsDto> unSyncColumns = new ArrayList<TableColumnsDto>();
        for (TableField tableField : tableFields) {
            if (existingColumns.contains(tableField.getName())) continue;
            TableColumnsDto tableColumnsDto = new TableColumnsDto();
            tableColumnsDto.setFieldName(tableField.getName());
            tableColumnsDto.setFieldDesc(tableField.getComment());
            tableColumnsDto.setFieldType(DatabaseTypeConverter.convertDataBaseType((String)tableField.getType()));
            tableColumnsDto.setFieldLength(tableField.getDataLength());
            tableColumnsDto.setAllowNull(!tableField.getDataIsEmpty());
            unSyncColumns.add(tableColumnsDto);
        }
        unSyncTableColumnsMap.put(tableName, unSyncColumns);
        List childWidget = widgets.stream().filter(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).collect(Collectors.toList());
        for (Widget subWidget : childWidget) {
            if (!HussarUtils.isNotEmpty((Object)subWidget.getChildren())) continue;
            String subTableName = subWidget.getName();
            this.getUnSyncColumns(subTableName, unSyncTableColumnsMap, subWidget.getChildren());
        }
    }
}

